// @bun
var __create = Object.create;
var __getProtoOf = Object.getPrototypeOf;
var __defProp = Object.defineProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __toESM = (mod, isNodeMode, target) => {
  target = mod != null ? __create(__getProtoOf(mod)) : {};
  const to = isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target;
  for (let key of __getOwnPropNames(mod))
    if (!__hasOwnProp.call(to, key))
      __defProp(to, key, {
        get: () => mod[key],
        enumerable: true
      });
  return to;
};
var __moduleCache = /* @__PURE__ */ new WeakMap;
var __toCommonJS = (from) => {
  var entry = __moduleCache.get(from), desc;
  if (entry)
    return entry;
  entry = __defProp({}, "__esModule", { value: true });
  if (from && typeof from === "object" || typeof from === "function")
    __getOwnPropNames(from).map((key) => !__hasOwnProp.call(entry, key) && __defProp(entry, key, {
      get: () => from[key],
      enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
    }));
  __moduleCache.set(from, entry);
  return entry;
};
var __commonJS = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports);
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {
      get: all[name],
      enumerable: true,
      configurable: true,
      set: (newValue) => all[name] = () => newValue
    });
};
var __esm = (fn, res) => () => (fn && (res = fn(fn = 0)), res);
var __promiseAll = (args) => Promise.all(args);
var __require = import.meta.require;

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/event.ts
class ElectrobunEvent {
  name;
  data;
  _response;
  responseWasSet = false;
  constructor(name, data) {
    this.name = name;
    this.data = data;
  }
  get response() {
    return this._response;
  }
  set response(value) {
    this._response = value;
    this.responseWasSet = true;
  }
  clearResponse() {
    this._response = undefined;
    this.responseWasSet = false;
  }
}

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/windowEvents.ts
var windowEvents_default;
var init_windowEvents = __esm(() => {
  windowEvents_default = {
    close: (data) => new ElectrobunEvent("close", data),
    resize: (data) => new ElectrobunEvent("resize", data),
    move: (data) => new ElectrobunEvent("move", data),
    focus: (data) => new ElectrobunEvent("focus", data)
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/webviewEvents.ts
var webviewEvents_default;
var init_webviewEvents = __esm(() => {
  webviewEvents_default = {
    willNavigate: (data) => new ElectrobunEvent("will-navigate", data),
    didNavigate: (data) => new ElectrobunEvent("did-navigate", data),
    didNavigateInPage: (data) => new ElectrobunEvent("did-navigate-in-page", data),
    didCommitNavigation: (data) => new ElectrobunEvent("did-commit-navigation", data),
    domReady: (data) => new ElectrobunEvent("dom-ready", data),
    newWindowOpen: (data) => new ElectrobunEvent("new-window-open", data),
    hostMessage: (data) => new ElectrobunEvent("host-message", data),
    downloadStarted: (data) => new ElectrobunEvent("download-started", data),
    downloadProgress: (data) => new ElectrobunEvent("download-progress", data),
    downloadCompleted: (data) => new ElectrobunEvent("download-completed", data),
    downloadFailed: (data) => new ElectrobunEvent("download-failed", data)
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/trayEvents.ts
var trayEvents_default;
var init_trayEvents = __esm(() => {
  trayEvents_default = {
    trayClicked: (data) => new ElectrobunEvent("tray-clicked", data)
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/ApplicationEvents.ts
var ApplicationEvents_default;
var init_ApplicationEvents = __esm(() => {
  ApplicationEvents_default = {
    applicationMenuClicked: (data) => new ElectrobunEvent("application-menu-clicked", data),
    contextMenuClicked: (data) => new ElectrobunEvent("context-menu-clicked", data),
    openUrl: (data) => new ElectrobunEvent("open-url", data),
    beforeQuit: (data) => new ElectrobunEvent("before-quit", data)
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/events/eventEmitter.ts
import EventEmitter from "events";
var ElectrobunEventEmitter, electrobunEventEmitter, eventEmitter_default;
var init_eventEmitter = __esm(() => {
  init_windowEvents();
  init_webviewEvents();
  init_trayEvents();
  init_ApplicationEvents();
  ElectrobunEventEmitter = class ElectrobunEventEmitter extends EventEmitter {
    constructor() {
      super();
    }
    emitEvent(ElectrobunEvent2, specifier) {
      if (specifier) {
        this.emit(`${ElectrobunEvent2.name}-${specifier}`, ElectrobunEvent2);
      } else {
        this.emit(ElectrobunEvent2.name, ElectrobunEvent2);
      }
    }
    events = {
      window: {
        ...windowEvents_default
      },
      webview: {
        ...webviewEvents_default
      },
      tray: {
        ...trayEvents_default
      },
      app: {
        ...ApplicationEvents_default
      }
    };
  };
  electrobunEventEmitter = new ElectrobunEventEmitter;
  eventEmitter_default = electrobunEventEmitter;
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/shared/rpc.ts
function missingTransportMethodError(methods, action) {
  const methodsString = methods.map((m) => `"${m}"`).join(", ");
  return new Error(`This RPC instance cannot ${action} because the transport did not provide one or more of these methods: ${methodsString}`);
}
function createRPC(options = {}) {
  let debugHooks = {};
  let transport = {};
  let requestHandler = undefined;
  function setTransport(newTransport) {
    if (transport.unregisterHandler)
      transport.unregisterHandler();
    transport = newTransport;
    transport.registerHandler?.(handler);
  }
  function setRequestHandler(h) {
    if (typeof h === "function") {
      requestHandler = h;
      return;
    }
    requestHandler = (method, params) => {
      const handlerFn = h[method];
      if (handlerFn)
        return handlerFn(params);
      const fallbackHandler = h._;
      if (!fallbackHandler)
        throw new Error(`The requested method has no handler: ${String(method)}`);
      return fallbackHandler(method, params);
    };
  }
  const { maxRequestTime = DEFAULT_MAX_REQUEST_TIME } = options;
  if (options.transport)
    setTransport(options.transport);
  if (options.requestHandler)
    setRequestHandler(options.requestHandler);
  if (options._debugHooks)
    debugHooks = options._debugHooks;
  let lastRequestId = 0;
  function getRequestId() {
    if (lastRequestId <= MAX_ID)
      return ++lastRequestId;
    return lastRequestId = 0;
  }
  const requestListeners = new Map;
  const requestTimeouts = new Map;
  function requestFn(method, ...args) {
    const params = args[0];
    return new Promise((resolve, reject) => {
      if (!transport.send)
        throw missingTransportMethodError(["send"], "make requests");
      const requestId = getRequestId();
      const request2 = {
        type: "request",
        id: requestId,
        method,
        params
      };
      requestListeners.set(requestId, { resolve, reject });
      if (maxRequestTime !== Infinity)
        requestTimeouts.set(requestId, setTimeout(() => {
          requestTimeouts.delete(requestId);
          reject(new Error("RPC request timed out."));
        }, maxRequestTime));
      debugHooks.onSend?.(request2);
      transport.send(request2);
    });
  }
  const request = new Proxy(requestFn, {
    get: (target, prop, receiver) => {
      if (prop in target)
        return Reflect.get(target, prop, receiver);
      return (params) => requestFn(prop, params);
    }
  });
  const requestProxy = request;
  function sendFn(message, ...args) {
    const payload = args[0];
    if (!transport.send)
      throw missingTransportMethodError(["send"], "send messages");
    const rpcMessage = {
      type: "message",
      id: message,
      payload
    };
    debugHooks.onSend?.(rpcMessage);
    transport.send(rpcMessage);
  }
  const send = new Proxy(sendFn, {
    get: (target, prop, receiver) => {
      if (prop in target)
        return Reflect.get(target, prop, receiver);
      return (payload) => sendFn(prop, payload);
    }
  });
  const sendProxy = send;
  const messageListeners = new Map;
  const wildcardMessageListeners = new Set;
  function addMessageListener(message, listener) {
    if (!transport.registerHandler)
      throw missingTransportMethodError(["registerHandler"], "register message listeners");
    if (message === "*") {
      wildcardMessageListeners.add(listener);
      return;
    }
    if (!messageListeners.has(message))
      messageListeners.set(message, new Set);
    messageListeners.get(message).add(listener);
  }
  function removeMessageListener(message, listener) {
    if (message === "*") {
      wildcardMessageListeners.delete(listener);
      return;
    }
    messageListeners.get(message)?.delete(listener);
    if (messageListeners.get(message)?.size === 0)
      messageListeners.delete(message);
  }
  async function handler(message) {
    debugHooks.onReceive?.(message);
    if (!("type" in message))
      throw new Error("Message does not contain a type.");
    if (message.type === "request") {
      if (!transport.send || !requestHandler)
        throw missingTransportMethodError(["send", "requestHandler"], "handle requests");
      const { id, method, params } = message;
      let response;
      try {
        response = {
          type: "response",
          id,
          success: true,
          payload: await requestHandler(method, params)
        };
      } catch (error) {
        if (!(error instanceof Error))
          throw error;
        response = {
          type: "response",
          id,
          success: false,
          error: error.message
        };
      }
      debugHooks.onSend?.(response);
      transport.send(response);
      return;
    }
    if (message.type === "response") {
      const timeout = requestTimeouts.get(message.id);
      if (timeout != null)
        clearTimeout(timeout);
      const { resolve, reject } = requestListeners.get(message.id) ?? {};
      if (!message.success)
        reject?.(new Error(message.error));
      else
        resolve?.(message.payload);
      return;
    }
    if (message.type === "message") {
      for (const listener of wildcardMessageListeners)
        listener(message.id, message.payload);
      const listeners = messageListeners.get(message.id);
      if (!listeners)
        return;
      for (const listener of listeners)
        listener(message.payload);
      return;
    }
    throw new Error(`Unexpected RPC message type: ${message.type}`);
  }
  const proxy = { send: sendProxy, request: requestProxy };
  return {
    setTransport,
    setRequestHandler,
    request,
    requestProxy,
    send,
    sendProxy,
    addMessageListener,
    removeMessageListener,
    proxy
  };
}
function defineElectrobunRPC(_side, config) {
  const rpcOptions = {
    maxRequestTime: config.maxRequestTime,
    requestHandler: {
      ...config.handlers.requests,
      ...config.extraRequestHandlers
    },
    transport: {
      registerHandler: () => {}
    }
  };
  const rpc = createRPC(rpcOptions);
  const messageHandlers = config.handlers.messages;
  if (messageHandlers) {
    rpc.addMessageListener("*", (messageName, payload) => {
      const globalHandler = messageHandlers["*"];
      if (globalHandler) {
        globalHandler(messageName, payload);
      }
      const messageHandler = messageHandlers[messageName];
      if (messageHandler) {
        messageHandler(payload);
      }
    });
  }
  return rpc;
}
var MAX_ID = 10000000000, DEFAULT_MAX_REQUEST_TIME = 1000;

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/shared/platform.ts
import { platform, arch } from "os";
var platformName, archName, OS, ARCH;
var init_platform = __esm(() => {
  platformName = platform();
  archName = arch();
  OS = (() => {
    switch (platformName) {
      case "win32":
        return "win";
      case "darwin":
        return "macos";
      case "linux":
        return "linux";
      default:
        throw new Error(`Unsupported platform: ${platformName}`);
    }
  })();
  ARCH = (() => {
    if (OS === "win") {
      return "x64";
    }
    switch (archName) {
      case "arm64":
        return "arm64";
      case "x64":
        return "x64";
      default:
        throw new Error(`Unsupported architecture: ${archName}`);
    }
  })();
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/shared/naming.ts
function sanitizeAppName(appName) {
  return appName.replace(/ /g, "");
}
function getAppFileName(appName, buildEnvironment) {
  const sanitized = sanitizeAppName(appName);
  return buildEnvironment === "stable" ? sanitized : `${sanitized}-${buildEnvironment}`;
}
function getPlatformPrefix(buildEnvironment, os, arch2) {
  return `${buildEnvironment}-${os}-${arch2}`;
}
function getTarballFileName(appFileName, os) {
  return os === "macos" ? `${appFileName}.app.tar.zst` : `${appFileName}.tar.zst`;
}

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/Utils.ts
var exports_Utils = {};
__export(exports_Utils, {
  showNotification: () => showNotification,
  showMessageBox: () => showMessageBox,
  showItemInFolder: () => showItemInFolder,
  quit: () => quit,
  paths: () => paths,
  openPath: () => openPath,
  openFileDialog: () => openFileDialog,
  openExternal: () => openExternal,
  moveToTrash: () => moveToTrash,
  clipboardWriteText: () => clipboardWriteText,
  clipboardWriteImage: () => clipboardWriteImage,
  clipboardReadText: () => clipboardReadText,
  clipboardReadImage: () => clipboardReadImage,
  clipboardClear: () => clipboardClear,
  clipboardAvailableFormats: () => clipboardAvailableFormats
});
import { homedir, tmpdir } from "os";
import { join } from "path";
import { readFileSync } from "fs";
function getLinuxXdgUserDirs() {
  try {
    const content = readFileSync(join(home, ".config", "user-dirs.dirs"), "utf-8");
    const dirs = {};
    for (const line of content.split(`
`)) {
      const trimmed = line.trim();
      if (trimmed.startsWith("#") || !trimmed.includes("="))
        continue;
      const eqIdx = trimmed.indexOf("=");
      const key = trimmed.slice(0, eqIdx);
      let value = trimmed.slice(eqIdx + 1);
      if (value.startsWith('"') && value.endsWith('"')) {
        value = value.slice(1, -1);
      }
      value = value.replace(/\$HOME/g, home);
      dirs[key] = value;
    }
    return dirs;
  } catch {
    return {};
  }
}
function xdgUserDir(key, fallbackName) {
  if (OS !== "linux")
    return "";
  if (!_xdgUserDirs)
    _xdgUserDirs = getLinuxXdgUserDirs();
  return _xdgUserDirs[key] || join(home, fallbackName);
}
function getVersionInfo() {
  if (_versionInfo)
    return _versionInfo;
  try {
    const resourcesDir = "Resources";
    const raw = readFileSync(join("..", resourcesDir, "version.json"), "utf-8");
    const parsed = JSON.parse(raw);
    _versionInfo = { identifier: parsed.identifier, channel: parsed.channel };
    return _versionInfo;
  } catch (error) {
    console.error("Failed to read version.json", error);
    throw error;
  }
}
function getAppDataDir() {
  switch (OS) {
    case "macos":
      return join(home, "Library", "Application Support");
    case "win":
      return process.env["LOCALAPPDATA"] || join(home, "AppData", "Local");
    case "linux":
      return process.env["XDG_DATA_HOME"] || join(home, ".local", "share");
  }
}
function getCacheDir() {
  switch (OS) {
    case "macos":
      return join(home, "Library", "Caches");
    case "win":
      return process.env["LOCALAPPDATA"] || join(home, "AppData", "Local");
    case "linux":
      return process.env["XDG_CACHE_HOME"] || join(home, ".cache");
  }
}
function getLogsDir() {
  switch (OS) {
    case "macos":
      return join(home, "Library", "Logs");
    case "win":
      return process.env["LOCALAPPDATA"] || join(home, "AppData", "Local");
    case "linux":
      return process.env["XDG_STATE_HOME"] || join(home, ".local", "state");
  }
}
function getConfigDir() {
  switch (OS) {
    case "macos":
      return join(home, "Library", "Application Support");
    case "win":
      return process.env["APPDATA"] || join(home, "AppData", "Roaming");
    case "linux":
      return process.env["XDG_CONFIG_HOME"] || join(home, ".config");
  }
}
function getUserDir(macName, winName, xdgKey, fallbackName) {
  switch (OS) {
    case "macos":
      return join(home, macName);
    case "win": {
      const userProfile = process.env["USERPROFILE"] || home;
      return join(userProfile, winName);
    }
    case "linux":
      return xdgUserDir(xdgKey, fallbackName);
  }
}
var moveToTrash = (path) => {
  return ffi.request.moveToTrash({ path });
}, showItemInFolder = (path) => {
  return ffi.request.showItemInFolder({ path });
}, openExternal = (url) => {
  return ffi.request.openExternal({ url });
}, openPath = (path) => {
  return ffi.request.openPath({ path });
}, showNotification = (options) => {
  const { title, body, subtitle, silent } = options;
  ffi.request.showNotification({ title, body, subtitle, silent });
}, isQuitting = false, quit = () => {
  if (isQuitting)
    return;
  isQuitting = true;
  const beforeQuitEvent = electrobunEventEmitter.events.app.beforeQuit({});
  electrobunEventEmitter.emitEvent(beforeQuitEvent);
  if (beforeQuitEvent.responseWasSet && beforeQuitEvent.response?.allow === false) {
    isQuitting = false;
    return;
  }
  native.symbols.stopEventLoop();
  native.symbols.waitForShutdownComplete(5000);
  native.symbols.forceExit(0);
}, openFileDialog = async (opts = {}) => {
  const optsWithDefault = {
    ...{
      startingFolder: "~/",
      allowedFileTypes: "*",
      canChooseFiles: true,
      canChooseDirectory: true,
      allowsMultipleSelection: true
    },
    ...opts
  };
  const result = await ffi.request.openFileDialog({
    startingFolder: optsWithDefault.startingFolder,
    allowedFileTypes: optsWithDefault.allowedFileTypes,
    canChooseFiles: optsWithDefault.canChooseFiles,
    canChooseDirectory: optsWithDefault.canChooseDirectory,
    allowsMultipleSelection: optsWithDefault.allowsMultipleSelection
  });
  const filePaths = result.split(",");
  return filePaths;
}, showMessageBox = async (opts = {}) => {
  const {
    type = "info",
    title = "",
    message = "",
    detail = "",
    buttons = ["OK"],
    defaultId = 0,
    cancelId = -1
  } = opts;
  const response = ffi.request.showMessageBox({
    type,
    title,
    message,
    detail,
    buttons,
    defaultId,
    cancelId
  });
  return { response };
}, clipboardReadText = () => {
  return ffi.request.clipboardReadText();
}, clipboardWriteText = (text) => {
  ffi.request.clipboardWriteText({ text });
}, clipboardReadImage = () => {
  return ffi.request.clipboardReadImage();
}, clipboardWriteImage = (pngData) => {
  ffi.request.clipboardWriteImage({ pngData });
}, clipboardClear = () => {
  ffi.request.clipboardClear();
}, clipboardAvailableFormats = () => {
  return ffi.request.clipboardAvailableFormats();
}, home, _xdgUserDirs, _versionInfo, paths;
var init_Utils = __esm(async () => {
  init_eventEmitter();
  init_platform();
  await init_native();
  process.exit = (code) => {
    if (isQuitting) {
      native.symbols.forceExit(code ?? 0);
      return;
    }
    quit();
  };
  home = homedir();
  paths = {
    get home() {
      return home;
    },
    get appData() {
      return getAppDataDir();
    },
    get config() {
      return getConfigDir();
    },
    get cache() {
      return getCacheDir();
    },
    get temp() {
      return tmpdir();
    },
    get logs() {
      return getLogsDir();
    },
    get documents() {
      return getUserDir("Documents", "Documents", "XDG_DOCUMENTS_DIR", "Documents");
    },
    get downloads() {
      return getUserDir("Downloads", "Downloads", "XDG_DOWNLOAD_DIR", "Downloads");
    },
    get desktop() {
      return getUserDir("Desktop", "Desktop", "XDG_DESKTOP_DIR", "Desktop");
    },
    get pictures() {
      return getUserDir("Pictures", "Pictures", "XDG_PICTURES_DIR", "Pictures");
    },
    get music() {
      return getUserDir("Music", "Music", "XDG_MUSIC_DIR", "Music");
    },
    get videos() {
      return getUserDir("Movies", "Videos", "XDG_VIDEOS_DIR", "Videos");
    },
    get userData() {
      const { identifier, channel } = getVersionInfo();
      return join(getAppDataDir(), identifier, channel);
    },
    get userCache() {
      const { identifier, channel } = getVersionInfo();
      return join(getCacheDir(), identifier, channel);
    },
    get userLogs() {
      const { identifier, channel } = getVersionInfo();
      return join(getLogsDir(), identifier, channel);
    }
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/Updater.ts
import { join as join2, dirname, resolve } from "path";
import { homedir as homedir2 } from "os";
import {
  renameSync,
  unlinkSync,
  mkdirSync,
  rmdirSync,
  statSync,
  readdirSync
} from "fs";
import { execSync } from "child_process";
function emitStatus(status, message, details) {
  const entry = {
    status,
    message,
    timestamp: Date.now(),
    details
  };
  statusHistory.push(entry);
  if (onStatusChangeCallback) {
    onStatusChangeCallback(entry);
  }
}
function getAppDataDir2() {
  switch (OS) {
    case "macos":
      return join2(homedir2(), "Library", "Application Support");
    case "win":
      return process.env["LOCALAPPDATA"] || join2(homedir2(), "AppData", "Local");
    case "linux":
      return process.env["XDG_DATA_HOME"] || join2(homedir2(), ".local", "share");
    default:
      return join2(homedir2(), ".config");
  }
}
function cleanupExtractionFolder(extractionFolder, keepTarHash) {
  const keepFile = `${keepTarHash}.tar`;
  try {
    const entries = readdirSync(extractionFolder);
    for (const entry of entries) {
      if (entry === keepFile)
        continue;
      const fullPath = join2(extractionFolder, entry);
      try {
        const s = statSync(fullPath);
        if (s.isDirectory()) {
          rmdirSync(fullPath, { recursive: true });
        } else {
          unlinkSync(fullPath);
        }
      } catch (e) {}
    }
  } catch (e) {}
}
var statusHistory, onStatusChangeCallback = null, localInfo, updateInfo, Updater;
var init_Updater = __esm(async () => {
  init_platform();
  await init_Utils();
  statusHistory = [];
  Updater = {
    updateInfo: () => {
      return updateInfo;
    },
    getStatusHistory: () => {
      return [...statusHistory];
    },
    clearStatusHistory: () => {
      statusHistory.length = 0;
    },
    onStatusChange: (callback) => {
      onStatusChangeCallback = callback;
    },
    checkForUpdate: async () => {
      emitStatus("checking", "Checking for updates...");
      const localInfo2 = await Updater.getLocallocalInfo();
      if (localInfo2.channel === "dev") {
        emitStatus("no-update", "Dev channel - updates disabled", {
          currentHash: localInfo2.hash
        });
        return {
          version: localInfo2.version,
          hash: localInfo2.hash,
          updateAvailable: false,
          updateReady: false,
          error: ""
        };
      }
      const cacheBuster = Math.random().toString(36).substring(7);
      const platformPrefix = getPlatformPrefix(localInfo2.channel, OS, ARCH);
      const updateInfoUrl = `${localInfo2.baseUrl.replace(/\/+$/, "")}/${platformPrefix}-update.json?${cacheBuster}`;
      try {
        const updateInfoResponse = await fetch(updateInfoUrl);
        if (updateInfoResponse.ok) {
          const responseText = await updateInfoResponse.text();
          try {
            updateInfo = JSON.parse(responseText);
          } catch {
            emitStatus("error", "Invalid update.json: failed to parse JSON", {
              url: updateInfoUrl
            });
            return {
              version: "",
              hash: "",
              updateAvailable: false,
              updateReady: false,
              error: `Invalid update.json: failed to parse JSON`
            };
          }
          if (!updateInfo.hash) {
            emitStatus("error", "Invalid update.json: missing hash", {
              url: updateInfoUrl
            });
            return {
              version: "",
              hash: "",
              updateAvailable: false,
              updateReady: false,
              error: `Invalid update.json: missing hash`
            };
          }
          if (updateInfo.hash !== localInfo2.hash) {
            updateInfo.updateAvailable = true;
            emitStatus("update-available", `Update available: ${localInfo2.hash.slice(0, 8)} \u2192 ${updateInfo.hash.slice(0, 8)}`, {
              currentHash: localInfo2.hash,
              latestHash: updateInfo.hash
            });
          } else {
            emitStatus("no-update", "Already on latest version", {
              currentHash: localInfo2.hash
            });
          }
        } else {
          emitStatus("error", `Failed to fetch update info (HTTP ${updateInfoResponse.status})`, { url: updateInfoUrl });
          return {
            version: "",
            hash: "",
            updateAvailable: false,
            updateReady: false,
            error: `Failed to fetch update info from ${updateInfoUrl}`
          };
        }
      } catch (error) {
        return {
          version: "",
          hash: "",
          updateAvailable: false,
          updateReady: false,
          error: `Failed to fetch update info from ${updateInfoUrl}`
        };
      }
      return updateInfo;
    },
    downloadUpdate: async () => {
      emitStatus("download-starting", "Starting update download...");
      const appDataFolder = await Updater.appDataFolder();
      await Updater.channelBucketUrl();
      const appFileName = localInfo.name;
      let currentHash = (await Updater.getLocallocalInfo()).hash;
      let latestHash = (await Updater.checkForUpdate()).hash;
      const extractionFolder = join2(appDataFolder, "self-extraction");
      if (!await Bun.file(extractionFolder).exists()) {
        mkdirSync(extractionFolder, { recursive: true });
      }
      let currentTarPath = join2(extractionFolder, `${currentHash}.tar`);
      const latestTarPath = join2(extractionFolder, `${latestHash}.tar`);
      const seenHashes = [];
      let patchesApplied = 0;
      let usedPatchPath = false;
      if (!await Bun.file(latestTarPath).exists()) {
        emitStatus("checking-local-tar", `Checking for local tar file: ${currentHash.slice(0, 8)}`, { currentHash });
        while (currentHash !== latestHash) {
          seenHashes.push(currentHash);
          const currentTar = Bun.file(currentTarPath);
          if (!await currentTar.exists()) {
            emitStatus("local-tar-missing", `Local tar not found for ${currentHash.slice(0, 8)}, will download full bundle`, { currentHash });
            break;
          }
          emitStatus("local-tar-found", `Found local tar for ${currentHash.slice(0, 8)}`, { currentHash });
          const platformPrefix = getPlatformPrefix(localInfo.channel, OS, ARCH);
          const patchUrl = `${localInfo.baseUrl.replace(/\/+$/, "")}/${platformPrefix}-${currentHash}.patch`;
          emitStatus("fetching-patch", `Checking for patch: ${currentHash.slice(0, 8)}`, { currentHash, url: patchUrl });
          const patchResponse = await fetch(patchUrl);
          if (!patchResponse.ok) {
            emitStatus("patch-not-found", `No patch available for ${currentHash.slice(0, 8)}, will download full bundle`, { currentHash });
            break;
          }
          emitStatus("patch-found", `Patch found for ${currentHash.slice(0, 8)}`, { currentHash });
          emitStatus("downloading-patch", `Downloading patch for ${currentHash.slice(0, 8)}...`, { currentHash });
          const patchFilePath = join2(appDataFolder, "self-extraction", `${currentHash}.patch`);
          await Bun.write(patchFilePath, await patchResponse.arrayBuffer());
          const tmpPatchedTarFilePath = join2(appDataFolder, "self-extraction", `from-${currentHash}.tar`);
          const bunBinDir = dirname(process.execPath);
          const bspatchBinName = OS === "win" ? "bspatch.exe" : "bspatch";
          const bspatchPath = join2(bunBinDir, bspatchBinName);
          emitStatus("applying-patch", `Applying patch ${patchesApplied + 1} for ${currentHash.slice(0, 8)}...`, {
            currentHash,
            patchNumber: patchesApplied + 1
          });
          if (!statSync(bspatchPath, { throwIfNoEntry: false })) {
            emitStatus("patch-failed", `bspatch binary not found at ${bspatchPath}`, {
              currentHash,
              errorMessage: `bspatch not found: ${bspatchPath}`
            });
            console.error("bspatch not found:", bspatchPath);
            break;
          }
          if (!statSync(currentTarPath, { throwIfNoEntry: false })) {
            emitStatus("patch-failed", `Old tar not found at ${currentTarPath}`, {
              currentHash,
              errorMessage: `old tar not found: ${currentTarPath}`
            });
            console.error("old tar not found:", currentTarPath);
            break;
          }
          if (!statSync(patchFilePath, { throwIfNoEntry: false })) {
            emitStatus("patch-failed", `Patch file not found at ${patchFilePath}`, {
              currentHash,
              errorMessage: `patch not found: ${patchFilePath}`
            });
            console.error("patch file not found:", patchFilePath);
            break;
          }
          try {
            const patchResult = Bun.spawnSync([
              bspatchPath,
              currentTarPath,
              tmpPatchedTarFilePath,
              patchFilePath
            ]);
            if (patchResult.exitCode !== 0 || patchResult.success === false) {
              const stderr = patchResult.stderr ? patchResult.stderr.toString() : "";
              const stdout = patchResult.stdout ? patchResult.stdout.toString() : "";
              if (updateInfo) {
                updateInfo.error = stderr || `bspatch failed with exit code ${patchResult.exitCode}`;
              }
              emitStatus("patch-failed", `Patch application failed: ${stderr || `exit code ${patchResult.exitCode}`}`, {
                currentHash,
                errorMessage: stderr || `exit code ${patchResult.exitCode}`
              });
              console.error("bspatch failed", {
                exitCode: patchResult.exitCode,
                stdout,
                stderr,
                bspatchPath,
                oldTar: currentTarPath,
                newTar: tmpPatchedTarFilePath,
                patch: patchFilePath
              });
              break;
            }
          } catch (error) {
            emitStatus("patch-failed", `Patch threw exception: ${error.message}`, {
              currentHash,
              errorMessage: error.message
            });
            console.error("bspatch threw", error, { bspatchPath });
            break;
          }
          patchesApplied++;
          emitStatus("patch-applied", `Patch ${patchesApplied} applied successfully`, {
            currentHash,
            patchNumber: patchesApplied
          });
          emitStatus("extracting-version", "Extracting version info from patched tar...", { currentHash });
          let hashFilePath = "";
          const resourcesDir = "Resources";
          const patchedTarBytes = await Bun.file(tmpPatchedTarFilePath).arrayBuffer();
          const patchedArchive = new Bun.Archive(patchedTarBytes);
          const patchedFiles = await patchedArchive.files();
          for (const [filePath] of patchedFiles) {
            if (filePath.endsWith(`${resourcesDir}/version.json`) || filePath.endsWith("metadata.json")) {
              hashFilePath = filePath;
              break;
            }
          }
          if (!hashFilePath) {
            emitStatus("error", "Could not find version/metadata file in patched tar", { currentHash });
            console.error("Neither Resources/version.json nor metadata.json found in patched tar:", tmpPatchedTarFilePath);
            break;
          }
          const hashFile = patchedFiles.get(hashFilePath);
          const hashFileJson = JSON.parse(await hashFile.text());
          const nextHash = hashFileJson.hash;
          if (seenHashes.includes(nextHash)) {
            emitStatus("error", "Cyclical update detected, falling back to full download", { currentHash: nextHash });
            console.log("Warning: cyclical update detected");
            break;
          }
          seenHashes.push(nextHash);
          if (!nextHash) {
            emitStatus("error", "Could not determine next hash from patched tar", { currentHash });
            break;
          }
          const updatedTarPath = join2(appDataFolder, "self-extraction", `${nextHash}.tar`);
          renameSync(tmpPatchedTarFilePath, updatedTarPath);
          unlinkSync(currentTarPath);
          unlinkSync(patchFilePath);
          currentHash = nextHash;
          currentTarPath = join2(appDataFolder, "self-extraction", `${currentHash}.tar`);
          emitStatus("patch-applied", `Patched to ${nextHash.slice(0, 8)}, checking for more patches...`, {
            currentHash: nextHash,
            toHash: latestHash,
            totalPatchesApplied: patchesApplied
          });
        }
        if (currentHash === latestHash && patchesApplied > 0) {
          usedPatchPath = true;
          emitStatus("patch-chain-complete", `Patch chain complete! Applied ${patchesApplied} patches`, {
            totalPatchesApplied: patchesApplied,
            currentHash: latestHash,
            usedPatchPath: true
          });
        }
        if (currentHash !== latestHash) {
          emitStatus("downloading-full-bundle", "Downloading full update bundle...", {
            currentHash,
            latestHash,
            usedPatchPath: false
          });
          const cacheBuster = Math.random().toString(36).substring(7);
          const platformPrefix = getPlatformPrefix(localInfo.channel, OS, ARCH);
          const tarballName = getTarballFileName(appFileName, OS);
          const urlToLatestTarball = `${localInfo.baseUrl.replace(/\/+$/, "")}/${platformPrefix}-${tarballName}`;
          const prevVersionCompressedTarballPath = join2(appDataFolder, "self-extraction", "latest.tar.zst");
          emitStatus("download-progress", `Fetching ${tarballName}...`, {
            url: urlToLatestTarball
          });
          const response = await fetch(urlToLatestTarball + `?${cacheBuster}`);
          if (response.ok && response.body) {
            const contentLength = response.headers.get("content-length");
            const totalBytes = contentLength ? parseInt(contentLength, 10) : undefined;
            let bytesDownloaded = 0;
            const reader = response.body.getReader();
            const writer = Bun.file(prevVersionCompressedTarballPath).writer();
            while (true) {
              const { done, value } = await reader.read();
              if (done)
                break;
              await writer.write(value);
              bytesDownloaded += value.length;
              if (bytesDownloaded % 500000 < value.length) {
                emitStatus("download-progress", `Downloading: ${(bytesDownloaded / 1024 / 1024).toFixed(1)} MB`, {
                  bytesDownloaded,
                  totalBytes,
                  progress: totalBytes ? Math.round(bytesDownloaded / totalBytes * 100) : undefined
                });
              }
            }
            await writer.flush();
            writer.end();
            emitStatus("download-progress", `Download complete: ${(bytesDownloaded / 1024 / 1024).toFixed(1)} MB`, {
              bytesDownloaded,
              totalBytes,
              progress: 100
            });
          } else {
            emitStatus("error", `Failed to download: ${urlToLatestTarball}`, {
              url: urlToLatestTarball
            });
            console.log("latest version not found at: ", urlToLatestTarball);
          }
          emitStatus("decompressing", "Decompressing update bundle...");
          const bunBinDir = dirname(process.execPath);
          const zstdBinName = OS === "win" ? "zig-zstd.exe" : "zig-zstd";
          const zstdPath = join2(bunBinDir, zstdBinName);
          if (!statSync(zstdPath, { throwIfNoEntry: false })) {
            updateInfo.error = `zig-zstd not found: ${zstdPath}`;
            emitStatus("error", updateInfo.error, { zstdPath });
            console.error("zig-zstd not found:", zstdPath);
          } else {
            const decompressResult = Bun.spawnSync([
              zstdPath,
              "decompress",
              "-i",
              prevVersionCompressedTarballPath,
              "-o",
              latestTarPath,
              "--no-timing"
            ], {
              cwd: extractionFolder,
              stdout: "inherit",
              stderr: "inherit"
            });
            if (!decompressResult.success) {
              updateInfo.error = `zig-zstd failed with exit code ${decompressResult.exitCode}`;
              emitStatus("error", updateInfo.error, {
                zstdPath,
                exitCode: decompressResult.exitCode
              });
              console.error("zig-zstd failed", {
                exitCode: decompressResult.exitCode,
                zstdPath
              });
            } else {
              emitStatus("decompressing", "Decompression complete");
            }
          }
          unlinkSync(prevVersionCompressedTarballPath);
        }
      }
      if (await Bun.file(latestTarPath).exists()) {
        updateInfo.updateReady = true;
        emitStatus("download-complete", `Update ready to install (used ${usedPatchPath ? "patch" : "full download"} path)`, {
          latestHash,
          usedPatchPath,
          totalPatchesApplied: patchesApplied
        });
      } else {
        updateInfo.error = "Failed to download latest version";
        emitStatus("error", "Failed to download latest version", { latestHash });
      }
      cleanupExtractionFolder(extractionFolder, latestHash);
    },
    applyUpdate: async () => {
      if (updateInfo?.updateReady) {
        emitStatus("applying", "Starting update installation...");
        const appDataFolder = await Updater.appDataFolder();
        const extractionFolder = join2(appDataFolder, "self-extraction");
        if (!await Bun.file(extractionFolder).exists()) {
          mkdirSync(extractionFolder, { recursive: true });
        }
        let latestHash = (await Updater.checkForUpdate()).hash;
        const latestTarPath = join2(extractionFolder, `${latestHash}.tar`);
        let appBundleSubpath = "";
        if (await Bun.file(latestTarPath).exists()) {
          emitStatus("extracting", `Extracting update to ${latestHash.slice(0, 8)}...`, { latestHash });
          const extractionDir = OS === "win" ? join2(extractionFolder, `temp-${latestHash}`) : extractionFolder;
          if (OS === "win") {
            mkdirSync(extractionDir, { recursive: true });
          }
          const latestTarBytes = await Bun.file(latestTarPath).arrayBuffer();
          const latestArchive = new Bun.Archive(latestTarBytes);
          await latestArchive.extract(extractionDir);
          if (OS === "macos") {
            const extractedFiles = readdirSync(extractionDir);
            for (const file of extractedFiles) {
              if (file.endsWith(".app")) {
                appBundleSubpath = file + "/";
                break;
              }
            }
          } else {
            appBundleSubpath = "./";
          }
          console.log(`Tar extraction completed. Found appBundleSubpath: ${appBundleSubpath}`);
          if (!appBundleSubpath) {
            console.error("Failed to find app in tarball");
            return;
          }
          const extractedAppPath = resolve(join2(extractionDir, appBundleSubpath));
          let newAppBundlePath;
          if (OS === "linux") {
            const extractedFiles = readdirSync(extractionDir);
            const appBundleDir = extractedFiles.find((file) => {
              const filePath = join2(extractionDir, file);
              return statSync(filePath).isDirectory() && !file.endsWith(".tar");
            });
            if (!appBundleDir) {
              console.error("Could not find app bundle directory in extraction");
              return;
            }
            newAppBundlePath = join2(extractionDir, appBundleDir);
            const bundleStats = statSync(newAppBundlePath, { throwIfNoEntry: false });
            if (!bundleStats || !bundleStats.isDirectory()) {
              console.error(`App bundle directory not found at: ${newAppBundlePath}`);
              console.log("Contents of extraction directory:");
              try {
                const files = readdirSync(extractionDir);
                for (const file of files) {
                  console.log(`  - ${file}`);
                  const subPath = join2(extractionDir, file);
                  if (statSync(subPath).isDirectory()) {
                    const subFiles = readdirSync(subPath);
                    for (const subFile of subFiles) {
                      console.log(`    - ${subFile}`);
                    }
                  }
                }
              } catch (e) {
                console.log("Could not list directory contents:", e);
              }
              return;
            }
          } else if (OS === "win") {
            const appBundleName = getAppFileName(localInfo.name, localInfo.channel);
            newAppBundlePath = join2(extractionDir, appBundleName);
            if (!statSync(newAppBundlePath, { throwIfNoEntry: false })) {
              console.error(`Extracted app not found at: ${newAppBundlePath}`);
              console.log("Contents of extraction directory:");
              try {
                const files = readdirSync(extractionDir);
                for (const file of files) {
                  console.log(`  - ${file}`);
                }
              } catch (e) {
                console.log("Could not list directory contents:", e);
              }
              return;
            }
          } else {
            newAppBundlePath = extractedAppPath;
          }
          let runningAppBundlePath;
          const appDataFolder2 = await Updater.appDataFolder();
          if (OS === "macos") {
            runningAppBundlePath = resolve(dirname(process.execPath), "..", "..");
          } else if (OS === "linux" || OS === "win") {
            runningAppBundlePath = join2(appDataFolder2, "app");
          } else {
            throw new Error(`Unsupported platform: ${OS}`);
          }
          try {
            emitStatus("replacing-app", "Removing old version...");
            if (OS === "macos") {
              if (statSync(runningAppBundlePath, { throwIfNoEntry: false })) {
                rmdirSync(runningAppBundlePath, { recursive: true });
              }
              emitStatus("replacing-app", "Installing new version...");
              renameSync(newAppBundlePath, runningAppBundlePath);
              try {
                execSync(`xattr -r -d com.apple.quarantine "${runningAppBundlePath}"`, { stdio: "ignore" });
              } catch (e) {}
            } else if (OS === "linux") {
              const appBundleDir = join2(appDataFolder2, "app");
              if (statSync(appBundleDir, { throwIfNoEntry: false })) {
                rmdirSync(appBundleDir, { recursive: true });
              }
              renameSync(newAppBundlePath, appBundleDir);
              const launcherPath = join2(appBundleDir, "bin", "launcher");
              if (statSync(launcherPath, { throwIfNoEntry: false })) {
                execSync(`chmod +x "${launcherPath}"`);
              }
              const bunPath = join2(appBundleDir, "bin", "bun");
              if (statSync(bunPath, { throwIfNoEntry: false })) {
                execSync(`chmod +x "${bunPath}"`);
              }
            }
            if (OS !== "win") {
              cleanupExtractionFolder(extractionFolder, latestHash);
            }
            if (OS === "win") {
              const parentDir = dirname(runningAppBundlePath);
              const updateScriptPath = join2(parentDir, "update.bat");
              const launcherPath = join2(runningAppBundlePath, "bin", "launcher.exe");
              const runningAppWin = runningAppBundlePath.replace(/\//g, "\\");
              const newAppWin = newAppBundlePath.replace(/\//g, "\\");
              const extractionDirWin = extractionDir.replace(/\//g, "\\");
              const launcherPathWin = launcherPath.replace(/\//g, "\\");
              const updateScript = `@echo off
setlocal

:: Wait for the app to fully exit (check if launcher.exe is still running)
:waitloop
tasklist /FI "IMAGENAME eq launcher.exe" 2>NUL | find /I /N "launcher.exe">NUL
if "%ERRORLEVEL%"=="0" (
    timeout /t 1 /nobreak >nul
    goto waitloop
)

:: Small extra delay to ensure all file handles are released
timeout /t 2 /nobreak >nul

:: Remove current app folder
if exist "${runningAppWin}" (
    rmdir /s /q "${runningAppWin}"
)

:: Move new app to current location
move "${newAppWin}" "${runningAppWin}"

:: Clean up extraction directory
rmdir /s /q "${extractionDirWin}" 2>nul

:: Launch the new app
start "" "${launcherPathWin}"

:: Clean up scheduled tasks starting with ElectrobunUpdate_
for /f "tokens=1" %%t in ('schtasks /query /fo list ^| findstr /i "ElectrobunUpdate_"') do (
    schtasks /delete /tn "%%t" /f >nul 2>&1
)

:: Delete this update script after a short delay
ping -n 2 127.0.0.1 >nul
del "%~f0"
`;
              await Bun.write(updateScriptPath, updateScript);
              const scriptPathWin = updateScriptPath.replace(/\//g, "\\");
              const taskName = `ElectrobunUpdate_${Date.now()}`;
              execSync(`schtasks /create /tn "${taskName}" /tr "cmd /c \\"${scriptPathWin}\\"" /sc once /st 00:00 /f`, { stdio: "ignore" });
              execSync(`schtasks /run /tn "${taskName}"`, { stdio: "ignore" });
              quit();
            }
          } catch (error) {
            emitStatus("error", `Failed to replace app: ${error.message}`, {
              errorMessage: error.message
            });
            console.error("Failed to replace app with new version", error);
            return;
          }
          emitStatus("launching-new-version", "Launching updated version...");
          if (OS === "macos") {
            const pid = process.pid;
            Bun.spawn([
              "sh",
              "-c",
              `while kill -0 ${pid} 2>/dev/null; do sleep 0.5; done; sleep 1; open "${runningAppBundlePath}"`
            ], {
              detached: true,
              stdio: ["ignore", "ignore", "ignore"]
            });
          } else if (OS === "linux") {
            const launcherPath = join2(runningAppBundlePath, "bin", "launcher");
            Bun.spawn(["sh", "-c", `"${launcherPath}" &`], {
              detached: true
            });
          }
          emitStatus("complete", "Update complete, restarting application...");
          quit();
        }
      }
    },
    channelBucketUrl: async () => {
      await Updater.getLocallocalInfo();
      return localInfo.baseUrl;
    },
    appDataFolder: async () => {
      await Updater.getLocallocalInfo();
      const appDataFolder = join2(getAppDataDir2(), localInfo.identifier, localInfo.channel);
      return appDataFolder;
    },
    localInfo: {
      version: async () => {
        return (await Updater.getLocallocalInfo()).version;
      },
      hash: async () => {
        return (await Updater.getLocallocalInfo()).hash;
      },
      channel: async () => {
        return (await Updater.getLocallocalInfo()).channel;
      },
      baseUrl: async () => {
        return (await Updater.getLocallocalInfo()).baseUrl;
      }
    },
    getLocallocalInfo: async () => {
      if (localInfo) {
        return localInfo;
      }
      try {
        const resourcesDir = "Resources";
        localInfo = await Bun.file(`../${resourcesDir}/version.json`).json();
        return localInfo;
      } catch (error) {
        console.error("Failed to read version.json", error);
        throw error;
      }
    }
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/BuildConfig.ts
var buildConfig = null, BuildConfig;
var init_BuildConfig = __esm(() => {
  BuildConfig = {
    get: async () => {
      if (buildConfig) {
        return buildConfig;
      }
      try {
        const resourcesDir = "Resources";
        buildConfig = await Bun.file(`../${resourcesDir}/build.json`).json();
        return buildConfig;
      } catch (error) {
        buildConfig = {
          defaultRenderer: "native",
          availableRenderers: ["native"]
        };
        return buildConfig;
      }
    },
    getCached: () => buildConfig
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/Socket.ts
import { createCipheriv, createDecipheriv, randomBytes } from "crypto";
function base64ToUint8Array(base64) {
  {
    return new Uint8Array(atob(base64).split("").map((char) => char.charCodeAt(0)));
  }
}
function encrypt(secretKey, text) {
  const iv = new Uint8Array(randomBytes(12));
  const cipher = createCipheriv("aes-256-gcm", secretKey, iv);
  const encrypted = Buffer.concat([
    new Uint8Array(cipher.update(text, "utf8")),
    new Uint8Array(cipher.final())
  ]).toString("base64");
  const tag = cipher.getAuthTag().toString("base64");
  return { encrypted, iv: Buffer.from(iv).toString("base64"), tag };
}
function decrypt(secretKey, encryptedData, iv, tag) {
  const decipher = createDecipheriv("aes-256-gcm", secretKey, iv);
  decipher.setAuthTag(tag);
  const decrypted = Buffer.concat([
    new Uint8Array(decipher.update(encryptedData)),
    new Uint8Array(decipher.final())
  ]);
  return decrypted.toString("utf8");
}
var socketMap, startRPCServer = () => {
  const startPort = 50000;
  const endPort = 65535;
  const payloadLimit = 1024 * 1024 * 500;
  let port = startPort;
  let server = null;
  while (port <= endPort) {
    try {
      server = Bun.serve({
        port,
        fetch(req, server2) {
          const url = new URL(req.url);
          if (url.pathname === "/socket") {
            const webviewIdString = url.searchParams.get("webviewId");
            if (!webviewIdString) {
              return new Response("Missing webviewId", { status: 400 });
            }
            const webviewId = parseInt(webviewIdString, 10);
            const success = server2.upgrade(req, { data: { webviewId } });
            return success ? undefined : new Response("Upgrade failed", { status: 500 });
          }
          console.log("unhandled RPC Server request", req.url);
        },
        websocket: {
          idleTimeout: 960,
          maxPayloadLength: payloadLimit,
          backpressureLimit: payloadLimit * 2,
          open(ws) {
            if (!ws?.data) {
              return;
            }
            const { webviewId } = ws.data;
            if (!socketMap[webviewId]) {
              socketMap[webviewId] = { socket: ws, queue: [] };
            } else {
              socketMap[webviewId].socket = ws;
            }
          },
          close(ws, _code, _reason) {
            if (!ws?.data) {
              return;
            }
            const { webviewId } = ws.data;
            if (socketMap[webviewId]) {
              socketMap[webviewId].socket = null;
            }
          },
          message(ws, message) {
            if (!ws?.data) {
              return;
            }
            const { webviewId } = ws.data;
            const browserView = BrowserView.getById(webviewId);
            if (!browserView) {
              return;
            }
            if (browserView.rpcHandler) {
              if (typeof message === "string") {
                try {
                  const encryptedPacket = JSON.parse(message);
                  const decrypted = decrypt(browserView.secretKey, base64ToUint8Array(encryptedPacket.encryptedData), base64ToUint8Array(encryptedPacket.iv), base64ToUint8Array(encryptedPacket.tag));
                  browserView.rpcHandler(JSON.parse(decrypted));
                } catch (error) {
                  console.log("Error handling message:", error);
                }
              } else if (message instanceof ArrayBuffer) {
                console.log("TODO: Received ArrayBuffer message:", message);
              }
            }
          }
        }
      });
      break;
    } catch (error) {
      if (error.code === "EADDRINUSE") {
        console.log(`Port ${port} in use, trying next port...`);
        port++;
      } else {
        throw error;
      }
    }
  }
  return { rpcServer: server, rpcPort: port };
}, rpcServer, rpcPort, sendMessageToWebviewViaSocket = (webviewId, message) => {
  const rpc = socketMap[webviewId];
  const browserView = BrowserView.getById(webviewId);
  if (!browserView)
    return false;
  if (rpc?.socket?.readyState === WebSocket.OPEN) {
    try {
      const unencryptedString = JSON.stringify(message);
      const encrypted = encrypt(browserView.secretKey, unencryptedString);
      const encryptedPacket = {
        encryptedData: encrypted.encrypted,
        iv: encrypted.iv,
        tag: encrypted.tag
      };
      const encryptedPacketString = JSON.stringify(encryptedPacket);
      rpc.socket.send(encryptedPacketString);
      return true;
    } catch (error) {
      console.error("Error sending message to webview via socket:", error);
    }
  }
  return false;
};
var init_Socket = __esm(async () => {
  await init_BrowserView();
  socketMap = {};
  ({ rpcServer, rpcPort } = startRPCServer());
  console.log("Server started at", rpcServer?.url.origin);
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/BrowserView.ts
import { randomBytes as randomBytes2 } from "crypto";

class BrowserView {
  id = nextWebviewId++;
  ptr;
  hostWebviewId;
  windowId;
  renderer;
  url = null;
  html = null;
  preload = null;
  partition = null;
  autoResize = true;
  frame = {
    x: 0,
    y: 0,
    width: 800,
    height: 600
  };
  pipePrefix;
  inStream;
  outStream;
  secretKey;
  rpc;
  rpcHandler;
  navigationRules = null;
  sandbox = false;
  startTransparent = false;
  startPassthrough = false;
  constructor(options = defaultOptions) {
    this.url = options.url || defaultOptions.url || null;
    this.html = options.html || defaultOptions.html || null;
    this.preload = options.preload || defaultOptions.preload || null;
    this.frame = {
      x: options.frame?.x ?? defaultOptions.frame.x,
      y: options.frame?.y ?? defaultOptions.frame.y,
      width: options.frame?.width ?? defaultOptions.frame.width,
      height: options.frame?.height ?? defaultOptions.frame.height
    };
    this.rpc = options.rpc;
    this.secretKey = new Uint8Array(randomBytes2(32));
    this.partition = options.partition || null;
    this.pipePrefix = `/private/tmp/electrobun_ipc_pipe_${hash}_${randomId}_${this.id}`;
    this.hostWebviewId = options.hostWebviewId;
    this.windowId = options.windowId ?? 0;
    this.autoResize = options.autoResize === false ? false : true;
    this.navigationRules = options.navigationRules || null;
    this.renderer = options.renderer ?? defaultOptions.renderer ?? "native";
    this.sandbox = options.sandbox ?? false;
    this.startTransparent = options.startTransparent ?? false;
    this.startPassthrough = options.startPassthrough ?? false;
    BrowserViewMap[this.id] = this;
    this.ptr = this.init();
    if (this.html) {
      console.log(`DEBUG: BrowserView constructor triggering loadHTML for webview ${this.id}`);
      setTimeout(() => {
        console.log(`DEBUG: BrowserView delayed loadHTML for webview ${this.id}`);
        this.loadHTML(this.html);
      }, 100);
    } else {
      console.log(`DEBUG: BrowserView constructor - no HTML provided for webview ${this.id}`);
    }
  }
  init() {
    this.createStreams();
    return ffi.request.createWebview({
      id: this.id,
      windowId: this.windowId,
      renderer: this.renderer,
      rpcPort,
      secretKey: this.secretKey.toString(),
      hostWebviewId: this.hostWebviewId || null,
      pipePrefix: this.pipePrefix,
      partition: this.partition,
      url: this.html ? null : this.url,
      html: this.html,
      preload: this.preload,
      frame: {
        width: this.frame.width,
        height: this.frame.height,
        x: this.frame.x,
        y: this.frame.y
      },
      autoResize: this.autoResize,
      navigationRules: this.navigationRules,
      sandbox: this.sandbox,
      startTransparent: this.startTransparent,
      startPassthrough: this.startPassthrough
    });
  }
  createStreams() {
    if (!this.rpc) {
      this.rpc = BrowserView.defineRPC({
        handlers: { requests: {}, messages: {} }
      });
    }
    this.rpc.setTransport(this.createTransport());
  }
  sendMessageToWebviewViaExecute(jsonMessage) {
    const stringifiedMessage = typeof jsonMessage === "string" ? jsonMessage : JSON.stringify(jsonMessage);
    const wrappedMessage = `window.__electrobun.receiveMessageFromBun(${stringifiedMessage})`;
    this.executeJavascript(wrappedMessage);
  }
  sendInternalMessageViaExecute(jsonMessage) {
    const stringifiedMessage = typeof jsonMessage === "string" ? jsonMessage : JSON.stringify(jsonMessage);
    const wrappedMessage = `window.__electrobun.receiveInternalMessageFromBun(${stringifiedMessage})`;
    this.executeJavascript(wrappedMessage);
  }
  executeJavascript(js) {
    ffi.request.evaluateJavascriptWithNoCompletion({ id: this.id, js });
  }
  loadURL(url) {
    console.log(`DEBUG: loadURL called for webview ${this.id}: ${url}`);
    this.url = url;
    native.symbols.loadURLInWebView(this.ptr, toCString(this.url));
  }
  loadHTML(html) {
    this.html = html;
    console.log(`DEBUG: Setting HTML content for webview ${this.id}:`, html.substring(0, 50) + "...");
    if (this.renderer === "cef") {
      native.symbols.setWebviewHTMLContent(this.id, toCString(html));
      this.loadURL("views://internal/index.html");
    } else {
      native.symbols.loadHTMLInWebView(this.ptr, toCString(html));
    }
  }
  setNavigationRules(rules) {
    this.navigationRules = JSON.stringify(rules);
    const rulesJson = JSON.stringify(rules);
    native.symbols.setWebviewNavigationRules(this.ptr, toCString(rulesJson));
  }
  findInPage(searchText, options) {
    const forward = options?.forward ?? true;
    const matchCase = options?.matchCase ?? false;
    native.symbols.webviewFindInPage(this.ptr, toCString(searchText), forward, matchCase);
  }
  stopFindInPage() {
    native.symbols.webviewStopFind(this.ptr);
  }
  openDevTools() {
    native.symbols.webviewOpenDevTools(this.ptr);
  }
  closeDevTools() {
    native.symbols.webviewCloseDevTools(this.ptr);
  }
  toggleDevTools() {
    native.symbols.webviewToggleDevTools(this.ptr);
  }
  on(name, handler) {
    const specificName = `${name}-${this.id}`;
    eventEmitter_default.on(specificName, handler);
  }
  createTransport = () => {
    const that = this;
    return {
      send(message) {
        const sentOverSocket = sendMessageToWebviewViaSocket(that.id, message);
        if (!sentOverSocket) {
          try {
            const messageString = JSON.stringify(message);
            that.sendMessageToWebviewViaExecute(messageString);
          } catch (error) {
            console.error("bun: failed to serialize message to webview", error);
          }
        }
      },
      registerHandler(handler) {
        that.rpcHandler = handler;
      }
    };
  };
  remove() {
    native.symbols.webviewRemove(this.ptr);
    delete BrowserViewMap[this.id];
  }
  static getById(id) {
    return BrowserViewMap[id];
  }
  static getAll() {
    return Object.values(BrowserViewMap);
  }
  static defineRPC(config) {
    return defineElectrobunRPC("bun", config);
  }
}
var BrowserViewMap, nextWebviewId = 1, hash, buildConfig2, defaultOptions, randomId;
var init_BrowserView = __esm(async () => {
  init_eventEmitter();
  init_BuildConfig();
  await __promiseAll([
    init_native(),
    init_Updater(),
    init_Socket()
  ]);
  BrowserViewMap = {};
  hash = await Updater.localInfo.hash();
  buildConfig2 = await BuildConfig.get();
  defaultOptions = {
    url: null,
    html: null,
    preload: null,
    renderer: buildConfig2.defaultRenderer,
    frame: {
      x: 0,
      y: 0,
      width: 800,
      height: 600
    }
  };
  randomId = Math.random().toString(36).substring(7);
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/Paths.ts
var exports_Paths = {};
__export(exports_Paths, {
  VIEWS_FOLDER: () => VIEWS_FOLDER
});
import { resolve as resolve2 } from "path";
var RESOURCES_FOLDER, VIEWS_FOLDER;
var init_Paths = __esm(() => {
  RESOURCES_FOLDER = resolve2("../Resources/");
  VIEWS_FOLDER = resolve2(RESOURCES_FOLDER, "app/views");
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/Tray.ts
import { join as join3 } from "path";

class Tray {
  id = nextTrayId++;
  ptr = null;
  constructor({
    title = "",
    image = "",
    template = true,
    width = 16,
    height = 16
  } = {}) {
    try {
      this.ptr = ffi.request.createTray({
        id: this.id,
        title,
        image: this.resolveImagePath(image),
        template,
        width,
        height
      });
    } catch (error) {
      console.warn("Tray creation failed:", error);
      console.warn("System tray functionality may not be available on this platform");
      this.ptr = null;
    }
    TrayMap[this.id] = this;
  }
  resolveImagePath(imgPath) {
    if (imgPath.startsWith("views://")) {
      return join3(VIEWS_FOLDER, imgPath.replace("views://", ""));
    } else {
      return imgPath;
    }
  }
  setTitle(title) {
    if (!this.ptr)
      return;
    ffi.request.setTrayTitle({ id: this.id, title });
  }
  setImage(imgPath) {
    if (!this.ptr)
      return;
    ffi.request.setTrayImage({
      id: this.id,
      image: this.resolveImagePath(imgPath)
    });
  }
  setMenu(menu) {
    if (!this.ptr)
      return;
    const menuWithDefaults = menuConfigWithDefaults(menu);
    ffi.request.setTrayMenu({
      id: this.id,
      menuConfig: JSON.stringify(menuWithDefaults)
    });
  }
  on(name, handler) {
    const specificName = `${name}-${this.id}`;
    eventEmitter_default.on(specificName, handler);
  }
  remove() {
    console.log("Tray.remove() called for id:", this.id);
    if (this.ptr) {
      ffi.request.removeTray({ id: this.id });
    }
    delete TrayMap[this.id];
    console.log("Tray removed from TrayMap");
  }
  static getById(id) {
    return TrayMap[id];
  }
  static getAll() {
    return Object.values(TrayMap);
  }
  static removeById(id) {
    const tray = TrayMap[id];
    if (tray) {
      tray.remove();
    }
  }
}
var nextTrayId = 1, TrayMap, menuConfigWithDefaults = (menu) => {
  return menu.map((item) => {
    if (item.type === "divider" || item.type === "separator") {
      return { type: "divider" };
    } else {
      const menuItem = item;
      const actionWithDataId = ffi.internal.serializeMenuAction(menuItem.action || "", menuItem.data);
      return {
        label: menuItem.label || "",
        type: menuItem.type || "normal",
        action: actionWithDataId,
        enabled: menuItem.enabled === false ? false : true,
        checked: Boolean(menuItem.checked),
        hidden: Boolean(menuItem.hidden),
        tooltip: menuItem.tooltip || undefined,
        ...menuItem.submenu ? { submenu: menuConfigWithDefaults(menuItem.submenu) } : {}
      };
    }
  });
};
var init_Tray = __esm(async () => {
  init_eventEmitter();
  init_Paths();
  await init_native();
  TrayMap = {};
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/preload/.generated/compiled.ts
var preloadScript = `(() => {
  // src/bun/preload/encryption.ts
  function base64ToUint8Array(base64) {
    return new Uint8Array(atob(base64).split("").map((char) => char.charCodeAt(0)));
  }
  function uint8ArrayToBase64(uint8Array) {
    let binary = "";
    for (let i = 0;i < uint8Array.length; i++) {
      binary += String.fromCharCode(uint8Array[i]);
    }
    return btoa(binary);
  }
  async function generateKeyFromBytes(rawKey) {
    return await window.crypto.subtle.importKey("raw", rawKey, { name: "AES-GCM" }, true, ["encrypt", "decrypt"]);
  }
  async function initEncryption() {
    const secretKey = await generateKeyFromBytes(new Uint8Array(window.__electrobunSecretKeyBytes));
    const encryptString = async (plaintext) => {
      const encoder = new TextEncoder;
      const encodedText = encoder.encode(plaintext);
      const iv = window.crypto.getRandomValues(new Uint8Array(12));
      const encryptedBuffer = await window.crypto.subtle.encrypt({ name: "AES-GCM", iv }, secretKey, encodedText);
      const encryptedData = new Uint8Array(encryptedBuffer.slice(0, -16));
      const tag = new Uint8Array(encryptedBuffer.slice(-16));
      return {
        encryptedData: uint8ArrayToBase64(encryptedData),
        iv: uint8ArrayToBase64(iv),
        tag: uint8ArrayToBase64(tag)
      };
    };
    const decryptString = async (encryptedDataB64, ivB64, tagB64) => {
      const encryptedData = base64ToUint8Array(encryptedDataB64);
      const iv = base64ToUint8Array(ivB64);
      const tag = base64ToUint8Array(tagB64);
      const combinedData = new Uint8Array(encryptedData.length + tag.length);
      combinedData.set(encryptedData);
      combinedData.set(tag, encryptedData.length);
      const decryptedBuffer = await window.crypto.subtle.decrypt({ name: "AES-GCM", iv }, secretKey, combinedData);
      const decoder = new TextDecoder;
      return decoder.decode(decryptedBuffer);
    };
    window.__electrobun_encrypt = encryptString;
    window.__electrobun_decrypt = decryptString;
  }

  // src/bun/preload/internalRpc.ts
  var pendingRequests = {};
  var requestId = 0;
  var isProcessingQueue = false;
  var sendQueue = [];
  function processQueue() {
    if (isProcessingQueue) {
      setTimeout(processQueue);
      return;
    }
    if (sendQueue.length === 0)
      return;
    isProcessingQueue = true;
    const batch = JSON.stringify(sendQueue);
    sendQueue.length = 0;
    window.__electrobunInternalBridge?.postMessage(batch);
    setTimeout(() => {
      isProcessingQueue = false;
    }, 2);
  }
  function send(type, payload) {
    sendQueue.push(JSON.stringify({ type: "message", id: type, payload }));
    processQueue();
  }
  function request(type, payload) {
    return new Promise((resolve, reject) => {
      const id = \`req_\${++requestId}_\${Date.now()}\`;
      pendingRequests[id] = { resolve, reject };
      sendQueue.push(JSON.stringify({
        type: "request",
        method: type,
        id,
        params: payload,
        hostWebviewId: window.__electrobunWebviewId
      }));
      processQueue();
      setTimeout(() => {
        if (pendingRequests[id]) {
          delete pendingRequests[id];
          reject(new Error(\`Request timeout: \${type}\`));
        }
      }, 1e4);
    });
  }
  function handleResponse(msg) {
    if (msg && msg.type === "response" && msg.id) {
      const pending = pendingRequests[msg.id];
      if (pending) {
        delete pendingRequests[msg.id];
        if (msg.success)
          pending.resolve(msg.payload);
        else
          pending.reject(msg.payload);
      }
    }
  }

  // src/bun/preload/dragRegions.ts
  function isAppRegionDrag(e) {
    const target = e.target;
    if (!target || !target.closest)
      return false;
    const draggableByStyle = target.closest('[style*="app-region"][style*="drag"]');
    const draggableByClass = target.closest(".electrobun-webkit-app-region-drag");
    return !!(draggableByStyle || draggableByClass);
  }
  function initDragRegions() {
    document.addEventListener("mousedown", (e) => {
      if (isAppRegionDrag(e)) {
        send("startWindowMove", { id: window.__electrobunWindowId });
      }
    });
    document.addEventListener("mouseup", (e) => {
      if (isAppRegionDrag(e)) {
        send("stopWindowMove", { id: window.__electrobunWindowId });
      }
    });
  }

  // src/bun/preload/webviewTag.ts
  var webviewRegistry = {};

  class ElectrobunWebviewTag extends HTMLElement {
    webviewId = null;
    maskSelectors = new Set;
    lastRect = { x: 0, y: 0, width: 0, height: 0 };
    resizeObserver = null;
    positionCheckLoop = null;
    transparent = false;
    passthroughEnabled = false;
    hidden = false;
    sandboxed = false;
    _eventListeners = {};
    constructor() {
      super();
    }
    connectedCallback() {
      requestAnimationFrame(() => this.initWebview());
    }
    disconnectedCallback() {
      if (this.webviewId !== null) {
        send("webviewTagRemove", { id: this.webviewId });
        delete webviewRegistry[this.webviewId];
      }
      if (this.resizeObserver)
        this.resizeObserver.disconnect();
      if (this.positionCheckLoop)
        clearInterval(this.positionCheckLoop);
    }
    async initWebview() {
      const rect = this.getBoundingClientRect();
      this.lastRect = {
        x: rect.x,
        y: rect.y,
        width: rect.width,
        height: rect.height
      };
      const url = this.getAttribute("src");
      const html = this.getAttribute("html");
      const preload = this.getAttribute("preload");
      const partition = this.getAttribute("partition");
      const renderer = this.getAttribute("renderer") || "native";
      const masks = this.getAttribute("masks");
      const sandbox = this.hasAttribute("sandbox");
      this.sandboxed = sandbox;
      const transparent = this.hasAttribute("transparent");
      const passthrough = this.hasAttribute("passthrough");
      this.transparent = transparent;
      this.passthroughEnabled = passthrough;
      if (transparent)
        this.style.opacity = "0";
      if (passthrough)
        this.style.pointerEvents = "none";
      if (masks) {
        masks.split(",").forEach((s) => this.maskSelectors.add(s.trim()));
      }
      try {
        const webviewId = await request("webviewTagInit", {
          hostWebviewId: window.__electrobunWebviewId,
          windowId: window.__electrobunWindowId,
          renderer,
          url,
          html,
          preload,
          partition,
          frame: {
            width: rect.width,
            height: rect.height,
            x: rect.x,
            y: rect.y
          },
          navigationRules: null,
          sandbox,
          transparent,
          passthrough
        });
        this.webviewId = webviewId;
        this.id = \`electrobun-webview-\${webviewId}\`;
        webviewRegistry[webviewId] = this;
        this.setupObservers();
        this.syncDimensions(true);
        requestAnimationFrame(() => {
          Object.values(webviewRegistry).forEach((webview) => {
            if (webview !== this && webview.webviewId !== null) {
              webview.syncDimensions(true);
            }
          });
        });
      } catch (err) {
        console.error("Failed to init webview:", err);
      }
    }
    setupObservers() {
      this.resizeObserver = new ResizeObserver(() => this.syncDimensions());
      this.resizeObserver.observe(this);
      this.positionCheckLoop = setInterval(() => this.syncDimensions(), 100);
    }
    syncDimensions(force = false) {
      if (this.webviewId === null)
        return;
      const rect = this.getBoundingClientRect();
      const newRect = {
        x: rect.x,
        y: rect.y,
        width: rect.width,
        height: rect.height
      };
      if (newRect.width === 0 && newRect.height === 0) {
        return;
      }
      if (!force && newRect.x === this.lastRect.x && newRect.y === this.lastRect.y && newRect.width === this.lastRect.width && newRect.height === this.lastRect.height) {
        return;
      }
      this.lastRect = newRect;
      const masks = [];
      this.maskSelectors.forEach((selector) => {
        try {
          document.querySelectorAll(selector).forEach((el) => {
            const mr = el.getBoundingClientRect();
            masks.push({
              x: mr.x - rect.x,
              y: mr.y - rect.y,
              width: mr.width,
              height: mr.height
            });
          });
        } catch (_e) {}
      });
      send("webviewTagResize", {
        id: this.webviewId,
        frame: newRect,
        masks: JSON.stringify(masks)
      });
    }
    loadURL(url) {
      if (this.webviewId === null)
        return;
      this.setAttribute("src", url);
      send("webviewTagUpdateSrc", { id: this.webviewId, url });
    }
    loadHTML(html) {
      if (this.webviewId === null)
        return;
      send("webviewTagUpdateHtml", { id: this.webviewId, html });
    }
    reload() {
      if (this.webviewId !== null)
        send("webviewTagReload", { id: this.webviewId });
    }
    goBack() {
      if (this.webviewId !== null)
        send("webviewTagGoBack", { id: this.webviewId });
    }
    goForward() {
      if (this.webviewId !== null)
        send("webviewTagGoForward", { id: this.webviewId });
    }
    async canGoBack() {
      if (this.webviewId === null)
        return false;
      return await request("webviewTagCanGoBack", {
        id: this.webviewId
      });
    }
    async canGoForward() {
      if (this.webviewId === null)
        return false;
      return await request("webviewTagCanGoForward", {
        id: this.webviewId
      });
    }
    toggleTransparent(value) {
      if (this.webviewId === null)
        return;
      this.transparent = value !== undefined ? value : !this.transparent;
      this.style.opacity = this.transparent ? "0" : "";
      send("webviewTagSetTransparent", {
        id: this.webviewId,
        transparent: this.transparent
      });
    }
    togglePassthrough(value) {
      if (this.webviewId === null)
        return;
      this.passthroughEnabled = value !== undefined ? value : !this.passthroughEnabled;
      this.style.pointerEvents = this.passthroughEnabled ? "none" : "";
      send("webviewTagSetPassthrough", {
        id: this.webviewId,
        enablePassthrough: this.passthroughEnabled
      });
    }
    toggleHidden(value) {
      if (this.webviewId === null)
        return;
      this.hidden = value !== undefined ? value : !this.hidden;
      send("webviewTagSetHidden", { id: this.webviewId, hidden: this.hidden });
    }
    addMaskSelector(selector) {
      this.maskSelectors.add(selector);
      this.syncDimensions(true);
    }
    removeMaskSelector(selector) {
      this.maskSelectors.delete(selector);
      this.syncDimensions(true);
    }
    setNavigationRules(rules) {
      if (this.webviewId !== null) {
        send("webviewTagSetNavigationRules", { id: this.webviewId, rules });
      }
    }
    findInPage(searchText, options) {
      if (this.webviewId === null)
        return;
      const forward = options?.forward !== false;
      const matchCase = options?.matchCase || false;
      send("webviewTagFindInPage", {
        id: this.webviewId,
        searchText,
        forward,
        matchCase
      });
    }
    stopFindInPage() {
      if (this.webviewId !== null)
        send("webviewTagStopFind", { id: this.webviewId });
    }
    openDevTools() {
      if (this.webviewId !== null)
        send("webviewTagOpenDevTools", { id: this.webviewId });
    }
    closeDevTools() {
      if (this.webviewId !== null)
        send("webviewTagCloseDevTools", { id: this.webviewId });
    }
    toggleDevTools() {
      if (this.webviewId !== null)
        send("webviewTagToggleDevTools", { id: this.webviewId });
    }
    on(event, listener) {
      if (!this._eventListeners[event])
        this._eventListeners[event] = [];
      this._eventListeners[event].push(listener);
    }
    off(event, listener) {
      if (!this._eventListeners[event])
        return;
      const idx = this._eventListeners[event].indexOf(listener);
      if (idx !== -1)
        this._eventListeners[event].splice(idx, 1);
    }
    emit(event, detail) {
      const listeners = this._eventListeners[event];
      if (listeners) {
        const customEvent = new CustomEvent(event, { detail });
        listeners.forEach((fn) => fn(customEvent));
      }
    }
    get src() {
      return this.getAttribute("src");
    }
    set src(value) {
      if (value) {
        this.setAttribute("src", value);
        if (this.webviewId !== null)
          this.loadURL(value);
      } else {
        this.removeAttribute("src");
      }
    }
    get html() {
      return this.getAttribute("html");
    }
    set html(value) {
      if (value) {
        this.setAttribute("html", value);
        if (this.webviewId !== null)
          this.loadHTML(value);
      } else {
        this.removeAttribute("html");
      }
    }
    get preload() {
      return this.getAttribute("preload");
    }
    set preload(value) {
      if (value)
        this.setAttribute("preload", value);
      else
        this.removeAttribute("preload");
    }
    get renderer() {
      return this.getAttribute("renderer") || "native";
    }
    set renderer(value) {
      this.setAttribute("renderer", value);
    }
    get sandbox() {
      return this.sandboxed;
    }
  }
  function initWebviewTag() {
    if (!customElements.get("electrobun-webview")) {
      customElements.define("electrobun-webview", ElectrobunWebviewTag);
    }
    const injectStyles = () => {
      const style = document.createElement("style");
      style.textContent = \`
electrobun-webview {
	display: block;
	width: 800px;
	height: 300px;
	background: #fff;
	background-repeat: no-repeat !important;
	overflow: hidden;
}
\`;
      if (document.head?.firstChild) {
        document.head.insertBefore(style, document.head.firstChild);
      } else if (document.head) {
        document.head.appendChild(style);
      }
    };
    if (document.head) {
      injectStyles();
    } else {
      document.addEventListener("DOMContentLoaded", injectStyles);
    }
  }

  // src/bun/preload/events.ts
  function emitWebviewEvent(eventName, detail) {
    setTimeout(() => {
      const bridge = window.__electrobunEventBridge || window.__electrobunInternalBridge;
      bridge?.postMessage(JSON.stringify({
        id: "webviewEvent",
        type: "message",
        payload: {
          id: window.__electrobunWebviewId,
          eventName,
          detail
        }
      }));
    });
  }
  function initLifecycleEvents() {
    window.addEventListener("load", () => {
      if (window === window.top) {
        emitWebviewEvent("dom-ready", document.location.href);
      }
    });
    window.addEventListener("popstate", () => {
      emitWebviewEvent("did-navigate-in-page", window.location.href);
    });
    window.addEventListener("hashchange", () => {
      emitWebviewEvent("did-navigate-in-page", window.location.href);
    });
  }
  var cmdKeyHeld = false;
  var cmdKeyTimestamp = 0;
  var CMD_KEY_THRESHOLD_MS = 500;
  function isCmdHeld() {
    if (cmdKeyHeld)
      return true;
    return Date.now() - cmdKeyTimestamp < CMD_KEY_THRESHOLD_MS && cmdKeyTimestamp > 0;
  }
  function initCmdClickHandling() {
    window.addEventListener("keydown", (event) => {
      if (event.key === "Meta" || event.metaKey) {
        cmdKeyHeld = true;
        cmdKeyTimestamp = Date.now();
      }
    }, true);
    window.addEventListener("keyup", (event) => {
      if (event.key === "Meta") {
        cmdKeyHeld = false;
        cmdKeyTimestamp = Date.now();
      }
    }, true);
    window.addEventListener("blur", () => {
      cmdKeyHeld = false;
    });
    window.addEventListener("click", (event) => {
      if (event.metaKey || event.ctrlKey) {
        const anchor = event.target?.closest?.("a");
        if (anchor && anchor.href) {
          event.preventDefault();
          event.stopPropagation();
          event.stopImmediatePropagation();
          emitWebviewEvent("new-window-open", JSON.stringify({
            url: anchor.href,
            isCmdClick: true,
            isSPANavigation: false
          }));
        }
      }
    }, true);
  }
  function initSPANavigationInterception() {
    const originalPushState = history.pushState;
    const originalReplaceState = history.replaceState;
    history.pushState = function(state, title, url) {
      if (isCmdHeld() && url) {
        const resolvedUrl = new URL(String(url), window.location.href).href;
        emitWebviewEvent("new-window-open", JSON.stringify({
          url: resolvedUrl,
          isCmdClick: true,
          isSPANavigation: true
        }));
        return;
      }
      return originalPushState.apply(this, [state, title, url]);
    };
    history.replaceState = function(state, title, url) {
      if (isCmdHeld() && url) {
        const resolvedUrl = new URL(String(url), window.location.href).href;
        emitWebviewEvent("new-window-open", JSON.stringify({
          url: resolvedUrl,
          isCmdClick: true,
          isSPANavigation: true
        }));
        return;
      }
      return originalReplaceState.apply(this, [state, title, url]);
    };
  }
  function initOverscrollPrevention() {
    document.addEventListener("DOMContentLoaded", () => {
      const style = document.createElement("style");
      style.type = "text/css";
      style.appendChild(document.createTextNode("html, body { overscroll-behavior: none; }"));
      document.head.appendChild(style);
    });
  }

  // src/bun/preload/index.ts
  initEncryption().catch((err) => console.error("Failed to initialize encryption:", err));
  var internalMessageHandler = (msg) => {
    handleResponse(msg);
  };
  if (!window.__electrobun) {
    window.__electrobun = {
      receiveInternalMessageFromBun: internalMessageHandler,
      receiveMessageFromBun: (msg) => {
        console.log("receiveMessageFromBun (no handler):", msg);
      }
    };
  } else {
    window.__electrobun.receiveInternalMessageFromBun = internalMessageHandler;
    window.__electrobun.receiveMessageFromBun = (msg) => {
      console.log("receiveMessageFromBun (no handler):", msg);
    };
  }
  window.__electrobunSendToHost = (message) => {
    emitWebviewEvent("host-message", JSON.stringify(message));
  };
  initLifecycleEvents();
  initCmdClickHandling();
  initSPANavigationInterception();
  initOverscrollPrevention();
  initDragRegions();
  initWebviewTag();
})();
`, preloadScriptSandboxed = `(() => {
  // src/bun/preload/events.ts
  function emitWebviewEvent(eventName, detail) {
    setTimeout(() => {
      const bridge = window.__electrobunEventBridge || window.__electrobunInternalBridge;
      bridge?.postMessage(JSON.stringify({
        id: "webviewEvent",
        type: "message",
        payload: {
          id: window.__electrobunWebviewId,
          eventName,
          detail
        }
      }));
    });
  }
  function initLifecycleEvents() {
    window.addEventListener("load", () => {
      if (window === window.top) {
        emitWebviewEvent("dom-ready", document.location.href);
      }
    });
    window.addEventListener("popstate", () => {
      emitWebviewEvent("did-navigate-in-page", window.location.href);
    });
    window.addEventListener("hashchange", () => {
      emitWebviewEvent("did-navigate-in-page", window.location.href);
    });
  }
  var cmdKeyHeld = false;
  var cmdKeyTimestamp = 0;
  var CMD_KEY_THRESHOLD_MS = 500;
  function isCmdHeld() {
    if (cmdKeyHeld)
      return true;
    return Date.now() - cmdKeyTimestamp < CMD_KEY_THRESHOLD_MS && cmdKeyTimestamp > 0;
  }
  function initCmdClickHandling() {
    window.addEventListener("keydown", (event) => {
      if (event.key === "Meta" || event.metaKey) {
        cmdKeyHeld = true;
        cmdKeyTimestamp = Date.now();
      }
    }, true);
    window.addEventListener("keyup", (event) => {
      if (event.key === "Meta") {
        cmdKeyHeld = false;
        cmdKeyTimestamp = Date.now();
      }
    }, true);
    window.addEventListener("blur", () => {
      cmdKeyHeld = false;
    });
    window.addEventListener("click", (event) => {
      if (event.metaKey || event.ctrlKey) {
        const anchor = event.target?.closest?.("a");
        if (anchor && anchor.href) {
          event.preventDefault();
          event.stopPropagation();
          event.stopImmediatePropagation();
          emitWebviewEvent("new-window-open", JSON.stringify({
            url: anchor.href,
            isCmdClick: true,
            isSPANavigation: false
          }));
        }
      }
    }, true);
  }
  function initSPANavigationInterception() {
    const originalPushState = history.pushState;
    const originalReplaceState = history.replaceState;
    history.pushState = function(state, title, url) {
      if (isCmdHeld() && url) {
        const resolvedUrl = new URL(String(url), window.location.href).href;
        emitWebviewEvent("new-window-open", JSON.stringify({
          url: resolvedUrl,
          isCmdClick: true,
          isSPANavigation: true
        }));
        return;
      }
      return originalPushState.apply(this, [state, title, url]);
    };
    history.replaceState = function(state, title, url) {
      if (isCmdHeld() && url) {
        const resolvedUrl = new URL(String(url), window.location.href).href;
        emitWebviewEvent("new-window-open", JSON.stringify({
          url: resolvedUrl,
          isCmdClick: true,
          isSPANavigation: true
        }));
        return;
      }
      return originalReplaceState.apply(this, [state, title, url]);
    };
  }
  function initOverscrollPrevention() {
    document.addEventListener("DOMContentLoaded", () => {
      const style = document.createElement("style");
      style.type = "text/css";
      style.appendChild(document.createTextNode("html, body { overscroll-behavior: none; }"));
      document.head.appendChild(style);
    });
  }

  // src/bun/preload/index-sandboxed.ts
  initLifecycleEvents();
  initCmdClickHandling();
  initSPANavigationInterception();
  initOverscrollPrevention();
})();
`;

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/proc/native.ts
import { join as join4 } from "path";
import {
  dlopen,
  suffix,
  JSCallback,
  CString,
  ptr,
  FFIType,
  toArrayBuffer
} from "bun:ffi";
function storeMenuData(data) {
  const id = `menuData_${++menuDataCounter}`;
  menuDataRegistry.set(id, data);
  return id;
}
function getMenuData(id) {
  return menuDataRegistry.get(id);
}
function clearMenuData(id) {
  menuDataRegistry.delete(id);
}
function serializeMenuAction(action, data) {
  const dataId = storeMenuData(data);
  return `${ELECTROBUN_DELIMITER}${dataId}|${action}`;
}
function deserializeMenuAction(encodedAction) {
  let actualAction = encodedAction;
  let data = undefined;
  if (encodedAction.startsWith(ELECTROBUN_DELIMITER)) {
    const parts = encodedAction.split("|");
    if (parts.length >= 4) {
      const dataId = parts[2];
      actualAction = parts.slice(3).join("|");
      data = getMenuData(dataId);
      clearMenuData(dataId);
    }
  }
  return { action: actualAction, data };
}
function toCString(jsString, addNullTerminator = true) {
  let appendWith = "";
  if (addNullTerminator && !jsString.endsWith("\x00")) {
    appendWith = "\x00";
  }
  const buff = Buffer.from(jsString + appendWith, "utf8");
  return ptr(buff);
}
var menuDataRegistry, menuDataCounter = 0, ELECTROBUN_DELIMITER = "|EB|", native, ffi, windowCloseCallback, windowMoveCallback, windowResizeCallback, windowFocusCallback, getMimeType, getHTMLForWebviewSync, urlOpenCallback, quitRequestedCallback, globalShortcutHandlers, globalShortcutCallback, sessionCache, webviewDecideNavigation, webviewEventHandler = (id, eventName, detail) => {
  const webview = BrowserView.getById(id);
  if (!webview) {
    console.error("[webviewEventHandler] No webview found for id:", id);
    return;
  }
  if (webview.hostWebviewId) {
    const hostWebview = BrowserView.getById(webview.hostWebviewId);
    if (!hostWebview) {
      console.error("[webviewEventHandler] No webview found for id:", id);
      return;
    }
    let js;
    if (eventName === "new-window-open" || eventName === "host-message") {
      js = `document.querySelector('#electrobun-webview-${id}').emit(${JSON.stringify(eventName)}, ${detail});`;
    } else {
      js = `document.querySelector('#electrobun-webview-${id}').emit(${JSON.stringify(eventName)}, ${JSON.stringify(detail)});`;
    }
    native.symbols.evaluateJavaScriptWithNoCompletion(hostWebview.ptr, toCString(js));
  }
  const eventMap = {
    "will-navigate": "willNavigate",
    "did-navigate": "didNavigate",
    "did-navigate-in-page": "didNavigateInPage",
    "did-commit-navigation": "didCommitNavigation",
    "dom-ready": "domReady",
    "new-window-open": "newWindowOpen",
    "host-message": "hostMessage",
    "download-started": "downloadStarted",
    "download-progress": "downloadProgress",
    "download-completed": "downloadCompleted",
    "download-failed": "downloadFailed",
    "load-started": "loadStarted",
    "load-committed": "loadCommitted",
    "load-finished": "loadFinished"
  };
  const mappedName = eventMap[eventName];
  const handler = mappedName ? eventEmitter_default.events.webview[mappedName] : undefined;
  if (!handler) {
    return { success: false };
  }
  let parsedDetail = detail;
  if (eventName === "new-window-open" || eventName === "host-message" || eventName === "download-started" || eventName === "download-progress" || eventName === "download-completed" || eventName === "download-failed") {
    try {
      parsedDetail = JSON.parse(detail);
    } catch (e) {
      console.error("[webviewEventHandler] Failed to parse JSON:", e);
      parsedDetail = detail;
    }
  }
  const event = handler({
    detail: parsedDetail
  });
  eventEmitter_default.emitEvent(event);
  eventEmitter_default.emitEvent(event, id);
}, webviewEventJSCallback, bunBridgePostmessageHandler, eventBridgeHandler, internalBridgeHandler, trayItemHandler, applicationMenuHandler, contextMenuHandler, internalRpcHandlers;
var init_native = __esm(async () => {
  init_eventEmitter();
  await __promiseAll([
    init_BrowserView(),
    init_Tray(),
    init_BrowserWindow()
  ]);
  menuDataRegistry = new Map;
  native = (() => {
    try {
      const nativeWrapperPath = join4(process.cwd(), `libNativeWrapper.${suffix}`);
      return dlopen(nativeWrapperPath, {
        createWindowWithFrameAndStyleFromWorker: {
          args: [
            FFIType.u32,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.u32,
            FFIType.cstring,
            FFIType.bool,
            FFIType.function,
            FFIType.function,
            FFIType.function,
            FFIType.function
          ],
          returns: FFIType.ptr
        },
        setWindowTitle: {
          args: [
            FFIType.ptr,
            FFIType.cstring
          ],
          returns: FFIType.void
        },
        showWindow: {
          args: [
            FFIType.ptr
          ],
          returns: FFIType.void
        },
        closeWindow: {
          args: [
            FFIType.ptr
          ],
          returns: FFIType.void
        },
        minimizeWindow: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        restoreWindow: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        isWindowMinimized: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        maximizeWindow: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        unmaximizeWindow: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        isWindowMaximized: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        setWindowFullScreen: {
          args: [FFIType.ptr, FFIType.bool],
          returns: FFIType.void
        },
        isWindowFullScreen: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        setWindowAlwaysOnTop: {
          args: [FFIType.ptr, FFIType.bool],
          returns: FFIType.void
        },
        isWindowAlwaysOnTop: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        setWindowPosition: {
          args: [FFIType.ptr, FFIType.f64, FFIType.f64],
          returns: FFIType.void
        },
        setWindowSize: {
          args: [FFIType.ptr, FFIType.f64, FFIType.f64],
          returns: FFIType.void
        },
        setWindowFrame: {
          args: [FFIType.ptr, FFIType.f64, FFIType.f64, FFIType.f64, FFIType.f64],
          returns: FFIType.void
        },
        getWindowFrame: {
          args: [FFIType.ptr, FFIType.ptr, FFIType.ptr, FFIType.ptr, FFIType.ptr],
          returns: FFIType.void
        },
        initWebview: {
          args: [
            FFIType.u32,
            FFIType.ptr,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.bool,
            FFIType.cstring,
            FFIType.function,
            FFIType.function,
            FFIType.function,
            FFIType.function,
            FFIType.function,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.bool,
            FFIType.bool
          ],
          returns: FFIType.ptr
        },
        setNextWebviewFlags: {
          args: [
            FFIType.bool,
            FFIType.bool
          ],
          returns: FFIType.void
        },
        webviewCanGoBack: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        webviewCanGoForward: {
          args: [FFIType.ptr],
          returns: FFIType.bool
        },
        resizeWebview: {
          args: [
            FFIType.ptr,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.f64,
            FFIType.cstring
          ],
          returns: FFIType.void
        },
        loadURLInWebView: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        loadHTMLInWebView: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        updatePreloadScriptToWebView: {
          args: [
            FFIType.ptr,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.bool
          ],
          returns: FFIType.void
        },
        webviewGoBack: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        webviewGoForward: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        webviewReload: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        webviewRemove: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        setWebviewHTMLContent: {
          args: [FFIType.u32, FFIType.cstring],
          returns: FFIType.void
        },
        startWindowMove: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        stopWindowMove: {
          args: [],
          returns: FFIType.void
        },
        webviewSetTransparent: {
          args: [FFIType.ptr, FFIType.bool],
          returns: FFIType.void
        },
        webviewSetPassthrough: {
          args: [FFIType.ptr, FFIType.bool],
          returns: FFIType.void
        },
        webviewSetHidden: {
          args: [FFIType.ptr, FFIType.bool],
          returns: FFIType.void
        },
        setWebviewNavigationRules: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        webviewFindInPage: {
          args: [FFIType.ptr, FFIType.cstring, FFIType.bool, FFIType.bool],
          returns: FFIType.void
        },
        webviewStopFind: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        evaluateJavaScriptWithNoCompletion: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        webviewOpenDevTools: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        webviewCloseDevTools: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        webviewToggleDevTools: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        createTray: {
          args: [
            FFIType.u32,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.bool,
            FFIType.u32,
            FFIType.u32,
            FFIType.function
          ],
          returns: FFIType.ptr
        },
        setTrayTitle: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        setTrayImage: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        setTrayMenu: {
          args: [FFIType.ptr, FFIType.cstring],
          returns: FFIType.void
        },
        removeTray: {
          args: [FFIType.ptr],
          returns: FFIType.void
        },
        setApplicationMenu: {
          args: [FFIType.cstring, FFIType.function],
          returns: FFIType.void
        },
        showContextMenu: {
          args: [FFIType.cstring, FFIType.function],
          returns: FFIType.void
        },
        moveToTrash: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        showItemInFolder: {
          args: [FFIType.cstring],
          returns: FFIType.void
        },
        openExternal: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        openPath: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        showNotification: {
          args: [
            FFIType.cstring,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.bool
          ],
          returns: FFIType.void
        },
        setGlobalShortcutCallback: {
          args: [FFIType.function],
          returns: FFIType.void
        },
        registerGlobalShortcut: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        unregisterGlobalShortcut: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        unregisterAllGlobalShortcuts: {
          args: [],
          returns: FFIType.void
        },
        isGlobalShortcutRegistered: {
          args: [FFIType.cstring],
          returns: FFIType.bool
        },
        getAllDisplays: {
          args: [],
          returns: FFIType.cstring
        },
        getPrimaryDisplay: {
          args: [],
          returns: FFIType.cstring
        },
        getCursorScreenPoint: {
          args: [],
          returns: FFIType.cstring
        },
        openFileDialog: {
          args: [
            FFIType.cstring,
            FFIType.cstring,
            FFIType.int,
            FFIType.int,
            FFIType.int
          ],
          returns: FFIType.cstring
        },
        showMessageBox: {
          args: [
            FFIType.cstring,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.cstring,
            FFIType.int,
            FFIType.int
          ],
          returns: FFIType.int
        },
        clipboardReadText: {
          args: [],
          returns: FFIType.cstring
        },
        clipboardWriteText: {
          args: [FFIType.cstring],
          returns: FFIType.void
        },
        clipboardReadImage: {
          args: [FFIType.ptr],
          returns: FFIType.ptr
        },
        clipboardWriteImage: {
          args: [FFIType.ptr, FFIType.u64],
          returns: FFIType.void
        },
        clipboardClear: {
          args: [],
          returns: FFIType.void
        },
        clipboardAvailableFormats: {
          args: [],
          returns: FFIType.cstring
        },
        sessionGetCookies: {
          args: [FFIType.cstring, FFIType.cstring],
          returns: FFIType.cstring
        },
        sessionSetCookie: {
          args: [FFIType.cstring, FFIType.cstring],
          returns: FFIType.bool
        },
        sessionRemoveCookie: {
          args: [FFIType.cstring, FFIType.cstring, FFIType.cstring],
          returns: FFIType.bool
        },
        sessionClearCookies: {
          args: [FFIType.cstring],
          returns: FFIType.void
        },
        sessionClearStorageData: {
          args: [FFIType.cstring, FFIType.cstring],
          returns: FFIType.void
        },
        setURLOpenHandler: {
          args: [FFIType.function],
          returns: FFIType.void
        },
        getWindowStyle: {
          args: [
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool,
            FFIType.bool
          ],
          returns: FFIType.u32
        },
        setJSUtils: {
          args: [
            FFIType.function,
            FFIType.function
          ],
          returns: FFIType.void
        },
        setWindowIcon: {
          args: [
            FFIType.ptr,
            FFIType.cstring
          ],
          returns: FFIType.void
        },
        killApp: {
          args: [],
          returns: FFIType.void
        },
        stopEventLoop: {
          args: [],
          returns: FFIType.void
        },
        waitForShutdownComplete: {
          args: [FFIType.i32],
          returns: FFIType.void
        },
        forceExit: {
          args: [FFIType.i32],
          returns: FFIType.void
        },
        setQuitRequestedHandler: {
          args: [FFIType.function],
          returns: FFIType.void
        },
        testFFI2: {
          args: [FFIType.function],
          returns: FFIType.void
        }
      });
    } catch (err) {
      console.log("FATAL Error opening native FFI:", err.message);
      console.log("This may be due to:");
      console.log("  - Missing libNativeWrapper.dll/so/dylib");
      console.log("  - Architecture mismatch (ARM64 vs x64)");
      console.log("  - Missing WebView2 or CEF dependencies");
      if (suffix === "so") {
        console.log("  - Missing system libraries (try: ldd ./libNativeWrapper.so)");
      }
      console.log("Check that the build process completed successfully for your architecture.");
      process.exit();
    }
  })();
  ffi = {
    request: {
      createWindow: (params) => {
        const {
          id,
          url: _url,
          title,
          frame: { x, y, width, height },
          styleMask: {
            Borderless,
            Titled,
            Closable,
            Miniaturizable,
            Resizable,
            UnifiedTitleAndToolbar,
            FullScreen,
            FullSizeContentView,
            UtilityWindow,
            DocModalWindow,
            NonactivatingPanel,
            HUDWindow
          },
          titleBarStyle,
          transparent
        } = params;
        const styleMask = native.symbols.getWindowStyle(Borderless, Titled, Closable, Miniaturizable, Resizable, UnifiedTitleAndToolbar, FullScreen, FullSizeContentView, UtilityWindow, DocModalWindow, NonactivatingPanel, HUDWindow);
        const windowPtr = native.symbols.createWindowWithFrameAndStyleFromWorker(id, x, y, width, height, styleMask, toCString(titleBarStyle), transparent, windowCloseCallback, windowMoveCallback, windowResizeCallback, windowFocusCallback);
        if (!windowPtr) {
          throw "Failed to create window";
        }
        native.symbols.setWindowTitle(windowPtr, toCString(title));
        native.symbols.showWindow(windowPtr);
        return windowPtr;
      },
      setTitle: (params) => {
        const { winId, title } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't add webview to window. window no longer exists`;
        }
        native.symbols.setWindowTitle(windowPtr, toCString(title));
      },
      closeWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't close window. Window no longer exists`;
        }
        native.symbols.closeWindow(windowPtr);
      },
      focusWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't focus window. Window no longer exists`;
        }
        native.symbols.showWindow(windowPtr);
      },
      minimizeWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't minimize window. Window no longer exists`;
        }
        native.symbols.minimizeWindow(windowPtr);
      },
      restoreWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't restore window. Window no longer exists`;
        }
        native.symbols.restoreWindow(windowPtr);
      },
      isWindowMinimized: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          return false;
        }
        return native.symbols.isWindowMinimized(windowPtr);
      },
      maximizeWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't maximize window. Window no longer exists`;
        }
        native.symbols.maximizeWindow(windowPtr);
      },
      unmaximizeWindow: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't unmaximize window. Window no longer exists`;
        }
        native.symbols.unmaximizeWindow(windowPtr);
      },
      isWindowMaximized: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          return false;
        }
        return native.symbols.isWindowMaximized(windowPtr);
      },
      setWindowFullScreen: (params) => {
        const { winId, fullScreen } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't set fullscreen. Window no longer exists`;
        }
        native.symbols.setWindowFullScreen(windowPtr, fullScreen);
      },
      isWindowFullScreen: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          return false;
        }
        return native.symbols.isWindowFullScreen(windowPtr);
      },
      setWindowAlwaysOnTop: (params) => {
        const { winId, alwaysOnTop } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't set always on top. Window no longer exists`;
        }
        native.symbols.setWindowAlwaysOnTop(windowPtr, alwaysOnTop);
      },
      isWindowAlwaysOnTop: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          return false;
        }
        return native.symbols.isWindowAlwaysOnTop(windowPtr);
      },
      setWindowPosition: (params) => {
        const { winId, x, y } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't set window position. Window no longer exists`;
        }
        native.symbols.setWindowPosition(windowPtr, x, y);
      },
      setWindowSize: (params) => {
        const { winId, width, height } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't set window size. Window no longer exists`;
        }
        native.symbols.setWindowSize(windowPtr, width, height);
      },
      setWindowFrame: (params) => {
        const { winId, x, y, width, height } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          throw `Can't set window frame. Window no longer exists`;
        }
        native.symbols.setWindowFrame(windowPtr, x, y, width, height);
      },
      getWindowFrame: (params) => {
        const { winId } = params;
        const windowPtr = BrowserWindow.getById(winId)?.ptr;
        if (!windowPtr) {
          return { x: 0, y: 0, width: 0, height: 0 };
        }
        const xBuf = new Float64Array(1);
        const yBuf = new Float64Array(1);
        const widthBuf = new Float64Array(1);
        const heightBuf = new Float64Array(1);
        native.symbols.getWindowFrame(windowPtr, ptr(xBuf), ptr(yBuf), ptr(widthBuf), ptr(heightBuf));
        return {
          x: xBuf[0],
          y: yBuf[0],
          width: widthBuf[0],
          height: heightBuf[0]
        };
      },
      createWebview: (params) => {
        const {
          id,
          windowId,
          renderer,
          rpcPort: rpcPort2,
          secretKey,
          url,
          partition,
          preload,
          frame: { x, y, width, height },
          autoResize,
          sandbox,
          startTransparent,
          startPassthrough
        } = params;
        const parentWindow = BrowserWindow.getById(windowId);
        const windowPtr = parentWindow?.ptr;
        const transparent = parentWindow?.transparent ?? false;
        if (!windowPtr) {
          throw `Can't add webview to window. window no longer exists`;
        }
        let dynamicPreload;
        let selectedPreloadScript;
        if (sandbox) {
          dynamicPreload = `
window.__electrobunWebviewId = ${id};
window.__electrobunWindowId = ${windowId};
window.__electrobunEventBridge = window.__electrobunEventBridge || window.webkit?.messageHandlers?.eventBridge || window.eventBridge || window.chrome?.webview?.hostObjects?.eventBridge;
window.__electrobunInternalBridge = window.__electrobunInternalBridge || window.webkit?.messageHandlers?.internalBridge || window.internalBridge || window.chrome?.webview?.hostObjects?.internalBridge;
`;
          selectedPreloadScript = preloadScriptSandboxed;
        } else {
          dynamicPreload = `
window.__electrobunWebviewId = ${id};
window.__electrobunWindowId = ${windowId};
window.__electrobunRpcSocketPort = ${rpcPort2};
window.__electrobunSecretKeyBytes = [${secretKey}];
window.__electrobunEventBridge = window.__electrobunEventBridge || window.webkit?.messageHandlers?.eventBridge || window.eventBridge || window.chrome?.webview?.hostObjects?.eventBridge;
window.__electrobunInternalBridge = window.__electrobunInternalBridge || window.webkit?.messageHandlers?.internalBridge || window.internalBridge || window.chrome?.webview?.hostObjects?.internalBridge;
window.__electrobunBunBridge = window.__electrobunBunBridge || window.webkit?.messageHandlers?.bunBridge || window.bunBridge || window.chrome?.webview?.hostObjects?.bunBridge;
`;
          selectedPreloadScript = preloadScript;
        }
        const electrobunPreload = dynamicPreload + selectedPreloadScript;
        const customPreload = preload;
        native.symbols.setNextWebviewFlags(startTransparent, startPassthrough);
        const webviewPtr = native.symbols.initWebview(id, windowPtr, toCString(renderer), toCString(url || ""), x, y, width, height, autoResize, toCString(partition || "persist:default"), webviewDecideNavigation, webviewEventJSCallback, eventBridgeHandler, bunBridgePostmessageHandler, internalBridgeHandler, toCString(electrobunPreload), toCString(customPreload || ""), transparent, sandbox);
        if (!webviewPtr) {
          throw "Failed to create webview";
        }
        return webviewPtr;
      },
      evaluateJavascriptWithNoCompletion: (params) => {
        const { id, js } = params;
        const webview = BrowserView.getById(id);
        if (!webview?.ptr) {
          return;
        }
        native.symbols.evaluateJavaScriptWithNoCompletion(webview.ptr, toCString(js));
      },
      createTray: (params) => {
        const { id, title, image, template, width, height } = params;
        const trayPtr = native.symbols.createTray(id, toCString(title), toCString(image), template, width, height, trayItemHandler);
        if (!trayPtr) {
          throw "Failed to create tray";
        }
        return trayPtr;
      },
      setTrayTitle: (params) => {
        const { id, title } = params;
        const tray = Tray.getById(id);
        if (!tray)
          return;
        native.symbols.setTrayTitle(tray.ptr, toCString(title));
      },
      setTrayImage: (params) => {
        const { id, image } = params;
        const tray = Tray.getById(id);
        if (!tray)
          return;
        native.symbols.setTrayImage(tray.ptr, toCString(image));
      },
      setTrayMenu: (params) => {
        const { id, menuConfig } = params;
        const tray = Tray.getById(id);
        if (!tray)
          return;
        native.symbols.setTrayMenu(tray.ptr, toCString(menuConfig));
      },
      removeTray: (params) => {
        const { id } = params;
        const tray = Tray.getById(id);
        if (!tray) {
          throw `Can't remove tray. Tray no longer exists`;
        }
        native.symbols.removeTray(tray.ptr);
      },
      setApplicationMenu: (params) => {
        const { menuConfig } = params;
        native.symbols.setApplicationMenu(toCString(menuConfig), applicationMenuHandler);
      },
      showContextMenu: (params) => {
        const { menuConfig } = params;
        native.symbols.showContextMenu(toCString(menuConfig), contextMenuHandler);
      },
      moveToTrash: (params) => {
        const { path } = params;
        return native.symbols.moveToTrash(toCString(path));
      },
      showItemInFolder: (params) => {
        const { path } = params;
        native.symbols.showItemInFolder(toCString(path));
      },
      openExternal: (params) => {
        const { url } = params;
        return native.symbols.openExternal(toCString(url));
      },
      openPath: (params) => {
        const { path } = params;
        return native.symbols.openPath(toCString(path));
      },
      showNotification: (params) => {
        const { title, body = "", subtitle = "", silent = false } = params;
        native.symbols.showNotification(toCString(title), toCString(body), toCString(subtitle), silent);
      },
      openFileDialog: (params) => {
        const {
          startingFolder,
          allowedFileTypes,
          canChooseFiles,
          canChooseDirectory,
          allowsMultipleSelection
        } = params;
        const filePath = native.symbols.openFileDialog(toCString(startingFolder), toCString(allowedFileTypes), canChooseFiles ? 1 : 0, canChooseDirectory ? 1 : 0, allowsMultipleSelection ? 1 : 0);
        return filePath.toString();
      },
      showMessageBox: (params) => {
        const {
          type = "info",
          title = "",
          message = "",
          detail = "",
          buttons = ["OK"],
          defaultId = 0,
          cancelId = -1
        } = params;
        const buttonsStr = buttons.join(",");
        return native.symbols.showMessageBox(toCString(type), toCString(title), toCString(message), toCString(detail), toCString(buttonsStr), defaultId, cancelId);
      },
      clipboardReadText: () => {
        const result = native.symbols.clipboardReadText();
        if (!result)
          return null;
        return result.toString();
      },
      clipboardWriteText: (params) => {
        native.symbols.clipboardWriteText(toCString(params.text));
      },
      clipboardReadImage: () => {
        const sizeBuffer = new BigUint64Array(1);
        const dataPtr = native.symbols.clipboardReadImage(ptr(sizeBuffer));
        if (!dataPtr)
          return null;
        const size = Number(sizeBuffer[0]);
        if (size === 0)
          return null;
        const result = new Uint8Array(size);
        const sourceView = new Uint8Array(toArrayBuffer(dataPtr, 0, size));
        result.set(sourceView);
        return result;
      },
      clipboardWriteImage: (params) => {
        const { pngData } = params;
        native.symbols.clipboardWriteImage(ptr(pngData), BigInt(pngData.length));
      },
      clipboardClear: () => {
        native.symbols.clipboardClear();
      },
      clipboardAvailableFormats: () => {
        const result = native.symbols.clipboardAvailableFormats();
        if (!result)
          return [];
        const formatsStr = result.toString();
        if (!formatsStr)
          return [];
        return formatsStr.split(",").filter((f) => f.length > 0);
      }
    },
    internal: {
      storeMenuData,
      getMenuData,
      clearMenuData,
      serializeMenuAction,
      deserializeMenuAction
    }
  };
  process.on("uncaughtException", (err) => {
    console.error("Uncaught exception in worker:", err);
    native.symbols.stopEventLoop();
    native.symbols.waitForShutdownComplete(5000);
    native.symbols.forceExit(1);
  });
  process.on("unhandledRejection", (reason, _promise) => {
    console.error("Unhandled rejection in worker:", reason);
  });
  process.on("SIGINT", () => {
    console.log("[electrobun] Received SIGINT, running quit sequence...");
    const { quit: quit2 } = (init_Utils(), __toCommonJS(exports_Utils));
    quit2();
  });
  process.on("SIGTERM", () => {
    console.log("[electrobun] Received SIGTERM, running quit sequence...");
    const { quit: quit2 } = (init_Utils(), __toCommonJS(exports_Utils));
    quit2();
  });
  windowCloseCallback = new JSCallback((id) => {
    const handler = eventEmitter_default.events.window.close;
    const event = handler({
      id
    });
    eventEmitter_default.emitEvent(event, id);
    eventEmitter_default.emitEvent(event);
  }, {
    args: ["u32"],
    returns: "void",
    threadsafe: true
  });
  windowMoveCallback = new JSCallback((id, x, y) => {
    const handler = eventEmitter_default.events.window.move;
    const event = handler({
      id,
      x,
      y
    });
    eventEmitter_default.emitEvent(event);
    eventEmitter_default.emitEvent(event, id);
  }, {
    args: ["u32", "f64", "f64"],
    returns: "void",
    threadsafe: true
  });
  windowResizeCallback = new JSCallback((id, x, y, width, height) => {
    const handler = eventEmitter_default.events.window.resize;
    const event = handler({
      id,
      x,
      y,
      width,
      height
    });
    eventEmitter_default.emitEvent(event);
    eventEmitter_default.emitEvent(event, id);
  }, {
    args: ["u32", "f64", "f64", "f64", "f64"],
    returns: "void",
    threadsafe: true
  });
  windowFocusCallback = new JSCallback((id) => {
    const handler = eventEmitter_default.events.window.focus;
    const event = handler({
      id
    });
    eventEmitter_default.emitEvent(event);
    eventEmitter_default.emitEvent(event, id);
  }, {
    args: ["u32"],
    returns: "void",
    threadsafe: true
  });
  getMimeType = new JSCallback((filePath) => {
    const _filePath = new CString(filePath).toString();
    const mimeType = Bun.file(_filePath).type;
    return toCString(mimeType.split(";")[0]);
  }, {
    args: [FFIType.cstring],
    returns: FFIType.cstring
  });
  getHTMLForWebviewSync = new JSCallback((webviewId) => {
    const webview = BrowserView.getById(webviewId);
    return toCString(webview?.html || "");
  }, {
    args: [FFIType.u32],
    returns: FFIType.cstring
  });
  native.symbols.setJSUtils(getMimeType, getHTMLForWebviewSync);
  urlOpenCallback = new JSCallback((urlPtr) => {
    const url = new CString(urlPtr).toString();
    const handler = eventEmitter_default.events.app.openUrl;
    const event = handler({ url });
    eventEmitter_default.emitEvent(event);
  }, {
    args: [FFIType.cstring],
    returns: "void",
    threadsafe: true
  });
  if (process.platform === "darwin") {
    native.symbols.setURLOpenHandler(urlOpenCallback);
  }
  quitRequestedCallback = new JSCallback(() => {
    const { quit: quit2 } = (init_Utils(), __toCommonJS(exports_Utils));
    quit2();
  }, {
    args: [],
    returns: "void",
    threadsafe: true
  });
  native.symbols.setQuitRequestedHandler(quitRequestedCallback);
  globalShortcutHandlers = new Map;
  globalShortcutCallback = new JSCallback((acceleratorPtr) => {
    const accelerator = new CString(acceleratorPtr).toString();
    const handler = globalShortcutHandlers.get(accelerator);
    if (handler) {
      handler();
    }
  }, {
    args: [FFIType.cstring],
    returns: "void",
    threadsafe: true
  });
  native.symbols.setGlobalShortcutCallback(globalShortcutCallback);
  sessionCache = new Map;
  webviewDecideNavigation = new JSCallback((_webviewId, _url) => {
    return true;
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.u32,
    threadsafe: true
  });
  webviewEventJSCallback = new JSCallback((id, _eventName, _detail) => {
    let eventName = "";
    let detail = "";
    try {
      eventName = new CString(_eventName).toString();
      detail = new CString(_detail).toString();
    } catch (err) {
      console.error("[webviewEventJSCallback] Error converting strings:", err);
      console.error("[webviewEventJSCallback] Raw values:", {
        _eventName,
        _detail
      });
      return;
    }
    webviewEventHandler(id, eventName, detail);
  }, {
    args: [FFIType.u32, FFIType.cstring, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  bunBridgePostmessageHandler = new JSCallback((id, msg) => {
    try {
      const msgStr = new CString(msg);
      if (!msgStr.length) {
        return;
      }
      const msgJson = JSON.parse(msgStr.toString());
      const webview = BrowserView.getById(id);
      if (!webview)
        return;
      webview.rpcHandler?.(msgJson);
    } catch (err) {
      console.error("error sending message to bun: ", err);
      console.error("msgString: ", new CString(msg));
    }
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  eventBridgeHandler = new JSCallback((_id, msg) => {
    try {
      const message = new CString(msg);
      const jsonMessage = JSON.parse(message.toString());
      if (jsonMessage.id === "webviewEvent") {
        const { payload } = jsonMessage;
        webviewEventHandler(payload.id, payload.eventName, payload.detail);
      }
    } catch (err) {
      console.error("error in eventBridgeHandler: ", err);
    }
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  internalBridgeHandler = new JSCallback((_id, msg) => {
    try {
      const batchMessage = new CString(msg);
      const jsonBatch = JSON.parse(batchMessage.toString());
      if (jsonBatch.id === "webviewEvent") {
        const { payload } = jsonBatch;
        webviewEventHandler(payload.id, payload.eventName, payload.detail);
        return;
      }
      jsonBatch.forEach((msgStr) => {
        const msgJson = JSON.parse(msgStr);
        if (msgJson.type === "message") {
          const handler = internalRpcHandlers.message[msgJson.id];
          handler?.(msgJson.payload);
        } else if (msgJson.type === "request") {
          const hostWebview = BrowserView.getById(msgJson.hostWebviewId);
          const handler = internalRpcHandlers.request[msgJson.method];
          const payload = handler?.(msgJson.params);
          const resultObj = {
            type: "response",
            id: msgJson.id,
            success: true,
            payload
          };
          if (!hostWebview) {
            console.log("--->>> internal request in bun: NO HOST WEBVIEW FOUND");
            return;
          }
          hostWebview.sendInternalMessageViaExecute(resultObj);
        }
      });
    } catch (err) {
      console.error("error in internalBridgeHandler: ", err);
    }
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  trayItemHandler = new JSCallback((id, action) => {
    const actionString = (new CString(action).toString() || "").trim();
    const { action: actualAction, data } = deserializeMenuAction(actionString);
    const event = eventEmitter_default.events.tray.trayClicked({
      id,
      action: actualAction,
      data
    });
    eventEmitter_default.emitEvent(event);
    eventEmitter_default.emitEvent(event, id);
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  applicationMenuHandler = new JSCallback((id, action) => {
    const actionString = new CString(action).toString();
    const { action: actualAction, data } = deserializeMenuAction(actionString);
    const event = eventEmitter_default.events.app.applicationMenuClicked({
      id,
      action: actualAction,
      data
    });
    eventEmitter_default.emitEvent(event);
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  contextMenuHandler = new JSCallback((_id, action) => {
    const actionString = new CString(action).toString();
    const { action: actualAction, data } = deserializeMenuAction(actionString);
    const event = eventEmitter_default.events.app.contextMenuClicked({
      action: actualAction,
      data
    });
    eventEmitter_default.emitEvent(event);
  }, {
    args: [FFIType.u32, FFIType.cstring],
    returns: FFIType.void,
    threadsafe: true
  });
  internalRpcHandlers = {
    request: {
      webviewTagInit: (params) => {
        const {
          hostWebviewId,
          windowId,
          renderer,
          html,
          preload,
          partition,
          frame,
          navigationRules,
          sandbox,
          transparent,
          passthrough
        } = params;
        const url = !params.url && !html ? "https://electrobun.dev" : params.url;
        const webviewForTag = new BrowserView({
          url,
          html,
          preload,
          partition,
          frame,
          hostWebviewId,
          autoResize: false,
          windowId,
          renderer,
          navigationRules,
          sandbox,
          startTransparent: transparent,
          startPassthrough: passthrough
        });
        return webviewForTag.id;
      },
      webviewTagCanGoBack: (params) => {
        const { id } = params;
        const webviewPtr = BrowserView.getById(id)?.ptr;
        if (!webviewPtr) {
          console.error("no webview ptr");
          return false;
        }
        return native.symbols.webviewCanGoBack(webviewPtr);
      },
      webviewTagCanGoForward: (params) => {
        const { id } = params;
        const webviewPtr = BrowserView.getById(id)?.ptr;
        if (!webviewPtr) {
          console.error("no webview ptr");
          return false;
        }
        return native.symbols.webviewCanGoForward(webviewPtr);
      }
    },
    message: {
      webviewTagResize: (params) => {
        const browserView = BrowserView.getById(params.id);
        const webviewPtr = browserView?.ptr;
        if (!webviewPtr) {
          console.log("[Bun] ERROR: webviewTagResize - no webview ptr found for id:", params.id);
          return;
        }
        const { x, y, width, height } = params.frame;
        native.symbols.resizeWebview(webviewPtr, x, y, width, height, toCString(params.masks));
      },
      webviewTagUpdateSrc: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagUpdateSrc: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.loadURLInWebView(webview.ptr, toCString(params.url));
      },
      webviewTagUpdateHtml: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagUpdateHtml: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.setWebviewHTMLContent(webview.id, toCString(params.html));
        webview.loadHTML(params.html);
        webview.html = params.html;
      },
      webviewTagUpdatePreload: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagUpdatePreload: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.updatePreloadScriptToWebView(webview.ptr, toCString("electrobun_custom_preload_script"), toCString(params.preload), true);
      },
      webviewTagGoBack: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagGoBack: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewGoBack(webview.ptr);
      },
      webviewTagGoForward: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagGoForward: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewGoForward(webview.ptr);
      },
      webviewTagReload: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagReload: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewReload(webview.ptr);
      },
      webviewTagRemove: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagRemove: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewRemove(webview.ptr);
      },
      startWindowMove: (params) => {
        const window2 = BrowserWindow.getById(params.id);
        if (!window2)
          return;
        native.symbols.startWindowMove(window2.ptr);
      },
      stopWindowMove: (_params) => {
        native.symbols.stopWindowMove();
      },
      webviewTagSetTransparent: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagSetTransparent: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewSetTransparent(webview.ptr, params.transparent);
      },
      webviewTagSetPassthrough: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagSetPassthrough: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewSetPassthrough(webview.ptr, params.enablePassthrough);
      },
      webviewTagSetHidden: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagSetHidden: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewSetHidden(webview.ptr, params.hidden);
      },
      webviewTagSetNavigationRules: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagSetNavigationRules: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        const rulesJson = JSON.stringify(params.rules);
        native.symbols.setWebviewNavigationRules(webview.ptr, toCString(rulesJson));
      },
      webviewTagFindInPage: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagFindInPage: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewFindInPage(webview.ptr, toCString(params.searchText), params.forward, params.matchCase);
      },
      webviewTagStopFind: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagStopFind: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewStopFind(webview.ptr);
      },
      webviewTagOpenDevTools: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagOpenDevTools: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewOpenDevTools(webview.ptr);
      },
      webviewTagCloseDevTools: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagCloseDevTools: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewCloseDevTools(webview.ptr);
      },
      webviewTagToggleDevTools: (params) => {
        const webview = BrowserView.getById(params.id);
        if (!webview || !webview.ptr) {
          console.error(`webviewTagToggleDevTools: BrowserView not found or has no ptr for id ${params.id}`);
          return;
        }
        native.symbols.webviewToggleDevTools(webview.ptr);
      },
      webviewEvent: (params) => {
        console.log("-----------------+webviewEvent", params);
      }
    }
  };
});

// ../node_modules/.bun/electrobun@1.14.4/node_modules/electrobun/dist/api/bun/core/BrowserWindow.ts
class BrowserWindow {
  id = nextWindowId++;
  ptr;
  title = "Electrobun";
  state = "creating";
  url = null;
  html = null;
  preload = null;
  renderer = "native";
  transparent = false;
  navigationRules = null;
  sandbox = false;
  frame = {
    x: 0,
    y: 0,
    width: 800,
    height: 600
  };
  webviewId;
  constructor(options = defaultOptions2) {
    this.title = options.title || "New Window";
    this.frame = options.frame ? { ...defaultOptions2.frame, ...options.frame } : { ...defaultOptions2.frame };
    this.url = options.url || null;
    this.html = options.html || null;
    this.preload = options.preload || null;
    this.renderer = options.renderer || defaultOptions2.renderer;
    this.transparent = options.transparent ?? false;
    this.navigationRules = options.navigationRules || null;
    this.sandbox = options.sandbox ?? false;
    this.init(options);
  }
  init({
    rpc,
    styleMask,
    titleBarStyle,
    transparent
  }) {
    this.ptr = ffi.request.createWindow({
      id: this.id,
      title: this.title,
      url: this.url || "",
      frame: {
        width: this.frame.width,
        height: this.frame.height,
        x: this.frame.x,
        y: this.frame.y
      },
      styleMask: {
        Borderless: false,
        Titled: true,
        Closable: true,
        Miniaturizable: true,
        Resizable: true,
        UnifiedTitleAndToolbar: false,
        FullScreen: false,
        FullSizeContentView: false,
        UtilityWindow: false,
        DocModalWindow: false,
        NonactivatingPanel: false,
        HUDWindow: false,
        ...styleMask || {},
        ...titleBarStyle === "hiddenInset" ? {
          Titled: true,
          FullSizeContentView: true
        } : {},
        ...titleBarStyle === "hidden" ? {
          Titled: false,
          FullSizeContentView: true
        } : {}
      },
      titleBarStyle: titleBarStyle || "default",
      transparent: transparent ?? false
    });
    BrowserWindowMap[this.id] = this;
    const webview = new BrowserView({
      url: this.url,
      html: this.html,
      preload: this.preload,
      renderer: this.renderer,
      frame: {
        x: 0,
        y: 0,
        width: this.frame.width,
        height: this.frame.height
      },
      rpc,
      windowId: this.id,
      navigationRules: this.navigationRules,
      sandbox: this.sandbox
    });
    console.log("setting webviewId: ", webview.id);
    this.webviewId = webview.id;
  }
  get webview() {
    return BrowserView.getById(this.webviewId);
  }
  static getById(id) {
    return BrowserWindowMap[id];
  }
  setTitle(title) {
    this.title = title;
    return ffi.request.setTitle({ winId: this.id, title });
  }
  close() {
    return ffi.request.closeWindow({ winId: this.id });
  }
  focus() {
    return ffi.request.focusWindow({ winId: this.id });
  }
  show() {
    return ffi.request.focusWindow({ winId: this.id });
  }
  minimize() {
    return ffi.request.minimizeWindow({ winId: this.id });
  }
  unminimize() {
    return ffi.request.restoreWindow({ winId: this.id });
  }
  isMinimized() {
    return ffi.request.isWindowMinimized({ winId: this.id });
  }
  maximize() {
    return ffi.request.maximizeWindow({ winId: this.id });
  }
  unmaximize() {
    return ffi.request.unmaximizeWindow({ winId: this.id });
  }
  isMaximized() {
    return ffi.request.isWindowMaximized({ winId: this.id });
  }
  setFullScreen(fullScreen) {
    return ffi.request.setWindowFullScreen({ winId: this.id, fullScreen });
  }
  isFullScreen() {
    return ffi.request.isWindowFullScreen({ winId: this.id });
  }
  setAlwaysOnTop(alwaysOnTop) {
    return ffi.request.setWindowAlwaysOnTop({ winId: this.id, alwaysOnTop });
  }
  isAlwaysOnTop() {
    return ffi.request.isWindowAlwaysOnTop({ winId: this.id });
  }
  setPosition(x, y) {
    this.frame.x = x;
    this.frame.y = y;
    return ffi.request.setWindowPosition({ winId: this.id, x, y });
  }
  setSize(width, height) {
    this.frame.width = width;
    this.frame.height = height;
    return ffi.request.setWindowSize({ winId: this.id, width, height });
  }
  setFrame(x, y, width, height) {
    this.frame = { x, y, width, height };
    return ffi.request.setWindowFrame({ winId: this.id, x, y, width, height });
  }
  getFrame() {
    const frame = ffi.request.getWindowFrame({ winId: this.id });
    this.frame = frame;
    return frame;
  }
  getPosition() {
    const frame = this.getFrame();
    return { x: frame.x, y: frame.y };
  }
  getSize() {
    const frame = this.getFrame();
    return { width: frame.width, height: frame.height };
  }
  on(name, handler) {
    const specificName = `${name}-${this.id}`;
    eventEmitter_default.on(specificName, handler);
  }
}
var buildConfig3, nextWindowId = 1, defaultOptions2, BrowserWindowMap;
var init_BrowserWindow = __esm(async () => {
  init_eventEmitter();
  init_BuildConfig();
  await __promiseAll([
    init_native(),
    init_BrowserView(),
    init_Utils()
  ]);
  buildConfig3 = await BuildConfig.get();
  defaultOptions2 = {
    title: "Electrobun",
    frame: {
      x: 0,
      y: 0,
      width: 800,
      height: 600
    },
    url: "https://electrobun.dev",
    html: null,
    preload: null,
    renderer: buildConfig3.defaultRenderer,
    titleBarStyle: "default",
    transparent: false,
    navigationRules: null,
    sandbox: false
  };
  BrowserWindowMap = {};
  eventEmitter_default.on("close", (event) => {
    const windowId = event.data.id;
    delete BrowserWindowMap[windowId];
    for (const view of BrowserView.getAll()) {
      if (view.windowId === windowId) {
        view.remove();
      }
    }
    const exitOnLastWindowClosed = buildConfig3.runtime?.exitOnLastWindowClosed ?? true;
    if (exitOnLastWindowClosed && Object.keys(BrowserWindowMap).length === 0) {
      quit();
    }
  });
});

// ../node_modules/.bun/partial-json@0.1.7/node_modules/partial-json/dist/options.js
var require_options = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Allow = exports.ALL = exports.COLLECTION = exports.ATOM = exports.SPECIAL = exports.INF = exports._INFINITY = exports.INFINITY = exports.NAN = exports.BOOL = exports.NULL = exports.OBJ = exports.ARR = exports.NUM = exports.STR = undefined;
  exports.STR = 1;
  exports.NUM = 2;
  exports.ARR = 4;
  exports.OBJ = 8;
  exports.NULL = 16;
  exports.BOOL = 32;
  exports.NAN = 64;
  exports.INFINITY = 128;
  exports._INFINITY = 256;
  exports.INF = exports.INFINITY | exports._INFINITY;
  exports.SPECIAL = exports.NULL | exports.BOOL | exports.INF | exports.NAN;
  exports.ATOM = exports.STR | exports.NUM | exports.SPECIAL;
  exports.COLLECTION = exports.ARR | exports.OBJ;
  exports.ALL = exports.ATOM | exports.COLLECTION;
  exports.Allow = { STR: exports.STR, NUM: exports.NUM, ARR: exports.ARR, OBJ: exports.OBJ, NULL: exports.NULL, BOOL: exports.BOOL, NAN: exports.NAN, INFINITY: exports.INFINITY, _INFINITY: exports._INFINITY, INF: exports.INF, SPECIAL: exports.SPECIAL, ATOM: exports.ATOM, COLLECTION: exports.COLLECTION, ALL: exports.ALL };
  exports.default = exports.Allow;
});

// ../node_modules/.bun/partial-json@0.1.7/node_modules/partial-json/dist/index.js
var require_dist = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Allow = exports.MalformedJSON = exports.PartialJSON = exports.parseJSON = exports.parse = undefined;
  var options_1 = require_options();
  Object.defineProperty(exports, "Allow", { enumerable: true, get: function() {
    return options_1.Allow;
  } });
  __exportStar(require_options(), exports);

  class PartialJSON extends Error {
  }
  exports.PartialJSON = PartialJSON;

  class MalformedJSON extends Error {
  }
  exports.MalformedJSON = MalformedJSON;
  function parseJSON(jsonString, allowPartial = options_1.Allow.ALL) {
    if (typeof jsonString !== "string") {
      throw new TypeError(`expecting str, got ${typeof jsonString}`);
    }
    if (!jsonString.trim()) {
      throw new Error(`${jsonString} is empty`);
    }
    return _parseJSON(jsonString.trim(), allowPartial);
  }
  exports.parseJSON = parseJSON;
  var _parseJSON = (jsonString, allow) => {
    const length = jsonString.length;
    let index = 0;
    const markPartialJSON = (msg) => {
      throw new PartialJSON(`${msg} at position ${index}`);
    };
    const throwMalformedError = (msg) => {
      throw new MalformedJSON(`${msg} at position ${index}`);
    };
    const parseAny = () => {
      skipBlank();
      if (index >= length)
        markPartialJSON("Unexpected end of input");
      if (jsonString[index] === '"')
        return parseStr();
      if (jsonString[index] === "{")
        return parseObj();
      if (jsonString[index] === "[")
        return parseArr();
      if (jsonString.substring(index, index + 4) === "null" || options_1.Allow.NULL & allow && length - index < 4 && "null".startsWith(jsonString.substring(index))) {
        index += 4;
        return null;
      }
      if (jsonString.substring(index, index + 4) === "true" || options_1.Allow.BOOL & allow && length - index < 4 && "true".startsWith(jsonString.substring(index))) {
        index += 4;
        return true;
      }
      if (jsonString.substring(index, index + 5) === "false" || options_1.Allow.BOOL & allow && length - index < 5 && "false".startsWith(jsonString.substring(index))) {
        index += 5;
        return false;
      }
      if (jsonString.substring(index, index + 8) === "Infinity" || options_1.Allow.INFINITY & allow && length - index < 8 && "Infinity".startsWith(jsonString.substring(index))) {
        index += 8;
        return Infinity;
      }
      if (jsonString.substring(index, index + 9) === "-Infinity" || options_1.Allow._INFINITY & allow && 1 < length - index && length - index < 9 && "-Infinity".startsWith(jsonString.substring(index))) {
        index += 9;
        return -Infinity;
      }
      if (jsonString.substring(index, index + 3) === "NaN" || options_1.Allow.NAN & allow && length - index < 3 && "NaN".startsWith(jsonString.substring(index))) {
        index += 3;
        return NaN;
      }
      return parseNum();
    };
    const parseStr = () => {
      const start = index;
      let escape2 = false;
      index++;
      while (index < length && (jsonString[index] !== '"' || escape2 && jsonString[index - 1] === "\\")) {
        escape2 = jsonString[index] === "\\" ? !escape2 : false;
        index++;
      }
      if (jsonString.charAt(index) == '"') {
        try {
          return JSON.parse(jsonString.substring(start, ++index - Number(escape2)));
        } catch (e) {
          throwMalformedError(String(e));
        }
      } else if (options_1.Allow.STR & allow) {
        try {
          return JSON.parse(jsonString.substring(start, index - Number(escape2)) + '"');
        } catch (e) {
          return JSON.parse(jsonString.substring(start, jsonString.lastIndexOf("\\")) + '"');
        }
      }
      markPartialJSON("Unterminated string literal");
    };
    const parseObj = () => {
      index++;
      skipBlank();
      const obj = {};
      try {
        while (jsonString[index] !== "}") {
          skipBlank();
          if (index >= length && options_1.Allow.OBJ & allow)
            return obj;
          const key = parseStr();
          skipBlank();
          index++;
          try {
            const value = parseAny();
            obj[key] = value;
          } catch (e) {
            if (options_1.Allow.OBJ & allow)
              return obj;
            else
              throw e;
          }
          skipBlank();
          if (jsonString[index] === ",")
            index++;
        }
      } catch (e) {
        if (options_1.Allow.OBJ & allow)
          return obj;
        else
          markPartialJSON("Expected '}' at end of object");
      }
      index++;
      return obj;
    };
    const parseArr = () => {
      index++;
      const arr = [];
      try {
        while (jsonString[index] !== "]") {
          arr.push(parseAny());
          skipBlank();
          if (jsonString[index] === ",") {
            index++;
          }
        }
      } catch (e) {
        if (options_1.Allow.ARR & allow) {
          return arr;
        }
        markPartialJSON("Expected ']' at end of array");
      }
      index++;
      return arr;
    };
    const parseNum = () => {
      if (index === 0) {
        if (jsonString === "-")
          throwMalformedError("Not sure what '-' is");
        try {
          return JSON.parse(jsonString);
        } catch (e) {
          if (options_1.Allow.NUM & allow)
            try {
              return JSON.parse(jsonString.substring(0, jsonString.lastIndexOf("e")));
            } catch (e2) {}
          throwMalformedError(String(e));
        }
      }
      const start = index;
      if (jsonString[index] === "-")
        index++;
      while (jsonString[index] && ",]}".indexOf(jsonString[index]) === -1)
        index++;
      if (index == length && !(options_1.Allow.NUM & allow))
        markPartialJSON("Unterminated number literal");
      try {
        return JSON.parse(jsonString.substring(start, index));
      } catch (e) {
        if (jsonString.substring(start, index) === "-")
          markPartialJSON("Not sure what '-' is");
        try {
          return JSON.parse(jsonString.substring(start, jsonString.lastIndexOf("e")));
        } catch (e2) {
          throwMalformedError(String(e2));
        }
      }
    };
    const skipBlank = () => {
      while (index < length && ` 
\r	`.includes(jsonString[index])) {
        index++;
      }
    };
    return parseAny();
  };
  var parse = parseJSON;
  exports.parse = parse;
});

// ../node_modules/.bun/retry@0.13.1/node_modules/retry/lib/retry_operation.js
var require_retry_operation = __commonJS((exports, module) => {
  function RetryOperation(timeouts, options) {
    if (typeof options === "boolean") {
      options = { forever: options };
    }
    this._originalTimeouts = JSON.parse(JSON.stringify(timeouts));
    this._timeouts = timeouts;
    this._options = options || {};
    this._maxRetryTime = options && options.maxRetryTime || Infinity;
    this._fn = null;
    this._errors = [];
    this._attempts = 1;
    this._operationTimeout = null;
    this._operationTimeoutCb = null;
    this._timeout = null;
    this._operationStart = null;
    this._timer = null;
    if (this._options.forever) {
      this._cachedTimeouts = this._timeouts.slice(0);
    }
  }
  module.exports = RetryOperation;
  RetryOperation.prototype.reset = function() {
    this._attempts = 1;
    this._timeouts = this._originalTimeouts.slice(0);
  };
  RetryOperation.prototype.stop = function() {
    if (this._timeout) {
      clearTimeout(this._timeout);
    }
    if (this._timer) {
      clearTimeout(this._timer);
    }
    this._timeouts = [];
    this._cachedTimeouts = null;
  };
  RetryOperation.prototype.retry = function(err) {
    if (this._timeout) {
      clearTimeout(this._timeout);
    }
    if (!err) {
      return false;
    }
    var currentTime = new Date().getTime();
    if (err && currentTime - this._operationStart >= this._maxRetryTime) {
      this._errors.push(err);
      this._errors.unshift(new Error("RetryOperation timeout occurred"));
      return false;
    }
    this._errors.push(err);
    var timeout = this._timeouts.shift();
    if (timeout === undefined) {
      if (this._cachedTimeouts) {
        this._errors.splice(0, this._errors.length - 1);
        timeout = this._cachedTimeouts.slice(-1);
      } else {
        return false;
      }
    }
    var self2 = this;
    this._timer = setTimeout(function() {
      self2._attempts++;
      if (self2._operationTimeoutCb) {
        self2._timeout = setTimeout(function() {
          self2._operationTimeoutCb(self2._attempts);
        }, self2._operationTimeout);
        if (self2._options.unref) {
          self2._timeout.unref();
        }
      }
      self2._fn(self2._attempts);
    }, timeout);
    if (this._options.unref) {
      this._timer.unref();
    }
    return true;
  };
  RetryOperation.prototype.attempt = function(fn, timeoutOps) {
    this._fn = fn;
    if (timeoutOps) {
      if (timeoutOps.timeout) {
        this._operationTimeout = timeoutOps.timeout;
      }
      if (timeoutOps.cb) {
        this._operationTimeoutCb = timeoutOps.cb;
      }
    }
    var self2 = this;
    if (this._operationTimeoutCb) {
      this._timeout = setTimeout(function() {
        self2._operationTimeoutCb();
      }, self2._operationTimeout);
    }
    this._operationStart = new Date().getTime();
    this._fn(this._attempts);
  };
  RetryOperation.prototype.try = function(fn) {
    console.log("Using RetryOperation.try() is deprecated");
    this.attempt(fn);
  };
  RetryOperation.prototype.start = function(fn) {
    console.log("Using RetryOperation.start() is deprecated");
    this.attempt(fn);
  };
  RetryOperation.prototype.start = RetryOperation.prototype.try;
  RetryOperation.prototype.errors = function() {
    return this._errors;
  };
  RetryOperation.prototype.attempts = function() {
    return this._attempts;
  };
  RetryOperation.prototype.mainError = function() {
    if (this._errors.length === 0) {
      return null;
    }
    var counts = {};
    var mainError = null;
    var mainErrorCount = 0;
    for (var i = 0;i < this._errors.length; i++) {
      var error3 = this._errors[i];
      var message = error3.message;
      var count = (counts[message] || 0) + 1;
      counts[message] = count;
      if (count >= mainErrorCount) {
        mainError = error3;
        mainErrorCount = count;
      }
    }
    return mainError;
  };
});

// ../node_modules/.bun/retry@0.13.1/node_modules/retry/lib/retry.js
var require_retry = __commonJS((exports) => {
  var RetryOperation = require_retry_operation();
  exports.operation = function(options) {
    var timeouts = exports.timeouts(options);
    return new RetryOperation(timeouts, {
      forever: options && (options.forever || options.retries === Infinity),
      unref: options && options.unref,
      maxRetryTime: options && options.maxRetryTime
    });
  };
  exports.timeouts = function(options) {
    if (options instanceof Array) {
      return [].concat(options);
    }
    var opts = {
      retries: 10,
      factor: 2,
      minTimeout: 1 * 1000,
      maxTimeout: Infinity,
      randomize: false
    };
    for (var key in options) {
      opts[key] = options[key];
    }
    if (opts.minTimeout > opts.maxTimeout) {
      throw new Error("minTimeout is greater than maxTimeout");
    }
    var timeouts = [];
    for (var i = 0;i < opts.retries; i++) {
      timeouts.push(this.createTimeout(i, opts));
    }
    if (options && options.forever && !timeouts.length) {
      timeouts.push(this.createTimeout(i, opts));
    }
    timeouts.sort(function(a, b) {
      return a - b;
    });
    return timeouts;
  };
  exports.createTimeout = function(attempt, opts) {
    var random = opts.randomize ? Math.random() + 1 : 1;
    var timeout = Math.round(random * Math.max(opts.minTimeout, 1) * Math.pow(opts.factor, attempt));
    timeout = Math.min(timeout, opts.maxTimeout);
    return timeout;
  };
  exports.wrap = function(obj, options, methods) {
    if (options instanceof Array) {
      methods = options;
      options = null;
    }
    if (!methods) {
      methods = [];
      for (var key in obj) {
        if (typeof obj[key] === "function") {
          methods.push(key);
        }
      }
    }
    for (var i = 0;i < methods.length; i++) {
      var method = methods[i];
      var original = obj[method];
      obj[method] = function retryWrapper(original2) {
        var op = exports.operation(options);
        var args = Array.prototype.slice.call(arguments, 1);
        var callback = args.pop();
        args.push(function(err) {
          if (op.retry(err)) {
            return;
          }
          if (err) {
            arguments[0] = op.mainError();
          }
          callback.apply(this, arguments);
        });
        op.attempt(function() {
          original2.apply(obj, args);
        });
      }.bind(obj, original);
      obj[method].options = options;
    }
  };
});

// ../node_modules/.bun/p-retry@4.6.2/node_modules/p-retry/index.js
var require_p_retry = __commonJS((exports, module) => {
  var retry = require_retry();
  var networkErrorMsgs = [
    "Failed to fetch",
    "NetworkError when attempting to fetch resource.",
    "The Internet connection appears to be offline.",
    "Network request failed"
  ];

  class AbortError extends Error {
    constructor(message) {
      super();
      if (message instanceof Error) {
        this.originalError = message;
        ({ message } = message);
      } else {
        this.originalError = new Error(message);
        this.originalError.stack = this.stack;
      }
      this.name = "AbortError";
      this.message = message;
    }
  }
  var decorateErrorWithCounts = (error3, attemptNumber, options) => {
    const retriesLeft = options.retries - (attemptNumber - 1);
    error3.attemptNumber = attemptNumber;
    error3.retriesLeft = retriesLeft;
    return error3;
  };
  var isNetworkError = (errorMessage) => networkErrorMsgs.includes(errorMessage);
  var pRetry = (input, options) => new Promise((resolve3, reject) => {
    options = {
      onFailedAttempt: () => {},
      retries: 10,
      ...options
    };
    const operation = retry.operation(options);
    operation.attempt(async (attemptNumber) => {
      try {
        resolve3(await input(attemptNumber));
      } catch (error3) {
        if (!(error3 instanceof Error)) {
          reject(new TypeError(`Non-error was thrown: "${error3}". You should only throw errors.`));
          return;
        }
        if (error3 instanceof AbortError) {
          operation.stop();
          reject(error3.originalError);
        } else if (error3 instanceof TypeError && !isNetworkError(error3.message)) {
          operation.stop();
          reject(error3);
        } else {
          decorateErrorWithCounts(error3, attemptNumber, options);
          try {
            await options.onFailedAttempt(error3);
          } catch (error4) {
            reject(error4);
            return;
          }
          if (!operation.retry(error3)) {
            reject(operation.mainError());
          }
        }
      }
    });
  });
  module.exports = pRetry;
  module.exports.default = pRetry;
  module.exports.AbortError = AbortError;
});

// ../node_modules/.bun/extend@3.0.2/node_modules/extend/index.js
var require_extend = __commonJS((exports, module) => {
  var hasOwn3 = Object.prototype.hasOwnProperty;
  var toStr = Object.prototype.toString;
  var defineProperty = Object.defineProperty;
  var gOPD = Object.getOwnPropertyDescriptor;
  var isArray3 = function isArray4(arr) {
    if (typeof Array.isArray === "function") {
      return Array.isArray(arr);
    }
    return toStr.call(arr) === "[object Array]";
  };
  var isPlainObject = function isPlainObject2(obj) {
    if (!obj || toStr.call(obj) !== "[object Object]") {
      return false;
    }
    var hasOwnConstructor = hasOwn3.call(obj, "constructor");
    var hasIsPrototypeOf = obj.constructor && obj.constructor.prototype && hasOwn3.call(obj.constructor.prototype, "isPrototypeOf");
    if (obj.constructor && !hasOwnConstructor && !hasIsPrototypeOf) {
      return false;
    }
    var key;
    for (key in obj) {}
    return typeof key === "undefined" || hasOwn3.call(obj, key);
  };
  var setProperty = function setProperty2(target, options) {
    if (defineProperty && options.name === "__proto__") {
      defineProperty(target, options.name, {
        enumerable: true,
        configurable: true,
        value: options.newValue,
        writable: true
      });
    } else {
      target[options.name] = options.newValue;
    }
  };
  var getProperty = function getProperty2(obj, name) {
    if (name === "__proto__") {
      if (!hasOwn3.call(obj, name)) {
        return;
      } else if (gOPD) {
        return gOPD(obj, name).value;
      }
    }
    return obj[name];
  };
  module.exports = function extend() {
    var options, name, src, copy, copyIsArray, clone;
    var target = arguments[0];
    var i = 1;
    var length = arguments.length;
    var deep = false;
    if (typeof target === "boolean") {
      deep = target;
      target = arguments[1] || {};
      i = 2;
    }
    if (target == null || typeof target !== "object" && typeof target !== "function") {
      target = {};
    }
    for (;i < length; ++i) {
      options = arguments[i];
      if (options != null) {
        for (name in options) {
          src = getProperty(target, name);
          copy = getProperty(options, name);
          if (target !== copy) {
            if (deep && copy && (isPlainObject(copy) || (copyIsArray = isArray3(copy)))) {
              if (copyIsArray) {
                copyIsArray = false;
                clone = src && isArray3(src) ? src : [];
              } else {
                clone = src && isPlainObject(src) ? src : {};
              }
              setProperty(target, { name, newValue: extend(deep, clone, copy) });
            } else if (typeof copy !== "undefined") {
              setProperty(target, { name, newValue: copy });
            }
          }
        }
      }
    }
    return target;
  };
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/package.json
var require_package = __commonJS((exports, module) => {
  module.exports = {
    name: "gaxios",
    version: "7.1.3",
    description: "A simple common HTTP client specifically for Google APIs and services.",
    main: "build/cjs/src/index.js",
    types: "build/cjs/src/index.d.ts",
    files: [
      "build/"
    ],
    exports: {
      ".": {
        import: {
          types: "./build/esm/src/index.d.ts",
          default: "./build/esm/src/index.js"
        },
        require: {
          types: "./build/cjs/src/index.d.ts",
          default: "./build/cjs/src/index.js"
        }
      }
    },
    scripts: {
      lint: "gts check --no-inline-config",
      test: "c8 mocha build/esm/test",
      "presystem-test": "npm run compile",
      "system-test": "mocha build/esm/system-test --timeout 80000",
      compile: "tsc -b ./tsconfig.json ./tsconfig.cjs.json && node utils/enable-esm.mjs",
      fix: "gts fix",
      prepare: "npm run compile",
      pretest: "npm run compile",
      webpack: "webpack",
      "prebrowser-test": "npm run compile",
      "browser-test": "node build/browser-test/browser-test-runner.js",
      docs: "jsdoc -c .jsdoc.js",
      "docs-test": "linkinator docs",
      "predocs-test": "npm run docs",
      "samples-test": "cd samples/ && npm link ../ && npm test && cd ../",
      prelint: "cd samples; npm link ../; npm install",
      clean: "gts clean"
    },
    repository: {
      type: "git",
      directory: "packages/gaxios",
      url: "https://github.com/googleapis/google-cloud-node-core.git"
    },
    keywords: [
      "google"
    ],
    engines: {
      node: ">=18"
    },
    author: "Google, LLC",
    license: "Apache-2.0",
    devDependencies: {
      "@babel/plugin-proposal-private-methods": "^7.18.6",
      "@types/cors": "^2.8.6",
      "@types/express": "^5.0.0",
      "@types/extend": "^3.0.1",
      "@types/mocha": "^10.0.10",
      "@types/multiparty": "4.2.1",
      "@types/mv": "^2.1.0",
      "@types/ncp": "^2.0.1",
      "@types/node": "^22.0.0",
      "@types/sinon": "^17.0.0",
      "@types/tmp": "0.2.6",
      assert: "^2.0.0",
      browserify: "^17.0.0",
      c8: "^10.0.0",
      cors: "^2.8.5",
      express: "^5.0.0",
      gts: "^6.0.0",
      "is-docker": "^3.0.0",
      jsdoc: "^4.0.0",
      "jsdoc-fresh": "^5.0.0",
      "jsdoc-region-tag": "^4.0.0",
      karma: "^6.0.0",
      "karma-chrome-launcher": "^3.0.0",
      "karma-coverage": "^2.0.0",
      "karma-firefox-launcher": "^2.0.0",
      "karma-mocha": "^2.0.0",
      "karma-remap-coverage": "^0.1.5",
      "karma-sourcemap-loader": "^0.4.0",
      "karma-webpack": "^5.0.1",
      linkinator: "^6.1.2",
      mocha: "^11.1.0",
      multiparty: "^4.2.1",
      mv: "^2.1.1",
      ncp: "^2.0.0",
      nock: "^14.0.0-beta.13",
      "null-loader": "^4.0.0",
      "pack-n-play": "^4.0.0",
      puppeteer: "^24.0.0",
      sinon: "^21.0.0",
      "stream-browserify": "^3.0.0",
      tmp: "0.2.5",
      "ts-loader": "^9.5.2",
      typescript: "^5.8.3",
      webpack: "^5.35.0",
      "webpack-cli": "^6.0.1"
    },
    dependencies: {
      extend: "^3.0.2",
      "https-proxy-agent": "^7.0.1",
      "node-fetch": "^3.3.2",
      rimraf: "^5.0.1"
    },
    homepage: "https://github.com/googleapis/google-cloud-node-core/tree/main/packages/gaxios"
  };
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/util.cjs
var require_util = __commonJS((exports, module) => {
  var pkg = require_package();
  module.exports = { pkg };
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/common.js
var require_common = __commonJS((exports) => {
  var __importDefault = exports && exports.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GaxiosError = exports.GAXIOS_ERROR_SYMBOL = undefined;
  exports.defaultErrorRedactor = defaultErrorRedactor;
  var extend_1 = __importDefault(require_extend());
  var util_cjs_1 = __importDefault(require_util());
  var pkg = util_cjs_1.default.pkg;
  exports.GAXIOS_ERROR_SYMBOL = Symbol.for(`${pkg.name}-gaxios-error`);

  class GaxiosError extends Error {
    config;
    response;
    code;
    status;
    error;
    [exports.GAXIOS_ERROR_SYMBOL] = pkg.version;
    static [Symbol.hasInstance](instance) {
      if (instance && typeof instance === "object" && exports.GAXIOS_ERROR_SYMBOL in instance && instance[exports.GAXIOS_ERROR_SYMBOL] === pkg.version) {
        return true;
      }
      return Function.prototype[Symbol.hasInstance].call(GaxiosError, instance);
    }
    constructor(message, config, response, cause) {
      super(message, { cause });
      this.config = config;
      this.response = response;
      this.error = cause instanceof Error ? cause : undefined;
      this.config = (0, extend_1.default)(true, {}, config);
      if (this.response) {
        this.response.config = (0, extend_1.default)(true, {}, this.response.config);
      }
      if (this.response) {
        try {
          this.response.data = translateData(this.config.responseType, this.response?.bodyUsed ? this.response?.data : undefined);
        } catch {}
        this.status = this.response.status;
      }
      if (cause instanceof DOMException) {
        this.code = cause.name;
      } else if (cause && typeof cause === "object" && "code" in cause && (typeof cause.code === "string" || typeof cause.code === "number")) {
        this.code = cause.code;
      }
    }
    static extractAPIErrorFromResponse(res, defaultErrorMessage = "The request failed") {
      let message = defaultErrorMessage;
      if (typeof res.data === "string") {
        message = res.data;
      }
      if (res.data && typeof res.data === "object" && "error" in res.data && res.data.error && !res.ok) {
        if (typeof res.data.error === "string") {
          return {
            message: res.data.error,
            code: res.status,
            status: res.statusText
          };
        }
        if (typeof res.data.error === "object") {
          message = "message" in res.data.error && typeof res.data.error.message === "string" ? res.data.error.message : message;
          const status = "status" in res.data.error && typeof res.data.error.status === "string" ? res.data.error.status : res.statusText;
          const code = "code" in res.data.error && typeof res.data.error.code === "number" ? res.data.error.code : res.status;
          if ("errors" in res.data.error && Array.isArray(res.data.error.errors)) {
            const errorMessages = [];
            for (const e of res.data.error.errors) {
              if (typeof e === "object" && "message" in e && typeof e.message === "string") {
                errorMessages.push(e.message);
              }
            }
            return Object.assign({
              message: errorMessages.join(`
`) || message,
              code,
              status
            }, res.data.error);
          }
          return Object.assign({
            message,
            code,
            status
          }, res.data.error);
        }
      }
      return {
        message,
        code: res.status,
        status: res.statusText
      };
    }
  }
  exports.GaxiosError = GaxiosError;
  function translateData(responseType, data) {
    switch (responseType) {
      case "stream":
        return data;
      case "json":
        return JSON.parse(JSON.stringify(data));
      case "arraybuffer":
        return JSON.parse(Buffer.from(data).toString("utf8"));
      case "blob":
        return JSON.parse(data.text());
      default:
        return data;
    }
  }
  function defaultErrorRedactor(data) {
    const REDACT = "<<REDACTED> - See `errorRedactor` option in `gaxios` for configuration>.";
    function redactHeaders(headers) {
      if (!headers)
        return;
      headers.forEach((_, key) => {
        if (/^authentication$/i.test(key) || /^authorization$/i.test(key) || /secret/i.test(key))
          headers.set(key, REDACT);
      });
    }
    function redactString(obj, key) {
      if (typeof obj === "object" && obj !== null && typeof obj[key] === "string") {
        const text = obj[key];
        if (/grant_type=/i.test(text) || /assertion=/i.test(text) || /secret/i.test(text)) {
          obj[key] = REDACT;
        }
      }
    }
    function redactObject(obj) {
      if (!obj || typeof obj !== "object") {
        return;
      } else if (obj instanceof FormData || obj instanceof URLSearchParams || "forEach" in obj && "set" in obj) {
        obj.forEach((_, key) => {
          if (["grant_type", "assertion"].includes(key) || /secret/.test(key)) {
            obj.set(key, REDACT);
          }
        });
      } else {
        if ("grant_type" in obj) {
          obj["grant_type"] = REDACT;
        }
        if ("assertion" in obj) {
          obj["assertion"] = REDACT;
        }
        if ("client_secret" in obj) {
          obj["client_secret"] = REDACT;
        }
      }
    }
    if (data.config) {
      redactHeaders(data.config.headers);
      redactString(data.config, "data");
      redactObject(data.config.data);
      redactString(data.config, "body");
      redactObject(data.config.body);
      if (data.config.url.searchParams.has("token")) {
        data.config.url.searchParams.set("token", REDACT);
      }
      if (data.config.url.searchParams.has("client_secret")) {
        data.config.url.searchParams.set("client_secret", REDACT);
      }
    }
    if (data.response) {
      defaultErrorRedactor({ config: data.response.config });
      redactHeaders(data.response.headers);
      if (data.response.bodyUsed) {
        redactString(data.response, "data");
        redactObject(data.response.data);
      }
    }
    return data;
  }
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/retry.js
var require_retry2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.getRetryConfig = getRetryConfig;
  async function getRetryConfig(err) {
    let config = getConfig(err);
    if (!err || !err.config || !config && !err.config.retry) {
      return { shouldRetry: false };
    }
    config = config || {};
    config.currentRetryAttempt = config.currentRetryAttempt || 0;
    config.retry = config.retry === undefined || config.retry === null ? 3 : config.retry;
    config.httpMethodsToRetry = config.httpMethodsToRetry || [
      "GET",
      "HEAD",
      "PUT",
      "OPTIONS",
      "DELETE"
    ];
    config.noResponseRetries = config.noResponseRetries === undefined || config.noResponseRetries === null ? 2 : config.noResponseRetries;
    config.retryDelayMultiplier = config.retryDelayMultiplier ? config.retryDelayMultiplier : 2;
    config.timeOfFirstRequest = config.timeOfFirstRequest ? config.timeOfFirstRequest : Date.now();
    config.totalTimeout = config.totalTimeout ? config.totalTimeout : Number.MAX_SAFE_INTEGER;
    config.maxRetryDelay = config.maxRetryDelay ? config.maxRetryDelay : Number.MAX_SAFE_INTEGER;
    const retryRanges = [
      [100, 199],
      [408, 408],
      [429, 429],
      [500, 599]
    ];
    config.statusCodesToRetry = config.statusCodesToRetry || retryRanges;
    err.config.retryConfig = config;
    const shouldRetryFn = config.shouldRetry || shouldRetryRequest;
    if (!await shouldRetryFn(err)) {
      return { shouldRetry: false, config: err.config };
    }
    const delay = getNextRetryDelay(config);
    err.config.retryConfig.currentRetryAttempt += 1;
    const backoff = config.retryBackoff ? config.retryBackoff(err, delay) : new Promise((resolve3) => {
      setTimeout(resolve3, delay);
    });
    if (config.onRetryAttempt) {
      await config.onRetryAttempt(err);
    }
    await backoff;
    return { shouldRetry: true, config: err.config };
  }
  function shouldRetryRequest(err) {
    const config = getConfig(err);
    if (err.config.signal?.aborted && err.code !== "TimeoutError" || err.code === "AbortError") {
      return false;
    }
    if (!config || config.retry === 0) {
      return false;
    }
    if (!err.response && (config.currentRetryAttempt || 0) >= config.noResponseRetries) {
      return false;
    }
    if (!config.httpMethodsToRetry || !config.httpMethodsToRetry.includes(err.config.method?.toUpperCase() || "GET")) {
      return false;
    }
    if (err.response && err.response.status) {
      let isInRange = false;
      for (const [min, max] of config.statusCodesToRetry) {
        const status = err.response.status;
        if (status >= min && status <= max) {
          isInRange = true;
          break;
        }
      }
      if (!isInRange) {
        return false;
      }
    }
    config.currentRetryAttempt = config.currentRetryAttempt || 0;
    if (config.currentRetryAttempt >= config.retry) {
      return false;
    }
    return true;
  }
  function getConfig(err) {
    if (err && err.config && err.config.retryConfig) {
      return err.config.retryConfig;
    }
    return;
  }
  function getNextRetryDelay(config) {
    const retryDelay = config.currentRetryAttempt ? 0 : config.retryDelay ?? 100;
    const calculatedDelay = retryDelay + (Math.pow(config.retryDelayMultiplier, config.currentRetryAttempt) - 1) / 2 * 1000;
    const maxAllowableDelay = config.totalTimeout - (Date.now() - config.timeOfFirstRequest);
    return Math.min(calculatedDelay, maxAllowableDelay, config.maxRetryDelay);
  }
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/interceptor.js
var require_interceptor = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GaxiosInterceptorManager = undefined;

  class GaxiosInterceptorManager extends Set {
  }
  exports.GaxiosInterceptorManager = GaxiosInterceptorManager;
});

// ../node_modules/.bun/ms@2.1.3/node_modules/ms/index.js
var require_ms = __commonJS((exports, module) => {
  var s = 1000;
  var m = s * 60;
  var h = m * 60;
  var d = h * 24;
  var w = d * 7;
  var y = d * 365.25;
  module.exports = function(val, options) {
    options = options || {};
    var type = typeof val;
    if (type === "string" && val.length > 0) {
      return parse(val);
    } else if (type === "number" && isFinite(val)) {
      return options.long ? fmtLong(val) : fmtShort(val);
    }
    throw new Error("val is not a non-empty string or a valid number. val=" + JSON.stringify(val));
  };
  function parse(str2) {
    str2 = String(str2);
    if (str2.length > 100) {
      return;
    }
    var match2 = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(str2);
    if (!match2) {
      return;
    }
    var n = parseFloat(match2[1]);
    var type = (match2[2] || "ms").toLowerCase();
    switch (type) {
      case "years":
      case "year":
      case "yrs":
      case "yr":
      case "y":
        return n * y;
      case "weeks":
      case "week":
      case "w":
        return n * w;
      case "days":
      case "day":
      case "d":
        return n * d;
      case "hours":
      case "hour":
      case "hrs":
      case "hr":
      case "h":
        return n * h;
      case "minutes":
      case "minute":
      case "mins":
      case "min":
      case "m":
        return n * m;
      case "seconds":
      case "second":
      case "secs":
      case "sec":
      case "s":
        return n * s;
      case "milliseconds":
      case "millisecond":
      case "msecs":
      case "msec":
      case "ms":
        return n;
      default:
        return;
    }
  }
  function fmtShort(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return Math.round(ms / d) + "d";
    }
    if (msAbs >= h) {
      return Math.round(ms / h) + "h";
    }
    if (msAbs >= m) {
      return Math.round(ms / m) + "m";
    }
    if (msAbs >= s) {
      return Math.round(ms / s) + "s";
    }
    return ms + "ms";
  }
  function fmtLong(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return plural(ms, msAbs, d, "day");
    }
    if (msAbs >= h) {
      return plural(ms, msAbs, h, "hour");
    }
    if (msAbs >= m) {
      return plural(ms, msAbs, m, "minute");
    }
    if (msAbs >= s) {
      return plural(ms, msAbs, s, "second");
    }
    return ms + " ms";
  }
  function plural(ms, msAbs, n, name) {
    var isPlural = msAbs >= n * 1.5;
    return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
  }
});

// ../node_modules/.bun/debug@4.4.3/node_modules/debug/src/common.js
var require_common2 = __commonJS((exports, module) => {
  function setup(env2) {
    createDebug.debug = createDebug;
    createDebug.default = createDebug;
    createDebug.coerce = coerce;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = require_ms();
    createDebug.destroy = destroy;
    Object.keys(env2).forEach((key) => {
      createDebug[key] = env2[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};
    function selectColor(namespace) {
      let hash2 = 0;
      for (let i = 0;i < namespace.length; i++) {
        hash2 = (hash2 << 5) - hash2 + namespace.charCodeAt(i);
        hash2 |= 0;
      }
      return createDebug.colors[Math.abs(hash2) % createDebug.colors.length];
    }
    createDebug.selectColor = selectColor;
    function createDebug(namespace) {
      let prevTime;
      let enableOverride = null;
      let namespacesCache;
      let enabledCache;
      function debug(...args) {
        if (!debug.enabled) {
          return;
        }
        const self2 = debug;
        const curr = Number(new Date);
        const ms = curr - (prevTime || curr);
        self2.diff = ms;
        self2.prev = prevTime;
        self2.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);
        if (typeof args[0] !== "string") {
          args.unshift("%O");
        }
        let index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, (match2, format) => {
          if (match2 === "%%") {
            return "%";
          }
          index++;
          const formatter = createDebug.formatters[format];
          if (typeof formatter === "function") {
            const val = args[index];
            match2 = formatter.call(self2, val);
            args.splice(index, 1);
            index--;
          }
          return match2;
        });
        createDebug.formatArgs.call(self2, args);
        const logFn = self2.log || createDebug.log;
        logFn.apply(self2, args);
      }
      debug.namespace = namespace;
      debug.useColors = createDebug.useColors();
      debug.color = createDebug.selectColor(namespace);
      debug.extend = extend;
      debug.destroy = createDebug.destroy;
      Object.defineProperty(debug, "enabled", {
        enumerable: true,
        configurable: false,
        get: () => {
          if (enableOverride !== null) {
            return enableOverride;
          }
          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }
          return enabledCache;
        },
        set: (v) => {
          enableOverride = v;
        }
      });
      if (typeof createDebug.init === "function") {
        createDebug.init(debug);
      }
      return debug;
    }
    function extend(namespace, delimiter) {
      const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
      newDebug.log = this.log;
      return newDebug;
    }
    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(/\s+/g, ",").split(",").filter(Boolean);
      for (const ns of split) {
        if (ns[0] === "-") {
          createDebug.skips.push(ns.slice(1));
        } else {
          createDebug.names.push(ns);
        }
      }
    }
    function matchesTemplate(search, template) {
      let searchIndex = 0;
      let templateIndex = 0;
      let starIndex = -1;
      let matchIndex = 0;
      while (searchIndex < search.length) {
        if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
          if (template[templateIndex] === "*") {
            starIndex = templateIndex;
            matchIndex = searchIndex;
            templateIndex++;
          } else {
            searchIndex++;
            templateIndex++;
          }
        } else if (starIndex !== -1) {
          templateIndex = starIndex + 1;
          matchIndex++;
          searchIndex = matchIndex;
        } else {
          return false;
        }
      }
      while (templateIndex < template.length && template[templateIndex] === "*") {
        templateIndex++;
      }
      return templateIndex === template.length;
    }
    function disable() {
      const namespaces = [
        ...createDebug.names,
        ...createDebug.skips.map((namespace) => "-" + namespace)
      ].join(",");
      createDebug.enable("");
      return namespaces;
    }
    function enabled(name) {
      for (const skip of createDebug.skips) {
        if (matchesTemplate(name, skip)) {
          return false;
        }
      }
      for (const ns of createDebug.names) {
        if (matchesTemplate(name, ns)) {
          return true;
        }
      }
      return false;
    }
    function coerce(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }
      return val;
    }
    function destroy() {
      console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
    }
    createDebug.enable(createDebug.load());
    return createDebug;
  }
  module.exports = setup;
});

// ../node_modules/.bun/debug@4.4.3/node_modules/debug/src/browser.js
var require_browser = __commonJS((exports, module) => {
  exports.formatArgs = formatArgs;
  exports.save = save;
  exports.load = load;
  exports.useColors = useColors;
  exports.storage = localstorage();
  exports.destroy = (() => {
    let warned = false;
    return () => {
      if (!warned) {
        warned = true;
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
    };
  })();
  exports.colors = [
    "#0000CC",
    "#0000FF",
    "#0033CC",
    "#0033FF",
    "#0066CC",
    "#0066FF",
    "#0099CC",
    "#0099FF",
    "#00CC00",
    "#00CC33",
    "#00CC66",
    "#00CC99",
    "#00CCCC",
    "#00CCFF",
    "#3300CC",
    "#3300FF",
    "#3333CC",
    "#3333FF",
    "#3366CC",
    "#3366FF",
    "#3399CC",
    "#3399FF",
    "#33CC00",
    "#33CC33",
    "#33CC66",
    "#33CC99",
    "#33CCCC",
    "#33CCFF",
    "#6600CC",
    "#6600FF",
    "#6633CC",
    "#6633FF",
    "#66CC00",
    "#66CC33",
    "#9900CC",
    "#9900FF",
    "#9933CC",
    "#9933FF",
    "#99CC00",
    "#99CC33",
    "#CC0000",
    "#CC0033",
    "#CC0066",
    "#CC0099",
    "#CC00CC",
    "#CC00FF",
    "#CC3300",
    "#CC3333",
    "#CC3366",
    "#CC3399",
    "#CC33CC",
    "#CC33FF",
    "#CC6600",
    "#CC6633",
    "#CC9900",
    "#CC9933",
    "#CCCC00",
    "#CCCC33",
    "#FF0000",
    "#FF0033",
    "#FF0066",
    "#FF0099",
    "#FF00CC",
    "#FF00FF",
    "#FF3300",
    "#FF3333",
    "#FF3366",
    "#FF3399",
    "#FF33CC",
    "#FF33FF",
    "#FF6600",
    "#FF6633",
    "#FF9900",
    "#FF9933",
    "#FFCC00",
    "#FFCC33"
  ];
  function useColors() {
    if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
      return true;
    }
    if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
      return false;
    }
    let m;
    return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== "undefined" && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31 || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
  }
  function formatArgs(args) {
    args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module.exports.humanize(this.diff);
    if (!this.useColors) {
      return;
    }
    const c = "color: " + this.color;
    args.splice(1, 0, c, "color: inherit");
    let index = 0;
    let lastC = 0;
    args[0].replace(/%[a-zA-Z%]/g, (match2) => {
      if (match2 === "%%") {
        return;
      }
      index++;
      if (match2 === "%c") {
        lastC = index;
      }
    });
    args.splice(lastC, 0, c);
  }
  exports.log = console.debug || console.log || (() => {});
  function save(namespaces) {
    try {
      if (namespaces) {
        exports.storage.setItem("debug", namespaces);
      } else {
        exports.storage.removeItem("debug");
      }
    } catch (error3) {}
  }
  function load() {
    let r;
    try {
      r = exports.storage.getItem("debug") || exports.storage.getItem("DEBUG");
    } catch (error3) {}
    if (!r && typeof process !== "undefined" && "env" in process) {
      r = process.env.DEBUG;
    }
    return r;
  }
  function localstorage() {
    try {
      return localStorage;
    } catch (error3) {}
  }
  module.exports = require_common2()(exports);
  var { formatters: formatters2 } = module.exports;
  formatters2.j = function(v) {
    try {
      return JSON.stringify(v);
    } catch (error3) {
      return "[UnexpectedJSONParseError]: " + error3.message;
    }
  };
});

// ../node_modules/.bun/debug@4.4.3/node_modules/debug/src/node.js
var require_node = __commonJS((exports, module) => {
  var tty = __require("tty");
  var util = __require("util");
  exports.init = init;
  exports.log = log2;
  exports.formatArgs = formatArgs;
  exports.save = save;
  exports.load = load;
  exports.useColors = useColors;
  exports.destroy = util.deprecate(() => {}, "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
  exports.colors = [6, 2, 3, 4, 5, 1];
  try {
    const supportsColor = (()=>{throw new Error("Cannot require module "+"supports-color");})();
    if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
      exports.colors = [
        20,
        21,
        26,
        27,
        32,
        33,
        38,
        39,
        40,
        41,
        42,
        43,
        44,
        45,
        56,
        57,
        62,
        63,
        68,
        69,
        74,
        75,
        76,
        77,
        78,
        79,
        80,
        81,
        92,
        93,
        98,
        99,
        112,
        113,
        128,
        129,
        134,
        135,
        148,
        149,
        160,
        161,
        162,
        163,
        164,
        165,
        166,
        167,
        168,
        169,
        170,
        171,
        172,
        173,
        178,
        179,
        184,
        185,
        196,
        197,
        198,
        199,
        200,
        201,
        202,
        203,
        204,
        205,
        206,
        207,
        208,
        209,
        214,
        215,
        220,
        221
      ];
    }
  } catch (error3) {}
  exports.inspectOpts = Object.keys(process.env).filter((key) => {
    return /^debug_/i.test(key);
  }).reduce((obj, key) => {
    const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
      return k.toUpperCase();
    });
    let val = process.env[key];
    if (/^(yes|on|true|enabled)$/i.test(val)) {
      val = true;
    } else if (/^(no|off|false|disabled)$/i.test(val)) {
      val = false;
    } else if (val === "null") {
      val = null;
    } else {
      val = Number(val);
    }
    obj[prop] = val;
    return obj;
  }, {});
  function useColors() {
    return "colors" in exports.inspectOpts ? Boolean(exports.inspectOpts.colors) : tty.isatty(process.stderr.fd);
  }
  function formatArgs(args) {
    const { namespace: name, useColors: useColors2 } = this;
    if (useColors2) {
      const c = this.color;
      const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
      const prefix = `  ${colorCode};1m${name} \x1B[0m`;
      args[0] = prefix + args[0].split(`
`).join(`
` + prefix);
      args.push(colorCode + "m+" + module.exports.humanize(this.diff) + "\x1B[0m");
    } else {
      args[0] = getDate() + name + " " + args[0];
    }
  }
  function getDate() {
    if (exports.inspectOpts.hideDate) {
      return "";
    }
    return new Date().toISOString() + " ";
  }
  function log2(...args) {
    return process.stderr.write(util.formatWithOptions(exports.inspectOpts, ...args) + `
`);
  }
  function save(namespaces) {
    if (namespaces) {
      process.env.DEBUG = namespaces;
    } else {
      delete process.env.DEBUG;
    }
  }
  function load() {
    return process.env.DEBUG;
  }
  function init(debug) {
    debug.inspectOpts = {};
    const keys = Object.keys(exports.inspectOpts);
    for (let i = 0;i < keys.length; i++) {
      debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
    }
  }
  module.exports = require_common2()(exports);
  var { formatters: formatters2 } = module.exports;
  formatters2.o = function(v) {
    this.inspectOpts.colors = this.useColors;
    return util.inspect(v, this.inspectOpts).split(`
`).map((str2) => str2.trim()).join(" ");
  };
  formatters2.O = function(v) {
    this.inspectOpts.colors = this.useColors;
    return util.inspect(v, this.inspectOpts);
  };
});

// ../node_modules/.bun/debug@4.4.3/node_modules/debug/src/index.js
var require_src = __commonJS((exports, module) => {
  if (typeof process === "undefined" || process.type === "renderer" || false || process.__nwjs) {
    module.exports = require_browser();
  } else {
    module.exports = require_node();
  }
});

// ../node_modules/.bun/agent-base@7.1.4/node_modules/agent-base/dist/helpers.js
var require_helpers = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = exports && exports.__importStar || function(mod) {
    if (mod && mod.__esModule)
      return mod;
    var result = {};
    if (mod != null) {
      for (var k in mod)
        if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    }
    __setModuleDefault(result, mod);
    return result;
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.req = exports.json = exports.toBuffer = undefined;
  var http = __importStar(__require("http"));
  var https = __importStar(__require("https"));
  async function toBuffer(stream) {
    let length = 0;
    const chunks = [];
    for await (const chunk of stream) {
      length += chunk.length;
      chunks.push(chunk);
    }
    return Buffer.concat(chunks, length);
  }
  exports.toBuffer = toBuffer;
  async function json(stream) {
    const buf = await toBuffer(stream);
    const str2 = buf.toString("utf8");
    try {
      return JSON.parse(str2);
    } catch (_err) {
      const err = _err;
      err.message += ` (input: ${str2})`;
      throw err;
    }
  }
  exports.json = json;
  function req(url, opts = {}) {
    const href = typeof url === "string" ? url : url.href;
    const req2 = (href.startsWith("https:") ? https : http).request(url, opts);
    const promise = new Promise((resolve3, reject) => {
      req2.once("response", resolve3).once("error", reject).end();
    });
    req2.then = promise.then.bind(promise);
    return req2;
  }
  exports.req = req;
});

// ../node_modules/.bun/agent-base@7.1.4/node_modules/agent-base/dist/index.js
var require_dist2 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = exports && exports.__importStar || function(mod) {
    if (mod && mod.__esModule)
      return mod;
    var result = {};
    if (mod != null) {
      for (var k in mod)
        if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    }
    __setModuleDefault(result, mod);
    return result;
  };
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Agent = undefined;
  var net = __importStar(__require("net"));
  var http = __importStar(__require("http"));
  var https_1 = __require("https");
  __exportStar(require_helpers(), exports);
  var INTERNAL = Symbol("AgentBaseInternalState");

  class Agent extends http.Agent {
    constructor(opts) {
      super(opts);
      this[INTERNAL] = {};
    }
    isSecureEndpoint(options) {
      if (options) {
        if (typeof options.secureEndpoint === "boolean") {
          return options.secureEndpoint;
        }
        if (typeof options.protocol === "string") {
          return options.protocol === "https:";
        }
      }
      const { stack } = new Error;
      if (typeof stack !== "string")
        return false;
      return stack.split(`
`).some((l) => l.indexOf("(https.js:") !== -1 || l.indexOf("node:https:") !== -1);
    }
    incrementSockets(name) {
      if (this.maxSockets === Infinity && this.maxTotalSockets === Infinity) {
        return null;
      }
      if (!this.sockets[name]) {
        this.sockets[name] = [];
      }
      const fakeSocket = new net.Socket({ writable: false });
      this.sockets[name].push(fakeSocket);
      this.totalSocketCount++;
      return fakeSocket;
    }
    decrementSockets(name, socket) {
      if (!this.sockets[name] || socket === null) {
        return;
      }
      const sockets = this.sockets[name];
      const index = sockets.indexOf(socket);
      if (index !== -1) {
        sockets.splice(index, 1);
        this.totalSocketCount--;
        if (sockets.length === 0) {
          delete this.sockets[name];
        }
      }
    }
    getName(options) {
      const secureEndpoint = this.isSecureEndpoint(options);
      if (secureEndpoint) {
        return https_1.Agent.prototype.getName.call(this, options);
      }
      return super.getName(options);
    }
    createSocket(req, options, cb) {
      const connectOpts = {
        ...options,
        secureEndpoint: this.isSecureEndpoint(options)
      };
      const name = this.getName(connectOpts);
      const fakeSocket = this.incrementSockets(name);
      Promise.resolve().then(() => this.connect(req, connectOpts)).then((socket) => {
        this.decrementSockets(name, fakeSocket);
        if (socket instanceof http.Agent) {
          try {
            return socket.addRequest(req, connectOpts);
          } catch (err) {
            return cb(err);
          }
        }
        this[INTERNAL].currentSocket = socket;
        super.createSocket(req, options, cb);
      }, (err) => {
        this.decrementSockets(name, fakeSocket);
        cb(err);
      });
    }
    createConnection() {
      const socket = this[INTERNAL].currentSocket;
      this[INTERNAL].currentSocket = undefined;
      if (!socket) {
        throw new Error("No socket was returned in the `connect()` function");
      }
      return socket;
    }
    get defaultPort() {
      return this[INTERNAL].defaultPort ?? (this.protocol === "https:" ? 443 : 80);
    }
    set defaultPort(v) {
      if (this[INTERNAL]) {
        this[INTERNAL].defaultPort = v;
      }
    }
    get protocol() {
      return this[INTERNAL].protocol ?? (this.isSecureEndpoint() ? "https:" : "http:");
    }
    set protocol(v) {
      if (this[INTERNAL]) {
        this[INTERNAL].protocol = v;
      }
    }
  }
  exports.Agent = Agent;
});

// ../node_modules/.bun/https-proxy-agent@7.0.6/node_modules/https-proxy-agent/dist/parse-proxy-response.js
var require_parse_proxy_response = __commonJS((exports) => {
  var __importDefault = exports && exports.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.parseProxyResponse = undefined;
  var debug_1 = __importDefault(require_src());
  var debug = (0, debug_1.default)("https-proxy-agent:parse-proxy-response");
  function parseProxyResponse(socket) {
    return new Promise((resolve3, reject) => {
      let buffersLength = 0;
      const buffers = [];
      function read() {
        const b = socket.read();
        if (b)
          ondata(b);
        else
          socket.once("readable", read);
      }
      function cleanup() {
        socket.removeListener("end", onend);
        socket.removeListener("error", onerror);
        socket.removeListener("readable", read);
      }
      function onend() {
        cleanup();
        debug("onend");
        reject(new Error("Proxy connection ended before receiving CONNECT response"));
      }
      function onerror(err) {
        cleanup();
        debug("onerror %o", err);
        reject(err);
      }
      function ondata(b) {
        buffers.push(b);
        buffersLength += b.length;
        const buffered = Buffer.concat(buffers, buffersLength);
        const endOfHeaders = buffered.indexOf(`\r
\r
`);
        if (endOfHeaders === -1) {
          debug("have not received end of HTTP headers yet...");
          read();
          return;
        }
        const headerParts = buffered.slice(0, endOfHeaders).toString("ascii").split(`\r
`);
        const firstLine = headerParts.shift();
        if (!firstLine) {
          socket.destroy();
          return reject(new Error("No header received from proxy CONNECT response"));
        }
        const firstLineParts = firstLine.split(" ");
        const statusCode = +firstLineParts[1];
        const statusText = firstLineParts.slice(2).join(" ");
        const headers = {};
        for (const header of headerParts) {
          if (!header)
            continue;
          const firstColon = header.indexOf(":");
          if (firstColon === -1) {
            socket.destroy();
            return reject(new Error(`Invalid header from proxy CONNECT response: "${header}"`));
          }
          const key = header.slice(0, firstColon).toLowerCase();
          const value = header.slice(firstColon + 1).trimStart();
          const current = headers[key];
          if (typeof current === "string") {
            headers[key] = [current, value];
          } else if (Array.isArray(current)) {
            current.push(value);
          } else {
            headers[key] = value;
          }
        }
        debug("got proxy server response: %o %o", firstLine, headers);
        cleanup();
        resolve3({
          connect: {
            statusCode,
            statusText,
            headers
          },
          buffered
        });
      }
      socket.on("error", onerror);
      socket.on("end", onend);
      read();
    });
  }
  exports.parseProxyResponse = parseProxyResponse;
});

// ../node_modules/.bun/https-proxy-agent@7.0.6/node_modules/https-proxy-agent/dist/index.js
var require_dist3 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = exports && exports.__importStar || function(mod) {
    if (mod && mod.__esModule)
      return mod;
    var result = {};
    if (mod != null) {
      for (var k in mod)
        if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    }
    __setModuleDefault(result, mod);
    return result;
  };
  var __importDefault = exports && exports.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.HttpsProxyAgent = undefined;
  var net = __importStar(__require("net"));
  var tls = __importStar(__require("tls"));
  var assert_1 = __importDefault(__require("assert"));
  var debug_1 = __importDefault(require_src());
  var agent_base_1 = require_dist2();
  var url_1 = __require("url");
  var parse_proxy_response_1 = require_parse_proxy_response();
  var debug = (0, debug_1.default)("https-proxy-agent");
  var setServernameFromNonIpHost = (options) => {
    if (options.servername === undefined && options.host && !net.isIP(options.host)) {
      return {
        ...options,
        servername: options.host
      };
    }
    return options;
  };

  class HttpsProxyAgent extends agent_base_1.Agent {
    constructor(proxy, opts) {
      super(opts);
      this.options = { path: undefined };
      this.proxy = typeof proxy === "string" ? new url_1.URL(proxy) : proxy;
      this.proxyHeaders = opts?.headers ?? {};
      debug("Creating new HttpsProxyAgent instance: %o", this.proxy.href);
      const host = (this.proxy.hostname || this.proxy.host).replace(/^\[|\]$/g, "");
      const port = this.proxy.port ? parseInt(this.proxy.port, 10) : this.proxy.protocol === "https:" ? 443 : 80;
      this.connectOpts = {
        ALPNProtocols: ["http/1.1"],
        ...opts ? omit(opts, "headers") : null,
        host,
        port
      };
    }
    async connect(req, opts) {
      const { proxy } = this;
      if (!opts.host) {
        throw new TypeError('No "host" provided');
      }
      let socket;
      if (proxy.protocol === "https:") {
        debug("Creating `tls.Socket`: %o", this.connectOpts);
        socket = tls.connect(setServernameFromNonIpHost(this.connectOpts));
      } else {
        debug("Creating `net.Socket`: %o", this.connectOpts);
        socket = net.connect(this.connectOpts);
      }
      const headers = typeof this.proxyHeaders === "function" ? this.proxyHeaders() : { ...this.proxyHeaders };
      const host = net.isIPv6(opts.host) ? `[${opts.host}]` : opts.host;
      let payload = `CONNECT ${host}:${opts.port} HTTP/1.1\r
`;
      if (proxy.username || proxy.password) {
        const auth = `${decodeURIComponent(proxy.username)}:${decodeURIComponent(proxy.password)}`;
        headers["Proxy-Authorization"] = `Basic ${Buffer.from(auth).toString("base64")}`;
      }
      headers.Host = `${host}:${opts.port}`;
      if (!headers["Proxy-Connection"]) {
        headers["Proxy-Connection"] = this.keepAlive ? "Keep-Alive" : "close";
      }
      for (const name of Object.keys(headers)) {
        payload += `${name}: ${headers[name]}\r
`;
      }
      const proxyResponsePromise = (0, parse_proxy_response_1.parseProxyResponse)(socket);
      socket.write(`${payload}\r
`);
      const { connect, buffered } = await proxyResponsePromise;
      req.emit("proxyConnect", connect);
      this.emit("proxyConnect", connect, req);
      if (connect.statusCode === 200) {
        req.once("socket", resume);
        if (opts.secureEndpoint) {
          debug("Upgrading socket connection to TLS");
          return tls.connect({
            ...omit(setServernameFromNonIpHost(opts), "host", "path", "port"),
            socket
          });
        }
        return socket;
      }
      socket.destroy();
      const fakeSocket = new net.Socket({ writable: false });
      fakeSocket.readable = true;
      req.once("socket", (s) => {
        debug("Replaying proxy buffer for failed request");
        (0, assert_1.default)(s.listenerCount("data") > 0);
        s.push(buffered);
        s.push(null);
      });
      return fakeSocket;
    }
  }
  HttpsProxyAgent.protocols = ["http", "https"];
  exports.HttpsProxyAgent = HttpsProxyAgent;
  function resume(socket) {
    socket.resume();
  }
  function omit(obj, ...keys) {
    const ret = {};
    let key;
    for (key in obj) {
      if (!keys.includes(key)) {
        ret[key] = obj[key];
      }
    }
    return ret;
  }
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/gaxios.js
var require_gaxios = __commonJS((exports) => {
  var __importDefault = exports && exports.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
  var _a4;
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Gaxios = undefined;
  var extend_1 = __importDefault(require_extend());
  var https_1 = __require("https");
  var common_js_1 = require_common();
  var retry_js_1 = require_retry2();
  var stream_1 = __require("stream");
  var interceptor_js_1 = require_interceptor();
  var randomUUID = async () => globalThis.crypto?.randomUUID() || (await import("crypto")).randomUUID();
  var HTTP_STATUS_NO_CONTENT = 204;

  class Gaxios {
    agentCache = new Map;
    defaults;
    interceptors;
    constructor(defaults2) {
      this.defaults = defaults2 || {};
      this.interceptors = {
        request: new interceptor_js_1.GaxiosInterceptorManager,
        response: new interceptor_js_1.GaxiosInterceptorManager
      };
    }
    fetch(...args) {
      const input = args[0];
      const init = args[1];
      let url = undefined;
      const headers = new Headers;
      if (typeof input === "string") {
        url = new URL(input);
      } else if (input instanceof URL) {
        url = input;
      } else if (input && input.url) {
        url = new URL(input.url);
      }
      if (input && typeof input === "object" && "headers" in input) {
        _a4.mergeHeaders(headers, input.headers);
      }
      if (init) {
        _a4.mergeHeaders(headers, new Headers(init.headers));
      }
      if (typeof input === "object" && !(input instanceof URL)) {
        return this.request({ ...init, ...input, headers, url });
      } else {
        return this.request({ ...init, headers, url });
      }
    }
    async request(opts = {}) {
      let prepared = await this.#prepareRequest(opts);
      prepared = await this.#applyRequestInterceptors(prepared);
      return this.#applyResponseInterceptors(this._request(prepared));
    }
    async _defaultAdapter(config) {
      const fetchImpl = config.fetchImplementation || this.defaults.fetchImplementation || await _a4.#getFetch();
      const preparedOpts = { ...config };
      delete preparedOpts.data;
      const res = await fetchImpl(config.url, preparedOpts);
      const data = await this.getResponseData(config, res);
      if (!Object.getOwnPropertyDescriptor(res, "data")?.configurable) {
        Object.defineProperties(res, {
          data: {
            configurable: true,
            writable: true,
            enumerable: true,
            value: data
          }
        });
      }
      return Object.assign(res, { config, data });
    }
    async _request(opts) {
      try {
        let translatedResponse;
        if (opts.adapter) {
          translatedResponse = await opts.adapter(opts, this._defaultAdapter.bind(this));
        } else {
          translatedResponse = await this._defaultAdapter(opts);
        }
        if (!opts.validateStatus(translatedResponse.status)) {
          if (opts.responseType === "stream") {
            const response = [];
            for await (const chunk of translatedResponse.data) {
              response.push(chunk);
            }
            translatedResponse.data = response.toString();
          }
          const errorInfo = common_js_1.GaxiosError.extractAPIErrorFromResponse(translatedResponse, `Request failed with status code ${translatedResponse.status}`);
          throw new common_js_1.GaxiosError(errorInfo?.message, opts, translatedResponse, errorInfo);
        }
        return translatedResponse;
      } catch (e) {
        let err;
        if (e instanceof common_js_1.GaxiosError) {
          err = e;
        } else if (e instanceof Error) {
          err = new common_js_1.GaxiosError(e.message, opts, undefined, e);
        } else {
          err = new common_js_1.GaxiosError("Unexpected Gaxios Error", opts, undefined, e);
        }
        const { shouldRetry, config } = await (0, retry_js_1.getRetryConfig)(err);
        if (shouldRetry && config) {
          err.config.retryConfig.currentRetryAttempt = config.retryConfig.currentRetryAttempt;
          opts.retryConfig = err.config?.retryConfig;
          this.#appendTimeoutToSignal(opts);
          return this._request(opts);
        }
        if (opts.errorRedactor) {
          opts.errorRedactor(err);
        }
        throw err;
      }
    }
    async getResponseData(opts, res) {
      if (res.status === HTTP_STATUS_NO_CONTENT) {
        return "";
      }
      if (opts.maxContentLength && res.headers.has("content-length") && opts.maxContentLength < Number.parseInt(res.headers?.get("content-length") || "")) {
        throw new common_js_1.GaxiosError("Response's `Content-Length` is over the limit.", opts, Object.assign(res, { config: opts }));
      }
      switch (opts.responseType) {
        case "stream":
          return res.body;
        case "json": {
          const data = await res.text();
          try {
            return JSON.parse(data);
          } catch {
            return data;
          }
        }
        case "arraybuffer":
          return res.arrayBuffer();
        case "blob":
          return res.blob();
        case "text":
          return res.text();
        default:
          return this.getResponseDataFromContentType(res);
      }
    }
    #urlMayUseProxy(url, noProxy = []) {
      const candidate = new URL(url);
      const noProxyList = [...noProxy];
      const noProxyEnvList = (process.env.NO_PROXY ?? process.env.no_proxy)?.split(",") || [];
      for (const rule of noProxyEnvList) {
        noProxyList.push(rule.trim());
      }
      for (const rule of noProxyList) {
        if (rule instanceof RegExp) {
          if (rule.test(candidate.toString())) {
            return false;
          }
        } else if (rule instanceof URL) {
          if (rule.origin === candidate.origin) {
            return false;
          }
        } else if (rule.startsWith("*.") || rule.startsWith(".")) {
          const cleanedRule = rule.replace(/^\*\./, ".");
          if (candidate.hostname.endsWith(cleanedRule)) {
            return false;
          }
        } else if (rule === candidate.origin || rule === candidate.hostname || rule === candidate.href) {
          return false;
        }
      }
      return true;
    }
    async#applyRequestInterceptors(options) {
      let promiseChain = Promise.resolve(options);
      for (const interceptor of this.interceptors.request.values()) {
        if (interceptor) {
          promiseChain = promiseChain.then(interceptor.resolved, interceptor.rejected);
        }
      }
      return promiseChain;
    }
    async#applyResponseInterceptors(response) {
      let promiseChain = Promise.resolve(response);
      for (const interceptor of this.interceptors.response.values()) {
        if (interceptor) {
          promiseChain = promiseChain.then(interceptor.resolved, interceptor.rejected);
        }
      }
      return promiseChain;
    }
    async#prepareRequest(options) {
      const preparedHeaders = new Headers(this.defaults.headers);
      _a4.mergeHeaders(preparedHeaders, options.headers);
      const opts = (0, extend_1.default)(true, {}, this.defaults, options);
      if (!opts.url) {
        throw new Error("URL is required.");
      }
      if (opts.baseURL) {
        opts.url = new URL(opts.url, opts.baseURL);
      }
      opts.url = new URL(opts.url);
      if (opts.params) {
        if (opts.paramsSerializer) {
          let additionalQueryParams = opts.paramsSerializer(opts.params);
          if (additionalQueryParams.startsWith("?")) {
            additionalQueryParams = additionalQueryParams.slice(1);
          }
          const prefix = opts.url.toString().includes("?") ? "&" : "?";
          opts.url = opts.url + prefix + additionalQueryParams;
        } else {
          const url = opts.url instanceof URL ? opts.url : new URL(opts.url);
          for (const [key, value] of new URLSearchParams(opts.params)) {
            url.searchParams.append(key, value);
          }
          opts.url = url;
        }
      }
      if (typeof options.maxContentLength === "number") {
        opts.size = options.maxContentLength;
      }
      if (typeof options.maxRedirects === "number") {
        opts.follow = options.maxRedirects;
      }
      const shouldDirectlyPassData = typeof opts.data === "string" || opts.data instanceof ArrayBuffer || opts.data instanceof Blob || globalThis.File && opts.data instanceof File || opts.data instanceof FormData || opts.data instanceof stream_1.Readable || opts.data instanceof ReadableStream || opts.data instanceof String || opts.data instanceof URLSearchParams || ArrayBuffer.isView(opts.data) || ["Blob", "File", "FormData"].includes(opts.data?.constructor?.name || "");
      if (opts.multipart?.length) {
        const boundary = await randomUUID();
        preparedHeaders.set("content-type", `multipart/related; boundary=${boundary}`);
        opts.body = stream_1.Readable.from(this.getMultipartRequest(opts.multipart, boundary));
      } else if (shouldDirectlyPassData) {
        opts.body = opts.data;
      } else if (typeof opts.data === "object") {
        if (preparedHeaders.get("Content-Type") === "application/x-www-form-urlencoded") {
          opts.body = opts.paramsSerializer ? opts.paramsSerializer(opts.data) : new URLSearchParams(opts.data);
        } else {
          if (!preparedHeaders.has("content-type")) {
            preparedHeaders.set("content-type", "application/json");
          }
          opts.body = JSON.stringify(opts.data);
        }
      } else if (opts.data) {
        opts.body = opts.data;
      }
      opts.validateStatus = opts.validateStatus || this.validateStatus;
      opts.responseType = opts.responseType || "unknown";
      if (!preparedHeaders.has("accept") && opts.responseType === "json") {
        preparedHeaders.set("accept", "application/json");
      }
      const proxy = opts.proxy || process?.env?.HTTPS_PROXY || process?.env?.https_proxy || process?.env?.HTTP_PROXY || process?.env?.http_proxy;
      if (opts.agent) {} else if (proxy && this.#urlMayUseProxy(opts.url, opts.noProxy)) {
        const HttpsProxyAgent = await _a4.#getProxyAgent();
        if (this.agentCache.has(proxy)) {
          opts.agent = this.agentCache.get(proxy);
        } else {
          opts.agent = new HttpsProxyAgent(proxy, {
            cert: opts.cert,
            key: opts.key
          });
          this.agentCache.set(proxy, opts.agent);
        }
      } else if (opts.cert && opts.key) {
        if (this.agentCache.has(opts.key)) {
          opts.agent = this.agentCache.get(opts.key);
        } else {
          opts.agent = new https_1.Agent({
            cert: opts.cert,
            key: opts.key
          });
          this.agentCache.set(opts.key, opts.agent);
        }
      }
      if (typeof opts.errorRedactor !== "function" && opts.errorRedactor !== false) {
        opts.errorRedactor = common_js_1.defaultErrorRedactor;
      }
      if (opts.body && !("duplex" in opts)) {
        opts.duplex = "half";
      }
      this.#appendTimeoutToSignal(opts);
      return Object.assign(opts, {
        headers: preparedHeaders,
        url: opts.url instanceof URL ? opts.url : new URL(opts.url)
      });
    }
    #appendTimeoutToSignal(opts) {
      if (opts.timeout) {
        const timeoutSignal = AbortSignal.timeout(opts.timeout);
        if (opts.signal && !opts.signal.aborted) {
          opts.signal = AbortSignal.any([opts.signal, timeoutSignal]);
        } else {
          opts.signal = timeoutSignal;
        }
      }
    }
    validateStatus(status) {
      return status >= 200 && status < 300;
    }
    async getResponseDataFromContentType(response) {
      let contentType = response.headers.get("Content-Type");
      if (contentType === null) {
        return response.text();
      }
      contentType = contentType.toLowerCase();
      if (contentType.includes("application/json")) {
        let data = await response.text();
        try {
          data = JSON.parse(data);
        } catch {}
        return data;
      } else if (contentType.match(/^text\//)) {
        return response.text();
      } else {
        return response.blob();
      }
    }
    async* getMultipartRequest(multipartOptions, boundary) {
      const finale = `--${boundary}--`;
      for (const currentPart of multipartOptions) {
        const partContentType = currentPart.headers.get("Content-Type") || "application/octet-stream";
        const preamble = `--${boundary}\r
Content-Type: ${partContentType}\r
\r
`;
        yield preamble;
        if (typeof currentPart.content === "string") {
          yield currentPart.content;
        } else {
          yield* currentPart.content;
        }
        yield `\r
`;
      }
      yield finale;
    }
    static #proxyAgent;
    static #fetch;
    static async#getProxyAgent() {
      this.#proxyAgent ||= (await Promise.resolve().then(() => __toESM(require_dist3()))).HttpsProxyAgent;
      return this.#proxyAgent;
    }
    static async#getFetch() {
      const hasWindow = typeof window !== "undefined" && !!window;
      this.#fetch ||= hasWindow ? window.fetch : (await import("node-fetch")).default;
      return this.#fetch;
    }
    static mergeHeaders(base, ...append) {
      base = base instanceof Headers ? base : new Headers(base);
      for (const headers of append) {
        const add = headers instanceof Headers ? headers : new Headers(headers);
        add.forEach((value, key) => {
          key === "set-cookie" ? base.append(key, value) : base.set(key, value);
        });
      }
      return base;
    }
  }
  exports.Gaxios = Gaxios;
  _a4 = Gaxios;
});

// ../node_modules/.bun/gaxios@7.1.3/node_modules/gaxios/build/cjs/src/index.js
var require_src2 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.instance = exports.Gaxios = exports.GaxiosError = undefined;
  exports.request = request;
  var gaxios_js_1 = require_gaxios();
  Object.defineProperty(exports, "Gaxios", { enumerable: true, get: function() {
    return gaxios_js_1.Gaxios;
  } });
  var common_js_1 = require_common();
  Object.defineProperty(exports, "GaxiosError", { enumerable: true, get: function() {
    return common_js_1.GaxiosError;
  } });
  __exportStar(require_interceptor(), exports);
  exports.instance = new gaxios_js_1.Gaxios;
  async function request(opts) {
    return exports.instance.request(opts);
  }
});

// ../node_modules/.bun/bignumber.js@9.3.1/node_modules/bignumber.js/bignumber.js
var require_bignumber = __commonJS((exports, module) => {
  (function(globalObject) {
    var BigNumber, isNumeric = /^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i, mathceil = Math.ceil, mathfloor = Math.floor, bignumberError = "[BigNumber Error] ", tooManyDigits = bignumberError + "Number primitive has more than 15 significant digits: ", BASE = 100000000000000, LOG_BASE = 14, MAX_SAFE_INTEGER = 9007199254740991, POWS_TEN = [1, 10, 100, 1000, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 10000000000, 100000000000, 1000000000000, 10000000000000], SQRT_BASE = 1e7, MAX = 1e9;
    function clone(configObject) {
      var div, convertBase, parseNumeric, P = BigNumber2.prototype = { constructor: BigNumber2, toString: null, valueOf: null }, ONE = new BigNumber2(1), DECIMAL_PLACES = 20, ROUNDING_MODE = 4, TO_EXP_NEG = -7, TO_EXP_POS = 21, MIN_EXP = -1e7, MAX_EXP = 1e7, CRYPTO = false, MODULO_MODE = 1, POW_PRECISION = 0, FORMAT = {
        prefix: "",
        groupSize: 3,
        secondaryGroupSize: 0,
        groupSeparator: ",",
        decimalSeparator: ".",
        fractionGroupSize: 0,
        fractionGroupSeparator: "\xA0",
        suffix: ""
      }, ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz", alphabetHasNormalDecimalDigits = true;
      function BigNumber2(v, b) {
        var alphabet, c, caseChanged, e, i, isNum, len, str2, x = this;
        if (!(x instanceof BigNumber2))
          return new BigNumber2(v, b);
        if (b == null) {
          if (v && v._isBigNumber === true) {
            x.s = v.s;
            if (!v.c || v.e > MAX_EXP) {
              x.c = x.e = null;
            } else if (v.e < MIN_EXP) {
              x.c = [x.e = 0];
            } else {
              x.e = v.e;
              x.c = v.c.slice();
            }
            return;
          }
          if ((isNum = typeof v == "number") && v * 0 == 0) {
            x.s = 1 / v < 0 ? (v = -v, -1) : 1;
            if (v === ~~v) {
              for (e = 0, i = v;i >= 10; i /= 10, e++)
                ;
              if (e > MAX_EXP) {
                x.c = x.e = null;
              } else {
                x.e = e;
                x.c = [v];
              }
              return;
            }
            str2 = String(v);
          } else {
            if (!isNumeric.test(str2 = String(v)))
              return parseNumeric(x, str2, isNum);
            x.s = str2.charCodeAt(0) == 45 ? (str2 = str2.slice(1), -1) : 1;
          }
          if ((e = str2.indexOf(".")) > -1)
            str2 = str2.replace(".", "");
          if ((i = str2.search(/e/i)) > 0) {
            if (e < 0)
              e = i;
            e += +str2.slice(i + 1);
            str2 = str2.substring(0, i);
          } else if (e < 0) {
            e = str2.length;
          }
        } else {
          intCheck(b, 2, ALPHABET.length, "Base");
          if (b == 10 && alphabetHasNormalDecimalDigits) {
            x = new BigNumber2(v);
            return round(x, DECIMAL_PLACES + x.e + 1, ROUNDING_MODE);
          }
          str2 = String(v);
          if (isNum = typeof v == "number") {
            if (v * 0 != 0)
              return parseNumeric(x, str2, isNum, b);
            x.s = 1 / v < 0 ? (str2 = str2.slice(1), -1) : 1;
            if (BigNumber2.DEBUG && str2.replace(/^0\.0*|\./, "").length > 15) {
              throw Error(tooManyDigits + v);
            }
          } else {
            x.s = str2.charCodeAt(0) === 45 ? (str2 = str2.slice(1), -1) : 1;
          }
          alphabet = ALPHABET.slice(0, b);
          e = i = 0;
          for (len = str2.length;i < len; i++) {
            if (alphabet.indexOf(c = str2.charAt(i)) < 0) {
              if (c == ".") {
                if (i > e) {
                  e = len;
                  continue;
                }
              } else if (!caseChanged) {
                if (str2 == str2.toUpperCase() && (str2 = str2.toLowerCase()) || str2 == str2.toLowerCase() && (str2 = str2.toUpperCase())) {
                  caseChanged = true;
                  i = -1;
                  e = 0;
                  continue;
                }
              }
              return parseNumeric(x, String(v), isNum, b);
            }
          }
          isNum = false;
          str2 = convertBase(str2, b, 10, x.s);
          if ((e = str2.indexOf(".")) > -1)
            str2 = str2.replace(".", "");
          else
            e = str2.length;
        }
        for (i = 0;str2.charCodeAt(i) === 48; i++)
          ;
        for (len = str2.length;str2.charCodeAt(--len) === 48; )
          ;
        if (str2 = str2.slice(i, ++len)) {
          len -= i;
          if (isNum && BigNumber2.DEBUG && len > 15 && (v > MAX_SAFE_INTEGER || v !== mathfloor(v))) {
            throw Error(tooManyDigits + x.s * v);
          }
          if ((e = e - i - 1) > MAX_EXP) {
            x.c = x.e = null;
          } else if (e < MIN_EXP) {
            x.c = [x.e = 0];
          } else {
            x.e = e;
            x.c = [];
            i = (e + 1) % LOG_BASE;
            if (e < 0)
              i += LOG_BASE;
            if (i < len) {
              if (i)
                x.c.push(+str2.slice(0, i));
              for (len -= LOG_BASE;i < len; ) {
                x.c.push(+str2.slice(i, i += LOG_BASE));
              }
              i = LOG_BASE - (str2 = str2.slice(i)).length;
            } else {
              i -= len;
            }
            for (;i--; str2 += "0")
              ;
            x.c.push(+str2);
          }
        } else {
          x.c = [x.e = 0];
        }
      }
      BigNumber2.clone = clone;
      BigNumber2.ROUND_UP = 0;
      BigNumber2.ROUND_DOWN = 1;
      BigNumber2.ROUND_CEIL = 2;
      BigNumber2.ROUND_FLOOR = 3;
      BigNumber2.ROUND_HALF_UP = 4;
      BigNumber2.ROUND_HALF_DOWN = 5;
      BigNumber2.ROUND_HALF_EVEN = 6;
      BigNumber2.ROUND_HALF_CEIL = 7;
      BigNumber2.ROUND_HALF_FLOOR = 8;
      BigNumber2.EUCLID = 9;
      BigNumber2.config = BigNumber2.set = function(obj) {
        var p, v;
        if (obj != null) {
          if (typeof obj == "object") {
            if (obj.hasOwnProperty(p = "DECIMAL_PLACES")) {
              v = obj[p];
              intCheck(v, 0, MAX, p);
              DECIMAL_PLACES = v;
            }
            if (obj.hasOwnProperty(p = "ROUNDING_MODE")) {
              v = obj[p];
              intCheck(v, 0, 8, p);
              ROUNDING_MODE = v;
            }
            if (obj.hasOwnProperty(p = "EXPONENTIAL_AT")) {
              v = obj[p];
              if (v && v.pop) {
                intCheck(v[0], -MAX, 0, p);
                intCheck(v[1], 0, MAX, p);
                TO_EXP_NEG = v[0];
                TO_EXP_POS = v[1];
              } else {
                intCheck(v, -MAX, MAX, p);
                TO_EXP_NEG = -(TO_EXP_POS = v < 0 ? -v : v);
              }
            }
            if (obj.hasOwnProperty(p = "RANGE")) {
              v = obj[p];
              if (v && v.pop) {
                intCheck(v[0], -MAX, -1, p);
                intCheck(v[1], 1, MAX, p);
                MIN_EXP = v[0];
                MAX_EXP = v[1];
              } else {
                intCheck(v, -MAX, MAX, p);
                if (v) {
                  MIN_EXP = -(MAX_EXP = v < 0 ? -v : v);
                } else {
                  throw Error(bignumberError + p + " cannot be zero: " + v);
                }
              }
            }
            if (obj.hasOwnProperty(p = "CRYPTO")) {
              v = obj[p];
              if (v === !!v) {
                if (v) {
                  if (typeof crypto != "undefined" && crypto && (crypto.getRandomValues || crypto.randomBytes)) {
                    CRYPTO = v;
                  } else {
                    CRYPTO = !v;
                    throw Error(bignumberError + "crypto unavailable");
                  }
                } else {
                  CRYPTO = v;
                }
              } else {
                throw Error(bignumberError + p + " not true or false: " + v);
              }
            }
            if (obj.hasOwnProperty(p = "MODULO_MODE")) {
              v = obj[p];
              intCheck(v, 0, 9, p);
              MODULO_MODE = v;
            }
            if (obj.hasOwnProperty(p = "POW_PRECISION")) {
              v = obj[p];
              intCheck(v, 0, MAX, p);
              POW_PRECISION = v;
            }
            if (obj.hasOwnProperty(p = "FORMAT")) {
              v = obj[p];
              if (typeof v == "object")
                FORMAT = v;
              else
                throw Error(bignumberError + p + " not an object: " + v);
            }
            if (obj.hasOwnProperty(p = "ALPHABET")) {
              v = obj[p];
              if (typeof v == "string" && !/^.?$|[+\-.\s]|(.).*\1/.test(v)) {
                alphabetHasNormalDecimalDigits = v.slice(0, 10) == "0123456789";
                ALPHABET = v;
              } else {
                throw Error(bignumberError + p + " invalid: " + v);
              }
            }
          } else {
            throw Error(bignumberError + "Object expected: " + obj);
          }
        }
        return {
          DECIMAL_PLACES,
          ROUNDING_MODE,
          EXPONENTIAL_AT: [TO_EXP_NEG, TO_EXP_POS],
          RANGE: [MIN_EXP, MAX_EXP],
          CRYPTO,
          MODULO_MODE,
          POW_PRECISION,
          FORMAT,
          ALPHABET
        };
      };
      BigNumber2.isBigNumber = function(v) {
        if (!v || v._isBigNumber !== true)
          return false;
        if (!BigNumber2.DEBUG)
          return true;
        var i, n, c = v.c, e = v.e, s = v.s;
        out:
          if ({}.toString.call(c) == "[object Array]") {
            if ((s === 1 || s === -1) && e >= -MAX && e <= MAX && e === mathfloor(e)) {
              if (c[0] === 0) {
                if (e === 0 && c.length === 1)
                  return true;
                break out;
              }
              i = (e + 1) % LOG_BASE;
              if (i < 1)
                i += LOG_BASE;
              if (String(c[0]).length == i) {
                for (i = 0;i < c.length; i++) {
                  n = c[i];
                  if (n < 0 || n >= BASE || n !== mathfloor(n))
                    break out;
                }
                if (n !== 0)
                  return true;
              }
            }
          } else if (c === null && e === null && (s === null || s === 1 || s === -1)) {
            return true;
          }
        throw Error(bignumberError + "Invalid BigNumber: " + v);
      };
      BigNumber2.maximum = BigNumber2.max = function() {
        return maxOrMin(arguments, -1);
      };
      BigNumber2.minimum = BigNumber2.min = function() {
        return maxOrMin(arguments, 1);
      };
      BigNumber2.random = function() {
        var pow2_53 = 9007199254740992;
        var random53bitInt = Math.random() * pow2_53 & 2097151 ? function() {
          return mathfloor(Math.random() * pow2_53);
        } : function() {
          return (Math.random() * 1073741824 | 0) * 8388608 + (Math.random() * 8388608 | 0);
        };
        return function(dp) {
          var a, b, e, k, v, i = 0, c = [], rand = new BigNumber2(ONE);
          if (dp == null)
            dp = DECIMAL_PLACES;
          else
            intCheck(dp, 0, MAX);
          k = mathceil(dp / LOG_BASE);
          if (CRYPTO) {
            if (crypto.getRandomValues) {
              a = crypto.getRandomValues(new Uint32Array(k *= 2));
              for (;i < k; ) {
                v = a[i] * 131072 + (a[i + 1] >>> 11);
                if (v >= 9000000000000000) {
                  b = crypto.getRandomValues(new Uint32Array(2));
                  a[i] = b[0];
                  a[i + 1] = b[1];
                } else {
                  c.push(v % 100000000000000);
                  i += 2;
                }
              }
              i = k / 2;
            } else if (crypto.randomBytes) {
              a = crypto.randomBytes(k *= 7);
              for (;i < k; ) {
                v = (a[i] & 31) * 281474976710656 + a[i + 1] * 1099511627776 + a[i + 2] * 4294967296 + a[i + 3] * 16777216 + (a[i + 4] << 16) + (a[i + 5] << 8) + a[i + 6];
                if (v >= 9000000000000000) {
                  crypto.randomBytes(7).copy(a, i);
                } else {
                  c.push(v % 100000000000000);
                  i += 7;
                }
              }
              i = k / 7;
            } else {
              CRYPTO = false;
              throw Error(bignumberError + "crypto unavailable");
            }
          }
          if (!CRYPTO) {
            for (;i < k; ) {
              v = random53bitInt();
              if (v < 9000000000000000)
                c[i++] = v % 100000000000000;
            }
          }
          k = c[--i];
          dp %= LOG_BASE;
          if (k && dp) {
            v = POWS_TEN[LOG_BASE - dp];
            c[i] = mathfloor(k / v) * v;
          }
          for (;c[i] === 0; c.pop(), i--)
            ;
          if (i < 0) {
            c = [e = 0];
          } else {
            for (e = -1;c[0] === 0; c.splice(0, 1), e -= LOG_BASE)
              ;
            for (i = 1, v = c[0];v >= 10; v /= 10, i++)
              ;
            if (i < LOG_BASE)
              e -= LOG_BASE - i;
          }
          rand.e = e;
          rand.c = c;
          return rand;
        };
      }();
      BigNumber2.sum = function() {
        var i = 1, args = arguments, sum = new BigNumber2(args[0]);
        for (;i < args.length; )
          sum = sum.plus(args[i++]);
        return sum;
      };
      convertBase = function() {
        var decimal = "0123456789";
        function toBaseOut(str2, baseIn, baseOut, alphabet) {
          var j, arr = [0], arrL, i = 0, len = str2.length;
          for (;i < len; ) {
            for (arrL = arr.length;arrL--; arr[arrL] *= baseIn)
              ;
            arr[0] += alphabet.indexOf(str2.charAt(i++));
            for (j = 0;j < arr.length; j++) {
              if (arr[j] > baseOut - 1) {
                if (arr[j + 1] == null)
                  arr[j + 1] = 0;
                arr[j + 1] += arr[j] / baseOut | 0;
                arr[j] %= baseOut;
              }
            }
          }
          return arr.reverse();
        }
        return function(str2, baseIn, baseOut, sign, callerIsToString) {
          var alphabet, d, e, k, r, x, xc, y, i = str2.indexOf("."), dp = DECIMAL_PLACES, rm = ROUNDING_MODE;
          if (i >= 0) {
            k = POW_PRECISION;
            POW_PRECISION = 0;
            str2 = str2.replace(".", "");
            y = new BigNumber2(baseIn);
            x = y.pow(str2.length - i);
            POW_PRECISION = k;
            y.c = toBaseOut(toFixedPoint(coeffToString(x.c), x.e, "0"), 10, baseOut, decimal);
            y.e = y.c.length;
          }
          xc = toBaseOut(str2, baseIn, baseOut, callerIsToString ? (alphabet = ALPHABET, decimal) : (alphabet = decimal, ALPHABET));
          e = k = xc.length;
          for (;xc[--k] == 0; xc.pop())
            ;
          if (!xc[0])
            return alphabet.charAt(0);
          if (i < 0) {
            --e;
          } else {
            x.c = xc;
            x.e = e;
            x.s = sign;
            x = div(x, y, dp, rm, baseOut);
            xc = x.c;
            r = x.r;
            e = x.e;
          }
          d = e + dp + 1;
          i = xc[d];
          k = baseOut / 2;
          r = r || d < 0 || xc[d + 1] != null;
          r = rm < 4 ? (i != null || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : i > k || i == k && (rm == 4 || r || rm == 6 && xc[d - 1] & 1 || rm == (x.s < 0 ? 8 : 7));
          if (d < 1 || !xc[0]) {
            str2 = r ? toFixedPoint(alphabet.charAt(1), -dp, alphabet.charAt(0)) : alphabet.charAt(0);
          } else {
            xc.length = d;
            if (r) {
              for (--baseOut;++xc[--d] > baseOut; ) {
                xc[d] = 0;
                if (!d) {
                  ++e;
                  xc = [1].concat(xc);
                }
              }
            }
            for (k = xc.length;!xc[--k]; )
              ;
            for (i = 0, str2 = "";i <= k; str2 += alphabet.charAt(xc[i++]))
              ;
            str2 = toFixedPoint(str2, e, alphabet.charAt(0));
          }
          return str2;
        };
      }();
      div = function() {
        function multiply(x, k, base) {
          var m, temp, xlo, xhi, carry = 0, i = x.length, klo = k % SQRT_BASE, khi = k / SQRT_BASE | 0;
          for (x = x.slice();i--; ) {
            xlo = x[i] % SQRT_BASE;
            xhi = x[i] / SQRT_BASE | 0;
            m = khi * xlo + xhi * klo;
            temp = klo * xlo + m % SQRT_BASE * SQRT_BASE + carry;
            carry = (temp / base | 0) + (m / SQRT_BASE | 0) + khi * xhi;
            x[i] = temp % base;
          }
          if (carry)
            x = [carry].concat(x);
          return x;
        }
        function compare2(a, b, aL, bL) {
          var i, cmp;
          if (aL != bL) {
            cmp = aL > bL ? 1 : -1;
          } else {
            for (i = cmp = 0;i < aL; i++) {
              if (a[i] != b[i]) {
                cmp = a[i] > b[i] ? 1 : -1;
                break;
              }
            }
          }
          return cmp;
        }
        function subtract(a, b, aL, base) {
          var i = 0;
          for (;aL--; ) {
            a[aL] -= i;
            i = a[aL] < b[aL] ? 1 : 0;
            a[aL] = i * base + a[aL] - b[aL];
          }
          for (;!a[0] && a.length > 1; a.splice(0, 1))
            ;
        }
        return function(x, y, dp, rm, base) {
          var cmp, e, i, more, n, prod, prodL, q, qc, rem, remL, rem0, xi, xL, yc0, yL, yz, s = x.s == y.s ? 1 : -1, xc = x.c, yc = y.c;
          if (!xc || !xc[0] || !yc || !yc[0]) {
            return new BigNumber2(!x.s || !y.s || (xc ? yc && xc[0] == yc[0] : !yc) ? NaN : xc && xc[0] == 0 || !yc ? s * 0 : s / 0);
          }
          q = new BigNumber2(s);
          qc = q.c = [];
          e = x.e - y.e;
          s = dp + e + 1;
          if (!base) {
            base = BASE;
            e = bitFloor(x.e / LOG_BASE) - bitFloor(y.e / LOG_BASE);
            s = s / LOG_BASE | 0;
          }
          for (i = 0;yc[i] == (xc[i] || 0); i++)
            ;
          if (yc[i] > (xc[i] || 0))
            e--;
          if (s < 0) {
            qc.push(1);
            more = true;
          } else {
            xL = xc.length;
            yL = yc.length;
            i = 0;
            s += 2;
            n = mathfloor(base / (yc[0] + 1));
            if (n > 1) {
              yc = multiply(yc, n, base);
              xc = multiply(xc, n, base);
              yL = yc.length;
              xL = xc.length;
            }
            xi = yL;
            rem = xc.slice(0, yL);
            remL = rem.length;
            for (;remL < yL; rem[remL++] = 0)
              ;
            yz = yc.slice();
            yz = [0].concat(yz);
            yc0 = yc[0];
            if (yc[1] >= base / 2)
              yc0++;
            do {
              n = 0;
              cmp = compare2(yc, rem, yL, remL);
              if (cmp < 0) {
                rem0 = rem[0];
                if (yL != remL)
                  rem0 = rem0 * base + (rem[1] || 0);
                n = mathfloor(rem0 / yc0);
                if (n > 1) {
                  if (n >= base)
                    n = base - 1;
                  prod = multiply(yc, n, base);
                  prodL = prod.length;
                  remL = rem.length;
                  while (compare2(prod, rem, prodL, remL) == 1) {
                    n--;
                    subtract(prod, yL < prodL ? yz : yc, prodL, base);
                    prodL = prod.length;
                    cmp = 1;
                  }
                } else {
                  if (n == 0) {
                    cmp = n = 1;
                  }
                  prod = yc.slice();
                  prodL = prod.length;
                }
                if (prodL < remL)
                  prod = [0].concat(prod);
                subtract(rem, prod, remL, base);
                remL = rem.length;
                if (cmp == -1) {
                  while (compare2(yc, rem, yL, remL) < 1) {
                    n++;
                    subtract(rem, yL < remL ? yz : yc, remL, base);
                    remL = rem.length;
                  }
                }
              } else if (cmp === 0) {
                n++;
                rem = [0];
              }
              qc[i++] = n;
              if (rem[0]) {
                rem[remL++] = xc[xi] || 0;
              } else {
                rem = [xc[xi]];
                remL = 1;
              }
            } while ((xi++ < xL || rem[0] != null) && s--);
            more = rem[0] != null;
            if (!qc[0])
              qc.splice(0, 1);
          }
          if (base == BASE) {
            for (i = 1, s = qc[0];s >= 10; s /= 10, i++)
              ;
            round(q, dp + (q.e = i + e * LOG_BASE - 1) + 1, rm, more);
          } else {
            q.e = e;
            q.r = +more;
          }
          return q;
        };
      }();
      function format(n, i, rm, id) {
        var c0, e, ne, len, str2;
        if (rm == null)
          rm = ROUNDING_MODE;
        else
          intCheck(rm, 0, 8);
        if (!n.c)
          return n.toString();
        c0 = n.c[0];
        ne = n.e;
        if (i == null) {
          str2 = coeffToString(n.c);
          str2 = id == 1 || id == 2 && (ne <= TO_EXP_NEG || ne >= TO_EXP_POS) ? toExponential(str2, ne) : toFixedPoint(str2, ne, "0");
        } else {
          n = round(new BigNumber2(n), i, rm);
          e = n.e;
          str2 = coeffToString(n.c);
          len = str2.length;
          if (id == 1 || id == 2 && (i <= e || e <= TO_EXP_NEG)) {
            for (;len < i; str2 += "0", len++)
              ;
            str2 = toExponential(str2, e);
          } else {
            i -= ne + (id === 2 && e > ne);
            str2 = toFixedPoint(str2, e, "0");
            if (e + 1 > len) {
              if (--i > 0)
                for (str2 += ".";i--; str2 += "0")
                  ;
            } else {
              i += e - len;
              if (i > 0) {
                if (e + 1 == len)
                  str2 += ".";
                for (;i--; str2 += "0")
                  ;
              }
            }
          }
        }
        return n.s < 0 && c0 ? "-" + str2 : str2;
      }
      function maxOrMin(args, n) {
        var k, y, i = 1, x = new BigNumber2(args[0]);
        for (;i < args.length; i++) {
          y = new BigNumber2(args[i]);
          if (!y.s || (k = compare(x, y)) === n || k === 0 && x.s === n) {
            x = y;
          }
        }
        return x;
      }
      function normalise(n, c, e) {
        var i = 1, j = c.length;
        for (;!c[--j]; c.pop())
          ;
        for (j = c[0];j >= 10; j /= 10, i++)
          ;
        if ((e = i + e * LOG_BASE - 1) > MAX_EXP) {
          n.c = n.e = null;
        } else if (e < MIN_EXP) {
          n.c = [n.e = 0];
        } else {
          n.e = e;
          n.c = c;
        }
        return n;
      }
      parseNumeric = function() {
        var basePrefix = /^(-?)0([xbo])(?=\w[\w.]*$)/i, dotAfter = /^([^.]+)\.$/, dotBefore = /^\.([^.]+)$/, isInfinityOrNaN = /^-?(Infinity|NaN)$/, whitespaceOrPlus = /^\s*\+(?=[\w.])|^\s+|\s+$/g;
        return function(x, str2, isNum, b) {
          var base, s = isNum ? str2 : str2.replace(whitespaceOrPlus, "");
          if (isInfinityOrNaN.test(s)) {
            x.s = isNaN(s) ? null : s < 0 ? -1 : 1;
          } else {
            if (!isNum) {
              s = s.replace(basePrefix, function(m, p1, p2) {
                base = (p2 = p2.toLowerCase()) == "x" ? 16 : p2 == "b" ? 2 : 8;
                return !b || b == base ? p1 : m;
              });
              if (b) {
                base = b;
                s = s.replace(dotAfter, "$1").replace(dotBefore, "0.$1");
              }
              if (str2 != s)
                return new BigNumber2(s, base);
            }
            if (BigNumber2.DEBUG) {
              throw Error(bignumberError + "Not a" + (b ? " base " + b : "") + " number: " + str2);
            }
            x.s = null;
          }
          x.c = x.e = null;
        };
      }();
      function round(x, sd, rm, r) {
        var d, i, j, k, n, ni, rd, xc = x.c, pows10 = POWS_TEN;
        if (xc) {
          out: {
            for (d = 1, k = xc[0];k >= 10; k /= 10, d++)
              ;
            i = sd - d;
            if (i < 0) {
              i += LOG_BASE;
              j = sd;
              n = xc[ni = 0];
              rd = mathfloor(n / pows10[d - j - 1] % 10);
            } else {
              ni = mathceil((i + 1) / LOG_BASE);
              if (ni >= xc.length) {
                if (r) {
                  for (;xc.length <= ni; xc.push(0))
                    ;
                  n = rd = 0;
                  d = 1;
                  i %= LOG_BASE;
                  j = i - LOG_BASE + 1;
                } else {
                  break out;
                }
              } else {
                n = k = xc[ni];
                for (d = 1;k >= 10; k /= 10, d++)
                  ;
                i %= LOG_BASE;
                j = i - LOG_BASE + d;
                rd = j < 0 ? 0 : mathfloor(n / pows10[d - j - 1] % 10);
              }
            }
            r = r || sd < 0 || xc[ni + 1] != null || (j < 0 ? n : n % pows10[d - j - 1]);
            r = rm < 4 ? (rd || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : rd > 5 || rd == 5 && (rm == 4 || r || rm == 6 && (i > 0 ? j > 0 ? n / pows10[d - j] : 0 : xc[ni - 1]) % 10 & 1 || rm == (x.s < 0 ? 8 : 7));
            if (sd < 1 || !xc[0]) {
              xc.length = 0;
              if (r) {
                sd -= x.e + 1;
                xc[0] = pows10[(LOG_BASE - sd % LOG_BASE) % LOG_BASE];
                x.e = -sd || 0;
              } else {
                xc[0] = x.e = 0;
              }
              return x;
            }
            if (i == 0) {
              xc.length = ni;
              k = 1;
              ni--;
            } else {
              xc.length = ni + 1;
              k = pows10[LOG_BASE - i];
              xc[ni] = j > 0 ? mathfloor(n / pows10[d - j] % pows10[j]) * k : 0;
            }
            if (r) {
              for (;; ) {
                if (ni == 0) {
                  for (i = 1, j = xc[0];j >= 10; j /= 10, i++)
                    ;
                  j = xc[0] += k;
                  for (k = 1;j >= 10; j /= 10, k++)
                    ;
                  if (i != k) {
                    x.e++;
                    if (xc[0] == BASE)
                      xc[0] = 1;
                  }
                  break;
                } else {
                  xc[ni] += k;
                  if (xc[ni] != BASE)
                    break;
                  xc[ni--] = 0;
                  k = 1;
                }
              }
            }
            for (i = xc.length;xc[--i] === 0; xc.pop())
              ;
          }
          if (x.e > MAX_EXP) {
            x.c = x.e = null;
          } else if (x.e < MIN_EXP) {
            x.c = [x.e = 0];
          }
        }
        return x;
      }
      function valueOf(n) {
        var str2, e = n.e;
        if (e === null)
          return n.toString();
        str2 = coeffToString(n.c);
        str2 = e <= TO_EXP_NEG || e >= TO_EXP_POS ? toExponential(str2, e) : toFixedPoint(str2, e, "0");
        return n.s < 0 ? "-" + str2 : str2;
      }
      P.absoluteValue = P.abs = function() {
        var x = new BigNumber2(this);
        if (x.s < 0)
          x.s = 1;
        return x;
      };
      P.comparedTo = function(y, b) {
        return compare(this, new BigNumber2(y, b));
      };
      P.decimalPlaces = P.dp = function(dp, rm) {
        var c, n, v, x = this;
        if (dp != null) {
          intCheck(dp, 0, MAX);
          if (rm == null)
            rm = ROUNDING_MODE;
          else
            intCheck(rm, 0, 8);
          return round(new BigNumber2(x), dp + x.e + 1, rm);
        }
        if (!(c = x.c))
          return null;
        n = ((v = c.length - 1) - bitFloor(this.e / LOG_BASE)) * LOG_BASE;
        if (v = c[v])
          for (;v % 10 == 0; v /= 10, n--)
            ;
        if (n < 0)
          n = 0;
        return n;
      };
      P.dividedBy = P.div = function(y, b) {
        return div(this, new BigNumber2(y, b), DECIMAL_PLACES, ROUNDING_MODE);
      };
      P.dividedToIntegerBy = P.idiv = function(y, b) {
        return div(this, new BigNumber2(y, b), 0, 1);
      };
      P.exponentiatedBy = P.pow = function(n, m) {
        var half, isModExp, i, k, more, nIsBig, nIsNeg, nIsOdd, y, x = this;
        n = new BigNumber2(n);
        if (n.c && !n.isInteger()) {
          throw Error(bignumberError + "Exponent not an integer: " + valueOf(n));
        }
        if (m != null)
          m = new BigNumber2(m);
        nIsBig = n.e > 14;
        if (!x.c || !x.c[0] || x.c[0] == 1 && !x.e && x.c.length == 1 || !n.c || !n.c[0]) {
          y = new BigNumber2(Math.pow(+valueOf(x), nIsBig ? n.s * (2 - isOdd(n)) : +valueOf(n)));
          return m ? y.mod(m) : y;
        }
        nIsNeg = n.s < 0;
        if (m) {
          if (m.c ? !m.c[0] : !m.s)
            return new BigNumber2(NaN);
          isModExp = !nIsNeg && x.isInteger() && m.isInteger();
          if (isModExp)
            x = x.mod(m);
        } else if (n.e > 9 && (x.e > 0 || x.e < -1 || (x.e == 0 ? x.c[0] > 1 || nIsBig && x.c[1] >= 240000000 : x.c[0] < 80000000000000 || nIsBig && x.c[0] <= 99999750000000))) {
          k = x.s < 0 && isOdd(n) ? -0 : 0;
          if (x.e > -1)
            k = 1 / k;
          return new BigNumber2(nIsNeg ? 1 / k : k);
        } else if (POW_PRECISION) {
          k = mathceil(POW_PRECISION / LOG_BASE + 2);
        }
        if (nIsBig) {
          half = new BigNumber2(0.5);
          if (nIsNeg)
            n.s = 1;
          nIsOdd = isOdd(n);
        } else {
          i = Math.abs(+valueOf(n));
          nIsOdd = i % 2;
        }
        y = new BigNumber2(ONE);
        for (;; ) {
          if (nIsOdd) {
            y = y.times(x);
            if (!y.c)
              break;
            if (k) {
              if (y.c.length > k)
                y.c.length = k;
            } else if (isModExp) {
              y = y.mod(m);
            }
          }
          if (i) {
            i = mathfloor(i / 2);
            if (i === 0)
              break;
            nIsOdd = i % 2;
          } else {
            n = n.times(half);
            round(n, n.e + 1, 1);
            if (n.e > 14) {
              nIsOdd = isOdd(n);
            } else {
              i = +valueOf(n);
              if (i === 0)
                break;
              nIsOdd = i % 2;
            }
          }
          x = x.times(x);
          if (k) {
            if (x.c && x.c.length > k)
              x.c.length = k;
          } else if (isModExp) {
            x = x.mod(m);
          }
        }
        if (isModExp)
          return y;
        if (nIsNeg)
          y = ONE.div(y);
        return m ? y.mod(m) : k ? round(y, POW_PRECISION, ROUNDING_MODE, more) : y;
      };
      P.integerValue = function(rm) {
        var n = new BigNumber2(this);
        if (rm == null)
          rm = ROUNDING_MODE;
        else
          intCheck(rm, 0, 8);
        return round(n, n.e + 1, rm);
      };
      P.isEqualTo = P.eq = function(y, b) {
        return compare(this, new BigNumber2(y, b)) === 0;
      };
      P.isFinite = function() {
        return !!this.c;
      };
      P.isGreaterThan = P.gt = function(y, b) {
        return compare(this, new BigNumber2(y, b)) > 0;
      };
      P.isGreaterThanOrEqualTo = P.gte = function(y, b) {
        return (b = compare(this, new BigNumber2(y, b))) === 1 || b === 0;
      };
      P.isInteger = function() {
        return !!this.c && bitFloor(this.e / LOG_BASE) > this.c.length - 2;
      };
      P.isLessThan = P.lt = function(y, b) {
        return compare(this, new BigNumber2(y, b)) < 0;
      };
      P.isLessThanOrEqualTo = P.lte = function(y, b) {
        return (b = compare(this, new BigNumber2(y, b))) === -1 || b === 0;
      };
      P.isNaN = function() {
        return !this.s;
      };
      P.isNegative = function() {
        return this.s < 0;
      };
      P.isPositive = function() {
        return this.s > 0;
      };
      P.isZero = function() {
        return !!this.c && this.c[0] == 0;
      };
      P.minus = function(y, b) {
        var i, j, t, xLTy, x = this, a = x.s;
        y = new BigNumber2(y, b);
        b = y.s;
        if (!a || !b)
          return new BigNumber2(NaN);
        if (a != b) {
          y.s = -b;
          return x.plus(y);
        }
        var xe = x.e / LOG_BASE, ye = y.e / LOG_BASE, xc = x.c, yc = y.c;
        if (!xe || !ye) {
          if (!xc || !yc)
            return xc ? (y.s = -b, y) : new BigNumber2(yc ? x : NaN);
          if (!xc[0] || !yc[0]) {
            return yc[0] ? (y.s = -b, y) : new BigNumber2(xc[0] ? x : ROUNDING_MODE == 3 ? -0 : 0);
          }
        }
        xe = bitFloor(xe);
        ye = bitFloor(ye);
        xc = xc.slice();
        if (a = xe - ye) {
          if (xLTy = a < 0) {
            a = -a;
            t = xc;
          } else {
            ye = xe;
            t = yc;
          }
          t.reverse();
          for (b = a;b--; t.push(0))
            ;
          t.reverse();
        } else {
          j = (xLTy = (a = xc.length) < (b = yc.length)) ? a : b;
          for (a = b = 0;b < j; b++) {
            if (xc[b] != yc[b]) {
              xLTy = xc[b] < yc[b];
              break;
            }
          }
        }
        if (xLTy) {
          t = xc;
          xc = yc;
          yc = t;
          y.s = -y.s;
        }
        b = (j = yc.length) - (i = xc.length);
        if (b > 0)
          for (;b--; xc[i++] = 0)
            ;
        b = BASE - 1;
        for (;j > a; ) {
          if (xc[--j] < yc[j]) {
            for (i = j;i && !xc[--i]; xc[i] = b)
              ;
            --xc[i];
            xc[j] += BASE;
          }
          xc[j] -= yc[j];
        }
        for (;xc[0] == 0; xc.splice(0, 1), --ye)
          ;
        if (!xc[0]) {
          y.s = ROUNDING_MODE == 3 ? -1 : 1;
          y.c = [y.e = 0];
          return y;
        }
        return normalise(y, xc, ye);
      };
      P.modulo = P.mod = function(y, b) {
        var q, s, x = this;
        y = new BigNumber2(y, b);
        if (!x.c || !y.s || y.c && !y.c[0]) {
          return new BigNumber2(NaN);
        } else if (!y.c || x.c && !x.c[0]) {
          return new BigNumber2(x);
        }
        if (MODULO_MODE == 9) {
          s = y.s;
          y.s = 1;
          q = div(x, y, 0, 3);
          y.s = s;
          q.s *= s;
        } else {
          q = div(x, y, 0, MODULO_MODE);
        }
        y = x.minus(q.times(y));
        if (!y.c[0] && MODULO_MODE == 1)
          y.s = x.s;
        return y;
      };
      P.multipliedBy = P.times = function(y, b) {
        var c, e, i, j, k, m, xcL, xlo, xhi, ycL, ylo, yhi, zc, base, sqrtBase, x = this, xc = x.c, yc = (y = new BigNumber2(y, b)).c;
        if (!xc || !yc || !xc[0] || !yc[0]) {
          if (!x.s || !y.s || xc && !xc[0] && !yc || yc && !yc[0] && !xc) {
            y.c = y.e = y.s = null;
          } else {
            y.s *= x.s;
            if (!xc || !yc) {
              y.c = y.e = null;
            } else {
              y.c = [0];
              y.e = 0;
            }
          }
          return y;
        }
        e = bitFloor(x.e / LOG_BASE) + bitFloor(y.e / LOG_BASE);
        y.s *= x.s;
        xcL = xc.length;
        ycL = yc.length;
        if (xcL < ycL) {
          zc = xc;
          xc = yc;
          yc = zc;
          i = xcL;
          xcL = ycL;
          ycL = i;
        }
        for (i = xcL + ycL, zc = [];i--; zc.push(0))
          ;
        base = BASE;
        sqrtBase = SQRT_BASE;
        for (i = ycL;--i >= 0; ) {
          c = 0;
          ylo = yc[i] % sqrtBase;
          yhi = yc[i] / sqrtBase | 0;
          for (k = xcL, j = i + k;j > i; ) {
            xlo = xc[--k] % sqrtBase;
            xhi = xc[k] / sqrtBase | 0;
            m = yhi * xlo + xhi * ylo;
            xlo = ylo * xlo + m % sqrtBase * sqrtBase + zc[j] + c;
            c = (xlo / base | 0) + (m / sqrtBase | 0) + yhi * xhi;
            zc[j--] = xlo % base;
          }
          zc[j] = c;
        }
        if (c) {
          ++e;
        } else {
          zc.splice(0, 1);
        }
        return normalise(y, zc, e);
      };
      P.negated = function() {
        var x = new BigNumber2(this);
        x.s = -x.s || null;
        return x;
      };
      P.plus = function(y, b) {
        var t, x = this, a = x.s;
        y = new BigNumber2(y, b);
        b = y.s;
        if (!a || !b)
          return new BigNumber2(NaN);
        if (a != b) {
          y.s = -b;
          return x.minus(y);
        }
        var xe = x.e / LOG_BASE, ye = y.e / LOG_BASE, xc = x.c, yc = y.c;
        if (!xe || !ye) {
          if (!xc || !yc)
            return new BigNumber2(a / 0);
          if (!xc[0] || !yc[0])
            return yc[0] ? y : new BigNumber2(xc[0] ? x : a * 0);
        }
        xe = bitFloor(xe);
        ye = bitFloor(ye);
        xc = xc.slice();
        if (a = xe - ye) {
          if (a > 0) {
            ye = xe;
            t = yc;
          } else {
            a = -a;
            t = xc;
          }
          t.reverse();
          for (;a--; t.push(0))
            ;
          t.reverse();
        }
        a = xc.length;
        b = yc.length;
        if (a - b < 0) {
          t = yc;
          yc = xc;
          xc = t;
          b = a;
        }
        for (a = 0;b; ) {
          a = (xc[--b] = xc[b] + yc[b] + a) / BASE | 0;
          xc[b] = BASE === xc[b] ? 0 : xc[b] % BASE;
        }
        if (a) {
          xc = [a].concat(xc);
          ++ye;
        }
        return normalise(y, xc, ye);
      };
      P.precision = P.sd = function(sd, rm) {
        var c, n, v, x = this;
        if (sd != null && sd !== !!sd) {
          intCheck(sd, 1, MAX);
          if (rm == null)
            rm = ROUNDING_MODE;
          else
            intCheck(rm, 0, 8);
          return round(new BigNumber2(x), sd, rm);
        }
        if (!(c = x.c))
          return null;
        v = c.length - 1;
        n = v * LOG_BASE + 1;
        if (v = c[v]) {
          for (;v % 10 == 0; v /= 10, n--)
            ;
          for (v = c[0];v >= 10; v /= 10, n++)
            ;
        }
        if (sd && x.e + 1 > n)
          n = x.e + 1;
        return n;
      };
      P.shiftedBy = function(k) {
        intCheck(k, -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER);
        return this.times("1e" + k);
      };
      P.squareRoot = P.sqrt = function() {
        var m, n, r, rep, t, x = this, c = x.c, s = x.s, e = x.e, dp = DECIMAL_PLACES + 4, half = new BigNumber2("0.5");
        if (s !== 1 || !c || !c[0]) {
          return new BigNumber2(!s || s < 0 && (!c || c[0]) ? NaN : c ? x : 1 / 0);
        }
        s = Math.sqrt(+valueOf(x));
        if (s == 0 || s == 1 / 0) {
          n = coeffToString(c);
          if ((n.length + e) % 2 == 0)
            n += "0";
          s = Math.sqrt(+n);
          e = bitFloor((e + 1) / 2) - (e < 0 || e % 2);
          if (s == 1 / 0) {
            n = "5e" + e;
          } else {
            n = s.toExponential();
            n = n.slice(0, n.indexOf("e") + 1) + e;
          }
          r = new BigNumber2(n);
        } else {
          r = new BigNumber2(s + "");
        }
        if (r.c[0]) {
          e = r.e;
          s = e + dp;
          if (s < 3)
            s = 0;
          for (;; ) {
            t = r;
            r = half.times(t.plus(div(x, t, dp, 1)));
            if (coeffToString(t.c).slice(0, s) === (n = coeffToString(r.c)).slice(0, s)) {
              if (r.e < e)
                --s;
              n = n.slice(s - 3, s + 1);
              if (n == "9999" || !rep && n == "4999") {
                if (!rep) {
                  round(t, t.e + DECIMAL_PLACES + 2, 0);
                  if (t.times(t).eq(x)) {
                    r = t;
                    break;
                  }
                }
                dp += 4;
                s += 4;
                rep = 1;
              } else {
                if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
                  round(r, r.e + DECIMAL_PLACES + 2, 1);
                  m = !r.times(r).eq(x);
                }
                break;
              }
            }
          }
        }
        return round(r, r.e + DECIMAL_PLACES + 1, ROUNDING_MODE, m);
      };
      P.toExponential = function(dp, rm) {
        if (dp != null) {
          intCheck(dp, 0, MAX);
          dp++;
        }
        return format(this, dp, rm, 1);
      };
      P.toFixed = function(dp, rm) {
        if (dp != null) {
          intCheck(dp, 0, MAX);
          dp = dp + this.e + 1;
        }
        return format(this, dp, rm);
      };
      P.toFormat = function(dp, rm, format2) {
        var str2, x = this;
        if (format2 == null) {
          if (dp != null && rm && typeof rm == "object") {
            format2 = rm;
            rm = null;
          } else if (dp && typeof dp == "object") {
            format2 = dp;
            dp = rm = null;
          } else {
            format2 = FORMAT;
          }
        } else if (typeof format2 != "object") {
          throw Error(bignumberError + "Argument not an object: " + format2);
        }
        str2 = x.toFixed(dp, rm);
        if (x.c) {
          var i, arr = str2.split("."), g1 = +format2.groupSize, g2 = +format2.secondaryGroupSize, groupSeparator = format2.groupSeparator || "", intPart = arr[0], fractionPart = arr[1], isNeg = x.s < 0, intDigits = isNeg ? intPart.slice(1) : intPart, len = intDigits.length;
          if (g2) {
            i = g1;
            g1 = g2;
            g2 = i;
            len -= i;
          }
          if (g1 > 0 && len > 0) {
            i = len % g1 || g1;
            intPart = intDigits.substr(0, i);
            for (;i < len; i += g1)
              intPart += groupSeparator + intDigits.substr(i, g1);
            if (g2 > 0)
              intPart += groupSeparator + intDigits.slice(i);
            if (isNeg)
              intPart = "-" + intPart;
          }
          str2 = fractionPart ? intPart + (format2.decimalSeparator || "") + ((g2 = +format2.fractionGroupSize) ? fractionPart.replace(new RegExp("\\d{" + g2 + "}\\B", "g"), "$&" + (format2.fractionGroupSeparator || "")) : fractionPart) : intPart;
        }
        return (format2.prefix || "") + str2 + (format2.suffix || "");
      };
      P.toFraction = function(md) {
        var d, d0, d1, d2, e, exp, n, n0, n1, q, r, s, x = this, xc = x.c;
        if (md != null) {
          n = new BigNumber2(md);
          if (!n.isInteger() && (n.c || n.s !== 1) || n.lt(ONE)) {
            throw Error(bignumberError + "Argument " + (n.isInteger() ? "out of range: " : "not an integer: ") + valueOf(n));
          }
        }
        if (!xc)
          return new BigNumber2(x);
        d = new BigNumber2(ONE);
        n1 = d0 = new BigNumber2(ONE);
        d1 = n0 = new BigNumber2(ONE);
        s = coeffToString(xc);
        e = d.e = s.length - x.e - 1;
        d.c[0] = POWS_TEN[(exp = e % LOG_BASE) < 0 ? LOG_BASE + exp : exp];
        md = !md || n.comparedTo(d) > 0 ? e > 0 ? d : n1 : n;
        exp = MAX_EXP;
        MAX_EXP = 1 / 0;
        n = new BigNumber2(s);
        n0.c[0] = 0;
        for (;; ) {
          q = div(n, d, 0, 1);
          d2 = d0.plus(q.times(d1));
          if (d2.comparedTo(md) == 1)
            break;
          d0 = d1;
          d1 = d2;
          n1 = n0.plus(q.times(d2 = n1));
          n0 = d2;
          d = n.minus(q.times(d2 = d));
          n = d2;
        }
        d2 = div(md.minus(d0), d1, 0, 1);
        n0 = n0.plus(d2.times(n1));
        d0 = d0.plus(d2.times(d1));
        n0.s = n1.s = x.s;
        e = e * 2;
        r = div(n1, d1, e, ROUNDING_MODE).minus(x).abs().comparedTo(div(n0, d0, e, ROUNDING_MODE).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];
        MAX_EXP = exp;
        return r;
      };
      P.toNumber = function() {
        return +valueOf(this);
      };
      P.toPrecision = function(sd, rm) {
        if (sd != null)
          intCheck(sd, 1, MAX);
        return format(this, sd, rm, 2);
      };
      P.toString = function(b) {
        var str2, n = this, s = n.s, e = n.e;
        if (e === null) {
          if (s) {
            str2 = "Infinity";
            if (s < 0)
              str2 = "-" + str2;
          } else {
            str2 = "NaN";
          }
        } else {
          if (b == null) {
            str2 = e <= TO_EXP_NEG || e >= TO_EXP_POS ? toExponential(coeffToString(n.c), e) : toFixedPoint(coeffToString(n.c), e, "0");
          } else if (b === 10 && alphabetHasNormalDecimalDigits) {
            n = round(new BigNumber2(n), DECIMAL_PLACES + e + 1, ROUNDING_MODE);
            str2 = toFixedPoint(coeffToString(n.c), n.e, "0");
          } else {
            intCheck(b, 2, ALPHABET.length, "Base");
            str2 = convertBase(toFixedPoint(coeffToString(n.c), e, "0"), 10, b, s, true);
          }
          if (s < 0 && n.c[0])
            str2 = "-" + str2;
        }
        return str2;
      };
      P.valueOf = P.toJSON = function() {
        return valueOf(this);
      };
      P._isBigNumber = true;
      if (configObject != null)
        BigNumber2.set(configObject);
      return BigNumber2;
    }
    function bitFloor(n) {
      var i = n | 0;
      return n > 0 || n === i ? i : i - 1;
    }
    function coeffToString(a) {
      var s, z, i = 1, j = a.length, r = a[0] + "";
      for (;i < j; ) {
        s = a[i++] + "";
        z = LOG_BASE - s.length;
        for (;z--; s = "0" + s)
          ;
        r += s;
      }
      for (j = r.length;r.charCodeAt(--j) === 48; )
        ;
      return r.slice(0, j + 1 || 1);
    }
    function compare(x, y) {
      var a, b, xc = x.c, yc = y.c, i = x.s, j = y.s, k = x.e, l = y.e;
      if (!i || !j)
        return null;
      a = xc && !xc[0];
      b = yc && !yc[0];
      if (a || b)
        return a ? b ? 0 : -j : i;
      if (i != j)
        return i;
      a = i < 0;
      b = k == l;
      if (!xc || !yc)
        return b ? 0 : !xc ^ a ? 1 : -1;
      if (!b)
        return k > l ^ a ? 1 : -1;
      j = (k = xc.length) < (l = yc.length) ? k : l;
      for (i = 0;i < j; i++)
        if (xc[i] != yc[i])
          return xc[i] > yc[i] ^ a ? 1 : -1;
      return k == l ? 0 : k > l ^ a ? 1 : -1;
    }
    function intCheck(n, min, max, name) {
      if (n < min || n > max || n !== mathfloor(n)) {
        throw Error(bignumberError + (name || "Argument") + (typeof n == "number" ? n < min || n > max ? " out of range: " : " not an integer: " : " not a primitive number: ") + String(n));
      }
    }
    function isOdd(n) {
      var k = n.c.length - 1;
      return bitFloor(n.e / LOG_BASE) == k && n.c[k] % 2 != 0;
    }
    function toExponential(str2, e) {
      return (str2.length > 1 ? str2.charAt(0) + "." + str2.slice(1) : str2) + (e < 0 ? "e" : "e+") + e;
    }
    function toFixedPoint(str2, e, z) {
      var len, zs;
      if (e < 0) {
        for (zs = z + ".";++e; zs += z)
          ;
        str2 = zs + str2;
      } else {
        len = str2.length;
        if (++e > len) {
          for (zs = z, e -= len;--e; zs += z)
            ;
          str2 += zs;
        } else if (e < len) {
          str2 = str2.slice(0, e) + "." + str2.slice(e);
        }
      }
      return str2;
    }
    BigNumber = clone();
    BigNumber["default"] = BigNumber.BigNumber = BigNumber;
    if (typeof define == "function" && define.amd) {
      define(function() {
        return BigNumber;
      });
    } else if (typeof module != "undefined" && module.exports) {
      module.exports = BigNumber;
    } else {
      if (!globalObject) {
        globalObject = typeof self != "undefined" && self ? self : window;
      }
      globalObject.BigNumber = BigNumber;
    }
  })(exports);
});

// ../node_modules/.bun/json-bigint@1.0.0/node_modules/json-bigint/lib/stringify.js
var require_stringify = __commonJS((exports, module) => {
  var BigNumber = require_bignumber();
  var JSON2 = exports;
  (function() {
    function f(n) {
      return n < 10 ? "0" + n : n;
    }
    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, gap, indent, meta = {
      "\b": "\\b",
      "\t": "\\t",
      "\n": "\\n",
      "\f": "\\f",
      "\r": "\\r",
      '"': "\\\"",
      "\\": "\\\\"
    }, rep;
    function quote(string) {
      escapable.lastIndex = 0;
      return escapable.test(string) ? '"' + string.replace(escapable, function(a) {
        var c = meta[a];
        return typeof c === "string" ? c : "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4);
      }) + '"' : '"' + string + '"';
    }
    function str2(key, holder) {
      var i, k, v, length, mind = gap, partial, value = holder[key], isBigNumber = value != null && (value instanceof BigNumber || BigNumber.isBigNumber(value));
      if (value && typeof value === "object" && typeof value.toJSON === "function") {
        value = value.toJSON(key);
      }
      if (typeof rep === "function") {
        value = rep.call(holder, key, value);
      }
      switch (typeof value) {
        case "string":
          if (isBigNumber) {
            return value;
          } else {
            return quote(value);
          }
        case "number":
          return isFinite(value) ? String(value) : "null";
        case "boolean":
        case "null":
        case "bigint":
          return String(value);
        case "object":
          if (!value) {
            return "null";
          }
          gap += indent;
          partial = [];
          if (Object.prototype.toString.apply(value) === "[object Array]") {
            length = value.length;
            for (i = 0;i < length; i += 1) {
              partial[i] = str2(i, value) || "null";
            }
            v = partial.length === 0 ? "[]" : gap ? `[
` + gap + partial.join(`,
` + gap) + `
` + mind + "]" : "[" + partial.join(",") + "]";
            gap = mind;
            return v;
          }
          if (rep && typeof rep === "object") {
            length = rep.length;
            for (i = 0;i < length; i += 1) {
              if (typeof rep[i] === "string") {
                k = rep[i];
                v = str2(k, value);
                if (v) {
                  partial.push(quote(k) + (gap ? ": " : ":") + v);
                }
              }
            }
          } else {
            Object.keys(value).forEach(function(k2) {
              var v2 = str2(k2, value);
              if (v2) {
                partial.push(quote(k2) + (gap ? ": " : ":") + v2);
              }
            });
          }
          v = partial.length === 0 ? "{}" : gap ? `{
` + gap + partial.join(`,
` + gap) + `
` + mind + "}" : "{" + partial.join(",") + "}";
          gap = mind;
          return v;
      }
    }
    if (typeof JSON2.stringify !== "function") {
      JSON2.stringify = function(value, replacer, space) {
        var i;
        gap = "";
        indent = "";
        if (typeof space === "number") {
          for (i = 0;i < space; i += 1) {
            indent += " ";
          }
        } else if (typeof space === "string") {
          indent = space;
        }
        rep = replacer;
        if (replacer && typeof replacer !== "function" && (typeof replacer !== "object" || typeof replacer.length !== "number")) {
          throw new Error("JSON.stringify");
        }
        return str2("", { "": value });
      };
    }
  })();
});

// ../node_modules/.bun/json-bigint@1.0.0/node_modules/json-bigint/lib/parse.js
var require_parse = __commonJS((exports, module) => {
  var BigNumber = null;
  var suspectProtoRx = /(?:_|\\u005[Ff])(?:_|\\u005[Ff])(?:p|\\u0070)(?:r|\\u0072)(?:o|\\u006[Ff])(?:t|\\u0074)(?:o|\\u006[Ff])(?:_|\\u005[Ff])(?:_|\\u005[Ff])/;
  var suspectConstructorRx = /(?:c|\\u0063)(?:o|\\u006[Ff])(?:n|\\u006[Ee])(?:s|\\u0073)(?:t|\\u0074)(?:r|\\u0072)(?:u|\\u0075)(?:c|\\u0063)(?:t|\\u0074)(?:o|\\u006[Ff])(?:r|\\u0072)/;
  var json_parse = function(options) {
    var _options = {
      strict: false,
      storeAsString: false,
      alwaysParseAsBig: false,
      useNativeBigInt: false,
      protoAction: "error",
      constructorAction: "error"
    };
    if (options !== undefined && options !== null) {
      if (options.strict === true) {
        _options.strict = true;
      }
      if (options.storeAsString === true) {
        _options.storeAsString = true;
      }
      _options.alwaysParseAsBig = options.alwaysParseAsBig === true ? options.alwaysParseAsBig : false;
      _options.useNativeBigInt = options.useNativeBigInt === true ? options.useNativeBigInt : false;
      if (typeof options.constructorAction !== "undefined") {
        if (options.constructorAction === "error" || options.constructorAction === "ignore" || options.constructorAction === "preserve") {
          _options.constructorAction = options.constructorAction;
        } else {
          throw new Error(`Incorrect value for constructorAction option, must be "error", "ignore" or undefined but passed ${options.constructorAction}`);
        }
      }
      if (typeof options.protoAction !== "undefined") {
        if (options.protoAction === "error" || options.protoAction === "ignore" || options.protoAction === "preserve") {
          _options.protoAction = options.protoAction;
        } else {
          throw new Error(`Incorrect value for protoAction option, must be "error", "ignore" or undefined but passed ${options.protoAction}`);
        }
      }
    }
    var at, ch, escapee = {
      '"': '"',
      "\\": "\\",
      "/": "/",
      b: "\b",
      f: "\f",
      n: `
`,
      r: "\r",
      t: "\t"
    }, text, error3 = function(m) {
      throw {
        name: "SyntaxError",
        message: m,
        at,
        text
      };
    }, next = function(c) {
      if (c && c !== ch) {
        error3("Expected '" + c + "' instead of '" + ch + "'");
      }
      ch = text.charAt(at);
      at += 1;
      return ch;
    }, number = function() {
      var number2, string2 = "";
      if (ch === "-") {
        string2 = "-";
        next("-");
      }
      while (ch >= "0" && ch <= "9") {
        string2 += ch;
        next();
      }
      if (ch === ".") {
        string2 += ".";
        while (next() && ch >= "0" && ch <= "9") {
          string2 += ch;
        }
      }
      if (ch === "e" || ch === "E") {
        string2 += ch;
        next();
        if (ch === "-" || ch === "+") {
          string2 += ch;
          next();
        }
        while (ch >= "0" && ch <= "9") {
          string2 += ch;
          next();
        }
      }
      number2 = +string2;
      if (!isFinite(number2)) {
        error3("Bad number");
      } else {
        if (BigNumber == null)
          BigNumber = require_bignumber();
        if (string2.length > 15)
          return _options.storeAsString ? string2 : _options.useNativeBigInt ? BigInt(string2) : new BigNumber(string2);
        else
          return !_options.alwaysParseAsBig ? number2 : _options.useNativeBigInt ? BigInt(number2) : new BigNumber(number2);
      }
    }, string = function() {
      var hex, i, string2 = "", uffff;
      if (ch === '"') {
        var startAt = at;
        while (next()) {
          if (ch === '"') {
            if (at - 1 > startAt)
              string2 += text.substring(startAt, at - 1);
            next();
            return string2;
          }
          if (ch === "\\") {
            if (at - 1 > startAt)
              string2 += text.substring(startAt, at - 1);
            next();
            if (ch === "u") {
              uffff = 0;
              for (i = 0;i < 4; i += 1) {
                hex = parseInt(next(), 16);
                if (!isFinite(hex)) {
                  break;
                }
                uffff = uffff * 16 + hex;
              }
              string2 += String.fromCharCode(uffff);
            } else if (typeof escapee[ch] === "string") {
              string2 += escapee[ch];
            } else {
              break;
            }
            startAt = at;
          }
        }
      }
      error3("Bad string");
    }, white = function() {
      while (ch && ch <= " ") {
        next();
      }
    }, word = function() {
      switch (ch) {
        case "t":
          next("t");
          next("r");
          next("u");
          next("e");
          return true;
        case "f":
          next("f");
          next("a");
          next("l");
          next("s");
          next("e");
          return false;
        case "n":
          next("n");
          next("u");
          next("l");
          next("l");
          return null;
      }
      error3("Unexpected '" + ch + "'");
    }, value, array = function() {
      var array2 = [];
      if (ch === "[") {
        next("[");
        white();
        if (ch === "]") {
          next("]");
          return array2;
        }
        while (ch) {
          array2.push(value());
          white();
          if (ch === "]") {
            next("]");
            return array2;
          }
          next(",");
          white();
        }
      }
      error3("Bad array");
    }, object = function() {
      var key, object2 = Object.create(null);
      if (ch === "{") {
        next("{");
        white();
        if (ch === "}") {
          next("}");
          return object2;
        }
        while (ch) {
          key = string();
          white();
          next(":");
          if (_options.strict === true && Object.hasOwnProperty.call(object2, key)) {
            error3('Duplicate key "' + key + '"');
          }
          if (suspectProtoRx.test(key) === true) {
            if (_options.protoAction === "error") {
              error3("Object contains forbidden prototype property");
            } else if (_options.protoAction === "ignore") {
              value();
            } else {
              object2[key] = value();
            }
          } else if (suspectConstructorRx.test(key) === true) {
            if (_options.constructorAction === "error") {
              error3("Object contains forbidden constructor property");
            } else if (_options.constructorAction === "ignore") {
              value();
            } else {
              object2[key] = value();
            }
          } else {
            object2[key] = value();
          }
          white();
          if (ch === "}") {
            next("}");
            return object2;
          }
          next(",");
          white();
        }
      }
      error3("Bad object");
    };
    value = function() {
      white();
      switch (ch) {
        case "{":
          return object();
        case "[":
          return array();
        case '"':
          return string();
        case "-":
          return number();
        default:
          return ch >= "0" && ch <= "9" ? number() : word();
      }
    };
    return function(source, reviver) {
      var result;
      text = source + "";
      at = 0;
      ch = " ";
      result = value();
      white();
      if (ch) {
        error3("Syntax error");
      }
      return typeof reviver === "function" ? function walk(holder, key) {
        var k, v, value2 = holder[key];
        if (value2 && typeof value2 === "object") {
          Object.keys(value2).forEach(function(k2) {
            v = walk(value2, k2);
            if (v !== undefined) {
              value2[k2] = v;
            } else {
              delete value2[k2];
            }
          });
        }
        return reviver.call(holder, key, value2);
      }({ "": result }, "") : result;
    };
  };
  module.exports = json_parse;
});

// ../node_modules/.bun/json-bigint@1.0.0/node_modules/json-bigint/index.js
var require_json_bigint = __commonJS((exports, module) => {
  var json_stringify = require_stringify().stringify;
  var json_parse = require_parse();
  module.exports = function(options) {
    return {
      parse: json_parse(options),
      stringify: json_stringify
    };
  };
  module.exports.parse = json_parse();
  module.exports.stringify = json_stringify;
});

// ../node_modules/.bun/gcp-metadata@8.1.2/node_modules/gcp-metadata/build/src/gcp-residency.js
var require_gcp_residency = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GCE_LINUX_BIOS_PATHS = undefined;
  exports.isGoogleCloudServerless = isGoogleCloudServerless;
  exports.isGoogleComputeEngineLinux = isGoogleComputeEngineLinux;
  exports.isGoogleComputeEngineMACAddress = isGoogleComputeEngineMACAddress;
  exports.isGoogleComputeEngine = isGoogleComputeEngine;
  exports.detectGCPResidency = detectGCPResidency;
  var fs_1 = __require("fs");
  var os_1 = __require("os");
  exports.GCE_LINUX_BIOS_PATHS = {
    BIOS_DATE: "/sys/class/dmi/id/bios_date",
    BIOS_VENDOR: "/sys/class/dmi/id/bios_vendor"
  };
  var GCE_MAC_ADDRESS_REGEX = /^42:01/;
  function isGoogleCloudServerless() {
    const isGFEnvironment = process.env.CLOUD_RUN_JOB || process.env.FUNCTION_NAME || process.env.K_SERVICE;
    return !!isGFEnvironment;
  }
  function isGoogleComputeEngineLinux() {
    if ((0, os_1.platform)() !== "linux")
      return false;
    try {
      (0, fs_1.statSync)(exports.GCE_LINUX_BIOS_PATHS.BIOS_DATE);
      const biosVendor = (0, fs_1.readFileSync)(exports.GCE_LINUX_BIOS_PATHS.BIOS_VENDOR, "utf8");
      return /Google/.test(biosVendor);
    } catch {
      return false;
    }
  }
  function isGoogleComputeEngineMACAddress() {
    const interfaces = (0, os_1.networkInterfaces)();
    for (const item of Object.values(interfaces)) {
      if (!item)
        continue;
      for (const { mac } of item) {
        if (GCE_MAC_ADDRESS_REGEX.test(mac)) {
          return true;
        }
      }
    }
    return false;
  }
  function isGoogleComputeEngine() {
    return isGoogleComputeEngineLinux() || isGoogleComputeEngineMACAddress();
  }
  function detectGCPResidency() {
    return isGoogleCloudServerless() || isGoogleComputeEngine();
  }
});

// ../node_modules/.bun/google-logging-utils@1.1.3/node_modules/google-logging-utils/build/src/colours.js
var require_colours = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Colours = undefined;

  class Colours {
    static isEnabled(stream) {
      return stream && stream.isTTY && (typeof stream.getColorDepth === "function" ? stream.getColorDepth() > 2 : true);
    }
    static refresh() {
      Colours.enabled = Colours.isEnabled(process === null || process === undefined ? undefined : process.stderr);
      if (!this.enabled) {
        Colours.reset = "";
        Colours.bright = "";
        Colours.dim = "";
        Colours.red = "";
        Colours.green = "";
        Colours.yellow = "";
        Colours.blue = "";
        Colours.magenta = "";
        Colours.cyan = "";
        Colours.white = "";
        Colours.grey = "";
      } else {
        Colours.reset = "\x1B[0m";
        Colours.bright = "\x1B[1m";
        Colours.dim = "\x1B[2m";
        Colours.red = "\x1B[31m";
        Colours.green = "\x1B[32m";
        Colours.yellow = "\x1B[33m";
        Colours.blue = "\x1B[34m";
        Colours.magenta = "\x1B[35m";
        Colours.cyan = "\x1B[36m";
        Colours.white = "\x1B[37m";
        Colours.grey = "\x1B[90m";
      }
    }
  }
  exports.Colours = Colours;
  Colours.enabled = false;
  Colours.reset = "";
  Colours.bright = "";
  Colours.dim = "";
  Colours.red = "";
  Colours.green = "";
  Colours.yellow = "";
  Colours.blue = "";
  Colours.magenta = "";
  Colours.cyan = "";
  Colours.white = "";
  Colours.grey = "";
  Colours.refresh();
});

// ../node_modules/.bun/google-logging-utils@1.1.3/node_modules/google-logging-utils/build/src/logging-utils.js
var require_logging_utils = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = exports && exports.__importStar || function() {
    var ownKeys = function(o) {
      ownKeys = Object.getOwnPropertyNames || function(o2) {
        var ar = [];
        for (var k in o2)
          if (Object.prototype.hasOwnProperty.call(o2, k))
            ar[ar.length] = k;
        return ar;
      };
      return ownKeys(o);
    };
    return function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k = ownKeys(mod), i = 0;i < k.length; i++)
          if (k[i] !== "default")
            __createBinding(result, mod, k[i]);
      }
      __setModuleDefault(result, mod);
      return result;
    };
  }();
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.env = exports.DebugLogBackendBase = exports.placeholder = exports.AdhocDebugLogger = exports.LogSeverity = undefined;
  exports.getNodeBackend = getNodeBackend;
  exports.getDebugBackend = getDebugBackend;
  exports.getStructuredBackend = getStructuredBackend;
  exports.setBackend = setBackend;
  exports.log = log2;
  var events_1 = __require("events");
  var process9 = __importStar(__require("process"));
  var util = __importStar(__require("util"));
  var colours_1 = require_colours();
  var LogSeverity;
  (function(LogSeverity2) {
    LogSeverity2["DEFAULT"] = "DEFAULT";
    LogSeverity2["DEBUG"] = "DEBUG";
    LogSeverity2["INFO"] = "INFO";
    LogSeverity2["WARNING"] = "WARNING";
    LogSeverity2["ERROR"] = "ERROR";
  })(LogSeverity || (exports.LogSeverity = LogSeverity = {}));

  class AdhocDebugLogger extends events_1.EventEmitter {
    constructor(namespace, upstream) {
      super();
      this.namespace = namespace;
      this.upstream = upstream;
      this.func = Object.assign(this.invoke.bind(this), {
        instance: this,
        on: (event, listener) => this.on(event, listener)
      });
      this.func.debug = (...args) => this.invokeSeverity(LogSeverity.DEBUG, ...args);
      this.func.info = (...args) => this.invokeSeverity(LogSeverity.INFO, ...args);
      this.func.warn = (...args) => this.invokeSeverity(LogSeverity.WARNING, ...args);
      this.func.error = (...args) => this.invokeSeverity(LogSeverity.ERROR, ...args);
      this.func.sublog = (namespace2) => log2(namespace2, this.func);
    }
    invoke(fields, ...args) {
      if (this.upstream) {
        try {
          this.upstream(fields, ...args);
        } catch (e) {}
      }
      try {
        this.emit("log", fields, args);
      } catch (e) {}
    }
    invokeSeverity(severity, ...args) {
      this.invoke({ severity }, ...args);
    }
  }
  exports.AdhocDebugLogger = AdhocDebugLogger;
  exports.placeholder = new AdhocDebugLogger("", () => {}).func;

  class DebugLogBackendBase {
    constructor() {
      var _a4;
      this.cached = new Map;
      this.filters = [];
      this.filtersSet = false;
      let nodeFlag = (_a4 = process9.env[exports.env.nodeEnables]) !== null && _a4 !== undefined ? _a4 : "*";
      if (nodeFlag === "all") {
        nodeFlag = "*";
      }
      this.filters = nodeFlag.split(",");
    }
    log(namespace, fields, ...args) {
      try {
        if (!this.filtersSet) {
          this.setFilters();
          this.filtersSet = true;
        }
        let logger = this.cached.get(namespace);
        if (!logger) {
          logger = this.makeLogger(namespace);
          this.cached.set(namespace, logger);
        }
        logger(fields, ...args);
      } catch (e) {
        console.error(e);
      }
    }
  }
  exports.DebugLogBackendBase = DebugLogBackendBase;

  class NodeBackend extends DebugLogBackendBase {
    constructor() {
      super(...arguments);
      this.enabledRegexp = /.*/g;
    }
    isEnabled(namespace) {
      return this.enabledRegexp.test(namespace);
    }
    makeLogger(namespace) {
      if (!this.enabledRegexp.test(namespace)) {
        return () => {};
      }
      return (fields, ...args) => {
        var _a4;
        const nscolour = `${colours_1.Colours.green}${namespace}${colours_1.Colours.reset}`;
        const pid = `${colours_1.Colours.yellow}${process9.pid}${colours_1.Colours.reset}`;
        let level;
        switch (fields.severity) {
          case LogSeverity.ERROR:
            level = `${colours_1.Colours.red}${fields.severity}${colours_1.Colours.reset}`;
            break;
          case LogSeverity.INFO:
            level = `${colours_1.Colours.magenta}${fields.severity}${colours_1.Colours.reset}`;
            break;
          case LogSeverity.WARNING:
            level = `${colours_1.Colours.yellow}${fields.severity}${colours_1.Colours.reset}`;
            break;
          default:
            level = (_a4 = fields.severity) !== null && _a4 !== undefined ? _a4 : LogSeverity.DEFAULT;
            break;
        }
        const msg = util.formatWithOptions({ colors: colours_1.Colours.enabled }, ...args);
        const filteredFields = Object.assign({}, fields);
        delete filteredFields.severity;
        const fieldsJson = Object.getOwnPropertyNames(filteredFields).length ? JSON.stringify(filteredFields) : "";
        const fieldsColour = fieldsJson ? `${colours_1.Colours.grey}${fieldsJson}${colours_1.Colours.reset}` : "";
        console.error("%s [%s|%s] %s%s", pid, nscolour, level, msg, fieldsJson ? ` ${fieldsColour}` : "");
      };
    }
    setFilters() {
      const totalFilters = this.filters.join(",");
      const regexp = totalFilters.replace(/[|\\{}()[\]^$+?.]/g, "\\$&").replace(/\*/g, ".*").replace(/,/g, "$|^");
      this.enabledRegexp = new RegExp(`^${regexp}$`, "i");
    }
  }
  function getNodeBackend() {
    return new NodeBackend;
  }

  class DebugBackend extends DebugLogBackendBase {
    constructor(pkg) {
      super();
      this.debugPkg = pkg;
    }
    makeLogger(namespace) {
      const debugLogger = this.debugPkg(namespace);
      return (fields, ...args) => {
        debugLogger(args[0], ...args.slice(1));
      };
    }
    setFilters() {
      var _a4;
      const existingFilters = (_a4 = process9.env["NODE_DEBUG"]) !== null && _a4 !== undefined ? _a4 : "";
      process9.env["NODE_DEBUG"] = `${existingFilters}${existingFilters ? "," : ""}${this.filters.join(",")}`;
    }
  }
  function getDebugBackend(debugPkg) {
    return new DebugBackend(debugPkg);
  }

  class StructuredBackend extends DebugLogBackendBase {
    constructor(upstream) {
      var _a4;
      super();
      this.upstream = (_a4 = upstream) !== null && _a4 !== undefined ? _a4 : undefined;
    }
    makeLogger(namespace) {
      var _a4;
      const debugLogger = (_a4 = this.upstream) === null || _a4 === undefined ? undefined : _a4.makeLogger(namespace);
      return (fields, ...args) => {
        var _a5;
        const severity = (_a5 = fields.severity) !== null && _a5 !== undefined ? _a5 : LogSeverity.INFO;
        const json = Object.assign({
          severity,
          message: util.format(...args)
        }, fields);
        const jsonString = JSON.stringify(json);
        if (debugLogger) {
          debugLogger(fields, jsonString);
        } else {
          console.log("%s", jsonString);
        }
      };
    }
    setFilters() {
      var _a4;
      (_a4 = this.upstream) === null || _a4 === undefined || _a4.setFilters();
    }
  }
  function getStructuredBackend(upstream) {
    return new StructuredBackend(upstream);
  }
  exports.env = {
    nodeEnables: "GOOGLE_SDK_NODE_LOGGING"
  };
  var loggerCache = new Map;
  var cachedBackend = undefined;
  function setBackend(backend) {
    cachedBackend = backend;
    loggerCache.clear();
  }
  function log2(namespace, parent) {
    if (!cachedBackend) {
      const enablesFlag = process9.env[exports.env.nodeEnables];
      if (!enablesFlag) {
        return exports.placeholder;
      }
    }
    if (!namespace) {
      return exports.placeholder;
    }
    if (parent) {
      namespace = `${parent.instance.namespace}:${namespace}`;
    }
    const existing = loggerCache.get(namespace);
    if (existing) {
      return existing.func;
    }
    if (cachedBackend === null) {
      return exports.placeholder;
    } else if (cachedBackend === undefined) {
      cachedBackend = getNodeBackend();
    }
    const logger = (() => {
      let previousBackend = undefined;
      const newLogger = new AdhocDebugLogger(namespace, (fields, ...args) => {
        if (previousBackend !== cachedBackend) {
          if (cachedBackend === null) {
            return;
          } else if (cachedBackend === undefined) {
            cachedBackend = getNodeBackend();
          }
          previousBackend = cachedBackend;
        }
        cachedBackend === null || cachedBackend === undefined || cachedBackend.log(namespace, fields, ...args);
      });
      return newLogger;
    })();
    loggerCache.set(namespace, logger);
    return logger.func;
  }
});

// ../node_modules/.bun/google-logging-utils@1.1.3/node_modules/google-logging-utils/build/src/index.js
var require_src3 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  __exportStar(require_logging_utils(), exports);
});

// ../node_modules/.bun/gcp-metadata@8.1.2/node_modules/gcp-metadata/build/src/index.js
var require_src4 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = exports && exports.__importStar || function() {
    var ownKeys = function(o) {
      ownKeys = Object.getOwnPropertyNames || function(o2) {
        var ar = [];
        for (var k in o2)
          if (Object.prototype.hasOwnProperty.call(o2, k))
            ar[ar.length] = k;
        return ar;
      };
      return ownKeys(o);
    };
    return function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k = ownKeys(mod), i = 0;i < k.length; i++)
          if (k[i] !== "default")
            __createBinding(result, mod, k[i]);
      }
      __setModuleDefault(result, mod);
      return result;
    };
  }();
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.gcpResidencyCache = exports.METADATA_SERVER_DETECTION = exports.HEADERS = exports.HEADER_VALUE = exports.HEADER_NAME = exports.SECONDARY_HOST_ADDRESS = exports.HOST_ADDRESS = exports.BASE_PATH = undefined;
  exports.instance = instance;
  exports.project = project;
  exports.universe = universe;
  exports.bulk = bulk;
  exports.isAvailable = isAvailable;
  exports.resetIsAvailableCache = resetIsAvailableCache;
  exports.getGCPResidency = getGCPResidency;
  exports.setGCPResidency = setGCPResidency;
  exports.requestTimeout = requestTimeout;
  var gaxios_1 = require_src2();
  var jsonBigint = require_json_bigint();
  var gcp_residency_1 = require_gcp_residency();
  var logger = __importStar(require_src3());
  exports.BASE_PATH = "/computeMetadata/v1";
  exports.HOST_ADDRESS = "http://169.254.169.254";
  exports.SECONDARY_HOST_ADDRESS = "http://metadata.google.internal.";
  exports.HEADER_NAME = "Metadata-Flavor";
  exports.HEADER_VALUE = "Google";
  exports.HEADERS = Object.freeze({ [exports.HEADER_NAME]: exports.HEADER_VALUE });
  var log2 = logger.log("gcp-metadata");
  exports.METADATA_SERVER_DETECTION = Object.freeze({
    "assume-present": "don't try to ping the metadata server, but assume it's present",
    none: "don't try to ping the metadata server, but don't try to use it either",
    "bios-only": "treat the result of a BIOS probe as canonical (don't fall back to pinging)",
    "ping-only": "skip the BIOS probe, and go straight to pinging"
  });
  function getBaseUrl(baseUrl) {
    if (!baseUrl) {
      baseUrl = process.env.GCE_METADATA_IP || process.env.GCE_METADATA_HOST || exports.HOST_ADDRESS;
    }
    if (!/^https?:\/\//.test(baseUrl)) {
      baseUrl = `http://${baseUrl}`;
    }
    return new URL(exports.BASE_PATH, baseUrl).href;
  }
  function validate(options) {
    Object.keys(options).forEach((key) => {
      switch (key) {
        case "params":
        case "property":
        case "headers":
          break;
        case "qs":
          throw new Error("'qs' is not a valid configuration option. Please use 'params' instead.");
        default:
          throw new Error(`'${key}' is not a valid configuration option.`);
      }
    });
  }
  async function metadataAccessor(type, options = {}, noResponseRetries = 3, fastFail = false) {
    const headers = new Headers(exports.HEADERS);
    let metadataKey = "";
    let params = {};
    if (typeof type === "object") {
      const metadataAccessor2 = type;
      new Headers(metadataAccessor2.headers).forEach((value, key) => headers.set(key, value));
      metadataKey = metadataAccessor2.metadataKey;
      params = metadataAccessor2.params || params;
      noResponseRetries = metadataAccessor2.noResponseRetries || noResponseRetries;
      fastFail = metadataAccessor2.fastFail || fastFail;
    } else {
      metadataKey = type;
    }
    if (typeof options === "string") {
      metadataKey += `/${options}`;
    } else {
      validate(options);
      if (options.property) {
        metadataKey += `/${options.property}`;
      }
      new Headers(options.headers).forEach((value, key) => headers.set(key, value));
      params = options.params || params;
    }
    const requestMethod = fastFail ? fastFailMetadataRequest : gaxios_1.request;
    const req = {
      url: `${getBaseUrl()}/${metadataKey}`,
      headers,
      retryConfig: { noResponseRetries },
      params,
      responseType: "text",
      timeout: requestTimeout()
    };
    log2.info("instance request %j", req);
    const res = await requestMethod(req);
    log2.info("instance metadata is %s", res.data);
    const metadataFlavor = res.headers.get(exports.HEADER_NAME);
    if (metadataFlavor !== exports.HEADER_VALUE) {
      throw new RangeError(`Invalid response from metadata service: incorrect ${exports.HEADER_NAME} header. Expected '${exports.HEADER_VALUE}', got ${metadataFlavor ? `'${metadataFlavor}'` : "no header"}`);
    }
    if (typeof res.data === "string") {
      try {
        return jsonBigint.parse(res.data);
      } catch {}
    }
    return res.data;
  }
  async function fastFailMetadataRequest(options) {
    const secondaryOptions = {
      ...options,
      url: options.url?.toString().replace(getBaseUrl(), getBaseUrl(exports.SECONDARY_HOST_ADDRESS))
    };
    const r1 = (0, gaxios_1.request)(options);
    const r2 = (0, gaxios_1.request)(secondaryOptions);
    return Promise.any([r1, r2]);
  }
  function instance(options) {
    return metadataAccessor("instance", options);
  }
  function project(options) {
    return metadataAccessor("project", options);
  }
  function universe(options) {
    return metadataAccessor("universe", options);
  }
  async function bulk(properties) {
    const r = {};
    await Promise.all(properties.map((item) => {
      return (async () => {
        const res = await metadataAccessor(item);
        const key = item.metadataKey;
        r[key] = res;
      })();
    }));
    return r;
  }
  function detectGCPAvailableRetries() {
    return process.env.DETECT_GCP_RETRIES ? Number(process.env.DETECT_GCP_RETRIES) : 0;
  }
  var cachedIsAvailableResponse;
  async function isAvailable() {
    if (process.env.METADATA_SERVER_DETECTION) {
      const value = process.env.METADATA_SERVER_DETECTION.trim().toLocaleLowerCase();
      if (!(value in exports.METADATA_SERVER_DETECTION)) {
        throw new RangeError(`Unknown \`METADATA_SERVER_DETECTION\` env variable. Got \`${value}\`, but it should be \`${Object.keys(exports.METADATA_SERVER_DETECTION).join("`, `")}\`, or unset`);
      }
      switch (value) {
        case "assume-present":
          return true;
        case "none":
          return false;
        case "bios-only":
          return getGCPResidency();
        case "ping-only":
      }
    }
    try {
      if (cachedIsAvailableResponse === undefined) {
        cachedIsAvailableResponse = metadataAccessor("instance", undefined, detectGCPAvailableRetries(), !(process.env.GCE_METADATA_IP || process.env.GCE_METADATA_HOST));
      }
      await cachedIsAvailableResponse;
      return true;
    } catch (e) {
      const err = e;
      if (process.env.DEBUG_AUTH) {
        console.info(err);
      }
      if (err.type === "request-timeout") {
        return false;
      }
      if (err.response && err.response.status === 404) {
        return false;
      } else {
        if (!(err.response && err.response.status === 404) && (!err.code || ![
          "EHOSTDOWN",
          "EHOSTUNREACH",
          "ENETUNREACH",
          "ENOENT",
          "ENOTFOUND",
          "ECONNREFUSED"
        ].includes(err.code.toString()))) {
          let code = "UNKNOWN";
          if (err.code)
            code = err.code.toString();
          process.emitWarning(`received unexpected error = ${err.message} code = ${code}`, "MetadataLookupWarning");
        }
        return false;
      }
    }
  }
  function resetIsAvailableCache() {
    cachedIsAvailableResponse = undefined;
  }
  exports.gcpResidencyCache = null;
  function getGCPResidency() {
    if (exports.gcpResidencyCache === null) {
      setGCPResidency();
    }
    return exports.gcpResidencyCache;
  }
  function setGCPResidency(value = null) {
    exports.gcpResidencyCache = value !== null ? value : (0, gcp_residency_1.detectGCPResidency)();
  }
  function requestTimeout() {
    return getGCPResidency() ? 0 : 3000;
  }
  __exportStar(require_gcp_residency(), exports);
});

// ../node_modules/.bun/base64-js@1.5.1/node_modules/base64-js/index.js
var require_base64_js = __commonJS((exports) => {
  exports.byteLength = byteLength;
  exports.toByteArray = toByteArray;
  exports.fromByteArray = fromByteArray;
  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
  var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  for (i = 0, len = code.length;i < len; ++i) {
    lookup[i] = code[i];
    revLookup[code.charCodeAt(i)] = i;
  }
  var i;
  var len;
  revLookup[45] = 62;
  revLookup[95] = 63;
  function getLens(b64) {
    var len2 = b64.length;
    if (len2 % 4 > 0) {
      throw new Error("Invalid string. Length must be a multiple of 4");
    }
    var validLen = b64.indexOf("=");
    if (validLen === -1)
      validLen = len2;
    var placeHoldersLen = validLen === len2 ? 0 : 4 - validLen % 4;
    return [validLen, placeHoldersLen];
  }
  function byteLength(b64) {
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function _byteLength(b64, validLen, placeHoldersLen) {
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function toByteArray(b64) {
    var tmp;
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
    var curByte = 0;
    var len2 = placeHoldersLen > 0 ? validLen - 4 : validLen;
    var i2;
    for (i2 = 0;i2 < len2; i2 += 4) {
      tmp = revLookup[b64.charCodeAt(i2)] << 18 | revLookup[b64.charCodeAt(i2 + 1)] << 12 | revLookup[b64.charCodeAt(i2 + 2)] << 6 | revLookup[b64.charCodeAt(i2 + 3)];
      arr[curByte++] = tmp >> 16 & 255;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 2) {
      tmp = revLookup[b64.charCodeAt(i2)] << 2 | revLookup[b64.charCodeAt(i2 + 1)] >> 4;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 1) {
      tmp = revLookup[b64.charCodeAt(i2)] << 10 | revLookup[b64.charCodeAt(i2 + 1)] << 4 | revLookup[b64.charCodeAt(i2 + 2)] >> 2;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    return arr;
  }
  function tripletToBase64(num) {
    return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
  }
  function encodeChunk(uint8, start, end) {
    var tmp;
    var output = [];
    for (var i2 = start;i2 < end; i2 += 3) {
      tmp = (uint8[i2] << 16 & 16711680) + (uint8[i2 + 1] << 8 & 65280) + (uint8[i2 + 2] & 255);
      output.push(tripletToBase64(tmp));
    }
    return output.join("");
  }
  function fromByteArray(uint8) {
    var tmp;
    var len2 = uint8.length;
    var extraBytes = len2 % 3;
    var parts = [];
    var maxChunkLength = 16383;
    for (var i2 = 0, len22 = len2 - extraBytes;i2 < len22; i2 += maxChunkLength) {
      parts.push(encodeChunk(uint8, i2, i2 + maxChunkLength > len22 ? len22 : i2 + maxChunkLength));
    }
    if (extraBytes === 1) {
      tmp = uint8[len2 - 1];
      parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "==");
    } else if (extraBytes === 2) {
      tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
      parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "=");
    }
    return parts.join("");
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/crypto/shared.js
var require_shared = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.fromArrayBufferToHex = fromArrayBufferToHex;
  function fromArrayBufferToHex(arrayBuffer) {
    const byteArray = Array.from(new Uint8Array(arrayBuffer));
    return byteArray.map((byte) => {
      return byte.toString(16).padStart(2, "0");
    }).join("");
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/crypto/browser/crypto.js
var require_crypto = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.BrowserCrypto = undefined;
  var base64js = require_base64_js();
  var shared_1 = require_shared();

  class BrowserCrypto {
    constructor() {
      if (typeof window === "undefined" || window.crypto === undefined || window.crypto.subtle === undefined) {
        throw new Error("SubtleCrypto not found. Make sure it's an https:// website.");
      }
    }
    async sha256DigestBase64(str2) {
      const inputBuffer = new TextEncoder().encode(str2);
      const outputBuffer = await window.crypto.subtle.digest("SHA-256", inputBuffer);
      return base64js.fromByteArray(new Uint8Array(outputBuffer));
    }
    randomBytesBase64(count) {
      const array = new Uint8Array(count);
      window.crypto.getRandomValues(array);
      return base64js.fromByteArray(array);
    }
    static padBase64(base642) {
      while (base642.length % 4 !== 0) {
        base642 += "=";
      }
      return base642;
    }
    async verify(pubkey, data, signature) {
      const algo = {
        name: "RSASSA-PKCS1-v1_5",
        hash: { name: "SHA-256" }
      };
      const dataArray = new TextEncoder().encode(data);
      const signatureArray = base64js.toByteArray(BrowserCrypto.padBase64(signature));
      const cryptoKey = await window.crypto.subtle.importKey("jwk", pubkey, algo, true, ["verify"]);
      const result = await window.crypto.subtle.verify(algo, cryptoKey, signatureArray, dataArray);
      return result;
    }
    async sign(privateKey, data) {
      const algo = {
        name: "RSASSA-PKCS1-v1_5",
        hash: { name: "SHA-256" }
      };
      const dataArray = new TextEncoder().encode(data);
      const cryptoKey = await window.crypto.subtle.importKey("jwk", privateKey, algo, true, ["sign"]);
      const result = await window.crypto.subtle.sign(algo, cryptoKey, dataArray);
      return base64js.fromByteArray(new Uint8Array(result));
    }
    decodeBase64StringUtf8(base642) {
      const uint8array = base64js.toByteArray(BrowserCrypto.padBase64(base642));
      const result = new TextDecoder().decode(uint8array);
      return result;
    }
    encodeBase64StringUtf8(text) {
      const uint8array = new TextEncoder().encode(text);
      const result = base64js.fromByteArray(uint8array);
      return result;
    }
    async sha256DigestHex(str2) {
      const inputBuffer = new TextEncoder().encode(str2);
      const outputBuffer = await window.crypto.subtle.digest("SHA-256", inputBuffer);
      return (0, shared_1.fromArrayBufferToHex)(outputBuffer);
    }
    async signWithHmacSha256(key, msg) {
      const rawKey = typeof key === "string" ? key : String.fromCharCode(...new Uint16Array(key));
      const enc = new TextEncoder;
      const cryptoKey = await window.crypto.subtle.importKey("raw", enc.encode(rawKey), {
        name: "HMAC",
        hash: {
          name: "SHA-256"
        }
      }, false, ["sign"]);
      return window.crypto.subtle.sign("HMAC", cryptoKey, enc.encode(msg));
    }
  }
  exports.BrowserCrypto = BrowserCrypto;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/crypto/node/crypto.js
var require_crypto2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.NodeCrypto = undefined;
  var crypto3 = __require("crypto");

  class NodeCrypto {
    async sha256DigestBase64(str2) {
      return crypto3.createHash("sha256").update(str2).digest("base64");
    }
    randomBytesBase64(count) {
      return crypto3.randomBytes(count).toString("base64");
    }
    async verify(pubkey, data, signature) {
      const verifier = crypto3.createVerify("RSA-SHA256");
      verifier.update(data);
      verifier.end();
      return verifier.verify(pubkey, signature, "base64");
    }
    async sign(privateKey, data) {
      const signer = crypto3.createSign("RSA-SHA256");
      signer.update(data);
      signer.end();
      return signer.sign(privateKey, "base64");
    }
    decodeBase64StringUtf8(base642) {
      return Buffer.from(base642, "base64").toString("utf-8");
    }
    encodeBase64StringUtf8(text) {
      return Buffer.from(text, "utf-8").toString("base64");
    }
    async sha256DigestHex(str2) {
      return crypto3.createHash("sha256").update(str2).digest("hex");
    }
    async signWithHmacSha256(key, msg) {
      const cryptoKey = typeof key === "string" ? key : toBuffer(key);
      return toArrayBuffer2(crypto3.createHmac("sha256", cryptoKey).update(msg).digest());
    }
  }
  exports.NodeCrypto = NodeCrypto;
  function toArrayBuffer2(buffer) {
    return buffer.buffer.slice(buffer.byteOffset, buffer.byteOffset + buffer.byteLength);
  }
  function toBuffer(arrayBuffer) {
    return Buffer.from(arrayBuffer);
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/crypto/crypto.js
var require_crypto3 = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createCrypto = createCrypto;
  exports.hasBrowserCrypto = hasBrowserCrypto;
  var crypto_1 = require_crypto();
  var crypto_2 = require_crypto2();
  __exportStar(require_shared(), exports);
  function createCrypto() {
    if (hasBrowserCrypto()) {
      return new crypto_1.BrowserCrypto;
    }
    return new crypto_2.NodeCrypto;
  }
  function hasBrowserCrypto() {
    return typeof window !== "undefined" && typeof window.crypto !== "undefined" && typeof window.crypto.subtle !== "undefined";
  }
});

// ../node_modules/.bun/safe-buffer@5.2.1/node_modules/safe-buffer/index.js
var require_safe_buffer = __commonJS((exports, module) => {
  /*! safe-buffer. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */
  var buffer = __require("buffer");
  var Buffer3 = buffer.Buffer;
  function copyProps(src, dst) {
    for (var key in src) {
      dst[key] = src[key];
    }
  }
  if (Buffer3.from && Buffer3.alloc && Buffer3.allocUnsafe && Buffer3.allocUnsafeSlow) {
    module.exports = buffer;
  } else {
    copyProps(buffer, exports);
    exports.Buffer = SafeBuffer;
  }
  function SafeBuffer(arg, encodingOrOffset, length) {
    return Buffer3(arg, encodingOrOffset, length);
  }
  SafeBuffer.prototype = Object.create(Buffer3.prototype);
  copyProps(Buffer3, SafeBuffer);
  SafeBuffer.from = function(arg, encodingOrOffset, length) {
    if (typeof arg === "number") {
      throw new TypeError("Argument must not be a number");
    }
    return Buffer3(arg, encodingOrOffset, length);
  };
  SafeBuffer.alloc = function(size, fill, encoding) {
    if (typeof size !== "number") {
      throw new TypeError("Argument must be a number");
    }
    var buf = Buffer3(size);
    if (fill !== undefined) {
      if (typeof encoding === "string") {
        buf.fill(fill, encoding);
      } else {
        buf.fill(fill);
      }
    } else {
      buf.fill(0);
    }
    return buf;
  };
  SafeBuffer.allocUnsafe = function(size) {
    if (typeof size !== "number") {
      throw new TypeError("Argument must be a number");
    }
    return Buffer3(size);
  };
  SafeBuffer.allocUnsafeSlow = function(size) {
    if (typeof size !== "number") {
      throw new TypeError("Argument must be a number");
    }
    return buffer.SlowBuffer(size);
  };
});

// ../node_modules/.bun/ecdsa-sig-formatter@1.0.11/node_modules/ecdsa-sig-formatter/src/param-bytes-for-alg.js
var require_param_bytes_for_alg = __commonJS((exports, module) => {
  function getParamSize(keySize) {
    var result = (keySize / 8 | 0) + (keySize % 8 === 0 ? 0 : 1);
    return result;
  }
  var paramBytesForAlg = {
    ES256: getParamSize(256),
    ES384: getParamSize(384),
    ES512: getParamSize(521)
  };
  function getParamBytesForAlg(alg) {
    var paramBytes = paramBytesForAlg[alg];
    if (paramBytes) {
      return paramBytes;
    }
    throw new Error('Unknown algorithm "' + alg + '"');
  }
  module.exports = getParamBytesForAlg;
});

// ../node_modules/.bun/ecdsa-sig-formatter@1.0.11/node_modules/ecdsa-sig-formatter/src/ecdsa-sig-formatter.js
var require_ecdsa_sig_formatter = __commonJS((exports, module) => {
  var Buffer3 = require_safe_buffer().Buffer;
  var getParamBytesForAlg = require_param_bytes_for_alg();
  var MAX_OCTET = 128;
  var CLASS_UNIVERSAL = 0;
  var PRIMITIVE_BIT = 32;
  var TAG_SEQ = 16;
  var TAG_INT = 2;
  var ENCODED_TAG_SEQ = TAG_SEQ | PRIMITIVE_BIT | CLASS_UNIVERSAL << 6;
  var ENCODED_TAG_INT = TAG_INT | CLASS_UNIVERSAL << 6;
  function base64Url(base642) {
    return base642.replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
  }
  function signatureAsBuffer(signature) {
    if (Buffer3.isBuffer(signature)) {
      return signature;
    } else if (typeof signature === "string") {
      return Buffer3.from(signature, "base64");
    }
    throw new TypeError("ECDSA signature must be a Base64 string or a Buffer");
  }
  function derToJose(signature, alg) {
    signature = signatureAsBuffer(signature);
    var paramBytes = getParamBytesForAlg(alg);
    var maxEncodedParamLength = paramBytes + 1;
    var inputLength = signature.length;
    var offset = 0;
    if (signature[offset++] !== ENCODED_TAG_SEQ) {
      throw new Error('Could not find expected "seq"');
    }
    var seqLength = signature[offset++];
    if (seqLength === (MAX_OCTET | 1)) {
      seqLength = signature[offset++];
    }
    if (inputLength - offset < seqLength) {
      throw new Error('"seq" specified length of "' + seqLength + '", only "' + (inputLength - offset) + '" remaining');
    }
    if (signature[offset++] !== ENCODED_TAG_INT) {
      throw new Error('Could not find expected "int" for "r"');
    }
    var rLength = signature[offset++];
    if (inputLength - offset - 2 < rLength) {
      throw new Error('"r" specified length of "' + rLength + '", only "' + (inputLength - offset - 2) + '" available');
    }
    if (maxEncodedParamLength < rLength) {
      throw new Error('"r" specified length of "' + rLength + '", max of "' + maxEncodedParamLength + '" is acceptable');
    }
    var rOffset = offset;
    offset += rLength;
    if (signature[offset++] !== ENCODED_TAG_INT) {
      throw new Error('Could not find expected "int" for "s"');
    }
    var sLength = signature[offset++];
    if (inputLength - offset !== sLength) {
      throw new Error('"s" specified length of "' + sLength + '", expected "' + (inputLength - offset) + '"');
    }
    if (maxEncodedParamLength < sLength) {
      throw new Error('"s" specified length of "' + sLength + '", max of "' + maxEncodedParamLength + '" is acceptable');
    }
    var sOffset = offset;
    offset += sLength;
    if (offset !== inputLength) {
      throw new Error('Expected to consume entire buffer, but "' + (inputLength - offset) + '" bytes remain');
    }
    var rPadding = paramBytes - rLength, sPadding = paramBytes - sLength;
    var dst = Buffer3.allocUnsafe(rPadding + rLength + sPadding + sLength);
    for (offset = 0;offset < rPadding; ++offset) {
      dst[offset] = 0;
    }
    signature.copy(dst, offset, rOffset + Math.max(-rPadding, 0), rOffset + rLength);
    offset = paramBytes;
    for (var o = offset;offset < o + sPadding; ++offset) {
      dst[offset] = 0;
    }
    signature.copy(dst, offset, sOffset + Math.max(-sPadding, 0), sOffset + sLength);
    dst = dst.toString("base64");
    dst = base64Url(dst);
    return dst;
  }
  function countPadding(buf, start, stop) {
    var padding = 0;
    while (start + padding < stop && buf[start + padding] === 0) {
      ++padding;
    }
    var needsSign = buf[start + padding] >= MAX_OCTET;
    if (needsSign) {
      --padding;
    }
    return padding;
  }
  function joseToDer(signature, alg) {
    signature = signatureAsBuffer(signature);
    var paramBytes = getParamBytesForAlg(alg);
    var signatureBytes = signature.length;
    if (signatureBytes !== paramBytes * 2) {
      throw new TypeError('"' + alg + '" signatures must be "' + paramBytes * 2 + '" bytes, saw "' + signatureBytes + '"');
    }
    var rPadding = countPadding(signature, 0, paramBytes);
    var sPadding = countPadding(signature, paramBytes, signature.length);
    var rLength = paramBytes - rPadding;
    var sLength = paramBytes - sPadding;
    var rsBytes = 1 + 1 + rLength + 1 + 1 + sLength;
    var shortLength = rsBytes < MAX_OCTET;
    var dst = Buffer3.allocUnsafe((shortLength ? 2 : 3) + rsBytes);
    var offset = 0;
    dst[offset++] = ENCODED_TAG_SEQ;
    if (shortLength) {
      dst[offset++] = rsBytes;
    } else {
      dst[offset++] = MAX_OCTET | 1;
      dst[offset++] = rsBytes & 255;
    }
    dst[offset++] = ENCODED_TAG_INT;
    dst[offset++] = rLength;
    if (rPadding < 0) {
      dst[offset++] = 0;
      offset += signature.copy(dst, offset, 0, paramBytes);
    } else {
      offset += signature.copy(dst, offset, rPadding, paramBytes);
    }
    dst[offset++] = ENCODED_TAG_INT;
    dst[offset++] = sLength;
    if (sPadding < 0) {
      dst[offset++] = 0;
      signature.copy(dst, offset, paramBytes);
    } else {
      signature.copy(dst, offset, paramBytes + sPadding);
    }
    return dst;
  }
  module.exports = {
    derToJose,
    joseToDer
  };
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/util.js
var require_util2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.LRUCache = undefined;
  exports.snakeToCamel = snakeToCamel;
  exports.originalOrCamelOptions = originalOrCamelOptions;
  exports.removeUndefinedValuesInObject = removeUndefinedValuesInObject;
  exports.isValidFile = isValidFile;
  exports.getWellKnownCertificateConfigFileLocation = getWellKnownCertificateConfigFileLocation;
  var fs6 = __require("fs");
  var os2 = __require("os");
  var path4 = __require("path");
  var WELL_KNOWN_CERTIFICATE_CONFIG_FILE = "certificate_config.json";
  var CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
  function snakeToCamel(str2) {
    return str2.replace(/([_][^_])/g, (match2) => match2.slice(1).toUpperCase());
  }
  function originalOrCamelOptions(obj) {
    function get(key) {
      const o = obj || {};
      return o[key] ?? o[snakeToCamel(key)];
    }
    return { get };
  }

  class LRUCache {
    capacity;
    #cache = new Map;
    maxAge;
    constructor(options) {
      this.capacity = options.capacity;
      this.maxAge = options.maxAge;
    }
    #moveToEnd(key, value) {
      this.#cache.delete(key);
      this.#cache.set(key, {
        value,
        lastAccessed: Date.now()
      });
    }
    set(key, value) {
      this.#moveToEnd(key, value);
      this.#evict();
    }
    get(key) {
      const item = this.#cache.get(key);
      if (!item)
        return;
      this.#moveToEnd(key, item.value);
      this.#evict();
      return item.value;
    }
    #evict() {
      const cutoffDate = this.maxAge ? Date.now() - this.maxAge : 0;
      let oldestItem = this.#cache.entries().next();
      while (!oldestItem.done && (this.#cache.size > this.capacity || oldestItem.value[1].lastAccessed < cutoffDate)) {
        this.#cache.delete(oldestItem.value[0]);
        oldestItem = this.#cache.entries().next();
      }
    }
  }
  exports.LRUCache = LRUCache;
  function removeUndefinedValuesInObject(object) {
    Object.entries(object).forEach(([key, value]) => {
      if (value === undefined || value === "undefined") {
        delete object[key];
      }
    });
    return object;
  }
  async function isValidFile(filePath) {
    try {
      const stats = await fs6.promises.lstat(filePath);
      return stats.isFile();
    } catch (e) {
      return false;
    }
  }
  function getWellKnownCertificateConfigFileLocation() {
    const configDir = process.env.CLOUDSDK_CONFIG || (_isWindows() ? path4.join(process.env.APPDATA || "", CLOUDSDK_CONFIG_DIRECTORY) : path4.join(process.env.HOME || "", ".config", CLOUDSDK_CONFIG_DIRECTORY));
    return path4.join(configDir, WELL_KNOWN_CERTIFICATE_CONFIG_FILE);
  }
  function _isWindows() {
    return os2.platform().startsWith("win");
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/package.json
var require_package2 = __commonJS((exports, module) => {
  module.exports = {
    name: "google-auth-library",
    version: "10.5.0",
    author: "Google Inc.",
    description: "Google APIs Authentication Client Library for Node.js",
    engines: {
      node: ">=18"
    },
    main: "./build/src/index.js",
    types: "./build/src/index.d.ts",
    repository: "googleapis/google-auth-library-nodejs.git",
    keywords: [
      "google",
      "api",
      "google apis",
      "client",
      "client library"
    ],
    dependencies: {
      "base64-js": "^1.3.0",
      "ecdsa-sig-formatter": "^1.0.11",
      gaxios: "^7.0.0",
      "gcp-metadata": "^8.0.0",
      "google-logging-utils": "^1.0.0",
      gtoken: "^8.0.0",
      jws: "^4.0.0"
    },
    devDependencies: {
      "@types/base64-js": "^1.2.5",
      "@types/jws": "^3.1.0",
      "@types/mocha": "^10.0.10",
      "@types/mv": "^2.1.0",
      "@types/ncp": "^2.0.1",
      "@types/node": "^22.0.0",
      "@types/sinon": "^17.0.0",
      "assert-rejects": "^1.0.0",
      c8: "^10.0.0",
      codecov: "^3.0.2",
      gts: "^6.0.0",
      "is-docker": "^3.0.0",
      jsdoc: "^4.0.0",
      "jsdoc-fresh": "^5.0.0",
      "jsdoc-region-tag": "^4.0.0",
      karma: "^6.0.0",
      "karma-chrome-launcher": "^3.0.0",
      "karma-coverage": "^2.0.0",
      "karma-firefox-launcher": "^2.0.0",
      "karma-mocha": "^2.0.0",
      "karma-sourcemap-loader": "^0.4.0",
      "karma-webpack": "^5.0.1",
      keypair: "^1.0.4",
      mocha: "^11.1.0",
      mv: "^2.1.1",
      ncp: "^2.0.0",
      nock: "^14.0.5",
      "null-loader": "^4.0.0",
      puppeteer: "^24.0.0",
      sinon: "^21.0.0",
      "ts-loader": "^8.0.0",
      typescript: "5.8.2",
      webpack: "^5.21.2",
      "webpack-cli": "^4.0.0"
    },
    files: [
      "build/src",
      "!build/src/**/*.map"
    ],
    scripts: {
      test: "c8 mocha build/test",
      clean: "gts clean",
      prepare: "npm run compile",
      lint: "gts check --no-inline-config",
      compile: "tsc -p .",
      fix: "gts fix",
      pretest: "npm run compile -- --sourceMap",
      docs: "jsdoc -c .jsdoc.js",
      "samples-setup": "cd samples/ && npm link ../ && npm run setup && cd ../",
      "samples-test": "cd samples/ && npm link ../ && npm test && cd ../",
      "system-test": "mocha build/system-test --timeout 60000",
      "presystem-test": "npm run compile -- --sourceMap",
      webpack: "webpack",
      "browser-test": "karma start",
      "docs-test": "echo 'disabled until linkinator is fixed'",
      "predocs-test": "npm run docs",
      prelint: "cd samples; npm link ../; npm install"
    },
    license: "Apache-2.0"
  };
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/shared.cjs
var require_shared2 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.USER_AGENT = exports.PRODUCT_NAME = exports.pkg = undefined;
  var pkg = require_package2();
  exports.pkg = pkg;
  var PRODUCT_NAME = "google-api-nodejs-client";
  exports.PRODUCT_NAME = PRODUCT_NAME;
  var USER_AGENT = `${PRODUCT_NAME}/${pkg.version}`;
  exports.USER_AGENT = USER_AGENT;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/authclient.js
var require_authclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AuthClient = exports.DEFAULT_EAGER_REFRESH_THRESHOLD_MILLIS = exports.DEFAULT_UNIVERSE = undefined;
  var events_1 = __require("events");
  var gaxios_1 = require_src2();
  var util_1 = require_util2();
  var google_logging_utils_1 = require_src3();
  var shared_cjs_1 = require_shared2();
  exports.DEFAULT_UNIVERSE = "googleapis.com";
  exports.DEFAULT_EAGER_REFRESH_THRESHOLD_MILLIS = 5 * 60 * 1000;

  class AuthClient extends events_1.EventEmitter {
    apiKey;
    projectId;
    quotaProjectId;
    transporter;
    credentials = {};
    eagerRefreshThresholdMillis = exports.DEFAULT_EAGER_REFRESH_THRESHOLD_MILLIS;
    forceRefreshOnFailure = false;
    universeDomain = exports.DEFAULT_UNIVERSE;
    static RequestMethodNameSymbol = Symbol("request method name");
    static RequestLogIdSymbol = Symbol("request log id");
    constructor(opts = {}) {
      super();
      const options = (0, util_1.originalOrCamelOptions)(opts);
      this.apiKey = opts.apiKey;
      this.projectId = options.get("project_id") ?? null;
      this.quotaProjectId = options.get("quota_project_id");
      this.credentials = options.get("credentials") ?? {};
      this.universeDomain = options.get("universe_domain") ?? exports.DEFAULT_UNIVERSE;
      this.transporter = opts.transporter ?? new gaxios_1.Gaxios(opts.transporterOptions);
      if (options.get("useAuthRequestParameters") !== false) {
        this.transporter.interceptors.request.add(AuthClient.DEFAULT_REQUEST_INTERCEPTOR);
        this.transporter.interceptors.response.add(AuthClient.DEFAULT_RESPONSE_INTERCEPTOR);
      }
      if (opts.eagerRefreshThresholdMillis) {
        this.eagerRefreshThresholdMillis = opts.eagerRefreshThresholdMillis;
      }
      this.forceRefreshOnFailure = opts.forceRefreshOnFailure ?? false;
    }
    fetch(...args) {
      const input = args[0];
      const init = args[1];
      let url = undefined;
      const headers = new Headers;
      if (typeof input === "string") {
        url = new URL(input);
      } else if (input instanceof URL) {
        url = input;
      } else if (input && input.url) {
        url = new URL(input.url);
      }
      if (input && typeof input === "object" && "headers" in input) {
        gaxios_1.Gaxios.mergeHeaders(headers, input.headers);
      }
      if (init) {
        gaxios_1.Gaxios.mergeHeaders(headers, new Headers(init.headers));
      }
      if (typeof input === "object" && !(input instanceof URL)) {
        return this.request({ ...init, ...input, headers, url });
      } else {
        return this.request({ ...init, headers, url });
      }
    }
    setCredentials(credentials) {
      this.credentials = credentials;
    }
    addSharedMetadataHeaders(headers) {
      if (!headers.has("x-goog-user-project") && this.quotaProjectId) {
        headers.set("x-goog-user-project", this.quotaProjectId);
      }
      return headers;
    }
    addUserProjectAndAuthHeaders(target, source) {
      const xGoogUserProject = source.get("x-goog-user-project");
      const authorizationHeader = source.get("authorization");
      if (xGoogUserProject) {
        target.set("x-goog-user-project", xGoogUserProject);
      }
      if (authorizationHeader) {
        target.set("authorization", authorizationHeader);
      }
      return target;
    }
    static log = (0, google_logging_utils_1.log)("auth");
    static DEFAULT_REQUEST_INTERCEPTOR = {
      resolved: async (config) => {
        if (!config.headers.has("x-goog-api-client")) {
          const nodeVersion = process.version.replace(/^v/, "");
          config.headers.set("x-goog-api-client", `gl-node/${nodeVersion}`);
        }
        const userAgent = config.headers.get("User-Agent");
        if (!userAgent) {
          config.headers.set("User-Agent", shared_cjs_1.USER_AGENT);
        } else if (!userAgent.includes(`${shared_cjs_1.PRODUCT_NAME}/`)) {
          config.headers.set("User-Agent", `${userAgent} ${shared_cjs_1.USER_AGENT}`);
        }
        try {
          const symbols = config;
          const methodName = symbols[AuthClient.RequestMethodNameSymbol];
          const logId = `${Math.floor(Math.random() * 1000)}`;
          symbols[AuthClient.RequestLogIdSymbol] = logId;
          const logObject = {
            url: config.url,
            headers: config.headers
          };
          if (methodName) {
            AuthClient.log.info("%s [%s] request %j", methodName, logId, logObject);
          } else {
            AuthClient.log.info("[%s] request %j", logId, logObject);
          }
        } catch (e) {}
        return config;
      }
    };
    static DEFAULT_RESPONSE_INTERCEPTOR = {
      resolved: async (response) => {
        try {
          const symbols = response.config;
          const methodName = symbols[AuthClient.RequestMethodNameSymbol];
          const logId = symbols[AuthClient.RequestLogIdSymbol];
          if (methodName) {
            AuthClient.log.info("%s [%s] response %j", methodName, logId, response.data);
          } else {
            AuthClient.log.info("[%s] response %j", logId, response.data);
          }
        } catch (e) {}
        return response;
      },
      rejected: async (error3) => {
        try {
          const symbols = error3.config;
          const methodName = symbols[AuthClient.RequestMethodNameSymbol];
          const logId = symbols[AuthClient.RequestLogIdSymbol];
          if (methodName) {
            AuthClient.log.info("%s [%s] error %j", methodName, logId, error3.response?.data);
          } else {
            AuthClient.log.error("[%s] error %j", logId, error3.response?.data);
          }
        } catch (e) {}
        throw error3;
      }
    };
    static setMethodName(config, methodName) {
      try {
        const symbols = config;
        symbols[AuthClient.RequestMethodNameSymbol] = methodName;
      } catch (e) {}
    }
    static get RETRY_CONFIG() {
      return {
        retry: true,
        retryConfig: {
          httpMethodsToRetry: ["GET", "PUT", "POST", "HEAD", "OPTIONS", "DELETE"]
        }
      };
    }
  }
  exports.AuthClient = AuthClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/loginticket.js
var require_loginticket = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.LoginTicket = undefined;

  class LoginTicket {
    envelope;
    payload;
    constructor(env2, pay) {
      this.envelope = env2;
      this.payload = pay;
    }
    getEnvelope() {
      return this.envelope;
    }
    getPayload() {
      return this.payload;
    }
    getUserId() {
      const payload = this.getPayload();
      if (payload && payload.sub) {
        return payload.sub;
      }
      return null;
    }
    getAttributes() {
      return { envelope: this.getEnvelope(), payload: this.getPayload() };
    }
  }
  exports.LoginTicket = LoginTicket;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/oauth2client.js
var require_oauth2client = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.OAuth2Client = exports.ClientAuthentication = exports.CertificateFormat = exports.CodeChallengeMethod = undefined;
  var gaxios_1 = require_src2();
  var querystring = __require("querystring");
  var stream = __require("stream");
  var formatEcdsa = require_ecdsa_sig_formatter();
  var util_1 = require_util2();
  var crypto_1 = require_crypto3();
  var authclient_1 = require_authclient();
  var loginticket_1 = require_loginticket();
  var CodeChallengeMethod;
  (function(CodeChallengeMethod2) {
    CodeChallengeMethod2["Plain"] = "plain";
    CodeChallengeMethod2["S256"] = "S256";
  })(CodeChallengeMethod || (exports.CodeChallengeMethod = CodeChallengeMethod = {}));
  var CertificateFormat;
  (function(CertificateFormat2) {
    CertificateFormat2["PEM"] = "PEM";
    CertificateFormat2["JWK"] = "JWK";
  })(CertificateFormat || (exports.CertificateFormat = CertificateFormat = {}));
  var ClientAuthentication;
  (function(ClientAuthentication2) {
    ClientAuthentication2["ClientSecretPost"] = "ClientSecretPost";
    ClientAuthentication2["ClientSecretBasic"] = "ClientSecretBasic";
    ClientAuthentication2["None"] = "None";
  })(ClientAuthentication || (exports.ClientAuthentication = ClientAuthentication = {}));

  class OAuth2Client extends authclient_1.AuthClient {
    redirectUri;
    certificateCache = {};
    certificateExpiry = null;
    certificateCacheFormat = CertificateFormat.PEM;
    refreshTokenPromises = new Map;
    endpoints;
    issuers;
    clientAuthentication;
    _clientId;
    _clientSecret;
    refreshHandler;
    constructor(options = {}, clientSecret, redirectUri) {
      super(typeof options === "object" ? options : {});
      if (typeof options !== "object") {
        options = {
          clientId: options,
          clientSecret,
          redirectUri
        };
      }
      this._clientId = options.clientId || options.client_id;
      this._clientSecret = options.clientSecret || options.client_secret;
      this.redirectUri = options.redirectUri || options.redirect_uris?.[0];
      this.endpoints = {
        tokenInfoUrl: "https://oauth2.googleapis.com/tokeninfo",
        oauth2AuthBaseUrl: "https://accounts.google.com/o/oauth2/v2/auth",
        oauth2TokenUrl: "https://oauth2.googleapis.com/token",
        oauth2RevokeUrl: "https://oauth2.googleapis.com/revoke",
        oauth2FederatedSignonPemCertsUrl: "https://www.googleapis.com/oauth2/v1/certs",
        oauth2FederatedSignonJwkCertsUrl: "https://www.googleapis.com/oauth2/v3/certs",
        oauth2IapPublicKeyUrl: "https://www.gstatic.com/iap/verify/public_key",
        ...options.endpoints
      };
      this.clientAuthentication = options.clientAuthentication || ClientAuthentication.ClientSecretPost;
      this.issuers = options.issuers || [
        "accounts.google.com",
        "https://accounts.google.com",
        this.universeDomain
      ];
    }
    static GOOGLE_TOKEN_INFO_URL = "https://oauth2.googleapis.com/tokeninfo";
    static CLOCK_SKEW_SECS_ = 300;
    static DEFAULT_MAX_TOKEN_LIFETIME_SECS_ = 86400;
    generateAuthUrl(opts = {}) {
      if (opts.code_challenge_method && !opts.code_challenge) {
        throw new Error("If a code_challenge_method is provided, code_challenge must be included.");
      }
      opts.response_type = opts.response_type || "code";
      opts.client_id = opts.client_id || this._clientId;
      opts.redirect_uri = opts.redirect_uri || this.redirectUri;
      if (Array.isArray(opts.scope)) {
        opts.scope = opts.scope.join(" ");
      }
      const rootUrl = this.endpoints.oauth2AuthBaseUrl.toString();
      return rootUrl + "?" + querystring.stringify(opts);
    }
    generateCodeVerifier() {
      throw new Error("generateCodeVerifier is removed, please use generateCodeVerifierAsync instead.");
    }
    async generateCodeVerifierAsync() {
      const crypto3 = (0, crypto_1.createCrypto)();
      const randomString = crypto3.randomBytesBase64(96);
      const codeVerifier = randomString.replace(/\+/g, "~").replace(/=/g, "_").replace(/\//g, "-");
      const unencodedCodeChallenge = await crypto3.sha256DigestBase64(codeVerifier);
      const codeChallenge = unencodedCodeChallenge.split("=")[0].replace(/\+/g, "-").replace(/\//g, "_");
      return { codeVerifier, codeChallenge };
    }
    getToken(codeOrOptions, callback) {
      const options = typeof codeOrOptions === "string" ? { code: codeOrOptions } : codeOrOptions;
      if (callback) {
        this.getTokenAsync(options).then((r) => callback(null, r.tokens, r.res), (e) => callback(e, null, e.response));
      } else {
        return this.getTokenAsync(options);
      }
    }
    async getTokenAsync(options) {
      const url = this.endpoints.oauth2TokenUrl.toString();
      const headers = new Headers;
      const values2 = {
        client_id: options.client_id || this._clientId,
        code_verifier: options.codeVerifier,
        code: options.code,
        grant_type: "authorization_code",
        redirect_uri: options.redirect_uri || this.redirectUri
      };
      if (this.clientAuthentication === ClientAuthentication.ClientSecretBasic) {
        const basic = Buffer.from(`${this._clientId}:${this._clientSecret}`);
        headers.set("authorization", `Basic ${basic.toString("base64")}`);
      }
      if (this.clientAuthentication === ClientAuthentication.ClientSecretPost) {
        values2.client_secret = this._clientSecret;
      }
      const opts = {
        ...OAuth2Client.RETRY_CONFIG,
        method: "POST",
        url,
        data: new URLSearchParams((0, util_1.removeUndefinedValuesInObject)(values2)),
        headers
      };
      authclient_1.AuthClient.setMethodName(opts, "getTokenAsync");
      const res = await this.transporter.request(opts);
      const tokens = res.data;
      if (res.data && res.data.expires_in) {
        tokens.expiry_date = new Date().getTime() + res.data.expires_in * 1000;
        delete tokens.expires_in;
      }
      this.emit("tokens", tokens);
      return { tokens, res };
    }
    async refreshToken(refreshToken) {
      if (!refreshToken) {
        return this.refreshTokenNoCache(refreshToken);
      }
      if (this.refreshTokenPromises.has(refreshToken)) {
        return this.refreshTokenPromises.get(refreshToken);
      }
      const p = this.refreshTokenNoCache(refreshToken).then((r) => {
        this.refreshTokenPromises.delete(refreshToken);
        return r;
      }, (e) => {
        this.refreshTokenPromises.delete(refreshToken);
        throw e;
      });
      this.refreshTokenPromises.set(refreshToken, p);
      return p;
    }
    async refreshTokenNoCache(refreshToken) {
      if (!refreshToken) {
        throw new Error("No refresh token is set.");
      }
      const url = this.endpoints.oauth2TokenUrl.toString();
      const data = {
        refresh_token: refreshToken,
        client_id: this._clientId,
        client_secret: this._clientSecret,
        grant_type: "refresh_token"
      };
      let res;
      try {
        const opts = {
          ...OAuth2Client.RETRY_CONFIG,
          method: "POST",
          url,
          data: new URLSearchParams((0, util_1.removeUndefinedValuesInObject)(data))
        };
        authclient_1.AuthClient.setMethodName(opts, "refreshTokenNoCache");
        res = await this.transporter.request(opts);
      } catch (e) {
        if (e instanceof gaxios_1.GaxiosError && e.message === "invalid_grant" && e.response?.data && /ReAuth/i.test(e.response.data.error_description)) {
          e.message = JSON.stringify(e.response.data);
        }
        throw e;
      }
      const tokens = res.data;
      if (res.data && res.data.expires_in) {
        tokens.expiry_date = new Date().getTime() + res.data.expires_in * 1000;
        delete tokens.expires_in;
      }
      this.emit("tokens", tokens);
      return { tokens, res };
    }
    refreshAccessToken(callback) {
      if (callback) {
        this.refreshAccessTokenAsync().then((r) => callback(null, r.credentials, r.res), callback);
      } else {
        return this.refreshAccessTokenAsync();
      }
    }
    async refreshAccessTokenAsync() {
      const r = await this.refreshToken(this.credentials.refresh_token);
      const tokens = r.tokens;
      tokens.refresh_token = this.credentials.refresh_token;
      this.credentials = tokens;
      return { credentials: this.credentials, res: r.res };
    }
    getAccessToken(callback) {
      if (callback) {
        this.getAccessTokenAsync().then((r) => callback(null, r.token, r.res), callback);
      } else {
        return this.getAccessTokenAsync();
      }
    }
    async getAccessTokenAsync() {
      const shouldRefresh = !this.credentials.access_token || this.isTokenExpiring();
      if (shouldRefresh) {
        if (!this.credentials.refresh_token) {
          if (this.refreshHandler) {
            const refreshedAccessToken = await this.processAndValidateRefreshHandler();
            if (refreshedAccessToken?.access_token) {
              this.setCredentials(refreshedAccessToken);
              return { token: this.credentials.access_token };
            }
          } else {
            throw new Error("No refresh token or refresh handler callback is set.");
          }
        }
        const r = await this.refreshAccessTokenAsync();
        if (!r.credentials || r.credentials && !r.credentials.access_token) {
          throw new Error("Could not refresh access token.");
        }
        return { token: r.credentials.access_token, res: r.res };
      } else {
        return { token: this.credentials.access_token };
      }
    }
    async getRequestHeaders(url) {
      const headers = (await this.getRequestMetadataAsync(url)).headers;
      return headers;
    }
    async getRequestMetadataAsync(url) {
      const thisCreds = this.credentials;
      if (!thisCreds.access_token && !thisCreds.refresh_token && !this.apiKey && !this.refreshHandler) {
        throw new Error("No access, refresh token, API key or refresh handler callback is set.");
      }
      if (thisCreds.access_token && !this.isTokenExpiring()) {
        thisCreds.token_type = thisCreds.token_type || "Bearer";
        const headers2 = new Headers({
          authorization: thisCreds.token_type + " " + thisCreds.access_token
        });
        return { headers: this.addSharedMetadataHeaders(headers2) };
      }
      if (this.refreshHandler) {
        const refreshedAccessToken = await this.processAndValidateRefreshHandler();
        if (refreshedAccessToken?.access_token) {
          this.setCredentials(refreshedAccessToken);
          const headers2 = new Headers({
            authorization: "Bearer " + this.credentials.access_token
          });
          return { headers: this.addSharedMetadataHeaders(headers2) };
        }
      }
      if (this.apiKey) {
        return { headers: new Headers({ "X-Goog-Api-Key": this.apiKey }) };
      }
      let r = null;
      let tokens = null;
      try {
        r = await this.refreshToken(thisCreds.refresh_token);
        tokens = r.tokens;
      } catch (err) {
        const e = err;
        if (e.response && (e.response.status === 403 || e.response.status === 404)) {
          e.message = `Could not refresh access token: ${e.message}`;
        }
        throw e;
      }
      const credentials = this.credentials;
      credentials.token_type = credentials.token_type || "Bearer";
      tokens.refresh_token = credentials.refresh_token;
      this.credentials = tokens;
      const headers = new Headers({
        authorization: credentials.token_type + " " + tokens.access_token
      });
      return { headers: this.addSharedMetadataHeaders(headers), res: r.res };
    }
    static getRevokeTokenUrl(token) {
      return new OAuth2Client().getRevokeTokenURL(token).toString();
    }
    getRevokeTokenURL(token) {
      const url = new URL(this.endpoints.oauth2RevokeUrl);
      url.searchParams.append("token", token);
      return url;
    }
    revokeToken(token, callback) {
      const opts = {
        ...OAuth2Client.RETRY_CONFIG,
        url: this.getRevokeTokenURL(token).toString(),
        method: "POST"
      };
      authclient_1.AuthClient.setMethodName(opts, "revokeToken");
      if (callback) {
        this.transporter.request(opts).then((r) => callback(null, r), callback);
      } else {
        return this.transporter.request(opts);
      }
    }
    revokeCredentials(callback) {
      if (callback) {
        this.revokeCredentialsAsync().then((res) => callback(null, res), callback);
      } else {
        return this.revokeCredentialsAsync();
      }
    }
    async revokeCredentialsAsync() {
      const token = this.credentials.access_token;
      this.credentials = {};
      if (token) {
        return this.revokeToken(token);
      } else {
        throw new Error("No access token to revoke.");
      }
    }
    request(opts, callback) {
      if (callback) {
        this.requestAsync(opts).then((r) => callback(null, r), (e) => {
          return callback(e, e.response);
        });
      } else {
        return this.requestAsync(opts);
      }
    }
    async requestAsync(opts, reAuthRetried = false) {
      try {
        const r = await this.getRequestMetadataAsync();
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
        this.addUserProjectAndAuthHeaders(opts.headers, r.headers);
        if (this.apiKey) {
          opts.headers.set("X-Goog-Api-Key", this.apiKey);
        }
        return await this.transporter.request(opts);
      } catch (e) {
        const res = e.response;
        if (res) {
          const statusCode = res.status;
          const mayRequireRefresh = this.credentials && this.credentials.access_token && this.credentials.refresh_token && (!this.credentials.expiry_date || this.forceRefreshOnFailure);
          const mayRequireRefreshWithNoRefreshToken = this.credentials && this.credentials.access_token && !this.credentials.refresh_token && (!this.credentials.expiry_date || this.forceRefreshOnFailure) && this.refreshHandler;
          const isReadableStream = res.config.data instanceof stream.Readable;
          const isAuthErr = statusCode === 401 || statusCode === 403;
          if (!reAuthRetried && isAuthErr && !isReadableStream && mayRequireRefresh) {
            await this.refreshAccessTokenAsync();
            return this.requestAsync(opts, true);
          } else if (!reAuthRetried && isAuthErr && !isReadableStream && mayRequireRefreshWithNoRefreshToken) {
            const refreshedAccessToken = await this.processAndValidateRefreshHandler();
            if (refreshedAccessToken?.access_token) {
              this.setCredentials(refreshedAccessToken);
            }
            return this.requestAsync(opts, true);
          }
        }
        throw e;
      }
    }
    verifyIdToken(options, callback) {
      if (callback && typeof callback !== "function") {
        throw new Error("This method accepts an options object as the first parameter, which includes the idToken, audience, and maxExpiry.");
      }
      if (callback) {
        this.verifyIdTokenAsync(options).then((r) => callback(null, r), callback);
      } else {
        return this.verifyIdTokenAsync(options);
      }
    }
    async verifyIdTokenAsync(options) {
      if (!options.idToken) {
        throw new Error("The verifyIdToken method requires an ID Token");
      }
      const response = await this.getFederatedSignonCertsAsync();
      const login = await this.verifySignedJwtWithCertsAsync(options.idToken, response.certs, options.audience, this.issuers, options.maxExpiry);
      return login;
    }
    async getTokenInfo(accessToken) {
      const { data } = await this.transporter.request({
        ...OAuth2Client.RETRY_CONFIG,
        method: "POST",
        headers: {
          "content-type": "application/x-www-form-urlencoded;charset=UTF-8",
          authorization: `Bearer ${accessToken}`
        },
        url: this.endpoints.tokenInfoUrl.toString()
      });
      const info = Object.assign({
        expiry_date: new Date().getTime() + data.expires_in * 1000,
        scopes: data.scope.split(" ")
      }, data);
      delete info.expires_in;
      delete info.scope;
      return info;
    }
    getFederatedSignonCerts(callback) {
      if (callback) {
        this.getFederatedSignonCertsAsync().then((r) => callback(null, r.certs, r.res), callback);
      } else {
        return this.getFederatedSignonCertsAsync();
      }
    }
    async getFederatedSignonCertsAsync() {
      const nowTime = new Date().getTime();
      const format = (0, crypto_1.hasBrowserCrypto)() ? CertificateFormat.JWK : CertificateFormat.PEM;
      if (this.certificateExpiry && nowTime < this.certificateExpiry.getTime() && this.certificateCacheFormat === format) {
        return { certs: this.certificateCache, format };
      }
      let res;
      let url;
      switch (format) {
        case CertificateFormat.PEM:
          url = this.endpoints.oauth2FederatedSignonPemCertsUrl.toString();
          break;
        case CertificateFormat.JWK:
          url = this.endpoints.oauth2FederatedSignonJwkCertsUrl.toString();
          break;
        default:
          throw new Error(`Unsupported certificate format ${format}`);
      }
      try {
        const opts = {
          ...OAuth2Client.RETRY_CONFIG,
          url
        };
        authclient_1.AuthClient.setMethodName(opts, "getFederatedSignonCertsAsync");
        res = await this.transporter.request(opts);
      } catch (e) {
        if (e instanceof Error) {
          e.message = `Failed to retrieve verification certificates: ${e.message}`;
        }
        throw e;
      }
      const cacheControl = res?.headers.get("cache-control");
      let cacheAge = -1;
      if (cacheControl) {
        const maxAge = /max-age=(?<maxAge>[0-9]+)/.exec(cacheControl)?.groups?.maxAge;
        if (maxAge) {
          cacheAge = Number(maxAge) * 1000;
        }
      }
      let certificates = {};
      switch (format) {
        case CertificateFormat.PEM:
          certificates = res.data;
          break;
        case CertificateFormat.JWK:
          for (const key of res.data.keys) {
            certificates[key.kid] = key;
          }
          break;
        default:
          throw new Error(`Unsupported certificate format ${format}`);
      }
      const now = new Date;
      this.certificateExpiry = cacheAge === -1 ? null : new Date(now.getTime() + cacheAge);
      this.certificateCache = certificates;
      this.certificateCacheFormat = format;
      return { certs: certificates, format, res };
    }
    getIapPublicKeys(callback) {
      if (callback) {
        this.getIapPublicKeysAsync().then((r) => callback(null, r.pubkeys, r.res), callback);
      } else {
        return this.getIapPublicKeysAsync();
      }
    }
    async getIapPublicKeysAsync() {
      let res;
      const url = this.endpoints.oauth2IapPublicKeyUrl.toString();
      try {
        const opts = {
          ...OAuth2Client.RETRY_CONFIG,
          url
        };
        authclient_1.AuthClient.setMethodName(opts, "getIapPublicKeysAsync");
        res = await this.transporter.request(opts);
      } catch (e) {
        if (e instanceof Error) {
          e.message = `Failed to retrieve verification certificates: ${e.message}`;
        }
        throw e;
      }
      return { pubkeys: res.data, res };
    }
    verifySignedJwtWithCerts() {
      throw new Error("verifySignedJwtWithCerts is removed, please use verifySignedJwtWithCertsAsync instead.");
    }
    async verifySignedJwtWithCertsAsync(jwt, certs, requiredAudience, issuers, maxExpiry) {
      const crypto3 = (0, crypto_1.createCrypto)();
      if (!maxExpiry) {
        maxExpiry = OAuth2Client.DEFAULT_MAX_TOKEN_LIFETIME_SECS_;
      }
      const segments = jwt.split(".");
      if (segments.length !== 3) {
        throw new Error("Wrong number of segments in token: " + jwt);
      }
      const signed = segments[0] + "." + segments[1];
      let signature = segments[2];
      let envelope;
      let payload;
      try {
        envelope = JSON.parse(crypto3.decodeBase64StringUtf8(segments[0]));
      } catch (err) {
        if (err instanceof Error) {
          err.message = `Can't parse token envelope: ${segments[0]}': ${err.message}`;
        }
        throw err;
      }
      if (!envelope) {
        throw new Error("Can't parse token envelope: " + segments[0]);
      }
      try {
        payload = JSON.parse(crypto3.decodeBase64StringUtf8(segments[1]));
      } catch (err) {
        if (err instanceof Error) {
          err.message = `Can't parse token payload '${segments[0]}`;
        }
        throw err;
      }
      if (!payload) {
        throw new Error("Can't parse token payload: " + segments[1]);
      }
      if (!Object.prototype.hasOwnProperty.call(certs, envelope.kid)) {
        throw new Error("No pem found for envelope: " + JSON.stringify(envelope));
      }
      const cert = certs[envelope.kid];
      if (envelope.alg === "ES256") {
        signature = formatEcdsa.joseToDer(signature, "ES256").toString("base64");
      }
      const verified = await crypto3.verify(cert, signed, signature);
      if (!verified) {
        throw new Error("Invalid token signature: " + jwt);
      }
      if (!payload.iat) {
        throw new Error("No issue time in token: " + JSON.stringify(payload));
      }
      if (!payload.exp) {
        throw new Error("No expiration time in token: " + JSON.stringify(payload));
      }
      const iat = Number(payload.iat);
      if (isNaN(iat))
        throw new Error("iat field using invalid format");
      const exp = Number(payload.exp);
      if (isNaN(exp))
        throw new Error("exp field using invalid format");
      const now = new Date().getTime() / 1000;
      if (exp >= now + maxExpiry) {
        throw new Error("Expiration time too far in future: " + JSON.stringify(payload));
      }
      const earliest = iat - OAuth2Client.CLOCK_SKEW_SECS_;
      const latest = exp + OAuth2Client.CLOCK_SKEW_SECS_;
      if (now < earliest) {
        throw new Error("Token used too early, " + now + " < " + earliest + ": " + JSON.stringify(payload));
      }
      if (now > latest) {
        throw new Error("Token used too late, " + now + " > " + latest + ": " + JSON.stringify(payload));
      }
      if (issuers && issuers.indexOf(payload.iss) < 0) {
        throw new Error("Invalid issuer, expected one of [" + issuers + "], but got " + payload.iss);
      }
      if (typeof requiredAudience !== "undefined" && requiredAudience !== null) {
        const aud = payload.aud;
        let audVerified = false;
        if (requiredAudience.constructor === Array) {
          audVerified = requiredAudience.indexOf(aud) > -1;
        } else {
          audVerified = aud === requiredAudience;
        }
        if (!audVerified) {
          throw new Error("Wrong recipient, payload audience != requiredAudience");
        }
      }
      return new loginticket_1.LoginTicket(envelope, payload);
    }
    async processAndValidateRefreshHandler() {
      if (this.refreshHandler) {
        const accessTokenResponse = await this.refreshHandler();
        if (!accessTokenResponse.access_token) {
          throw new Error("No access token is returned by the refreshHandler callback.");
        }
        return accessTokenResponse;
      }
      return;
    }
    isTokenExpiring() {
      const expiryDate = this.credentials.expiry_date;
      return expiryDate ? expiryDate <= new Date().getTime() + this.eagerRefreshThresholdMillis : false;
    }
  }
  exports.OAuth2Client = OAuth2Client;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/computeclient.js
var require_computeclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Compute = undefined;
  var gaxios_1 = require_src2();
  var gcpMetadata = require_src4();
  var oauth2client_1 = require_oauth2client();

  class Compute extends oauth2client_1.OAuth2Client {
    serviceAccountEmail;
    scopes;
    constructor(options = {}) {
      super(options);
      this.credentials = { expiry_date: 1, refresh_token: "compute-placeholder" };
      this.serviceAccountEmail = options.serviceAccountEmail || "default";
      this.scopes = Array.isArray(options.scopes) ? options.scopes : options.scopes ? [options.scopes] : [];
    }
    async refreshTokenNoCache() {
      const tokenPath = `service-accounts/${this.serviceAccountEmail}/token`;
      let data;
      try {
        const instanceOptions = {
          property: tokenPath
        };
        if (this.scopes.length > 0) {
          instanceOptions.params = {
            scopes: this.scopes.join(",")
          };
        }
        data = await gcpMetadata.instance(instanceOptions);
      } catch (e) {
        if (e instanceof gaxios_1.GaxiosError) {
          e.message = `Could not refresh access token: ${e.message}`;
          this.wrapError(e);
        }
        throw e;
      }
      const tokens = data;
      if (data && data.expires_in) {
        tokens.expiry_date = new Date().getTime() + data.expires_in * 1000;
        delete tokens.expires_in;
      }
      this.emit("tokens", tokens);
      return { tokens, res: null };
    }
    async fetchIdToken(targetAudience) {
      const idTokenPath = `service-accounts/${this.serviceAccountEmail}/identity` + `?format=full&audience=${targetAudience}`;
      let idToken;
      try {
        const instanceOptions = {
          property: idTokenPath
        };
        idToken = await gcpMetadata.instance(instanceOptions);
      } catch (e) {
        if (e instanceof Error) {
          e.message = `Could not fetch ID token: ${e.message}`;
        }
        throw e;
      }
      return idToken;
    }
    wrapError(e) {
      const res = e.response;
      if (res && res.status) {
        e.status = res.status;
        if (res.status === 403) {
          e.message = "A Forbidden error was returned while attempting to retrieve an access " + "token for the Compute Engine built-in service account. This may be because the Compute " + "Engine instance does not have the correct permission scopes specified: " + e.message;
        } else if (res.status === 404) {
          e.message = "A Not Found error was returned while attempting to retrieve an access" + "token for the Compute Engine built-in service account. This may be because the Compute " + "Engine instance does not have any permission scopes specified: " + e.message;
        }
      }
    }
  }
  exports.Compute = Compute;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/idtokenclient.js
var require_idtokenclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IdTokenClient = undefined;
  var oauth2client_1 = require_oauth2client();

  class IdTokenClient extends oauth2client_1.OAuth2Client {
    targetAudience;
    idTokenProvider;
    constructor(options) {
      super(options);
      this.targetAudience = options.targetAudience;
      this.idTokenProvider = options.idTokenProvider;
    }
    async getRequestMetadataAsync() {
      if (!this.credentials.id_token || !this.credentials.expiry_date || this.isTokenExpiring()) {
        const idToken = await this.idTokenProvider.fetchIdToken(this.targetAudience);
        this.credentials = {
          id_token: idToken,
          expiry_date: this.getIdTokenExpiryDate(idToken)
        };
      }
      const headers = new Headers({
        authorization: "Bearer " + this.credentials.id_token
      });
      return { headers };
    }
    getIdTokenExpiryDate(idToken) {
      const payloadB64 = idToken.split(".")[1];
      if (payloadB64) {
        const payload = JSON.parse(Buffer.from(payloadB64, "base64").toString("ascii"));
        return payload.exp * 1000;
      }
    }
  }
  exports.IdTokenClient = IdTokenClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/envDetect.js
var require_envDetect = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GCPEnv = undefined;
  exports.clear = clear;
  exports.getEnv = getEnv;
  var gcpMetadata = require_src4();
  var GCPEnv;
  (function(GCPEnv2) {
    GCPEnv2["APP_ENGINE"] = "APP_ENGINE";
    GCPEnv2["KUBERNETES_ENGINE"] = "KUBERNETES_ENGINE";
    GCPEnv2["CLOUD_FUNCTIONS"] = "CLOUD_FUNCTIONS";
    GCPEnv2["COMPUTE_ENGINE"] = "COMPUTE_ENGINE";
    GCPEnv2["CLOUD_RUN"] = "CLOUD_RUN";
    GCPEnv2["CLOUD_RUN_JOBS"] = "CLOUD_RUN_JOBS";
    GCPEnv2["NONE"] = "NONE";
  })(GCPEnv || (exports.GCPEnv = GCPEnv = {}));
  var envPromise;
  function clear() {
    envPromise = undefined;
  }
  async function getEnv() {
    if (envPromise) {
      return envPromise;
    }
    envPromise = getEnvMemoized();
    return envPromise;
  }
  async function getEnvMemoized() {
    let env2 = GCPEnv.NONE;
    if (isAppEngine()) {
      env2 = GCPEnv.APP_ENGINE;
    } else if (isCloudFunction()) {
      env2 = GCPEnv.CLOUD_FUNCTIONS;
    } else if (await isComputeEngine()) {
      if (await isKubernetesEngine()) {
        env2 = GCPEnv.KUBERNETES_ENGINE;
      } else if (isCloudRun()) {
        env2 = GCPEnv.CLOUD_RUN;
      } else if (isCloudRunJob()) {
        env2 = GCPEnv.CLOUD_RUN_JOBS;
      } else {
        env2 = GCPEnv.COMPUTE_ENGINE;
      }
    } else {
      env2 = GCPEnv.NONE;
    }
    return env2;
  }
  function isAppEngine() {
    return !!(process.env.GAE_SERVICE || process.env.GAE_MODULE_NAME);
  }
  function isCloudFunction() {
    return !!(process.env.FUNCTION_NAME || process.env.FUNCTION_TARGET);
  }
  function isCloudRun() {
    return !!process.env.K_CONFIGURATION;
  }
  function isCloudRunJob() {
    return !!process.env.CLOUD_RUN_JOB;
  }
  async function isKubernetesEngine() {
    try {
      await gcpMetadata.instance("attributes/cluster-name");
      return true;
    } catch (e) {
      return false;
    }
  }
  async function isComputeEngine() {
    return gcpMetadata.isAvailable();
  }
});

// ../node_modules/.bun/jws@4.0.1/node_modules/jws/lib/data-stream.js
var require_data_stream = __commonJS((exports, module) => {
  var Buffer3 = require_safe_buffer().Buffer;
  var Stream3 = __require("stream");
  var util = __require("util");
  function DataStream(data) {
    this.buffer = null;
    this.writable = true;
    this.readable = true;
    if (!data) {
      this.buffer = Buffer3.alloc(0);
      return this;
    }
    if (typeof data.pipe === "function") {
      this.buffer = Buffer3.alloc(0);
      data.pipe(this);
      return this;
    }
    if (data.length || typeof data === "object") {
      this.buffer = data;
      this.writable = false;
      process.nextTick(function() {
        this.emit("end", data);
        this.readable = false;
        this.emit("close");
      }.bind(this));
      return this;
    }
    throw new TypeError("Unexpected data type (" + typeof data + ")");
  }
  util.inherits(DataStream, Stream3);
  DataStream.prototype.write = function write(data) {
    this.buffer = Buffer3.concat([this.buffer, Buffer3.from(data)]);
    this.emit("data", data);
  };
  DataStream.prototype.end = function end(data) {
    if (data)
      this.write(data);
    this.emit("end", data);
    this.emit("close");
    this.writable = false;
    this.readable = false;
  };
  module.exports = DataStream;
});

// ../node_modules/.bun/buffer-equal-constant-time@1.0.1/node_modules/buffer-equal-constant-time/index.js
var require_buffer_equal_constant_time = __commonJS((exports, module) => {
  var Buffer3 = __require("buffer").Buffer;
  var SlowBuffer = __require("buffer").SlowBuffer;
  module.exports = bufferEq;
  function bufferEq(a, b) {
    if (!Buffer3.isBuffer(a) || !Buffer3.isBuffer(b)) {
      return false;
    }
    if (a.length !== b.length) {
      return false;
    }
    var c = 0;
    for (var i = 0;i < a.length; i++) {
      c |= a[i] ^ b[i];
    }
    return c === 0;
  }
  bufferEq.install = function() {
    Buffer3.prototype.equal = SlowBuffer.prototype.equal = function equal(that) {
      return bufferEq(this, that);
    };
  };
  var origBufEqual = Buffer3.prototype.equal;
  var origSlowBufEqual = SlowBuffer.prototype.equal;
  bufferEq.restore = function() {
    Buffer3.prototype.equal = origBufEqual;
    SlowBuffer.prototype.equal = origSlowBufEqual;
  };
});

// ../node_modules/.bun/jwa@2.0.1/node_modules/jwa/index.js
var require_jwa = __commonJS((exports, module) => {
  var Buffer3 = require_safe_buffer().Buffer;
  var crypto3 = __require("crypto");
  var formatEcdsa = require_ecdsa_sig_formatter();
  var util = __require("util");
  var MSG_INVALID_ALGORITHM = `"%s" is not a valid algorithm.
  Supported algorithms are:
  "HS256", "HS384", "HS512", "RS256", "RS384", "RS512", "PS256", "PS384", "PS512", "ES256", "ES384", "ES512" and "none".`;
  var MSG_INVALID_SECRET = "secret must be a string or buffer";
  var MSG_INVALID_VERIFIER_KEY = "key must be a string or a buffer";
  var MSG_INVALID_SIGNER_KEY = "key must be a string, a buffer or an object";
  var supportsKeyObjects = typeof crypto3.createPublicKey === "function";
  if (supportsKeyObjects) {
    MSG_INVALID_VERIFIER_KEY += " or a KeyObject";
    MSG_INVALID_SECRET += "or a KeyObject";
  }
  function checkIsPublicKey(key) {
    if (Buffer3.isBuffer(key)) {
      return;
    }
    if (typeof key === "string") {
      return;
    }
    if (!supportsKeyObjects) {
      throw typeError(MSG_INVALID_VERIFIER_KEY);
    }
    if (typeof key !== "object") {
      throw typeError(MSG_INVALID_VERIFIER_KEY);
    }
    if (typeof key.type !== "string") {
      throw typeError(MSG_INVALID_VERIFIER_KEY);
    }
    if (typeof key.asymmetricKeyType !== "string") {
      throw typeError(MSG_INVALID_VERIFIER_KEY);
    }
    if (typeof key.export !== "function") {
      throw typeError(MSG_INVALID_VERIFIER_KEY);
    }
  }
  function checkIsPrivateKey(key) {
    if (Buffer3.isBuffer(key)) {
      return;
    }
    if (typeof key === "string") {
      return;
    }
    if (typeof key === "object") {
      return;
    }
    throw typeError(MSG_INVALID_SIGNER_KEY);
  }
  function checkIsSecretKey(key) {
    if (Buffer3.isBuffer(key)) {
      return;
    }
    if (typeof key === "string") {
      return key;
    }
    if (!supportsKeyObjects) {
      throw typeError(MSG_INVALID_SECRET);
    }
    if (typeof key !== "object") {
      throw typeError(MSG_INVALID_SECRET);
    }
    if (key.type !== "secret") {
      throw typeError(MSG_INVALID_SECRET);
    }
    if (typeof key.export !== "function") {
      throw typeError(MSG_INVALID_SECRET);
    }
  }
  function fromBase64(base642) {
    return base642.replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
  }
  function toBase64(base64url) {
    base64url = base64url.toString();
    var padding = 4 - base64url.length % 4;
    if (padding !== 4) {
      for (var i = 0;i < padding; ++i) {
        base64url += "=";
      }
    }
    return base64url.replace(/\-/g, "+").replace(/_/g, "/");
  }
  function typeError(template) {
    var args = [].slice.call(arguments, 1);
    var errMsg = util.format.bind(util, template).apply(null, args);
    return new TypeError(errMsg);
  }
  function bufferOrString(obj) {
    return Buffer3.isBuffer(obj) || typeof obj === "string";
  }
  function normalizeInput(thing) {
    if (!bufferOrString(thing))
      thing = JSON.stringify(thing);
    return thing;
  }
  function createHmacSigner(bits) {
    return function sign(thing, secret) {
      checkIsSecretKey(secret);
      thing = normalizeInput(thing);
      var hmac = crypto3.createHmac("sha" + bits, secret);
      var sig = (hmac.update(thing), hmac.digest("base64"));
      return fromBase64(sig);
    };
  }
  var bufferEqual;
  var timingSafeEqual = "timingSafeEqual" in crypto3 ? function timingSafeEqual2(a, b) {
    if (a.byteLength !== b.byteLength) {
      return false;
    }
    return crypto3.timingSafeEqual(a, b);
  } : function timingSafeEqual2(a, b) {
    if (!bufferEqual) {
      bufferEqual = require_buffer_equal_constant_time();
    }
    return bufferEqual(a, b);
  };
  function createHmacVerifier(bits) {
    return function verify(thing, signature, secret) {
      var computedSig = createHmacSigner(bits)(thing, secret);
      return timingSafeEqual(Buffer3.from(signature), Buffer3.from(computedSig));
    };
  }
  function createKeySigner(bits) {
    return function sign(thing, privateKey) {
      checkIsPrivateKey(privateKey);
      thing = normalizeInput(thing);
      var signer = crypto3.createSign("RSA-SHA" + bits);
      var sig = (signer.update(thing), signer.sign(privateKey, "base64"));
      return fromBase64(sig);
    };
  }
  function createKeyVerifier(bits) {
    return function verify(thing, signature, publicKey) {
      checkIsPublicKey(publicKey);
      thing = normalizeInput(thing);
      signature = toBase64(signature);
      var verifier = crypto3.createVerify("RSA-SHA" + bits);
      verifier.update(thing);
      return verifier.verify(publicKey, signature, "base64");
    };
  }
  function createPSSKeySigner(bits) {
    return function sign(thing, privateKey) {
      checkIsPrivateKey(privateKey);
      thing = normalizeInput(thing);
      var signer = crypto3.createSign("RSA-SHA" + bits);
      var sig = (signer.update(thing), signer.sign({
        key: privateKey,
        padding: crypto3.constants.RSA_PKCS1_PSS_PADDING,
        saltLength: crypto3.constants.RSA_PSS_SALTLEN_DIGEST
      }, "base64"));
      return fromBase64(sig);
    };
  }
  function createPSSKeyVerifier(bits) {
    return function verify(thing, signature, publicKey) {
      checkIsPublicKey(publicKey);
      thing = normalizeInput(thing);
      signature = toBase64(signature);
      var verifier = crypto3.createVerify("RSA-SHA" + bits);
      verifier.update(thing);
      return verifier.verify({
        key: publicKey,
        padding: crypto3.constants.RSA_PKCS1_PSS_PADDING,
        saltLength: crypto3.constants.RSA_PSS_SALTLEN_DIGEST
      }, signature, "base64");
    };
  }
  function createECDSASigner(bits) {
    var inner = createKeySigner(bits);
    return function sign() {
      var signature = inner.apply(null, arguments);
      signature = formatEcdsa.derToJose(signature, "ES" + bits);
      return signature;
    };
  }
  function createECDSAVerifer(bits) {
    var inner = createKeyVerifier(bits);
    return function verify(thing, signature, publicKey) {
      signature = formatEcdsa.joseToDer(signature, "ES" + bits).toString("base64");
      var result = inner(thing, signature, publicKey);
      return result;
    };
  }
  function createNoneSigner() {
    return function sign() {
      return "";
    };
  }
  function createNoneVerifier() {
    return function verify(thing, signature) {
      return signature === "";
    };
  }
  module.exports = function jwa(algorithm) {
    var signerFactories = {
      hs: createHmacSigner,
      rs: createKeySigner,
      ps: createPSSKeySigner,
      es: createECDSASigner,
      none: createNoneSigner
    };
    var verifierFactories = {
      hs: createHmacVerifier,
      rs: createKeyVerifier,
      ps: createPSSKeyVerifier,
      es: createECDSAVerifer,
      none: createNoneVerifier
    };
    var match2 = algorithm.match(/^(RS|PS|ES|HS)(256|384|512)$|^(none)$/);
    if (!match2)
      throw typeError(MSG_INVALID_ALGORITHM, algorithm);
    var algo = (match2[1] || match2[3]).toLowerCase();
    var bits = match2[2];
    return {
      sign: signerFactories[algo](bits),
      verify: verifierFactories[algo](bits)
    };
  };
});

// ../node_modules/.bun/jws@4.0.1/node_modules/jws/lib/tostring.js
var require_tostring = __commonJS((exports, module) => {
  var Buffer3 = __require("buffer").Buffer;
  module.exports = function toString(obj) {
    if (typeof obj === "string")
      return obj;
    if (typeof obj === "number" || Buffer3.isBuffer(obj))
      return obj.toString();
    return JSON.stringify(obj);
  };
});

// ../node_modules/.bun/jws@4.0.1/node_modules/jws/lib/sign-stream.js
var require_sign_stream = __commonJS((exports, module) => {
  var Buffer3 = require_safe_buffer().Buffer;
  var DataStream = require_data_stream();
  var jwa = require_jwa();
  var Stream3 = __require("stream");
  var toString = require_tostring();
  var util = __require("util");
  function base64url(string, encoding) {
    return Buffer3.from(string, encoding).toString("base64").replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
  }
  function jwsSecuredInput(header, payload, encoding) {
    encoding = encoding || "utf8";
    var encodedHeader = base64url(toString(header), "binary");
    var encodedPayload = base64url(toString(payload), encoding);
    return util.format("%s.%s", encodedHeader, encodedPayload);
  }
  function jwsSign(opts) {
    var header = opts.header;
    var payload = opts.payload;
    var secretOrKey = opts.secret || opts.privateKey;
    var encoding = opts.encoding;
    var algo = jwa(header.alg);
    var securedInput = jwsSecuredInput(header, payload, encoding);
    var signature = algo.sign(securedInput, secretOrKey);
    return util.format("%s.%s", securedInput, signature);
  }
  function SignStream(opts) {
    var secret = opts.secret;
    secret = secret == null ? opts.privateKey : secret;
    secret = secret == null ? opts.key : secret;
    if (/^hs/i.test(opts.header.alg) === true && secret == null) {
      throw new TypeError("secret must be a string or buffer or a KeyObject");
    }
    var secretStream = new DataStream(secret);
    this.readable = true;
    this.header = opts.header;
    this.encoding = opts.encoding;
    this.secret = this.privateKey = this.key = secretStream;
    this.payload = new DataStream(opts.payload);
    this.secret.once("close", function() {
      if (!this.payload.writable && this.readable)
        this.sign();
    }.bind(this));
    this.payload.once("close", function() {
      if (!this.secret.writable && this.readable)
        this.sign();
    }.bind(this));
  }
  util.inherits(SignStream, Stream3);
  SignStream.prototype.sign = function sign() {
    try {
      var signature = jwsSign({
        header: this.header,
        payload: this.payload.buffer,
        secret: this.secret.buffer,
        encoding: this.encoding
      });
      this.emit("done", signature);
      this.emit("data", signature);
      this.emit("end");
      this.readable = false;
      return signature;
    } catch (e) {
      this.readable = false;
      this.emit("error", e);
      this.emit("close");
    }
  };
  SignStream.sign = jwsSign;
  module.exports = SignStream;
});

// ../node_modules/.bun/jws@4.0.1/node_modules/jws/lib/verify-stream.js
var require_verify_stream = __commonJS((exports, module) => {
  var Buffer3 = require_safe_buffer().Buffer;
  var DataStream = require_data_stream();
  var jwa = require_jwa();
  var Stream3 = __require("stream");
  var toString = require_tostring();
  var util = __require("util");
  var JWS_REGEX = /^[a-zA-Z0-9\-_]+?\.[a-zA-Z0-9\-_]+?\.([a-zA-Z0-9\-_]+)?$/;
  function isObject(thing) {
    return Object.prototype.toString.call(thing) === "[object Object]";
  }
  function safeJsonParse(thing) {
    if (isObject(thing))
      return thing;
    try {
      return JSON.parse(thing);
    } catch (e) {
      return;
    }
  }
  function headerFromJWS(jwsSig) {
    var encodedHeader = jwsSig.split(".", 1)[0];
    return safeJsonParse(Buffer3.from(encodedHeader, "base64").toString("binary"));
  }
  function securedInputFromJWS(jwsSig) {
    return jwsSig.split(".", 2).join(".");
  }
  function signatureFromJWS(jwsSig) {
    return jwsSig.split(".")[2];
  }
  function payloadFromJWS(jwsSig, encoding) {
    encoding = encoding || "utf8";
    var payload = jwsSig.split(".")[1];
    return Buffer3.from(payload, "base64").toString(encoding);
  }
  function isValidJws(string) {
    return JWS_REGEX.test(string) && !!headerFromJWS(string);
  }
  function jwsVerify(jwsSig, algorithm, secretOrKey) {
    if (!algorithm) {
      var err = new Error("Missing algorithm parameter for jws.verify");
      err.code = "MISSING_ALGORITHM";
      throw err;
    }
    jwsSig = toString(jwsSig);
    var signature = signatureFromJWS(jwsSig);
    var securedInput = securedInputFromJWS(jwsSig);
    var algo = jwa(algorithm);
    return algo.verify(securedInput, signature, secretOrKey);
  }
  function jwsDecode(jwsSig, opts) {
    opts = opts || {};
    jwsSig = toString(jwsSig);
    if (!isValidJws(jwsSig))
      return null;
    var header = headerFromJWS(jwsSig);
    if (!header)
      return null;
    var payload = payloadFromJWS(jwsSig);
    if (header.typ === "JWT" || opts.json)
      payload = JSON.parse(payload, opts.encoding);
    return {
      header,
      payload,
      signature: signatureFromJWS(jwsSig)
    };
  }
  function VerifyStream(opts) {
    opts = opts || {};
    var secretOrKey = opts.secret;
    secretOrKey = secretOrKey == null ? opts.publicKey : secretOrKey;
    secretOrKey = secretOrKey == null ? opts.key : secretOrKey;
    if (/^hs/i.test(opts.algorithm) === true && secretOrKey == null) {
      throw new TypeError("secret must be a string or buffer or a KeyObject");
    }
    var secretStream = new DataStream(secretOrKey);
    this.readable = true;
    this.algorithm = opts.algorithm;
    this.encoding = opts.encoding;
    this.secret = this.publicKey = this.key = secretStream;
    this.signature = new DataStream(opts.signature);
    this.secret.once("close", function() {
      if (!this.signature.writable && this.readable)
        this.verify();
    }.bind(this));
    this.signature.once("close", function() {
      if (!this.secret.writable && this.readable)
        this.verify();
    }.bind(this));
  }
  util.inherits(VerifyStream, Stream3);
  VerifyStream.prototype.verify = function verify() {
    try {
      var valid = jwsVerify(this.signature.buffer, this.algorithm, this.key.buffer);
      var obj = jwsDecode(this.signature.buffer, this.encoding);
      this.emit("done", valid, obj);
      this.emit("data", valid);
      this.emit("end");
      this.readable = false;
      return valid;
    } catch (e) {
      this.readable = false;
      this.emit("error", e);
      this.emit("close");
    }
  };
  VerifyStream.decode = jwsDecode;
  VerifyStream.isValid = isValidJws;
  VerifyStream.verify = jwsVerify;
  module.exports = VerifyStream;
});

// ../node_modules/.bun/jws@4.0.1/node_modules/jws/index.js
var require_jws = __commonJS((exports) => {
  var SignStream = require_sign_stream();
  var VerifyStream = require_verify_stream();
  var ALGORITHMS = [
    "HS256",
    "HS384",
    "HS512",
    "RS256",
    "RS384",
    "RS512",
    "PS256",
    "PS384",
    "PS512",
    "ES256",
    "ES384",
    "ES512"
  ];
  exports.ALGORITHMS = ALGORITHMS;
  exports.sign = SignStream.sign;
  exports.verify = VerifyStream.verify;
  exports.decode = VerifyStream.decode;
  exports.isValid = VerifyStream.isValid;
  exports.createSign = function createSign(opts) {
    return new SignStream(opts);
  };
  exports.createVerify = function createVerify(opts) {
    return new VerifyStream(opts);
  };
});

// ../node_modules/.bun/gtoken@8.0.0/node_modules/gtoken/build/cjs/src/index.cjs
var require_src5 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.GoogleToken = undefined;
  var fs6 = _interopRequireWildcard(__require("fs"));
  var _gaxios = require_src2();
  var jws = _interopRequireWildcard(require_jws());
  var path4 = _interopRequireWildcard(__require("path"));
  var _util = __require("util");
  function _interopRequireWildcard(e, t) {
    if (typeof WeakMap == "function")
      var r = new WeakMap, n = new WeakMap;
    return (_interopRequireWildcard = function _interopRequireWildcard2(e2, t2) {
      if (!t2 && e2 && e2.__esModule)
        return e2;
      var o, i, f = { __proto__: null, default: e2 };
      if (e2 === null || _typeof(e2) != "object" && typeof e2 != "function")
        return f;
      if (o = t2 ? n : r) {
        if (o.has(e2))
          return o.get(e2);
        o.set(e2, f);
      }
      for (var _t3 in e2)
        _t3 !== "default" && {}.hasOwnProperty.call(e2, _t3) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e2, _t3)) && (i.get || i.set) ? o(f, _t3, i) : f[_t3] = e2[_t3]);
      return f;
    })(e, t);
  }
  function _typeof(o) {
    "@babel/helpers - typeof";
    return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(o2) {
      return typeof o2;
    } : function(o2) {
      return o2 && typeof Symbol == "function" && o2.constructor === Symbol && o2 !== Symbol.prototype ? "symbol" : typeof o2;
    }, _typeof(o);
  }
  function _classPrivateMethodInitSpec(e, a) {
    _checkPrivateRedeclaration(e, a), a.add(e);
  }
  function _classPrivateFieldInitSpec(e, t, a) {
    _checkPrivateRedeclaration(e, t), t.set(e, a);
  }
  function _checkPrivateRedeclaration(e, t) {
    if (t.has(e))
      throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
  function _classPrivateFieldSet(s, a, r) {
    return s.set(_assertClassBrand(s, a), r), r;
  }
  function _classPrivateFieldGet(s, a) {
    return s.get(_assertClassBrand(s, a));
  }
  function _assertClassBrand(e, t, n) {
    if (typeof e == "function" ? e === t : e.has(t))
      return arguments.length < 3 ? t : n;
    throw new TypeError("Private element is not present on this object");
  }
  function _defineProperties(e, r) {
    for (var t = 0;t < r.length; t++) {
      var o = r[t];
      o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), Object.defineProperty(e, _toPropertyKey(o.key), o);
    }
  }
  function _createClass(e, r, t) {
    return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: false }), e;
  }
  function _classCallCheck(a, n) {
    if (!(a instanceof n))
      throw new TypeError("Cannot call a class as a function");
  }
  function _callSuper(t, o, e) {
    return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e));
  }
  function _possibleConstructorReturn(t, e) {
    if (e && (_typeof(e) == "object" || typeof e == "function"))
      return e;
    if (e !== undefined)
      throw new TypeError("Derived constructors may only return object or undefined");
    return _assertThisInitialized(t);
  }
  function _assertThisInitialized(e) {
    if (e === undefined)
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    return e;
  }
  function _inherits(t, e) {
    if (typeof e != "function" && e !== null)
      throw new TypeError("Super expression must either be null or a function");
    t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: true, configurable: true } }), Object.defineProperty(t, "prototype", { writable: false }), e && _setPrototypeOf(t, e);
  }
  function _wrapNativeSuper(t) {
    var r = typeof Map == "function" ? new Map : undefined;
    return _wrapNativeSuper = function _wrapNativeSuper2(t2) {
      if (t2 === null || !_isNativeFunction(t2))
        return t2;
      if (typeof t2 != "function")
        throw new TypeError("Super expression must either be null or a function");
      if (r !== undefined) {
        if (r.has(t2))
          return r.get(t2);
        r.set(t2, Wrapper);
      }
      function Wrapper() {
        return _construct(t2, arguments, _getPrototypeOf(this).constructor);
      }
      return Wrapper.prototype = Object.create(t2.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }), _setPrototypeOf(Wrapper, t2);
    }, _wrapNativeSuper(t);
  }
  function _construct(t, e, r) {
    if (_isNativeReflectConstruct())
      return Reflect.construct.apply(null, arguments);
    var o = [null];
    o.push.apply(o, e);
    var p = new (t.bind.apply(t, o));
    return r && _setPrototypeOf(p, r.prototype), p;
  }
  function _isNativeReflectConstruct() {
    try {
      var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {}));
    } catch (t2) {}
    return (_isNativeReflectConstruct = function _isNativeReflectConstruct2() {
      return !!t;
    })();
  }
  function _isNativeFunction(t) {
    try {
      return Function.toString.call(t).indexOf("[native code]") !== -1;
    } catch (n) {
      return typeof t == "function";
    }
  }
  function _setPrototypeOf(t, e) {
    return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t2, e2) {
      return t2.__proto__ = e2, t2;
    }, _setPrototypeOf(t, e);
  }
  function _getPrototypeOf(t) {
    return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(t2) {
      return t2.__proto__ || Object.getPrototypeOf(t2);
    }, _getPrototypeOf(t);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: true, configurable: true, writable: true }) : e[r] = t, e;
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return _typeof(i) == "symbol" ? i : i + "";
  }
  function _toPrimitive(t, r) {
    if (_typeof(t) != "object" || !t)
      return t;
    var e = t[Symbol.toPrimitive];
    if (e !== undefined) {
      var i = e.call(t, r || "default");
      if (_typeof(i) != "object")
        return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (r === "string" ? String : Number)(t);
  }
  function _regenerator() {
    /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */
    var e, t, r = typeof Symbol == "function" ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag";
    function i(r2, n2, o2, i2) {
      var c2 = n2 && n2.prototype instanceof Generator ? n2 : Generator, u2 = Object.create(c2.prototype);
      return _regeneratorDefine2(u2, "_invoke", function(r3, n3, o3) {
        var i3, c3, u3, f2 = 0, p = o3 || [], y = false, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d2(t2, r4) {
          return i3 = t2, c3 = 0, u3 = e, G.n = r4, a;
        } };
        function d(r4, n4) {
          for (c3 = r4, u3 = n4, t = 0;!y && f2 && !o4 && t < p.length; t++) {
            var o4, i4 = p[t], d2 = G.p, l = i4[2];
            r4 > 3 ? (o4 = l === n4) && (u3 = i4[(c3 = i4[4]) ? 5 : (c3 = 3, 3)], i4[4] = i4[5] = e) : i4[0] <= d2 && ((o4 = r4 < 2 && d2 < i4[1]) ? (c3 = 0, G.v = n4, G.n = i4[1]) : d2 < l && (o4 = r4 < 3 || i4[0] > n4 || n4 > l) && (i4[4] = r4, i4[5] = n4, G.n = l, c3 = 0));
          }
          if (o4 || r4 > 1)
            return a;
          throw y = true, n4;
        }
        return function(o4, p2, l) {
          if (f2 > 1)
            throw TypeError("Generator is already running");
          for (y && p2 === 1 && d(p2, l), c3 = p2, u3 = l;(t = c3 < 2 ? e : u3) || !y; ) {
            i3 || (c3 ? c3 < 3 ? (c3 > 1 && (G.n = -1), d(c3, u3)) : G.n = u3 : G.v = u3);
            try {
              if (f2 = 2, i3) {
                if (c3 || (o4 = "next"), t = i3[o4]) {
                  if (!(t = t.call(i3, u3)))
                    throw TypeError("iterator result is not an object");
                  if (!t.done)
                    return t;
                  u3 = t.value, c3 < 2 && (c3 = 0);
                } else
                  c3 === 1 && (t = i3["return"]) && t.call(i3), c3 < 2 && (u3 = TypeError("The iterator does not provide a '" + o4 + "' method"), c3 = 1);
                i3 = e;
              } else if ((t = (y = G.n < 0) ? u3 : r3.call(n3, G)) !== a)
                break;
            } catch (t2) {
              i3 = e, c3 = 1, u3 = t2;
            } finally {
              f2 = 1;
            }
          }
          return { value: t, done: y };
        };
      }(r2, o2, i2), true), u2;
    }
    var a = {};
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}
    t = Object.getPrototypeOf;
    var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function() {
      return this;
    }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c);
    function f(e2) {
      return Object.setPrototypeOf ? Object.setPrototypeOf(e2, GeneratorFunctionPrototype) : (e2.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e2, o, "GeneratorFunction")), e2.prototype = Object.create(u), e2;
    }
    return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function() {
      return this;
    }), _regeneratorDefine2(u, "toString", function() {
      return "[object Generator]";
    }), (_regenerator = function _regenerator2() {
      return { w: i, m: f };
    })();
  }
  function _regeneratorDefine2(e, r, n, t) {
    var i = Object.defineProperty;
    try {
      i({}, "", {});
    } catch (e2) {
      i = 0;
    }
    _regeneratorDefine2 = function _regeneratorDefine(e2, r2, n2, t2) {
      if (r2)
        i ? i(e2, r2, { value: n2, enumerable: !t2, configurable: !t2, writable: !t2 }) : e2[r2] = n2;
      else {
        var o = function o2(r3, n3) {
          _regeneratorDefine2(e2, r3, function(e3) {
            return this._invoke(r3, n3, e3);
          });
        };
        o("next", 0), o("throw", 1), o("return", 2);
      }
    }, _regeneratorDefine2(e, r, n, t);
  }
  function asyncGeneratorStep(n, t, e, r, o, a, c) {
    try {
      var i = n[a](c), u = i.value;
    } catch (n2) {
      return void e(n2);
    }
    i.done ? t(u) : Promise.resolve(u).then(r, o);
  }
  function _asyncToGenerator(n) {
    return function() {
      var t = this, e = arguments;
      return new Promise(function(r, o) {
        var a = n.apply(t, e);
        function _next(n2) {
          asyncGeneratorStep(a, r, o, _next, _throw, "next", n2);
        }
        function _throw(n2) {
          asyncGeneratorStep(a, r, o, _next, _throw, "throw", n2);
        }
        _next(undefined);
      });
    };
  }
  var readFile = fs6.readFile ? (0, _util.promisify)(fs6.readFile) : /* @__PURE__ */ _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee() {
    return _regenerator().w(function(_context) {
      while (true)
        switch (_context.n) {
          case 0:
            throw new ErrorWithCode("use key rather than keyFile.", "MISSING_CREDENTIALS");
          case 1:
            return _context.a(2);
        }
    }, _callee);
  }));
  var GOOGLE_TOKEN_URL = "https://oauth2.googleapis.com/token";
  var GOOGLE_REVOKE_TOKEN_URL = "https://oauth2.googleapis.com/revoke?token=";
  var ErrorWithCode = /* @__PURE__ */ function(_Error) {
    function ErrorWithCode2(message, code) {
      var _this;
      _classCallCheck(this, ErrorWithCode2);
      _this = _callSuper(this, ErrorWithCode2, [message]);
      _defineProperty(_this, "code", undefined);
      _this.code = code;
      return _this;
    }
    _inherits(ErrorWithCode2, _Error);
    return _createClass(ErrorWithCode2);
  }(/* @__PURE__ */ _wrapNativeSuper(Error));
  var _inFlightRequest = /* @__PURE__ */ new WeakMap;
  var _GoogleToken_brand = /* @__PURE__ */ new WeakSet;
  var GoogleToken = exports.GoogleToken = /* @__PURE__ */ function() {
    function GoogleToken2(_options) {
      _classCallCheck(this, GoogleToken2);
      _classPrivateMethodInitSpec(this, _GoogleToken_brand);
      _defineProperty(this, "expiresAt", undefined);
      _defineProperty(this, "key", undefined);
      _defineProperty(this, "keyFile", undefined);
      _defineProperty(this, "iss", undefined);
      _defineProperty(this, "sub", undefined);
      _defineProperty(this, "scope", undefined);
      _defineProperty(this, "rawToken", undefined);
      _defineProperty(this, "tokenExpires", undefined);
      _defineProperty(this, "email", undefined);
      _defineProperty(this, "additionalClaims", undefined);
      _defineProperty(this, "eagerRefreshThresholdMillis", undefined);
      _defineProperty(this, "transporter", {
        request: function request(opts) {
          return (0, _gaxios.request)(opts);
        }
      });
      _classPrivateFieldInitSpec(this, _inFlightRequest, undefined);
      _assertClassBrand(_GoogleToken_brand, this, _configure).call(this, _options);
    }
    return _createClass(GoogleToken2, [{
      key: "accessToken",
      get: function get() {
        return this.rawToken ? this.rawToken.access_token : undefined;
      }
    }, {
      key: "idToken",
      get: function get() {
        return this.rawToken ? this.rawToken.id_token : undefined;
      }
    }, {
      key: "tokenType",
      get: function get() {
        return this.rawToken ? this.rawToken.token_type : undefined;
      }
    }, {
      key: "refreshToken",
      get: function get() {
        return this.rawToken ? this.rawToken.refresh_token : undefined;
      }
    }, {
      key: "hasExpired",
      value: function hasExpired() {
        var now = new Date().getTime();
        if (this.rawToken && this.expiresAt) {
          return now >= this.expiresAt;
        } else {
          return true;
        }
      }
    }, {
      key: "isTokenExpiring",
      value: function isTokenExpiring() {
        var _this$eagerRefreshThr;
        var now = new Date().getTime();
        var eagerRefreshThresholdMillis = (_this$eagerRefreshThr = this.eagerRefreshThresholdMillis) !== null && _this$eagerRefreshThr !== undefined ? _this$eagerRefreshThr : 0;
        if (this.rawToken && this.expiresAt) {
          return this.expiresAt <= now + eagerRefreshThresholdMillis;
        } else {
          return true;
        }
      }
    }, {
      key: "getToken",
      value: function getToken(callback) {
        var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        if (_typeof(callback) === "object") {
          opts = callback;
          callback = undefined;
        }
        opts = Object.assign({
          forceRefresh: false
        }, opts);
        if (callback) {
          var cb = callback;
          _assertClassBrand(_GoogleToken_brand, this, _getTokenAsync).call(this, opts).then(function(t) {
            return cb(null, t);
          }, callback);
          return;
        }
        return _assertClassBrand(_GoogleToken_brand, this, _getTokenAsync).call(this, opts);
      }
    }, {
      key: "getCredentials",
      value: function() {
        var _getCredentials = _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee2(keyFile) {
          var ext, key, body, privateKey, clientEmail, _privateKey, _t;
          return _regenerator().w(function(_context2) {
            while (true)
              switch (_context2.n) {
                case 0:
                  ext = path4.extname(keyFile);
                  _t = ext;
                  _context2.n = _t === ".json" ? 1 : _t === ".der" ? 4 : _t === ".crt" ? 4 : _t === ".pem" ? 4 : _t === ".p12" ? 6 : _t === ".pfx" ? 6 : 7;
                  break;
                case 1:
                  _context2.n = 2;
                  return readFile(keyFile, "utf8");
                case 2:
                  key = _context2.v;
                  body = JSON.parse(key);
                  privateKey = body.private_key;
                  clientEmail = body.client_email;
                  if (!(!privateKey || !clientEmail)) {
                    _context2.n = 3;
                    break;
                  }
                  throw new ErrorWithCode("private_key and client_email are required.", "MISSING_CREDENTIALS");
                case 3:
                  return _context2.a(2, {
                    privateKey,
                    clientEmail
                  });
                case 4:
                  _context2.n = 5;
                  return readFile(keyFile, "utf8");
                case 5:
                  _privateKey = _context2.v;
                  return _context2.a(2, {
                    privateKey: _privateKey
                  });
                case 6:
                  throw new ErrorWithCode("*.p12 certificates are not supported after v6.1.2. " + "Consider utilizing *.json format or converting *.p12 to *.pem using the OpenSSL CLI.", "UNKNOWN_CERTIFICATE_TYPE");
                case 7:
                  throw new ErrorWithCode("Unknown certificate type. Type is determined based on file extension. " + "Current supported extensions are *.json, and *.pem.", "UNKNOWN_CERTIFICATE_TYPE");
                case 8:
                  return _context2.a(2);
              }
          }, _callee2);
        }));
        function getCredentials(_x) {
          return _getCredentials.apply(this, arguments);
        }
        return getCredentials;
      }()
    }, {
      key: "revokeToken",
      value: function revokeToken(callback) {
        if (callback) {
          _assertClassBrand(_GoogleToken_brand, this, _revokeTokenAsync).call(this).then(function() {
            return callback();
          }, callback);
          return;
        }
        return _assertClassBrand(_GoogleToken_brand, this, _revokeTokenAsync).call(this);
      }
    }]);
  }();
  function _getTokenAsync(_x2) {
    return _getTokenAsync2.apply(this, arguments);
  }
  function _getTokenAsync2() {
    _getTokenAsync2 = _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee3(opts) {
      return _regenerator().w(function(_context3) {
        while (true)
          switch (_context3.n) {
            case 0:
              if (!(_classPrivateFieldGet(_inFlightRequest, this) && !opts.forceRefresh)) {
                _context3.n = 1;
                break;
              }
              return _context3.a(2, _classPrivateFieldGet(_inFlightRequest, this));
            case 1:
              _context3.p = 1;
              _context3.n = 2;
              return _classPrivateFieldSet(_inFlightRequest, this, _assertClassBrand(_GoogleToken_brand, this, _getTokenAsyncInner).call(this, opts));
            case 2:
              return _context3.a(2, _context3.v);
            case 3:
              _context3.p = 3;
              _classPrivateFieldSet(_inFlightRequest, this, undefined);
              return _context3.f(3);
            case 4:
              return _context3.a(2);
          }
      }, _callee3, this, [[1, , 3, 4]]);
    }));
    return _getTokenAsync2.apply(this, arguments);
  }
  function _getTokenAsyncInner(_x3) {
    return _getTokenAsyncInner2.apply(this, arguments);
  }
  function _getTokenAsyncInner2() {
    _getTokenAsyncInner2 = _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee4(opts) {
      var creds;
      return _regenerator().w(function(_context4) {
        while (true)
          switch (_context4.n) {
            case 0:
              if (!(this.isTokenExpiring() === false && opts.forceRefresh === false)) {
                _context4.n = 1;
                break;
              }
              return _context4.a(2, Promise.resolve(this.rawToken));
            case 1:
              if (!(!this.key && !this.keyFile)) {
                _context4.n = 2;
                break;
              }
              throw new Error("No key or keyFile set.");
            case 2:
              if (!(!this.key && this.keyFile)) {
                _context4.n = 4;
                break;
              }
              _context4.n = 3;
              return this.getCredentials(this.keyFile);
            case 3:
              creds = _context4.v;
              this.key = creds.privateKey;
              this.iss = creds.clientEmail || this.iss;
              if (!creds.clientEmail) {
                _assertClassBrand(_GoogleToken_brand, this, _ensureEmail).call(this);
              }
            case 4:
              return _context4.a(2, _assertClassBrand(_GoogleToken_brand, this, _requestToken).call(this));
          }
      }, _callee4, this);
    }));
    return _getTokenAsyncInner2.apply(this, arguments);
  }
  function _ensureEmail() {
    if (!this.iss) {
      throw new ErrorWithCode("email is required.", "MISSING_CREDENTIALS");
    }
  }
  function _revokeTokenAsync() {
    return _revokeTokenAsync2.apply(this, arguments);
  }
  function _revokeTokenAsync2() {
    _revokeTokenAsync2 = _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee5() {
      var url;
      return _regenerator().w(function(_context5) {
        while (true)
          switch (_context5.n) {
            case 0:
              if (this.accessToken) {
                _context5.n = 1;
                break;
              }
              throw new Error("No token to revoke.");
            case 1:
              url = GOOGLE_REVOKE_TOKEN_URL + this.accessToken;
              _context5.n = 2;
              return this.transporter.request({
                url,
                retry: true
              });
            case 2:
              _assertClassBrand(_GoogleToken_brand, this, _configure).call(this, {
                email: this.iss,
                sub: this.sub,
                key: this.key,
                keyFile: this.keyFile,
                scope: this.scope,
                additionalClaims: this.additionalClaims
              });
            case 3:
              return _context5.a(2);
          }
      }, _callee5, this);
    }));
    return _revokeTokenAsync2.apply(this, arguments);
  }
  function _configure() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.keyFile = options.keyFile;
    this.key = options.key;
    this.rawToken = undefined;
    this.iss = options.email || options.iss;
    this.sub = options.sub;
    this.additionalClaims = options.additionalClaims;
    if (_typeof(options.scope) === "object") {
      this.scope = options.scope.join(" ");
    } else {
      this.scope = options.scope;
    }
    this.eagerRefreshThresholdMillis = options.eagerRefreshThresholdMillis;
    if (options.transporter) {
      this.transporter = options.transporter;
    }
  }
  function _requestToken() {
    return _requestToken2.apply(this, arguments);
  }
  function _requestToken2() {
    _requestToken2 = _asyncToGenerator(/* @__PURE__ */ _regenerator().m(function _callee6() {
      var iat, additionalClaims, payload, signedJWT, r, _response, _response2, body, desc, _t2;
      return _regenerator().w(function(_context6) {
        while (true)
          switch (_context6.n) {
            case 0:
              iat = Math.floor(new Date().getTime() / 1000);
              additionalClaims = this.additionalClaims || {};
              payload = Object.assign({
                iss: this.iss,
                scope: this.scope,
                aud: GOOGLE_TOKEN_URL,
                exp: iat + 3600,
                iat,
                sub: this.sub
              }, additionalClaims);
              signedJWT = jws.sign({
                header: {
                  alg: "RS256"
                },
                payload,
                secret: this.key
              });
              _context6.p = 1;
              _context6.n = 2;
              return this.transporter.request({
                method: "POST",
                url: GOOGLE_TOKEN_URL,
                data: new URLSearchParams({
                  grant_type: "urn:ietf:params:oauth:grant-type:jwt-bearer",
                  assertion: signedJWT
                }),
                responseType: "json",
                retryConfig: {
                  httpMethodsToRetry: ["POST"]
                }
              });
            case 2:
              r = _context6.v;
              this.rawToken = r.data;
              this.expiresAt = r.data.expires_in === null || r.data.expires_in === undefined ? undefined : (iat + r.data.expires_in) * 1000;
              return _context6.a(2, this.rawToken);
            case 3:
              _context6.p = 3;
              _t2 = _context6.v;
              this.rawToken = undefined;
              this.tokenExpires = undefined;
              body = _t2.response && (_response = _t2.response) !== null && _response !== undefined && _response.data ? (_response2 = _t2.response) === null || _response2 === undefined ? undefined : _response2.data : {};
              if (body.error) {
                desc = body.error_description ? ": ".concat(body.error_description) : "";
                _t2.message = "".concat(body.error).concat(desc);
              }
              throw _t2;
            case 4:
              return _context6.a(2);
          }
      }, _callee6, this, [[1, 3]]);
    }));
    return _requestToken2.apply(this, arguments);
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/jwtaccess.js
var require_jwtaccess = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JWTAccess = undefined;
  var jws = require_jws();
  var util_1 = require_util2();
  var DEFAULT_HEADER = {
    alg: "RS256",
    typ: "JWT"
  };

  class JWTAccess {
    email;
    key;
    keyId;
    projectId;
    eagerRefreshThresholdMillis;
    cache = new util_1.LRUCache({
      capacity: 500,
      maxAge: 60 * 60 * 1000
    });
    constructor(email, key, keyId, eagerRefreshThresholdMillis) {
      this.email = email;
      this.key = key;
      this.keyId = keyId;
      this.eagerRefreshThresholdMillis = eagerRefreshThresholdMillis ?? 5 * 60 * 1000;
    }
    getCachedKey(url, scopes) {
      let cacheKey2 = url;
      if (scopes && Array.isArray(scopes) && scopes.length) {
        cacheKey2 = url ? `${url}_${scopes.join("_")}` : `${scopes.join("_")}`;
      } else if (typeof scopes === "string") {
        cacheKey2 = url ? `${url}_${scopes}` : scopes;
      }
      if (!cacheKey2) {
        throw Error("Scopes or url must be provided");
      }
      return cacheKey2;
    }
    getRequestHeaders(url, additionalClaims, scopes) {
      const key = this.getCachedKey(url, scopes);
      const cachedToken = this.cache.get(key);
      const now = Date.now();
      if (cachedToken && cachedToken.expiration - now > this.eagerRefreshThresholdMillis) {
        return new Headers(cachedToken.headers);
      }
      const iat = Math.floor(Date.now() / 1000);
      const exp = JWTAccess.getExpirationTime(iat);
      let defaultClaims;
      if (Array.isArray(scopes)) {
        scopes = scopes.join(" ");
      }
      if (scopes) {
        defaultClaims = {
          iss: this.email,
          sub: this.email,
          scope: scopes,
          exp,
          iat
        };
      } else {
        defaultClaims = {
          iss: this.email,
          sub: this.email,
          aud: url,
          exp,
          iat
        };
      }
      if (additionalClaims) {
        for (const claim in defaultClaims) {
          if (additionalClaims[claim]) {
            throw new Error(`The '${claim}' property is not allowed when passing additionalClaims. This claim is included in the JWT by default.`);
          }
        }
      }
      const header = this.keyId ? { ...DEFAULT_HEADER, kid: this.keyId } : DEFAULT_HEADER;
      const payload = Object.assign(defaultClaims, additionalClaims);
      const signedJWT = jws.sign({ header, payload, secret: this.key });
      const headers = new Headers({ authorization: `Bearer ${signedJWT}` });
      this.cache.set(key, {
        expiration: exp * 1000,
        headers
      });
      return headers;
    }
    static getExpirationTime(iat) {
      const exp = iat + 3600;
      return exp;
    }
    fromJSON(json) {
      if (!json) {
        throw new Error("Must pass in a JSON object containing the service account auth settings.");
      }
      if (!json.client_email) {
        throw new Error("The incoming JSON object does not contain a client_email field");
      }
      if (!json.private_key) {
        throw new Error("The incoming JSON object does not contain a private_key field");
      }
      this.email = json.client_email;
      this.key = json.private_key;
      this.keyId = json.private_key_id;
      this.projectId = json.project_id;
    }
    fromStream(inputStream, callback) {
      if (callback) {
        this.fromStreamAsync(inputStream).then(() => callback(), callback);
      } else {
        return this.fromStreamAsync(inputStream);
      }
    }
    fromStreamAsync(inputStream) {
      return new Promise((resolve3, reject) => {
        if (!inputStream) {
          reject(new Error("Must pass in a stream containing the service account auth settings."));
        }
        let s = "";
        inputStream.setEncoding("utf8").on("data", (chunk) => s += chunk).on("error", reject).on("end", () => {
          try {
            const data = JSON.parse(s);
            this.fromJSON(data);
            resolve3();
          } catch (err) {
            reject(err);
          }
        });
      });
    }
  }
  exports.JWTAccess = JWTAccess;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/jwtclient.js
var require_jwtclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.JWT = undefined;
  var gtoken_1 = require_src5();
  var jwtaccess_1 = require_jwtaccess();
  var oauth2client_1 = require_oauth2client();
  var authclient_1 = require_authclient();

  class JWT extends oauth2client_1.OAuth2Client {
    email;
    keyFile;
    key;
    keyId;
    defaultScopes;
    scopes;
    scope;
    subject;
    gtoken;
    additionalClaims;
    useJWTAccessWithScope;
    defaultServicePath;
    access;
    constructor(options = {}) {
      super(options);
      this.email = options.email;
      this.keyFile = options.keyFile;
      this.key = options.key;
      this.keyId = options.keyId;
      this.scopes = options.scopes;
      this.subject = options.subject;
      this.additionalClaims = options.additionalClaims;
      this.credentials = { refresh_token: "jwt-placeholder", expiry_date: 1 };
    }
    createScoped(scopes) {
      const jwt = new JWT(this);
      jwt.scopes = scopes;
      return jwt;
    }
    async getRequestMetadataAsync(url) {
      url = this.defaultServicePath ? `https://${this.defaultServicePath}/` : url;
      const useSelfSignedJWT = !this.hasUserScopes() && url || this.useJWTAccessWithScope && this.hasAnyScopes() || this.universeDomain !== authclient_1.DEFAULT_UNIVERSE;
      if (this.subject && this.universeDomain !== authclient_1.DEFAULT_UNIVERSE) {
        throw new RangeError(`Service Account user is configured for the credential. Domain-wide delegation is not supported in universes other than ${authclient_1.DEFAULT_UNIVERSE}`);
      }
      if (!this.apiKey && useSelfSignedJWT) {
        if (this.additionalClaims && this.additionalClaims.target_audience) {
          const { tokens } = await this.refreshToken();
          return {
            headers: this.addSharedMetadataHeaders(new Headers({
              authorization: `Bearer ${tokens.id_token}`
            }))
          };
        } else {
          if (!this.access) {
            this.access = new jwtaccess_1.JWTAccess(this.email, this.key, this.keyId, this.eagerRefreshThresholdMillis);
          }
          let scopes;
          if (this.hasUserScopes()) {
            scopes = this.scopes;
          } else if (!url) {
            scopes = this.defaultScopes;
          }
          const useScopes = this.useJWTAccessWithScope || this.universeDomain !== authclient_1.DEFAULT_UNIVERSE;
          const headers = await this.access.getRequestHeaders(url ?? undefined, this.additionalClaims, useScopes ? scopes : undefined);
          return { headers: this.addSharedMetadataHeaders(headers) };
        }
      } else if (this.hasAnyScopes() || this.apiKey) {
        return super.getRequestMetadataAsync(url);
      } else {
        return { headers: new Headers };
      }
    }
    async fetchIdToken(targetAudience) {
      const gtoken = new gtoken_1.GoogleToken({
        iss: this.email,
        sub: this.subject,
        scope: this.scopes || this.defaultScopes,
        keyFile: this.keyFile,
        key: this.key,
        additionalClaims: { target_audience: targetAudience },
        transporter: this.transporter
      });
      await gtoken.getToken({
        forceRefresh: true
      });
      if (!gtoken.idToken) {
        throw new Error("Unknown error: Failed to fetch ID token");
      }
      return gtoken.idToken;
    }
    hasUserScopes() {
      if (!this.scopes) {
        return false;
      }
      return this.scopes.length > 0;
    }
    hasAnyScopes() {
      if (this.scopes && this.scopes.length > 0)
        return true;
      if (this.defaultScopes && this.defaultScopes.length > 0)
        return true;
      return false;
    }
    authorize(callback) {
      if (callback) {
        this.authorizeAsync().then((r) => callback(null, r), callback);
      } else {
        return this.authorizeAsync();
      }
    }
    async authorizeAsync() {
      const result = await this.refreshToken();
      if (!result) {
        throw new Error("No result returned");
      }
      this.credentials = result.tokens;
      this.credentials.refresh_token = "jwt-placeholder";
      this.key = this.gtoken.key;
      this.email = this.gtoken.iss;
      return result.tokens;
    }
    async refreshTokenNoCache() {
      const gtoken = this.createGToken();
      const token = await gtoken.getToken({
        forceRefresh: this.isTokenExpiring()
      });
      const tokens = {
        access_token: token.access_token,
        token_type: "Bearer",
        expiry_date: gtoken.expiresAt,
        id_token: gtoken.idToken
      };
      this.emit("tokens", tokens);
      return { res: null, tokens };
    }
    createGToken() {
      if (!this.gtoken) {
        this.gtoken = new gtoken_1.GoogleToken({
          iss: this.email,
          sub: this.subject,
          scope: this.scopes || this.defaultScopes,
          keyFile: this.keyFile,
          key: this.key,
          additionalClaims: this.additionalClaims,
          transporter: this.transporter
        });
      }
      return this.gtoken;
    }
    fromJSON(json) {
      if (!json) {
        throw new Error("Must pass in a JSON object containing the service account auth settings.");
      }
      if (!json.client_email) {
        throw new Error("The incoming JSON object does not contain a client_email field");
      }
      if (!json.private_key) {
        throw new Error("The incoming JSON object does not contain a private_key field");
      }
      this.email = json.client_email;
      this.key = json.private_key;
      this.keyId = json.private_key_id;
      this.projectId = json.project_id;
      this.quotaProjectId = json.quota_project_id;
      this.universeDomain = json.universe_domain || this.universeDomain;
    }
    fromStream(inputStream, callback) {
      if (callback) {
        this.fromStreamAsync(inputStream).then(() => callback(), callback);
      } else {
        return this.fromStreamAsync(inputStream);
      }
    }
    fromStreamAsync(inputStream) {
      return new Promise((resolve3, reject) => {
        if (!inputStream) {
          throw new Error("Must pass in a stream containing the service account auth settings.");
        }
        let s = "";
        inputStream.setEncoding("utf8").on("error", reject).on("data", (chunk) => s += chunk).on("end", () => {
          try {
            const data = JSON.parse(s);
            this.fromJSON(data);
            resolve3();
          } catch (e) {
            reject(e);
          }
        });
      });
    }
    fromAPIKey(apiKey) {
      if (typeof apiKey !== "string") {
        throw new Error("Must provide an API Key string.");
      }
      this.apiKey = apiKey;
    }
    async getCredentials() {
      if (this.key) {
        return { private_key: this.key, client_email: this.email };
      } else if (this.keyFile) {
        const gtoken = this.createGToken();
        const creds = await gtoken.getCredentials(this.keyFile);
        return { private_key: creds.privateKey, client_email: creds.clientEmail };
      }
      throw new Error("A key or a keyFile must be provided to getCredentials.");
    }
  }
  exports.JWT = JWT;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/refreshclient.js
var require_refreshclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.UserRefreshClient = exports.USER_REFRESH_ACCOUNT_TYPE = undefined;
  var oauth2client_1 = require_oauth2client();
  var authclient_1 = require_authclient();
  exports.USER_REFRESH_ACCOUNT_TYPE = "authorized_user";

  class UserRefreshClient extends oauth2client_1.OAuth2Client {
    _refreshToken;
    constructor(optionsOrClientId, clientSecret, refreshToken, eagerRefreshThresholdMillis, forceRefreshOnFailure) {
      const opts = optionsOrClientId && typeof optionsOrClientId === "object" ? optionsOrClientId : {
        clientId: optionsOrClientId,
        clientSecret,
        refreshToken,
        eagerRefreshThresholdMillis,
        forceRefreshOnFailure
      };
      super(opts);
      this._refreshToken = opts.refreshToken;
      this.credentials.refresh_token = opts.refreshToken;
    }
    async refreshTokenNoCache() {
      return super.refreshTokenNoCache(this._refreshToken);
    }
    async fetchIdToken(targetAudience) {
      const opts = {
        ...UserRefreshClient.RETRY_CONFIG,
        url: this.endpoints.oauth2TokenUrl,
        method: "POST",
        data: new URLSearchParams({
          client_id: this._clientId,
          client_secret: this._clientSecret,
          grant_type: "refresh_token",
          refresh_token: this._refreshToken,
          target_audience: targetAudience
        })
      };
      authclient_1.AuthClient.setMethodName(opts, "fetchIdToken");
      const res = await this.transporter.request(opts);
      return res.data.id_token;
    }
    fromJSON(json) {
      if (!json) {
        throw new Error("Must pass in a JSON object containing the user refresh token");
      }
      if (json.type !== "authorized_user") {
        throw new Error('The incoming JSON object does not have the "authorized_user" type');
      }
      if (!json.client_id) {
        throw new Error("The incoming JSON object does not contain a client_id field");
      }
      if (!json.client_secret) {
        throw new Error("The incoming JSON object does not contain a client_secret field");
      }
      if (!json.refresh_token) {
        throw new Error("The incoming JSON object does not contain a refresh_token field");
      }
      this._clientId = json.client_id;
      this._clientSecret = json.client_secret;
      this._refreshToken = json.refresh_token;
      this.credentials.refresh_token = json.refresh_token;
      this.quotaProjectId = json.quota_project_id;
      this.universeDomain = json.universe_domain || this.universeDomain;
    }
    fromStream(inputStream, callback) {
      if (callback) {
        this.fromStreamAsync(inputStream).then(() => callback(), callback);
      } else {
        return this.fromStreamAsync(inputStream);
      }
    }
    async fromStreamAsync(inputStream) {
      return new Promise((resolve3, reject) => {
        if (!inputStream) {
          return reject(new Error("Must pass in a stream containing the user refresh token."));
        }
        let s = "";
        inputStream.setEncoding("utf8").on("error", reject).on("data", (chunk) => s += chunk).on("end", () => {
          try {
            const data = JSON.parse(s);
            this.fromJSON(data);
            return resolve3();
          } catch (err) {
            return reject(err);
          }
        });
      });
    }
    static fromJSON(json) {
      const client = new UserRefreshClient;
      client.fromJSON(json);
      return client;
    }
  }
  exports.UserRefreshClient = UserRefreshClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/impersonated.js
var require_impersonated = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.Impersonated = exports.IMPERSONATED_ACCOUNT_TYPE = undefined;
  var oauth2client_1 = require_oauth2client();
  var gaxios_1 = require_src2();
  var util_1 = require_util2();
  exports.IMPERSONATED_ACCOUNT_TYPE = "impersonated_service_account";

  class Impersonated extends oauth2client_1.OAuth2Client {
    sourceClient;
    targetPrincipal;
    targetScopes;
    delegates;
    lifetime;
    endpoint;
    constructor(options = {}) {
      super(options);
      this.credentials = {
        expiry_date: 1,
        refresh_token: "impersonated-placeholder"
      };
      this.sourceClient = options.sourceClient ?? new oauth2client_1.OAuth2Client;
      this.targetPrincipal = options.targetPrincipal ?? "";
      this.delegates = options.delegates ?? [];
      this.targetScopes = options.targetScopes ?? [];
      this.lifetime = options.lifetime ?? 3600;
      const usingExplicitUniverseDomain = !!(0, util_1.originalOrCamelOptions)(options).get("universe_domain");
      if (!usingExplicitUniverseDomain) {
        this.universeDomain = this.sourceClient.universeDomain;
      } else if (this.sourceClient.universeDomain !== this.universeDomain) {
        throw new RangeError(`Universe domain ${this.sourceClient.universeDomain} in source credentials does not match ${this.universeDomain} universe domain set for impersonated credentials.`);
      }
      this.endpoint = options.endpoint ?? `https://iamcredentials.${this.universeDomain}`;
    }
    async sign(blobToSign) {
      await this.sourceClient.getAccessToken();
      const name = `projects/-/serviceAccounts/${this.targetPrincipal}`;
      const u = `${this.endpoint}/v1/${name}:signBlob`;
      const body = {
        delegates: this.delegates,
        payload: Buffer.from(blobToSign).toString("base64")
      };
      const res = await this.sourceClient.request({
        ...Impersonated.RETRY_CONFIG,
        url: u,
        data: body,
        method: "POST"
      });
      return res.data;
    }
    getTargetPrincipal() {
      return this.targetPrincipal;
    }
    async refreshToken() {
      try {
        await this.sourceClient.getAccessToken();
        const name = "projects/-/serviceAccounts/" + this.targetPrincipal;
        const u = `${this.endpoint}/v1/${name}:generateAccessToken`;
        const body = {
          delegates: this.delegates,
          scope: this.targetScopes,
          lifetime: this.lifetime + "s"
        };
        const res = await this.sourceClient.request({
          ...Impersonated.RETRY_CONFIG,
          url: u,
          data: body,
          method: "POST"
        });
        const tokenResponse = res.data;
        this.credentials.access_token = tokenResponse.accessToken;
        this.credentials.expiry_date = Date.parse(tokenResponse.expireTime);
        return {
          tokens: this.credentials,
          res
        };
      } catch (error3) {
        if (!(error3 instanceof Error))
          throw error3;
        let status = 0;
        let message = "";
        if (error3 instanceof gaxios_1.GaxiosError) {
          status = error3?.response?.data?.error?.status;
          message = error3?.response?.data?.error?.message;
        }
        if (status && message) {
          error3.message = `${status}: unable to impersonate: ${message}`;
          throw error3;
        } else {
          error3.message = `unable to impersonate: ${error3}`;
          throw error3;
        }
      }
    }
    async fetchIdToken(targetAudience, options) {
      await this.sourceClient.getAccessToken();
      const name = `projects/-/serviceAccounts/${this.targetPrincipal}`;
      const u = `${this.endpoint}/v1/${name}:generateIdToken`;
      const body = {
        delegates: this.delegates,
        audience: targetAudience,
        includeEmail: options?.includeEmail ?? true,
        useEmailAzp: options?.includeEmail ?? true
      };
      const res = await this.sourceClient.request({
        ...Impersonated.RETRY_CONFIG,
        url: u,
        data: body,
        method: "POST"
      });
      return res.data.token;
    }
  }
  exports.Impersonated = Impersonated;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/oauth2common.js
var require_oauth2common = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.OAuthClientAuthHandler = undefined;
  exports.getErrorFromOAuthErrorResponse = getErrorFromOAuthErrorResponse;
  var gaxios_1 = require_src2();
  var crypto_1 = require_crypto3();
  var METHODS_SUPPORTING_REQUEST_BODY = ["PUT", "POST", "PATCH"];

  class OAuthClientAuthHandler {
    #crypto = (0, crypto_1.createCrypto)();
    #clientAuthentication;
    transporter;
    constructor(options) {
      if (options && "clientId" in options) {
        this.#clientAuthentication = options;
        this.transporter = new gaxios_1.Gaxios;
      } else {
        this.#clientAuthentication = options?.clientAuthentication;
        this.transporter = options?.transporter || new gaxios_1.Gaxios;
      }
    }
    applyClientAuthenticationOptions(opts, bearerToken) {
      opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
      this.injectAuthenticatedHeaders(opts, bearerToken);
      if (!bearerToken) {
        this.injectAuthenticatedRequestBody(opts);
      }
    }
    injectAuthenticatedHeaders(opts, bearerToken) {
      if (bearerToken) {
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers, {
          authorization: `Bearer ${bearerToken}`
        });
      } else if (this.#clientAuthentication?.confidentialClientType === "basic") {
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
        const clientId = this.#clientAuthentication.clientId;
        const clientSecret = this.#clientAuthentication.clientSecret || "";
        const base64EncodedCreds = this.#crypto.encodeBase64StringUtf8(`${clientId}:${clientSecret}`);
        gaxios_1.Gaxios.mergeHeaders(opts.headers, {
          authorization: `Basic ${base64EncodedCreds}`
        });
      }
    }
    injectAuthenticatedRequestBody(opts) {
      if (this.#clientAuthentication?.confidentialClientType === "request-body") {
        const method = (opts.method || "GET").toUpperCase();
        if (!METHODS_SUPPORTING_REQUEST_BODY.includes(method)) {
          throw new Error(`${method} HTTP method does not support ` + `${this.#clientAuthentication.confidentialClientType} ` + "client authentication");
        }
        const headers = new Headers(opts.headers);
        const contentType = headers.get("content-type");
        if (contentType?.startsWith("application/x-www-form-urlencoded") || opts.data instanceof URLSearchParams) {
          const data = new URLSearchParams(opts.data ?? "");
          data.append("client_id", this.#clientAuthentication.clientId);
          data.append("client_secret", this.#clientAuthentication.clientSecret || "");
          opts.data = data;
        } else if (contentType?.startsWith("application/json")) {
          opts.data = opts.data || {};
          Object.assign(opts.data, {
            client_id: this.#clientAuthentication.clientId,
            client_secret: this.#clientAuthentication.clientSecret || ""
          });
        } else {
          throw new Error(`${contentType} content-types are not supported with ` + `${this.#clientAuthentication.confidentialClientType} ` + "client authentication");
        }
      }
    }
    static get RETRY_CONFIG() {
      return {
        retry: true,
        retryConfig: {
          httpMethodsToRetry: ["GET", "PUT", "POST", "HEAD", "OPTIONS", "DELETE"]
        }
      };
    }
  }
  exports.OAuthClientAuthHandler = OAuthClientAuthHandler;
  function getErrorFromOAuthErrorResponse(resp, err) {
    const errorCode = resp.error;
    const errorDescription = resp.error_description;
    const errorUri = resp.error_uri;
    let message = `Error code ${errorCode}`;
    if (typeof errorDescription !== "undefined") {
      message += `: ${errorDescription}`;
    }
    if (typeof errorUri !== "undefined") {
      message += ` - ${errorUri}`;
    }
    const newError = new Error(message);
    if (err) {
      const keys = Object.keys(err);
      if (err.stack) {
        keys.push("stack");
      }
      keys.forEach((key) => {
        if (key !== "message") {
          Object.defineProperty(newError, key, {
            value: err[key],
            writable: false,
            enumerable: true
          });
        }
      });
    }
    return newError;
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/stscredentials.js
var require_stscredentials = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.StsCredentials = undefined;
  var gaxios_1 = require_src2();
  var authclient_1 = require_authclient();
  var oauth2common_1 = require_oauth2common();
  var util_1 = require_util2();

  class StsCredentials extends oauth2common_1.OAuthClientAuthHandler {
    #tokenExchangeEndpoint;
    constructor(options = {
      tokenExchangeEndpoint: ""
    }, clientAuthentication) {
      if (typeof options !== "object" || options instanceof URL) {
        options = {
          tokenExchangeEndpoint: options,
          clientAuthentication
        };
      }
      super(options);
      this.#tokenExchangeEndpoint = options.tokenExchangeEndpoint;
    }
    async exchangeToken(stsCredentialsOptions, headers, options) {
      const values2 = {
        grant_type: stsCredentialsOptions.grantType,
        resource: stsCredentialsOptions.resource,
        audience: stsCredentialsOptions.audience,
        scope: stsCredentialsOptions.scope?.join(" "),
        requested_token_type: stsCredentialsOptions.requestedTokenType,
        subject_token: stsCredentialsOptions.subjectToken,
        subject_token_type: stsCredentialsOptions.subjectTokenType,
        actor_token: stsCredentialsOptions.actingParty?.actorToken,
        actor_token_type: stsCredentialsOptions.actingParty?.actorTokenType,
        options: options && JSON.stringify(options)
      };
      const opts = {
        ...StsCredentials.RETRY_CONFIG,
        url: this.#tokenExchangeEndpoint.toString(),
        method: "POST",
        headers,
        data: new URLSearchParams((0, util_1.removeUndefinedValuesInObject)(values2))
      };
      authclient_1.AuthClient.setMethodName(opts, "exchangeToken");
      this.applyClientAuthenticationOptions(opts);
      try {
        const response = await this.transporter.request(opts);
        const stsSuccessfulResponse = response.data;
        stsSuccessfulResponse.res = response;
        return stsSuccessfulResponse;
      } catch (error3) {
        if (error3 instanceof gaxios_1.GaxiosError && error3.response) {
          throw (0, oauth2common_1.getErrorFromOAuthErrorResponse)(error3.response.data, error3);
        }
        throw error3;
      }
    }
  }
  exports.StsCredentials = StsCredentials;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/baseexternalclient.js
var require_baseexternalclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.BaseExternalAccountClient = exports.CLOUD_RESOURCE_MANAGER = exports.EXTERNAL_ACCOUNT_TYPE = exports.EXPIRATION_TIME_OFFSET = undefined;
  var gaxios_1 = require_src2();
  var stream = __require("stream");
  var authclient_1 = require_authclient();
  var sts = require_stscredentials();
  var util_1 = require_util2();
  var shared_cjs_1 = require_shared2();
  var STS_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
  var STS_REQUEST_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
  var DEFAULT_OAUTH_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
  var DEFAULT_TOKEN_LIFESPAN = 3600;
  exports.EXPIRATION_TIME_OFFSET = 5 * 60 * 1000;
  exports.EXTERNAL_ACCOUNT_TYPE = "external_account";
  exports.CLOUD_RESOURCE_MANAGER = "https://cloudresourcemanager.googleapis.com/v1/projects/";
  var WORKFORCE_AUDIENCE_PATTERN = "//iam\\.googleapis\\.com/locations/[^/]+/workforcePools/[^/]+/providers/.+";
  var DEFAULT_TOKEN_URL = "https://sts.{universeDomain}/v1/token";

  class BaseExternalAccountClient extends authclient_1.AuthClient {
    scopes;
    projectNumber;
    audience;
    subjectTokenType;
    stsCredential;
    clientAuth;
    credentialSourceType;
    cachedAccessToken;
    serviceAccountImpersonationUrl;
    serviceAccountImpersonationLifetime;
    workforcePoolUserProject;
    configLifetimeRequested;
    tokenUrl;
    cloudResourceManagerURL;
    supplierContext;
    #pendingAccessToken = null;
    constructor(options) {
      super(options);
      const opts = (0, util_1.originalOrCamelOptions)(options);
      const type = opts.get("type");
      if (type && type !== exports.EXTERNAL_ACCOUNT_TYPE) {
        throw new Error(`Expected "${exports.EXTERNAL_ACCOUNT_TYPE}" type but ` + `received "${options.type}"`);
      }
      const clientId = opts.get("client_id");
      const clientSecret = opts.get("client_secret");
      this.tokenUrl = opts.get("token_url") ?? DEFAULT_TOKEN_URL.replace("{universeDomain}", this.universeDomain);
      const subjectTokenType = opts.get("subject_token_type");
      const workforcePoolUserProject = opts.get("workforce_pool_user_project");
      const serviceAccountImpersonationUrl = opts.get("service_account_impersonation_url");
      const serviceAccountImpersonation = opts.get("service_account_impersonation");
      const serviceAccountImpersonationLifetime = (0, util_1.originalOrCamelOptions)(serviceAccountImpersonation).get("token_lifetime_seconds");
      this.cloudResourceManagerURL = new URL(opts.get("cloud_resource_manager_url") || `https://cloudresourcemanager.${this.universeDomain}/v1/projects/`);
      if (clientId) {
        this.clientAuth = {
          confidentialClientType: "basic",
          clientId,
          clientSecret
        };
      }
      this.stsCredential = new sts.StsCredentials({
        tokenExchangeEndpoint: this.tokenUrl,
        clientAuthentication: this.clientAuth
      });
      this.scopes = opts.get("scopes") || [DEFAULT_OAUTH_SCOPE];
      this.cachedAccessToken = null;
      this.audience = opts.get("audience");
      this.subjectTokenType = subjectTokenType;
      this.workforcePoolUserProject = workforcePoolUserProject;
      const workforceAudiencePattern = new RegExp(WORKFORCE_AUDIENCE_PATTERN);
      if (this.workforcePoolUserProject && !this.audience.match(workforceAudiencePattern)) {
        throw new Error("workforcePoolUserProject should not be set for non-workforce pool " + "credentials.");
      }
      this.serviceAccountImpersonationUrl = serviceAccountImpersonationUrl;
      this.serviceAccountImpersonationLifetime = serviceAccountImpersonationLifetime;
      if (this.serviceAccountImpersonationLifetime) {
        this.configLifetimeRequested = true;
      } else {
        this.configLifetimeRequested = false;
        this.serviceAccountImpersonationLifetime = DEFAULT_TOKEN_LIFESPAN;
      }
      this.projectNumber = this.getProjectNumber(this.audience);
      this.supplierContext = {
        audience: this.audience,
        subjectTokenType: this.subjectTokenType,
        transporter: this.transporter
      };
    }
    getServiceAccountEmail() {
      if (this.serviceAccountImpersonationUrl) {
        if (this.serviceAccountImpersonationUrl.length > 256) {
          throw new RangeError(`URL is too long: ${this.serviceAccountImpersonationUrl}`);
        }
        const re = /serviceAccounts\/(?<email>[^:]+):generateAccessToken$/;
        const result = re.exec(this.serviceAccountImpersonationUrl);
        return result?.groups?.email || null;
      }
      return null;
    }
    setCredentials(credentials) {
      super.setCredentials(credentials);
      this.cachedAccessToken = credentials;
    }
    async getAccessToken() {
      if (!this.cachedAccessToken || this.isExpired(this.cachedAccessToken)) {
        await this.refreshAccessTokenAsync();
      }
      return {
        token: this.cachedAccessToken.access_token,
        res: this.cachedAccessToken.res
      };
    }
    async getRequestHeaders() {
      const accessTokenResponse = await this.getAccessToken();
      const headers = new Headers({
        authorization: `Bearer ${accessTokenResponse.token}`
      });
      return this.addSharedMetadataHeaders(headers);
    }
    request(opts, callback) {
      if (callback) {
        this.requestAsync(opts).then((r) => callback(null, r), (e) => {
          return callback(e, e.response);
        });
      } else {
        return this.requestAsync(opts);
      }
    }
    async getProjectId() {
      const projectNumber = this.projectNumber || this.workforcePoolUserProject;
      if (this.projectId) {
        return this.projectId;
      } else if (projectNumber) {
        const headers = await this.getRequestHeaders();
        const opts = {
          ...BaseExternalAccountClient.RETRY_CONFIG,
          headers,
          url: `${this.cloudResourceManagerURL.toString()}${projectNumber}`
        };
        authclient_1.AuthClient.setMethodName(opts, "getProjectId");
        const response = await this.transporter.request(opts);
        this.projectId = response.data.projectId;
        return this.projectId;
      }
      return null;
    }
    async requestAsync(opts, reAuthRetried = false) {
      let response;
      try {
        const requestHeaders = await this.getRequestHeaders();
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
        this.addUserProjectAndAuthHeaders(opts.headers, requestHeaders);
        response = await this.transporter.request(opts);
      } catch (e) {
        const res = e.response;
        if (res) {
          const statusCode = res.status;
          const isReadableStream = res.config.data instanceof stream.Readable;
          const isAuthErr = statusCode === 401 || statusCode === 403;
          if (!reAuthRetried && isAuthErr && !isReadableStream && this.forceRefreshOnFailure) {
            await this.refreshAccessTokenAsync();
            return await this.requestAsync(opts, true);
          }
        }
        throw e;
      }
      return response;
    }
    async refreshAccessTokenAsync() {
      this.#pendingAccessToken = this.#pendingAccessToken || this.#internalRefreshAccessTokenAsync();
      try {
        return await this.#pendingAccessToken;
      } finally {
        this.#pendingAccessToken = null;
      }
    }
    async#internalRefreshAccessTokenAsync() {
      const subjectToken = await this.retrieveSubjectToken();
      const stsCredentialsOptions = {
        grantType: STS_GRANT_TYPE,
        audience: this.audience,
        requestedTokenType: STS_REQUEST_TOKEN_TYPE,
        subjectToken,
        subjectTokenType: this.subjectTokenType,
        scope: this.serviceAccountImpersonationUrl ? [DEFAULT_OAUTH_SCOPE] : this.getScopesArray()
      };
      const additionalOptions = !this.clientAuth && this.workforcePoolUserProject ? { userProject: this.workforcePoolUserProject } : undefined;
      const additionalHeaders = new Headers({
        "x-goog-api-client": this.getMetricsHeaderValue()
      });
      const stsResponse = await this.stsCredential.exchangeToken(stsCredentialsOptions, additionalHeaders, additionalOptions);
      if (this.serviceAccountImpersonationUrl) {
        this.cachedAccessToken = await this.getImpersonatedAccessToken(stsResponse.access_token);
      } else if (stsResponse.expires_in) {
        this.cachedAccessToken = {
          access_token: stsResponse.access_token,
          expiry_date: new Date().getTime() + stsResponse.expires_in * 1000,
          res: stsResponse.res
        };
      } else {
        this.cachedAccessToken = {
          access_token: stsResponse.access_token,
          res: stsResponse.res
        };
      }
      this.credentials = {};
      Object.assign(this.credentials, this.cachedAccessToken);
      delete this.credentials.res;
      this.emit("tokens", {
        refresh_token: null,
        expiry_date: this.cachedAccessToken.expiry_date,
        access_token: this.cachedAccessToken.access_token,
        token_type: "Bearer",
        id_token: null
      });
      return this.cachedAccessToken;
    }
    getProjectNumber(audience) {
      const match2 = audience.match(/\/projects\/([^/]+)/);
      if (!match2) {
        return null;
      }
      return match2[1];
    }
    async getImpersonatedAccessToken(token) {
      const opts = {
        ...BaseExternalAccountClient.RETRY_CONFIG,
        url: this.serviceAccountImpersonationUrl,
        method: "POST",
        headers: {
          "content-type": "application/json",
          authorization: `Bearer ${token}`
        },
        data: {
          scope: this.getScopesArray(),
          lifetime: this.serviceAccountImpersonationLifetime + "s"
        }
      };
      authclient_1.AuthClient.setMethodName(opts, "getImpersonatedAccessToken");
      const response = await this.transporter.request(opts);
      const successResponse = response.data;
      return {
        access_token: successResponse.accessToken,
        expiry_date: new Date(successResponse.expireTime).getTime(),
        res: response
      };
    }
    isExpired(accessToken) {
      const now = new Date().getTime();
      return accessToken.expiry_date ? now >= accessToken.expiry_date - this.eagerRefreshThresholdMillis : false;
    }
    getScopesArray() {
      if (typeof this.scopes === "string") {
        return [this.scopes];
      }
      return this.scopes || [DEFAULT_OAUTH_SCOPE];
    }
    getMetricsHeaderValue() {
      const nodeVersion = process.version.replace(/^v/, "");
      const saImpersonation = this.serviceAccountImpersonationUrl !== undefined;
      const credentialSourceType = this.credentialSourceType ? this.credentialSourceType : "unknown";
      return `gl-node/${nodeVersion} auth/${shared_cjs_1.pkg.version} google-byoid-sdk source/${credentialSourceType} sa-impersonation/${saImpersonation} config-lifetime/${this.configLifetimeRequested}`;
    }
    getTokenUrl() {
      return this.tokenUrl;
    }
  }
  exports.BaseExternalAccountClient = BaseExternalAccountClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/filesubjecttokensupplier.js
var require_filesubjecttokensupplier = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.FileSubjectTokenSupplier = undefined;
  var util_1 = __require("util");
  var fs6 = __require("fs");
  var readFile = (0, util_1.promisify)(fs6.readFile ?? (() => {}));
  var realpath = (0, util_1.promisify)(fs6.realpath ?? (() => {}));
  var lstat = (0, util_1.promisify)(fs6.lstat ?? (() => {}));

  class FileSubjectTokenSupplier {
    filePath;
    formatType;
    subjectTokenFieldName;
    constructor(opts) {
      this.filePath = opts.filePath;
      this.formatType = opts.formatType;
      this.subjectTokenFieldName = opts.subjectTokenFieldName;
    }
    async getSubjectToken() {
      let parsedFilePath = this.filePath;
      try {
        parsedFilePath = await realpath(parsedFilePath);
        if (!(await lstat(parsedFilePath)).isFile()) {
          throw new Error;
        }
      } catch (err) {
        if (err instanceof Error) {
          err.message = `The file at ${parsedFilePath} does not exist, or it is not a file. ${err.message}`;
        }
        throw err;
      }
      let subjectToken;
      const rawText = await readFile(parsedFilePath, { encoding: "utf8" });
      if (this.formatType === "text") {
        subjectToken = rawText;
      } else if (this.formatType === "json" && this.subjectTokenFieldName) {
        const json = JSON.parse(rawText);
        subjectToken = json[this.subjectTokenFieldName];
      }
      if (!subjectToken) {
        throw new Error("Unable to parse the subject_token from the credential_source file");
      }
      return subjectToken;
    }
  }
  exports.FileSubjectTokenSupplier = FileSubjectTokenSupplier;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/urlsubjecttokensupplier.js
var require_urlsubjecttokensupplier = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.UrlSubjectTokenSupplier = undefined;
  var authclient_1 = require_authclient();

  class UrlSubjectTokenSupplier {
    url;
    headers;
    formatType;
    subjectTokenFieldName;
    additionalGaxiosOptions;
    constructor(opts) {
      this.url = opts.url;
      this.formatType = opts.formatType;
      this.subjectTokenFieldName = opts.subjectTokenFieldName;
      this.headers = opts.headers;
      this.additionalGaxiosOptions = opts.additionalGaxiosOptions;
    }
    async getSubjectToken(context) {
      const opts = {
        ...this.additionalGaxiosOptions,
        url: this.url,
        method: "GET",
        headers: this.headers
      };
      authclient_1.AuthClient.setMethodName(opts, "getSubjectToken");
      let subjectToken;
      if (this.formatType === "text") {
        const response = await context.transporter.request(opts);
        subjectToken = response.data;
      } else if (this.formatType === "json" && this.subjectTokenFieldName) {
        const response = await context.transporter.request(opts);
        subjectToken = response.data[this.subjectTokenFieldName];
      }
      if (!subjectToken) {
        throw new Error("Unable to parse the subject_token from the credential_source URL");
      }
      return subjectToken;
    }
  }
  exports.UrlSubjectTokenSupplier = UrlSubjectTokenSupplier;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/certificatesubjecttokensupplier.js
var require_certificatesubjecttokensupplier = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.CertificateSubjectTokenSupplier = exports.InvalidConfigurationError = exports.CertificateSourceUnavailableError = exports.CERTIFICATE_CONFIGURATION_ENV_VARIABLE = undefined;
  var util_1 = require_util2();
  var fs6 = __require("fs");
  var crypto_1 = __require("crypto");
  var https = __require("https");
  exports.CERTIFICATE_CONFIGURATION_ENV_VARIABLE = "GOOGLE_API_CERTIFICATE_CONFIG";

  class CertificateSourceUnavailableError extends Error {
    constructor(message) {
      super(message);
      this.name = "CertificateSourceUnavailableError";
    }
  }
  exports.CertificateSourceUnavailableError = CertificateSourceUnavailableError;

  class InvalidConfigurationError extends Error {
    constructor(message) {
      super(message);
      this.name = "InvalidConfigurationError";
    }
  }
  exports.InvalidConfigurationError = InvalidConfigurationError;

  class CertificateSubjectTokenSupplier {
    certificateConfigPath;
    trustChainPath;
    cert;
    key;
    constructor(opts) {
      if (!opts.useDefaultCertificateConfig && !opts.certificateConfigLocation) {
        throw new InvalidConfigurationError("Either `useDefaultCertificateConfig` must be true or a `certificateConfigLocation` must be provided.");
      }
      if (opts.useDefaultCertificateConfig && opts.certificateConfigLocation) {
        throw new InvalidConfigurationError("Both `useDefaultCertificateConfig` and `certificateConfigLocation` cannot be provided.");
      }
      this.trustChainPath = opts.trustChainPath;
      this.certificateConfigPath = opts.certificateConfigLocation ?? "";
    }
    async createMtlsHttpsAgent() {
      if (!this.key || !this.cert) {
        throw new InvalidConfigurationError("Cannot create mTLS Agent with missing certificate or key");
      }
      return new https.Agent({ key: this.key, cert: this.cert });
    }
    async getSubjectToken() {
      this.certificateConfigPath = await this.#resolveCertificateConfigFilePath();
      const { certPath, keyPath } = await this.#getCertAndKeyPaths();
      ({ cert: this.cert, key: this.key } = await this.#getKeyAndCert(certPath, keyPath));
      return await this.#processChainFromPaths(this.cert);
    }
    async#resolveCertificateConfigFilePath() {
      const overridePath = this.certificateConfigPath;
      if (overridePath) {
        if (await (0, util_1.isValidFile)(overridePath)) {
          return overridePath;
        }
        throw new CertificateSourceUnavailableError(`Provided certificate config path is invalid: ${overridePath}`);
      }
      const envPath = process.env[exports.CERTIFICATE_CONFIGURATION_ENV_VARIABLE];
      if (envPath) {
        if (await (0, util_1.isValidFile)(envPath)) {
          return envPath;
        }
        throw new CertificateSourceUnavailableError(`Path from environment variable "${exports.CERTIFICATE_CONFIGURATION_ENV_VARIABLE}" is invalid: ${envPath}`);
      }
      const wellKnownPath = (0, util_1.getWellKnownCertificateConfigFileLocation)();
      if (await (0, util_1.isValidFile)(wellKnownPath)) {
        return wellKnownPath;
      }
      throw new CertificateSourceUnavailableError("Could not find certificate configuration file. Searched override path, " + `the "${exports.CERTIFICATE_CONFIGURATION_ENV_VARIABLE}" env var, and the gcloud path (${wellKnownPath}).`);
    }
    async#getCertAndKeyPaths() {
      const configPath = this.certificateConfigPath;
      let fileContents;
      try {
        fileContents = await fs6.promises.readFile(configPath, "utf8");
      } catch (err) {
        throw new CertificateSourceUnavailableError(`Failed to read certificate config file at: ${configPath}`);
      }
      try {
        const config = JSON.parse(fileContents);
        const certPath = config?.cert_configs?.workload?.cert_path;
        const keyPath = config?.cert_configs?.workload?.key_path;
        if (!certPath || !keyPath) {
          throw new InvalidConfigurationError(`Certificate config file (${configPath}) is missing required "cert_path" or "key_path" in the workload config.`);
        }
        return { certPath, keyPath };
      } catch (e) {
        if (e instanceof InvalidConfigurationError)
          throw e;
        throw new InvalidConfigurationError(`Failed to parse certificate config from ${configPath}: ${e.message}`);
      }
    }
    async#getKeyAndCert(certPath, keyPath) {
      let cert, key;
      try {
        cert = await fs6.promises.readFile(certPath);
        new crypto_1.X509Certificate(cert);
      } catch (err) {
        const message = err instanceof Error ? err.message : String(err);
        throw new CertificateSourceUnavailableError(`Failed to read certificate file at ${certPath}: ${message}`);
      }
      try {
        key = await fs6.promises.readFile(keyPath);
        (0, crypto_1.createPrivateKey)(key);
      } catch (err) {
        const message = err instanceof Error ? err.message : String(err);
        throw new CertificateSourceUnavailableError(`Failed to read private key file at ${keyPath}: ${message}`);
      }
      return { cert, key };
    }
    async#processChainFromPaths(leafCertBuffer) {
      const leafCert = new crypto_1.X509Certificate(leafCertBuffer);
      if (!this.trustChainPath) {
        return JSON.stringify([leafCert.raw.toString("base64")]);
      }
      try {
        const chainPems = await fs6.promises.readFile(this.trustChainPath, "utf8");
        const pemBlocks = chainPems.match(/-----BEGIN CERTIFICATE-----[^-]+-----END CERTIFICATE-----/g) ?? [];
        const chainCerts = pemBlocks.map((pem, index) => {
          try {
            return new crypto_1.X509Certificate(pem);
          } catch (err) {
            const message = err instanceof Error ? err.message : String(err);
            throw new InvalidConfigurationError(`Failed to parse certificate at index ${index} in trust chain file ${this.trustChainPath}: ${message}`);
          }
        });
        const leafIndex = chainCerts.findIndex((chainCert) => leafCert.raw.equals(chainCert.raw));
        let finalChain;
        if (leafIndex === -1) {
          finalChain = [leafCert, ...chainCerts];
        } else if (leafIndex === 0) {
          finalChain = chainCerts;
        } else {
          throw new InvalidConfigurationError(`Leaf certificate exists in the trust chain but is not the first entry (found at index ${leafIndex}).`);
        }
        return JSON.stringify(finalChain.map((cert) => cert.raw.toString("base64")));
      } catch (err) {
        if (err instanceof InvalidConfigurationError)
          throw err;
        const message = err instanceof Error ? err.message : String(err);
        throw new CertificateSourceUnavailableError(`Failed to process certificate chain from ${this.trustChainPath}: ${message}`);
      }
    }
  }
  exports.CertificateSubjectTokenSupplier = CertificateSubjectTokenSupplier;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/identitypoolclient.js
var require_identitypoolclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IdentityPoolClient = undefined;
  var baseexternalclient_1 = require_baseexternalclient();
  var util_1 = require_util2();
  var filesubjecttokensupplier_1 = require_filesubjecttokensupplier();
  var urlsubjecttokensupplier_1 = require_urlsubjecttokensupplier();
  var certificatesubjecttokensupplier_1 = require_certificatesubjecttokensupplier();
  var stscredentials_1 = require_stscredentials();
  var gaxios_1 = require_src2();

  class IdentityPoolClient extends baseexternalclient_1.BaseExternalAccountClient {
    subjectTokenSupplier;
    constructor(options) {
      super(options);
      const opts = (0, util_1.originalOrCamelOptions)(options);
      const credentialSource = opts.get("credential_source");
      const subjectTokenSupplier = opts.get("subject_token_supplier");
      if (!credentialSource && !subjectTokenSupplier) {
        throw new Error("A credential source or subject token supplier must be specified.");
      }
      if (credentialSource && subjectTokenSupplier) {
        throw new Error("Only one of credential source or subject token supplier can be specified.");
      }
      if (subjectTokenSupplier) {
        this.subjectTokenSupplier = subjectTokenSupplier;
        this.credentialSourceType = "programmatic";
      } else {
        const credentialSourceOpts = (0, util_1.originalOrCamelOptions)(credentialSource);
        const formatOpts = (0, util_1.originalOrCamelOptions)(credentialSourceOpts.get("format"));
        const formatType = formatOpts.get("type") || "text";
        const formatSubjectTokenFieldName = formatOpts.get("subject_token_field_name");
        if (formatType !== "json" && formatType !== "text") {
          throw new Error(`Invalid credential_source format "${formatType}"`);
        }
        if (formatType === "json" && !formatSubjectTokenFieldName) {
          throw new Error("Missing subject_token_field_name for JSON credential_source format");
        }
        const file = credentialSourceOpts.get("file");
        const url = credentialSourceOpts.get("url");
        const certificate = credentialSourceOpts.get("certificate");
        const headers = credentialSourceOpts.get("headers");
        if (file && url || url && certificate || file && certificate) {
          throw new Error('No valid Identity Pool "credential_source" provided, must be either file, url, or certificate.');
        } else if (file) {
          this.credentialSourceType = "file";
          this.subjectTokenSupplier = new filesubjecttokensupplier_1.FileSubjectTokenSupplier({
            filePath: file,
            formatType,
            subjectTokenFieldName: formatSubjectTokenFieldName
          });
        } else if (url) {
          this.credentialSourceType = "url";
          this.subjectTokenSupplier = new urlsubjecttokensupplier_1.UrlSubjectTokenSupplier({
            url,
            formatType,
            subjectTokenFieldName: formatSubjectTokenFieldName,
            headers,
            additionalGaxiosOptions: IdentityPoolClient.RETRY_CONFIG
          });
        } else if (certificate) {
          this.credentialSourceType = "certificate";
          const certificateSubjecttokensupplier = new certificatesubjecttokensupplier_1.CertificateSubjectTokenSupplier({
            useDefaultCertificateConfig: certificate.use_default_certificate_config,
            certificateConfigLocation: certificate.certificate_config_location,
            trustChainPath: certificate.trust_chain_path
          });
          this.subjectTokenSupplier = certificateSubjecttokensupplier;
        } else {
          throw new Error('No valid Identity Pool "credential_source" provided, must be either file, url, or certificate.');
        }
      }
    }
    async retrieveSubjectToken() {
      const subjectToken = await this.subjectTokenSupplier.getSubjectToken(this.supplierContext);
      if (this.subjectTokenSupplier instanceof certificatesubjecttokensupplier_1.CertificateSubjectTokenSupplier) {
        const mtlsAgent = await this.subjectTokenSupplier.createMtlsHttpsAgent();
        this.stsCredential = new stscredentials_1.StsCredentials({
          tokenExchangeEndpoint: this.getTokenUrl(),
          clientAuthentication: this.clientAuth,
          transporter: new gaxios_1.Gaxios({ agent: mtlsAgent })
        });
        this.transporter = new gaxios_1.Gaxios({
          ...this.transporter.defaults || {},
          agent: mtlsAgent
        });
      }
      return subjectToken;
    }
  }
  exports.IdentityPoolClient = IdentityPoolClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/awsrequestsigner.js
var require_awsrequestsigner = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AwsRequestSigner = undefined;
  var gaxios_1 = require_src2();
  var crypto_1 = require_crypto3();
  var AWS_ALGORITHM = "AWS4-HMAC-SHA256";
  var AWS_REQUEST_TYPE = "aws4_request";

  class AwsRequestSigner {
    getCredentials;
    region;
    crypto;
    constructor(getCredentials, region) {
      this.getCredentials = getCredentials;
      this.region = region;
      this.crypto = (0, crypto_1.createCrypto)();
    }
    async getRequestOptions(amzOptions) {
      if (!amzOptions.url) {
        throw new RangeError('"url" is required in "amzOptions"');
      }
      const requestPayloadData = typeof amzOptions.data === "object" ? JSON.stringify(amzOptions.data) : amzOptions.data;
      const url = amzOptions.url;
      const method = amzOptions.method || "GET";
      const requestPayload = amzOptions.body || requestPayloadData;
      const additionalAmzHeaders = amzOptions.headers;
      const awsSecurityCredentials = await this.getCredentials();
      const uri = new URL(url);
      if (typeof requestPayload !== "string" && requestPayload !== undefined) {
        throw new TypeError(`'requestPayload' is expected to be a string if provided. Got: ${requestPayload}`);
      }
      const headerMap = await generateAuthenticationHeaderMap({
        crypto: this.crypto,
        host: uri.host,
        canonicalUri: uri.pathname,
        canonicalQuerystring: uri.search.slice(1),
        method,
        region: this.region,
        securityCredentials: awsSecurityCredentials,
        requestPayload,
        additionalAmzHeaders
      });
      const headers = gaxios_1.Gaxios.mergeHeaders(headerMap.amzDate ? { "x-amz-date": headerMap.amzDate } : {}, {
        authorization: headerMap.authorizationHeader,
        host: uri.host
      }, additionalAmzHeaders || {});
      if (awsSecurityCredentials.token) {
        gaxios_1.Gaxios.mergeHeaders(headers, {
          "x-amz-security-token": awsSecurityCredentials.token
        });
      }
      const awsSignedReq = {
        url,
        method,
        headers
      };
      if (requestPayload !== undefined) {
        awsSignedReq.body = requestPayload;
      }
      return awsSignedReq;
    }
  }
  exports.AwsRequestSigner = AwsRequestSigner;
  async function sign(crypto3, key, msg) {
    return await crypto3.signWithHmacSha256(key, msg);
  }
  async function getSigningKey(crypto3, key, dateStamp, region, serviceName) {
    const kDate = await sign(crypto3, `AWS4${key}`, dateStamp);
    const kRegion = await sign(crypto3, kDate, region);
    const kService = await sign(crypto3, kRegion, serviceName);
    const kSigning = await sign(crypto3, kService, "aws4_request");
    return kSigning;
  }
  async function generateAuthenticationHeaderMap(options) {
    const additionalAmzHeaders = gaxios_1.Gaxios.mergeHeaders(options.additionalAmzHeaders);
    const requestPayload = options.requestPayload || "";
    const serviceName = options.host.split(".")[0];
    const now = new Date;
    const amzDate = now.toISOString().replace(/[-:]/g, "").replace(/\.[0-9]+/, "");
    const dateStamp = now.toISOString().replace(/[-]/g, "").replace(/T.*/, "");
    if (options.securityCredentials.token) {
      additionalAmzHeaders.set("x-amz-security-token", options.securityCredentials.token);
    }
    const amzHeaders = gaxios_1.Gaxios.mergeHeaders({
      host: options.host
    }, additionalAmzHeaders.has("date") ? {} : { "x-amz-date": amzDate }, additionalAmzHeaders);
    let canonicalHeaders = "";
    const signedHeadersList = [
      ...amzHeaders.keys()
    ].sort();
    signedHeadersList.forEach((key) => {
      canonicalHeaders += `${key}:${amzHeaders.get(key)}
`;
    });
    const signedHeaders = signedHeadersList.join(";");
    const payloadHash = await options.crypto.sha256DigestHex(requestPayload);
    const canonicalRequest = `${options.method.toUpperCase()}
` + `${options.canonicalUri}
` + `${options.canonicalQuerystring}
` + `${canonicalHeaders}
` + `${signedHeaders}
` + `${payloadHash}`;
    const credentialScope = `${dateStamp}/${options.region}/${serviceName}/${AWS_REQUEST_TYPE}`;
    const stringToSign = `${AWS_ALGORITHM}
` + `${amzDate}
` + `${credentialScope}
` + await options.crypto.sha256DigestHex(canonicalRequest);
    const signingKey = await getSigningKey(options.crypto, options.securityCredentials.secretAccessKey, dateStamp, options.region, serviceName);
    const signature = await sign(options.crypto, signingKey, stringToSign);
    const authorizationHeader = `${AWS_ALGORITHM} Credential=${options.securityCredentials.accessKeyId}/` + `${credentialScope}, SignedHeaders=${signedHeaders}, ` + `Signature=${(0, crypto_1.fromArrayBufferToHex)(signature)}`;
    return {
      amzDate: additionalAmzHeaders.has("date") ? undefined : amzDate,
      authorizationHeader,
      canonicalQuerystring: options.canonicalQuerystring
    };
  }
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/defaultawssecuritycredentialssupplier.js
var require_defaultawssecuritycredentialssupplier = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.DefaultAwsSecurityCredentialsSupplier = undefined;
  var authclient_1 = require_authclient();

  class DefaultAwsSecurityCredentialsSupplier {
    regionUrl;
    securityCredentialsUrl;
    imdsV2SessionTokenUrl;
    additionalGaxiosOptions;
    constructor(opts) {
      this.regionUrl = opts.regionUrl;
      this.securityCredentialsUrl = opts.securityCredentialsUrl;
      this.imdsV2SessionTokenUrl = opts.imdsV2SessionTokenUrl;
      this.additionalGaxiosOptions = opts.additionalGaxiosOptions;
    }
    async getAwsRegion(context) {
      if (this.#regionFromEnv) {
        return this.#regionFromEnv;
      }
      const metadataHeaders = new Headers;
      if (!this.#regionFromEnv && this.imdsV2SessionTokenUrl) {
        metadataHeaders.set("x-aws-ec2-metadata-token", await this.#getImdsV2SessionToken(context.transporter));
      }
      if (!this.regionUrl) {
        throw new RangeError("Unable to determine AWS region due to missing " + '"options.credential_source.region_url"');
      }
      const opts = {
        ...this.additionalGaxiosOptions,
        url: this.regionUrl,
        method: "GET",
        headers: metadataHeaders
      };
      authclient_1.AuthClient.setMethodName(opts, "getAwsRegion");
      const response = await context.transporter.request(opts);
      return response.data.substr(0, response.data.length - 1);
    }
    async getAwsSecurityCredentials(context) {
      if (this.#securityCredentialsFromEnv) {
        return this.#securityCredentialsFromEnv;
      }
      const metadataHeaders = new Headers;
      if (this.imdsV2SessionTokenUrl) {
        metadataHeaders.set("x-aws-ec2-metadata-token", await this.#getImdsV2SessionToken(context.transporter));
      }
      const roleName = await this.#getAwsRoleName(metadataHeaders, context.transporter);
      const awsCreds = await this.#retrieveAwsSecurityCredentials(roleName, metadataHeaders, context.transporter);
      return {
        accessKeyId: awsCreds.AccessKeyId,
        secretAccessKey: awsCreds.SecretAccessKey,
        token: awsCreds.Token
      };
    }
    async#getImdsV2SessionToken(transporter) {
      const opts = {
        ...this.additionalGaxiosOptions,
        url: this.imdsV2SessionTokenUrl,
        method: "PUT",
        headers: { "x-aws-ec2-metadata-token-ttl-seconds": "300" }
      };
      authclient_1.AuthClient.setMethodName(opts, "#getImdsV2SessionToken");
      const response = await transporter.request(opts);
      return response.data;
    }
    async#getAwsRoleName(headers, transporter) {
      if (!this.securityCredentialsUrl) {
        throw new Error("Unable to determine AWS role name due to missing " + '"options.credential_source.url"');
      }
      const opts = {
        ...this.additionalGaxiosOptions,
        url: this.securityCredentialsUrl,
        method: "GET",
        headers
      };
      authclient_1.AuthClient.setMethodName(opts, "#getAwsRoleName");
      const response = await transporter.request(opts);
      return response.data;
    }
    async#retrieveAwsSecurityCredentials(roleName, headers, transporter) {
      const opts = {
        ...this.additionalGaxiosOptions,
        url: `${this.securityCredentialsUrl}/${roleName}`,
        headers
      };
      authclient_1.AuthClient.setMethodName(opts, "#retrieveAwsSecurityCredentials");
      const response = await transporter.request(opts);
      return response.data;
    }
    get #regionFromEnv() {
      return process.env["AWS_REGION"] || process.env["AWS_DEFAULT_REGION"] || null;
    }
    get #securityCredentialsFromEnv() {
      if (process.env["AWS_ACCESS_KEY_ID"] && process.env["AWS_SECRET_ACCESS_KEY"]) {
        return {
          accessKeyId: process.env["AWS_ACCESS_KEY_ID"],
          secretAccessKey: process.env["AWS_SECRET_ACCESS_KEY"],
          token: process.env["AWS_SESSION_TOKEN"]
        };
      }
      return null;
    }
  }
  exports.DefaultAwsSecurityCredentialsSupplier = DefaultAwsSecurityCredentialsSupplier;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/awsclient.js
var require_awsclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.AwsClient = undefined;
  var awsrequestsigner_1 = require_awsrequestsigner();
  var baseexternalclient_1 = require_baseexternalclient();
  var defaultawssecuritycredentialssupplier_1 = require_defaultawssecuritycredentialssupplier();
  var util_1 = require_util2();
  var gaxios_1 = require_src2();

  class AwsClient extends baseexternalclient_1.BaseExternalAccountClient {
    environmentId;
    awsSecurityCredentialsSupplier;
    regionalCredVerificationUrl;
    awsRequestSigner;
    region;
    static #DEFAULT_AWS_REGIONAL_CREDENTIAL_VERIFICATION_URL = "https://sts.{region}.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15";
    static AWS_EC2_METADATA_IPV4_ADDRESS = "169.254.169.254";
    static AWS_EC2_METADATA_IPV6_ADDRESS = "fd00:ec2::254";
    constructor(options) {
      super(options);
      const opts = (0, util_1.originalOrCamelOptions)(options);
      const credentialSource = opts.get("credential_source");
      const awsSecurityCredentialsSupplier = opts.get("aws_security_credentials_supplier");
      if (!credentialSource && !awsSecurityCredentialsSupplier) {
        throw new Error("A credential source or AWS security credentials supplier must be specified.");
      }
      if (credentialSource && awsSecurityCredentialsSupplier) {
        throw new Error("Only one of credential source or AWS security credentials supplier can be specified.");
      }
      if (awsSecurityCredentialsSupplier) {
        this.awsSecurityCredentialsSupplier = awsSecurityCredentialsSupplier;
        this.regionalCredVerificationUrl = AwsClient.#DEFAULT_AWS_REGIONAL_CREDENTIAL_VERIFICATION_URL;
        this.credentialSourceType = "programmatic";
      } else {
        const credentialSourceOpts = (0, util_1.originalOrCamelOptions)(credentialSource);
        this.environmentId = credentialSourceOpts.get("environment_id");
        const regionUrl = credentialSourceOpts.get("region_url");
        const securityCredentialsUrl = credentialSourceOpts.get("url");
        const imdsV2SessionTokenUrl = credentialSourceOpts.get("imdsv2_session_token_url");
        this.awsSecurityCredentialsSupplier = new defaultawssecuritycredentialssupplier_1.DefaultAwsSecurityCredentialsSupplier({
          regionUrl,
          securityCredentialsUrl,
          imdsV2SessionTokenUrl
        });
        this.regionalCredVerificationUrl = credentialSourceOpts.get("regional_cred_verification_url");
        this.credentialSourceType = "aws";
        this.validateEnvironmentId();
      }
      this.awsRequestSigner = null;
      this.region = "";
    }
    validateEnvironmentId() {
      const match2 = this.environmentId?.match(/^(aws)(\d+)$/);
      if (!match2 || !this.regionalCredVerificationUrl) {
        throw new Error('No valid AWS "credential_source" provided');
      } else if (parseInt(match2[2], 10) !== 1) {
        throw new Error(`aws version "${match2[2]}" is not supported in the current build.`);
      }
    }
    async retrieveSubjectToken() {
      if (!this.awsRequestSigner) {
        this.region = await this.awsSecurityCredentialsSupplier.getAwsRegion(this.supplierContext);
        this.awsRequestSigner = new awsrequestsigner_1.AwsRequestSigner(async () => {
          return this.awsSecurityCredentialsSupplier.getAwsSecurityCredentials(this.supplierContext);
        }, this.region);
      }
      const options = await this.awsRequestSigner.getRequestOptions({
        ...AwsClient.RETRY_CONFIG,
        url: this.regionalCredVerificationUrl.replace("{region}", this.region),
        method: "POST"
      });
      const reformattedHeader = [];
      const extendedHeaders = gaxios_1.Gaxios.mergeHeaders({
        "x-goog-cloud-target-resource": this.audience
      }, options.headers);
      extendedHeaders.forEach((value, key) => reformattedHeader.push({ key, value }));
      return encodeURIComponent(JSON.stringify({
        url: options.url,
        method: options.method,
        headers: reformattedHeader
      }));
    }
  }
  exports.AwsClient = AwsClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/executable-response.js
var require_executable_response = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.InvalidSubjectTokenError = exports.InvalidMessageFieldError = exports.InvalidCodeFieldError = exports.InvalidTokenTypeFieldError = exports.InvalidExpirationTimeFieldError = exports.InvalidSuccessFieldError = exports.InvalidVersionFieldError = exports.ExecutableResponseError = exports.ExecutableResponse = undefined;
  var SAML_SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:saml2";
  var OIDC_SUBJECT_TOKEN_TYPE1 = "urn:ietf:params:oauth:token-type:id_token";
  var OIDC_SUBJECT_TOKEN_TYPE2 = "urn:ietf:params:oauth:token-type:jwt";

  class ExecutableResponse {
    version;
    success;
    expirationTime;
    tokenType;
    errorCode;
    errorMessage;
    subjectToken;
    constructor(responseJson) {
      if (!responseJson.version) {
        throw new InvalidVersionFieldError("Executable response must contain a 'version' field.");
      }
      if (responseJson.success === undefined) {
        throw new InvalidSuccessFieldError("Executable response must contain a 'success' field.");
      }
      this.version = responseJson.version;
      this.success = responseJson.success;
      if (this.success) {
        this.expirationTime = responseJson.expiration_time;
        this.tokenType = responseJson.token_type;
        if (this.tokenType !== SAML_SUBJECT_TOKEN_TYPE && this.tokenType !== OIDC_SUBJECT_TOKEN_TYPE1 && this.tokenType !== OIDC_SUBJECT_TOKEN_TYPE2) {
          throw new InvalidTokenTypeFieldError("Executable response must contain a 'token_type' field when successful " + `and it must be one of ${OIDC_SUBJECT_TOKEN_TYPE1}, ${OIDC_SUBJECT_TOKEN_TYPE2}, or ${SAML_SUBJECT_TOKEN_TYPE}.`);
        }
        if (this.tokenType === SAML_SUBJECT_TOKEN_TYPE) {
          if (!responseJson.saml_response) {
            throw new InvalidSubjectTokenError(`Executable response must contain a 'saml_response' field when token_type=${SAML_SUBJECT_TOKEN_TYPE}.`);
          }
          this.subjectToken = responseJson.saml_response;
        } else {
          if (!responseJson.id_token) {
            throw new InvalidSubjectTokenError("Executable response must contain a 'id_token' field when " + `token_type=${OIDC_SUBJECT_TOKEN_TYPE1} or ${OIDC_SUBJECT_TOKEN_TYPE2}.`);
          }
          this.subjectToken = responseJson.id_token;
        }
      } else {
        if (!responseJson.code) {
          throw new InvalidCodeFieldError("Executable response must contain a 'code' field when unsuccessful.");
        }
        if (!responseJson.message) {
          throw new InvalidMessageFieldError("Executable response must contain a 'message' field when unsuccessful.");
        }
        this.errorCode = responseJson.code;
        this.errorMessage = responseJson.message;
      }
    }
    isValid() {
      return !this.isExpired() && this.success;
    }
    isExpired() {
      return this.expirationTime !== undefined && this.expirationTime < Math.round(Date.now() / 1000);
    }
  }
  exports.ExecutableResponse = ExecutableResponse;

  class ExecutableResponseError extends Error {
    constructor(message) {
      super(message);
      Object.setPrototypeOf(this, new.target.prototype);
    }
  }
  exports.ExecutableResponseError = ExecutableResponseError;

  class InvalidVersionFieldError extends ExecutableResponseError {
  }
  exports.InvalidVersionFieldError = InvalidVersionFieldError;

  class InvalidSuccessFieldError extends ExecutableResponseError {
  }
  exports.InvalidSuccessFieldError = InvalidSuccessFieldError;

  class InvalidExpirationTimeFieldError extends ExecutableResponseError {
  }
  exports.InvalidExpirationTimeFieldError = InvalidExpirationTimeFieldError;

  class InvalidTokenTypeFieldError extends ExecutableResponseError {
  }
  exports.InvalidTokenTypeFieldError = InvalidTokenTypeFieldError;

  class InvalidCodeFieldError extends ExecutableResponseError {
  }
  exports.InvalidCodeFieldError = InvalidCodeFieldError;

  class InvalidMessageFieldError extends ExecutableResponseError {
  }
  exports.InvalidMessageFieldError = InvalidMessageFieldError;

  class InvalidSubjectTokenError extends ExecutableResponseError {
  }
  exports.InvalidSubjectTokenError = InvalidSubjectTokenError;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/pluggable-auth-handler.js
var require_pluggable_auth_handler = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.PluggableAuthHandler = exports.ExecutableError = undefined;
  var executable_response_1 = require_executable_response();
  var childProcess4 = __require("child_process");
  var fs6 = __require("fs");

  class ExecutableError extends Error {
    code;
    constructor(message, code) {
      super(`The executable failed with exit code: ${code} and error message: ${message}.`);
      this.code = code;
      Object.setPrototypeOf(this, new.target.prototype);
    }
  }
  exports.ExecutableError = ExecutableError;

  class PluggableAuthHandler {
    commandComponents;
    timeoutMillis;
    outputFile;
    constructor(options) {
      if (!options.command) {
        throw new Error("No command provided.");
      }
      this.commandComponents = PluggableAuthHandler.parseCommand(options.command);
      this.timeoutMillis = options.timeoutMillis;
      if (!this.timeoutMillis) {
        throw new Error("No timeoutMillis provided.");
      }
      this.outputFile = options.outputFile;
    }
    retrieveResponseFromExecutable(envMap) {
      return new Promise((resolve3, reject) => {
        const child = childProcess4.spawn(this.commandComponents[0], this.commandComponents.slice(1), {
          env: { ...process.env, ...Object.fromEntries(envMap) }
        });
        let output = "";
        child.stdout.on("data", (data) => {
          output += data;
        });
        child.stderr.on("data", (err) => {
          output += err;
        });
        const timeout = setTimeout(() => {
          child.removeAllListeners();
          child.kill();
          return reject(new Error("The executable failed to finish within the timeout specified."));
        }, this.timeoutMillis);
        child.on("close", (code) => {
          clearTimeout(timeout);
          if (code === 0) {
            try {
              const responseJson = JSON.parse(output);
              const response = new executable_response_1.ExecutableResponse(responseJson);
              return resolve3(response);
            } catch (error3) {
              if (error3 instanceof executable_response_1.ExecutableResponseError) {
                return reject(error3);
              }
              return reject(new executable_response_1.ExecutableResponseError(`The executable returned an invalid response: ${output}`));
            }
          } else {
            return reject(new ExecutableError(output, code.toString()));
          }
        });
      });
    }
    async retrieveCachedResponse() {
      if (!this.outputFile || this.outputFile.length === 0) {
        return;
      }
      let filePath;
      try {
        filePath = await fs6.promises.realpath(this.outputFile);
      } catch {
        return;
      }
      if (!(await fs6.promises.lstat(filePath)).isFile()) {
        return;
      }
      const responseString = await fs6.promises.readFile(filePath, {
        encoding: "utf8"
      });
      if (responseString === "") {
        return;
      }
      try {
        const responseJson = JSON.parse(responseString);
        const response = new executable_response_1.ExecutableResponse(responseJson);
        if (response.isValid()) {
          return new executable_response_1.ExecutableResponse(responseJson);
        }
        return;
      } catch (error3) {
        if (error3 instanceof executable_response_1.ExecutableResponseError) {
          throw error3;
        }
        throw new executable_response_1.ExecutableResponseError(`The output file contained an invalid response: ${responseString}`);
      }
    }
    static parseCommand(command) {
      const components = command.match(/(?:[^\s"]+|"[^"]*")+/g);
      if (!components) {
        throw new Error(`Provided command: "${command}" could not be parsed.`);
      }
      for (let i = 0;i < components.length; i++) {
        if (components[i][0] === '"' && components[i].slice(-1) === '"') {
          components[i] = components[i].slice(1, -1);
        }
      }
      return components;
    }
  }
  exports.PluggableAuthHandler = PluggableAuthHandler;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/pluggable-auth-client.js
var require_pluggable_auth_client = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.PluggableAuthClient = exports.ExecutableError = undefined;
  var baseexternalclient_1 = require_baseexternalclient();
  var executable_response_1 = require_executable_response();
  var pluggable_auth_handler_1 = require_pluggable_auth_handler();
  var pluggable_auth_handler_2 = require_pluggable_auth_handler();
  Object.defineProperty(exports, "ExecutableError", { enumerable: true, get: function() {
    return pluggable_auth_handler_2.ExecutableError;
  } });
  var DEFAULT_EXECUTABLE_TIMEOUT_MILLIS = 30 * 1000;
  var MINIMUM_EXECUTABLE_TIMEOUT_MILLIS = 5 * 1000;
  var MAXIMUM_EXECUTABLE_TIMEOUT_MILLIS = 120 * 1000;
  var GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES = "GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES";
  var MAXIMUM_EXECUTABLE_VERSION = 1;

  class PluggableAuthClient extends baseexternalclient_1.BaseExternalAccountClient {
    command;
    timeoutMillis;
    outputFile;
    handler;
    constructor(options) {
      super(options);
      if (!options.credential_source.executable) {
        throw new Error('No valid Pluggable Auth "credential_source" provided.');
      }
      this.command = options.credential_source.executable.command;
      if (!this.command) {
        throw new Error('No valid Pluggable Auth "credential_source" provided.');
      }
      if (options.credential_source.executable.timeout_millis === undefined) {
        this.timeoutMillis = DEFAULT_EXECUTABLE_TIMEOUT_MILLIS;
      } else {
        this.timeoutMillis = options.credential_source.executable.timeout_millis;
        if (this.timeoutMillis < MINIMUM_EXECUTABLE_TIMEOUT_MILLIS || this.timeoutMillis > MAXIMUM_EXECUTABLE_TIMEOUT_MILLIS) {
          throw new Error(`Timeout must be between ${MINIMUM_EXECUTABLE_TIMEOUT_MILLIS} and ` + `${MAXIMUM_EXECUTABLE_TIMEOUT_MILLIS} milliseconds.`);
        }
      }
      this.outputFile = options.credential_source.executable.output_file;
      this.handler = new pluggable_auth_handler_1.PluggableAuthHandler({
        command: this.command,
        timeoutMillis: this.timeoutMillis,
        outputFile: this.outputFile
      });
      this.credentialSourceType = "executable";
    }
    async retrieveSubjectToken() {
      if (process.env[GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES] !== "1") {
        throw new Error("Pluggable Auth executables need to be explicitly allowed to run by " + "setting the GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES environment " + "Variable to 1.");
      }
      let executableResponse = undefined;
      if (this.outputFile) {
        executableResponse = await this.handler.retrieveCachedResponse();
      }
      if (!executableResponse) {
        const envMap = new Map;
        envMap.set("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE", this.audience);
        envMap.set("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE", this.subjectTokenType);
        envMap.set("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE", "0");
        if (this.outputFile) {
          envMap.set("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE", this.outputFile);
        }
        const serviceAccountEmail = this.getServiceAccountEmail();
        if (serviceAccountEmail) {
          envMap.set("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL", serviceAccountEmail);
        }
        executableResponse = await this.handler.retrieveResponseFromExecutable(envMap);
      }
      if (executableResponse.version > MAXIMUM_EXECUTABLE_VERSION) {
        throw new Error(`Version of executable is not currently supported, maximum supported version is ${MAXIMUM_EXECUTABLE_VERSION}.`);
      }
      if (!executableResponse.success) {
        throw new pluggable_auth_handler_1.ExecutableError(executableResponse.errorMessage, executableResponse.errorCode);
      }
      if (this.outputFile) {
        if (!executableResponse.expirationTime) {
          throw new executable_response_1.InvalidExpirationTimeFieldError("The executable response must contain the `expiration_time` field for successful responses when an output_file has been specified in the configuration.");
        }
      }
      if (executableResponse.isExpired()) {
        throw new Error("Executable response is expired.");
      }
      return executableResponse.subjectToken;
    }
  }
  exports.PluggableAuthClient = PluggableAuthClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/externalclient.js
var require_externalclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ExternalAccountClient = undefined;
  var baseexternalclient_1 = require_baseexternalclient();
  var identitypoolclient_1 = require_identitypoolclient();
  var awsclient_1 = require_awsclient();
  var pluggable_auth_client_1 = require_pluggable_auth_client();

  class ExternalAccountClient {
    constructor() {
      throw new Error("ExternalAccountClients should be initialized via: " + "ExternalAccountClient.fromJSON(), " + "directly via explicit constructors, eg. " + "new AwsClient(options), new IdentityPoolClient(options), new" + "PluggableAuthClientOptions, or via " + "new GoogleAuth(options).getClient()");
    }
    static fromJSON(options) {
      if (options && options.type === baseexternalclient_1.EXTERNAL_ACCOUNT_TYPE) {
        if (options.credential_source?.environment_id) {
          return new awsclient_1.AwsClient(options);
        } else if (options.credential_source?.executable) {
          return new pluggable_auth_client_1.PluggableAuthClient(options);
        } else {
          return new identitypoolclient_1.IdentityPoolClient(options);
        }
      } else {
        return null;
      }
    }
  }
  exports.ExternalAccountClient = ExternalAccountClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/externalAccountAuthorizedUserClient.js
var require_externalAccountAuthorizedUserClient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ExternalAccountAuthorizedUserClient = exports.EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE = undefined;
  var authclient_1 = require_authclient();
  var oauth2common_1 = require_oauth2common();
  var gaxios_1 = require_src2();
  var stream = __require("stream");
  var baseexternalclient_1 = require_baseexternalclient();
  exports.EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE = "external_account_authorized_user";
  var DEFAULT_TOKEN_URL = "https://sts.{universeDomain}/v1/oauthtoken";

  class ExternalAccountAuthorizedUserHandler extends oauth2common_1.OAuthClientAuthHandler {
    #tokenRefreshEndpoint;
    constructor(options) {
      super(options);
      this.#tokenRefreshEndpoint = options.tokenRefreshEndpoint;
    }
    async refreshToken(refreshToken, headers) {
      const opts = {
        ...ExternalAccountAuthorizedUserHandler.RETRY_CONFIG,
        url: this.#tokenRefreshEndpoint,
        method: "POST",
        headers,
        data: new URLSearchParams({
          grant_type: "refresh_token",
          refresh_token: refreshToken
        })
      };
      authclient_1.AuthClient.setMethodName(opts, "refreshToken");
      this.applyClientAuthenticationOptions(opts);
      try {
        const response = await this.transporter.request(opts);
        const tokenRefreshResponse = response.data;
        tokenRefreshResponse.res = response;
        return tokenRefreshResponse;
      } catch (error3) {
        if (error3 instanceof gaxios_1.GaxiosError && error3.response) {
          throw (0, oauth2common_1.getErrorFromOAuthErrorResponse)(error3.response.data, error3);
        }
        throw error3;
      }
    }
  }

  class ExternalAccountAuthorizedUserClient extends authclient_1.AuthClient {
    cachedAccessToken;
    externalAccountAuthorizedUserHandler;
    refreshToken;
    constructor(options) {
      super(options);
      if (options.universe_domain) {
        this.universeDomain = options.universe_domain;
      }
      this.refreshToken = options.refresh_token;
      const clientAuthentication = {
        confidentialClientType: "basic",
        clientId: options.client_id,
        clientSecret: options.client_secret
      };
      this.externalAccountAuthorizedUserHandler = new ExternalAccountAuthorizedUserHandler({
        tokenRefreshEndpoint: options.token_url ?? DEFAULT_TOKEN_URL.replace("{universeDomain}", this.universeDomain),
        transporter: this.transporter,
        clientAuthentication
      });
      this.cachedAccessToken = null;
      this.quotaProjectId = options.quota_project_id;
      if (typeof options?.eagerRefreshThresholdMillis !== "number") {
        this.eagerRefreshThresholdMillis = baseexternalclient_1.EXPIRATION_TIME_OFFSET;
      } else {
        this.eagerRefreshThresholdMillis = options.eagerRefreshThresholdMillis;
      }
      this.forceRefreshOnFailure = !!options?.forceRefreshOnFailure;
    }
    async getAccessToken() {
      if (!this.cachedAccessToken || this.isExpired(this.cachedAccessToken)) {
        await this.refreshAccessTokenAsync();
      }
      return {
        token: this.cachedAccessToken.access_token,
        res: this.cachedAccessToken.res
      };
    }
    async getRequestHeaders() {
      const accessTokenResponse = await this.getAccessToken();
      const headers = new Headers({
        authorization: `Bearer ${accessTokenResponse.token}`
      });
      return this.addSharedMetadataHeaders(headers);
    }
    request(opts, callback) {
      if (callback) {
        this.requestAsync(opts).then((r) => callback(null, r), (e) => {
          return callback(e, e.response);
        });
      } else {
        return this.requestAsync(opts);
      }
    }
    async requestAsync(opts, reAuthRetried = false) {
      let response;
      try {
        const requestHeaders = await this.getRequestHeaders();
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
        this.addUserProjectAndAuthHeaders(opts.headers, requestHeaders);
        response = await this.transporter.request(opts);
      } catch (e) {
        const res = e.response;
        if (res) {
          const statusCode = res.status;
          const isReadableStream = res.config.data instanceof stream.Readable;
          const isAuthErr = statusCode === 401 || statusCode === 403;
          if (!reAuthRetried && isAuthErr && !isReadableStream && this.forceRefreshOnFailure) {
            await this.refreshAccessTokenAsync();
            return await this.requestAsync(opts, true);
          }
        }
        throw e;
      }
      return response;
    }
    async refreshAccessTokenAsync() {
      const refreshResponse = await this.externalAccountAuthorizedUserHandler.refreshToken(this.refreshToken);
      this.cachedAccessToken = {
        access_token: refreshResponse.access_token,
        expiry_date: new Date().getTime() + refreshResponse.expires_in * 1000,
        res: refreshResponse.res
      };
      if (refreshResponse.refresh_token !== undefined) {
        this.refreshToken = refreshResponse.refresh_token;
      }
      return this.cachedAccessToken;
    }
    isExpired(credentials) {
      const now = new Date().getTime();
      return credentials.expiry_date ? now >= credentials.expiry_date - this.eagerRefreshThresholdMillis : false;
    }
  }
  exports.ExternalAccountAuthorizedUserClient = ExternalAccountAuthorizedUserClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/googleauth.js
var require_googleauth = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GoogleAuth = exports.GoogleAuthExceptionMessages = undefined;
  var child_process_1 = __require("child_process");
  var fs6 = __require("fs");
  var gaxios_1 = require_src2();
  var gcpMetadata = require_src4();
  var os2 = __require("os");
  var path4 = __require("path");
  var crypto_1 = require_crypto3();
  var computeclient_1 = require_computeclient();
  var idtokenclient_1 = require_idtokenclient();
  var envDetect_1 = require_envDetect();
  var jwtclient_1 = require_jwtclient();
  var refreshclient_1 = require_refreshclient();
  var impersonated_1 = require_impersonated();
  var externalclient_1 = require_externalclient();
  var baseexternalclient_1 = require_baseexternalclient();
  var authclient_1 = require_authclient();
  var externalAccountAuthorizedUserClient_1 = require_externalAccountAuthorizedUserClient();
  var util_1 = require_util2();
  exports.GoogleAuthExceptionMessages = {
    API_KEY_WITH_CREDENTIALS: "API Keys and Credentials are mutually exclusive authentication methods and cannot be used together.",
    NO_PROJECT_ID_FOUND: `Unable to detect a Project Id in the current environment. 
` + `To learn more about authentication and Google APIs, visit: 
` + "https://cloud.google.com/docs/authentication/getting-started",
    NO_CREDENTIALS_FOUND: `Unable to find credentials in current environment. 
` + `To learn more about authentication and Google APIs, visit: 
` + "https://cloud.google.com/docs/authentication/getting-started",
    NO_ADC_FOUND: "Could not load the default credentials. Browse to https://cloud.google.com/docs/authentication/getting-started for more information.",
    NO_UNIVERSE_DOMAIN_FOUND: `Unable to detect a Universe Domain in the current environment.
` + `To learn more about Universe Domain retrieval, visit: 
` + "https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys"
  };

  class GoogleAuth {
    checkIsGCE = undefined;
    useJWTAccessWithScope;
    defaultServicePath;
    get isGCE() {
      return this.checkIsGCE;
    }
    _findProjectIdPromise;
    _cachedProjectId;
    jsonContent = null;
    apiKey;
    cachedCredential = null;
    #pendingAuthClient = null;
    defaultScopes;
    keyFilename;
    scopes;
    clientOptions = {};
    constructor(opts = {}) {
      this._cachedProjectId = opts.projectId || null;
      this.cachedCredential = opts.authClient || null;
      this.keyFilename = opts.keyFilename || opts.keyFile;
      this.scopes = opts.scopes;
      this.clientOptions = opts.clientOptions || {};
      this.jsonContent = opts.credentials || null;
      this.apiKey = opts.apiKey || this.clientOptions.apiKey || null;
      if (this.apiKey && (this.jsonContent || this.clientOptions.credentials)) {
        throw new RangeError(exports.GoogleAuthExceptionMessages.API_KEY_WITH_CREDENTIALS);
      }
      if (opts.universeDomain) {
        this.clientOptions.universeDomain = opts.universeDomain;
      }
    }
    setGapicJWTValues(client) {
      client.defaultServicePath = this.defaultServicePath;
      client.useJWTAccessWithScope = this.useJWTAccessWithScope;
      client.defaultScopes = this.defaultScopes;
    }
    getProjectId(callback) {
      if (callback) {
        this.getProjectIdAsync().then((r) => callback(null, r), callback);
      } else {
        return this.getProjectIdAsync();
      }
    }
    async getProjectIdOptional() {
      try {
        return await this.getProjectId();
      } catch (e) {
        if (e instanceof Error && e.message === exports.GoogleAuthExceptionMessages.NO_PROJECT_ID_FOUND) {
          return null;
        } else {
          throw e;
        }
      }
    }
    async findAndCacheProjectId() {
      let projectId = null;
      projectId ||= await this.getProductionProjectId();
      projectId ||= await this.getFileProjectId();
      projectId ||= await this.getDefaultServiceProjectId();
      projectId ||= await this.getGCEProjectId();
      projectId ||= await this.getExternalAccountClientProjectId();
      if (projectId) {
        this._cachedProjectId = projectId;
        return projectId;
      } else {
        throw new Error(exports.GoogleAuthExceptionMessages.NO_PROJECT_ID_FOUND);
      }
    }
    async getProjectIdAsync() {
      if (this._cachedProjectId) {
        return this._cachedProjectId;
      }
      if (!this._findProjectIdPromise) {
        this._findProjectIdPromise = this.findAndCacheProjectId();
      }
      return this._findProjectIdPromise;
    }
    async getUniverseDomainFromMetadataServer() {
      let universeDomain;
      try {
        universeDomain = await gcpMetadata.universe("universe-domain");
        universeDomain ||= authclient_1.DEFAULT_UNIVERSE;
      } catch (e) {
        if (e && e?.response?.status === 404) {
          universeDomain = authclient_1.DEFAULT_UNIVERSE;
        } else {
          throw e;
        }
      }
      return universeDomain;
    }
    async getUniverseDomain() {
      let universeDomain = (0, util_1.originalOrCamelOptions)(this.clientOptions).get("universe_domain");
      try {
        universeDomain ??= (await this.getClient()).universeDomain;
      } catch {
        universeDomain ??= authclient_1.DEFAULT_UNIVERSE;
      }
      return universeDomain;
    }
    getAnyScopes() {
      return this.scopes || this.defaultScopes;
    }
    getApplicationDefault(optionsOrCallback = {}, callback) {
      let options;
      if (typeof optionsOrCallback === "function") {
        callback = optionsOrCallback;
      } else {
        options = optionsOrCallback;
      }
      if (callback) {
        this.getApplicationDefaultAsync(options).then((r) => callback(null, r.credential, r.projectId), callback);
      } else {
        return this.getApplicationDefaultAsync(options);
      }
    }
    async getApplicationDefaultAsync(options = {}) {
      if (this.cachedCredential) {
        return await this.#prepareAndCacheClient(this.cachedCredential, null);
      }
      let credential;
      credential = await this._tryGetApplicationCredentialsFromEnvironmentVariable(options);
      if (credential) {
        if (credential instanceof jwtclient_1.JWT) {
          credential.scopes = this.scopes;
        } else if (credential instanceof baseexternalclient_1.BaseExternalAccountClient) {
          credential.scopes = this.getAnyScopes();
        }
        return await this.#prepareAndCacheClient(credential);
      }
      credential = await this._tryGetApplicationCredentialsFromWellKnownFile(options);
      if (credential) {
        if (credential instanceof jwtclient_1.JWT) {
          credential.scopes = this.scopes;
        } else if (credential instanceof baseexternalclient_1.BaseExternalAccountClient) {
          credential.scopes = this.getAnyScopes();
        }
        return await this.#prepareAndCacheClient(credential);
      }
      if (await this._checkIsGCE()) {
        options.scopes = this.getAnyScopes();
        return await this.#prepareAndCacheClient(new computeclient_1.Compute(options));
      }
      throw new Error(exports.GoogleAuthExceptionMessages.NO_ADC_FOUND);
    }
    async#prepareAndCacheClient(credential, quotaProjectIdOverride = process.env["GOOGLE_CLOUD_QUOTA_PROJECT"] || null) {
      const projectId = await this.getProjectIdOptional();
      if (quotaProjectIdOverride) {
        credential.quotaProjectId = quotaProjectIdOverride;
      }
      this.cachedCredential = credential;
      return { credential, projectId };
    }
    async _checkIsGCE() {
      if (this.checkIsGCE === undefined) {
        this.checkIsGCE = gcpMetadata.getGCPResidency() || await gcpMetadata.isAvailable();
      }
      return this.checkIsGCE;
    }
    async _tryGetApplicationCredentialsFromEnvironmentVariable(options) {
      const credentialsPath = process.env["GOOGLE_APPLICATION_CREDENTIALS"] || process.env["google_application_credentials"];
      if (!credentialsPath || credentialsPath.length === 0) {
        return null;
      }
      try {
        return this._getApplicationCredentialsFromFilePath(credentialsPath, options);
      } catch (e) {
        if (e instanceof Error) {
          e.message = `Unable to read the credential file specified by the GOOGLE_APPLICATION_CREDENTIALS environment variable: ${e.message}`;
        }
        throw e;
      }
    }
    async _tryGetApplicationCredentialsFromWellKnownFile(options) {
      let location = null;
      if (this._isWindows()) {
        location = process.env["APPDATA"];
      } else {
        const home2 = process.env["HOME"];
        if (home2) {
          location = path4.join(home2, ".config");
        }
      }
      if (location) {
        location = path4.join(location, "gcloud", "application_default_credentials.json");
        if (!fs6.existsSync(location)) {
          location = null;
        }
      }
      if (!location) {
        return null;
      }
      const client = await this._getApplicationCredentialsFromFilePath(location, options);
      return client;
    }
    async _getApplicationCredentialsFromFilePath(filePath, options = {}) {
      if (!filePath || filePath.length === 0) {
        throw new Error("The file path is invalid.");
      }
      try {
        filePath = fs6.realpathSync(filePath);
        if (!fs6.lstatSync(filePath).isFile()) {
          throw new Error;
        }
      } catch (err) {
        if (err instanceof Error) {
          err.message = `The file at ${filePath} does not exist, or it is not a file. ${err.message}`;
        }
        throw err;
      }
      const readStream = fs6.createReadStream(filePath);
      return this.fromStream(readStream, options);
    }
    fromImpersonatedJSON(json) {
      if (!json) {
        throw new Error("Must pass in a JSON object containing an  impersonated refresh token");
      }
      if (json.type !== impersonated_1.IMPERSONATED_ACCOUNT_TYPE) {
        throw new Error(`The incoming JSON object does not have the "${impersonated_1.IMPERSONATED_ACCOUNT_TYPE}" type`);
      }
      if (!json.source_credentials) {
        throw new Error("The incoming JSON object does not contain a source_credentials field");
      }
      if (!json.service_account_impersonation_url) {
        throw new Error("The incoming JSON object does not contain a service_account_impersonation_url field");
      }
      const sourceClient = this.fromJSON(json.source_credentials);
      if (json.service_account_impersonation_url?.length > 256) {
        throw new RangeError(`Target principal is too long: ${json.service_account_impersonation_url}`);
      }
      const targetPrincipal = /(?<target>[^/]+):(generateAccessToken|generateIdToken)$/.exec(json.service_account_impersonation_url)?.groups?.target;
      if (!targetPrincipal) {
        throw new RangeError(`Cannot extract target principal from ${json.service_account_impersonation_url}`);
      }
      const targetScopes = (this.scopes || json.scopes || this.defaultScopes) ?? [];
      return new impersonated_1.Impersonated({
        ...json,
        sourceClient,
        targetPrincipal,
        targetScopes: Array.isArray(targetScopes) ? targetScopes : [targetScopes]
      });
    }
    fromJSON(json, options = {}) {
      let client;
      const preferredUniverseDomain = (0, util_1.originalOrCamelOptions)(options).get("universe_domain");
      if (json.type === refreshclient_1.USER_REFRESH_ACCOUNT_TYPE) {
        client = new refreshclient_1.UserRefreshClient(options);
        client.fromJSON(json);
      } else if (json.type === impersonated_1.IMPERSONATED_ACCOUNT_TYPE) {
        client = this.fromImpersonatedJSON(json);
      } else if (json.type === baseexternalclient_1.EXTERNAL_ACCOUNT_TYPE) {
        client = externalclient_1.ExternalAccountClient.fromJSON({
          ...json,
          ...options
        });
        client.scopes = this.getAnyScopes();
      } else if (json.type === externalAccountAuthorizedUserClient_1.EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE) {
        client = new externalAccountAuthorizedUserClient_1.ExternalAccountAuthorizedUserClient({
          ...json,
          ...options
        });
      } else {
        options.scopes = this.scopes;
        client = new jwtclient_1.JWT(options);
        this.setGapicJWTValues(client);
        client.fromJSON(json);
      }
      if (preferredUniverseDomain) {
        client.universeDomain = preferredUniverseDomain;
      }
      return client;
    }
    _cacheClientFromJSON(json, options) {
      const client = this.fromJSON(json, options);
      this.jsonContent = json;
      this.cachedCredential = client;
      return client;
    }
    fromStream(inputStream, optionsOrCallback = {}, callback) {
      let options = {};
      if (typeof optionsOrCallback === "function") {
        callback = optionsOrCallback;
      } else {
        options = optionsOrCallback;
      }
      if (callback) {
        this.fromStreamAsync(inputStream, options).then((r) => callback(null, r), callback);
      } else {
        return this.fromStreamAsync(inputStream, options);
      }
    }
    fromStreamAsync(inputStream, options) {
      return new Promise((resolve3, reject) => {
        if (!inputStream) {
          throw new Error("Must pass in a stream containing the Google auth settings.");
        }
        const chunks = [];
        inputStream.setEncoding("utf8").on("error", reject).on("data", (chunk) => chunks.push(chunk)).on("end", () => {
          try {
            try {
              const data = JSON.parse(chunks.join(""));
              const r = this._cacheClientFromJSON(data, options);
              return resolve3(r);
            } catch (err) {
              if (!this.keyFilename)
                throw err;
              const client = new jwtclient_1.JWT({
                ...this.clientOptions,
                keyFile: this.keyFilename
              });
              this.cachedCredential = client;
              this.setGapicJWTValues(client);
              return resolve3(client);
            }
          } catch (err) {
            return reject(err);
          }
        });
      });
    }
    fromAPIKey(apiKey, options = {}) {
      return new jwtclient_1.JWT({ ...options, apiKey });
    }
    _isWindows() {
      const sys = os2.platform();
      if (sys && sys.length >= 3) {
        if (sys.substring(0, 3).toLowerCase() === "win") {
          return true;
        }
      }
      return false;
    }
    async getDefaultServiceProjectId() {
      return new Promise((resolve3) => {
        (0, child_process_1.exec)("gcloud config config-helper --format json", (err, stdout) => {
          if (!err && stdout) {
            try {
              const projectId = JSON.parse(stdout).configuration.properties.core.project;
              resolve3(projectId);
              return;
            } catch (e) {}
          }
          resolve3(null);
        });
      });
    }
    getProductionProjectId() {
      return process.env["GCLOUD_PROJECT"] || process.env["GOOGLE_CLOUD_PROJECT"] || process.env["gcloud_project"] || process.env["google_cloud_project"];
    }
    async getFileProjectId() {
      if (this.cachedCredential) {
        return this.cachedCredential.projectId;
      }
      if (this.keyFilename) {
        const creds = await this.getClient();
        if (creds && creds.projectId) {
          return creds.projectId;
        }
      }
      const r = await this._tryGetApplicationCredentialsFromEnvironmentVariable();
      if (r) {
        return r.projectId;
      } else {
        return null;
      }
    }
    async getExternalAccountClientProjectId() {
      if (!this.jsonContent || this.jsonContent.type !== baseexternalclient_1.EXTERNAL_ACCOUNT_TYPE) {
        return null;
      }
      const creds = await this.getClient();
      return await creds.getProjectId();
    }
    async getGCEProjectId() {
      try {
        const r = await gcpMetadata.project("project-id");
        return r;
      } catch (e) {
        return null;
      }
    }
    getCredentials(callback) {
      if (callback) {
        this.getCredentialsAsync().then((r) => callback(null, r), callback);
      } else {
        return this.getCredentialsAsync();
      }
    }
    async getCredentialsAsync() {
      const client = await this.getClient();
      if (client instanceof impersonated_1.Impersonated) {
        return { client_email: client.getTargetPrincipal() };
      }
      if (client instanceof baseexternalclient_1.BaseExternalAccountClient) {
        const serviceAccountEmail = client.getServiceAccountEmail();
        if (serviceAccountEmail) {
          return {
            client_email: serviceAccountEmail,
            universe_domain: client.universeDomain
          };
        }
      }
      if (this.jsonContent) {
        return {
          client_email: this.jsonContent.client_email,
          private_key: this.jsonContent.private_key,
          universe_domain: this.jsonContent.universe_domain
        };
      }
      if (await this._checkIsGCE()) {
        const [client_email, universe_domain] = await Promise.all([
          gcpMetadata.instance("service-accounts/default/email"),
          this.getUniverseDomain()
        ]);
        return { client_email, universe_domain };
      }
      throw new Error(exports.GoogleAuthExceptionMessages.NO_CREDENTIALS_FOUND);
    }
    async getClient() {
      if (this.cachedCredential) {
        return this.cachedCredential;
      }
      this.#pendingAuthClient = this.#pendingAuthClient || this.#determineClient();
      try {
        return await this.#pendingAuthClient;
      } finally {
        this.#pendingAuthClient = null;
      }
    }
    async#determineClient() {
      if (this.jsonContent) {
        return this._cacheClientFromJSON(this.jsonContent, this.clientOptions);
      } else if (this.keyFilename) {
        const filePath = path4.resolve(this.keyFilename);
        const stream = fs6.createReadStream(filePath);
        return await this.fromStreamAsync(stream, this.clientOptions);
      } else if (this.apiKey) {
        const client = await this.fromAPIKey(this.apiKey, this.clientOptions);
        client.scopes = this.scopes;
        const { credential } = await this.#prepareAndCacheClient(client);
        return credential;
      } else {
        const { credential } = await this.getApplicationDefaultAsync(this.clientOptions);
        return credential;
      }
    }
    async getIdTokenClient(targetAudience) {
      const client = await this.getClient();
      if (!("fetchIdToken" in client)) {
        throw new Error("Cannot fetch ID token in this environment, use GCE or set the GOOGLE_APPLICATION_CREDENTIALS environment variable to a service account credentials JSON file.");
      }
      return new idtokenclient_1.IdTokenClient({ targetAudience, idTokenProvider: client });
    }
    async getAccessToken() {
      const client = await this.getClient();
      return (await client.getAccessToken()).token;
    }
    async getRequestHeaders(url) {
      const client = await this.getClient();
      return client.getRequestHeaders(url);
    }
    async authorizeRequest(opts = {}) {
      const url = opts.url;
      const client = await this.getClient();
      const headers = await client.getRequestHeaders(url);
      opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers, headers);
      return opts;
    }
    async fetch(...args) {
      const client = await this.getClient();
      return client.fetch(...args);
    }
    async request(opts) {
      const client = await this.getClient();
      return client.request(opts);
    }
    getEnv() {
      return (0, envDetect_1.getEnv)();
    }
    async sign(data, endpoint) {
      const client = await this.getClient();
      const universe = await this.getUniverseDomain();
      endpoint = endpoint || `https://iamcredentials.${universe}/v1/projects/-/serviceAccounts/`;
      if (client instanceof impersonated_1.Impersonated) {
        const signed = await client.sign(data);
        return signed.signedBlob;
      }
      const crypto3 = (0, crypto_1.createCrypto)();
      if (client instanceof jwtclient_1.JWT && client.key) {
        const sign = await crypto3.sign(client.key, data);
        return sign;
      }
      const creds = await this.getCredentials();
      if (!creds.client_email) {
        throw new Error("Cannot sign data without `client_email`.");
      }
      return this.signBlob(crypto3, creds.client_email, data, endpoint);
    }
    async signBlob(crypto3, emailOrUniqueId, data, endpoint) {
      const url = new URL(endpoint + `${emailOrUniqueId}:signBlob`);
      const res = await this.request({
        method: "POST",
        url: url.href,
        data: {
          payload: crypto3.encodeBase64StringUtf8(data)
        },
        retry: true,
        retryConfig: {
          httpMethodsToRetry: ["POST"]
        }
      });
      return res.data.signedBlob;
    }
  }
  exports.GoogleAuth = GoogleAuth;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/iam.js
var require_iam = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.IAMAuth = undefined;

  class IAMAuth {
    selector;
    token;
    constructor(selector, token) {
      this.selector = selector;
      this.token = token;
      this.selector = selector;
      this.token = token;
    }
    getRequestHeaders() {
      return {
        "x-goog-iam-authority-selector": this.selector,
        "x-goog-iam-authorization-token": this.token
      };
    }
  }
  exports.IAMAuth = IAMAuth;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/downscopedclient.js
var require_downscopedclient = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.DownscopedClient = exports.EXPIRATION_TIME_OFFSET = exports.MAX_ACCESS_BOUNDARY_RULES_COUNT = undefined;
  var gaxios_1 = require_src2();
  var stream = __require("stream");
  var authclient_1 = require_authclient();
  var sts = require_stscredentials();
  var STS_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
  var STS_REQUEST_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
  var STS_SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
  exports.MAX_ACCESS_BOUNDARY_RULES_COUNT = 10;
  exports.EXPIRATION_TIME_OFFSET = 5 * 60 * 1000;

  class DownscopedClient extends authclient_1.AuthClient {
    authClient;
    credentialAccessBoundary;
    cachedDownscopedAccessToken;
    stsCredential;
    constructor(options, credentialAccessBoundary = {
      accessBoundary: {
        accessBoundaryRules: []
      }
    }) {
      super(options instanceof authclient_1.AuthClient ? {} : options);
      if (options instanceof authclient_1.AuthClient) {
        this.authClient = options;
        this.credentialAccessBoundary = credentialAccessBoundary;
      } else {
        this.authClient = options.authClient;
        this.credentialAccessBoundary = options.credentialAccessBoundary;
      }
      if (this.credentialAccessBoundary.accessBoundary.accessBoundaryRules.length === 0) {
        throw new Error("At least one access boundary rule needs to be defined.");
      } else if (this.credentialAccessBoundary.accessBoundary.accessBoundaryRules.length > exports.MAX_ACCESS_BOUNDARY_RULES_COUNT) {
        throw new Error("The provided access boundary has more than " + `${exports.MAX_ACCESS_BOUNDARY_RULES_COUNT} access boundary rules.`);
      }
      for (const rule of this.credentialAccessBoundary.accessBoundary.accessBoundaryRules) {
        if (rule.availablePermissions.length === 0) {
          throw new Error("At least one permission should be defined in access boundary rules.");
        }
      }
      this.stsCredential = new sts.StsCredentials({
        tokenExchangeEndpoint: `https://sts.${this.universeDomain}/v1/token`
      });
      this.cachedDownscopedAccessToken = null;
    }
    setCredentials(credentials) {
      if (!credentials.expiry_date) {
        throw new Error("The access token expiry_date field is missing in the provided " + "credentials.");
      }
      super.setCredentials(credentials);
      this.cachedDownscopedAccessToken = credentials;
    }
    async getAccessToken() {
      if (!this.cachedDownscopedAccessToken || this.isExpired(this.cachedDownscopedAccessToken)) {
        await this.refreshAccessTokenAsync();
      }
      return {
        token: this.cachedDownscopedAccessToken.access_token,
        expirationTime: this.cachedDownscopedAccessToken.expiry_date,
        res: this.cachedDownscopedAccessToken.res
      };
    }
    async getRequestHeaders() {
      const accessTokenResponse = await this.getAccessToken();
      const headers = new Headers({
        authorization: `Bearer ${accessTokenResponse.token}`
      });
      return this.addSharedMetadataHeaders(headers);
    }
    request(opts, callback) {
      if (callback) {
        this.requestAsync(opts).then((r) => callback(null, r), (e) => {
          return callback(e, e.response);
        });
      } else {
        return this.requestAsync(opts);
      }
    }
    async requestAsync(opts, reAuthRetried = false) {
      let response;
      try {
        const requestHeaders = await this.getRequestHeaders();
        opts.headers = gaxios_1.Gaxios.mergeHeaders(opts.headers);
        this.addUserProjectAndAuthHeaders(opts.headers, requestHeaders);
        response = await this.transporter.request(opts);
      } catch (e) {
        const res = e.response;
        if (res) {
          const statusCode = res.status;
          const isReadableStream = res.config.data instanceof stream.Readable;
          const isAuthErr = statusCode === 401 || statusCode === 403;
          if (!reAuthRetried && isAuthErr && !isReadableStream && this.forceRefreshOnFailure) {
            await this.refreshAccessTokenAsync();
            return await this.requestAsync(opts, true);
          }
        }
        throw e;
      }
      return response;
    }
    async refreshAccessTokenAsync() {
      const subjectToken = (await this.authClient.getAccessToken()).token;
      const stsCredentialsOptions = {
        grantType: STS_GRANT_TYPE,
        requestedTokenType: STS_REQUEST_TOKEN_TYPE,
        subjectToken,
        subjectTokenType: STS_SUBJECT_TOKEN_TYPE
      };
      const stsResponse = await this.stsCredential.exchangeToken(stsCredentialsOptions, undefined, this.credentialAccessBoundary);
      const sourceCredExpireDate = this.authClient.credentials?.expiry_date || null;
      const expiryDate = stsResponse.expires_in ? new Date().getTime() + stsResponse.expires_in * 1000 : sourceCredExpireDate;
      this.cachedDownscopedAccessToken = {
        access_token: stsResponse.access_token,
        expiry_date: expiryDate,
        res: stsResponse.res
      };
      this.credentials = {};
      Object.assign(this.credentials, this.cachedDownscopedAccessToken);
      delete this.credentials.res;
      this.emit("tokens", {
        refresh_token: null,
        expiry_date: this.cachedDownscopedAccessToken.expiry_date,
        access_token: this.cachedDownscopedAccessToken.access_token,
        token_type: "Bearer",
        id_token: null
      });
      return this.cachedDownscopedAccessToken;
    }
    isExpired(downscopedAccessToken) {
      const now = new Date().getTime();
      return downscopedAccessToken.expiry_date ? now >= downscopedAccessToken.expiry_date - this.eagerRefreshThresholdMillis : false;
    }
  }
  exports.DownscopedClient = DownscopedClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/auth/passthrough.js
var require_passthrough = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.PassThroughClient = undefined;
  var authclient_1 = require_authclient();

  class PassThroughClient extends authclient_1.AuthClient {
    async request(opts) {
      return this.transporter.request(opts);
    }
    async getAccessToken() {
      return {};
    }
    async getRequestHeaders() {
      return new Headers;
    }
  }
  exports.PassThroughClient = PassThroughClient;
});

// ../node_modules/.bun/google-auth-library@10.5.0/node_modules/google-auth-library/build/src/index.js
var require_src6 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.GoogleAuth = exports.auth = exports.PassThroughClient = exports.ExternalAccountAuthorizedUserClient = exports.EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE = exports.ExecutableError = exports.PluggableAuthClient = exports.DownscopedClient = exports.BaseExternalAccountClient = exports.ExternalAccountClient = exports.IdentityPoolClient = exports.AwsRequestSigner = exports.AwsClient = exports.UserRefreshClient = exports.LoginTicket = exports.ClientAuthentication = exports.OAuth2Client = exports.CodeChallengeMethod = exports.Impersonated = exports.JWT = exports.JWTAccess = exports.IdTokenClient = exports.IAMAuth = exports.GCPEnv = exports.Compute = exports.DEFAULT_UNIVERSE = exports.AuthClient = exports.gaxios = exports.gcpMetadata = undefined;
  var googleauth_1 = require_googleauth();
  Object.defineProperty(exports, "GoogleAuth", { enumerable: true, get: function() {
    return googleauth_1.GoogleAuth;
  } });
  exports.gcpMetadata = require_src4();
  exports.gaxios = require_src2();
  var authclient_1 = require_authclient();
  Object.defineProperty(exports, "AuthClient", { enumerable: true, get: function() {
    return authclient_1.AuthClient;
  } });
  Object.defineProperty(exports, "DEFAULT_UNIVERSE", { enumerable: true, get: function() {
    return authclient_1.DEFAULT_UNIVERSE;
  } });
  var computeclient_1 = require_computeclient();
  Object.defineProperty(exports, "Compute", { enumerable: true, get: function() {
    return computeclient_1.Compute;
  } });
  var envDetect_1 = require_envDetect();
  Object.defineProperty(exports, "GCPEnv", { enumerable: true, get: function() {
    return envDetect_1.GCPEnv;
  } });
  var iam_1 = require_iam();
  Object.defineProperty(exports, "IAMAuth", { enumerable: true, get: function() {
    return iam_1.IAMAuth;
  } });
  var idtokenclient_1 = require_idtokenclient();
  Object.defineProperty(exports, "IdTokenClient", { enumerable: true, get: function() {
    return idtokenclient_1.IdTokenClient;
  } });
  var jwtaccess_1 = require_jwtaccess();
  Object.defineProperty(exports, "JWTAccess", { enumerable: true, get: function() {
    return jwtaccess_1.JWTAccess;
  } });
  var jwtclient_1 = require_jwtclient();
  Object.defineProperty(exports, "JWT", { enumerable: true, get: function() {
    return jwtclient_1.JWT;
  } });
  var impersonated_1 = require_impersonated();
  Object.defineProperty(exports, "Impersonated", { enumerable: true, get: function() {
    return impersonated_1.Impersonated;
  } });
  var oauth2client_1 = require_oauth2client();
  Object.defineProperty(exports, "CodeChallengeMethod", { enumerable: true, get: function() {
    return oauth2client_1.CodeChallengeMethod;
  } });
  Object.defineProperty(exports, "OAuth2Client", { enumerable: true, get: function() {
    return oauth2client_1.OAuth2Client;
  } });
  Object.defineProperty(exports, "ClientAuthentication", { enumerable: true, get: function() {
    return oauth2client_1.ClientAuthentication;
  } });
  var loginticket_1 = require_loginticket();
  Object.defineProperty(exports, "LoginTicket", { enumerable: true, get: function() {
    return loginticket_1.LoginTicket;
  } });
  var refreshclient_1 = require_refreshclient();
  Object.defineProperty(exports, "UserRefreshClient", { enumerable: true, get: function() {
    return refreshclient_1.UserRefreshClient;
  } });
  var awsclient_1 = require_awsclient();
  Object.defineProperty(exports, "AwsClient", { enumerable: true, get: function() {
    return awsclient_1.AwsClient;
  } });
  var awsrequestsigner_1 = require_awsrequestsigner();
  Object.defineProperty(exports, "AwsRequestSigner", { enumerable: true, get: function() {
    return awsrequestsigner_1.AwsRequestSigner;
  } });
  var identitypoolclient_1 = require_identitypoolclient();
  Object.defineProperty(exports, "IdentityPoolClient", { enumerable: true, get: function() {
    return identitypoolclient_1.IdentityPoolClient;
  } });
  var externalclient_1 = require_externalclient();
  Object.defineProperty(exports, "ExternalAccountClient", { enumerable: true, get: function() {
    return externalclient_1.ExternalAccountClient;
  } });
  var baseexternalclient_1 = require_baseexternalclient();
  Object.defineProperty(exports, "BaseExternalAccountClient", { enumerable: true, get: function() {
    return baseexternalclient_1.BaseExternalAccountClient;
  } });
  var downscopedclient_1 = require_downscopedclient();
  Object.defineProperty(exports, "DownscopedClient", { enumerable: true, get: function() {
    return downscopedclient_1.DownscopedClient;
  } });
  var pluggable_auth_client_1 = require_pluggable_auth_client();
  Object.defineProperty(exports, "PluggableAuthClient", { enumerable: true, get: function() {
    return pluggable_auth_client_1.PluggableAuthClient;
  } });
  Object.defineProperty(exports, "ExecutableError", { enumerable: true, get: function() {
    return pluggable_auth_client_1.ExecutableError;
  } });
  var externalAccountAuthorizedUserClient_1 = require_externalAccountAuthorizedUserClient();
  Object.defineProperty(exports, "EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE", { enumerable: true, get: function() {
    return externalAccountAuthorizedUserClient_1.EXTERNAL_ACCOUNT_AUTHORIZED_USER_TYPE;
  } });
  Object.defineProperty(exports, "ExternalAccountAuthorizedUserClient", { enumerable: true, get: function() {
    return externalAccountAuthorizedUserClient_1.ExternalAccountAuthorizedUserClient;
  } });
  var passthrough_1 = require_passthrough();
  Object.defineProperty(exports, "PassThroughClient", { enumerable: true, get: function() {
    return passthrough_1.PassThroughClient;
  } });
  var auth = new googleauth_1.GoogleAuth;
  exports.auth = auth;
});

// ../node_modules/.bun/@smithy+types@4.12.0/node_modules/@smithy/types/dist-cjs/index.js
var require_dist_cjs = __commonJS((exports) => {
  exports.HttpAuthLocation = undefined;
  (function(HttpAuthLocation) {
    HttpAuthLocation["HEADER"] = "header";
    HttpAuthLocation["QUERY"] = "query";
  })(exports.HttpAuthLocation || (exports.HttpAuthLocation = {}));
  exports.HttpApiKeyAuthLocation = undefined;
  (function(HttpApiKeyAuthLocation) {
    HttpApiKeyAuthLocation["HEADER"] = "header";
    HttpApiKeyAuthLocation["QUERY"] = "query";
  })(exports.HttpApiKeyAuthLocation || (exports.HttpApiKeyAuthLocation = {}));
  exports.EndpointURLScheme = undefined;
  (function(EndpointURLScheme) {
    EndpointURLScheme["HTTP"] = "http";
    EndpointURLScheme["HTTPS"] = "https";
  })(exports.EndpointURLScheme || (exports.EndpointURLScheme = {}));
  exports.AlgorithmId = undefined;
  (function(AlgorithmId) {
    AlgorithmId["MD5"] = "md5";
    AlgorithmId["CRC32"] = "crc32";
    AlgorithmId["CRC32C"] = "crc32c";
    AlgorithmId["SHA1"] = "sha1";
    AlgorithmId["SHA256"] = "sha256";
  })(exports.AlgorithmId || (exports.AlgorithmId = {}));
  var getChecksumConfiguration = (runtimeConfig) => {
    const checksumAlgorithms = [];
    if (runtimeConfig.sha256 !== undefined) {
      checksumAlgorithms.push({
        algorithmId: () => exports.AlgorithmId.SHA256,
        checksumConstructor: () => runtimeConfig.sha256
      });
    }
    if (runtimeConfig.md5 != null) {
      checksumAlgorithms.push({
        algorithmId: () => exports.AlgorithmId.MD5,
        checksumConstructor: () => runtimeConfig.md5
      });
    }
    return {
      addChecksumAlgorithm(algo) {
        checksumAlgorithms.push(algo);
      },
      checksumAlgorithms() {
        return checksumAlgorithms;
      }
    };
  };
  var resolveChecksumRuntimeConfig = (clientConfig) => {
    const runtimeConfig = {};
    clientConfig.checksumAlgorithms().forEach((checksumAlgorithm) => {
      runtimeConfig[checksumAlgorithm.algorithmId()] = checksumAlgorithm.checksumConstructor();
    });
    return runtimeConfig;
  };
  var getDefaultClientConfiguration = (runtimeConfig) => {
    return getChecksumConfiguration(runtimeConfig);
  };
  var resolveDefaultRuntimeConfig = (config) => {
    return resolveChecksumRuntimeConfig(config);
  };
  exports.FieldPosition = undefined;
  (function(FieldPosition) {
    FieldPosition[FieldPosition["HEADER"] = 0] = "HEADER";
    FieldPosition[FieldPosition["TRAILER"] = 1] = "TRAILER";
  })(exports.FieldPosition || (exports.FieldPosition = {}));
  var SMITHY_CONTEXT_KEY = "__smithy_context";
  exports.IniSectionType = undefined;
  (function(IniSectionType) {
    IniSectionType["PROFILE"] = "profile";
    IniSectionType["SSO_SESSION"] = "sso-session";
    IniSectionType["SERVICES"] = "services";
  })(exports.IniSectionType || (exports.IniSectionType = {}));
  exports.RequestHandlerProtocol = undefined;
  (function(RequestHandlerProtocol) {
    RequestHandlerProtocol["HTTP_0_9"] = "http/0.9";
    RequestHandlerProtocol["HTTP_1_0"] = "http/1.0";
    RequestHandlerProtocol["TDS_8_0"] = "tds/8.0";
  })(exports.RequestHandlerProtocol || (exports.RequestHandlerProtocol = {}));
  exports.SMITHY_CONTEXT_KEY = SMITHY_CONTEXT_KEY;
  exports.getDefaultClientConfiguration = getDefaultClientConfiguration;
  exports.resolveDefaultRuntimeConfig = resolveDefaultRuntimeConfig;
});

// ../node_modules/.bun/@smithy+protocol-http@5.3.8/node_modules/@smithy/protocol-http/dist-cjs/index.js
var require_dist_cjs2 = __commonJS((exports) => {
  var types = require_dist_cjs();
  var getHttpHandlerExtensionConfiguration = (runtimeConfig) => {
    return {
      setHttpHandler(handler) {
        runtimeConfig.httpHandler = handler;
      },
      httpHandler() {
        return runtimeConfig.httpHandler;
      },
      updateHttpClientConfig(key, value) {
        runtimeConfig.httpHandler?.updateHttpClientConfig(key, value);
      },
      httpHandlerConfigs() {
        return runtimeConfig.httpHandler.httpHandlerConfigs();
      }
    };
  };
  var resolveHttpHandlerRuntimeConfig = (httpHandlerExtensionConfiguration) => {
    return {
      httpHandler: httpHandlerExtensionConfiguration.httpHandler()
    };
  };

  class Field {
    name;
    kind;
    values;
    constructor({ name, kind = types.FieldPosition.HEADER, values: values2 = [] }) {
      this.name = name;
      this.kind = kind;
      this.values = values2;
    }
    add(value) {
      this.values.push(value);
    }
    set(values2) {
      this.values = values2;
    }
    remove(value) {
      this.values = this.values.filter((v) => v !== value);
    }
    toString() {
      return this.values.map((v) => v.includes(",") || v.includes(" ") ? `"${v}"` : v).join(", ");
    }
    get() {
      return this.values;
    }
  }

  class Fields {
    entries = {};
    encoding;
    constructor({ fields = [], encoding = "utf-8" }) {
      fields.forEach(this.setField.bind(this));
      this.encoding = encoding;
    }
    setField(field) {
      this.entries[field.name.toLowerCase()] = field;
    }
    getField(name) {
      return this.entries[name.toLowerCase()];
    }
    removeField(name) {
      delete this.entries[name.toLowerCase()];
    }
    getByType(kind) {
      return Object.values(this.entries).filter((field) => field.kind === kind);
    }
  }

  class HttpRequest {
    method;
    protocol;
    hostname;
    port;
    path;
    query;
    headers;
    username;
    password;
    fragment;
    body;
    constructor(options) {
      this.method = options.method || "GET";
      this.hostname = options.hostname || "localhost";
      this.port = options.port;
      this.query = options.query || {};
      this.headers = options.headers || {};
      this.body = options.body;
      this.protocol = options.protocol ? options.protocol.slice(-1) !== ":" ? `${options.protocol}:` : options.protocol : "https:";
      this.path = options.path ? options.path.charAt(0) !== "/" ? `/${options.path}` : options.path : "/";
      this.username = options.username;
      this.password = options.password;
      this.fragment = options.fragment;
    }
    static clone(request) {
      const cloned = new HttpRequest({
        ...request,
        headers: { ...request.headers }
      });
      if (cloned.query) {
        cloned.query = cloneQuery(cloned.query);
      }
      return cloned;
    }
    static isInstance(request) {
      if (!request) {
        return false;
      }
      const req = request;
      return "method" in req && "protocol" in req && "hostname" in req && "path" in req && typeof req["query"] === "object" && typeof req["headers"] === "object";
    }
    clone() {
      return HttpRequest.clone(this);
    }
  }
  function cloneQuery(query) {
    return Object.keys(query).reduce((carry, paramName) => {
      const param = query[paramName];
      return {
        ...carry,
        [paramName]: Array.isArray(param) ? [...param] : param
      };
    }, {});
  }

  class HttpResponse2 {
    statusCode;
    reason;
    headers;
    body;
    constructor(options) {
      this.statusCode = options.statusCode;
      this.reason = options.reason;
      this.headers = options.headers || {};
      this.body = options.body;
    }
    static isInstance(response) {
      if (!response)
        return false;
      const resp = response;
      return typeof resp.statusCode === "number" && typeof resp.headers === "object";
    }
  }
  function isValidHostname(hostname) {
    const hostPattern = /^[a-z0-9][a-z0-9\.\-]*[a-z0-9]$/;
    return hostPattern.test(hostname);
  }
  exports.Field = Field;
  exports.Fields = Fields;
  exports.HttpRequest = HttpRequest;
  exports.HttpResponse = HttpResponse2;
  exports.getHttpHandlerExtensionConfiguration = getHttpHandlerExtensionConfiguration;
  exports.isValidHostname = isValidHostname;
  exports.resolveHttpHandlerRuntimeConfig = resolveHttpHandlerRuntimeConfig;
});

// ../node_modules/.bun/@aws-sdk+middleware-host-header@3.972.3/node_modules/@aws-sdk/middleware-host-header/dist-cjs/index.js
var require_dist_cjs3 = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  function resolveHostHeaderConfig(input) {
    return input;
  }
  var hostHeaderMiddleware = (options) => (next) => async (args) => {
    if (!protocolHttp.HttpRequest.isInstance(args.request))
      return next(args);
    const { request } = args;
    const { handlerProtocol = "" } = options.requestHandler.metadata || {};
    if (handlerProtocol.indexOf("h2") >= 0 && !request.headers[":authority"]) {
      delete request.headers["host"];
      request.headers[":authority"] = request.hostname + (request.port ? ":" + request.port : "");
    } else if (!request.headers["host"]) {
      let host = request.hostname;
      if (request.port != null)
        host += `:${request.port}`;
      request.headers["host"] = host;
    }
    return next(args);
  };
  var hostHeaderMiddlewareOptions = {
    name: "hostHeaderMiddleware",
    step: "build",
    priority: "low",
    tags: ["HOST"],
    override: true
  };
  var getHostHeaderPlugin = (options) => ({
    applyToStack: (clientStack) => {
      clientStack.add(hostHeaderMiddleware(options), hostHeaderMiddlewareOptions);
    }
  });
  exports.getHostHeaderPlugin = getHostHeaderPlugin;
  exports.hostHeaderMiddleware = hostHeaderMiddleware;
  exports.hostHeaderMiddlewareOptions = hostHeaderMiddlewareOptions;
  exports.resolveHostHeaderConfig = resolveHostHeaderConfig;
});

// ../node_modules/.bun/@aws-sdk+middleware-logger@3.972.3/node_modules/@aws-sdk/middleware-logger/dist-cjs/index.js
var require_dist_cjs4 = __commonJS((exports) => {
  var loggerMiddleware = () => (next, context) => async (args) => {
    try {
      const response = await next(args);
      const { clientName, commandName, logger, dynamoDbDocumentClientOptions = {} } = context;
      const { overrideInputFilterSensitiveLog, overrideOutputFilterSensitiveLog } = dynamoDbDocumentClientOptions;
      const inputFilterSensitiveLog = overrideInputFilterSensitiveLog ?? context.inputFilterSensitiveLog;
      const outputFilterSensitiveLog = overrideOutputFilterSensitiveLog ?? context.outputFilterSensitiveLog;
      const { $metadata, ...outputWithoutMetadata } = response.output;
      logger?.info?.({
        clientName,
        commandName,
        input: inputFilterSensitiveLog(args.input),
        output: outputFilterSensitiveLog(outputWithoutMetadata),
        metadata: $metadata
      });
      return response;
    } catch (error3) {
      const { clientName, commandName, logger, dynamoDbDocumentClientOptions = {} } = context;
      const { overrideInputFilterSensitiveLog } = dynamoDbDocumentClientOptions;
      const inputFilterSensitiveLog = overrideInputFilterSensitiveLog ?? context.inputFilterSensitiveLog;
      logger?.error?.({
        clientName,
        commandName,
        input: inputFilterSensitiveLog(args.input),
        error: error3,
        metadata: error3.$metadata
      });
      throw error3;
    }
  };
  var loggerMiddlewareOptions = {
    name: "loggerMiddleware",
    tags: ["LOGGER"],
    step: "initialize",
    override: true
  };
  var getLoggerPlugin = (options) => ({
    applyToStack: (clientStack) => {
      clientStack.add(loggerMiddleware(), loggerMiddlewareOptions);
    }
  });
  exports.getLoggerPlugin = getLoggerPlugin;
  exports.loggerMiddleware = loggerMiddleware;
  exports.loggerMiddlewareOptions = loggerMiddlewareOptions;
});

// ../node_modules/.bun/@aws+lambda-invoke-store@0.2.3/node_modules/@aws/lambda-invoke-store/dist-cjs/invoke-store.js
var require_invoke_store = __commonJS((exports) => {
  var PROTECTED_KEYS = {
    REQUEST_ID: Symbol.for("_AWS_LAMBDA_REQUEST_ID"),
    X_RAY_TRACE_ID: Symbol.for("_AWS_LAMBDA_X_RAY_TRACE_ID"),
    TENANT_ID: Symbol.for("_AWS_LAMBDA_TENANT_ID")
  };
  var NO_GLOBAL_AWS_LAMBDA = ["true", "1"].includes(process.env?.AWS_LAMBDA_NODEJS_NO_GLOBAL_AWSLAMBDA ?? "");
  if (!NO_GLOBAL_AWS_LAMBDA) {
    globalThis.awslambda = globalThis.awslambda || {};
  }

  class InvokeStoreBase {
    static PROTECTED_KEYS = PROTECTED_KEYS;
    isProtectedKey(key) {
      return Object.values(PROTECTED_KEYS).includes(key);
    }
    getRequestId() {
      return this.get(PROTECTED_KEYS.REQUEST_ID) ?? "-";
    }
    getXRayTraceId() {
      return this.get(PROTECTED_KEYS.X_RAY_TRACE_ID);
    }
    getTenantId() {
      return this.get(PROTECTED_KEYS.TENANT_ID);
    }
  }

  class InvokeStoreSingle extends InvokeStoreBase {
    currentContext;
    getContext() {
      return this.currentContext;
    }
    hasContext() {
      return this.currentContext !== undefined;
    }
    get(key) {
      return this.currentContext?.[key];
    }
    set(key, value) {
      if (this.isProtectedKey(key)) {
        throw new Error(`Cannot modify protected Lambda context field: ${String(key)}`);
      }
      this.currentContext = this.currentContext || {};
      this.currentContext[key] = value;
    }
    run(context, fn) {
      this.currentContext = context;
      return fn();
    }
  }

  class InvokeStoreMulti extends InvokeStoreBase {
    als;
    static async create() {
      const instance = new InvokeStoreMulti;
      const asyncHooks = await import("async_hooks");
      instance.als = new asyncHooks.AsyncLocalStorage;
      return instance;
    }
    getContext() {
      return this.als.getStore();
    }
    hasContext() {
      return this.als.getStore() !== undefined;
    }
    get(key) {
      return this.als.getStore()?.[key];
    }
    set(key, value) {
      if (this.isProtectedKey(key)) {
        throw new Error(`Cannot modify protected Lambda context field: ${String(key)}`);
      }
      const store = this.als.getStore();
      if (!store) {
        throw new Error("No context available");
      }
      store[key] = value;
    }
    run(context, fn) {
      return this.als.run(context, fn);
    }
  }
  exports.InvokeStore = undefined;
  (function(InvokeStore) {
    let instance = null;
    async function getInstanceAsync() {
      if (!instance) {
        instance = (async () => {
          const isMulti = "AWS_LAMBDA_MAX_CONCURRENCY" in process.env;
          const newInstance = isMulti ? await InvokeStoreMulti.create() : new InvokeStoreSingle;
          if (!NO_GLOBAL_AWS_LAMBDA && globalThis.awslambda?.InvokeStore) {
            return globalThis.awslambda.InvokeStore;
          } else if (!NO_GLOBAL_AWS_LAMBDA && globalThis.awslambda) {
            globalThis.awslambda.InvokeStore = newInstance;
            return newInstance;
          } else {
            return newInstance;
          }
        })();
      }
      return instance;
    }
    InvokeStore.getInstanceAsync = getInstanceAsync;
    InvokeStore._testing = process.env.AWS_LAMBDA_BENCHMARK_MODE === "1" ? {
      reset: () => {
        instance = null;
        if (globalThis.awslambda?.InvokeStore) {
          delete globalThis.awslambda.InvokeStore;
        }
        globalThis.awslambda = { InvokeStore: undefined };
      }
    } : undefined;
  })(exports.InvokeStore || (exports.InvokeStore = {}));
  exports.InvokeStoreBase = InvokeStoreBase;
});

// ../node_modules/.bun/@aws-sdk+middleware-recursion-detection@3.972.3/node_modules/@aws-sdk/middleware-recursion-detection/dist-cjs/recursionDetectionMiddleware.js
var require_recursionDetectionMiddleware = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.recursionDetectionMiddleware = undefined;
  var lambda_invoke_store_1 = require_invoke_store();
  var protocol_http_1 = require_dist_cjs2();
  var TRACE_ID_HEADER_NAME = "X-Amzn-Trace-Id";
  var ENV_LAMBDA_FUNCTION_NAME = "AWS_LAMBDA_FUNCTION_NAME";
  var ENV_TRACE_ID = "_X_AMZN_TRACE_ID";
  var recursionDetectionMiddleware = () => (next) => async (args) => {
    const { request } = args;
    if (!protocol_http_1.HttpRequest.isInstance(request)) {
      return next(args);
    }
    const traceIdHeader = Object.keys(request.headers ?? {}).find((h) => h.toLowerCase() === TRACE_ID_HEADER_NAME.toLowerCase()) ?? TRACE_ID_HEADER_NAME;
    if (request.headers.hasOwnProperty(traceIdHeader)) {
      return next(args);
    }
    const functionName = process.env[ENV_LAMBDA_FUNCTION_NAME];
    const traceIdFromEnv = process.env[ENV_TRACE_ID];
    const invokeStore = await lambda_invoke_store_1.InvokeStore.getInstanceAsync();
    const traceIdFromInvokeStore = invokeStore?.getXRayTraceId();
    const traceId = traceIdFromInvokeStore ?? traceIdFromEnv;
    const nonEmptyString = (str2) => typeof str2 === "string" && str2.length > 0;
    if (nonEmptyString(functionName) && nonEmptyString(traceId)) {
      request.headers[TRACE_ID_HEADER_NAME] = traceId;
    }
    return next({
      ...args,
      request
    });
  };
  exports.recursionDetectionMiddleware = recursionDetectionMiddleware;
});

// ../node_modules/.bun/@aws-sdk+middleware-recursion-detection@3.972.3/node_modules/@aws-sdk/middleware-recursion-detection/dist-cjs/index.js
var require_dist_cjs5 = __commonJS((exports) => {
  var recursionDetectionMiddleware = require_recursionDetectionMiddleware();
  var recursionDetectionMiddlewareOptions = {
    step: "build",
    tags: ["RECURSION_DETECTION"],
    name: "recursionDetectionMiddleware",
    override: true,
    priority: "low"
  };
  var getRecursionDetectionPlugin = (options) => ({
    applyToStack: (clientStack) => {
      clientStack.add(recursionDetectionMiddleware.recursionDetectionMiddleware(), recursionDetectionMiddlewareOptions);
    }
  });
  exports.getRecursionDetectionPlugin = getRecursionDetectionPlugin;
  Object.keys(recursionDetectionMiddleware).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return recursionDetectionMiddleware[k];
        }
      });
  });
});

// ../node_modules/.bun/@smithy+util-middleware@4.2.8/node_modules/@smithy/util-middleware/dist-cjs/index.js
var require_dist_cjs6 = __commonJS((exports) => {
  var types = require_dist_cjs();
  var getSmithyContext = (context) => context[types.SMITHY_CONTEXT_KEY] || (context[types.SMITHY_CONTEXT_KEY] = {});
  var normalizeProvider = (input) => {
    if (typeof input === "function")
      return input;
    const promisified = Promise.resolve(input);
    return () => promisified;
  };
  exports.getSmithyContext = getSmithyContext;
  exports.normalizeProvider = normalizeProvider;
});

// ../node_modules/.bun/@smithy+middleware-serde@4.2.9/node_modules/@smithy/middleware-serde/dist-cjs/index.js
var require_dist_cjs7 = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  var deserializerMiddleware = (options, deserializer) => (next, context) => async (args) => {
    const { response } = await next(args);
    try {
      const parsed = await deserializer(response, options);
      return {
        response,
        output: parsed
      };
    } catch (error3) {
      Object.defineProperty(error3, "$response", {
        value: response,
        enumerable: false,
        writable: false,
        configurable: false
      });
      if (!("$metadata" in error3)) {
        const hint = `Deserialization error: to see the raw response, inspect the hidden field {error}.$response on this object.`;
        try {
          error3.message += `
  ` + hint;
        } catch (e) {
          if (!context.logger || context.logger?.constructor?.name === "NoOpLogger") {
            console.warn(hint);
          } else {
            context.logger?.warn?.(hint);
          }
        }
        if (typeof error3.$responseBodyText !== "undefined") {
          if (error3.$response) {
            error3.$response.body = error3.$responseBodyText;
          }
        }
        try {
          if (protocolHttp.HttpResponse.isInstance(response)) {
            const { headers = {} } = response;
            const headerEntries = Object.entries(headers);
            error3.$metadata = {
              httpStatusCode: response.statusCode,
              requestId: findHeader(/^x-[\w-]+-request-?id$/, headerEntries),
              extendedRequestId: findHeader(/^x-[\w-]+-id-2$/, headerEntries),
              cfId: findHeader(/^x-[\w-]+-cf-id$/, headerEntries)
            };
          }
        } catch (e) {}
      }
      throw error3;
    }
  };
  var findHeader = (pattern, headers) => {
    return (headers.find(([k]) => {
      return k.match(pattern);
    }) || [undefined, undefined])[1];
  };
  var serializerMiddleware = (options, serializer) => (next, context) => async (args) => {
    const endpointConfig = options;
    const endpoint = context.endpointV2?.url && endpointConfig.urlParser ? async () => endpointConfig.urlParser(context.endpointV2.url) : endpointConfig.endpoint;
    if (!endpoint) {
      throw new Error("No valid endpoint provider available.");
    }
    const request = await serializer(args.input, { ...options, endpoint });
    return next({
      ...args,
      request
    });
  };
  var deserializerMiddlewareOption = {
    name: "deserializerMiddleware",
    step: "deserialize",
    tags: ["DESERIALIZER"],
    override: true
  };
  var serializerMiddlewareOption = {
    name: "serializerMiddleware",
    step: "serialize",
    tags: ["SERIALIZER"],
    override: true
  };
  function getSerdePlugin(config, serializer, deserializer) {
    return {
      applyToStack: (commandStack) => {
        commandStack.add(deserializerMiddleware(config, deserializer), deserializerMiddlewareOption);
        commandStack.add(serializerMiddleware(config, serializer), serializerMiddlewareOption);
      }
    };
  }
  exports.deserializerMiddleware = deserializerMiddleware;
  exports.deserializerMiddlewareOption = deserializerMiddlewareOption;
  exports.getSerdePlugin = getSerdePlugin;
  exports.serializerMiddleware = serializerMiddleware;
  exports.serializerMiddlewareOption = serializerMiddlewareOption;
});

// ../node_modules/.bun/@smithy+is-array-buffer@4.2.0/node_modules/@smithy/is-array-buffer/dist-cjs/index.js
var require_dist_cjs8 = __commonJS((exports) => {
  var isArrayBuffer = (arg) => typeof ArrayBuffer === "function" && arg instanceof ArrayBuffer || Object.prototype.toString.call(arg) === "[object ArrayBuffer]";
  exports.isArrayBuffer = isArrayBuffer;
});

// ../node_modules/.bun/@smithy+util-buffer-from@4.2.0/node_modules/@smithy/util-buffer-from/dist-cjs/index.js
var require_dist_cjs9 = __commonJS((exports) => {
  var isArrayBuffer = require_dist_cjs8();
  var buffer = __require("buffer");
  var fromArrayBuffer = (input, offset = 0, length = input.byteLength - offset) => {
    if (!isArrayBuffer.isArrayBuffer(input)) {
      throw new TypeError(`The "input" argument must be ArrayBuffer. Received type ${typeof input} (${input})`);
    }
    return buffer.Buffer.from(input, offset, length);
  };
  var fromString = (input, encoding) => {
    if (typeof input !== "string") {
      throw new TypeError(`The "input" argument must be of type string. Received type ${typeof input} (${input})`);
    }
    return encoding ? buffer.Buffer.from(input, encoding) : buffer.Buffer.from(input);
  };
  exports.fromArrayBuffer = fromArrayBuffer;
  exports.fromString = fromString;
});

// ../node_modules/.bun/@smithy+util-base64@4.3.0/node_modules/@smithy/util-base64/dist-cjs/fromBase64.js
var require_fromBase64 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.fromBase64 = undefined;
  var util_buffer_from_1 = require_dist_cjs9();
  var BASE64_REGEX = /^[A-Za-z0-9+/]*={0,2}$/;
  var fromBase64 = (input) => {
    if (input.length * 3 % 4 !== 0) {
      throw new TypeError(`Incorrect padding on base64 string.`);
    }
    if (!BASE64_REGEX.exec(input)) {
      throw new TypeError(`Invalid base64 string.`);
    }
    const buffer = (0, util_buffer_from_1.fromString)(input, "base64");
    return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);
  };
  exports.fromBase64 = fromBase64;
});

// ../node_modules/.bun/@smithy+util-utf8@4.2.0/node_modules/@smithy/util-utf8/dist-cjs/index.js
var require_dist_cjs10 = __commonJS((exports) => {
  var utilBufferFrom = require_dist_cjs9();
  var fromUtf8 = (input) => {
    const buf = utilBufferFrom.fromString(input, "utf8");
    return new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength / Uint8Array.BYTES_PER_ELEMENT);
  };
  var toUint8Array = (data) => {
    if (typeof data === "string") {
      return fromUtf8(data);
    }
    if (ArrayBuffer.isView(data)) {
      return new Uint8Array(data.buffer, data.byteOffset, data.byteLength / Uint8Array.BYTES_PER_ELEMENT);
    }
    return new Uint8Array(data);
  };
  var toUtf8 = (input) => {
    if (typeof input === "string") {
      return input;
    }
    if (typeof input !== "object" || typeof input.byteOffset !== "number" || typeof input.byteLength !== "number") {
      throw new Error("@smithy/util-utf8: toUtf8 encoder function only accepts string | Uint8Array.");
    }
    return utilBufferFrom.fromArrayBuffer(input.buffer, input.byteOffset, input.byteLength).toString("utf8");
  };
  exports.fromUtf8 = fromUtf8;
  exports.toUint8Array = toUint8Array;
  exports.toUtf8 = toUtf8;
});

// ../node_modules/.bun/@smithy+util-base64@4.3.0/node_modules/@smithy/util-base64/dist-cjs/toBase64.js
var require_toBase64 = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.toBase64 = undefined;
  var util_buffer_from_1 = require_dist_cjs9();
  var util_utf8_1 = require_dist_cjs10();
  var toBase64 = (_input) => {
    let input;
    if (typeof _input === "string") {
      input = (0, util_utf8_1.fromUtf8)(_input);
    } else {
      input = _input;
    }
    if (typeof input !== "object" || typeof input.byteOffset !== "number" || typeof input.byteLength !== "number") {
      throw new Error("@smithy/util-base64: toBase64 encoder function only accepts string | Uint8Array.");
    }
    return (0, util_buffer_from_1.fromArrayBuffer)(input.buffer, input.byteOffset, input.byteLength).toString("base64");
  };
  exports.toBase64 = toBase64;
});

// ../node_modules/.bun/@smithy+util-base64@4.3.0/node_modules/@smithy/util-base64/dist-cjs/index.js
var require_dist_cjs11 = __commonJS((exports) => {
  var fromBase64 = require_fromBase64();
  var toBase64 = require_toBase64();
  Object.keys(fromBase64).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return fromBase64[k];
        }
      });
  });
  Object.keys(toBase64).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return toBase64[k];
        }
      });
  });
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/checksum/ChecksumStream.js
var require_ChecksumStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ChecksumStream = undefined;
  var util_base64_1 = require_dist_cjs11();
  var stream_1 = __require("stream");

  class ChecksumStream extends stream_1.Duplex {
    expectedChecksum;
    checksumSourceLocation;
    checksum;
    source;
    base64Encoder;
    constructor({ expectedChecksum, checksum, source, checksumSourceLocation, base64Encoder }) {
      super();
      if (typeof source.pipe === "function") {
        this.source = source;
      } else {
        throw new Error(`@smithy/util-stream: unsupported source type ${source?.constructor?.name ?? source} in ChecksumStream.`);
      }
      this.base64Encoder = base64Encoder ?? util_base64_1.toBase64;
      this.expectedChecksum = expectedChecksum;
      this.checksum = checksum;
      this.checksumSourceLocation = checksumSourceLocation;
      this.source.pipe(this);
    }
    _read(size) {}
    _write(chunk, encoding, callback) {
      try {
        this.checksum.update(chunk);
        this.push(chunk);
      } catch (e) {
        return callback(e);
      }
      return callback();
    }
    async _final(callback) {
      try {
        const digest = await this.checksum.digest();
        const received = this.base64Encoder(digest);
        if (this.expectedChecksum !== received) {
          return callback(new Error(`Checksum mismatch: expected "${this.expectedChecksum}" but received "${received}"` + ` in response header "${this.checksumSourceLocation}".`));
        }
      } catch (e) {
        return callback(e);
      }
      this.push(null);
      return callback();
    }
  }
  exports.ChecksumStream = ChecksumStream;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/stream-type-check.js
var require_stream_type_check = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.isBlob = exports.isReadableStream = undefined;
  var isReadableStream = (stream) => typeof ReadableStream === "function" && (stream?.constructor?.name === ReadableStream.name || stream instanceof ReadableStream);
  exports.isReadableStream = isReadableStream;
  var isBlob = (blob) => {
    return typeof Blob === "function" && (blob?.constructor?.name === Blob.name || blob instanceof Blob);
  };
  exports.isBlob = isBlob;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/checksum/ChecksumStream.browser.js
var require_ChecksumStream_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ChecksumStream = undefined;
  var ReadableStreamRef = typeof ReadableStream === "function" ? ReadableStream : function() {};

  class ChecksumStream extends ReadableStreamRef {
  }
  exports.ChecksumStream = ChecksumStream;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/checksum/createChecksumStream.browser.js
var require_createChecksumStream_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createChecksumStream = undefined;
  var util_base64_1 = require_dist_cjs11();
  var stream_type_check_1 = require_stream_type_check();
  var ChecksumStream_browser_1 = require_ChecksumStream_browser();
  var createChecksumStream = ({ expectedChecksum, checksum, source, checksumSourceLocation, base64Encoder }) => {
    if (!(0, stream_type_check_1.isReadableStream)(source)) {
      throw new Error(`@smithy/util-stream: unsupported source type ${source?.constructor?.name ?? source} in ChecksumStream.`);
    }
    const encoder = base64Encoder ?? util_base64_1.toBase64;
    if (typeof TransformStream !== "function") {
      throw new Error("@smithy/util-stream: unable to instantiate ChecksumStream because API unavailable: ReadableStream/TransformStream.");
    }
    const transform = new TransformStream({
      start() {},
      async transform(chunk, controller) {
        checksum.update(chunk);
        controller.enqueue(chunk);
      },
      async flush(controller) {
        const digest = await checksum.digest();
        const received = encoder(digest);
        if (expectedChecksum !== received) {
          const error3 = new Error(`Checksum mismatch: expected "${expectedChecksum}" but received "${received}"` + ` in response header "${checksumSourceLocation}".`);
          controller.error(error3);
        } else {
          controller.terminate();
        }
      }
    });
    source.pipeThrough(transform);
    const readable = transform.readable;
    Object.setPrototypeOf(readable, ChecksumStream_browser_1.ChecksumStream.prototype);
    return readable;
  };
  exports.createChecksumStream = createChecksumStream;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/checksum/createChecksumStream.js
var require_createChecksumStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createChecksumStream = createChecksumStream;
  var stream_type_check_1 = require_stream_type_check();
  var ChecksumStream_1 = require_ChecksumStream();
  var createChecksumStream_browser_1 = require_createChecksumStream_browser();
  function createChecksumStream(init) {
    if (typeof ReadableStream === "function" && (0, stream_type_check_1.isReadableStream)(init.source)) {
      return (0, createChecksumStream_browser_1.createChecksumStream)(init);
    }
    return new ChecksumStream_1.ChecksumStream(init);
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/ByteArrayCollector.js
var require_ByteArrayCollector = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.ByteArrayCollector = undefined;

  class ByteArrayCollector {
    allocByteArray;
    byteLength = 0;
    byteArrays = [];
    constructor(allocByteArray) {
      this.allocByteArray = allocByteArray;
    }
    push(byteArray) {
      this.byteArrays.push(byteArray);
      this.byteLength += byteArray.byteLength;
    }
    flush() {
      if (this.byteArrays.length === 1) {
        const bytes = this.byteArrays[0];
        this.reset();
        return bytes;
      }
      const aggregation = this.allocByteArray(this.byteLength);
      let cursor = 0;
      for (let i = 0;i < this.byteArrays.length; ++i) {
        const bytes = this.byteArrays[i];
        aggregation.set(bytes, cursor);
        cursor += bytes.byteLength;
      }
      this.reset();
      return aggregation;
    }
    reset() {
      this.byteArrays = [];
      this.byteLength = 0;
    }
  }
  exports.ByteArrayCollector = ByteArrayCollector;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/createBufferedReadableStream.js
var require_createBufferedReadableStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createBufferedReadable = undefined;
  exports.createBufferedReadableStream = createBufferedReadableStream;
  exports.merge = merge;
  exports.flush = flush;
  exports.sizeOf = sizeOf;
  exports.modeOf = modeOf;
  var ByteArrayCollector_1 = require_ByteArrayCollector();
  function createBufferedReadableStream(upstream, size, logger) {
    const reader = upstream.getReader();
    let streamBufferingLoggedWarning = false;
    let bytesSeen = 0;
    const buffers = ["", new ByteArrayCollector_1.ByteArrayCollector((size2) => new Uint8Array(size2))];
    let mode = -1;
    const pull = async (controller) => {
      const { value, done } = await reader.read();
      const chunk = value;
      if (done) {
        if (mode !== -1) {
          const remainder = flush(buffers, mode);
          if (sizeOf(remainder) > 0) {
            controller.enqueue(remainder);
          }
        }
        controller.close();
      } else {
        const chunkMode = modeOf(chunk, false);
        if (mode !== chunkMode) {
          if (mode >= 0) {
            controller.enqueue(flush(buffers, mode));
          }
          mode = chunkMode;
        }
        if (mode === -1) {
          controller.enqueue(chunk);
          return;
        }
        const chunkSize = sizeOf(chunk);
        bytesSeen += chunkSize;
        const bufferSize = sizeOf(buffers[mode]);
        if (chunkSize >= size && bufferSize === 0) {
          controller.enqueue(chunk);
        } else {
          const newSize = merge(buffers, mode, chunk);
          if (!streamBufferingLoggedWarning && bytesSeen > size * 2) {
            streamBufferingLoggedWarning = true;
            logger?.warn(`@smithy/util-stream - stream chunk size ${chunkSize} is below threshold of ${size}, automatically buffering.`);
          }
          if (newSize >= size) {
            controller.enqueue(flush(buffers, mode));
          } else {
            await pull(controller);
          }
        }
      }
    };
    return new ReadableStream({
      pull
    });
  }
  exports.createBufferedReadable = createBufferedReadableStream;
  function merge(buffers, mode, chunk) {
    switch (mode) {
      case 0:
        buffers[0] += chunk;
        return sizeOf(buffers[0]);
      case 1:
      case 2:
        buffers[mode].push(chunk);
        return sizeOf(buffers[mode]);
    }
  }
  function flush(buffers, mode) {
    switch (mode) {
      case 0:
        const s = buffers[0];
        buffers[0] = "";
        return s;
      case 1:
      case 2:
        return buffers[mode].flush();
    }
    throw new Error(`@smithy/util-stream - invalid index ${mode} given to flush()`);
  }
  function sizeOf(chunk) {
    return chunk?.byteLength ?? chunk?.length ?? 0;
  }
  function modeOf(chunk, allowBuffer = true) {
    if (allowBuffer && typeof Buffer !== "undefined" && chunk instanceof Buffer) {
      return 2;
    }
    if (chunk instanceof Uint8Array) {
      return 1;
    }
    if (typeof chunk === "string") {
      return 0;
    }
    return -1;
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/createBufferedReadable.js
var require_createBufferedReadable = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.createBufferedReadable = createBufferedReadable;
  var node_stream_1 = __require("stream");
  var ByteArrayCollector_1 = require_ByteArrayCollector();
  var createBufferedReadableStream_1 = require_createBufferedReadableStream();
  var stream_type_check_1 = require_stream_type_check();
  function createBufferedReadable(upstream, size, logger) {
    if ((0, stream_type_check_1.isReadableStream)(upstream)) {
      return (0, createBufferedReadableStream_1.createBufferedReadableStream)(upstream, size, logger);
    }
    const downstream = new node_stream_1.Readable({ read() {} });
    let streamBufferingLoggedWarning = false;
    let bytesSeen = 0;
    const buffers = [
      "",
      new ByteArrayCollector_1.ByteArrayCollector((size2) => new Uint8Array(size2)),
      new ByteArrayCollector_1.ByteArrayCollector((size2) => Buffer.from(new Uint8Array(size2)))
    ];
    let mode = -1;
    upstream.on("data", (chunk) => {
      const chunkMode = (0, createBufferedReadableStream_1.modeOf)(chunk, true);
      if (mode !== chunkMode) {
        if (mode >= 0) {
          downstream.push((0, createBufferedReadableStream_1.flush)(buffers, mode));
        }
        mode = chunkMode;
      }
      if (mode === -1) {
        downstream.push(chunk);
        return;
      }
      const chunkSize = (0, createBufferedReadableStream_1.sizeOf)(chunk);
      bytesSeen += chunkSize;
      const bufferSize = (0, createBufferedReadableStream_1.sizeOf)(buffers[mode]);
      if (chunkSize >= size && bufferSize === 0) {
        downstream.push(chunk);
      } else {
        const newSize = (0, createBufferedReadableStream_1.merge)(buffers, mode, chunk);
        if (!streamBufferingLoggedWarning && bytesSeen > size * 2) {
          streamBufferingLoggedWarning = true;
          logger?.warn(`@smithy/util-stream - stream chunk size ${chunkSize} is below threshold of ${size}, automatically buffering.`);
        }
        if (newSize >= size) {
          downstream.push((0, createBufferedReadableStream_1.flush)(buffers, mode));
        }
      }
    });
    upstream.on("end", () => {
      if (mode !== -1) {
        const remainder = (0, createBufferedReadableStream_1.flush)(buffers, mode);
        if ((0, createBufferedReadableStream_1.sizeOf)(remainder) > 0) {
          downstream.push(remainder);
        }
      }
      downstream.push(null);
    });
    return downstream;
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/getAwsChunkedEncodingStream.browser.js
var require_getAwsChunkedEncodingStream_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.getAwsChunkedEncodingStream = undefined;
  var getAwsChunkedEncodingStream = (readableStream, options) => {
    const { base64Encoder, bodyLengthChecker, checksumAlgorithmFn, checksumLocationName, streamHasher } = options;
    const checksumRequired = base64Encoder !== undefined && bodyLengthChecker !== undefined && checksumAlgorithmFn !== undefined && checksumLocationName !== undefined && streamHasher !== undefined;
    const digest = checksumRequired ? streamHasher(checksumAlgorithmFn, readableStream) : undefined;
    const reader = readableStream.getReader();
    return new ReadableStream({
      async pull(controller) {
        const { value, done } = await reader.read();
        if (done) {
          controller.enqueue(`0\r
`);
          if (checksumRequired) {
            const checksum = base64Encoder(await digest);
            controller.enqueue(`${checksumLocationName}:${checksum}\r
`);
            controller.enqueue(`\r
`);
          }
          controller.close();
        } else {
          controller.enqueue(`${(bodyLengthChecker(value) || 0).toString(16)}\r
${value}\r
`);
        }
      }
    });
  };
  exports.getAwsChunkedEncodingStream = getAwsChunkedEncodingStream;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/getAwsChunkedEncodingStream.js
var require_getAwsChunkedEncodingStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.getAwsChunkedEncodingStream = getAwsChunkedEncodingStream;
  var node_stream_1 = __require("stream");
  var getAwsChunkedEncodingStream_browser_1 = require_getAwsChunkedEncodingStream_browser();
  var stream_type_check_1 = require_stream_type_check();
  function getAwsChunkedEncodingStream(stream, options) {
    const readable = stream;
    const readableStream = stream;
    if ((0, stream_type_check_1.isReadableStream)(readableStream)) {
      return (0, getAwsChunkedEncodingStream_browser_1.getAwsChunkedEncodingStream)(readableStream, options);
    }
    const { base64Encoder, bodyLengthChecker, checksumAlgorithmFn, checksumLocationName, streamHasher } = options;
    const checksumRequired = base64Encoder !== undefined && checksumAlgorithmFn !== undefined && checksumLocationName !== undefined && streamHasher !== undefined;
    const digest = checksumRequired ? streamHasher(checksumAlgorithmFn, readable) : undefined;
    const awsChunkedEncodingStream = new node_stream_1.Readable({
      read: () => {}
    });
    readable.on("data", (data) => {
      const length = bodyLengthChecker(data) || 0;
      if (length === 0) {
        return;
      }
      awsChunkedEncodingStream.push(`${length.toString(16)}\r
`);
      awsChunkedEncodingStream.push(data);
      awsChunkedEncodingStream.push(`\r
`);
    });
    readable.on("end", async () => {
      awsChunkedEncodingStream.push(`0\r
`);
      if (checksumRequired) {
        const checksum = base64Encoder(await digest);
        awsChunkedEncodingStream.push(`${checksumLocationName}:${checksum}\r
`);
        awsChunkedEncodingStream.push(`\r
`);
      }
      awsChunkedEncodingStream.push(null);
    });
    return awsChunkedEncodingStream;
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/headStream.browser.js
var require_headStream_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.headStream = headStream;
  async function headStream(stream, bytes) {
    let byteLengthCounter = 0;
    const chunks = [];
    const reader = stream.getReader();
    let isDone = false;
    while (!isDone) {
      const { done, value } = await reader.read();
      if (value) {
        chunks.push(value);
        byteLengthCounter += value?.byteLength ?? 0;
      }
      if (byteLengthCounter >= bytes) {
        break;
      }
      isDone = done;
    }
    reader.releaseLock();
    const collected = new Uint8Array(Math.min(bytes, byteLengthCounter));
    let offset = 0;
    for (const chunk of chunks) {
      if (chunk.byteLength > collected.byteLength - offset) {
        collected.set(chunk.subarray(0, collected.byteLength - offset), offset);
        break;
      } else {
        collected.set(chunk, offset);
      }
      offset += chunk.length;
    }
    return collected;
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/headStream.js
var require_headStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.headStream = undefined;
  var stream_1 = __require("stream");
  var headStream_browser_1 = require_headStream_browser();
  var stream_type_check_1 = require_stream_type_check();
  var headStream = (stream, bytes) => {
    if ((0, stream_type_check_1.isReadableStream)(stream)) {
      return (0, headStream_browser_1.headStream)(stream, bytes);
    }
    return new Promise((resolve3, reject) => {
      const collector = new Collector;
      collector.limit = bytes;
      stream.pipe(collector);
      stream.on("error", (err) => {
        collector.end();
        reject(err);
      });
      collector.on("error", reject);
      collector.on("finish", function() {
        const bytes2 = new Uint8Array(Buffer.concat(this.buffers));
        resolve3(bytes2);
      });
    });
  };
  exports.headStream = headStream;

  class Collector extends stream_1.Writable {
    buffers = [];
    limit = Infinity;
    bytesBuffered = 0;
    _write(chunk, encoding, callback) {
      this.buffers.push(chunk);
      this.bytesBuffered += chunk.byteLength ?? 0;
      if (this.bytesBuffered >= this.limit) {
        const excess = this.bytesBuffered - this.limit;
        const tailBuffer = this.buffers[this.buffers.length - 1];
        this.buffers[this.buffers.length - 1] = tailBuffer.subarray(0, tailBuffer.byteLength - excess);
        this.emit("finish");
      }
      callback();
    }
  }
});

// ../node_modules/.bun/@smithy+util-uri-escape@4.2.0/node_modules/@smithy/util-uri-escape/dist-cjs/index.js
var require_dist_cjs12 = __commonJS((exports) => {
  var escapeUri = (uri) => encodeURIComponent(uri).replace(/[!'()*]/g, hexEncode);
  var hexEncode = (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`;
  var escapeUriPath = (uri) => uri.split("/").map(escapeUri).join("/");
  exports.escapeUri = escapeUri;
  exports.escapeUriPath = escapeUriPath;
});

// ../node_modules/.bun/@smithy+querystring-builder@4.2.8/node_modules/@smithy/querystring-builder/dist-cjs/index.js
var require_dist_cjs13 = __commonJS((exports) => {
  var utilUriEscape = require_dist_cjs12();
  function buildQueryString(query) {
    const parts = [];
    for (let key of Object.keys(query).sort()) {
      const value = query[key];
      key = utilUriEscape.escapeUri(key);
      if (Array.isArray(value)) {
        for (let i = 0, iLen = value.length;i < iLen; i++) {
          parts.push(`${key}=${utilUriEscape.escapeUri(value[i])}`);
        }
      } else {
        let qsEntry = key;
        if (value || typeof value === "string") {
          qsEntry += `=${utilUriEscape.escapeUri(value)}`;
        }
        parts.push(qsEntry);
      }
    }
    return parts.join("&");
  }
  exports.buildQueryString = buildQueryString;
});

// ../node_modules/.bun/@smithy+node-http-handler@4.4.10/node_modules/@smithy/node-http-handler/dist-cjs/index.js
var require_dist_cjs14 = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  var querystringBuilder = require_dist_cjs13();
  var http = __require("http");
  var https = __require("https");
  var stream = __require("stream");
  var http2 = __require("http2");
  var NODEJS_TIMEOUT_ERROR_CODES = ["ECONNRESET", "EPIPE", "ETIMEDOUT"];
  var getTransformedHeaders = (headers) => {
    const transformedHeaders = {};
    for (const name of Object.keys(headers)) {
      const headerValues = headers[name];
      transformedHeaders[name] = Array.isArray(headerValues) ? headerValues.join(",") : headerValues;
    }
    return transformedHeaders;
  };
  var timing = {
    setTimeout: (cb, ms) => setTimeout(cb, ms),
    clearTimeout: (timeoutId) => clearTimeout(timeoutId)
  };
  var DEFER_EVENT_LISTENER_TIME$2 = 1000;
  var setConnectionTimeout = (request, reject, timeoutInMs = 0) => {
    if (!timeoutInMs) {
      return -1;
    }
    const registerTimeout = (offset) => {
      const timeoutId = timing.setTimeout(() => {
        request.destroy();
        reject(Object.assign(new Error(`@smithy/node-http-handler - the request socket did not establish a connection with the server within the configured timeout of ${timeoutInMs} ms.`), {
          name: "TimeoutError"
        }));
      }, timeoutInMs - offset);
      const doWithSocket = (socket) => {
        if (socket?.connecting) {
          socket.on("connect", () => {
            timing.clearTimeout(timeoutId);
          });
        } else {
          timing.clearTimeout(timeoutId);
        }
      };
      if (request.socket) {
        doWithSocket(request.socket);
      } else {
        request.on("socket", doWithSocket);
      }
    };
    if (timeoutInMs < 2000) {
      registerTimeout(0);
      return 0;
    }
    return timing.setTimeout(registerTimeout.bind(null, DEFER_EVENT_LISTENER_TIME$2), DEFER_EVENT_LISTENER_TIME$2);
  };
  var setRequestTimeout = (req, reject, timeoutInMs = 0, throwOnRequestTimeout, logger) => {
    if (timeoutInMs) {
      return timing.setTimeout(() => {
        let msg = `@smithy/node-http-handler - [${throwOnRequestTimeout ? "ERROR" : "WARN"}] a request has exceeded the configured ${timeoutInMs} ms requestTimeout.`;
        if (throwOnRequestTimeout) {
          const error3 = Object.assign(new Error(msg), {
            name: "TimeoutError",
            code: "ETIMEDOUT"
          });
          req.destroy(error3);
          reject(error3);
        } else {
          msg += ` Init client requestHandler with throwOnRequestTimeout=true to turn this into an error.`;
          logger?.warn?.(msg);
        }
      }, timeoutInMs);
    }
    return -1;
  };
  var DEFER_EVENT_LISTENER_TIME$1 = 3000;
  var setSocketKeepAlive = (request, { keepAlive, keepAliveMsecs }, deferTimeMs = DEFER_EVENT_LISTENER_TIME$1) => {
    if (keepAlive !== true) {
      return -1;
    }
    const registerListener = () => {
      if (request.socket) {
        request.socket.setKeepAlive(keepAlive, keepAliveMsecs || 0);
      } else {
        request.on("socket", (socket) => {
          socket.setKeepAlive(keepAlive, keepAliveMsecs || 0);
        });
      }
    };
    if (deferTimeMs === 0) {
      registerListener();
      return 0;
    }
    return timing.setTimeout(registerListener, deferTimeMs);
  };
  var DEFER_EVENT_LISTENER_TIME = 3000;
  var setSocketTimeout = (request, reject, timeoutInMs = 0) => {
    const registerTimeout = (offset) => {
      const timeout = timeoutInMs - offset;
      const onTimeout = () => {
        request.destroy();
        reject(Object.assign(new Error(`@smithy/node-http-handler - the request socket timed out after ${timeoutInMs} ms of inactivity (configured by client requestHandler).`), { name: "TimeoutError" }));
      };
      if (request.socket) {
        request.socket.setTimeout(timeout, onTimeout);
        request.on("close", () => request.socket?.removeListener("timeout", onTimeout));
      } else {
        request.setTimeout(timeout, onTimeout);
      }
    };
    if (0 < timeoutInMs && timeoutInMs < 6000) {
      registerTimeout(0);
      return 0;
    }
    return timing.setTimeout(registerTimeout.bind(null, timeoutInMs === 0 ? 0 : DEFER_EVENT_LISTENER_TIME), DEFER_EVENT_LISTENER_TIME);
  };
  var MIN_WAIT_TIME = 6000;
  async function writeRequestBody(httpRequest, request, maxContinueTimeoutMs = MIN_WAIT_TIME, externalAgent = false) {
    const headers = request.headers ?? {};
    const expect = headers.Expect || headers.expect;
    let timeoutId = -1;
    let sendBody = true;
    if (!externalAgent && expect === "100-continue") {
      sendBody = await Promise.race([
        new Promise((resolve3) => {
          timeoutId = Number(timing.setTimeout(() => resolve3(true), Math.max(MIN_WAIT_TIME, maxContinueTimeoutMs)));
        }),
        new Promise((resolve3) => {
          httpRequest.on("continue", () => {
            timing.clearTimeout(timeoutId);
            resolve3(true);
          });
          httpRequest.on("response", () => {
            timing.clearTimeout(timeoutId);
            resolve3(false);
          });
          httpRequest.on("error", () => {
            timing.clearTimeout(timeoutId);
            resolve3(false);
          });
        })
      ]);
    }
    if (sendBody) {
      writeBody(httpRequest, request.body);
    }
  }
  function writeBody(httpRequest, body) {
    if (body instanceof stream.Readable) {
      body.pipe(httpRequest);
      return;
    }
    if (body) {
      const isBuffer = Buffer.isBuffer(body);
      const isString = typeof body === "string";
      if (isBuffer || isString) {
        if (isBuffer && body.byteLength === 0) {
          httpRequest.end();
        } else {
          httpRequest.end(body);
        }
        return;
      }
      const uint8 = body;
      if (typeof uint8 === "object" && uint8.buffer && typeof uint8.byteOffset === "number" && typeof uint8.byteLength === "number") {
        httpRequest.end(Buffer.from(uint8.buffer, uint8.byteOffset, uint8.byteLength));
        return;
      }
      httpRequest.end(Buffer.from(body));
      return;
    }
    httpRequest.end();
  }
  var DEFAULT_REQUEST_TIMEOUT = 0;

  class NodeHttpHandler {
    config;
    configProvider;
    socketWarningTimestamp = 0;
    externalAgent = false;
    metadata = { handlerProtocol: "http/1.1" };
    static create(instanceOrOptions) {
      if (typeof instanceOrOptions?.handle === "function") {
        return instanceOrOptions;
      }
      return new NodeHttpHandler(instanceOrOptions);
    }
    static checkSocketUsage(agent, socketWarningTimestamp, logger = console) {
      const { sockets, requests, maxSockets } = agent;
      if (typeof maxSockets !== "number" || maxSockets === Infinity) {
        return socketWarningTimestamp;
      }
      const interval = 15000;
      if (Date.now() - interval < socketWarningTimestamp) {
        return socketWarningTimestamp;
      }
      if (sockets && requests) {
        for (const origin in sockets) {
          const socketsInUse = sockets[origin]?.length ?? 0;
          const requestsEnqueued = requests[origin]?.length ?? 0;
          if (socketsInUse >= maxSockets && requestsEnqueued >= 2 * maxSockets) {
            logger?.warn?.(`@smithy/node-http-handler:WARN - socket usage at capacity=${socketsInUse} and ${requestsEnqueued} additional requests are enqueued.
See https://docs.aws.amazon.com/sdk-for-javascript/v3/developer-guide/node-configuring-maxsockets.html
or increase socketAcquisitionWarningTimeout=(millis) in the NodeHttpHandler config.`);
            return Date.now();
          }
        }
      }
      return socketWarningTimestamp;
    }
    constructor(options) {
      this.configProvider = new Promise((resolve3, reject) => {
        if (typeof options === "function") {
          options().then((_options) => {
            resolve3(this.resolveDefaultConfig(_options));
          }).catch(reject);
        } else {
          resolve3(this.resolveDefaultConfig(options));
        }
      });
    }
    resolveDefaultConfig(options) {
      const { requestTimeout, connectionTimeout, socketTimeout, socketAcquisitionWarningTimeout, httpAgent, httpsAgent, throwOnRequestTimeout, logger } = options || {};
      const keepAlive = true;
      const maxSockets = 50;
      return {
        connectionTimeout,
        requestTimeout,
        socketTimeout,
        socketAcquisitionWarningTimeout,
        throwOnRequestTimeout,
        httpAgent: (() => {
          if (httpAgent instanceof http.Agent || typeof httpAgent?.destroy === "function") {
            this.externalAgent = true;
            return httpAgent;
          }
          return new http.Agent({ keepAlive, maxSockets, ...httpAgent });
        })(),
        httpsAgent: (() => {
          if (httpsAgent instanceof https.Agent || typeof httpsAgent?.destroy === "function") {
            this.externalAgent = true;
            return httpsAgent;
          }
          return new https.Agent({ keepAlive, maxSockets, ...httpsAgent });
        })(),
        logger
      };
    }
    destroy() {
      this.config?.httpAgent?.destroy();
      this.config?.httpsAgent?.destroy();
    }
    async handle(request, { abortSignal, requestTimeout } = {}) {
      if (!this.config) {
        this.config = await this.configProvider;
      }
      return new Promise((_resolve, _reject) => {
        const config = this.config;
        let writeRequestBodyPromise = undefined;
        const timeouts = [];
        const resolve3 = async (arg) => {
          await writeRequestBodyPromise;
          timeouts.forEach(timing.clearTimeout);
          _resolve(arg);
        };
        const reject = async (arg) => {
          await writeRequestBodyPromise;
          timeouts.forEach(timing.clearTimeout);
          _reject(arg);
        };
        if (abortSignal?.aborted) {
          const abortError = new Error("Request aborted");
          abortError.name = "AbortError";
          reject(abortError);
          return;
        }
        const isSSL = request.protocol === "https:";
        const headers = request.headers ?? {};
        const expectContinue = (headers.Expect ?? headers.expect) === "100-continue";
        let agent = isSSL ? config.httpsAgent : config.httpAgent;
        if (expectContinue && !this.externalAgent) {
          agent = new (isSSL ? https.Agent : http.Agent)({
            keepAlive: false,
            maxSockets: Infinity
          });
        }
        timeouts.push(timing.setTimeout(() => {
          this.socketWarningTimestamp = NodeHttpHandler.checkSocketUsage(agent, this.socketWarningTimestamp, config.logger);
        }, config.socketAcquisitionWarningTimeout ?? (config.requestTimeout ?? 2000) + (config.connectionTimeout ?? 1000)));
        const queryString = querystringBuilder.buildQueryString(request.query || {});
        let auth = undefined;
        if (request.username != null || request.password != null) {
          const username = request.username ?? "";
          const password = request.password ?? "";
          auth = `${username}:${password}`;
        }
        let path5 = request.path;
        if (queryString) {
          path5 += `?${queryString}`;
        }
        if (request.fragment) {
          path5 += `#${request.fragment}`;
        }
        let hostname = request.hostname ?? "";
        if (hostname[0] === "[" && hostname.endsWith("]")) {
          hostname = request.hostname.slice(1, -1);
        } else {
          hostname = request.hostname;
        }
        const nodeHttpsOptions = {
          headers: request.headers,
          host: hostname,
          method: request.method,
          path: path5,
          port: request.port,
          agent,
          auth
        };
        const requestFunc = isSSL ? https.request : http.request;
        const req = requestFunc(nodeHttpsOptions, (res) => {
          const httpResponse = new protocolHttp.HttpResponse({
            statusCode: res.statusCode || -1,
            reason: res.statusMessage,
            headers: getTransformedHeaders(res.headers),
            body: res
          });
          resolve3({ response: httpResponse });
        });
        req.on("error", (err) => {
          if (NODEJS_TIMEOUT_ERROR_CODES.includes(err.code)) {
            reject(Object.assign(err, { name: "TimeoutError" }));
          } else {
            reject(err);
          }
        });
        if (abortSignal) {
          const onAbort = () => {
            req.destroy();
            const abortError = new Error("Request aborted");
            abortError.name = "AbortError";
            reject(abortError);
          };
          if (typeof abortSignal.addEventListener === "function") {
            const signal = abortSignal;
            signal.addEventListener("abort", onAbort, { once: true });
            req.once("close", () => signal.removeEventListener("abort", onAbort));
          } else {
            abortSignal.onabort = onAbort;
          }
        }
        const effectiveRequestTimeout = requestTimeout ?? config.requestTimeout;
        timeouts.push(setConnectionTimeout(req, reject, config.connectionTimeout));
        timeouts.push(setRequestTimeout(req, reject, effectiveRequestTimeout, config.throwOnRequestTimeout, config.logger ?? console));
        timeouts.push(setSocketTimeout(req, reject, config.socketTimeout));
        const httpAgent = nodeHttpsOptions.agent;
        if (typeof httpAgent === "object" && "keepAlive" in httpAgent) {
          timeouts.push(setSocketKeepAlive(req, {
            keepAlive: httpAgent.keepAlive,
            keepAliveMsecs: httpAgent.keepAliveMsecs
          }));
        }
        writeRequestBodyPromise = writeRequestBody(req, request, effectiveRequestTimeout, this.externalAgent).catch((e) => {
          timeouts.forEach(timing.clearTimeout);
          return _reject(e);
        });
      });
    }
    updateHttpClientConfig(key, value) {
      this.config = undefined;
      this.configProvider = this.configProvider.then((config) => {
        return {
          ...config,
          [key]: value
        };
      });
    }
    httpHandlerConfigs() {
      return this.config ?? {};
    }
  }

  class NodeHttp2ConnectionPool {
    sessions = [];
    constructor(sessions) {
      this.sessions = sessions ?? [];
    }
    poll() {
      if (this.sessions.length > 0) {
        return this.sessions.shift();
      }
    }
    offerLast(session) {
      this.sessions.push(session);
    }
    contains(session) {
      return this.sessions.includes(session);
    }
    remove(session) {
      this.sessions = this.sessions.filter((s) => s !== session);
    }
    [Symbol.iterator]() {
      return this.sessions[Symbol.iterator]();
    }
    destroy(connection) {
      for (const session of this.sessions) {
        if (session === connection) {
          if (!session.destroyed) {
            session.destroy();
          }
        }
      }
    }
  }

  class NodeHttp2ConnectionManager {
    constructor(config) {
      this.config = config;
      if (this.config.maxConcurrency && this.config.maxConcurrency <= 0) {
        throw new RangeError("maxConcurrency must be greater than zero.");
      }
    }
    config;
    sessionCache = new Map;
    lease(requestContext, connectionConfiguration) {
      const url = this.getUrlString(requestContext);
      const existingPool = this.sessionCache.get(url);
      if (existingPool) {
        const existingSession = existingPool.poll();
        if (existingSession && !this.config.disableConcurrency) {
          return existingSession;
        }
      }
      const session = http2.connect(url);
      if (this.config.maxConcurrency) {
        session.settings({ maxConcurrentStreams: this.config.maxConcurrency }, (err) => {
          if (err) {
            throw new Error("Fail to set maxConcurrentStreams to " + this.config.maxConcurrency + "when creating new session for " + requestContext.destination.toString());
          }
        });
      }
      session.unref();
      const destroySessionCb = () => {
        session.destroy();
        this.deleteSession(url, session);
      };
      session.on("goaway", destroySessionCb);
      session.on("error", destroySessionCb);
      session.on("frameError", destroySessionCb);
      session.on("close", () => this.deleteSession(url, session));
      if (connectionConfiguration.requestTimeout) {
        session.setTimeout(connectionConfiguration.requestTimeout, destroySessionCb);
      }
      const connectionPool = this.sessionCache.get(url) || new NodeHttp2ConnectionPool;
      connectionPool.offerLast(session);
      this.sessionCache.set(url, connectionPool);
      return session;
    }
    deleteSession(authority, session) {
      const existingConnectionPool = this.sessionCache.get(authority);
      if (!existingConnectionPool) {
        return;
      }
      if (!existingConnectionPool.contains(session)) {
        return;
      }
      existingConnectionPool.remove(session);
      this.sessionCache.set(authority, existingConnectionPool);
    }
    release(requestContext, session) {
      const cacheKey2 = this.getUrlString(requestContext);
      this.sessionCache.get(cacheKey2)?.offerLast(session);
    }
    destroy() {
      for (const [key, connectionPool] of this.sessionCache) {
        for (const session of connectionPool) {
          if (!session.destroyed) {
            session.destroy();
          }
          connectionPool.remove(session);
        }
        this.sessionCache.delete(key);
      }
    }
    setMaxConcurrentStreams(maxConcurrentStreams) {
      if (maxConcurrentStreams && maxConcurrentStreams <= 0) {
        throw new RangeError("maxConcurrentStreams must be greater than zero.");
      }
      this.config.maxConcurrency = maxConcurrentStreams;
    }
    setDisableConcurrentStreams(disableConcurrentStreams) {
      this.config.disableConcurrency = disableConcurrentStreams;
    }
    getUrlString(request) {
      return request.destination.toString();
    }
  }

  class NodeHttp2Handler {
    config;
    configProvider;
    metadata = { handlerProtocol: "h2" };
    connectionManager = new NodeHttp2ConnectionManager({});
    static create(instanceOrOptions) {
      if (typeof instanceOrOptions?.handle === "function") {
        return instanceOrOptions;
      }
      return new NodeHttp2Handler(instanceOrOptions);
    }
    constructor(options) {
      this.configProvider = new Promise((resolve3, reject) => {
        if (typeof options === "function") {
          options().then((opts) => {
            resolve3(opts || {});
          }).catch(reject);
        } else {
          resolve3(options || {});
        }
      });
    }
    destroy() {
      this.connectionManager.destroy();
    }
    async handle(request, { abortSignal, requestTimeout } = {}) {
      if (!this.config) {
        this.config = await this.configProvider;
        this.connectionManager.setDisableConcurrentStreams(this.config.disableConcurrentStreams || false);
        if (this.config.maxConcurrentStreams) {
          this.connectionManager.setMaxConcurrentStreams(this.config.maxConcurrentStreams);
        }
      }
      const { requestTimeout: configRequestTimeout, disableConcurrentStreams } = this.config;
      const effectiveRequestTimeout = requestTimeout ?? configRequestTimeout;
      return new Promise((_resolve, _reject) => {
        let fulfilled = false;
        let writeRequestBodyPromise = undefined;
        const resolve3 = async (arg) => {
          await writeRequestBodyPromise;
          _resolve(arg);
        };
        const reject = async (arg) => {
          await writeRequestBodyPromise;
          _reject(arg);
        };
        if (abortSignal?.aborted) {
          fulfilled = true;
          const abortError = new Error("Request aborted");
          abortError.name = "AbortError";
          reject(abortError);
          return;
        }
        const { hostname, method, port, protocol, query } = request;
        let auth = "";
        if (request.username != null || request.password != null) {
          const username = request.username ?? "";
          const password = request.password ?? "";
          auth = `${username}:${password}@`;
        }
        const authority = `${protocol}//${auth}${hostname}${port ? `:${port}` : ""}`;
        const requestContext = { destination: new URL(authority) };
        const session = this.connectionManager.lease(requestContext, {
          requestTimeout: this.config?.sessionTimeout,
          disableConcurrentStreams: disableConcurrentStreams || false
        });
        const rejectWithDestroy = (err) => {
          if (disableConcurrentStreams) {
            this.destroySession(session);
          }
          fulfilled = true;
          reject(err);
        };
        const queryString = querystringBuilder.buildQueryString(query || {});
        let path5 = request.path;
        if (queryString) {
          path5 += `?${queryString}`;
        }
        if (request.fragment) {
          path5 += `#${request.fragment}`;
        }
        const req = session.request({
          ...request.headers,
          [http2.constants.HTTP2_HEADER_PATH]: path5,
          [http2.constants.HTTP2_HEADER_METHOD]: method
        });
        session.ref();
        req.on("response", (headers) => {
          const httpResponse = new protocolHttp.HttpResponse({
            statusCode: headers[":status"] || -1,
            headers: getTransformedHeaders(headers),
            body: req
          });
          fulfilled = true;
          resolve3({ response: httpResponse });
          if (disableConcurrentStreams) {
            session.close();
            this.connectionManager.deleteSession(authority, session);
          }
        });
        if (effectiveRequestTimeout) {
          req.setTimeout(effectiveRequestTimeout, () => {
            req.close();
            const timeoutError = new Error(`Stream timed out because of no activity for ${effectiveRequestTimeout} ms`);
            timeoutError.name = "TimeoutError";
            rejectWithDestroy(timeoutError);
          });
        }
        if (abortSignal) {
          const onAbort = () => {
            req.close();
            const abortError = new Error("Request aborted");
            abortError.name = "AbortError";
            rejectWithDestroy(abortError);
          };
          if (typeof abortSignal.addEventListener === "function") {
            const signal = abortSignal;
            signal.addEventListener("abort", onAbort, { once: true });
            req.once("close", () => signal.removeEventListener("abort", onAbort));
          } else {
            abortSignal.onabort = onAbort;
          }
        }
        req.on("frameError", (type, code, id) => {
          rejectWithDestroy(new Error(`Frame type id ${type} in stream id ${id} has failed with code ${code}.`));
        });
        req.on("error", rejectWithDestroy);
        req.on("aborted", () => {
          rejectWithDestroy(new Error(`HTTP/2 stream is abnormally aborted in mid-communication with result code ${req.rstCode}.`));
        });
        req.on("close", () => {
          session.unref();
          if (disableConcurrentStreams) {
            session.destroy();
          }
          if (!fulfilled) {
            rejectWithDestroy(new Error("Unexpected error: http2 request did not get a response"));
          }
        });
        writeRequestBodyPromise = writeRequestBody(req, request, effectiveRequestTimeout);
      });
    }
    updateHttpClientConfig(key, value) {
      this.config = undefined;
      this.configProvider = this.configProvider.then((config) => {
        return {
          ...config,
          [key]: value
        };
      });
    }
    httpHandlerConfigs() {
      return this.config ?? {};
    }
    destroySession(session) {
      if (!session.destroyed) {
        session.destroy();
      }
    }
  }

  class Collector extends stream.Writable {
    bufferedBytes = [];
    _write(chunk, encoding, callback) {
      this.bufferedBytes.push(chunk);
      callback();
    }
  }
  var streamCollector = (stream2) => {
    if (isReadableStreamInstance(stream2)) {
      return collectReadableStream(stream2);
    }
    return new Promise((resolve3, reject) => {
      const collector = new Collector;
      stream2.pipe(collector);
      stream2.on("error", (err) => {
        collector.end();
        reject(err);
      });
      collector.on("error", reject);
      collector.on("finish", function() {
        const bytes = new Uint8Array(Buffer.concat(this.bufferedBytes));
        resolve3(bytes);
      });
    });
  };
  var isReadableStreamInstance = (stream2) => typeof ReadableStream === "function" && stream2 instanceof ReadableStream;
  async function collectReadableStream(stream2) {
    const chunks = [];
    const reader = stream2.getReader();
    let isDone = false;
    let length = 0;
    while (!isDone) {
      const { done, value } = await reader.read();
      if (value) {
        chunks.push(value);
        length += value.length;
      }
      isDone = done;
    }
    const collected = new Uint8Array(length);
    let offset = 0;
    for (const chunk of chunks) {
      collected.set(chunk, offset);
      offset += chunk.length;
    }
    return collected;
  }
  exports.DEFAULT_REQUEST_TIMEOUT = DEFAULT_REQUEST_TIMEOUT;
  exports.NodeHttp2Handler = NodeHttp2Handler;
  exports.NodeHttpHandler = NodeHttpHandler;
  exports.streamCollector = streamCollector;
});

// ../node_modules/.bun/@smithy+fetch-http-handler@5.3.9/node_modules/@smithy/fetch-http-handler/dist-cjs/index.js
var require_dist_cjs15 = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  var querystringBuilder = require_dist_cjs13();
  var utilBase64 = require_dist_cjs11();
  function createRequest(url, requestOptions) {
    return new Request(url, requestOptions);
  }
  function requestTimeout(timeoutInMs = 0) {
    return new Promise((resolve3, reject) => {
      if (timeoutInMs) {
        setTimeout(() => {
          const timeoutError = new Error(`Request did not complete within ${timeoutInMs} ms`);
          timeoutError.name = "TimeoutError";
          reject(timeoutError);
        }, timeoutInMs);
      }
    });
  }
  var keepAliveSupport = {
    supported: undefined
  };

  class FetchHttpHandler {
    config;
    configProvider;
    static create(instanceOrOptions) {
      if (typeof instanceOrOptions?.handle === "function") {
        return instanceOrOptions;
      }
      return new FetchHttpHandler(instanceOrOptions);
    }
    constructor(options) {
      if (typeof options === "function") {
        this.configProvider = options().then((opts) => opts || {});
      } else {
        this.config = options ?? {};
        this.configProvider = Promise.resolve(this.config);
      }
      if (keepAliveSupport.supported === undefined) {
        keepAliveSupport.supported = Boolean(typeof Request !== "undefined" && "keepalive" in createRequest("https://[::1]"));
      }
    }
    destroy() {}
    async handle(request, { abortSignal, requestTimeout: requestTimeout$1 } = {}) {
      if (!this.config) {
        this.config = await this.configProvider;
      }
      const requestTimeoutInMs = requestTimeout$1 ?? this.config.requestTimeout;
      const keepAlive = this.config.keepAlive === true;
      const credentials = this.config.credentials;
      if (abortSignal?.aborted) {
        const abortError = new Error("Request aborted");
        abortError.name = "AbortError";
        return Promise.reject(abortError);
      }
      let path5 = request.path;
      const queryString = querystringBuilder.buildQueryString(request.query || {});
      if (queryString) {
        path5 += `?${queryString}`;
      }
      if (request.fragment) {
        path5 += `#${request.fragment}`;
      }
      let auth = "";
      if (request.username != null || request.password != null) {
        const username = request.username ?? "";
        const password = request.password ?? "";
        auth = `${username}:${password}@`;
      }
      const { port, method } = request;
      const url = `${request.protocol}//${auth}${request.hostname}${port ? `:${port}` : ""}${path5}`;
      const body = method === "GET" || method === "HEAD" ? undefined : request.body;
      const requestOptions = {
        body,
        headers: new Headers(request.headers),
        method,
        credentials
      };
      if (this.config?.cache) {
        requestOptions.cache = this.config.cache;
      }
      if (body) {
        requestOptions.duplex = "half";
      }
      if (typeof AbortController !== "undefined") {
        requestOptions.signal = abortSignal;
      }
      if (keepAliveSupport.supported) {
        requestOptions.keepalive = keepAlive;
      }
      if (typeof this.config.requestInit === "function") {
        Object.assign(requestOptions, this.config.requestInit(request));
      }
      let removeSignalEventListener = () => {};
      const fetchRequest = createRequest(url, requestOptions);
      const raceOfPromises = [
        fetch(fetchRequest).then((response) => {
          const fetchHeaders = response.headers;
          const transformedHeaders = {};
          for (const pair of fetchHeaders.entries()) {
            transformedHeaders[pair[0]] = pair[1];
          }
          const hasReadableStream = response.body != null;
          if (!hasReadableStream) {
            return response.blob().then((body2) => ({
              response: new protocolHttp.HttpResponse({
                headers: transformedHeaders,
                reason: response.statusText,
                statusCode: response.status,
                body: body2
              })
            }));
          }
          return {
            response: new protocolHttp.HttpResponse({
              headers: transformedHeaders,
              reason: response.statusText,
              statusCode: response.status,
              body: response.body
            })
          };
        }),
        requestTimeout(requestTimeoutInMs)
      ];
      if (abortSignal) {
        raceOfPromises.push(new Promise((resolve3, reject) => {
          const onAbort = () => {
            const abortError = new Error("Request aborted");
            abortError.name = "AbortError";
            reject(abortError);
          };
          if (typeof abortSignal.addEventListener === "function") {
            const signal = abortSignal;
            signal.addEventListener("abort", onAbort, { once: true });
            removeSignalEventListener = () => signal.removeEventListener("abort", onAbort);
          } else {
            abortSignal.onabort = onAbort;
          }
        }));
      }
      return Promise.race(raceOfPromises).finally(removeSignalEventListener);
    }
    updateHttpClientConfig(key, value) {
      this.config = undefined;
      this.configProvider = this.configProvider.then((config) => {
        config[key] = value;
        return config;
      });
    }
    httpHandlerConfigs() {
      return this.config ?? {};
    }
  }
  var streamCollector = async (stream) => {
    if (typeof Blob === "function" && stream instanceof Blob || stream.constructor?.name === "Blob") {
      if (Blob.prototype.arrayBuffer !== undefined) {
        return new Uint8Array(await stream.arrayBuffer());
      }
      return collectBlob(stream);
    }
    return collectStream(stream);
  };
  async function collectBlob(blob) {
    const base642 = await readToBase64(blob);
    const arrayBuffer = utilBase64.fromBase64(base642);
    return new Uint8Array(arrayBuffer);
  }
  async function collectStream(stream) {
    const chunks = [];
    const reader = stream.getReader();
    let isDone = false;
    let length = 0;
    while (!isDone) {
      const { done, value } = await reader.read();
      if (value) {
        chunks.push(value);
        length += value.length;
      }
      isDone = done;
    }
    const collected = new Uint8Array(length);
    let offset = 0;
    for (const chunk of chunks) {
      collected.set(chunk, offset);
      offset += chunk.length;
    }
    return collected;
  }
  function readToBase64(blob) {
    return new Promise((resolve3, reject) => {
      const reader = new FileReader;
      reader.onloadend = () => {
        if (reader.readyState !== 2) {
          return reject(new Error("Reader aborted too early"));
        }
        const result = reader.result ?? "";
        const commaIndex = result.indexOf(",");
        const dataOffset = commaIndex > -1 ? commaIndex + 1 : result.length;
        resolve3(result.substring(dataOffset));
      };
      reader.onabort = () => reject(new Error("Read aborted"));
      reader.onerror = () => reject(reader.error);
      reader.readAsDataURL(blob);
    });
  }
  exports.FetchHttpHandler = FetchHttpHandler;
  exports.keepAliveSupport = keepAliveSupport;
  exports.streamCollector = streamCollector;
});

// ../node_modules/.bun/@smithy+util-hex-encoding@4.2.0/node_modules/@smithy/util-hex-encoding/dist-cjs/index.js
var require_dist_cjs16 = __commonJS((exports) => {
  var SHORT_TO_HEX = {};
  var HEX_TO_SHORT = {};
  for (let i = 0;i < 256; i++) {
    let encodedByte = i.toString(16).toLowerCase();
    if (encodedByte.length === 1) {
      encodedByte = `0${encodedByte}`;
    }
    SHORT_TO_HEX[i] = encodedByte;
    HEX_TO_SHORT[encodedByte] = i;
  }
  function fromHex(encoded) {
    if (encoded.length % 2 !== 0) {
      throw new Error("Hex encoded strings must have an even number length");
    }
    const out = new Uint8Array(encoded.length / 2);
    for (let i = 0;i < encoded.length; i += 2) {
      const encodedByte = encoded.slice(i, i + 2).toLowerCase();
      if (encodedByte in HEX_TO_SHORT) {
        out[i / 2] = HEX_TO_SHORT[encodedByte];
      } else {
        throw new Error(`Cannot decode unrecognized sequence ${encodedByte} as hexadecimal`);
      }
    }
    return out;
  }
  function toHex(bytes) {
    let out = "";
    for (let i = 0;i < bytes.byteLength; i++) {
      out += SHORT_TO_HEX[bytes[i]];
    }
    return out;
  }
  exports.fromHex = fromHex;
  exports.toHex = toHex;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/sdk-stream-mixin.browser.js
var require_sdk_stream_mixin_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.sdkStreamMixin = undefined;
  var fetch_http_handler_1 = require_dist_cjs15();
  var util_base64_1 = require_dist_cjs11();
  var util_hex_encoding_1 = require_dist_cjs16();
  var util_utf8_1 = require_dist_cjs10();
  var stream_type_check_1 = require_stream_type_check();
  var ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED = "The stream has already been transformed.";
  var sdkStreamMixin = (stream) => {
    if (!isBlobInstance(stream) && !(0, stream_type_check_1.isReadableStream)(stream)) {
      const name = stream?.__proto__?.constructor?.name || stream;
      throw new Error(`Unexpected stream implementation, expect Blob or ReadableStream, got ${name}`);
    }
    let transformed = false;
    const transformToByteArray = async () => {
      if (transformed) {
        throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
      }
      transformed = true;
      return await (0, fetch_http_handler_1.streamCollector)(stream);
    };
    const blobToWebStream = (blob) => {
      if (typeof blob.stream !== "function") {
        throw new Error(`Cannot transform payload Blob to web stream. Please make sure the Blob.stream() is polyfilled.
` + "If you are using React Native, this API is not yet supported, see: https://react-native.canny.io/feature-requests/p/fetch-streaming-body");
      }
      return blob.stream();
    };
    return Object.assign(stream, {
      transformToByteArray,
      transformToString: async (encoding) => {
        const buf = await transformToByteArray();
        if (encoding === "base64") {
          return (0, util_base64_1.toBase64)(buf);
        } else if (encoding === "hex") {
          return (0, util_hex_encoding_1.toHex)(buf);
        } else if (encoding === undefined || encoding === "utf8" || encoding === "utf-8") {
          return (0, util_utf8_1.toUtf8)(buf);
        } else if (typeof TextDecoder === "function") {
          return new TextDecoder(encoding).decode(buf);
        } else {
          throw new Error("TextDecoder is not available, please make sure polyfill is provided.");
        }
      },
      transformToWebStream: () => {
        if (transformed) {
          throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
        }
        transformed = true;
        if (isBlobInstance(stream)) {
          return blobToWebStream(stream);
        } else if ((0, stream_type_check_1.isReadableStream)(stream)) {
          return stream;
        } else {
          throw new Error(`Cannot transform payload to web stream, got ${stream}`);
        }
      }
    });
  };
  exports.sdkStreamMixin = sdkStreamMixin;
  var isBlobInstance = (stream) => typeof Blob === "function" && stream instanceof Blob;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/sdk-stream-mixin.js
var require_sdk_stream_mixin = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.sdkStreamMixin = undefined;
  var node_http_handler_1 = require_dist_cjs14();
  var util_buffer_from_1 = require_dist_cjs9();
  var stream_1 = __require("stream");
  var sdk_stream_mixin_browser_1 = require_sdk_stream_mixin_browser();
  var ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED = "The stream has already been transformed.";
  var sdkStreamMixin = (stream) => {
    if (!(stream instanceof stream_1.Readable)) {
      try {
        return (0, sdk_stream_mixin_browser_1.sdkStreamMixin)(stream);
      } catch (e) {
        const name = stream?.__proto__?.constructor?.name || stream;
        throw new Error(`Unexpected stream implementation, expect Stream.Readable instance, got ${name}`);
      }
    }
    let transformed = false;
    const transformToByteArray = async () => {
      if (transformed) {
        throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
      }
      transformed = true;
      return await (0, node_http_handler_1.streamCollector)(stream);
    };
    return Object.assign(stream, {
      transformToByteArray,
      transformToString: async (encoding) => {
        const buf = await transformToByteArray();
        if (encoding === undefined || Buffer.isEncoding(encoding)) {
          return (0, util_buffer_from_1.fromArrayBuffer)(buf.buffer, buf.byteOffset, buf.byteLength).toString(encoding);
        } else {
          const decoder = new TextDecoder(encoding);
          return decoder.decode(buf);
        }
      },
      transformToWebStream: () => {
        if (transformed) {
          throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
        }
        if (stream.readableFlowing !== null) {
          throw new Error("The stream has been consumed by other callbacks.");
        }
        if (typeof stream_1.Readable.toWeb !== "function") {
          throw new Error("Readable.toWeb() is not supported. Please ensure a polyfill is available.");
        }
        transformed = true;
        return stream_1.Readable.toWeb(stream);
      }
    });
  };
  exports.sdkStreamMixin = sdkStreamMixin;
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/splitStream.browser.js
var require_splitStream_browser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.splitStream = splitStream;
  async function splitStream(stream) {
    if (typeof stream.stream === "function") {
      stream = stream.stream();
    }
    const readableStream = stream;
    return readableStream.tee();
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/splitStream.js
var require_splitStream = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.splitStream = splitStream;
  var stream_1 = __require("stream");
  var splitStream_browser_1 = require_splitStream_browser();
  var stream_type_check_1 = require_stream_type_check();
  async function splitStream(stream) {
    if ((0, stream_type_check_1.isReadableStream)(stream) || (0, stream_type_check_1.isBlob)(stream)) {
      return (0, splitStream_browser_1.splitStream)(stream);
    }
    const stream1 = new stream_1.PassThrough;
    const stream2 = new stream_1.PassThrough;
    stream.pipe(stream1);
    stream.pipe(stream2);
    return [stream1, stream2];
  }
});

// ../node_modules/.bun/@smithy+util-stream@4.5.12/node_modules/@smithy/util-stream/dist-cjs/index.js
var require_dist_cjs17 = __commonJS((exports) => {
  var utilBase64 = require_dist_cjs11();
  var utilUtf8 = require_dist_cjs10();
  var ChecksumStream = require_ChecksumStream();
  var createChecksumStream = require_createChecksumStream();
  var createBufferedReadable = require_createBufferedReadable();
  var getAwsChunkedEncodingStream = require_getAwsChunkedEncodingStream();
  var headStream = require_headStream();
  var sdkStreamMixin = require_sdk_stream_mixin();
  var splitStream = require_splitStream();
  var streamTypeCheck = require_stream_type_check();

  class Uint8ArrayBlobAdapter extends Uint8Array {
    static fromString(source, encoding = "utf-8") {
      if (typeof source === "string") {
        if (encoding === "base64") {
          return Uint8ArrayBlobAdapter.mutate(utilBase64.fromBase64(source));
        }
        return Uint8ArrayBlobAdapter.mutate(utilUtf8.fromUtf8(source));
      }
      throw new Error(`Unsupported conversion from ${typeof source} to Uint8ArrayBlobAdapter.`);
    }
    static mutate(source) {
      Object.setPrototypeOf(source, Uint8ArrayBlobAdapter.prototype);
      return source;
    }
    transformToString(encoding = "utf-8") {
      if (encoding === "base64") {
        return utilBase64.toBase64(this);
      }
      return utilUtf8.toUtf8(this);
    }
  }
  Object.defineProperty(exports, "isBlob", {
    enumerable: true,
    get: function() {
      return streamTypeCheck.isBlob;
    }
  });
  Object.defineProperty(exports, "isReadableStream", {
    enumerable: true,
    get: function() {
      return streamTypeCheck.isReadableStream;
    }
  });
  exports.Uint8ArrayBlobAdapter = Uint8ArrayBlobAdapter;
  Object.keys(ChecksumStream).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return ChecksumStream[k];
        }
      });
  });
  Object.keys(createChecksumStream).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return createChecksumStream[k];
        }
      });
  });
  Object.keys(createBufferedReadable).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return createBufferedReadable[k];
        }
      });
  });
  Object.keys(getAwsChunkedEncodingStream).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return getAwsChunkedEncodingStream[k];
        }
      });
  });
  Object.keys(headStream).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return headStream[k];
        }
      });
  });
  Object.keys(sdkStreamMixin).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return sdkStreamMixin[k];
        }
      });
  });
  Object.keys(splitStream).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return splitStream[k];
        }
      });
  });
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/submodules/schema/index.js
var require_schema = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  var utilMiddleware = require_dist_cjs6();
  var deref = (schemaRef) => {
    if (typeof schemaRef === "function") {
      return schemaRef();
    }
    return schemaRef;
  };
  var operation = (namespace, name, traits, input, output) => ({
    name,
    namespace,
    traits,
    input,
    output
  });
  var schemaDeserializationMiddleware = (config) => (next, context) => async (args) => {
    const { response } = await next(args);
    const { operationSchema } = utilMiddleware.getSmithyContext(context);
    const [, ns, n, t, i, o] = operationSchema ?? [];
    try {
      const parsed = await config.protocol.deserializeResponse(operation(ns, n, t, i, o), {
        ...config,
        ...context
      }, response);
      return {
        response,
        output: parsed
      };
    } catch (error4) {
      Object.defineProperty(error4, "$response", {
        value: response,
        enumerable: false,
        writable: false,
        configurable: false
      });
      if (!("$metadata" in error4)) {
        const hint = `Deserialization error: to see the raw response, inspect the hidden field {error}.$response on this object.`;
        try {
          error4.message += `
  ` + hint;
        } catch (e) {
          if (!context.logger || context.logger?.constructor?.name === "NoOpLogger") {
            console.warn(hint);
          } else {
            context.logger?.warn?.(hint);
          }
        }
        if (typeof error4.$responseBodyText !== "undefined") {
          if (error4.$response) {
            error4.$response.body = error4.$responseBodyText;
          }
        }
        try {
          if (protocolHttp.HttpResponse.isInstance(response)) {
            const { headers = {} } = response;
            const headerEntries = Object.entries(headers);
            error4.$metadata = {
              httpStatusCode: response.statusCode,
              requestId: findHeader(/^x-[\w-]+-request-?id$/, headerEntries),
              extendedRequestId: findHeader(/^x-[\w-]+-id-2$/, headerEntries),
              cfId: findHeader(/^x-[\w-]+-cf-id$/, headerEntries)
            };
          }
        } catch (e) {}
      }
      throw error4;
    }
  };
  var findHeader = (pattern, headers) => {
    return (headers.find(([k]) => {
      return k.match(pattern);
    }) || [undefined, undefined])[1];
  };
  var schemaSerializationMiddleware = (config) => (next, context) => async (args) => {
    const { operationSchema } = utilMiddleware.getSmithyContext(context);
    const [, ns, n, t, i, o] = operationSchema ?? [];
    const endpoint = context.endpointV2?.url && config.urlParser ? async () => config.urlParser(context.endpointV2.url) : config.endpoint;
    const request = await config.protocol.serializeRequest(operation(ns, n, t, i, o), args.input, {
      ...config,
      ...context,
      endpoint
    });
    return next({
      ...args,
      request
    });
  };
  var deserializerMiddlewareOption = {
    name: "deserializerMiddleware",
    step: "deserialize",
    tags: ["DESERIALIZER"],
    override: true
  };
  var serializerMiddlewareOption = {
    name: "serializerMiddleware",
    step: "serialize",
    tags: ["SERIALIZER"],
    override: true
  };
  function getSchemaSerdePlugin(config) {
    return {
      applyToStack: (commandStack) => {
        commandStack.add(schemaSerializationMiddleware(config), serializerMiddlewareOption);
        commandStack.add(schemaDeserializationMiddleware(config), deserializerMiddlewareOption);
        config.protocol.setSerdeContext(config);
      }
    };
  }

  class Schema {
    name;
    namespace;
    traits;
    static assign(instance, values2) {
      const schema = Object.assign(instance, values2);
      return schema;
    }
    static [Symbol.hasInstance](lhs) {
      const isPrototype = this.prototype.isPrototypeOf(lhs);
      if (!isPrototype && typeof lhs === "object" && lhs !== null) {
        const list2 = lhs;
        return list2.symbol === this.symbol;
      }
      return isPrototype;
    }
    getName() {
      return this.namespace + "#" + this.name;
    }
  }

  class ListSchema extends Schema {
    static symbol = Symbol.for("@smithy/lis");
    name;
    traits;
    valueSchema;
    symbol = ListSchema.symbol;
  }
  var list = (namespace, name, traits, valueSchema) => Schema.assign(new ListSchema, {
    name,
    namespace,
    traits,
    valueSchema
  });

  class MapSchema extends Schema {
    static symbol = Symbol.for("@smithy/map");
    name;
    traits;
    keySchema;
    valueSchema;
    symbol = MapSchema.symbol;
  }
  var map = (namespace, name, traits, keySchema, valueSchema) => Schema.assign(new MapSchema, {
    name,
    namespace,
    traits,
    keySchema,
    valueSchema
  });

  class OperationSchema extends Schema {
    static symbol = Symbol.for("@smithy/ope");
    name;
    traits;
    input;
    output;
    symbol = OperationSchema.symbol;
  }
  var op = (namespace, name, traits, input, output) => Schema.assign(new OperationSchema, {
    name,
    namespace,
    traits,
    input,
    output
  });

  class StructureSchema extends Schema {
    static symbol = Symbol.for("@smithy/str");
    name;
    traits;
    memberNames;
    memberList;
    symbol = StructureSchema.symbol;
  }
  var struct = (namespace, name, traits, memberNames, memberList) => Schema.assign(new StructureSchema, {
    name,
    namespace,
    traits,
    memberNames,
    memberList
  });

  class ErrorSchema extends StructureSchema {
    static symbol = Symbol.for("@smithy/err");
    ctor;
    symbol = ErrorSchema.symbol;
  }
  var error3 = (namespace, name, traits, memberNames, memberList, ctor) => Schema.assign(new ErrorSchema, {
    name,
    namespace,
    traits,
    memberNames,
    memberList,
    ctor: null
  });
  function translateTraits(indicator) {
    if (typeof indicator === "object") {
      return indicator;
    }
    indicator = indicator | 0;
    const traits = {};
    let i = 0;
    for (const trait of [
      "httpLabel",
      "idempotent",
      "idempotencyToken",
      "sensitive",
      "httpPayload",
      "httpResponseCode",
      "httpQueryParams"
    ]) {
      if ((indicator >> i++ & 1) === 1) {
        traits[trait] = 1;
      }
    }
    return traits;
  }
  var anno = {
    it: Symbol.for("@smithy/nor-struct-it")
  };

  class NormalizedSchema {
    ref;
    memberName;
    static symbol = Symbol.for("@smithy/nor");
    symbol = NormalizedSchema.symbol;
    name;
    schema;
    _isMemberSchema;
    traits;
    memberTraits;
    normalizedTraits;
    constructor(ref, memberName) {
      this.ref = ref;
      this.memberName = memberName;
      const traitStack = [];
      let _ref = ref;
      let schema = ref;
      this._isMemberSchema = false;
      while (isMemberSchema(_ref)) {
        traitStack.push(_ref[1]);
        _ref = _ref[0];
        schema = deref(_ref);
        this._isMemberSchema = true;
      }
      if (traitStack.length > 0) {
        this.memberTraits = {};
        for (let i = traitStack.length - 1;i >= 0; --i) {
          const traitSet = traitStack[i];
          Object.assign(this.memberTraits, translateTraits(traitSet));
        }
      } else {
        this.memberTraits = 0;
      }
      if (schema instanceof NormalizedSchema) {
        const computedMemberTraits = this.memberTraits;
        Object.assign(this, schema);
        this.memberTraits = Object.assign({}, computedMemberTraits, schema.getMemberTraits(), this.getMemberTraits());
        this.normalizedTraits = undefined;
        this.memberName = memberName ?? schema.memberName;
        return;
      }
      this.schema = deref(schema);
      if (isStaticSchema(this.schema)) {
        this.name = `${this.schema[1]}#${this.schema[2]}`;
        this.traits = this.schema[3];
      } else {
        this.name = this.memberName ?? String(schema);
        this.traits = 0;
      }
      if (this._isMemberSchema && !memberName) {
        throw new Error(`@smithy/core/schema - NormalizedSchema member init ${this.getName(true)} missing member name.`);
      }
    }
    static [Symbol.hasInstance](lhs) {
      const isPrototype = this.prototype.isPrototypeOf(lhs);
      if (!isPrototype && typeof lhs === "object" && lhs !== null) {
        const ns = lhs;
        return ns.symbol === this.symbol;
      }
      return isPrototype;
    }
    static of(ref) {
      const sc = deref(ref);
      if (sc instanceof NormalizedSchema) {
        return sc;
      }
      if (isMemberSchema(sc)) {
        const [ns, traits] = sc;
        if (ns instanceof NormalizedSchema) {
          Object.assign(ns.getMergedTraits(), translateTraits(traits));
          return ns;
        }
        throw new Error(`@smithy/core/schema - may not init unwrapped member schema=${JSON.stringify(ref, null, 2)}.`);
      }
      return new NormalizedSchema(sc);
    }
    getSchema() {
      const sc = this.schema;
      if (Array.isArray(sc) && sc[0] === 0) {
        return sc[4];
      }
      return sc;
    }
    getName(withNamespace = false) {
      const { name } = this;
      const short = !withNamespace && name && name.includes("#");
      return short ? name.split("#")[1] : name || undefined;
    }
    getMemberName() {
      return this.memberName;
    }
    isMemberSchema() {
      return this._isMemberSchema;
    }
    isListSchema() {
      const sc = this.getSchema();
      return typeof sc === "number" ? sc >= 64 && sc < 128 : sc[0] === 1;
    }
    isMapSchema() {
      const sc = this.getSchema();
      return typeof sc === "number" ? sc >= 128 && sc <= 255 : sc[0] === 2;
    }
    isStructSchema() {
      const sc = this.getSchema();
      if (typeof sc !== "object") {
        return false;
      }
      const id = sc[0];
      return id === 3 || id === -3 || id === 4;
    }
    isUnionSchema() {
      const sc = this.getSchema();
      if (typeof sc !== "object") {
        return false;
      }
      return sc[0] === 4;
    }
    isBlobSchema() {
      const sc = this.getSchema();
      return sc === 21 || sc === 42;
    }
    isTimestampSchema() {
      const sc = this.getSchema();
      return typeof sc === "number" && sc >= 4 && sc <= 7;
    }
    isUnitSchema() {
      return this.getSchema() === "unit";
    }
    isDocumentSchema() {
      return this.getSchema() === 15;
    }
    isStringSchema() {
      return this.getSchema() === 0;
    }
    isBooleanSchema() {
      return this.getSchema() === 2;
    }
    isNumericSchema() {
      return this.getSchema() === 1;
    }
    isBigIntegerSchema() {
      return this.getSchema() === 17;
    }
    isBigDecimalSchema() {
      return this.getSchema() === 19;
    }
    isStreaming() {
      const { streaming: streaming3 } = this.getMergedTraits();
      return !!streaming3 || this.getSchema() === 42;
    }
    isIdempotencyToken() {
      return !!this.getMergedTraits().idempotencyToken;
    }
    getMergedTraits() {
      return this.normalizedTraits ?? (this.normalizedTraits = {
        ...this.getOwnTraits(),
        ...this.getMemberTraits()
      });
    }
    getMemberTraits() {
      return translateTraits(this.memberTraits);
    }
    getOwnTraits() {
      return translateTraits(this.traits);
    }
    getKeySchema() {
      const [isDoc, isMap] = [this.isDocumentSchema(), this.isMapSchema()];
      if (!isDoc && !isMap) {
        throw new Error(`@smithy/core/schema - cannot get key for non-map: ${this.getName(true)}`);
      }
      const schema = this.getSchema();
      const memberSchema = isDoc ? 15 : schema[4] ?? 0;
      return member([memberSchema, 0], "key");
    }
    getValueSchema() {
      const sc = this.getSchema();
      const [isDoc, isMap, isList] = [this.isDocumentSchema(), this.isMapSchema(), this.isListSchema()];
      const memberSchema = typeof sc === "number" ? 63 & sc : sc && typeof sc === "object" && (isMap || isList) ? sc[3 + sc[0]] : isDoc ? 15 : undefined;
      if (memberSchema != null) {
        return member([memberSchema, 0], isMap ? "value" : "member");
      }
      throw new Error(`@smithy/core/schema - ${this.getName(true)} has no value member.`);
    }
    getMemberSchema(memberName) {
      const struct2 = this.getSchema();
      if (this.isStructSchema() && struct2[4].includes(memberName)) {
        const i = struct2[4].indexOf(memberName);
        const memberSchema = struct2[5][i];
        return member(isMemberSchema(memberSchema) ? memberSchema : [memberSchema, 0], memberName);
      }
      if (this.isDocumentSchema()) {
        return member([15, 0], memberName);
      }
      throw new Error(`@smithy/core/schema - ${this.getName(true)} has no no member=${memberName}.`);
    }
    getMemberSchemas() {
      const buffer = {};
      try {
        for (const [k, v] of this.structIterator()) {
          buffer[k] = v;
        }
      } catch (ignored) {}
      return buffer;
    }
    getEventStreamMember() {
      if (this.isStructSchema()) {
        for (const [memberName, memberSchema] of this.structIterator()) {
          if (memberSchema.isStreaming() && memberSchema.isStructSchema()) {
            return memberName;
          }
        }
      }
      return "";
    }
    *structIterator() {
      if (this.isUnitSchema()) {
        return;
      }
      if (!this.isStructSchema()) {
        throw new Error("@smithy/core/schema - cannot iterate non-struct schema.");
      }
      const struct2 = this.getSchema();
      const z = struct2[4].length;
      let it = struct2[anno.it];
      if (it && z === it.length) {
        yield* it;
        return;
      }
      it = Array(z);
      for (let i = 0;i < z; ++i) {
        const k = struct2[4][i];
        const v = member([struct2[5][i], 0], k);
        yield it[i] = [k, v];
      }
      struct2[anno.it] = it;
    }
  }
  function member(memberSchema, memberName) {
    if (memberSchema instanceof NormalizedSchema) {
      return Object.assign(memberSchema, {
        memberName,
        _isMemberSchema: true
      });
    }
    const internalCtorAccess = NormalizedSchema;
    return new internalCtorAccess(memberSchema, memberName);
  }
  var isMemberSchema = (sc) => Array.isArray(sc) && sc.length === 2;
  var isStaticSchema = (sc) => Array.isArray(sc) && sc.length >= 5;

  class SimpleSchema extends Schema {
    static symbol = Symbol.for("@smithy/sim");
    name;
    schemaRef;
    traits;
    symbol = SimpleSchema.symbol;
  }
  var sim = (namespace, name, schemaRef, traits) => Schema.assign(new SimpleSchema, {
    name,
    namespace,
    traits,
    schemaRef
  });
  var simAdapter = (namespace, name, traits, schemaRef) => Schema.assign(new SimpleSchema, {
    name,
    namespace,
    traits,
    schemaRef
  });
  var SCHEMA = {
    BLOB: 21,
    STREAMING_BLOB: 42,
    BOOLEAN: 2,
    STRING: 0,
    NUMERIC: 1,
    BIG_INTEGER: 17,
    BIG_DECIMAL: 19,
    DOCUMENT: 15,
    TIMESTAMP_DEFAULT: 4,
    TIMESTAMP_DATE_TIME: 5,
    TIMESTAMP_HTTP_DATE: 6,
    TIMESTAMP_EPOCH_SECONDS: 7,
    LIST_MODIFIER: 64,
    MAP_MODIFIER: 128
  };

  class TypeRegistry {
    namespace;
    schemas;
    exceptions;
    static registries = new Map;
    constructor(namespace, schemas = new Map, exceptions = new Map) {
      this.namespace = namespace;
      this.schemas = schemas;
      this.exceptions = exceptions;
    }
    static for(namespace) {
      if (!TypeRegistry.registries.has(namespace)) {
        TypeRegistry.registries.set(namespace, new TypeRegistry(namespace));
      }
      return TypeRegistry.registries.get(namespace);
    }
    copyFrom(other) {
      const { schemas, exceptions } = this;
      for (const [k, v] of other.schemas) {
        if (!schemas.has(k)) {
          schemas.set(k, v);
        }
      }
      for (const [k, v] of other.exceptions) {
        if (!exceptions.has(k)) {
          exceptions.set(k, v);
        }
      }
    }
    register(shapeId, schema) {
      const qualifiedName = this.normalizeShapeId(shapeId);
      for (const r of [this, TypeRegistry.for(qualifiedName.split("#")[0])]) {
        r.schemas.set(qualifiedName, schema);
      }
    }
    getSchema(shapeId) {
      const id = this.normalizeShapeId(shapeId);
      if (!this.schemas.has(id)) {
        throw new Error(`@smithy/core/schema - schema not found for ${id}`);
      }
      return this.schemas.get(id);
    }
    registerError(es, ctor) {
      const $error2 = es;
      const ns = $error2[1];
      for (const r of [this, TypeRegistry.for(ns)]) {
        r.schemas.set(ns + "#" + $error2[2], $error2);
        r.exceptions.set($error2, ctor);
      }
    }
    getErrorCtor(es) {
      const $error2 = es;
      if (this.exceptions.has($error2)) {
        return this.exceptions.get($error2);
      }
      const registry = TypeRegistry.for($error2[1]);
      return registry.exceptions.get($error2);
    }
    getBaseException() {
      for (const exceptionKey of this.exceptions.keys()) {
        if (Array.isArray(exceptionKey)) {
          const [, ns, name] = exceptionKey;
          const id = ns + "#" + name;
          if (id.startsWith("smithy.ts.sdk.synthetic.") && id.endsWith("ServiceException")) {
            return exceptionKey;
          }
        }
      }
      return;
    }
    find(predicate) {
      return [...this.schemas.values()].find(predicate);
    }
    clear() {
      this.schemas.clear();
      this.exceptions.clear();
    }
    normalizeShapeId(shapeId) {
      if (shapeId.includes("#")) {
        return shapeId;
      }
      return this.namespace + "#" + shapeId;
    }
  }
  exports.ErrorSchema = ErrorSchema;
  exports.ListSchema = ListSchema;
  exports.MapSchema = MapSchema;
  exports.NormalizedSchema = NormalizedSchema;
  exports.OperationSchema = OperationSchema;
  exports.SCHEMA = SCHEMA;
  exports.Schema = Schema;
  exports.SimpleSchema = SimpleSchema;
  exports.StructureSchema = StructureSchema;
  exports.TypeRegistry = TypeRegistry;
  exports.deref = deref;
  exports.deserializerMiddlewareOption = deserializerMiddlewareOption;
  exports.error = error3;
  exports.getSchemaSerdePlugin = getSchemaSerdePlugin;
  exports.isStaticSchema = isStaticSchema;
  exports.list = list;
  exports.map = map;
  exports.op = op;
  exports.operation = operation;
  exports.serializerMiddlewareOption = serializerMiddlewareOption;
  exports.sim = sim;
  exports.simAdapter = simAdapter;
  exports.struct = struct;
  exports.translateTraits = translateTraits;
});

// ../node_modules/.bun/tslib@2.8.1/node_modules/tslib/tslib.js
var require_tslib = __commonJS((exports, module) => {
  var __extends;
  var __assign;
  var __rest2;
  var __decorate;
  var __param;
  var __esDecorate;
  var __runInitializers;
  var __propKey;
  var __setFunctionName;
  var __metadata;
  var __awaiter;
  var __generator;
  var __exportStar;
  var __values2;
  var __read;
  var __spread;
  var __spreadArrays;
  var __spreadArray;
  var __await2;
  var __asyncGenerator2;
  var __asyncDelegator;
  var __asyncValues2;
  var __makeTemplateObject;
  var __importStar;
  var __importDefault;
  var __classPrivateFieldGet3;
  var __classPrivateFieldSet3;
  var __classPrivateFieldIn;
  var __createBinding;
  var __addDisposableResource;
  var __disposeResources;
  var __rewriteRelativeImportExtension;
  (function(factory) {
    var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
    if (typeof define === "function" && define.amd) {
      define("tslib", ["exports"], function(exports2) {
        factory(createExporter(root, createExporter(exports2)));
      });
    } else if (typeof module === "object" && typeof exports === "object") {
      factory(createExporter(root, createExporter(exports)));
    } else {
      factory(createExporter(root));
    }
    function createExporter(exports2, previous) {
      if (exports2 !== root) {
        if (typeof Object.create === "function") {
          Object.defineProperty(exports2, "__esModule", { value: true });
        } else {
          exports2.__esModule = true;
        }
      }
      return function(id, v) {
        return exports2[id] = previous ? previous(id, v) : v;
      };
    }
  })(function(exporter) {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
      d.__proto__ = b;
    } || function(d, b) {
      for (var p in b)
        if (Object.prototype.hasOwnProperty.call(b, p))
          d[p] = b[p];
    };
    __extends = function(d, b) {
      if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __);
    };
    __assign = Object.assign || function(t) {
      for (var s, i = 1, n = arguments.length;i < n; i++) {
        s = arguments[i];
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
      }
      return t;
    };
    __rest2 = function(s, e) {
      var t = {};
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s);i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
            t[p[i]] = s[p[i]];
        }
      return t;
    };
    __decorate = function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
      else
        for (var i = decorators.length - 1;i >= 0; i--)
          if (d = decorators[i])
            r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    __param = function(paramIndex, decorator) {
      return function(target, key) {
        decorator(target, key, paramIndex);
      };
    };
    __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
      function accept(f) {
        if (f !== undefined && typeof f !== "function")
          throw new TypeError("Function expected");
        return f;
      }
      var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
      var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
      var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
      var _, done = false;
      for (var i = decorators.length - 1;i >= 0; i--) {
        var context = {};
        for (var p in contextIn)
          context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access)
          context.access[p] = contextIn.access[p];
        context.addInitializer = function(f) {
          if (done)
            throw new TypeError("Cannot add initializers after decoration has completed");
          extraInitializers.push(accept(f || null));
        };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
          if (result === undefined)
            continue;
          if (result === null || typeof result !== "object")
            throw new TypeError("Object expected");
          if (_ = accept(result.get))
            descriptor.get = _;
          if (_ = accept(result.set))
            descriptor.set = _;
          if (_ = accept(result.init))
            initializers.unshift(_);
        } else if (_ = accept(result)) {
          if (kind === "field")
            initializers.unshift(_);
          else
            descriptor[key] = _;
        }
      }
      if (target)
        Object.defineProperty(target, contextIn.name, descriptor);
      done = true;
    };
    __runInitializers = function(thisArg, initializers, value) {
      var useValue = arguments.length > 2;
      for (var i = 0;i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
      }
      return useValue ? value : undefined;
    };
    __propKey = function(x) {
      return typeof x === "symbol" ? x : "".concat(x);
    };
    __setFunctionName = function(f, name, prefix) {
      if (typeof name === "symbol")
        name = name.description ? "[".concat(name.description, "]") : "";
      return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    };
    __metadata = function(metadataKey, metadataValue) {
      if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
        return Reflect.metadata(metadataKey, metadataValue);
    };
    __awaiter = function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve3) {
          resolve3(value);
        });
      }
      return new (P || (P = Promise))(function(resolve3, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve3(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    __generator = function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1)
          throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
      return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f)
          throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _)
          try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
              return t;
            if (y = 0, t)
              op = [op[0] & 2, t.value];
            switch (op[0]) {
              case 0:
              case 1:
                t = op;
                break;
              case 4:
                _.label++;
                return { value: op[1], done: false };
              case 5:
                _.label++;
                y = op[1];
                op = [0];
                continue;
              case 7:
                op = _.ops.pop();
                _.trys.pop();
                continue;
              default:
                if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _ = 0;
                  continue;
                }
                if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                  _.label = op[1];
                  break;
                }
                if (op[0] === 6 && _.label < t[1]) {
                  _.label = t[1];
                  t = op;
                  break;
                }
                if (t && _.label < t[2]) {
                  _.label = t[2];
                  _.ops.push(op);
                  break;
                }
                if (t[2])
                  _.ops.pop();
                _.trys.pop();
                continue;
            }
            op = body.call(thisArg, _);
          } catch (e) {
            op = [6, e];
            y = 0;
          } finally {
            f = t = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return { value: op[0] ? op[1] : undefined, done: true };
      }
    };
    __exportStar = function(m, o) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
          __createBinding(o, m, p);
    };
    __createBinding = Object.create ? function(o, m, k, k2) {
      if (k2 === undefined)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === undefined)
        k2 = k;
      o[k2] = m[k];
    };
    __values2 = function(o) {
      var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
      if (m)
        return m.call(o);
      if (o && typeof o.length === "number")
        return {
          next: function() {
            if (o && i >= o.length)
              o = undefined;
            return { value: o && o[i++], done: !o };
          }
        };
      throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __read = function(o, n) {
      var m = typeof Symbol === "function" && o[Symbol.iterator];
      if (!m)
        return o;
      var i = m.call(o), r, ar = [], e;
      try {
        while ((n === undefined || n-- > 0) && !(r = i.next()).done)
          ar.push(r.value);
      } catch (error3) {
        e = { error: error3 };
      } finally {
        try {
          if (r && !r.done && (m = i["return"]))
            m.call(i);
        } finally {
          if (e)
            throw e.error;
        }
      }
      return ar;
    };
    __spread = function() {
      for (var ar = [], i = 0;i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
      return ar;
    };
    __spreadArrays = function() {
      for (var s = 0, i = 0, il = arguments.length;i < il; i++)
        s += arguments[i].length;
      for (var r = Array(s), k = 0, i = 0;i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length;j < jl; j++, k++)
          r[k] = a[j];
      return r;
    };
    __spreadArray = function(to, from, pack) {
      if (pack || arguments.length === 2)
        for (var i = 0, l = from.length, ar;i < l; i++) {
          if (ar || !(i in from)) {
            if (!ar)
              ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
          }
        }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    __await2 = function(v) {
      return this instanceof __await2 ? (this.v = v, this) : new __await2(v);
    };
    __asyncGenerator2 = function(thisArg, _arguments, generator) {
      if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
      var g = generator.apply(thisArg, _arguments || []), i, q = [];
      return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function() {
        return this;
      }, i;
      function awaitReturn(f) {
        return function(v) {
          return Promise.resolve(v).then(f, reject);
        };
      }
      function verb(n, f) {
        if (g[n]) {
          i[n] = function(v) {
            return new Promise(function(a, b) {
              q.push([n, v, a, b]) > 1 || resume(n, v);
            });
          };
          if (f)
            i[n] = f(i[n]);
        }
      }
      function resume(n, v) {
        try {
          step(g[n](v));
        } catch (e) {
          settle(q[0][3], e);
        }
      }
      function step(r) {
        r.value instanceof __await2 ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
      }
      function fulfill(value) {
        resume("next", value);
      }
      function reject(value) {
        resume("throw", value);
      }
      function settle(f, v) {
        if (f(v), q.shift(), q.length)
          resume(q[0][0], q[0][1]);
      }
    };
    __asyncDelegator = function(o) {
      var i, p;
      return i = {}, verb("next"), verb("throw", function(e) {
        throw e;
      }), verb("return"), i[Symbol.iterator] = function() {
        return this;
      }, i;
      function verb(n, f) {
        i[n] = o[n] ? function(v) {
          return (p = !p) ? { value: __await2(o[n](v)), done: false } : f ? f(v) : v;
        } : f;
      }
    };
    __asyncValues2 = function(o) {
      if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
      var m = o[Symbol.asyncIterator], i;
      return m ? m.call(o) : (o = typeof __values2 === "function" ? __values2(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
      }, i);
      function verb(n) {
        i[n] = o[n] && function(v) {
          return new Promise(function(resolve3, reject) {
            v = o[n](v), settle(resolve3, reject, v.done, v.value);
          });
        };
      }
      function settle(resolve3, reject, d, v) {
        Promise.resolve(v).then(function(v2) {
          resolve3({ value: v2, done: d });
        }, reject);
      }
    };
    __makeTemplateObject = function(cooked, raw2) {
      if (Object.defineProperty) {
        Object.defineProperty(cooked, "raw", { value: raw2 });
      } else {
        cooked.raw = raw2;
      }
      return cooked;
    };
    var __setModuleDefault = Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    };
    var ownKeys = function(o) {
      ownKeys = Object.getOwnPropertyNames || function(o2) {
        var ar = [];
        for (var k in o2)
          if (Object.prototype.hasOwnProperty.call(o2, k))
            ar[ar.length] = k;
        return ar;
      };
      return ownKeys(o);
    };
    __importStar = function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k = ownKeys(mod), i = 0;i < k.length; i++)
          if (k[i] !== "default")
            __createBinding(result, mod, k[i]);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    __importDefault = function(mod) {
      return mod && mod.__esModule ? mod : { default: mod };
    };
    __classPrivateFieldGet3 = function(receiver, state, kind, f) {
      if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a getter");
      if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot read private member from an object whose class did not declare it");
      return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    };
    __classPrivateFieldSet3 = function(receiver, state, value, kind, f) {
      if (kind === "m")
        throw new TypeError("Private method is not writable");
      if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a setter");
      if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot write private member to an object whose class did not declare it");
      return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
    };
    __classPrivateFieldIn = function(state, receiver) {
      if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function")
        throw new TypeError("Cannot use 'in' operator on non-object");
      return typeof state === "function" ? receiver === state : state.has(receiver);
    };
    __addDisposableResource = function(env2, value, async) {
      if (value !== null && value !== undefined) {
        if (typeof value !== "object" && typeof value !== "function")
          throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
          if (!Symbol.asyncDispose)
            throw new TypeError("Symbol.asyncDispose is not defined.");
          dispose = value[Symbol.asyncDispose];
        }
        if (dispose === undefined) {
          if (!Symbol.dispose)
            throw new TypeError("Symbol.dispose is not defined.");
          dispose = value[Symbol.dispose];
          if (async)
            inner = dispose;
        }
        if (typeof dispose !== "function")
          throw new TypeError("Object not disposable.");
        if (inner)
          dispose = function() {
            try {
              inner.call(this);
            } catch (e) {
              return Promise.reject(e);
            }
          };
        env2.stack.push({ value, dispose, async });
      } else if (async) {
        env2.stack.push({ async: true });
      }
      return value;
    };
    var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error3, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error3, e.suppressed = suppressed, e;
    };
    __disposeResources = function(env2) {
      function fail(e) {
        env2.error = env2.hasError ? new _SuppressedError(e, env2.error, "An error was suppressed during disposal.") : e;
        env2.hasError = true;
      }
      var r, s = 0;
      function next() {
        while (r = env2.stack.pop()) {
          try {
            if (!r.async && s === 1)
              return s = 0, env2.stack.push(r), Promise.resolve().then(next);
            if (r.dispose) {
              var result = r.dispose.call(r.value);
              if (r.async)
                return s |= 2, Promise.resolve(result).then(next, function(e) {
                  fail(e);
                  return next();
                });
            } else
              s |= 1;
          } catch (e) {
            fail(e);
          }
        }
        if (s === 1)
          return env2.hasError ? Promise.reject(env2.error) : Promise.resolve();
        if (env2.hasError)
          throw env2.error;
      }
      return next();
    };
    __rewriteRelativeImportExtension = function(path5, preserveJsx) {
      if (typeof path5 === "string" && /^\.\.?\//.test(path5)) {
        return path5.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function(m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : d + ext + "." + cm.toLowerCase() + "js";
        });
      }
      return path5;
    };
    exporter("__extends", __extends);
    exporter("__assign", __assign);
    exporter("__rest", __rest2);
    exporter("__decorate", __decorate);
    exporter("__param", __param);
    exporter("__esDecorate", __esDecorate);
    exporter("__runInitializers", __runInitializers);
    exporter("__propKey", __propKey);
    exporter("__setFunctionName", __setFunctionName);
    exporter("__metadata", __metadata);
    exporter("__awaiter", __awaiter);
    exporter("__generator", __generator);
    exporter("__exportStar", __exportStar);
    exporter("__createBinding", __createBinding);
    exporter("__values", __values2);
    exporter("__read", __read);
    exporter("__spread", __spread);
    exporter("__spreadArrays", __spreadArrays);
    exporter("__spreadArray", __spreadArray);
    exporter("__await", __await2);
    exporter("__asyncGenerator", __asyncGenerator2);
    exporter("__asyncDelegator", __asyncDelegator);
    exporter("__asyncValues", __asyncValues2);
    exporter("__makeTemplateObject", __makeTemplateObject);
    exporter("__importStar", __importStar);
    exporter("__importDefault", __importDefault);
    exporter("__classPrivateFieldGet", __classPrivateFieldGet3);
    exporter("__classPrivateFieldSet", __classPrivateFieldSet3);
    exporter("__classPrivateFieldIn", __classPrivateFieldIn);
    exporter("__addDisposableResource", __addDisposableResource);
    exporter("__disposeResources", __disposeResources);
    exporter("__rewriteRelativeImportExtension", __rewriteRelativeImportExtension);
  });
});

// ../node_modules/.bun/@smithy+uuid@1.1.0/node_modules/@smithy/uuid/dist-cjs/randomUUID.js
var require_randomUUID = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.randomUUID = undefined;
  var tslib_1 = require_tslib();
  var crypto_1 = tslib_1.__importDefault(__require("crypto"));
  exports.randomUUID = crypto_1.default.randomUUID.bind(crypto_1.default);
});

// ../node_modules/.bun/@smithy+uuid@1.1.0/node_modules/@smithy/uuid/dist-cjs/index.js
var require_dist_cjs18 = __commonJS((exports) => {
  var randomUUID = require_randomUUID();
  var decimalToHex = Array.from({ length: 256 }, (_, i) => i.toString(16).padStart(2, "0"));
  var v4 = () => {
    if (randomUUID.randomUUID) {
      return randomUUID.randomUUID();
    }
    const rnds = new Uint8Array(16);
    crypto.getRandomValues(rnds);
    rnds[6] = rnds[6] & 15 | 64;
    rnds[8] = rnds[8] & 63 | 128;
    return decimalToHex[rnds[0]] + decimalToHex[rnds[1]] + decimalToHex[rnds[2]] + decimalToHex[rnds[3]] + "-" + decimalToHex[rnds[4]] + decimalToHex[rnds[5]] + "-" + decimalToHex[rnds[6]] + decimalToHex[rnds[7]] + "-" + decimalToHex[rnds[8]] + decimalToHex[rnds[9]] + "-" + decimalToHex[rnds[10]] + decimalToHex[rnds[11]] + decimalToHex[rnds[12]] + decimalToHex[rnds[13]] + decimalToHex[rnds[14]] + decimalToHex[rnds[15]];
  };
  exports.v4 = v4;
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/submodules/serde/index.js
var require_serde = __commonJS((exports) => {
  var uuid2 = require_dist_cjs18();
  var copyDocumentWithTransform = (source, schemaRef, transform = (_) => _) => source;
  var parseBoolean = (value) => {
    switch (value) {
      case "true":
        return true;
      case "false":
        return false;
      default:
        throw new Error(`Unable to parse boolean value "${value}"`);
    }
  };
  var expectBoolean = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value === "number") {
      if (value === 0 || value === 1) {
        logger.warn(stackTraceWarning(`Expected boolean, got ${typeof value}: ${value}`));
      }
      if (value === 0) {
        return false;
      }
      if (value === 1) {
        return true;
      }
    }
    if (typeof value === "string") {
      const lower = value.toLowerCase();
      if (lower === "false" || lower === "true") {
        logger.warn(stackTraceWarning(`Expected boolean, got ${typeof value}: ${value}`));
      }
      if (lower === "false") {
        return false;
      }
      if (lower === "true") {
        return true;
      }
    }
    if (typeof value === "boolean") {
      return value;
    }
    throw new TypeError(`Expected boolean, got ${typeof value}: ${value}`);
  };
  var expectNumber = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value === "string") {
      const parsed = parseFloat(value);
      if (!Number.isNaN(parsed)) {
        if (String(parsed) !== String(value)) {
          logger.warn(stackTraceWarning(`Expected number but observed string: ${value}`));
        }
        return parsed;
      }
    }
    if (typeof value === "number") {
      return value;
    }
    throw new TypeError(`Expected number, got ${typeof value}: ${value}`);
  };
  var MAX_FLOAT = Math.ceil(2 ** 127 * (2 - 2 ** -23));
  var expectFloat32 = (value) => {
    const expected = expectNumber(value);
    if (expected !== undefined && !Number.isNaN(expected) && expected !== Infinity && expected !== -Infinity) {
      if (Math.abs(expected) > MAX_FLOAT) {
        throw new TypeError(`Expected 32-bit float, got ${value}`);
      }
    }
    return expected;
  };
  var expectLong = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (Number.isInteger(value) && !Number.isNaN(value)) {
      return value;
    }
    throw new TypeError(`Expected integer, got ${typeof value}: ${value}`);
  };
  var expectInt = expectLong;
  var expectInt32 = (value) => expectSizedInt(value, 32);
  var expectShort = (value) => expectSizedInt(value, 16);
  var expectByte = (value) => expectSizedInt(value, 8);
  var expectSizedInt = (value, size) => {
    const expected = expectLong(value);
    if (expected !== undefined && castInt(expected, size) !== expected) {
      throw new TypeError(`Expected ${size}-bit integer, got ${value}`);
    }
    return expected;
  };
  var castInt = (value, size) => {
    switch (size) {
      case 32:
        return Int32Array.of(value)[0];
      case 16:
        return Int16Array.of(value)[0];
      case 8:
        return Int8Array.of(value)[0];
    }
  };
  var expectNonNull = (value, location) => {
    if (value === null || value === undefined) {
      if (location) {
        throw new TypeError(`Expected a non-null value for ${location}`);
      }
      throw new TypeError("Expected a non-null value");
    }
    return value;
  };
  var expectObject = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value === "object" && !Array.isArray(value)) {
      return value;
    }
    const receivedType = Array.isArray(value) ? "array" : typeof value;
    throw new TypeError(`Expected object, got ${receivedType}: ${value}`);
  };
  var expectString = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value === "string") {
      return value;
    }
    if (["boolean", "number", "bigint"].includes(typeof value)) {
      logger.warn(stackTraceWarning(`Expected string, got ${typeof value}: ${value}`));
      return String(value);
    }
    throw new TypeError(`Expected string, got ${typeof value}: ${value}`);
  };
  var expectUnion = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    const asObject = expectObject(value);
    const setKeys = Object.entries(asObject).filter(([, v]) => v != null).map(([k]) => k);
    if (setKeys.length === 0) {
      throw new TypeError(`Unions must have exactly one non-null member. None were found.`);
    }
    if (setKeys.length > 1) {
      throw new TypeError(`Unions must have exactly one non-null member. Keys ${setKeys} were not null.`);
    }
    return asObject;
  };
  var strictParseDouble = (value) => {
    if (typeof value == "string") {
      return expectNumber(parseNumber(value));
    }
    return expectNumber(value);
  };
  var strictParseFloat = strictParseDouble;
  var strictParseFloat32 = (value) => {
    if (typeof value == "string") {
      return expectFloat32(parseNumber(value));
    }
    return expectFloat32(value);
  };
  var NUMBER_REGEX = /(-?(?:0|[1-9]\d*)(?:\.\d+)?(?:[eE][+-]?\d+)?)|(-?Infinity)|(NaN)/g;
  var parseNumber = (value) => {
    const matches = value.match(NUMBER_REGEX);
    if (matches === null || matches[0].length !== value.length) {
      throw new TypeError(`Expected real number, got implicit NaN`);
    }
    return parseFloat(value);
  };
  var limitedParseDouble = (value) => {
    if (typeof value == "string") {
      return parseFloatString(value);
    }
    return expectNumber(value);
  };
  var handleFloat = limitedParseDouble;
  var limitedParseFloat = limitedParseDouble;
  var limitedParseFloat32 = (value) => {
    if (typeof value == "string") {
      return parseFloatString(value);
    }
    return expectFloat32(value);
  };
  var parseFloatString = (value) => {
    switch (value) {
      case "NaN":
        return NaN;
      case "Infinity":
        return Infinity;
      case "-Infinity":
        return -Infinity;
      default:
        throw new Error(`Unable to parse float value: ${value}`);
    }
  };
  var strictParseLong = (value) => {
    if (typeof value === "string") {
      return expectLong(parseNumber(value));
    }
    return expectLong(value);
  };
  var strictParseInt = strictParseLong;
  var strictParseInt32 = (value) => {
    if (typeof value === "string") {
      return expectInt32(parseNumber(value));
    }
    return expectInt32(value);
  };
  var strictParseShort = (value) => {
    if (typeof value === "string") {
      return expectShort(parseNumber(value));
    }
    return expectShort(value);
  };
  var strictParseByte = (value) => {
    if (typeof value === "string") {
      return expectByte(parseNumber(value));
    }
    return expectByte(value);
  };
  var stackTraceWarning = (message) => {
    return String(new TypeError(message).stack || message).split(`
`).slice(0, 5).filter((s) => !s.includes("stackTraceWarning")).join(`
`);
  };
  var logger = {
    warn: console.warn
  };
  var DAYS = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  var MONTHS = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
  function dateToUtcString(date2) {
    const year2 = date2.getUTCFullYear();
    const month = date2.getUTCMonth();
    const dayOfWeek = date2.getUTCDay();
    const dayOfMonthInt = date2.getUTCDate();
    const hoursInt = date2.getUTCHours();
    const minutesInt = date2.getUTCMinutes();
    const secondsInt = date2.getUTCSeconds();
    const dayOfMonthString = dayOfMonthInt < 10 ? `0${dayOfMonthInt}` : `${dayOfMonthInt}`;
    const hoursString = hoursInt < 10 ? `0${hoursInt}` : `${hoursInt}`;
    const minutesString = minutesInt < 10 ? `0${minutesInt}` : `${minutesInt}`;
    const secondsString = secondsInt < 10 ? `0${secondsInt}` : `${secondsInt}`;
    return `${DAYS[dayOfWeek]}, ${dayOfMonthString} ${MONTHS[month]} ${year2} ${hoursString}:${minutesString}:${secondsString} GMT`;
  }
  var RFC3339 = new RegExp(/^(\d{4})-(\d{2})-(\d{2})[tT](\d{2}):(\d{2}):(\d{2})(?:\.(\d+))?[zZ]$/);
  var parseRfc3339DateTime = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value !== "string") {
      throw new TypeError("RFC-3339 date-times must be expressed as strings");
    }
    const match2 = RFC3339.exec(value);
    if (!match2) {
      throw new TypeError("Invalid RFC-3339 date-time value");
    }
    const [_, yearStr, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds] = match2;
    const year2 = strictParseShort(stripLeadingZeroes(yearStr));
    const month = parseDateValue(monthStr, "month", 1, 12);
    const day = parseDateValue(dayStr, "day", 1, 31);
    return buildDate(year2, month, day, { hours, minutes, seconds, fractionalMilliseconds });
  };
  var RFC3339_WITH_OFFSET$1 = new RegExp(/^(\d{4})-(\d{2})-(\d{2})[tT](\d{2}):(\d{2}):(\d{2})(?:\.(\d+))?(([-+]\d{2}\:\d{2})|[zZ])$/);
  var parseRfc3339DateTimeWithOffset = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value !== "string") {
      throw new TypeError("RFC-3339 date-times must be expressed as strings");
    }
    const match2 = RFC3339_WITH_OFFSET$1.exec(value);
    if (!match2) {
      throw new TypeError("Invalid RFC-3339 date-time value");
    }
    const [_, yearStr, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds, offsetStr] = match2;
    const year2 = strictParseShort(stripLeadingZeroes(yearStr));
    const month = parseDateValue(monthStr, "month", 1, 12);
    const day = parseDateValue(dayStr, "day", 1, 31);
    const date2 = buildDate(year2, month, day, { hours, minutes, seconds, fractionalMilliseconds });
    if (offsetStr.toUpperCase() != "Z") {
      date2.setTime(date2.getTime() - parseOffsetToMilliseconds(offsetStr));
    }
    return date2;
  };
  var IMF_FIXDATE$1 = new RegExp(/^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d{2}) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? GMT$/);
  var RFC_850_DATE$1 = new RegExp(/^(?:Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\d{2})-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d{2}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? GMT$/);
  var ASC_TIME$1 = new RegExp(/^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( [1-9]|\d{2}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? (\d{4})$/);
  var parseRfc7231DateTime = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    if (typeof value !== "string") {
      throw new TypeError("RFC-7231 date-times must be expressed as strings");
    }
    let match2 = IMF_FIXDATE$1.exec(value);
    if (match2) {
      const [_, dayStr, monthStr, yearStr, hours, minutes, seconds, fractionalMilliseconds] = match2;
      return buildDate(strictParseShort(stripLeadingZeroes(yearStr)), parseMonthByShortName(monthStr), parseDateValue(dayStr, "day", 1, 31), { hours, minutes, seconds, fractionalMilliseconds });
    }
    match2 = RFC_850_DATE$1.exec(value);
    if (match2) {
      const [_, dayStr, monthStr, yearStr, hours, minutes, seconds, fractionalMilliseconds] = match2;
      return adjustRfc850Year(buildDate(parseTwoDigitYear(yearStr), parseMonthByShortName(monthStr), parseDateValue(dayStr, "day", 1, 31), {
        hours,
        minutes,
        seconds,
        fractionalMilliseconds
      }));
    }
    match2 = ASC_TIME$1.exec(value);
    if (match2) {
      const [_, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds, yearStr] = match2;
      return buildDate(strictParseShort(stripLeadingZeroes(yearStr)), parseMonthByShortName(monthStr), parseDateValue(dayStr.trimLeft(), "day", 1, 31), { hours, minutes, seconds, fractionalMilliseconds });
    }
    throw new TypeError("Invalid RFC-7231 date-time value");
  };
  var parseEpochTimestamp = (value) => {
    if (value === null || value === undefined) {
      return;
    }
    let valueAsDouble;
    if (typeof value === "number") {
      valueAsDouble = value;
    } else if (typeof value === "string") {
      valueAsDouble = strictParseDouble(value);
    } else if (typeof value === "object" && value.tag === 1) {
      valueAsDouble = value.value;
    } else {
      throw new TypeError("Epoch timestamps must be expressed as floating point numbers or their string representation");
    }
    if (Number.isNaN(valueAsDouble) || valueAsDouble === Infinity || valueAsDouble === -Infinity) {
      throw new TypeError("Epoch timestamps must be valid, non-Infinite, non-NaN numerics");
    }
    return new Date(Math.round(valueAsDouble * 1000));
  };
  var buildDate = (year2, month, day, time2) => {
    const adjustedMonth = month - 1;
    validateDayOfMonth(year2, adjustedMonth, day);
    return new Date(Date.UTC(year2, adjustedMonth, day, parseDateValue(time2.hours, "hour", 0, 23), parseDateValue(time2.minutes, "minute", 0, 59), parseDateValue(time2.seconds, "seconds", 0, 60), parseMilliseconds(time2.fractionalMilliseconds)));
  };
  var parseTwoDigitYear = (value) => {
    const thisYear = new Date().getUTCFullYear();
    const valueInThisCentury = Math.floor(thisYear / 100) * 100 + strictParseShort(stripLeadingZeroes(value));
    if (valueInThisCentury < thisYear) {
      return valueInThisCentury + 100;
    }
    return valueInThisCentury;
  };
  var FIFTY_YEARS_IN_MILLIS = 50 * 365 * 24 * 60 * 60 * 1000;
  var adjustRfc850Year = (input) => {
    if (input.getTime() - new Date().getTime() > FIFTY_YEARS_IN_MILLIS) {
      return new Date(Date.UTC(input.getUTCFullYear() - 100, input.getUTCMonth(), input.getUTCDate(), input.getUTCHours(), input.getUTCMinutes(), input.getUTCSeconds(), input.getUTCMilliseconds()));
    }
    return input;
  };
  var parseMonthByShortName = (value) => {
    const monthIdx = MONTHS.indexOf(value);
    if (monthIdx < 0) {
      throw new TypeError(`Invalid month: ${value}`);
    }
    return monthIdx + 1;
  };
  var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var validateDayOfMonth = (year2, month, day) => {
    let maxDays = DAYS_IN_MONTH[month];
    if (month === 1 && isLeapYear(year2)) {
      maxDays = 29;
    }
    if (day > maxDays) {
      throw new TypeError(`Invalid day for ${MONTHS[month]} in ${year2}: ${day}`);
    }
  };
  var isLeapYear = (year2) => {
    return year2 % 4 === 0 && (year2 % 100 !== 0 || year2 % 400 === 0);
  };
  var parseDateValue = (value, type, lower, upper) => {
    const dateVal = strictParseByte(stripLeadingZeroes(value));
    if (dateVal < lower || dateVal > upper) {
      throw new TypeError(`${type} must be between ${lower} and ${upper}, inclusive`);
    }
    return dateVal;
  };
  var parseMilliseconds = (value) => {
    if (value === null || value === undefined) {
      return 0;
    }
    return strictParseFloat32("0." + value) * 1000;
  };
  var parseOffsetToMilliseconds = (value) => {
    const directionStr = value[0];
    let direction = 1;
    if (directionStr == "+") {
      direction = 1;
    } else if (directionStr == "-") {
      direction = -1;
    } else {
      throw new TypeError(`Offset direction, ${directionStr}, must be "+" or "-"`);
    }
    const hour = Number(value.substring(1, 3));
    const minute = Number(value.substring(4, 6));
    return direction * (hour * 60 + minute) * 60 * 1000;
  };
  var stripLeadingZeroes = (value) => {
    let idx = 0;
    while (idx < value.length - 1 && value.charAt(idx) === "0") {
      idx++;
    }
    if (idx === 0) {
      return value;
    }
    return value.slice(idx);
  };
  var LazyJsonString = function LazyJsonString2(val) {
    const str2 = Object.assign(new String(val), {
      deserializeJSON() {
        return JSON.parse(String(val));
      },
      toString() {
        return String(val);
      },
      toJSON() {
        return String(val);
      }
    });
    return str2;
  };
  LazyJsonString.from = (object) => {
    if (object && typeof object === "object" && (object instanceof LazyJsonString || ("deserializeJSON" in object))) {
      return object;
    } else if (typeof object === "string" || Object.getPrototypeOf(object) === String.prototype) {
      return LazyJsonString(String(object));
    }
    return LazyJsonString(JSON.stringify(object));
  };
  LazyJsonString.fromObject = LazyJsonString.from;
  function quoteHeader(part) {
    if (part.includes(",") || part.includes('"')) {
      part = `"${part.replace(/"/g, "\\\"")}"`;
    }
    return part;
  }
  var ddd = `(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun)(?:[ne|u?r]?s?day)?`;
  var mmm = `(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)`;
  var time = `(\\d?\\d):(\\d{2}):(\\d{2})(?:\\.(\\d+))?`;
  var date = `(\\d?\\d)`;
  var year = `(\\d{4})`;
  var RFC3339_WITH_OFFSET = new RegExp(/^(\d{4})-(\d\d)-(\d\d)[tT](\d\d):(\d\d):(\d\d)(\.(\d+))?(([-+]\d\d:\d\d)|[zZ])$/);
  var IMF_FIXDATE = new RegExp(`^${ddd}, ${date} ${mmm} ${year} ${time} GMT$`);
  var RFC_850_DATE = new RegExp(`^${ddd}, ${date}-${mmm}-(\\d\\d) ${time} GMT$`);
  var ASC_TIME = new RegExp(`^${ddd} ${mmm} ( [1-9]|\\d\\d) ${time} ${year}$`);
  var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
  var _parseEpochTimestamp = (value) => {
    if (value == null) {
      return;
    }
    let num = NaN;
    if (typeof value === "number") {
      num = value;
    } else if (typeof value === "string") {
      if (!/^-?\d*\.?\d+$/.test(value)) {
        throw new TypeError(`parseEpochTimestamp - numeric string invalid.`);
      }
      num = Number.parseFloat(value);
    } else if (typeof value === "object" && value.tag === 1) {
      num = value.value;
    }
    if (isNaN(num) || Math.abs(num) === Infinity) {
      throw new TypeError("Epoch timestamps must be valid finite numbers.");
    }
    return new Date(Math.round(num * 1000));
  };
  var _parseRfc3339DateTimeWithOffset = (value) => {
    if (value == null) {
      return;
    }
    if (typeof value !== "string") {
      throw new TypeError("RFC3339 timestamps must be strings");
    }
    const matches = RFC3339_WITH_OFFSET.exec(value);
    if (!matches) {
      throw new TypeError(`Invalid RFC3339 timestamp format ${value}`);
    }
    const [, yearStr, monthStr, dayStr, hours, minutes, seconds, , ms, offsetStr] = matches;
    range(monthStr, 1, 12);
    range(dayStr, 1, 31);
    range(hours, 0, 23);
    range(minutes, 0, 59);
    range(seconds, 0, 60);
    const date2 = new Date(Date.UTC(Number(yearStr), Number(monthStr) - 1, Number(dayStr), Number(hours), Number(minutes), Number(seconds), Number(ms) ? Math.round(parseFloat(`0.${ms}`) * 1000) : 0));
    date2.setUTCFullYear(Number(yearStr));
    if (offsetStr.toUpperCase() != "Z") {
      const [, sign, offsetH, offsetM] = /([+-])(\d\d):(\d\d)/.exec(offsetStr) || [undefined, "+", 0, 0];
      const scalar = sign === "-" ? 1 : -1;
      date2.setTime(date2.getTime() + scalar * (Number(offsetH) * 60 * 60 * 1000 + Number(offsetM) * 60 * 1000));
    }
    return date2;
  };
  var _parseRfc7231DateTime = (value) => {
    if (value == null) {
      return;
    }
    if (typeof value !== "string") {
      throw new TypeError("RFC7231 timestamps must be strings.");
    }
    let day;
    let month;
    let year2;
    let hour;
    let minute;
    let second;
    let fraction;
    let matches;
    if (matches = IMF_FIXDATE.exec(value)) {
      [, day, month, year2, hour, minute, second, fraction] = matches;
    } else if (matches = RFC_850_DATE.exec(value)) {
      [, day, month, year2, hour, minute, second, fraction] = matches;
      year2 = (Number(year2) + 1900).toString();
    } else if (matches = ASC_TIME.exec(value)) {
      [, month, day, hour, minute, second, fraction, year2] = matches;
    }
    if (year2 && second) {
      const timestamp = Date.UTC(Number(year2), months.indexOf(month), Number(day), Number(hour), Number(minute), Number(second), fraction ? Math.round(parseFloat(`0.${fraction}`) * 1000) : 0);
      range(day, 1, 31);
      range(hour, 0, 23);
      range(minute, 0, 59);
      range(second, 0, 60);
      const date2 = new Date(timestamp);
      date2.setUTCFullYear(Number(year2));
      return date2;
    }
    throw new TypeError(`Invalid RFC7231 date-time value ${value}.`);
  };
  function range(v, min, max) {
    const _v = Number(v);
    if (_v < min || _v > max) {
      throw new Error(`Value ${_v} out of range [${min}, ${max}]`);
    }
  }
  function splitEvery(value, delimiter, numDelimiters) {
    if (numDelimiters <= 0 || !Number.isInteger(numDelimiters)) {
      throw new Error("Invalid number of delimiters (" + numDelimiters + ") for splitEvery.");
    }
    const segments = value.split(delimiter);
    if (numDelimiters === 1) {
      return segments;
    }
    const compoundSegments = [];
    let currentSegment = "";
    for (let i = 0;i < segments.length; i++) {
      if (currentSegment === "") {
        currentSegment = segments[i];
      } else {
        currentSegment += delimiter + segments[i];
      }
      if ((i + 1) % numDelimiters === 0) {
        compoundSegments.push(currentSegment);
        currentSegment = "";
      }
    }
    if (currentSegment !== "") {
      compoundSegments.push(currentSegment);
    }
    return compoundSegments;
  }
  var splitHeader = (value) => {
    const z = value.length;
    const values2 = [];
    let withinQuotes = false;
    let prevChar = undefined;
    let anchor = 0;
    for (let i = 0;i < z; ++i) {
      const char = value[i];
      switch (char) {
        case `"`:
          if (prevChar !== "\\") {
            withinQuotes = !withinQuotes;
          }
          break;
        case ",":
          if (!withinQuotes) {
            values2.push(value.slice(anchor, i));
            anchor = i + 1;
          }
          break;
      }
      prevChar = char;
    }
    values2.push(value.slice(anchor));
    return values2.map((v) => {
      v = v.trim();
      const z2 = v.length;
      if (z2 < 2) {
        return v;
      }
      if (v[0] === `"` && v[z2 - 1] === `"`) {
        v = v.slice(1, z2 - 1);
      }
      return v.replace(/\\"/g, '"');
    });
  };
  var format = /^-?\d*(\.\d+)?$/;

  class NumericValue {
    string;
    type;
    constructor(string, type) {
      this.string = string;
      this.type = type;
      if (!format.test(string)) {
        throw new Error(`@smithy/core/serde - NumericValue must only contain [0-9], at most one decimal point ".", and an optional negation prefix "-".`);
      }
    }
    toString() {
      return this.string;
    }
    static [Symbol.hasInstance](object) {
      if (!object || typeof object !== "object") {
        return false;
      }
      const _nv = object;
      return NumericValue.prototype.isPrototypeOf(object) || _nv.type === "bigDecimal" && format.test(_nv.string);
    }
  }
  function nv(input) {
    return new NumericValue(String(input), "bigDecimal");
  }
  Object.defineProperty(exports, "generateIdempotencyToken", {
    enumerable: true,
    get: function() {
      return uuid2.v4;
    }
  });
  exports.LazyJsonString = LazyJsonString;
  exports.NumericValue = NumericValue;
  exports._parseEpochTimestamp = _parseEpochTimestamp;
  exports._parseRfc3339DateTimeWithOffset = _parseRfc3339DateTimeWithOffset;
  exports._parseRfc7231DateTime = _parseRfc7231DateTime;
  exports.copyDocumentWithTransform = copyDocumentWithTransform;
  exports.dateToUtcString = dateToUtcString;
  exports.expectBoolean = expectBoolean;
  exports.expectByte = expectByte;
  exports.expectFloat32 = expectFloat32;
  exports.expectInt = expectInt;
  exports.expectInt32 = expectInt32;
  exports.expectLong = expectLong;
  exports.expectNonNull = expectNonNull;
  exports.expectNumber = expectNumber;
  exports.expectObject = expectObject;
  exports.expectShort = expectShort;
  exports.expectString = expectString;
  exports.expectUnion = expectUnion;
  exports.handleFloat = handleFloat;
  exports.limitedParseDouble = limitedParseDouble;
  exports.limitedParseFloat = limitedParseFloat;
  exports.limitedParseFloat32 = limitedParseFloat32;
  exports.logger = logger;
  exports.nv = nv;
  exports.parseBoolean = parseBoolean;
  exports.parseEpochTimestamp = parseEpochTimestamp;
  exports.parseRfc3339DateTime = parseRfc3339DateTime;
  exports.parseRfc3339DateTimeWithOffset = parseRfc3339DateTimeWithOffset;
  exports.parseRfc7231DateTime = parseRfc7231DateTime;
  exports.quoteHeader = quoteHeader;
  exports.splitEvery = splitEvery;
  exports.splitHeader = splitHeader;
  exports.strictParseByte = strictParseByte;
  exports.strictParseDouble = strictParseDouble;
  exports.strictParseFloat = strictParseFloat;
  exports.strictParseFloat32 = strictParseFloat32;
  exports.strictParseInt = strictParseInt;
  exports.strictParseInt32 = strictParseInt32;
  exports.strictParseLong = strictParseLong;
  exports.strictParseShort = strictParseShort;
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/submodules/event-streams/index.js
var require_event_streams = __commonJS((exports) => {
  var utilUtf8 = require_dist_cjs10();

  class EventStreamSerde {
    marshaller;
    serializer;
    deserializer;
    serdeContext;
    defaultContentType;
    constructor({ marshaller, serializer, deserializer, serdeContext, defaultContentType }) {
      this.marshaller = marshaller;
      this.serializer = serializer;
      this.deserializer = deserializer;
      this.serdeContext = serdeContext;
      this.defaultContentType = defaultContentType;
    }
    async serializeEventStream({ eventStream, requestSchema, initialRequest }) {
      const marshaller = this.marshaller;
      const eventStreamMember = requestSchema.getEventStreamMember();
      const unionSchema = requestSchema.getMemberSchema(eventStreamMember);
      const serializer = this.serializer;
      const defaultContentType = this.defaultContentType;
      const initialRequestMarker = Symbol("initialRequestMarker");
      const eventStreamIterable = {
        async* [Symbol.asyncIterator]() {
          if (initialRequest) {
            const headers = {
              ":event-type": { type: "string", value: "initial-request" },
              ":message-type": { type: "string", value: "event" },
              ":content-type": { type: "string", value: defaultContentType }
            };
            serializer.write(requestSchema, initialRequest);
            const body = serializer.flush();
            yield {
              [initialRequestMarker]: true,
              headers,
              body
            };
          }
          for await (const page of eventStream) {
            yield page;
          }
        }
      };
      return marshaller.serialize(eventStreamIterable, (event) => {
        if (event[initialRequestMarker]) {
          return {
            headers: event.headers,
            body: event.body
          };
        }
        const unionMember = Object.keys(event).find((key) => {
          return key !== "__type";
        }) ?? "";
        const { additionalHeaders, body, eventType, explicitPayloadContentType } = this.writeEventBody(unionMember, unionSchema, event);
        const headers = {
          ":event-type": { type: "string", value: eventType },
          ":message-type": { type: "string", value: "event" },
          ":content-type": { type: "string", value: explicitPayloadContentType ?? defaultContentType },
          ...additionalHeaders
        };
        return {
          headers,
          body
        };
      });
    }
    async deserializeEventStream({ response, responseSchema, initialResponseContainer }) {
      const marshaller = this.marshaller;
      const eventStreamMember = responseSchema.getEventStreamMember();
      const unionSchema = responseSchema.getMemberSchema(eventStreamMember);
      const memberSchemas = unionSchema.getMemberSchemas();
      const initialResponseMarker = Symbol("initialResponseMarker");
      const asyncIterable = marshaller.deserialize(response.body, async (event) => {
        const unionMember = Object.keys(event).find((key) => {
          return key !== "__type";
        }) ?? "";
        const body = event[unionMember].body;
        if (unionMember === "initial-response") {
          const dataObject = await this.deserializer.read(responseSchema, body);
          delete dataObject[eventStreamMember];
          return {
            [initialResponseMarker]: true,
            ...dataObject
          };
        } else if (unionMember in memberSchemas) {
          const eventStreamSchema = memberSchemas[unionMember];
          if (eventStreamSchema.isStructSchema()) {
            const out = {};
            let hasBindings = false;
            for (const [name, member] of eventStreamSchema.structIterator()) {
              const { eventHeader, eventPayload } = member.getMergedTraits();
              hasBindings = hasBindings || Boolean(eventHeader || eventPayload);
              if (eventPayload) {
                if (member.isBlobSchema()) {
                  out[name] = body;
                } else if (member.isStringSchema()) {
                  out[name] = (this.serdeContext?.utf8Encoder ?? utilUtf8.toUtf8)(body);
                } else if (member.isStructSchema()) {
                  out[name] = await this.deserializer.read(member, body);
                }
              } else if (eventHeader) {
                const value = event[unionMember].headers[name]?.value;
                if (value != null) {
                  if (member.isNumericSchema()) {
                    if (value && typeof value === "object" && "bytes" in value) {
                      out[name] = BigInt(value.toString());
                    } else {
                      out[name] = Number(value);
                    }
                  } else {
                    out[name] = value;
                  }
                }
              }
            }
            if (hasBindings) {
              return {
                [unionMember]: out
              };
            }
            if (body.byteLength === 0) {
              return {
                [unionMember]: {}
              };
            }
          }
          return {
            [unionMember]: await this.deserializer.read(eventStreamSchema, body)
          };
        } else {
          return {
            $unknown: event
          };
        }
      });
      const asyncIterator = asyncIterable[Symbol.asyncIterator]();
      const firstEvent = await asyncIterator.next();
      if (firstEvent.done) {
        return asyncIterable;
      }
      if (firstEvent.value?.[initialResponseMarker]) {
        if (!responseSchema) {
          throw new Error("@smithy::core/protocols - initial-response event encountered in event stream but no response schema given.");
        }
        for (const [key, value] of Object.entries(firstEvent.value)) {
          initialResponseContainer[key] = value;
        }
      }
      return {
        async* [Symbol.asyncIterator]() {
          if (!firstEvent?.value?.[initialResponseMarker]) {
            yield firstEvent.value;
          }
          while (true) {
            const { done, value } = await asyncIterator.next();
            if (done) {
              break;
            }
            yield value;
          }
        }
      };
    }
    writeEventBody(unionMember, unionSchema, event) {
      const serializer = this.serializer;
      let eventType = unionMember;
      let explicitPayloadMember = null;
      let explicitPayloadContentType;
      const isKnownSchema = (() => {
        const struct = unionSchema.getSchema();
        return struct[4].includes(unionMember);
      })();
      const additionalHeaders = {};
      if (!isKnownSchema) {
        const [type, value] = event[unionMember];
        eventType = type;
        serializer.write(15, value);
      } else {
        const eventSchema = unionSchema.getMemberSchema(unionMember);
        if (eventSchema.isStructSchema()) {
          for (const [memberName, memberSchema] of eventSchema.structIterator()) {
            const { eventHeader, eventPayload } = memberSchema.getMergedTraits();
            if (eventPayload) {
              explicitPayloadMember = memberName;
            } else if (eventHeader) {
              const value = event[unionMember][memberName];
              let type = "binary";
              if (memberSchema.isNumericSchema()) {
                if ((-2) ** 31 <= value && value <= 2 ** 31 - 1) {
                  type = "integer";
                } else {
                  type = "long";
                }
              } else if (memberSchema.isTimestampSchema()) {
                type = "timestamp";
              } else if (memberSchema.isStringSchema()) {
                type = "string";
              } else if (memberSchema.isBooleanSchema()) {
                type = "boolean";
              }
              if (value != null) {
                additionalHeaders[memberName] = {
                  type,
                  value
                };
                delete event[unionMember][memberName];
              }
            }
          }
          if (explicitPayloadMember !== null) {
            const payloadSchema = eventSchema.getMemberSchema(explicitPayloadMember);
            if (payloadSchema.isBlobSchema()) {
              explicitPayloadContentType = "application/octet-stream";
            } else if (payloadSchema.isStringSchema()) {
              explicitPayloadContentType = "text/plain";
            }
            serializer.write(payloadSchema, event[unionMember][explicitPayloadMember]);
          } else {
            serializer.write(eventSchema, event[unionMember]);
          }
        } else if (eventSchema.isUnitSchema()) {
          serializer.write(eventSchema, {});
        } else {
          throw new Error("@smithy/core/event-streams - non-struct member not supported in event stream union.");
        }
      }
      const messageSerialization = serializer.flush();
      const body = typeof messageSerialization === "string" ? (this.serdeContext?.utf8Decoder ?? utilUtf8.fromUtf8)(messageSerialization) : messageSerialization;
      return {
        body,
        eventType,
        explicitPayloadContentType,
        additionalHeaders
      };
    }
  }
  exports.EventStreamSerde = EventStreamSerde;
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/submodules/protocols/index.js
var require_protocols = __commonJS((exports) => {
  var utilStream = require_dist_cjs17();
  var schema = require_schema();
  var serde = require_serde();
  var protocolHttp = require_dist_cjs2();
  var utilBase64 = require_dist_cjs11();
  var utilUtf8 = require_dist_cjs10();
  var collectBody = async (streamBody = new Uint8Array, context) => {
    if (streamBody instanceof Uint8Array) {
      return utilStream.Uint8ArrayBlobAdapter.mutate(streamBody);
    }
    if (!streamBody) {
      return utilStream.Uint8ArrayBlobAdapter.mutate(new Uint8Array);
    }
    const fromContext = context.streamCollector(streamBody);
    return utilStream.Uint8ArrayBlobAdapter.mutate(await fromContext);
  };
  function extendedEncodeURIComponent(str2) {
    return encodeURIComponent(str2).replace(/[!'()*]/g, function(c) {
      return "%" + c.charCodeAt(0).toString(16).toUpperCase();
    });
  }

  class SerdeContext {
    serdeContext;
    setSerdeContext(serdeContext) {
      this.serdeContext = serdeContext;
    }
  }

  class HttpProtocol extends SerdeContext {
    options;
    compositeErrorRegistry;
    constructor(options) {
      super();
      this.options = options;
      this.compositeErrorRegistry = schema.TypeRegistry.for(options.defaultNamespace);
      for (const etr of options.errorTypeRegistries ?? []) {
        this.compositeErrorRegistry.copyFrom(etr);
      }
    }
    getRequestType() {
      return protocolHttp.HttpRequest;
    }
    getResponseType() {
      return protocolHttp.HttpResponse;
    }
    setSerdeContext(serdeContext) {
      this.serdeContext = serdeContext;
      this.serializer.setSerdeContext(serdeContext);
      this.deserializer.setSerdeContext(serdeContext);
      if (this.getPayloadCodec()) {
        this.getPayloadCodec().setSerdeContext(serdeContext);
      }
    }
    updateServiceEndpoint(request, endpoint) {
      if ("url" in endpoint) {
        request.protocol = endpoint.url.protocol;
        request.hostname = endpoint.url.hostname;
        request.port = endpoint.url.port ? Number(endpoint.url.port) : undefined;
        request.path = endpoint.url.pathname;
        request.fragment = endpoint.url.hash || undefined;
        request.username = endpoint.url.username || undefined;
        request.password = endpoint.url.password || undefined;
        if (!request.query) {
          request.query = {};
        }
        for (const [k, v] of endpoint.url.searchParams.entries()) {
          request.query[k] = v;
        }
        return request;
      } else {
        request.protocol = endpoint.protocol;
        request.hostname = endpoint.hostname;
        request.port = endpoint.port ? Number(endpoint.port) : undefined;
        request.path = endpoint.path;
        request.query = {
          ...endpoint.query
        };
        return request;
      }
    }
    setHostPrefix(request, operationSchema, input) {
      if (this.serdeContext?.disableHostPrefix) {
        return;
      }
      const inputNs = schema.NormalizedSchema.of(operationSchema.input);
      const opTraits = schema.translateTraits(operationSchema.traits ?? {});
      if (opTraits.endpoint) {
        let hostPrefix = opTraits.endpoint?.[0];
        if (typeof hostPrefix === "string") {
          const hostLabelInputs = [...inputNs.structIterator()].filter(([, member]) => member.getMergedTraits().hostLabel);
          for (const [name] of hostLabelInputs) {
            const replacement = input[name];
            if (typeof replacement !== "string") {
              throw new Error(`@smithy/core/schema - ${name} in input must be a string as hostLabel.`);
            }
            hostPrefix = hostPrefix.replace(`{${name}}`, replacement);
          }
          request.hostname = hostPrefix + request.hostname;
        }
      }
    }
    deserializeMetadata(output) {
      return {
        httpStatusCode: output.statusCode,
        requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
        extendedRequestId: output.headers["x-amz-id-2"],
        cfId: output.headers["x-amz-cf-id"]
      };
    }
    async serializeEventStream({ eventStream, requestSchema, initialRequest }) {
      const eventStreamSerde = await this.loadEventStreamCapability();
      return eventStreamSerde.serializeEventStream({
        eventStream,
        requestSchema,
        initialRequest
      });
    }
    async deserializeEventStream({ response, responseSchema, initialResponseContainer }) {
      const eventStreamSerde = await this.loadEventStreamCapability();
      return eventStreamSerde.deserializeEventStream({
        response,
        responseSchema,
        initialResponseContainer
      });
    }
    async loadEventStreamCapability() {
      const { EventStreamSerde } = await Promise.resolve().then(() => __toESM(require_event_streams()));
      return new EventStreamSerde({
        marshaller: this.getEventStreamMarshaller(),
        serializer: this.serializer,
        deserializer: this.deserializer,
        serdeContext: this.serdeContext,
        defaultContentType: this.getDefaultContentType()
      });
    }
    getDefaultContentType() {
      throw new Error(`@smithy/core/protocols - ${this.constructor.name} getDefaultContentType() implementation missing.`);
    }
    async deserializeHttpMessage(schema2, context, response, arg4, arg5) {
      return [];
    }
    getEventStreamMarshaller() {
      const context = this.serdeContext;
      if (!context.eventStreamMarshaller) {
        throw new Error("@smithy/core - HttpProtocol: eventStreamMarshaller missing in serdeContext.");
      }
      return context.eventStreamMarshaller;
    }
  }

  class HttpBindingProtocol extends HttpProtocol {
    async serializeRequest(operationSchema, _input, context) {
      const input = {
        ..._input ?? {}
      };
      const serializer = this.serializer;
      const query = {};
      const headers = {};
      const endpoint = await context.endpoint();
      const ns = schema.NormalizedSchema.of(operationSchema?.input);
      const schema$1 = ns.getSchema();
      let hasNonHttpBindingMember = false;
      let payload;
      const request = new protocolHttp.HttpRequest({
        protocol: "",
        hostname: "",
        port: undefined,
        path: "",
        fragment: undefined,
        query,
        headers,
        body: undefined
      });
      if (endpoint) {
        this.updateServiceEndpoint(request, endpoint);
        this.setHostPrefix(request, operationSchema, input);
        const opTraits = schema.translateTraits(operationSchema.traits);
        if (opTraits.http) {
          request.method = opTraits.http[0];
          const [path5, search] = opTraits.http[1].split("?");
          if (request.path == "/") {
            request.path = path5;
          } else {
            request.path += path5;
          }
          const traitSearchParams = new URLSearchParams(search ?? "");
          Object.assign(query, Object.fromEntries(traitSearchParams));
        }
      }
      for (const [memberName, memberNs] of ns.structIterator()) {
        const memberTraits = memberNs.getMergedTraits() ?? {};
        const inputMemberValue = input[memberName];
        if (inputMemberValue == null && !memberNs.isIdempotencyToken()) {
          if (memberTraits.httpLabel) {
            if (request.path.includes(`{${memberName}+}`) || request.path.includes(`{${memberName}}`)) {
              throw new Error(`No value provided for input HTTP label: ${memberName}.`);
            }
          }
          continue;
        }
        if (memberTraits.httpPayload) {
          const isStreaming = memberNs.isStreaming();
          if (isStreaming) {
            const isEventStream = memberNs.isStructSchema();
            if (isEventStream) {
              if (input[memberName]) {
                payload = await this.serializeEventStream({
                  eventStream: input[memberName],
                  requestSchema: ns
                });
              }
            } else {
              payload = inputMemberValue;
            }
          } else {
            serializer.write(memberNs, inputMemberValue);
            payload = serializer.flush();
          }
          delete input[memberName];
        } else if (memberTraits.httpLabel) {
          serializer.write(memberNs, inputMemberValue);
          const replacement = serializer.flush();
          if (request.path.includes(`{${memberName}+}`)) {
            request.path = request.path.replace(`{${memberName}+}`, replacement.split("/").map(extendedEncodeURIComponent).join("/"));
          } else if (request.path.includes(`{${memberName}}`)) {
            request.path = request.path.replace(`{${memberName}}`, extendedEncodeURIComponent(replacement));
          }
          delete input[memberName];
        } else if (memberTraits.httpHeader) {
          serializer.write(memberNs, inputMemberValue);
          headers[memberTraits.httpHeader.toLowerCase()] = String(serializer.flush());
          delete input[memberName];
        } else if (typeof memberTraits.httpPrefixHeaders === "string") {
          for (const [key, val] of Object.entries(inputMemberValue)) {
            const amalgam = memberTraits.httpPrefixHeaders + key;
            serializer.write([memberNs.getValueSchema(), { httpHeader: amalgam }], val);
            headers[amalgam.toLowerCase()] = serializer.flush();
          }
          delete input[memberName];
        } else if (memberTraits.httpQuery || memberTraits.httpQueryParams) {
          this.serializeQuery(memberNs, inputMemberValue, query);
          delete input[memberName];
        } else {
          hasNonHttpBindingMember = true;
        }
      }
      if (hasNonHttpBindingMember && input) {
        serializer.write(schema$1, input);
        payload = serializer.flush();
      }
      request.headers = headers;
      request.query = query;
      request.body = payload;
      return request;
    }
    serializeQuery(ns, data, query) {
      const serializer = this.serializer;
      const traits = ns.getMergedTraits();
      if (traits.httpQueryParams) {
        for (const [key, val] of Object.entries(data)) {
          if (!(key in query)) {
            const valueSchema = ns.getValueSchema();
            Object.assign(valueSchema.getMergedTraits(), {
              ...traits,
              httpQuery: key,
              httpQueryParams: undefined
            });
            this.serializeQuery(valueSchema, val, query);
          }
        }
        return;
      }
      if (ns.isListSchema()) {
        const sparse = !!ns.getMergedTraits().sparse;
        const buffer = [];
        for (const item of data) {
          serializer.write([ns.getValueSchema(), traits], item);
          const serializable = serializer.flush();
          if (sparse || serializable !== undefined) {
            buffer.push(serializable);
          }
        }
        query[traits.httpQuery] = buffer;
      } else {
        serializer.write([ns, traits], data);
        query[traits.httpQuery] = serializer.flush();
      }
    }
    async deserializeResponse(operationSchema, context, response) {
      const deserializer = this.deserializer;
      const ns = schema.NormalizedSchema.of(operationSchema.output);
      const dataObject = {};
      if (response.statusCode >= 300) {
        const bytes = await collectBody(response.body, context);
        if (bytes.byteLength > 0) {
          Object.assign(dataObject, await deserializer.read(15, bytes));
        }
        await this.handleError(operationSchema, context, response, dataObject, this.deserializeMetadata(response));
        throw new Error("@smithy/core/protocols - HTTP Protocol error handler failed to throw.");
      }
      for (const header in response.headers) {
        const value = response.headers[header];
        delete response.headers[header];
        response.headers[header.toLowerCase()] = value;
      }
      const nonHttpBindingMembers = await this.deserializeHttpMessage(ns, context, response, dataObject);
      if (nonHttpBindingMembers.length) {
        const bytes = await collectBody(response.body, context);
        if (bytes.byteLength > 0) {
          const dataFromBody = await deserializer.read(ns, bytes);
          for (const member of nonHttpBindingMembers) {
            if (dataFromBody[member] != null) {
              dataObject[member] = dataFromBody[member];
            }
          }
        }
      } else if (nonHttpBindingMembers.discardResponseBody) {
        await collectBody(response.body, context);
      }
      dataObject.$metadata = this.deserializeMetadata(response);
      return dataObject;
    }
    async deserializeHttpMessage(schema$1, context, response, arg4, arg5) {
      let dataObject;
      if (arg4 instanceof Set) {
        dataObject = arg5;
      } else {
        dataObject = arg4;
      }
      let discardResponseBody = true;
      const deserializer = this.deserializer;
      const ns = schema.NormalizedSchema.of(schema$1);
      const nonHttpBindingMembers = [];
      for (const [memberName, memberSchema] of ns.structIterator()) {
        const memberTraits = memberSchema.getMemberTraits();
        if (memberTraits.httpPayload) {
          discardResponseBody = false;
          const isStreaming = memberSchema.isStreaming();
          if (isStreaming) {
            const isEventStream = memberSchema.isStructSchema();
            if (isEventStream) {
              dataObject[memberName] = await this.deserializeEventStream({
                response,
                responseSchema: ns
              });
            } else {
              dataObject[memberName] = utilStream.sdkStreamMixin(response.body);
            }
          } else if (response.body) {
            const bytes = await collectBody(response.body, context);
            if (bytes.byteLength > 0) {
              dataObject[memberName] = await deserializer.read(memberSchema, bytes);
            }
          }
        } else if (memberTraits.httpHeader) {
          const key = String(memberTraits.httpHeader).toLowerCase();
          const value = response.headers[key];
          if (value != null) {
            if (memberSchema.isListSchema()) {
              const headerListValueSchema = memberSchema.getValueSchema();
              headerListValueSchema.getMergedTraits().httpHeader = key;
              let sections;
              if (headerListValueSchema.isTimestampSchema() && headerListValueSchema.getSchema() === 4) {
                sections = serde.splitEvery(value, ",", 2);
              } else {
                sections = serde.splitHeader(value);
              }
              const list = [];
              for (const section of sections) {
                list.push(await deserializer.read(headerListValueSchema, section.trim()));
              }
              dataObject[memberName] = list;
            } else {
              dataObject[memberName] = await deserializer.read(memberSchema, value);
            }
          }
        } else if (memberTraits.httpPrefixHeaders !== undefined) {
          dataObject[memberName] = {};
          for (const [header, value] of Object.entries(response.headers)) {
            if (header.startsWith(memberTraits.httpPrefixHeaders)) {
              const valueSchema = memberSchema.getValueSchema();
              valueSchema.getMergedTraits().httpHeader = header;
              dataObject[memberName][header.slice(memberTraits.httpPrefixHeaders.length)] = await deserializer.read(valueSchema, value);
            }
          }
        } else if (memberTraits.httpResponseCode) {
          dataObject[memberName] = response.statusCode;
        } else {
          nonHttpBindingMembers.push(memberName);
        }
      }
      nonHttpBindingMembers.discardResponseBody = discardResponseBody;
      return nonHttpBindingMembers;
    }
  }

  class RpcProtocol extends HttpProtocol {
    async serializeRequest(operationSchema, input, context) {
      const serializer = this.serializer;
      const query = {};
      const headers = {};
      const endpoint = await context.endpoint();
      const ns = schema.NormalizedSchema.of(operationSchema?.input);
      const schema$1 = ns.getSchema();
      let payload;
      const request = new protocolHttp.HttpRequest({
        protocol: "",
        hostname: "",
        port: undefined,
        path: "/",
        fragment: undefined,
        query,
        headers,
        body: undefined
      });
      if (endpoint) {
        this.updateServiceEndpoint(request, endpoint);
        this.setHostPrefix(request, operationSchema, input);
      }
      const _input = {
        ...input
      };
      if (input) {
        const eventStreamMember = ns.getEventStreamMember();
        if (eventStreamMember) {
          if (_input[eventStreamMember]) {
            const initialRequest = {};
            for (const [memberName, memberSchema] of ns.structIterator()) {
              if (memberName !== eventStreamMember && _input[memberName]) {
                serializer.write(memberSchema, _input[memberName]);
                initialRequest[memberName] = serializer.flush();
              }
            }
            payload = await this.serializeEventStream({
              eventStream: _input[eventStreamMember],
              requestSchema: ns,
              initialRequest
            });
          }
        } else {
          serializer.write(schema$1, _input);
          payload = serializer.flush();
        }
      }
      request.headers = headers;
      request.query = query;
      request.body = payload;
      request.method = "POST";
      return request;
    }
    async deserializeResponse(operationSchema, context, response) {
      const deserializer = this.deserializer;
      const ns = schema.NormalizedSchema.of(operationSchema.output);
      const dataObject = {};
      if (response.statusCode >= 300) {
        const bytes = await collectBody(response.body, context);
        if (bytes.byteLength > 0) {
          Object.assign(dataObject, await deserializer.read(15, bytes));
        }
        await this.handleError(operationSchema, context, response, dataObject, this.deserializeMetadata(response));
        throw new Error("@smithy/core/protocols - RPC Protocol error handler failed to throw.");
      }
      for (const header in response.headers) {
        const value = response.headers[header];
        delete response.headers[header];
        response.headers[header.toLowerCase()] = value;
      }
      const eventStreamMember = ns.getEventStreamMember();
      if (eventStreamMember) {
        dataObject[eventStreamMember] = await this.deserializeEventStream({
          response,
          responseSchema: ns,
          initialResponseContainer: dataObject
        });
      } else {
        const bytes = await collectBody(response.body, context);
        if (bytes.byteLength > 0) {
          Object.assign(dataObject, await deserializer.read(ns, bytes));
        }
      }
      dataObject.$metadata = this.deserializeMetadata(response);
      return dataObject;
    }
  }
  var resolvedPath = (resolvedPath2, input, memberName, labelValueProvider, uriLabel, isGreedyLabel) => {
    if (input != null && input[memberName] !== undefined) {
      const labelValue = labelValueProvider();
      if (labelValue.length <= 0) {
        throw new Error("Empty value provided for input HTTP label: " + memberName + ".");
      }
      resolvedPath2 = resolvedPath2.replace(uriLabel, isGreedyLabel ? labelValue.split("/").map((segment) => extendedEncodeURIComponent(segment)).join("/") : extendedEncodeURIComponent(labelValue));
    } else {
      throw new Error("No value provided for input HTTP label: " + memberName + ".");
    }
    return resolvedPath2;
  };
  function requestBuilder(input, context) {
    return new RequestBuilder(input, context);
  }

  class RequestBuilder {
    input;
    context;
    query = {};
    method = "";
    headers = {};
    path = "";
    body = null;
    hostname = "";
    resolvePathStack = [];
    constructor(input, context) {
      this.input = input;
      this.context = context;
    }
    async build() {
      const { hostname, protocol = "https", port, path: basePath } = await this.context.endpoint();
      this.path = basePath;
      for (const resolvePath of this.resolvePathStack) {
        resolvePath(this.path);
      }
      return new protocolHttp.HttpRequest({
        protocol,
        hostname: this.hostname || hostname,
        port,
        method: this.method,
        path: this.path,
        query: this.query,
        body: this.body,
        headers: this.headers
      });
    }
    hn(hostname) {
      this.hostname = hostname;
      return this;
    }
    bp(uriLabel) {
      this.resolvePathStack.push((basePath) => {
        this.path = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + uriLabel;
      });
      return this;
    }
    p(memberName, labelValueProvider, uriLabel, isGreedyLabel) {
      this.resolvePathStack.push((path5) => {
        this.path = resolvedPath(path5, this.input, memberName, labelValueProvider, uriLabel, isGreedyLabel);
      });
      return this;
    }
    h(headers) {
      this.headers = headers;
      return this;
    }
    q(query) {
      this.query = query;
      return this;
    }
    b(body) {
      this.body = body;
      return this;
    }
    m(method) {
      this.method = method;
      return this;
    }
  }
  function determineTimestampFormat(ns, settings) {
    if (settings.timestampFormat.useTrait) {
      if (ns.isTimestampSchema() && (ns.getSchema() === 5 || ns.getSchema() === 6 || ns.getSchema() === 7)) {
        return ns.getSchema();
      }
    }
    const { httpLabel, httpPrefixHeaders, httpHeader, httpQuery } = ns.getMergedTraits();
    const bindingFormat = settings.httpBindings ? typeof httpPrefixHeaders === "string" || Boolean(httpHeader) ? 6 : Boolean(httpQuery) || Boolean(httpLabel) ? 5 : undefined : undefined;
    return bindingFormat ?? settings.timestampFormat.default;
  }

  class FromStringShapeDeserializer extends SerdeContext {
    settings;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    read(_schema, data) {
      const ns = schema.NormalizedSchema.of(_schema);
      if (ns.isListSchema()) {
        return serde.splitHeader(data).map((item) => this.read(ns.getValueSchema(), item));
      }
      if (ns.isBlobSchema()) {
        return (this.serdeContext?.base64Decoder ?? utilBase64.fromBase64)(data);
      }
      if (ns.isTimestampSchema()) {
        const format = determineTimestampFormat(ns, this.settings);
        switch (format) {
          case 5:
            return serde._parseRfc3339DateTimeWithOffset(data);
          case 6:
            return serde._parseRfc7231DateTime(data);
          case 7:
            return serde._parseEpochTimestamp(data);
          default:
            console.warn("Missing timestamp format, parsing value with Date constructor:", data);
            return new Date(data);
        }
      }
      if (ns.isStringSchema()) {
        const mediaType = ns.getMergedTraits().mediaType;
        let intermediateValue = data;
        if (mediaType) {
          if (ns.getMergedTraits().httpHeader) {
            intermediateValue = this.base64ToUtf8(intermediateValue);
          }
          const isJson = mediaType === "application/json" || mediaType.endsWith("+json");
          if (isJson) {
            intermediateValue = serde.LazyJsonString.from(intermediateValue);
          }
          return intermediateValue;
        }
      }
      if (ns.isNumericSchema()) {
        return Number(data);
      }
      if (ns.isBigIntegerSchema()) {
        return BigInt(data);
      }
      if (ns.isBigDecimalSchema()) {
        return new serde.NumericValue(data, "bigDecimal");
      }
      if (ns.isBooleanSchema()) {
        return String(data).toLowerCase() === "true";
      }
      return data;
    }
    base64ToUtf8(base64String) {
      return (this.serdeContext?.utf8Encoder ?? utilUtf8.toUtf8)((this.serdeContext?.base64Decoder ?? utilBase64.fromBase64)(base64String));
    }
  }

  class HttpInterceptingShapeDeserializer extends SerdeContext {
    codecDeserializer;
    stringDeserializer;
    constructor(codecDeserializer, codecSettings) {
      super();
      this.codecDeserializer = codecDeserializer;
      this.stringDeserializer = new FromStringShapeDeserializer(codecSettings);
    }
    setSerdeContext(serdeContext) {
      this.stringDeserializer.setSerdeContext(serdeContext);
      this.codecDeserializer.setSerdeContext(serdeContext);
      this.serdeContext = serdeContext;
    }
    read(schema$1, data) {
      const ns = schema.NormalizedSchema.of(schema$1);
      const traits = ns.getMergedTraits();
      const toString = this.serdeContext?.utf8Encoder ?? utilUtf8.toUtf8;
      if (traits.httpHeader || traits.httpResponseCode) {
        return this.stringDeserializer.read(ns, toString(data));
      }
      if (traits.httpPayload) {
        if (ns.isBlobSchema()) {
          const toBytes = this.serdeContext?.utf8Decoder ?? utilUtf8.fromUtf8;
          if (typeof data === "string") {
            return toBytes(data);
          }
          return data;
        } else if (ns.isStringSchema()) {
          if ("byteLength" in data) {
            return toString(data);
          }
          return data;
        }
      }
      return this.codecDeserializer.read(ns, data);
    }
  }

  class ToStringShapeSerializer extends SerdeContext {
    settings;
    stringBuffer = "";
    constructor(settings) {
      super();
      this.settings = settings;
    }
    write(schema$1, value) {
      const ns = schema.NormalizedSchema.of(schema$1);
      switch (typeof value) {
        case "object":
          if (value === null) {
            this.stringBuffer = "null";
            return;
          }
          if (ns.isTimestampSchema()) {
            if (!(value instanceof Date)) {
              throw new Error(`@smithy/core/protocols - received non-Date value ${value} when schema expected Date in ${ns.getName(true)}`);
            }
            const format = determineTimestampFormat(ns, this.settings);
            switch (format) {
              case 5:
                this.stringBuffer = value.toISOString().replace(".000Z", "Z");
                break;
              case 6:
                this.stringBuffer = serde.dateToUtcString(value);
                break;
              case 7:
                this.stringBuffer = String(value.getTime() / 1000);
                break;
              default:
                console.warn("Missing timestamp format, using epoch seconds", value);
                this.stringBuffer = String(value.getTime() / 1000);
            }
            return;
          }
          if (ns.isBlobSchema() && "byteLength" in value) {
            this.stringBuffer = (this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(value);
            return;
          }
          if (ns.isListSchema() && Array.isArray(value)) {
            let buffer = "";
            for (const item of value) {
              this.write([ns.getValueSchema(), ns.getMergedTraits()], item);
              const headerItem = this.flush();
              const serialized = ns.getValueSchema().isTimestampSchema() ? headerItem : serde.quoteHeader(headerItem);
              if (buffer !== "") {
                buffer += ", ";
              }
              buffer += serialized;
            }
            this.stringBuffer = buffer;
            return;
          }
          this.stringBuffer = JSON.stringify(value, null, 2);
          break;
        case "string":
          const mediaType = ns.getMergedTraits().mediaType;
          let intermediateValue = value;
          if (mediaType) {
            const isJson = mediaType === "application/json" || mediaType.endsWith("+json");
            if (isJson) {
              intermediateValue = serde.LazyJsonString.from(intermediateValue);
            }
            if (ns.getMergedTraits().httpHeader) {
              this.stringBuffer = (this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(intermediateValue.toString());
              return;
            }
          }
          this.stringBuffer = value;
          break;
        default:
          if (ns.isIdempotencyToken()) {
            this.stringBuffer = serde.generateIdempotencyToken();
          } else {
            this.stringBuffer = String(value);
          }
      }
    }
    flush() {
      const buffer = this.stringBuffer;
      this.stringBuffer = "";
      return buffer;
    }
  }

  class HttpInterceptingShapeSerializer {
    codecSerializer;
    stringSerializer;
    buffer;
    constructor(codecSerializer, codecSettings, stringSerializer = new ToStringShapeSerializer(codecSettings)) {
      this.codecSerializer = codecSerializer;
      this.stringSerializer = stringSerializer;
    }
    setSerdeContext(serdeContext) {
      this.codecSerializer.setSerdeContext(serdeContext);
      this.stringSerializer.setSerdeContext(serdeContext);
    }
    write(schema$1, value) {
      const ns = schema.NormalizedSchema.of(schema$1);
      const traits = ns.getMergedTraits();
      if (traits.httpHeader || traits.httpLabel || traits.httpQuery) {
        this.stringSerializer.write(ns, value);
        this.buffer = this.stringSerializer.flush();
        return;
      }
      return this.codecSerializer.write(ns, value);
    }
    flush() {
      if (this.buffer !== undefined) {
        const buffer = this.buffer;
        this.buffer = undefined;
        return buffer;
      }
      return this.codecSerializer.flush();
    }
  }
  exports.FromStringShapeDeserializer = FromStringShapeDeserializer;
  exports.HttpBindingProtocol = HttpBindingProtocol;
  exports.HttpInterceptingShapeDeserializer = HttpInterceptingShapeDeserializer;
  exports.HttpInterceptingShapeSerializer = HttpInterceptingShapeSerializer;
  exports.HttpProtocol = HttpProtocol;
  exports.RequestBuilder = RequestBuilder;
  exports.RpcProtocol = RpcProtocol;
  exports.SerdeContext = SerdeContext;
  exports.ToStringShapeSerializer = ToStringShapeSerializer;
  exports.collectBody = collectBody;
  exports.determineTimestampFormat = determineTimestampFormat;
  exports.extendedEncodeURIComponent = extendedEncodeURIComponent;
  exports.requestBuilder = requestBuilder;
  exports.resolvedPath = resolvedPath;
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/index.js
var require_dist_cjs19 = __commonJS((exports) => {
  var types = require_dist_cjs();
  var utilMiddleware = require_dist_cjs6();
  var middlewareSerde = require_dist_cjs7();
  var protocolHttp = require_dist_cjs2();
  var protocols = require_protocols();
  var getSmithyContext = (context) => context[types.SMITHY_CONTEXT_KEY] || (context[types.SMITHY_CONTEXT_KEY] = {});
  var resolveAuthOptions = (candidateAuthOptions, authSchemePreference) => {
    if (!authSchemePreference || authSchemePreference.length === 0) {
      return candidateAuthOptions;
    }
    const preferredAuthOptions = [];
    for (const preferredSchemeName of authSchemePreference) {
      for (const candidateAuthOption of candidateAuthOptions) {
        const candidateAuthSchemeName = candidateAuthOption.schemeId.split("#")[1];
        if (candidateAuthSchemeName === preferredSchemeName) {
          preferredAuthOptions.push(candidateAuthOption);
        }
      }
    }
    for (const candidateAuthOption of candidateAuthOptions) {
      if (!preferredAuthOptions.find(({ schemeId }) => schemeId === candidateAuthOption.schemeId)) {
        preferredAuthOptions.push(candidateAuthOption);
      }
    }
    return preferredAuthOptions;
  };
  function convertHttpAuthSchemesToMap(httpAuthSchemes) {
    const map = new Map;
    for (const scheme of httpAuthSchemes) {
      map.set(scheme.schemeId, scheme);
    }
    return map;
  }
  var httpAuthSchemeMiddleware = (config, mwOptions) => (next, context) => async (args) => {
    const options = config.httpAuthSchemeProvider(await mwOptions.httpAuthSchemeParametersProvider(config, context, args.input));
    const authSchemePreference = config.authSchemePreference ? await config.authSchemePreference() : [];
    const resolvedOptions = resolveAuthOptions(options, authSchemePreference);
    const authSchemes = convertHttpAuthSchemesToMap(config.httpAuthSchemes);
    const smithyContext = utilMiddleware.getSmithyContext(context);
    const failureReasons = [];
    for (const option of resolvedOptions) {
      const scheme = authSchemes.get(option.schemeId);
      if (!scheme) {
        failureReasons.push(`HttpAuthScheme \`${option.schemeId}\` was not enabled for this service.`);
        continue;
      }
      const identityProvider = scheme.identityProvider(await mwOptions.identityProviderConfigProvider(config));
      if (!identityProvider) {
        failureReasons.push(`HttpAuthScheme \`${option.schemeId}\` did not have an IdentityProvider configured.`);
        continue;
      }
      const { identityProperties = {}, signingProperties = {} } = option.propertiesExtractor?.(config, context) || {};
      option.identityProperties = Object.assign(option.identityProperties || {}, identityProperties);
      option.signingProperties = Object.assign(option.signingProperties || {}, signingProperties);
      smithyContext.selectedHttpAuthScheme = {
        httpAuthOption: option,
        identity: await identityProvider(option.identityProperties),
        signer: scheme.signer
      };
      break;
    }
    if (!smithyContext.selectedHttpAuthScheme) {
      throw new Error(failureReasons.join(`
`));
    }
    return next(args);
  };
  var httpAuthSchemeEndpointRuleSetMiddlewareOptions = {
    step: "serialize",
    tags: ["HTTP_AUTH_SCHEME"],
    name: "httpAuthSchemeMiddleware",
    override: true,
    relation: "before",
    toMiddleware: "endpointV2Middleware"
  };
  var getHttpAuthSchemeEndpointRuleSetPlugin = (config, { httpAuthSchemeParametersProvider, identityProviderConfigProvider }) => ({
    applyToStack: (clientStack) => {
      clientStack.addRelativeTo(httpAuthSchemeMiddleware(config, {
        httpAuthSchemeParametersProvider,
        identityProviderConfigProvider
      }), httpAuthSchemeEndpointRuleSetMiddlewareOptions);
    }
  });
  var httpAuthSchemeMiddlewareOptions = {
    step: "serialize",
    tags: ["HTTP_AUTH_SCHEME"],
    name: "httpAuthSchemeMiddleware",
    override: true,
    relation: "before",
    toMiddleware: middlewareSerde.serializerMiddlewareOption.name
  };
  var getHttpAuthSchemePlugin = (config, { httpAuthSchemeParametersProvider, identityProviderConfigProvider }) => ({
    applyToStack: (clientStack) => {
      clientStack.addRelativeTo(httpAuthSchemeMiddleware(config, {
        httpAuthSchemeParametersProvider,
        identityProviderConfigProvider
      }), httpAuthSchemeMiddlewareOptions);
    }
  });
  var defaultErrorHandler = (signingProperties) => (error3) => {
    throw error3;
  };
  var defaultSuccessHandler = (httpResponse, signingProperties) => {};
  var httpSigningMiddleware = (config) => (next, context) => async (args) => {
    if (!protocolHttp.HttpRequest.isInstance(args.request)) {
      return next(args);
    }
    const smithyContext = utilMiddleware.getSmithyContext(context);
    const scheme = smithyContext.selectedHttpAuthScheme;
    if (!scheme) {
      throw new Error(`No HttpAuthScheme was selected: unable to sign request`);
    }
    const { httpAuthOption: { signingProperties = {} }, identity, signer } = scheme;
    const output = await next({
      ...args,
      request: await signer.sign(args.request, identity, signingProperties)
    }).catch((signer.errorHandler || defaultErrorHandler)(signingProperties));
    (signer.successHandler || defaultSuccessHandler)(output.response, signingProperties);
    return output;
  };
  var httpSigningMiddlewareOptions = {
    step: "finalizeRequest",
    tags: ["HTTP_SIGNING"],
    name: "httpSigningMiddleware",
    aliases: ["apiKeyMiddleware", "tokenMiddleware", "awsAuthMiddleware"],
    override: true,
    relation: "after",
    toMiddleware: "retryMiddleware"
  };
  var getHttpSigningPlugin = (config) => ({
    applyToStack: (clientStack) => {
      clientStack.addRelativeTo(httpSigningMiddleware(), httpSigningMiddlewareOptions);
    }
  });
  var normalizeProvider = (input) => {
    if (typeof input === "function")
      return input;
    const promisified = Promise.resolve(input);
    return () => promisified;
  };
  var makePagedClientRequest = async (CommandCtor, client, input, withCommand = (_) => _, ...args) => {
    let command = new CommandCtor(input);
    command = withCommand(command) ?? command;
    return await client.send(command, ...args);
  };
  function createPaginator(ClientCtor, CommandCtor, inputTokenName, outputTokenName, pageSizeTokenName) {
    return async function* paginateOperation(config, input, ...additionalArguments) {
      const _input = input;
      let token = config.startingToken ?? _input[inputTokenName];
      let hasNext = true;
      let page;
      while (hasNext) {
        _input[inputTokenName] = token;
        if (pageSizeTokenName) {
          _input[pageSizeTokenName] = _input[pageSizeTokenName] ?? config.pageSize;
        }
        if (config.client instanceof ClientCtor) {
          page = await makePagedClientRequest(CommandCtor, config.client, input, config.withCommand, ...additionalArguments);
        } else {
          throw new Error(`Invalid client, expected instance of ${ClientCtor.name}`);
        }
        yield page;
        const prevToken = token;
        token = get(page, outputTokenName);
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return;
    };
  }
  var get = (fromObject, path5) => {
    let cursor = fromObject;
    const pathComponents = path5.split(".");
    for (const step of pathComponents) {
      if (!cursor || typeof cursor !== "object") {
        return;
      }
      cursor = cursor[step];
    }
    return cursor;
  };
  function setFeature(context, feature, value) {
    if (!context.__smithy_context) {
      context.__smithy_context = {
        features: {}
      };
    } else if (!context.__smithy_context.features) {
      context.__smithy_context.features = {};
    }
    context.__smithy_context.features[feature] = value;
  }

  class DefaultIdentityProviderConfig {
    authSchemes = new Map;
    constructor(config) {
      for (const [key, value] of Object.entries(config)) {
        if (value !== undefined) {
          this.authSchemes.set(key, value);
        }
      }
    }
    getIdentityProvider(schemeId) {
      return this.authSchemes.get(schemeId);
    }
  }

  class HttpApiKeyAuthSigner {
    async sign(httpRequest, identity, signingProperties) {
      if (!signingProperties) {
        throw new Error("request could not be signed with `apiKey` since the `name` and `in` signer properties are missing");
      }
      if (!signingProperties.name) {
        throw new Error("request could not be signed with `apiKey` since the `name` signer property is missing");
      }
      if (!signingProperties.in) {
        throw new Error("request could not be signed with `apiKey` since the `in` signer property is missing");
      }
      if (!identity.apiKey) {
        throw new Error("request could not be signed with `apiKey` since the `apiKey` is not defined");
      }
      const clonedRequest = protocolHttp.HttpRequest.clone(httpRequest);
      if (signingProperties.in === types.HttpApiKeyAuthLocation.QUERY) {
        clonedRequest.query[signingProperties.name] = identity.apiKey;
      } else if (signingProperties.in === types.HttpApiKeyAuthLocation.HEADER) {
        clonedRequest.headers[signingProperties.name] = signingProperties.scheme ? `${signingProperties.scheme} ${identity.apiKey}` : identity.apiKey;
      } else {
        throw new Error("request can only be signed with `apiKey` locations `query` or `header`, " + "but found: `" + signingProperties.in + "`");
      }
      return clonedRequest;
    }
  }

  class HttpBearerAuthSigner {
    async sign(httpRequest, identity, signingProperties) {
      const clonedRequest = protocolHttp.HttpRequest.clone(httpRequest);
      if (!identity.token) {
        throw new Error("request could not be signed with `token` since the `token` is not defined");
      }
      clonedRequest.headers["Authorization"] = `Bearer ${identity.token}`;
      return clonedRequest;
    }
  }

  class NoAuthSigner {
    async sign(httpRequest, identity, signingProperties) {
      return httpRequest;
    }
  }
  var createIsIdentityExpiredFunction = (expirationMs) => function isIdentityExpired2(identity) {
    return doesIdentityRequireRefresh(identity) && identity.expiration.getTime() - Date.now() < expirationMs;
  };
  var EXPIRATION_MS = 300000;
  var isIdentityExpired = createIsIdentityExpiredFunction(EXPIRATION_MS);
  var doesIdentityRequireRefresh = (identity) => identity.expiration !== undefined;
  var memoizeIdentityProvider = (provider, isExpired, requiresRefresh) => {
    if (provider === undefined) {
      return;
    }
    const normalizedProvider = typeof provider !== "function" ? async () => Promise.resolve(provider) : provider;
    let resolved;
    let pending;
    let hasResult;
    let isConstant = false;
    const coalesceProvider = async (options) => {
      if (!pending) {
        pending = normalizedProvider(options);
      }
      try {
        resolved = await pending;
        hasResult = true;
        isConstant = false;
      } finally {
        pending = undefined;
      }
      return resolved;
    };
    if (isExpired === undefined) {
      return async (options) => {
        if (!hasResult || options?.forceRefresh) {
          resolved = await coalesceProvider(options);
        }
        return resolved;
      };
    }
    return async (options) => {
      if (!hasResult || options?.forceRefresh) {
        resolved = await coalesceProvider(options);
      }
      if (isConstant) {
        return resolved;
      }
      if (!requiresRefresh(resolved)) {
        isConstant = true;
        return resolved;
      }
      if (isExpired(resolved)) {
        await coalesceProvider(options);
        return resolved;
      }
      return resolved;
    };
  };
  Object.defineProperty(exports, "requestBuilder", {
    enumerable: true,
    get: function() {
      return protocols.requestBuilder;
    }
  });
  exports.DefaultIdentityProviderConfig = DefaultIdentityProviderConfig;
  exports.EXPIRATION_MS = EXPIRATION_MS;
  exports.HttpApiKeyAuthSigner = HttpApiKeyAuthSigner;
  exports.HttpBearerAuthSigner = HttpBearerAuthSigner;
  exports.NoAuthSigner = NoAuthSigner;
  exports.createIsIdentityExpiredFunction = createIsIdentityExpiredFunction;
  exports.createPaginator = createPaginator;
  exports.doesIdentityRequireRefresh = doesIdentityRequireRefresh;
  exports.getHttpAuthSchemeEndpointRuleSetPlugin = getHttpAuthSchemeEndpointRuleSetPlugin;
  exports.getHttpAuthSchemePlugin = getHttpAuthSchemePlugin;
  exports.getHttpSigningPlugin = getHttpSigningPlugin;
  exports.getSmithyContext = getSmithyContext;
  exports.httpAuthSchemeEndpointRuleSetMiddlewareOptions = httpAuthSchemeEndpointRuleSetMiddlewareOptions;
  exports.httpAuthSchemeMiddleware = httpAuthSchemeMiddleware;
  exports.httpAuthSchemeMiddlewareOptions = httpAuthSchemeMiddlewareOptions;
  exports.httpSigningMiddleware = httpSigningMiddleware;
  exports.httpSigningMiddlewareOptions = httpSigningMiddlewareOptions;
  exports.isIdentityExpired = isIdentityExpired;
  exports.memoizeIdentityProvider = memoizeIdentityProvider;
  exports.normalizeProvider = normalizeProvider;
  exports.setFeature = setFeature;
});

// ../node_modules/.bun/@smithy+util-endpoints@3.2.8/node_modules/@smithy/util-endpoints/dist-cjs/index.js
var require_dist_cjs20 = __commonJS((exports) => {
  var types = require_dist_cjs();

  class EndpointCache {
    capacity;
    data = new Map;
    parameters = [];
    constructor({ size, params }) {
      this.capacity = size ?? 50;
      if (params) {
        this.parameters = params;
      }
    }
    get(endpointParams, resolver) {
      const key = this.hash(endpointParams);
      if (key === false) {
        return resolver();
      }
      if (!this.data.has(key)) {
        if (this.data.size > this.capacity + 10) {
          const keys = this.data.keys();
          let i = 0;
          while (true) {
            const { value, done } = keys.next();
            this.data.delete(value);
            if (done || ++i > 10) {
              break;
            }
          }
        }
        this.data.set(key, resolver());
      }
      return this.data.get(key);
    }
    size() {
      return this.data.size;
    }
    hash(endpointParams) {
      let buffer = "";
      const { parameters } = this;
      if (parameters.length === 0) {
        return false;
      }
      for (const param of parameters) {
        const val = String(endpointParams[param] ?? "");
        if (val.includes("|;")) {
          return false;
        }
        buffer += val + "|;";
      }
      return buffer;
    }
  }
  var IP_V4_REGEX = new RegExp(`^(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}$`);
  var isIpAddress = (value) => IP_V4_REGEX.test(value) || value.startsWith("[") && value.endsWith("]");
  var VALID_HOST_LABEL_REGEX = new RegExp(`^(?!.*-$)(?!-)[a-zA-Z0-9-]{1,63}$`);
  var isValidHostLabel = (value, allowSubDomains = false) => {
    if (!allowSubDomains) {
      return VALID_HOST_LABEL_REGEX.test(value);
    }
    const labels = value.split(".");
    for (const label of labels) {
      if (!isValidHostLabel(label)) {
        return false;
      }
    }
    return true;
  };
  var customEndpointFunctions = {};
  var debugId = "endpoints";
  function toDebugString(input) {
    if (typeof input !== "object" || input == null) {
      return input;
    }
    if ("ref" in input) {
      return `$${toDebugString(input.ref)}`;
    }
    if ("fn" in input) {
      return `${input.fn}(${(input.argv || []).map(toDebugString).join(", ")})`;
    }
    return JSON.stringify(input, null, 2);
  }

  class EndpointError extends Error {
    constructor(message) {
      super(message);
      this.name = "EndpointError";
    }
  }
  var booleanEquals = (value1, value2) => value1 === value2;
  var getAttrPathList = (path5) => {
    const parts = path5.split(".");
    const pathList = [];
    for (const part of parts) {
      const squareBracketIndex = part.indexOf("[");
      if (squareBracketIndex !== -1) {
        if (part.indexOf("]") !== part.length - 1) {
          throw new EndpointError(`Path: '${path5}' does not end with ']'`);
        }
        const arrayIndex = part.slice(squareBracketIndex + 1, -1);
        if (Number.isNaN(parseInt(arrayIndex))) {
          throw new EndpointError(`Invalid array index: '${arrayIndex}' in path: '${path5}'`);
        }
        if (squareBracketIndex !== 0) {
          pathList.push(part.slice(0, squareBracketIndex));
        }
        pathList.push(arrayIndex);
      } else {
        pathList.push(part);
      }
    }
    return pathList;
  };
  var getAttr = (value, path5) => getAttrPathList(path5).reduce((acc, index) => {
    if (typeof acc !== "object") {
      throw new EndpointError(`Index '${index}' in '${path5}' not found in '${JSON.stringify(value)}'`);
    } else if (Array.isArray(acc)) {
      return acc[parseInt(index)];
    }
    return acc[index];
  }, value);
  var isSet = (value) => value != null;
  var not = (value) => !value;
  var DEFAULT_PORTS = {
    [types.EndpointURLScheme.HTTP]: 80,
    [types.EndpointURLScheme.HTTPS]: 443
  };
  var parseURL = (value) => {
    const whatwgURL = (() => {
      try {
        if (value instanceof URL) {
          return value;
        }
        if (typeof value === "object" && "hostname" in value) {
          const { hostname: hostname2, port, protocol: protocol2 = "", path: path5 = "", query = {} } = value;
          const url = new URL(`${protocol2}//${hostname2}${port ? `:${port}` : ""}${path5}`);
          url.search = Object.entries(query).map(([k, v]) => `${k}=${v}`).join("&");
          return url;
        }
        return new URL(value);
      } catch (error3) {
        return null;
      }
    })();
    if (!whatwgURL) {
      console.error(`Unable to parse ${JSON.stringify(value)} as a whatwg URL.`);
      return null;
    }
    const urlString = whatwgURL.href;
    const { host, hostname, pathname, protocol, search } = whatwgURL;
    if (search) {
      return null;
    }
    const scheme = protocol.slice(0, -1);
    if (!Object.values(types.EndpointURLScheme).includes(scheme)) {
      return null;
    }
    const isIp = isIpAddress(hostname);
    const inputContainsDefaultPort = urlString.includes(`${host}:${DEFAULT_PORTS[scheme]}`) || typeof value === "string" && value.includes(`${host}:${DEFAULT_PORTS[scheme]}`);
    const authority = `${host}${inputContainsDefaultPort ? `:${DEFAULT_PORTS[scheme]}` : ``}`;
    return {
      scheme,
      authority,
      path: pathname,
      normalizedPath: pathname.endsWith("/") ? pathname : `${pathname}/`,
      isIp
    };
  };
  var stringEquals = (value1, value2) => value1 === value2;
  var substring = (input, start, stop, reverse) => {
    if (start >= stop || input.length < stop) {
      return null;
    }
    if (!reverse) {
      return input.substring(start, stop);
    }
    return input.substring(input.length - stop, input.length - start);
  };
  var uriEncode = (value) => encodeURIComponent(value).replace(/[!*'()]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
  var endpointFunctions = {
    booleanEquals,
    getAttr,
    isSet,
    isValidHostLabel,
    not,
    parseURL,
    stringEquals,
    substring,
    uriEncode
  };
  var evaluateTemplate = (template, options) => {
    const evaluatedTemplateArr = [];
    const templateContext = {
      ...options.endpointParams,
      ...options.referenceRecord
    };
    let currentIndex = 0;
    while (currentIndex < template.length) {
      const openingBraceIndex = template.indexOf("{", currentIndex);
      if (openingBraceIndex === -1) {
        evaluatedTemplateArr.push(template.slice(currentIndex));
        break;
      }
      evaluatedTemplateArr.push(template.slice(currentIndex, openingBraceIndex));
      const closingBraceIndex = template.indexOf("}", openingBraceIndex);
      if (closingBraceIndex === -1) {
        evaluatedTemplateArr.push(template.slice(openingBraceIndex));
        break;
      }
      if (template[openingBraceIndex + 1] === "{" && template[closingBraceIndex + 1] === "}") {
        evaluatedTemplateArr.push(template.slice(openingBraceIndex + 1, closingBraceIndex));
        currentIndex = closingBraceIndex + 2;
      }
      const parameterName = template.substring(openingBraceIndex + 1, closingBraceIndex);
      if (parameterName.includes("#")) {
        const [refName, attrName] = parameterName.split("#");
        evaluatedTemplateArr.push(getAttr(templateContext[refName], attrName));
      } else {
        evaluatedTemplateArr.push(templateContext[parameterName]);
      }
      currentIndex = closingBraceIndex + 1;
    }
    return evaluatedTemplateArr.join("");
  };
  var getReferenceValue = ({ ref }, options) => {
    const referenceRecord = {
      ...options.endpointParams,
      ...options.referenceRecord
    };
    return referenceRecord[ref];
  };
  var evaluateExpression = (obj, keyName, options) => {
    if (typeof obj === "string") {
      return evaluateTemplate(obj, options);
    } else if (obj["fn"]) {
      return group$2.callFunction(obj, options);
    } else if (obj["ref"]) {
      return getReferenceValue(obj, options);
    }
    throw new EndpointError(`'${keyName}': ${String(obj)} is not a string, function or reference.`);
  };
  var callFunction = ({ fn, argv }, options) => {
    const evaluatedArgs = argv.map((arg) => ["boolean", "number"].includes(typeof arg) ? arg : group$2.evaluateExpression(arg, "arg", options));
    const fnSegments = fn.split(".");
    if (fnSegments[0] in customEndpointFunctions && fnSegments[1] != null) {
      return customEndpointFunctions[fnSegments[0]][fnSegments[1]](...evaluatedArgs);
    }
    return endpointFunctions[fn](...evaluatedArgs);
  };
  var group$2 = {
    evaluateExpression,
    callFunction
  };
  var evaluateCondition = ({ assign, ...fnArgs }, options) => {
    if (assign && assign in options.referenceRecord) {
      throw new EndpointError(`'${assign}' is already defined in Reference Record.`);
    }
    const value = callFunction(fnArgs, options);
    options.logger?.debug?.(`${debugId} evaluateCondition: ${toDebugString(fnArgs)} = ${toDebugString(value)}`);
    return {
      result: value === "" ? true : !!value,
      ...assign != null && { toAssign: { name: assign, value } }
    };
  };
  var evaluateConditions = (conditions = [], options) => {
    const conditionsReferenceRecord = {};
    for (const condition of conditions) {
      const { result, toAssign } = evaluateCondition(condition, {
        ...options,
        referenceRecord: {
          ...options.referenceRecord,
          ...conditionsReferenceRecord
        }
      });
      if (!result) {
        return { result };
      }
      if (toAssign) {
        conditionsReferenceRecord[toAssign.name] = toAssign.value;
        options.logger?.debug?.(`${debugId} assign: ${toAssign.name} := ${toDebugString(toAssign.value)}`);
      }
    }
    return { result: true, referenceRecord: conditionsReferenceRecord };
  };
  var getEndpointHeaders = (headers, options) => Object.entries(headers).reduce((acc, [headerKey, headerVal]) => ({
    ...acc,
    [headerKey]: headerVal.map((headerValEntry) => {
      const processedExpr = evaluateExpression(headerValEntry, "Header value entry", options);
      if (typeof processedExpr !== "string") {
        throw new EndpointError(`Header '${headerKey}' value '${processedExpr}' is not a string`);
      }
      return processedExpr;
    })
  }), {});
  var getEndpointProperties = (properties, options) => Object.entries(properties).reduce((acc, [propertyKey, propertyVal]) => ({
    ...acc,
    [propertyKey]: group$1.getEndpointProperty(propertyVal, options)
  }), {});
  var getEndpointProperty = (property, options) => {
    if (Array.isArray(property)) {
      return property.map((propertyEntry) => getEndpointProperty(propertyEntry, options));
    }
    switch (typeof property) {
      case "string":
        return evaluateTemplate(property, options);
      case "object":
        if (property === null) {
          throw new EndpointError(`Unexpected endpoint property: ${property}`);
        }
        return group$1.getEndpointProperties(property, options);
      case "boolean":
        return property;
      default:
        throw new EndpointError(`Unexpected endpoint property type: ${typeof property}`);
    }
  };
  var group$1 = {
    getEndpointProperty,
    getEndpointProperties
  };
  var getEndpointUrl = (endpointUrl, options) => {
    const expression = evaluateExpression(endpointUrl, "Endpoint URL", options);
    if (typeof expression === "string") {
      try {
        return new URL(expression);
      } catch (error3) {
        console.error(`Failed to construct URL with ${expression}`, error3);
        throw error3;
      }
    }
    throw new EndpointError(`Endpoint URL must be a string, got ${typeof expression}`);
  };
  var evaluateEndpointRule = (endpointRule, options) => {
    const { conditions, endpoint } = endpointRule;
    const { result, referenceRecord } = evaluateConditions(conditions, options);
    if (!result) {
      return;
    }
    const endpointRuleOptions = {
      ...options,
      referenceRecord: { ...options.referenceRecord, ...referenceRecord }
    };
    const { url, properties, headers } = endpoint;
    options.logger?.debug?.(`${debugId} Resolving endpoint from template: ${toDebugString(endpoint)}`);
    return {
      ...headers != null && {
        headers: getEndpointHeaders(headers, endpointRuleOptions)
      },
      ...properties != null && {
        properties: getEndpointProperties(properties, endpointRuleOptions)
      },
      url: getEndpointUrl(url, endpointRuleOptions)
    };
  };
  var evaluateErrorRule = (errorRule, options) => {
    const { conditions, error: error3 } = errorRule;
    const { result, referenceRecord } = evaluateConditions(conditions, options);
    if (!result) {
      return;
    }
    throw new EndpointError(evaluateExpression(error3, "Error", {
      ...options,
      referenceRecord: { ...options.referenceRecord, ...referenceRecord }
    }));
  };
  var evaluateRules = (rules, options) => {
    for (const rule of rules) {
      if (rule.type === "endpoint") {
        const endpointOrUndefined = evaluateEndpointRule(rule, options);
        if (endpointOrUndefined) {
          return endpointOrUndefined;
        }
      } else if (rule.type === "error") {
        evaluateErrorRule(rule, options);
      } else if (rule.type === "tree") {
        const endpointOrUndefined = group.evaluateTreeRule(rule, options);
        if (endpointOrUndefined) {
          return endpointOrUndefined;
        }
      } else {
        throw new EndpointError(`Unknown endpoint rule: ${rule}`);
      }
    }
    throw new EndpointError(`Rules evaluation failed`);
  };
  var evaluateTreeRule = (treeRule, options) => {
    const { conditions, rules } = treeRule;
    const { result, referenceRecord } = evaluateConditions(conditions, options);
    if (!result) {
      return;
    }
    return group.evaluateRules(rules, {
      ...options,
      referenceRecord: { ...options.referenceRecord, ...referenceRecord }
    });
  };
  var group = {
    evaluateRules,
    evaluateTreeRule
  };
  var resolveEndpoint = (ruleSetObject, options) => {
    const { endpointParams, logger } = options;
    const { parameters, rules } = ruleSetObject;
    options.logger?.debug?.(`${debugId} Initial EndpointParams: ${toDebugString(endpointParams)}`);
    const paramsWithDefault = Object.entries(parameters).filter(([, v]) => v.default != null).map(([k, v]) => [k, v.default]);
    if (paramsWithDefault.length > 0) {
      for (const [paramKey, paramDefaultValue] of paramsWithDefault) {
        endpointParams[paramKey] = endpointParams[paramKey] ?? paramDefaultValue;
      }
    }
    const requiredParams = Object.entries(parameters).filter(([, v]) => v.required).map(([k]) => k);
    for (const requiredParam of requiredParams) {
      if (endpointParams[requiredParam] == null) {
        throw new EndpointError(`Missing required parameter: '${requiredParam}'`);
      }
    }
    const endpoint = evaluateRules(rules, { endpointParams, logger, referenceRecord: {} });
    options.logger?.debug?.(`${debugId} Resolved endpoint: ${toDebugString(endpoint)}`);
    return endpoint;
  };
  exports.EndpointCache = EndpointCache;
  exports.EndpointError = EndpointError;
  exports.customEndpointFunctions = customEndpointFunctions;
  exports.isIpAddress = isIpAddress;
  exports.isValidHostLabel = isValidHostLabel;
  exports.resolveEndpoint = resolveEndpoint;
});

// ../node_modules/.bun/@smithy+querystring-parser@4.2.8/node_modules/@smithy/querystring-parser/dist-cjs/index.js
var require_dist_cjs21 = __commonJS((exports) => {
  function parseQueryString(querystring) {
    const query = {};
    querystring = querystring.replace(/^\?/, "");
    if (querystring) {
      for (const pair of querystring.split("&")) {
        let [key, value = null] = pair.split("=");
        key = decodeURIComponent(key);
        if (value) {
          value = decodeURIComponent(value);
        }
        if (!(key in query)) {
          query[key] = value;
        } else if (Array.isArray(query[key])) {
          query[key].push(value);
        } else {
          query[key] = [query[key], value];
        }
      }
    }
    return query;
  }
  exports.parseQueryString = parseQueryString;
});

// ../node_modules/.bun/@smithy+url-parser@4.2.8/node_modules/@smithy/url-parser/dist-cjs/index.js
var require_dist_cjs22 = __commonJS((exports) => {
  var querystringParser = require_dist_cjs21();
  var parseUrl = (url) => {
    if (typeof url === "string") {
      return parseUrl(new URL(url));
    }
    const { hostname, pathname, port, protocol, search } = url;
    let query;
    if (search) {
      query = querystringParser.parseQueryString(search);
    }
    return {
      hostname,
      port: port ? parseInt(port) : undefined,
      protocol,
      path: pathname,
      query
    };
  };
  exports.parseUrl = parseUrl;
});

// ../node_modules/.bun/@aws-sdk+util-endpoints@3.993.0/node_modules/@aws-sdk/util-endpoints/dist-cjs/index.js
var require_dist_cjs23 = __commonJS((exports) => {
  var utilEndpoints = require_dist_cjs20();
  var urlParser = require_dist_cjs22();
  var isVirtualHostableS3Bucket = (value, allowSubDomains = false) => {
    if (allowSubDomains) {
      for (const label of value.split(".")) {
        if (!isVirtualHostableS3Bucket(label)) {
          return false;
        }
      }
      return true;
    }
    if (!utilEndpoints.isValidHostLabel(value)) {
      return false;
    }
    if (value.length < 3 || value.length > 63) {
      return false;
    }
    if (value !== value.toLowerCase()) {
      return false;
    }
    if (utilEndpoints.isIpAddress(value)) {
      return false;
    }
    return true;
  };
  var ARN_DELIMITER = ":";
  var RESOURCE_DELIMITER = "/";
  var parseArn = (value) => {
    const segments = value.split(ARN_DELIMITER);
    if (segments.length < 6)
      return null;
    const [arn, partition5, service, region, accountId, ...resourcePath] = segments;
    if (arn !== "arn" || partition5 === "" || service === "" || resourcePath.join(ARN_DELIMITER) === "")
      return null;
    const resourceId = resourcePath.map((resource) => resource.split(RESOURCE_DELIMITER)).flat();
    return {
      partition: partition5,
      service,
      region,
      accountId,
      resourceId
    };
  };
  var partitions = [
    {
      id: "aws",
      outputs: {
        dnsSuffix: "amazonaws.com",
        dualStackDnsSuffix: "api.aws",
        implicitGlobalRegion: "us-east-1",
        name: "aws",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$",
      regions: {
        "af-south-1": {
          description: "Africa (Cape Town)"
        },
        "ap-east-1": {
          description: "Asia Pacific (Hong Kong)"
        },
        "ap-east-2": {
          description: "Asia Pacific (Taipei)"
        },
        "ap-northeast-1": {
          description: "Asia Pacific (Tokyo)"
        },
        "ap-northeast-2": {
          description: "Asia Pacific (Seoul)"
        },
        "ap-northeast-3": {
          description: "Asia Pacific (Osaka)"
        },
        "ap-south-1": {
          description: "Asia Pacific (Mumbai)"
        },
        "ap-south-2": {
          description: "Asia Pacific (Hyderabad)"
        },
        "ap-southeast-1": {
          description: "Asia Pacific (Singapore)"
        },
        "ap-southeast-2": {
          description: "Asia Pacific (Sydney)"
        },
        "ap-southeast-3": {
          description: "Asia Pacific (Jakarta)"
        },
        "ap-southeast-4": {
          description: "Asia Pacific (Melbourne)"
        },
        "ap-southeast-5": {
          description: "Asia Pacific (Malaysia)"
        },
        "ap-southeast-6": {
          description: "Asia Pacific (New Zealand)"
        },
        "ap-southeast-7": {
          description: "Asia Pacific (Thailand)"
        },
        "aws-global": {
          description: "aws global region"
        },
        "ca-central-1": {
          description: "Canada (Central)"
        },
        "ca-west-1": {
          description: "Canada West (Calgary)"
        },
        "eu-central-1": {
          description: "Europe (Frankfurt)"
        },
        "eu-central-2": {
          description: "Europe (Zurich)"
        },
        "eu-north-1": {
          description: "Europe (Stockholm)"
        },
        "eu-south-1": {
          description: "Europe (Milan)"
        },
        "eu-south-2": {
          description: "Europe (Spain)"
        },
        "eu-west-1": {
          description: "Europe (Ireland)"
        },
        "eu-west-2": {
          description: "Europe (London)"
        },
        "eu-west-3": {
          description: "Europe (Paris)"
        },
        "il-central-1": {
          description: "Israel (Tel Aviv)"
        },
        "me-central-1": {
          description: "Middle East (UAE)"
        },
        "me-south-1": {
          description: "Middle East (Bahrain)"
        },
        "mx-central-1": {
          description: "Mexico (Central)"
        },
        "sa-east-1": {
          description: "South America (Sao Paulo)"
        },
        "us-east-1": {
          description: "US East (N. Virginia)"
        },
        "us-east-2": {
          description: "US East (Ohio)"
        },
        "us-west-1": {
          description: "US West (N. California)"
        },
        "us-west-2": {
          description: "US West (Oregon)"
        }
      }
    },
    {
      id: "aws-cn",
      outputs: {
        dnsSuffix: "amazonaws.com.cn",
        dualStackDnsSuffix: "api.amazonwebservices.com.cn",
        implicitGlobalRegion: "cn-northwest-1",
        name: "aws-cn",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^cn\\-\\w+\\-\\d+$",
      regions: {
        "aws-cn-global": {
          description: "aws-cn global region"
        },
        "cn-north-1": {
          description: "China (Beijing)"
        },
        "cn-northwest-1": {
          description: "China (Ningxia)"
        }
      }
    },
    {
      id: "aws-eusc",
      outputs: {
        dnsSuffix: "amazonaws.eu",
        dualStackDnsSuffix: "api.amazonwebservices.eu",
        implicitGlobalRegion: "eusc-de-east-1",
        name: "aws-eusc",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^eusc\\-(de)\\-\\w+\\-\\d+$",
      regions: {
        "eusc-de-east-1": {
          description: "AWS European Sovereign Cloud (Germany)"
        }
      }
    },
    {
      id: "aws-iso",
      outputs: {
        dnsSuffix: "c2s.ic.gov",
        dualStackDnsSuffix: "api.aws.ic.gov",
        implicitGlobalRegion: "us-iso-east-1",
        name: "aws-iso",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^us\\-iso\\-\\w+\\-\\d+$",
      regions: {
        "aws-iso-global": {
          description: "aws-iso global region"
        },
        "us-iso-east-1": {
          description: "US ISO East"
        },
        "us-iso-west-1": {
          description: "US ISO WEST"
        }
      }
    },
    {
      id: "aws-iso-b",
      outputs: {
        dnsSuffix: "sc2s.sgov.gov",
        dualStackDnsSuffix: "api.aws.scloud",
        implicitGlobalRegion: "us-isob-east-1",
        name: "aws-iso-b",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^us\\-isob\\-\\w+\\-\\d+$",
      regions: {
        "aws-iso-b-global": {
          description: "aws-iso-b global region"
        },
        "us-isob-east-1": {
          description: "US ISOB East (Ohio)"
        },
        "us-isob-west-1": {
          description: "US ISOB West"
        }
      }
    },
    {
      id: "aws-iso-e",
      outputs: {
        dnsSuffix: "cloud.adc-e.uk",
        dualStackDnsSuffix: "api.cloud-aws.adc-e.uk",
        implicitGlobalRegion: "eu-isoe-west-1",
        name: "aws-iso-e",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^eu\\-isoe\\-\\w+\\-\\d+$",
      regions: {
        "aws-iso-e-global": {
          description: "aws-iso-e global region"
        },
        "eu-isoe-west-1": {
          description: "EU ISOE West"
        }
      }
    },
    {
      id: "aws-iso-f",
      outputs: {
        dnsSuffix: "csp.hci.ic.gov",
        dualStackDnsSuffix: "api.aws.hci.ic.gov",
        implicitGlobalRegion: "us-isof-south-1",
        name: "aws-iso-f",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^us\\-isof\\-\\w+\\-\\d+$",
      regions: {
        "aws-iso-f-global": {
          description: "aws-iso-f global region"
        },
        "us-isof-east-1": {
          description: "US ISOF EAST"
        },
        "us-isof-south-1": {
          description: "US ISOF SOUTH"
        }
      }
    },
    {
      id: "aws-us-gov",
      outputs: {
        dnsSuffix: "amazonaws.com",
        dualStackDnsSuffix: "api.aws",
        implicitGlobalRegion: "us-gov-west-1",
        name: "aws-us-gov",
        supportsDualStack: true,
        supportsFIPS: true
      },
      regionRegex: "^us\\-gov\\-\\w+\\-\\d+$",
      regions: {
        "aws-us-gov-global": {
          description: "aws-us-gov global region"
        },
        "us-gov-east-1": {
          description: "AWS GovCloud (US-East)"
        },
        "us-gov-west-1": {
          description: "AWS GovCloud (US-West)"
        }
      }
    }
  ];
  var version = "1.1";
  var partitionsInfo = {
    partitions,
    version
  };
  var selectedPartitionsInfo = partitionsInfo;
  var selectedUserAgentPrefix = "";
  var partition4 = (value) => {
    const { partitions: partitions2 } = selectedPartitionsInfo;
    for (const partition5 of partitions2) {
      const { regions, outputs } = partition5;
      for (const [region, regionData] of Object.entries(regions)) {
        if (region === value) {
          return {
            ...outputs,
            ...regionData
          };
        }
      }
    }
    for (const partition5 of partitions2) {
      const { regionRegex, outputs } = partition5;
      if (new RegExp(regionRegex).test(value)) {
        return {
          ...outputs
        };
      }
    }
    const DEFAULT_PARTITION = partitions2.find((partition5) => partition5.id === "aws");
    if (!DEFAULT_PARTITION) {
      throw new Error("Provided region was not found in the partition array or regex," + " and default partition with id 'aws' doesn't exist.");
    }
    return {
      ...DEFAULT_PARTITION.outputs
    };
  };
  var setPartitionInfo = (partitionsInfo2, userAgentPrefix = "") => {
    selectedPartitionsInfo = partitionsInfo2;
    selectedUserAgentPrefix = userAgentPrefix;
  };
  var useDefaultPartitionInfo = () => {
    setPartitionInfo(partitionsInfo, "");
  };
  var getUserAgentPrefix = () => selectedUserAgentPrefix;
  var awsEndpointFunctions = {
    isVirtualHostableS3Bucket,
    parseArn,
    partition: partition4
  };
  utilEndpoints.customEndpointFunctions.aws = awsEndpointFunctions;
  var resolveDefaultAwsRegionalEndpointsConfig = (input) => {
    if (typeof input.endpointProvider !== "function") {
      throw new Error("@aws-sdk/util-endpoint - endpointProvider and endpoint missing in config for this client.");
    }
    const { endpoint } = input;
    if (endpoint === undefined) {
      input.endpoint = async () => {
        return toEndpointV1(input.endpointProvider({
          Region: typeof input.region === "function" ? await input.region() : input.region,
          UseDualStack: typeof input.useDualstackEndpoint === "function" ? await input.useDualstackEndpoint() : input.useDualstackEndpoint,
          UseFIPS: typeof input.useFipsEndpoint === "function" ? await input.useFipsEndpoint() : input.useFipsEndpoint,
          Endpoint: undefined
        }, { logger: input.logger }));
      };
    }
    return input;
  };
  var toEndpointV1 = (endpoint) => urlParser.parseUrl(endpoint.url);
  Object.defineProperty(exports, "EndpointError", {
    enumerable: true,
    get: function() {
      return utilEndpoints.EndpointError;
    }
  });
  Object.defineProperty(exports, "isIpAddress", {
    enumerable: true,
    get: function() {
      return utilEndpoints.isIpAddress;
    }
  });
  Object.defineProperty(exports, "resolveEndpoint", {
    enumerable: true,
    get: function() {
      return utilEndpoints.resolveEndpoint;
    }
  });
  exports.awsEndpointFunctions = awsEndpointFunctions;
  exports.getUserAgentPrefix = getUserAgentPrefix;
  exports.partition = partition4;
  exports.resolveDefaultAwsRegionalEndpointsConfig = resolveDefaultAwsRegionalEndpointsConfig;
  exports.setPartitionInfo = setPartitionInfo;
  exports.toEndpointV1 = toEndpointV1;
  exports.useDefaultPartitionInfo = useDefaultPartitionInfo;
});

// ../node_modules/.bun/@smithy+property-provider@4.2.8/node_modules/@smithy/property-provider/dist-cjs/index.js
var require_dist_cjs24 = __commonJS((exports) => {
  class ProviderError extends Error {
    name = "ProviderError";
    tryNextLink;
    constructor(message, options = true) {
      let logger;
      let tryNextLink = true;
      if (typeof options === "boolean") {
        logger = undefined;
        tryNextLink = options;
      } else if (options != null && typeof options === "object") {
        logger = options.logger;
        tryNextLink = options.tryNextLink ?? true;
      }
      super(message);
      this.tryNextLink = tryNextLink;
      Object.setPrototypeOf(this, ProviderError.prototype);
      logger?.debug?.(`@smithy/property-provider ${tryNextLink ? "->" : "(!)"} ${message}`);
    }
    static from(error3, options = true) {
      return Object.assign(new this(error3.message, options), error3);
    }
  }

  class CredentialsProviderError extends ProviderError {
    name = "CredentialsProviderError";
    constructor(message, options = true) {
      super(message, options);
      Object.setPrototypeOf(this, CredentialsProviderError.prototype);
    }
  }

  class TokenProviderError extends ProviderError {
    name = "TokenProviderError";
    constructor(message, options = true) {
      super(message, options);
      Object.setPrototypeOf(this, TokenProviderError.prototype);
    }
  }
  var chain = (...providers) => async () => {
    if (providers.length === 0) {
      throw new ProviderError("No providers in chain");
    }
    let lastProviderError;
    for (const provider of providers) {
      try {
        const credentials = await provider();
        return credentials;
      } catch (err) {
        lastProviderError = err;
        if (err?.tryNextLink) {
          continue;
        }
        throw err;
      }
    }
    throw lastProviderError;
  };
  var fromStatic = (staticValue) => () => Promise.resolve(staticValue);
  var memoize = (provider, isExpired, requiresRefresh) => {
    let resolved;
    let pending;
    let hasResult;
    let isConstant = false;
    const coalesceProvider = async () => {
      if (!pending) {
        pending = provider();
      }
      try {
        resolved = await pending;
        hasResult = true;
        isConstant = false;
      } finally {
        pending = undefined;
      }
      return resolved;
    };
    if (isExpired === undefined) {
      return async (options) => {
        if (!hasResult || options?.forceRefresh) {
          resolved = await coalesceProvider();
        }
        return resolved;
      };
    }
    return async (options) => {
      if (!hasResult || options?.forceRefresh) {
        resolved = await coalesceProvider();
      }
      if (isConstant) {
        return resolved;
      }
      if (requiresRefresh && !requiresRefresh(resolved)) {
        isConstant = true;
        return resolved;
      }
      if (isExpired(resolved)) {
        await coalesceProvider();
        return resolved;
      }
      return resolved;
    };
  };
  exports.CredentialsProviderError = CredentialsProviderError;
  exports.ProviderError = ProviderError;
  exports.TokenProviderError = TokenProviderError;
  exports.chain = chain;
  exports.fromStatic = fromStatic;
  exports.memoize = memoize;
});

// ../node_modules/.bun/@aws-sdk+core@3.973.11/node_modules/@aws-sdk/core/dist-cjs/submodules/client/index.js
var require_client = __commonJS((exports) => {
  var state = {
    warningEmitted: false
  };
  var emitWarningIfUnsupportedVersion = (version) => {
    if (version && !state.warningEmitted && parseInt(version.substring(1, version.indexOf("."))) < 20) {
      state.warningEmitted = true;
      process.emitWarning(`NodeDeprecationWarning: The AWS SDK for JavaScript (v3) will
no longer support Node.js ${version} in January 2026.

To continue receiving updates to AWS services, bug fixes, and security
updates please upgrade to a supported Node.js LTS version.

More information can be found at: https://a.co/c895JFp`);
    }
  };
  function setCredentialFeature(credentials, feature, value) {
    if (!credentials.$source) {
      credentials.$source = {};
    }
    credentials.$source[feature] = value;
    return credentials;
  }
  function setFeature(context, feature, value) {
    if (!context.__aws_sdk_context) {
      context.__aws_sdk_context = {
        features: {}
      };
    } else if (!context.__aws_sdk_context.features) {
      context.__aws_sdk_context.features = {};
    }
    context.__aws_sdk_context.features[feature] = value;
  }
  function setTokenFeature(token, feature, value) {
    if (!token.$source) {
      token.$source = {};
    }
    token.$source[feature] = value;
    return token;
  }
  exports.emitWarningIfUnsupportedVersion = emitWarningIfUnsupportedVersion;
  exports.setCredentialFeature = setCredentialFeature;
  exports.setFeature = setFeature;
  exports.setTokenFeature = setTokenFeature;
  exports.state = state;
});

// ../node_modules/.bun/@smithy+signature-v4@5.3.8/node_modules/@smithy/signature-v4/dist-cjs/index.js
var require_dist_cjs25 = __commonJS((exports) => {
  var utilHexEncoding = require_dist_cjs16();
  var utilUtf8 = require_dist_cjs10();
  var isArrayBuffer = require_dist_cjs8();
  var protocolHttp = require_dist_cjs2();
  var utilMiddleware = require_dist_cjs6();
  var utilUriEscape = require_dist_cjs12();
  var ALGORITHM_QUERY_PARAM = "X-Amz-Algorithm";
  var CREDENTIAL_QUERY_PARAM = "X-Amz-Credential";
  var AMZ_DATE_QUERY_PARAM = "X-Amz-Date";
  var SIGNED_HEADERS_QUERY_PARAM = "X-Amz-SignedHeaders";
  var EXPIRES_QUERY_PARAM = "X-Amz-Expires";
  var SIGNATURE_QUERY_PARAM = "X-Amz-Signature";
  var TOKEN_QUERY_PARAM = "X-Amz-Security-Token";
  var REGION_SET_PARAM = "X-Amz-Region-Set";
  var AUTH_HEADER = "authorization";
  var AMZ_DATE_HEADER = AMZ_DATE_QUERY_PARAM.toLowerCase();
  var DATE_HEADER = "date";
  var GENERATED_HEADERS = [AUTH_HEADER, AMZ_DATE_HEADER, DATE_HEADER];
  var SIGNATURE_HEADER = SIGNATURE_QUERY_PARAM.toLowerCase();
  var SHA256_HEADER = "x-amz-content-sha256";
  var TOKEN_HEADER = TOKEN_QUERY_PARAM.toLowerCase();
  var HOST_HEADER = "host";
  var ALWAYS_UNSIGNABLE_HEADERS = {
    authorization: true,
    "cache-control": true,
    connection: true,
    expect: true,
    from: true,
    "keep-alive": true,
    "max-forwards": true,
    pragma: true,
    referer: true,
    te: true,
    trailer: true,
    "transfer-encoding": true,
    upgrade: true,
    "user-agent": true,
    "x-amzn-trace-id": true
  };
  var PROXY_HEADER_PATTERN = /^proxy-/;
  var SEC_HEADER_PATTERN = /^sec-/;
  var UNSIGNABLE_PATTERNS = [/^proxy-/i, /^sec-/i];
  var ALGORITHM_IDENTIFIER = "AWS4-HMAC-SHA256";
  var ALGORITHM_IDENTIFIER_V4A = "AWS4-ECDSA-P256-SHA256";
  var EVENT_ALGORITHM_IDENTIFIER = "AWS4-HMAC-SHA256-PAYLOAD";
  var UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
  var MAX_CACHE_SIZE = 50;
  var KEY_TYPE_IDENTIFIER = "aws4_request";
  var MAX_PRESIGNED_TTL = 60 * 60 * 24 * 7;
  var signingKeyCache = {};
  var cacheQueue = [];
  var createScope = (shortDate, region, service) => `${shortDate}/${region}/${service}/${KEY_TYPE_IDENTIFIER}`;
  var getSigningKey = async (sha256Constructor, credentials, shortDate, region, service) => {
    const credsHash = await hmac(sha256Constructor, credentials.secretAccessKey, credentials.accessKeyId);
    const cacheKey2 = `${shortDate}:${region}:${service}:${utilHexEncoding.toHex(credsHash)}:${credentials.sessionToken}`;
    if (cacheKey2 in signingKeyCache) {
      return signingKeyCache[cacheKey2];
    }
    cacheQueue.push(cacheKey2);
    while (cacheQueue.length > MAX_CACHE_SIZE) {
      delete signingKeyCache[cacheQueue.shift()];
    }
    let key = `AWS4${credentials.secretAccessKey}`;
    for (const signable of [shortDate, region, service, KEY_TYPE_IDENTIFIER]) {
      key = await hmac(sha256Constructor, key, signable);
    }
    return signingKeyCache[cacheKey2] = key;
  };
  var clearCredentialCache = () => {
    cacheQueue.length = 0;
    Object.keys(signingKeyCache).forEach((cacheKey2) => {
      delete signingKeyCache[cacheKey2];
    });
  };
  var hmac = (ctor, secret, data) => {
    const hash2 = new ctor(secret);
    hash2.update(utilUtf8.toUint8Array(data));
    return hash2.digest();
  };
  var getCanonicalHeaders = ({ headers }, unsignableHeaders, signableHeaders) => {
    const canonical = {};
    for (const headerName of Object.keys(headers).sort()) {
      if (headers[headerName] == undefined) {
        continue;
      }
      const canonicalHeaderName = headerName.toLowerCase();
      if (canonicalHeaderName in ALWAYS_UNSIGNABLE_HEADERS || unsignableHeaders?.has(canonicalHeaderName) || PROXY_HEADER_PATTERN.test(canonicalHeaderName) || SEC_HEADER_PATTERN.test(canonicalHeaderName)) {
        if (!signableHeaders || signableHeaders && !signableHeaders.has(canonicalHeaderName)) {
          continue;
        }
      }
      canonical[canonicalHeaderName] = headers[headerName].trim().replace(/\s+/g, " ");
    }
    return canonical;
  };
  var getPayloadHash = async ({ headers, body }, hashConstructor) => {
    for (const headerName of Object.keys(headers)) {
      if (headerName.toLowerCase() === SHA256_HEADER) {
        return headers[headerName];
      }
    }
    if (body == undefined) {
      return "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    } else if (typeof body === "string" || ArrayBuffer.isView(body) || isArrayBuffer.isArrayBuffer(body)) {
      const hashCtor = new hashConstructor;
      hashCtor.update(utilUtf8.toUint8Array(body));
      return utilHexEncoding.toHex(await hashCtor.digest());
    }
    return UNSIGNED_PAYLOAD;
  };

  class HeaderFormatter {
    format(headers) {
      const chunks = [];
      for (const headerName of Object.keys(headers)) {
        const bytes = utilUtf8.fromUtf8(headerName);
        chunks.push(Uint8Array.from([bytes.byteLength]), bytes, this.formatHeaderValue(headers[headerName]));
      }
      const out = new Uint8Array(chunks.reduce((carry, bytes) => carry + bytes.byteLength, 0));
      let position = 0;
      for (const chunk of chunks) {
        out.set(chunk, position);
        position += chunk.byteLength;
      }
      return out;
    }
    formatHeaderValue(header) {
      switch (header.type) {
        case "boolean":
          return Uint8Array.from([header.value ? 0 : 1]);
        case "byte":
          return Uint8Array.from([2, header.value]);
        case "short":
          const shortView = new DataView(new ArrayBuffer(3));
          shortView.setUint8(0, 3);
          shortView.setInt16(1, header.value, false);
          return new Uint8Array(shortView.buffer);
        case "integer":
          const intView = new DataView(new ArrayBuffer(5));
          intView.setUint8(0, 4);
          intView.setInt32(1, header.value, false);
          return new Uint8Array(intView.buffer);
        case "long":
          const longBytes = new Uint8Array(9);
          longBytes[0] = 5;
          longBytes.set(header.value.bytes, 1);
          return longBytes;
        case "binary":
          const binView = new DataView(new ArrayBuffer(3 + header.value.byteLength));
          binView.setUint8(0, 6);
          binView.setUint16(1, header.value.byteLength, false);
          const binBytes = new Uint8Array(binView.buffer);
          binBytes.set(header.value, 3);
          return binBytes;
        case "string":
          const utf8Bytes = utilUtf8.fromUtf8(header.value);
          const strView = new DataView(new ArrayBuffer(3 + utf8Bytes.byteLength));
          strView.setUint8(0, 7);
          strView.setUint16(1, utf8Bytes.byteLength, false);
          const strBytes = new Uint8Array(strView.buffer);
          strBytes.set(utf8Bytes, 3);
          return strBytes;
        case "timestamp":
          const tsBytes = new Uint8Array(9);
          tsBytes[0] = 8;
          tsBytes.set(Int64.fromNumber(header.value.valueOf()).bytes, 1);
          return tsBytes;
        case "uuid":
          if (!UUID_PATTERN.test(header.value)) {
            throw new Error(`Invalid UUID received: ${header.value}`);
          }
          const uuidBytes = new Uint8Array(17);
          uuidBytes[0] = 9;
          uuidBytes.set(utilHexEncoding.fromHex(header.value.replace(/\-/g, "")), 1);
          return uuidBytes;
      }
    }
  }
  var UUID_PATTERN = /^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$/;

  class Int64 {
    bytes;
    constructor(bytes) {
      this.bytes = bytes;
      if (bytes.byteLength !== 8) {
        throw new Error("Int64 buffers must be exactly 8 bytes");
      }
    }
    static fromNumber(number) {
      if (number > 9223372036854776000 || number < -9223372036854776000) {
        throw new Error(`${number} is too large (or, if negative, too small) to represent as an Int64`);
      }
      const bytes = new Uint8Array(8);
      for (let i = 7, remaining = Math.abs(Math.round(number));i > -1 && remaining > 0; i--, remaining /= 256) {
        bytes[i] = remaining;
      }
      if (number < 0) {
        negate(bytes);
      }
      return new Int64(bytes);
    }
    valueOf() {
      const bytes = this.bytes.slice(0);
      const negative = bytes[0] & 128;
      if (negative) {
        negate(bytes);
      }
      return parseInt(utilHexEncoding.toHex(bytes), 16) * (negative ? -1 : 1);
    }
    toString() {
      return String(this.valueOf());
    }
  }
  function negate(bytes) {
    for (let i = 0;i < 8; i++) {
      bytes[i] ^= 255;
    }
    for (let i = 7;i > -1; i--) {
      bytes[i]++;
      if (bytes[i] !== 0)
        break;
    }
  }
  var hasHeader = (soughtHeader, headers) => {
    soughtHeader = soughtHeader.toLowerCase();
    for (const headerName of Object.keys(headers)) {
      if (soughtHeader === headerName.toLowerCase()) {
        return true;
      }
    }
    return false;
  };
  var moveHeadersToQuery = (request, options = {}) => {
    const { headers, query = {} } = protocolHttp.HttpRequest.clone(request);
    for (const name of Object.keys(headers)) {
      const lname = name.toLowerCase();
      if (lname.slice(0, 6) === "x-amz-" && !options.unhoistableHeaders?.has(lname) || options.hoistableHeaders?.has(lname)) {
        query[name] = headers[name];
        delete headers[name];
      }
    }
    return {
      ...request,
      headers,
      query
    };
  };
  var prepareRequest = (request) => {
    request = protocolHttp.HttpRequest.clone(request);
    for (const headerName of Object.keys(request.headers)) {
      if (GENERATED_HEADERS.indexOf(headerName.toLowerCase()) > -1) {
        delete request.headers[headerName];
      }
    }
    return request;
  };
  var getCanonicalQuery = ({ query = {} }) => {
    const keys = [];
    const serialized = {};
    for (const key of Object.keys(query)) {
      if (key.toLowerCase() === SIGNATURE_HEADER) {
        continue;
      }
      const encodedKey = utilUriEscape.escapeUri(key);
      keys.push(encodedKey);
      const value = query[key];
      if (typeof value === "string") {
        serialized[encodedKey] = `${encodedKey}=${utilUriEscape.escapeUri(value)}`;
      } else if (Array.isArray(value)) {
        serialized[encodedKey] = value.slice(0).reduce((encoded, value2) => encoded.concat([`${encodedKey}=${utilUriEscape.escapeUri(value2)}`]), []).sort().join("&");
      }
    }
    return keys.sort().map((key) => serialized[key]).filter((serialized2) => serialized2).join("&");
  };
  var iso8601 = (time) => toDate(time).toISOString().replace(/\.\d{3}Z$/, "Z");
  var toDate = (time) => {
    if (typeof time === "number") {
      return new Date(time * 1000);
    }
    if (typeof time === "string") {
      if (Number(time)) {
        return new Date(Number(time) * 1000);
      }
      return new Date(time);
    }
    return time;
  };

  class SignatureV4Base {
    service;
    regionProvider;
    credentialProvider;
    sha256;
    uriEscapePath;
    applyChecksum;
    constructor({ applyChecksum, credentials, region, service, sha256, uriEscapePath = true }) {
      this.service = service;
      this.sha256 = sha256;
      this.uriEscapePath = uriEscapePath;
      this.applyChecksum = typeof applyChecksum === "boolean" ? applyChecksum : true;
      this.regionProvider = utilMiddleware.normalizeProvider(region);
      this.credentialProvider = utilMiddleware.normalizeProvider(credentials);
    }
    createCanonicalRequest(request, canonicalHeaders, payloadHash) {
      const sortedHeaders = Object.keys(canonicalHeaders).sort();
      return `${request.method}
${this.getCanonicalPath(request)}
${getCanonicalQuery(request)}
${sortedHeaders.map((name) => `${name}:${canonicalHeaders[name]}`).join(`
`)}

${sortedHeaders.join(";")}
${payloadHash}`;
    }
    async createStringToSign(longDate, credentialScope, canonicalRequest, algorithmIdentifier) {
      const hash2 = new this.sha256;
      hash2.update(utilUtf8.toUint8Array(canonicalRequest));
      const hashedRequest = await hash2.digest();
      return `${algorithmIdentifier}
${longDate}
${credentialScope}
${utilHexEncoding.toHex(hashedRequest)}`;
    }
    getCanonicalPath({ path: path5 }) {
      if (this.uriEscapePath) {
        const normalizedPathSegments = [];
        for (const pathSegment of path5.split("/")) {
          if (pathSegment?.length === 0)
            continue;
          if (pathSegment === ".")
            continue;
          if (pathSegment === "..") {
            normalizedPathSegments.pop();
          } else {
            normalizedPathSegments.push(pathSegment);
          }
        }
        const normalizedPath = `${path5?.startsWith("/") ? "/" : ""}${normalizedPathSegments.join("/")}${normalizedPathSegments.length > 0 && path5?.endsWith("/") ? "/" : ""}`;
        const doubleEncoded = utilUriEscape.escapeUri(normalizedPath);
        return doubleEncoded.replace(/%2F/g, "/");
      }
      return path5;
    }
    validateResolvedCredentials(credentials) {
      if (typeof credentials !== "object" || typeof credentials.accessKeyId !== "string" || typeof credentials.secretAccessKey !== "string") {
        throw new Error("Resolved credential object is not valid");
      }
    }
    formatDate(now) {
      const longDate = iso8601(now).replace(/[\-:]/g, "");
      return {
        longDate,
        shortDate: longDate.slice(0, 8)
      };
    }
    getCanonicalHeaderList(headers) {
      return Object.keys(headers).sort().join(";");
    }
  }

  class SignatureV4 extends SignatureV4Base {
    headerFormatter = new HeaderFormatter;
    constructor({ applyChecksum, credentials, region, service, sha256, uriEscapePath = true }) {
      super({
        applyChecksum,
        credentials,
        region,
        service,
        sha256,
        uriEscapePath
      });
    }
    async presign(originalRequest, options = {}) {
      const { signingDate = new Date, expiresIn = 3600, unsignableHeaders, unhoistableHeaders, signableHeaders, hoistableHeaders, signingRegion, signingService } = options;
      const credentials = await this.credentialProvider();
      this.validateResolvedCredentials(credentials);
      const region = signingRegion ?? await this.regionProvider();
      const { longDate, shortDate } = this.formatDate(signingDate);
      if (expiresIn > MAX_PRESIGNED_TTL) {
        return Promise.reject("Signature version 4 presigned URLs" + " must have an expiration date less than one week in" + " the future");
      }
      const scope = createScope(shortDate, region, signingService ?? this.service);
      const request = moveHeadersToQuery(prepareRequest(originalRequest), { unhoistableHeaders, hoistableHeaders });
      if (credentials.sessionToken) {
        request.query[TOKEN_QUERY_PARAM] = credentials.sessionToken;
      }
      request.query[ALGORITHM_QUERY_PARAM] = ALGORITHM_IDENTIFIER;
      request.query[CREDENTIAL_QUERY_PARAM] = `${credentials.accessKeyId}/${scope}`;
      request.query[AMZ_DATE_QUERY_PARAM] = longDate;
      request.query[EXPIRES_QUERY_PARAM] = expiresIn.toString(10);
      const canonicalHeaders = getCanonicalHeaders(request, unsignableHeaders, signableHeaders);
      request.query[SIGNED_HEADERS_QUERY_PARAM] = this.getCanonicalHeaderList(canonicalHeaders);
      request.query[SIGNATURE_QUERY_PARAM] = await this.getSignature(longDate, scope, this.getSigningKey(credentials, region, shortDate, signingService), this.createCanonicalRequest(request, canonicalHeaders, await getPayloadHash(originalRequest, this.sha256)));
      return request;
    }
    async sign(toSign, options) {
      if (typeof toSign === "string") {
        return this.signString(toSign, options);
      } else if (toSign.headers && toSign.payload) {
        return this.signEvent(toSign, options);
      } else if (toSign.message) {
        return this.signMessage(toSign, options);
      } else {
        return this.signRequest(toSign, options);
      }
    }
    async signEvent({ headers, payload }, { signingDate = new Date, priorSignature, signingRegion, signingService }) {
      const region = signingRegion ?? await this.regionProvider();
      const { shortDate, longDate } = this.formatDate(signingDate);
      const scope = createScope(shortDate, region, signingService ?? this.service);
      const hashedPayload = await getPayloadHash({ headers: {}, body: payload }, this.sha256);
      const hash2 = new this.sha256;
      hash2.update(headers);
      const hashedHeaders = utilHexEncoding.toHex(await hash2.digest());
      const stringToSign = [
        EVENT_ALGORITHM_IDENTIFIER,
        longDate,
        scope,
        priorSignature,
        hashedHeaders,
        hashedPayload
      ].join(`
`);
      return this.signString(stringToSign, { signingDate, signingRegion: region, signingService });
    }
    async signMessage(signableMessage, { signingDate = new Date, signingRegion, signingService }) {
      const promise = this.signEvent({
        headers: this.headerFormatter.format(signableMessage.message.headers),
        payload: signableMessage.message.body
      }, {
        signingDate,
        signingRegion,
        signingService,
        priorSignature: signableMessage.priorSignature
      });
      return promise.then((signature) => {
        return { message: signableMessage.message, signature };
      });
    }
    async signString(stringToSign, { signingDate = new Date, signingRegion, signingService } = {}) {
      const credentials = await this.credentialProvider();
      this.validateResolvedCredentials(credentials);
      const region = signingRegion ?? await this.regionProvider();
      const { shortDate } = this.formatDate(signingDate);
      const hash2 = new this.sha256(await this.getSigningKey(credentials, region, shortDate, signingService));
      hash2.update(utilUtf8.toUint8Array(stringToSign));
      return utilHexEncoding.toHex(await hash2.digest());
    }
    async signRequest(requestToSign, { signingDate = new Date, signableHeaders, unsignableHeaders, signingRegion, signingService } = {}) {
      const credentials = await this.credentialProvider();
      this.validateResolvedCredentials(credentials);
      const region = signingRegion ?? await this.regionProvider();
      const request = prepareRequest(requestToSign);
      const { longDate, shortDate } = this.formatDate(signingDate);
      const scope = createScope(shortDate, region, signingService ?? this.service);
      request.headers[AMZ_DATE_HEADER] = longDate;
      if (credentials.sessionToken) {
        request.headers[TOKEN_HEADER] = credentials.sessionToken;
      }
      const payloadHash = await getPayloadHash(request, this.sha256);
      if (!hasHeader(SHA256_HEADER, request.headers) && this.applyChecksum) {
        request.headers[SHA256_HEADER] = payloadHash;
      }
      const canonicalHeaders = getCanonicalHeaders(request, unsignableHeaders, signableHeaders);
      const signature = await this.getSignature(longDate, scope, this.getSigningKey(credentials, region, shortDate, signingService), this.createCanonicalRequest(request, canonicalHeaders, payloadHash));
      request.headers[AUTH_HEADER] = `${ALGORITHM_IDENTIFIER} ` + `Credential=${credentials.accessKeyId}/${scope}, ` + `SignedHeaders=${this.getCanonicalHeaderList(canonicalHeaders)}, ` + `Signature=${signature}`;
      return request;
    }
    async getSignature(longDate, credentialScope, keyPromise, canonicalRequest) {
      const stringToSign = await this.createStringToSign(longDate, credentialScope, canonicalRequest, ALGORITHM_IDENTIFIER);
      const hash2 = new this.sha256(await keyPromise);
      hash2.update(utilUtf8.toUint8Array(stringToSign));
      return utilHexEncoding.toHex(await hash2.digest());
    }
    getSigningKey(credentials, region, shortDate, service) {
      return getSigningKey(this.sha256, credentials, shortDate, region, service || this.service);
    }
  }
  var signatureV4aContainer = {
    SignatureV4a: null
  };
  exports.ALGORITHM_IDENTIFIER = ALGORITHM_IDENTIFIER;
  exports.ALGORITHM_IDENTIFIER_V4A = ALGORITHM_IDENTIFIER_V4A;
  exports.ALGORITHM_QUERY_PARAM = ALGORITHM_QUERY_PARAM;
  exports.ALWAYS_UNSIGNABLE_HEADERS = ALWAYS_UNSIGNABLE_HEADERS;
  exports.AMZ_DATE_HEADER = AMZ_DATE_HEADER;
  exports.AMZ_DATE_QUERY_PARAM = AMZ_DATE_QUERY_PARAM;
  exports.AUTH_HEADER = AUTH_HEADER;
  exports.CREDENTIAL_QUERY_PARAM = CREDENTIAL_QUERY_PARAM;
  exports.DATE_HEADER = DATE_HEADER;
  exports.EVENT_ALGORITHM_IDENTIFIER = EVENT_ALGORITHM_IDENTIFIER;
  exports.EXPIRES_QUERY_PARAM = EXPIRES_QUERY_PARAM;
  exports.GENERATED_HEADERS = GENERATED_HEADERS;
  exports.HOST_HEADER = HOST_HEADER;
  exports.KEY_TYPE_IDENTIFIER = KEY_TYPE_IDENTIFIER;
  exports.MAX_CACHE_SIZE = MAX_CACHE_SIZE;
  exports.MAX_PRESIGNED_TTL = MAX_PRESIGNED_TTL;
  exports.PROXY_HEADER_PATTERN = PROXY_HEADER_PATTERN;
  exports.REGION_SET_PARAM = REGION_SET_PARAM;
  exports.SEC_HEADER_PATTERN = SEC_HEADER_PATTERN;
  exports.SHA256_HEADER = SHA256_HEADER;
  exports.SIGNATURE_HEADER = SIGNATURE_HEADER;
  exports.SIGNATURE_QUERY_PARAM = SIGNATURE_QUERY_PARAM;
  exports.SIGNED_HEADERS_QUERY_PARAM = SIGNED_HEADERS_QUERY_PARAM;
  exports.SignatureV4 = SignatureV4;
  exports.SignatureV4Base = SignatureV4Base;
  exports.TOKEN_HEADER = TOKEN_HEADER;
  exports.TOKEN_QUERY_PARAM = TOKEN_QUERY_PARAM;
  exports.UNSIGNABLE_PATTERNS = UNSIGNABLE_PATTERNS;
  exports.UNSIGNED_PAYLOAD = UNSIGNED_PAYLOAD;
  exports.clearCredentialCache = clearCredentialCache;
  exports.createScope = createScope;
  exports.getCanonicalHeaders = getCanonicalHeaders;
  exports.getCanonicalQuery = getCanonicalQuery;
  exports.getPayloadHash = getPayloadHash;
  exports.getSigningKey = getSigningKey;
  exports.hasHeader = hasHeader;
  exports.moveHeadersToQuery = moveHeadersToQuery;
  exports.prepareRequest = prepareRequest;
  exports.signatureV4aContainer = signatureV4aContainer;
});

// ../node_modules/.bun/@smithy+util-body-length-browser@4.2.0/node_modules/@smithy/util-body-length-browser/dist-cjs/index.js
var require_dist_cjs26 = __commonJS((exports) => {
  var TEXT_ENCODER = typeof TextEncoder == "function" ? new TextEncoder : null;
  var calculateBodyLength = (body) => {
    if (typeof body === "string") {
      if (TEXT_ENCODER) {
        return TEXT_ENCODER.encode(body).byteLength;
      }
      let len = body.length;
      for (let i = len - 1;i >= 0; i--) {
        const code = body.charCodeAt(i);
        if (code > 127 && code <= 2047)
          len++;
        else if (code > 2047 && code <= 65535)
          len += 2;
        if (code >= 56320 && code <= 57343)
          i--;
      }
      return len;
    } else if (typeof body.byteLength === "number") {
      return body.byteLength;
    } else if (typeof body.size === "number") {
      return body.size;
    }
    throw new Error(`Body Length computation failed for ${body}`);
  };
  exports.calculateBodyLength = calculateBodyLength;
});

// ../node_modules/.bun/@smithy+core@3.23.2/node_modules/@smithy/core/dist-cjs/submodules/cbor/index.js
var require_cbor = __commonJS((exports) => {
  var serde = require_serde();
  var utilUtf8 = require_dist_cjs10();
  var protocols = require_protocols();
  var protocolHttp = require_dist_cjs2();
  var utilBodyLengthBrowser = require_dist_cjs26();
  var schema = require_schema();
  var utilMiddleware = require_dist_cjs6();
  var utilBase64 = require_dist_cjs11();
  var majorUint64 = 0;
  var majorNegativeInt64 = 1;
  var majorUnstructuredByteString = 2;
  var majorUtf8String = 3;
  var majorList = 4;
  var majorMap = 5;
  var majorTag = 6;
  var majorSpecial = 7;
  var specialFalse = 20;
  var specialTrue = 21;
  var specialNull = 22;
  var specialUndefined = 23;
  var extendedOneByte = 24;
  var extendedFloat16 = 25;
  var extendedFloat32 = 26;
  var extendedFloat64 = 27;
  var minorIndefinite = 31;
  function alloc(size) {
    return typeof Buffer !== "undefined" ? Buffer.alloc(size) : new Uint8Array(size);
  }
  var tagSymbol = Symbol("@smithy/core/cbor::tagSymbol");
  function tag(data2) {
    data2[tagSymbol] = true;
    return data2;
  }
  var USE_TEXT_DECODER = typeof TextDecoder !== "undefined";
  var USE_BUFFER$1 = typeof Buffer !== "undefined";
  var payload = alloc(0);
  var dataView$1 = new DataView(payload.buffer, payload.byteOffset, payload.byteLength);
  var textDecoder = USE_TEXT_DECODER ? new TextDecoder : null;
  var _offset = 0;
  function setPayload(bytes) {
    payload = bytes;
    dataView$1 = new DataView(payload.buffer, payload.byteOffset, payload.byteLength);
  }
  function decode(at, to) {
    if (at >= to) {
      throw new Error("unexpected end of (decode) payload.");
    }
    const major = (payload[at] & 224) >> 5;
    const minor = payload[at] & 31;
    switch (major) {
      case majorUint64:
      case majorNegativeInt64:
      case majorTag:
        let unsignedInt;
        let offset;
        if (minor < 24) {
          unsignedInt = minor;
          offset = 1;
        } else {
          switch (minor) {
            case extendedOneByte:
            case extendedFloat16:
            case extendedFloat32:
            case extendedFloat64:
              const countLength = minorValueToArgumentLength[minor];
              const countOffset = countLength + 1;
              offset = countOffset;
              if (to - at < countOffset) {
                throw new Error(`countLength ${countLength} greater than remaining buf len.`);
              }
              const countIndex = at + 1;
              if (countLength === 1) {
                unsignedInt = payload[countIndex];
              } else if (countLength === 2) {
                unsignedInt = dataView$1.getUint16(countIndex);
              } else if (countLength === 4) {
                unsignedInt = dataView$1.getUint32(countIndex);
              } else {
                unsignedInt = dataView$1.getBigUint64(countIndex);
              }
              break;
            default:
              throw new Error(`unexpected minor value ${minor}.`);
          }
        }
        if (major === majorUint64) {
          _offset = offset;
          return castBigInt(unsignedInt);
        } else if (major === majorNegativeInt64) {
          let negativeInt;
          if (typeof unsignedInt === "bigint") {
            negativeInt = BigInt(-1) - unsignedInt;
          } else {
            negativeInt = -1 - unsignedInt;
          }
          _offset = offset;
          return castBigInt(negativeInt);
        } else {
          if (minor === 2 || minor === 3) {
            const length = decodeCount(at + offset, to);
            let b = BigInt(0);
            const start = at + offset + _offset;
            for (let i = start;i < start + length; ++i) {
              b = b << BigInt(8) | BigInt(payload[i]);
            }
            _offset = offset + _offset + length;
            return minor === 3 ? -b - BigInt(1) : b;
          } else if (minor === 4) {
            const decimalFraction = decode(at + offset, to);
            const [exponent, mantissa] = decimalFraction;
            const normalizer = mantissa < 0 ? -1 : 1;
            const mantissaStr = "0".repeat(Math.abs(exponent) + 1) + String(BigInt(normalizer) * BigInt(mantissa));
            let numericString;
            const sign = mantissa < 0 ? "-" : "";
            numericString = exponent === 0 ? mantissaStr : mantissaStr.slice(0, mantissaStr.length + exponent) + "." + mantissaStr.slice(exponent);
            numericString = numericString.replace(/^0+/g, "");
            if (numericString === "") {
              numericString = "0";
            }
            if (numericString[0] === ".") {
              numericString = "0" + numericString;
            }
            numericString = sign + numericString;
            _offset = offset + _offset;
            return serde.nv(numericString);
          } else {
            const value = decode(at + offset, to);
            const valueOffset = _offset;
            _offset = offset + valueOffset;
            return tag({ tag: castBigInt(unsignedInt), value });
          }
        }
      case majorUtf8String:
      case majorMap:
      case majorList:
      case majorUnstructuredByteString:
        if (minor === minorIndefinite) {
          switch (major) {
            case majorUtf8String:
              return decodeUtf8StringIndefinite(at, to);
            case majorMap:
              return decodeMapIndefinite(at, to);
            case majorList:
              return decodeListIndefinite(at, to);
            case majorUnstructuredByteString:
              return decodeUnstructuredByteStringIndefinite(at, to);
          }
        } else {
          switch (major) {
            case majorUtf8String:
              return decodeUtf8String(at, to);
            case majorMap:
              return decodeMap(at, to);
            case majorList:
              return decodeList(at, to);
            case majorUnstructuredByteString:
              return decodeUnstructuredByteString(at, to);
          }
        }
      default:
        return decodeSpecial(at, to);
    }
  }
  function bytesToUtf8(bytes, at, to) {
    if (USE_BUFFER$1 && bytes.constructor?.name === "Buffer") {
      return bytes.toString("utf-8", at, to);
    }
    if (textDecoder) {
      return textDecoder.decode(bytes.subarray(at, to));
    }
    return utilUtf8.toUtf8(bytes.subarray(at, to));
  }
  function demote(bigInteger) {
    const num = Number(bigInteger);
    if (num < Number.MIN_SAFE_INTEGER || Number.MAX_SAFE_INTEGER < num) {
      console.warn(new Error(`@smithy/core/cbor - truncating BigInt(${bigInteger}) to ${num} with loss of precision.`));
    }
    return num;
  }
  var minorValueToArgumentLength = {
    [extendedOneByte]: 1,
    [extendedFloat16]: 2,
    [extendedFloat32]: 4,
    [extendedFloat64]: 8
  };
  function bytesToFloat16(a, b) {
    const sign = a >> 7;
    const exponent = (a & 124) >> 2;
    const fraction = (a & 3) << 8 | b;
    const scalar = sign === 0 ? 1 : -1;
    let exponentComponent;
    let summation;
    if (exponent === 0) {
      if (fraction === 0) {
        return 0;
      } else {
        exponentComponent = Math.pow(2, 1 - 15);
        summation = 0;
      }
    } else if (exponent === 31) {
      if (fraction === 0) {
        return scalar * Infinity;
      } else {
        return NaN;
      }
    } else {
      exponentComponent = Math.pow(2, exponent - 15);
      summation = 1;
    }
    summation += fraction / 1024;
    return scalar * (exponentComponent * summation);
  }
  function decodeCount(at, to) {
    const minor = payload[at] & 31;
    if (minor < 24) {
      _offset = 1;
      return minor;
    }
    if (minor === extendedOneByte || minor === extendedFloat16 || minor === extendedFloat32 || minor === extendedFloat64) {
      const countLength = minorValueToArgumentLength[minor];
      _offset = countLength + 1;
      if (to - at < _offset) {
        throw new Error(`countLength ${countLength} greater than remaining buf len.`);
      }
      const countIndex = at + 1;
      if (countLength === 1) {
        return payload[countIndex];
      } else if (countLength === 2) {
        return dataView$1.getUint16(countIndex);
      } else if (countLength === 4) {
        return dataView$1.getUint32(countIndex);
      }
      return demote(dataView$1.getBigUint64(countIndex));
    }
    throw new Error(`unexpected minor value ${minor}.`);
  }
  function decodeUtf8String(at, to) {
    const length = decodeCount(at, to);
    const offset = _offset;
    at += offset;
    if (to - at < length) {
      throw new Error(`string len ${length} greater than remaining buf len.`);
    }
    const value = bytesToUtf8(payload, at, at + length);
    _offset = offset + length;
    return value;
  }
  function decodeUtf8StringIndefinite(at, to) {
    at += 1;
    const vector = [];
    for (const base = at;at < to; ) {
      if (payload[at] === 255) {
        const data2 = alloc(vector.length);
        data2.set(vector, 0);
        _offset = at - base + 2;
        return bytesToUtf8(data2, 0, data2.length);
      }
      const major = (payload[at] & 224) >> 5;
      const minor = payload[at] & 31;
      if (major !== majorUtf8String) {
        throw new Error(`unexpected major type ${major} in indefinite string.`);
      }
      if (minor === minorIndefinite) {
        throw new Error("nested indefinite string.");
      }
      const bytes = decodeUnstructuredByteString(at, to);
      const length = _offset;
      at += length;
      for (let i = 0;i < bytes.length; ++i) {
        vector.push(bytes[i]);
      }
    }
    throw new Error("expected break marker.");
  }
  function decodeUnstructuredByteString(at, to) {
    const length = decodeCount(at, to);
    const offset = _offset;
    at += offset;
    if (to - at < length) {
      throw new Error(`unstructured byte string len ${length} greater than remaining buf len.`);
    }
    const value = payload.subarray(at, at + length);
    _offset = offset + length;
    return value;
  }
  function decodeUnstructuredByteStringIndefinite(at, to) {
    at += 1;
    const vector = [];
    for (const base = at;at < to; ) {
      if (payload[at] === 255) {
        const data2 = alloc(vector.length);
        data2.set(vector, 0);
        _offset = at - base + 2;
        return data2;
      }
      const major = (payload[at] & 224) >> 5;
      const minor = payload[at] & 31;
      if (major !== majorUnstructuredByteString) {
        throw new Error(`unexpected major type ${major} in indefinite string.`);
      }
      if (minor === minorIndefinite) {
        throw new Error("nested indefinite string.");
      }
      const bytes = decodeUnstructuredByteString(at, to);
      const length = _offset;
      at += length;
      for (let i = 0;i < bytes.length; ++i) {
        vector.push(bytes[i]);
      }
    }
    throw new Error("expected break marker.");
  }
  function decodeList(at, to) {
    const listDataLength = decodeCount(at, to);
    const offset = _offset;
    at += offset;
    const base = at;
    const list = Array(listDataLength);
    for (let i = 0;i < listDataLength; ++i) {
      const item = decode(at, to);
      const itemOffset = _offset;
      list[i] = item;
      at += itemOffset;
    }
    _offset = offset + (at - base);
    return list;
  }
  function decodeListIndefinite(at, to) {
    at += 1;
    const list = [];
    for (const base = at;at < to; ) {
      if (payload[at] === 255) {
        _offset = at - base + 2;
        return list;
      }
      const item = decode(at, to);
      const n = _offset;
      at += n;
      list.push(item);
    }
    throw new Error("expected break marker.");
  }
  function decodeMap(at, to) {
    const mapDataLength = decodeCount(at, to);
    const offset = _offset;
    at += offset;
    const base = at;
    const map = {};
    for (let i = 0;i < mapDataLength; ++i) {
      if (at >= to) {
        throw new Error("unexpected end of map payload.");
      }
      const major = (payload[at] & 224) >> 5;
      if (major !== majorUtf8String) {
        throw new Error(`unexpected major type ${major} for map key at index ${at}.`);
      }
      const key = decode(at, to);
      at += _offset;
      const value = decode(at, to);
      at += _offset;
      map[key] = value;
    }
    _offset = offset + (at - base);
    return map;
  }
  function decodeMapIndefinite(at, to) {
    at += 1;
    const base = at;
    const map = {};
    for (;at < to; ) {
      if (at >= to) {
        throw new Error("unexpected end of map payload.");
      }
      if (payload[at] === 255) {
        _offset = at - base + 2;
        return map;
      }
      const major = (payload[at] & 224) >> 5;
      if (major !== majorUtf8String) {
        throw new Error(`unexpected major type ${major} for map key.`);
      }
      const key = decode(at, to);
      at += _offset;
      const value = decode(at, to);
      at += _offset;
      map[key] = value;
    }
    throw new Error("expected break marker.");
  }
  function decodeSpecial(at, to) {
    const minor = payload[at] & 31;
    switch (minor) {
      case specialTrue:
      case specialFalse:
        _offset = 1;
        return minor === specialTrue;
      case specialNull:
        _offset = 1;
        return null;
      case specialUndefined:
        _offset = 1;
        return null;
      case extendedFloat16:
        if (to - at < 3) {
          throw new Error("incomplete float16 at end of buf.");
        }
        _offset = 3;
        return bytesToFloat16(payload[at + 1], payload[at + 2]);
      case extendedFloat32:
        if (to - at < 5) {
          throw new Error("incomplete float32 at end of buf.");
        }
        _offset = 5;
        return dataView$1.getFloat32(at + 1);
      case extendedFloat64:
        if (to - at < 9) {
          throw new Error("incomplete float64 at end of buf.");
        }
        _offset = 9;
        return dataView$1.getFloat64(at + 1);
      default:
        throw new Error(`unexpected minor value ${minor}.`);
    }
  }
  function castBigInt(bigInt) {
    if (typeof bigInt === "number") {
      return bigInt;
    }
    const num = Number(bigInt);
    if (Number.MIN_SAFE_INTEGER <= num && num <= Number.MAX_SAFE_INTEGER) {
      return num;
    }
    return bigInt;
  }
  var USE_BUFFER = typeof Buffer !== "undefined";
  var initialSize = 2048;
  var data = alloc(initialSize);
  var dataView = new DataView(data.buffer, data.byteOffset, data.byteLength);
  var cursor = 0;
  function ensureSpace(bytes) {
    const remaining = data.byteLength - cursor;
    if (remaining < bytes) {
      if (cursor < 16000000) {
        resize(Math.max(data.byteLength * 4, data.byteLength + bytes));
      } else {
        resize(data.byteLength + bytes + 16000000);
      }
    }
  }
  function toUint8Array() {
    const out = alloc(cursor);
    out.set(data.subarray(0, cursor), 0);
    cursor = 0;
    return out;
  }
  function resize(size) {
    const old = data;
    data = alloc(size);
    if (old) {
      if (old.copy) {
        old.copy(data, 0, 0, old.byteLength);
      } else {
        data.set(old, 0);
      }
    }
    dataView = new DataView(data.buffer, data.byteOffset, data.byteLength);
  }
  function encodeHeader(major, value) {
    if (value < 24) {
      data[cursor++] = major << 5 | value;
    } else if (value < 1 << 8) {
      data[cursor++] = major << 5 | 24;
      data[cursor++] = value;
    } else if (value < 1 << 16) {
      data[cursor++] = major << 5 | extendedFloat16;
      dataView.setUint16(cursor, value);
      cursor += 2;
    } else if (value < 2 ** 32) {
      data[cursor++] = major << 5 | extendedFloat32;
      dataView.setUint32(cursor, value);
      cursor += 4;
    } else {
      data[cursor++] = major << 5 | extendedFloat64;
      dataView.setBigUint64(cursor, typeof value === "bigint" ? value : BigInt(value));
      cursor += 8;
    }
  }
  function encode2(_input) {
    const encodeStack = [_input];
    while (encodeStack.length) {
      const input = encodeStack.pop();
      ensureSpace(typeof input === "string" ? input.length * 4 : 64);
      if (typeof input === "string") {
        if (USE_BUFFER) {
          encodeHeader(majorUtf8String, Buffer.byteLength(input));
          cursor += data.write(input, cursor);
        } else {
          const bytes = utilUtf8.fromUtf8(input);
          encodeHeader(majorUtf8String, bytes.byteLength);
          data.set(bytes, cursor);
          cursor += bytes.byteLength;
        }
        continue;
      } else if (typeof input === "number") {
        if (Number.isInteger(input)) {
          const nonNegative = input >= 0;
          const major = nonNegative ? majorUint64 : majorNegativeInt64;
          const value = nonNegative ? input : -input - 1;
          if (value < 24) {
            data[cursor++] = major << 5 | value;
          } else if (value < 256) {
            data[cursor++] = major << 5 | 24;
            data[cursor++] = value;
          } else if (value < 65536) {
            data[cursor++] = major << 5 | extendedFloat16;
            data[cursor++] = value >> 8;
            data[cursor++] = value;
          } else if (value < 4294967296) {
            data[cursor++] = major << 5 | extendedFloat32;
            dataView.setUint32(cursor, value);
            cursor += 4;
          } else {
            data[cursor++] = major << 5 | extendedFloat64;
            dataView.setBigUint64(cursor, BigInt(value));
            cursor += 8;
          }
          continue;
        }
        data[cursor++] = majorSpecial << 5 | extendedFloat64;
        dataView.setFloat64(cursor, input);
        cursor += 8;
        continue;
      } else if (typeof input === "bigint") {
        const nonNegative = input >= 0;
        const major = nonNegative ? majorUint64 : majorNegativeInt64;
        const value = nonNegative ? input : -input - BigInt(1);
        const n = Number(value);
        if (n < 24) {
          data[cursor++] = major << 5 | n;
        } else if (n < 256) {
          data[cursor++] = major << 5 | 24;
          data[cursor++] = n;
        } else if (n < 65536) {
          data[cursor++] = major << 5 | extendedFloat16;
          data[cursor++] = n >> 8;
          data[cursor++] = n & 255;
        } else if (n < 4294967296) {
          data[cursor++] = major << 5 | extendedFloat32;
          dataView.setUint32(cursor, n);
          cursor += 4;
        } else if (value < BigInt("18446744073709551616")) {
          data[cursor++] = major << 5 | extendedFloat64;
          dataView.setBigUint64(cursor, value);
          cursor += 8;
        } else {
          const binaryBigInt = value.toString(2);
          const bigIntBytes = new Uint8Array(Math.ceil(binaryBigInt.length / 8));
          let b = value;
          let i = 0;
          while (bigIntBytes.byteLength - ++i >= 0) {
            bigIntBytes[bigIntBytes.byteLength - i] = Number(b & BigInt(255));
            b >>= BigInt(8);
          }
          ensureSpace(bigIntBytes.byteLength * 2);
          data[cursor++] = nonNegative ? 194 : 195;
          if (USE_BUFFER) {
            encodeHeader(majorUnstructuredByteString, Buffer.byteLength(bigIntBytes));
          } else {
            encodeHeader(majorUnstructuredByteString, bigIntBytes.byteLength);
          }
          data.set(bigIntBytes, cursor);
          cursor += bigIntBytes.byteLength;
        }
        continue;
      } else if (input === null) {
        data[cursor++] = majorSpecial << 5 | specialNull;
        continue;
      } else if (typeof input === "boolean") {
        data[cursor++] = majorSpecial << 5 | (input ? specialTrue : specialFalse);
        continue;
      } else if (typeof input === "undefined") {
        throw new Error("@smithy/core/cbor: client may not serialize undefined value.");
      } else if (Array.isArray(input)) {
        for (let i = input.length - 1;i >= 0; --i) {
          encodeStack.push(input[i]);
        }
        encodeHeader(majorList, input.length);
        continue;
      } else if (typeof input.byteLength === "number") {
        ensureSpace(input.length * 2);
        encodeHeader(majorUnstructuredByteString, input.length);
        data.set(input, cursor);
        cursor += input.byteLength;
        continue;
      } else if (typeof input === "object") {
        if (input instanceof serde.NumericValue) {
          const decimalIndex = input.string.indexOf(".");
          const exponent = decimalIndex === -1 ? 0 : decimalIndex - input.string.length + 1;
          const mantissa = BigInt(input.string.replace(".", ""));
          data[cursor++] = 196;
          encodeStack.push(mantissa);
          encodeStack.push(exponent);
          encodeHeader(majorList, 2);
          continue;
        }
        if (input[tagSymbol]) {
          if ("tag" in input && "value" in input) {
            encodeStack.push(input.value);
            encodeHeader(majorTag, input.tag);
            continue;
          } else {
            throw new Error("tag encountered with missing fields, need 'tag' and 'value', found: " + JSON.stringify(input));
          }
        }
        const keys = Object.keys(input);
        for (let i = keys.length - 1;i >= 0; --i) {
          const key = keys[i];
          encodeStack.push(input[key]);
          encodeStack.push(key);
        }
        encodeHeader(majorMap, keys.length);
        continue;
      }
      throw new Error(`data type ${input?.constructor?.name ?? typeof input} not compatible for encoding.`);
    }
  }
  var cbor = {
    deserialize(payload2) {
      setPayload(payload2);
      return decode(0, payload2.length);
    },
    serialize(input) {
      try {
        encode2(input);
        return toUint8Array();
      } catch (e) {
        toUint8Array();
        throw e;
      }
    },
    resizeEncodingBuffer(size) {
      resize(size);
    }
  };
  var parseCborBody = (streamBody, context) => {
    return protocols.collectBody(streamBody, context).then(async (bytes) => {
      if (bytes.length) {
        try {
          return cbor.deserialize(bytes);
        } catch (e) {
          Object.defineProperty(e, "$responseBodyText", {
            value: context.utf8Encoder(bytes)
          });
          throw e;
        }
      }
      return {};
    });
  };
  var dateToTag = (date) => {
    return tag({
      tag: 1,
      value: date.getTime() / 1000
    });
  };
  var parseCborErrorBody = async (errorBody, context) => {
    const value = await parseCborBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
  };
  var loadSmithyRpcV2CborErrorCode = (output, data2) => {
    const sanitizeErrorCode = (rawValue) => {
      let cleanValue = rawValue;
      if (typeof cleanValue === "number") {
        cleanValue = cleanValue.toString();
      }
      if (cleanValue.indexOf(",") >= 0) {
        cleanValue = cleanValue.split(",")[0];
      }
      if (cleanValue.indexOf(":") >= 0) {
        cleanValue = cleanValue.split(":")[0];
      }
      if (cleanValue.indexOf("#") >= 0) {
        cleanValue = cleanValue.split("#")[1];
      }
      return cleanValue;
    };
    if (data2["__type"] !== undefined) {
      return sanitizeErrorCode(data2["__type"]);
    }
    const codeKey = Object.keys(data2).find((key) => key.toLowerCase() === "code");
    if (codeKey && data2[codeKey] !== undefined) {
      return sanitizeErrorCode(data2[codeKey]);
    }
  };
  var checkCborResponse = (response) => {
    if (String(response.headers["smithy-protocol"]).toLowerCase() !== "rpc-v2-cbor") {
      throw new Error("Malformed RPCv2 CBOR response, status: " + response.statusCode);
    }
  };
  var buildHttpRpcRequest = async (context, headers, path5, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
      protocol,
      hostname,
      port,
      method: "POST",
      path: basePath.endsWith("/") ? basePath.slice(0, -1) + path5 : basePath + path5,
      headers: {
        ...headers
      }
    };
    if (resolvedHostname !== undefined) {
      contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
      contents.body = body;
      try {
        contents.headers["content-length"] = String(utilBodyLengthBrowser.calculateBodyLength(body));
      } catch (e) {}
    }
    return new protocolHttp.HttpRequest(contents);
  };

  class CborCodec extends protocols.SerdeContext {
    createSerializer() {
      const serializer = new CborShapeSerializer;
      serializer.setSerdeContext(this.serdeContext);
      return serializer;
    }
    createDeserializer() {
      const deserializer = new CborShapeDeserializer;
      deserializer.setSerdeContext(this.serdeContext);
      return deserializer;
    }
  }

  class CborShapeSerializer extends protocols.SerdeContext {
    value;
    write(schema2, value) {
      this.value = this.serialize(schema2, value);
    }
    serialize(schema$1, source) {
      const ns = schema.NormalizedSchema.of(schema$1);
      if (source == null) {
        if (ns.isIdempotencyToken()) {
          return serde.generateIdempotencyToken();
        }
        return source;
      }
      if (ns.isBlobSchema()) {
        if (typeof source === "string") {
          return (this.serdeContext?.base64Decoder ?? utilBase64.fromBase64)(source);
        }
        return source;
      }
      if (ns.isTimestampSchema()) {
        if (typeof source === "number" || typeof source === "bigint") {
          return dateToTag(new Date(Number(source) / 1000 | 0));
        }
        return dateToTag(source);
      }
      if (typeof source === "function" || typeof source === "object") {
        const sourceObject = source;
        if (ns.isListSchema() && Array.isArray(sourceObject)) {
          const sparse = !!ns.getMergedTraits().sparse;
          const newArray = [];
          let i = 0;
          for (const item of sourceObject) {
            const value = this.serialize(ns.getValueSchema(), item);
            if (value != null || sparse) {
              newArray[i++] = value;
            }
          }
          return newArray;
        }
        if (sourceObject instanceof Date) {
          return dateToTag(sourceObject);
        }
        const newObject = {};
        if (ns.isMapSchema()) {
          const sparse = !!ns.getMergedTraits().sparse;
          for (const key of Object.keys(sourceObject)) {
            const value = this.serialize(ns.getValueSchema(), sourceObject[key]);
            if (value != null || sparse) {
              newObject[key] = value;
            }
          }
        } else if (ns.isStructSchema()) {
          for (const [key, memberSchema] of ns.structIterator()) {
            const value = this.serialize(memberSchema, sourceObject[key]);
            if (value != null) {
              newObject[key] = value;
            }
          }
          const isUnion = ns.isUnionSchema();
          if (isUnion && Array.isArray(sourceObject.$unknown)) {
            const [k, v] = sourceObject.$unknown;
            newObject[k] = v;
          } else if (typeof sourceObject.__type === "string") {
            for (const [k, v] of Object.entries(sourceObject)) {
              if (!(k in newObject)) {
                newObject[k] = this.serialize(15, v);
              }
            }
          }
        } else if (ns.isDocumentSchema()) {
          for (const key of Object.keys(sourceObject)) {
            newObject[key] = this.serialize(ns.getValueSchema(), sourceObject[key]);
          }
        } else if (ns.isBigDecimalSchema()) {
          return sourceObject;
        }
        return newObject;
      }
      return source;
    }
    flush() {
      const buffer = cbor.serialize(this.value);
      this.value = undefined;
      return buffer;
    }
  }

  class CborShapeDeserializer extends protocols.SerdeContext {
    read(schema2, bytes) {
      const data2 = cbor.deserialize(bytes);
      return this.readValue(schema2, data2);
    }
    readValue(_schema, value) {
      const ns = schema.NormalizedSchema.of(_schema);
      if (ns.isTimestampSchema()) {
        if (typeof value === "number") {
          return serde._parseEpochTimestamp(value);
        }
        if (typeof value === "object") {
          if (value.tag === 1 && "value" in value) {
            return serde._parseEpochTimestamp(value.value);
          }
        }
      }
      if (ns.isBlobSchema()) {
        if (typeof value === "string") {
          return (this.serdeContext?.base64Decoder ?? utilBase64.fromBase64)(value);
        }
        return value;
      }
      if (typeof value === "undefined" || typeof value === "boolean" || typeof value === "number" || typeof value === "string" || typeof value === "bigint" || typeof value === "symbol") {
        return value;
      } else if (typeof value === "object") {
        if (value === null) {
          return null;
        }
        if ("byteLength" in value) {
          return value;
        }
        if (value instanceof Date) {
          return value;
        }
        if (ns.isDocumentSchema()) {
          return value;
        }
        if (ns.isListSchema()) {
          const newArray = [];
          const memberSchema = ns.getValueSchema();
          const sparse = !!ns.getMergedTraits().sparse;
          for (const item of value) {
            const itemValue = this.readValue(memberSchema, item);
            if (itemValue != null || sparse) {
              newArray.push(itemValue);
            }
          }
          return newArray;
        }
        const newObject = {};
        if (ns.isMapSchema()) {
          const sparse = !!ns.getMergedTraits().sparse;
          const targetSchema = ns.getValueSchema();
          for (const key of Object.keys(value)) {
            const itemValue = this.readValue(targetSchema, value[key]);
            if (itemValue != null || sparse) {
              newObject[key] = itemValue;
            }
          }
        } else if (ns.isStructSchema()) {
          const isUnion = ns.isUnionSchema();
          let keys;
          if (isUnion) {
            keys = new Set(Object.keys(value).filter((k) => k !== "__type"));
          }
          for (const [key, memberSchema] of ns.structIterator()) {
            if (isUnion) {
              keys.delete(key);
            }
            if (value[key] != null) {
              newObject[key] = this.readValue(memberSchema, value[key]);
            }
          }
          if (isUnion && keys?.size === 1 && Object.keys(newObject).length === 0) {
            const k = keys.values().next().value;
            newObject.$unknown = [k, value[k]];
          } else if (typeof value.__type === "string") {
            for (const [k, v] of Object.entries(value)) {
              if (!(k in newObject)) {
                newObject[k] = v;
              }
            }
          }
        } else if (value instanceof serde.NumericValue) {
          return value;
        }
        return newObject;
      } else {
        return value;
      }
    }
  }

  class SmithyRpcV2CborProtocol extends protocols.RpcProtocol {
    codec = new CborCodec;
    serializer = this.codec.createSerializer();
    deserializer = this.codec.createDeserializer();
    constructor({ defaultNamespace, errorTypeRegistries }) {
      super({ defaultNamespace, errorTypeRegistries });
    }
    getShapeId() {
      return "smithy.protocols#rpcv2Cbor";
    }
    getPayloadCodec() {
      return this.codec;
    }
    async serializeRequest(operationSchema, input, context) {
      const request = await super.serializeRequest(operationSchema, input, context);
      Object.assign(request.headers, {
        "content-type": this.getDefaultContentType(),
        "smithy-protocol": "rpc-v2-cbor",
        accept: this.getDefaultContentType()
      });
      if (schema.deref(operationSchema.input) === "unit") {
        delete request.body;
        delete request.headers["content-type"];
      } else {
        if (!request.body) {
          this.serializer.write(15, {});
          request.body = this.serializer.flush();
        }
        try {
          request.headers["content-length"] = String(request.body.byteLength);
        } catch (e) {}
      }
      const { service, operation } = utilMiddleware.getSmithyContext(context);
      const path5 = `/service/${service}/operation/${operation}`;
      if (request.path.endsWith("/")) {
        request.path += path5.slice(1);
      } else {
        request.path += path5;
      }
      return request;
    }
    async deserializeResponse(operationSchema, context, response) {
      return super.deserializeResponse(operationSchema, context, response);
    }
    async handleError(operationSchema, context, response, dataObject, metadata) {
      const errorName = loadSmithyRpcV2CborErrorCode(response, dataObject) ?? "Unknown";
      const errorMetadata = {
        $metadata: metadata,
        $fault: response.statusCode <= 500 ? "client" : "server"
      };
      let namespace = this.options.defaultNamespace;
      if (errorName.includes("#")) {
        [namespace] = errorName.split("#");
      }
      const registry = this.compositeErrorRegistry;
      const nsRegistry = schema.TypeRegistry.for(namespace);
      registry.copyFrom(nsRegistry);
      let errorSchema;
      try {
        errorSchema = registry.getSchema(errorName);
      } catch (e) {
        if (dataObject.Message) {
          dataObject.message = dataObject.Message;
        }
        const syntheticRegistry = schema.TypeRegistry.for("smithy.ts.sdk.synthetic." + namespace);
        registry.copyFrom(syntheticRegistry);
        const baseExceptionSchema = registry.getBaseException();
        if (baseExceptionSchema) {
          const ErrorCtor2 = registry.getErrorCtor(baseExceptionSchema);
          throw Object.assign(new ErrorCtor2({ name: errorName }), errorMetadata, dataObject);
        }
        throw Object.assign(new Error(errorName), errorMetadata, dataObject);
      }
      const ns = schema.NormalizedSchema.of(errorSchema);
      const ErrorCtor = registry.getErrorCtor(errorSchema);
      const message = dataObject.message ?? dataObject.Message ?? "Unknown";
      const exception = new ErrorCtor(message);
      const output = {};
      for (const [name, member] of ns.structIterator()) {
        output[name] = this.deserializer.readValue(member, dataObject[name]);
      }
      throw Object.assign(exception, errorMetadata, {
        $fault: ns.getMergedTraits().error,
        message
      }, output);
    }
    getDefaultContentType() {
      return "application/cbor";
    }
  }
  exports.CborCodec = CborCodec;
  exports.CborShapeDeserializer = CborShapeDeserializer;
  exports.CborShapeSerializer = CborShapeSerializer;
  exports.SmithyRpcV2CborProtocol = SmithyRpcV2CborProtocol;
  exports.buildHttpRpcRequest = buildHttpRpcRequest;
  exports.cbor = cbor;
  exports.checkCborResponse = checkCborResponse;
  exports.dateToTag = dateToTag;
  exports.loadSmithyRpcV2CborErrorCode = loadSmithyRpcV2CborErrorCode;
  exports.parseCborBody = parseCborBody;
  exports.parseCborErrorBody = parseCborErrorBody;
  exports.tag = tag;
  exports.tagSymbol = tagSymbol;
});

// ../node_modules/.bun/@smithy+middleware-stack@4.2.8/node_modules/@smithy/middleware-stack/dist-cjs/index.js
var require_dist_cjs27 = __commonJS((exports) => {
  var getAllAliases = (name, aliases) => {
    const _aliases = [];
    if (name) {
      _aliases.push(name);
    }
    if (aliases) {
      for (const alias of aliases) {
        _aliases.push(alias);
      }
    }
    return _aliases;
  };
  var getMiddlewareNameWithAliases = (name, aliases) => {
    return `${name || "anonymous"}${aliases && aliases.length > 0 ? ` (a.k.a. ${aliases.join(",")})` : ""}`;
  };
  var constructStack = () => {
    let absoluteEntries = [];
    let relativeEntries = [];
    let identifyOnResolve = false;
    const entriesNameSet = new Set;
    const sort = (entries) => entries.sort((a, b) => stepWeights[b.step] - stepWeights[a.step] || priorityWeights[b.priority || "normal"] - priorityWeights[a.priority || "normal"]);
    const removeByName = (toRemove) => {
      let isRemoved = false;
      const filterCb = (entry) => {
        const aliases = getAllAliases(entry.name, entry.aliases);
        if (aliases.includes(toRemove)) {
          isRemoved = true;
          for (const alias of aliases) {
            entriesNameSet.delete(alias);
          }
          return false;
        }
        return true;
      };
      absoluteEntries = absoluteEntries.filter(filterCb);
      relativeEntries = relativeEntries.filter(filterCb);
      return isRemoved;
    };
    const removeByReference = (toRemove) => {
      let isRemoved = false;
      const filterCb = (entry) => {
        if (entry.middleware === toRemove) {
          isRemoved = true;
          for (const alias of getAllAliases(entry.name, entry.aliases)) {
            entriesNameSet.delete(alias);
          }
          return false;
        }
        return true;
      };
      absoluteEntries = absoluteEntries.filter(filterCb);
      relativeEntries = relativeEntries.filter(filterCb);
      return isRemoved;
    };
    const cloneTo = (toStack) => {
      absoluteEntries.forEach((entry) => {
        toStack.add(entry.middleware, { ...entry });
      });
      relativeEntries.forEach((entry) => {
        toStack.addRelativeTo(entry.middleware, { ...entry });
      });
      toStack.identifyOnResolve?.(stack.identifyOnResolve());
      return toStack;
    };
    const expandRelativeMiddlewareList = (from) => {
      const expandedMiddlewareList = [];
      from.before.forEach((entry) => {
        if (entry.before.length === 0 && entry.after.length === 0) {
          expandedMiddlewareList.push(entry);
        } else {
          expandedMiddlewareList.push(...expandRelativeMiddlewareList(entry));
        }
      });
      expandedMiddlewareList.push(from);
      from.after.reverse().forEach((entry) => {
        if (entry.before.length === 0 && entry.after.length === 0) {
          expandedMiddlewareList.push(entry);
        } else {
          expandedMiddlewareList.push(...expandRelativeMiddlewareList(entry));
        }
      });
      return expandedMiddlewareList;
    };
    const getMiddlewareList = (debug = false) => {
      const normalizedAbsoluteEntries = [];
      const normalizedRelativeEntries = [];
      const normalizedEntriesNameMap = {};
      absoluteEntries.forEach((entry) => {
        const normalizedEntry = {
          ...entry,
          before: [],
          after: []
        };
        for (const alias of getAllAliases(normalizedEntry.name, normalizedEntry.aliases)) {
          normalizedEntriesNameMap[alias] = normalizedEntry;
        }
        normalizedAbsoluteEntries.push(normalizedEntry);
      });
      relativeEntries.forEach((entry) => {
        const normalizedEntry = {
          ...entry,
          before: [],
          after: []
        };
        for (const alias of getAllAliases(normalizedEntry.name, normalizedEntry.aliases)) {
          normalizedEntriesNameMap[alias] = normalizedEntry;
        }
        normalizedRelativeEntries.push(normalizedEntry);
      });
      normalizedRelativeEntries.forEach((entry) => {
        if (entry.toMiddleware) {
          const toMiddleware = normalizedEntriesNameMap[entry.toMiddleware];
          if (toMiddleware === undefined) {
            if (debug) {
              return;
            }
            throw new Error(`${entry.toMiddleware} is not found when adding ` + `${getMiddlewareNameWithAliases(entry.name, entry.aliases)} ` + `middleware ${entry.relation} ${entry.toMiddleware}`);
          }
          if (entry.relation === "after") {
            toMiddleware.after.push(entry);
          }
          if (entry.relation === "before") {
            toMiddleware.before.push(entry);
          }
        }
      });
      const mainChain = sort(normalizedAbsoluteEntries).map(expandRelativeMiddlewareList).reduce((wholeList, expandedMiddlewareList) => {
        wholeList.push(...expandedMiddlewareList);
        return wholeList;
      }, []);
      return mainChain;
    };
    const stack = {
      add: (middleware, options = {}) => {
        const { name, override, aliases: _aliases } = options;
        const entry = {
          step: "initialize",
          priority: "normal",
          middleware,
          ...options
        };
        const aliases = getAllAliases(name, _aliases);
        if (aliases.length > 0) {
          if (aliases.some((alias) => entriesNameSet.has(alias))) {
            if (!override)
              throw new Error(`Duplicate middleware name '${getMiddlewareNameWithAliases(name, _aliases)}'`);
            for (const alias of aliases) {
              const toOverrideIndex = absoluteEntries.findIndex((entry2) => entry2.name === alias || entry2.aliases?.some((a) => a === alias));
              if (toOverrideIndex === -1) {
                continue;
              }
              const toOverride = absoluteEntries[toOverrideIndex];
              if (toOverride.step !== entry.step || entry.priority !== toOverride.priority) {
                throw new Error(`"${getMiddlewareNameWithAliases(toOverride.name, toOverride.aliases)}" middleware with ` + `${toOverride.priority} priority in ${toOverride.step} step cannot ` + `be overridden by "${getMiddlewareNameWithAliases(name, _aliases)}" middleware with ` + `${entry.priority} priority in ${entry.step} step.`);
              }
              absoluteEntries.splice(toOverrideIndex, 1);
            }
          }
          for (const alias of aliases) {
            entriesNameSet.add(alias);
          }
        }
        absoluteEntries.push(entry);
      },
      addRelativeTo: (middleware, options) => {
        const { name, override, aliases: _aliases } = options;
        const entry = {
          middleware,
          ...options
        };
        const aliases = getAllAliases(name, _aliases);
        if (aliases.length > 0) {
          if (aliases.some((alias) => entriesNameSet.has(alias))) {
            if (!override)
              throw new Error(`Duplicate middleware name '${getMiddlewareNameWithAliases(name, _aliases)}'`);
            for (const alias of aliases) {
              const toOverrideIndex = relativeEntries.findIndex((entry2) => entry2.name === alias || entry2.aliases?.some((a) => a === alias));
              if (toOverrideIndex === -1) {
                continue;
              }
              const toOverride = relativeEntries[toOverrideIndex];
              if (toOverride.toMiddleware !== entry.toMiddleware || toOverride.relation !== entry.relation) {
                throw new Error(`"${getMiddlewareNameWithAliases(toOverride.name, toOverride.aliases)}" middleware ` + `${toOverride.relation} "${toOverride.toMiddleware}" middleware cannot be overridden ` + `by "${getMiddlewareNameWithAliases(name, _aliases)}" middleware ${entry.relation} ` + `"${entry.toMiddleware}" middleware.`);
              }
              relativeEntries.splice(toOverrideIndex, 1);
            }
          }
          for (const alias of aliases) {
            entriesNameSet.add(alias);
          }
        }
        relativeEntries.push(entry);
      },
      clone: () => cloneTo(constructStack()),
      use: (plugin) => {
        plugin.applyToStack(stack);
      },
      remove: (toRemove) => {
        if (typeof toRemove === "string")
          return removeByName(toRemove);
        else
          return removeByReference(toRemove);
      },
      removeByTag: (toRemove) => {
        let isRemoved = false;
        const filterCb = (entry) => {
          const { tags, name, aliases: _aliases } = entry;
          if (tags && tags.includes(toRemove)) {
            const aliases = getAllAliases(name, _aliases);
            for (const alias of aliases) {
              entriesNameSet.delete(alias);
            }
            isRemoved = true;
            return false;
          }
          return true;
        };
        absoluteEntries = absoluteEntries.filter(filterCb);
        relativeEntries = relativeEntries.filter(filterCb);
        return isRemoved;
      },
      concat: (from) => {
        const cloned = cloneTo(constructStack());
        cloned.use(from);
        cloned.identifyOnResolve(identifyOnResolve || cloned.identifyOnResolve() || (from.identifyOnResolve?.() ?? false));
        return cloned;
      },
      applyToStack: cloneTo,
      identify: () => {
        return getMiddlewareList(true).map((mw) => {
          const step = mw.step ?? mw.relation + " " + mw.toMiddleware;
          return getMiddlewareNameWithAliases(mw.name, mw.aliases) + " - " + step;
        });
      },
      identifyOnResolve(toggle) {
        if (typeof toggle === "boolean")
          identifyOnResolve = toggle;
        return identifyOnResolve;
      },
      resolve: (handler, context) => {
        for (const middleware of getMiddlewareList().map((entry) => entry.middleware).reverse()) {
          handler = middleware(handler, context);
        }
        if (identifyOnResolve) {
          console.log(stack.identify());
        }
        return handler;
      }
    };
    return stack;
  };
  var stepWeights = {
    initialize: 5,
    serialize: 4,
    build: 3,
    finalizeRequest: 2,
    deserialize: 1
  };
  var priorityWeights = {
    high: 3,
    normal: 2,
    low: 1
  };
  exports.constructStack = constructStack;
});

// ../node_modules/.bun/@smithy+smithy-client@4.11.5/node_modules/@smithy/smithy-client/dist-cjs/index.js
var require_dist_cjs28 = __commonJS((exports) => {
  var middlewareStack = require_dist_cjs27();
  var protocols = require_protocols();
  var types = require_dist_cjs();
  var schema = require_schema();
  var serde = require_serde();

  class Client {
    config;
    middlewareStack = middlewareStack.constructStack();
    initConfig;
    handlers;
    constructor(config) {
      this.config = config;
      const { protocol, protocolSettings } = config;
      if (protocolSettings) {
        if (typeof protocol === "function") {
          config.protocol = new protocol(protocolSettings);
        }
      }
    }
    send(command, optionsOrCb, cb) {
      const options = typeof optionsOrCb !== "function" ? optionsOrCb : undefined;
      const callback = typeof optionsOrCb === "function" ? optionsOrCb : cb;
      const useHandlerCache = options === undefined && this.config.cacheMiddleware === true;
      let handler;
      if (useHandlerCache) {
        if (!this.handlers) {
          this.handlers = new WeakMap;
        }
        const handlers = this.handlers;
        if (handlers.has(command.constructor)) {
          handler = handlers.get(command.constructor);
        } else {
          handler = command.resolveMiddleware(this.middlewareStack, this.config, options);
          handlers.set(command.constructor, handler);
        }
      } else {
        delete this.handlers;
        handler = command.resolveMiddleware(this.middlewareStack, this.config, options);
      }
      if (callback) {
        handler(command).then((result) => callback(null, result.output), (err) => callback(err)).catch(() => {});
      } else {
        return handler(command).then((result) => result.output);
      }
    }
    destroy() {
      this.config?.requestHandler?.destroy?.();
      delete this.handlers;
    }
  }
  var SENSITIVE_STRING$1 = "***SensitiveInformation***";
  function schemaLogFilter(schema$1, data) {
    if (data == null) {
      return data;
    }
    const ns = schema.NormalizedSchema.of(schema$1);
    if (ns.getMergedTraits().sensitive) {
      return SENSITIVE_STRING$1;
    }
    if (ns.isListSchema()) {
      const isSensitive = !!ns.getValueSchema().getMergedTraits().sensitive;
      if (isSensitive) {
        return SENSITIVE_STRING$1;
      }
    } else if (ns.isMapSchema()) {
      const isSensitive = !!ns.getKeySchema().getMergedTraits().sensitive || !!ns.getValueSchema().getMergedTraits().sensitive;
      if (isSensitive) {
        return SENSITIVE_STRING$1;
      }
    } else if (ns.isStructSchema() && typeof data === "object") {
      const object = data;
      const newObject = {};
      for (const [member, memberNs] of ns.structIterator()) {
        if (object[member] != null) {
          newObject[member] = schemaLogFilter(memberNs, object[member]);
        }
      }
      return newObject;
    }
    return data;
  }

  class Command {
    middlewareStack = middlewareStack.constructStack();
    schema;
    static classBuilder() {
      return new ClassBuilder;
    }
    resolveMiddlewareWithContext(clientStack, configuration, options, { middlewareFn, clientName, commandName, inputFilterSensitiveLog, outputFilterSensitiveLog, smithyContext, additionalContext, CommandCtor }) {
      for (const mw of middlewareFn.bind(this)(CommandCtor, clientStack, configuration, options)) {
        this.middlewareStack.use(mw);
      }
      const stack = clientStack.concat(this.middlewareStack);
      const { logger } = configuration;
      const handlerExecutionContext = {
        logger,
        clientName,
        commandName,
        inputFilterSensitiveLog,
        outputFilterSensitiveLog,
        [types.SMITHY_CONTEXT_KEY]: {
          commandInstance: this,
          ...smithyContext
        },
        ...additionalContext
      };
      const { requestHandler } = configuration;
      return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
  }

  class ClassBuilder {
    _init = () => {};
    _ep = {};
    _middlewareFn = () => [];
    _commandName = "";
    _clientName = "";
    _additionalContext = {};
    _smithyContext = {};
    _inputFilterSensitiveLog = undefined;
    _outputFilterSensitiveLog = undefined;
    _serializer = null;
    _deserializer = null;
    _operationSchema;
    init(cb) {
      this._init = cb;
    }
    ep(endpointParameterInstructions) {
      this._ep = endpointParameterInstructions;
      return this;
    }
    m(middlewareSupplier) {
      this._middlewareFn = middlewareSupplier;
      return this;
    }
    s(service, operation, smithyContext = {}) {
      this._smithyContext = {
        service,
        operation,
        ...smithyContext
      };
      return this;
    }
    c(additionalContext = {}) {
      this._additionalContext = additionalContext;
      return this;
    }
    n(clientName, commandName) {
      this._clientName = clientName;
      this._commandName = commandName;
      return this;
    }
    f(inputFilter = (_) => _, outputFilter = (_) => _) {
      this._inputFilterSensitiveLog = inputFilter;
      this._outputFilterSensitiveLog = outputFilter;
      return this;
    }
    ser(serializer) {
      this._serializer = serializer;
      return this;
    }
    de(deserializer) {
      this._deserializer = deserializer;
      return this;
    }
    sc(operation) {
      this._operationSchema = operation;
      this._smithyContext.operationSchema = operation;
      return this;
    }
    build() {
      const closure = this;
      let CommandRef;
      return CommandRef = class extends Command {
        input;
        static getEndpointParameterInstructions() {
          return closure._ep;
        }
        constructor(...[input]) {
          super();
          this.input = input ?? {};
          closure._init(this);
          this.schema = closure._operationSchema;
        }
        resolveMiddleware(stack, configuration, options) {
          const op = closure._operationSchema;
          const input = op?.[4] ?? op?.input;
          const output = op?.[5] ?? op?.output;
          return this.resolveMiddlewareWithContext(stack, configuration, options, {
            CommandCtor: CommandRef,
            middlewareFn: closure._middlewareFn,
            clientName: closure._clientName,
            commandName: closure._commandName,
            inputFilterSensitiveLog: closure._inputFilterSensitiveLog ?? (op ? schemaLogFilter.bind(null, input) : (_) => _),
            outputFilterSensitiveLog: closure._outputFilterSensitiveLog ?? (op ? schemaLogFilter.bind(null, output) : (_) => _),
            smithyContext: closure._smithyContext,
            additionalContext: closure._additionalContext
          });
        }
        serialize = closure._serializer;
        deserialize = closure._deserializer;
      };
    }
  }
  var SENSITIVE_STRING = "***SensitiveInformation***";
  var createAggregatedClient = (commands, Client2, options) => {
    for (const [command, CommandCtor] of Object.entries(commands)) {
      const methodImpl = async function(args, optionsOrCb, cb) {
        const command2 = new CommandCtor(args);
        if (typeof optionsOrCb === "function") {
          this.send(command2, optionsOrCb);
        } else if (typeof cb === "function") {
          if (typeof optionsOrCb !== "object")
            throw new Error(`Expected http options but got ${typeof optionsOrCb}`);
          this.send(command2, optionsOrCb || {}, cb);
        } else {
          return this.send(command2, optionsOrCb);
        }
      };
      const methodName = (command[0].toLowerCase() + command.slice(1)).replace(/Command$/, "");
      Client2.prototype[methodName] = methodImpl;
    }
    const { paginators = {}, waiters = {} } = options ?? {};
    for (const [paginatorName, paginatorFn] of Object.entries(paginators)) {
      if (Client2.prototype[paginatorName] === undefined) {
        Client2.prototype[paginatorName] = function(commandInput = {}, paginationConfiguration, ...rest) {
          return paginatorFn({
            ...paginationConfiguration,
            client: this
          }, commandInput, ...rest);
        };
      }
    }
    for (const [waiterName, waiterFn] of Object.entries(waiters)) {
      if (Client2.prototype[waiterName] === undefined) {
        Client2.prototype[waiterName] = async function(commandInput = {}, waiterConfiguration, ...rest) {
          let config = waiterConfiguration;
          if (typeof waiterConfiguration === "number") {
            config = {
              maxWaitTime: waiterConfiguration
            };
          }
          return waiterFn({
            ...config,
            client: this
          }, commandInput, ...rest);
        };
      }
    }
  };

  class ServiceException extends Error {
    $fault;
    $response;
    $retryable;
    $metadata;
    constructor(options) {
      super(options.message);
      Object.setPrototypeOf(this, Object.getPrototypeOf(this).constructor.prototype);
      this.name = options.name;
      this.$fault = options.$fault;
      this.$metadata = options.$metadata;
    }
    static isInstance(value) {
      if (!value)
        return false;
      const candidate = value;
      return ServiceException.prototype.isPrototypeOf(candidate) || Boolean(candidate.$fault) && Boolean(candidate.$metadata) && (candidate.$fault === "client" || candidate.$fault === "server");
    }
    static [Symbol.hasInstance](instance) {
      if (!instance)
        return false;
      const candidate = instance;
      if (this === ServiceException) {
        return ServiceException.isInstance(instance);
      }
      if (ServiceException.isInstance(instance)) {
        if (candidate.name && this.name) {
          return this.prototype.isPrototypeOf(instance) || candidate.name === this.name;
        }
        return this.prototype.isPrototypeOf(instance);
      }
      return false;
    }
  }
  var decorateServiceException = (exception, additions = {}) => {
    Object.entries(additions).filter(([, v]) => v !== undefined).forEach(([k, v]) => {
      if (exception[k] == undefined || exception[k] === "") {
        exception[k] = v;
      }
    });
    const message = exception.message || exception.Message || "UnknownError";
    exception.message = message;
    delete exception.Message;
    return exception;
  };
  var throwDefaultError = ({ output, parsedBody, exceptionCtor, errorCode }) => {
    const $metadata = deserializeMetadata(output);
    const statusCode = $metadata.httpStatusCode ? $metadata.httpStatusCode + "" : undefined;
    const response = new exceptionCtor({
      name: parsedBody?.code || parsedBody?.Code || errorCode || statusCode || "UnknownError",
      $fault: "client",
      $metadata
    });
    throw decorateServiceException(response, parsedBody);
  };
  var withBaseException = (ExceptionCtor) => {
    return ({ output, parsedBody, errorCode }) => {
      throwDefaultError({ output, parsedBody, exceptionCtor: ExceptionCtor, errorCode });
    };
  };
  var deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"]
  });
  var loadConfigsForDefaultMode = (mode) => {
    switch (mode) {
      case "standard":
        return {
          retryMode: "standard",
          connectionTimeout: 3100
        };
      case "in-region":
        return {
          retryMode: "standard",
          connectionTimeout: 1100
        };
      case "cross-region":
        return {
          retryMode: "standard",
          connectionTimeout: 3100
        };
      case "mobile":
        return {
          retryMode: "standard",
          connectionTimeout: 30000
        };
      default:
        return {};
    }
  };
  var warningEmitted = false;
  var emitWarningIfUnsupportedVersion = (version) => {
    if (version && !warningEmitted && parseInt(version.substring(1, version.indexOf("."))) < 16) {
      warningEmitted = true;
    }
  };
  var getChecksumConfiguration = (runtimeConfig) => {
    const checksumAlgorithms = [];
    for (const id in types.AlgorithmId) {
      const algorithmId = types.AlgorithmId[id];
      if (runtimeConfig[algorithmId] === undefined) {
        continue;
      }
      checksumAlgorithms.push({
        algorithmId: () => algorithmId,
        checksumConstructor: () => runtimeConfig[algorithmId]
      });
    }
    return {
      addChecksumAlgorithm(algo) {
        checksumAlgorithms.push(algo);
      },
      checksumAlgorithms() {
        return checksumAlgorithms;
      }
    };
  };
  var resolveChecksumRuntimeConfig = (clientConfig) => {
    const runtimeConfig = {};
    clientConfig.checksumAlgorithms().forEach((checksumAlgorithm) => {
      runtimeConfig[checksumAlgorithm.algorithmId()] = checksumAlgorithm.checksumConstructor();
    });
    return runtimeConfig;
  };
  var getRetryConfiguration = (runtimeConfig) => {
    return {
      setRetryStrategy(retryStrategy) {
        runtimeConfig.retryStrategy = retryStrategy;
      },
      retryStrategy() {
        return runtimeConfig.retryStrategy;
      }
    };
  };
  var resolveRetryRuntimeConfig = (retryStrategyConfiguration) => {
    const runtimeConfig = {};
    runtimeConfig.retryStrategy = retryStrategyConfiguration.retryStrategy();
    return runtimeConfig;
  };
  var getDefaultExtensionConfiguration = (runtimeConfig) => {
    return Object.assign(getChecksumConfiguration(runtimeConfig), getRetryConfiguration(runtimeConfig));
  };
  var getDefaultClientConfiguration = getDefaultExtensionConfiguration;
  var resolveDefaultRuntimeConfig = (config) => {
    return Object.assign(resolveChecksumRuntimeConfig(config), resolveRetryRuntimeConfig(config));
  };
  var getArrayIfSingleItem = (mayBeArray) => Array.isArray(mayBeArray) ? mayBeArray : [mayBeArray];
  var getValueFromTextNode = (obj) => {
    const textNodeName = "#text";
    for (const key in obj) {
      if (obj.hasOwnProperty(key) && obj[key][textNodeName] !== undefined) {
        obj[key] = obj[key][textNodeName];
      } else if (typeof obj[key] === "object" && obj[key] !== null) {
        obj[key] = getValueFromTextNode(obj[key]);
      }
    }
    return obj;
  };
  var isSerializableHeaderValue = (value) => {
    return value != null;
  };

  class NoOpLogger {
    trace() {}
    debug() {}
    info() {}
    warn() {}
    error() {}
  }
  function map(arg0, arg1, arg2) {
    let target;
    let filter;
    let instructions;
    if (typeof arg1 === "undefined" && typeof arg2 === "undefined") {
      target = {};
      instructions = arg0;
    } else {
      target = arg0;
      if (typeof arg1 === "function") {
        filter = arg1;
        instructions = arg2;
        return mapWithFilter(target, filter, instructions);
      } else {
        instructions = arg1;
      }
    }
    for (const key of Object.keys(instructions)) {
      if (!Array.isArray(instructions[key])) {
        target[key] = instructions[key];
        continue;
      }
      applyInstruction(target, null, instructions, key);
    }
    return target;
  }
  var convertMap = (target) => {
    const output = {};
    for (const [k, v] of Object.entries(target || {})) {
      output[k] = [, v];
    }
    return output;
  };
  var take = (source, instructions) => {
    const out = {};
    for (const key in instructions) {
      applyInstruction(out, source, instructions, key);
    }
    return out;
  };
  var mapWithFilter = (target, filter, instructions) => {
    return map(target, Object.entries(instructions).reduce((_instructions, [key, value]) => {
      if (Array.isArray(value)) {
        _instructions[key] = value;
      } else {
        if (typeof value === "function") {
          _instructions[key] = [filter, value()];
        } else {
          _instructions[key] = [filter, value];
        }
      }
      return _instructions;
    }, {}));
  };
  var applyInstruction = (target, source, instructions, targetKey) => {
    if (source !== null) {
      let instruction = instructions[targetKey];
      if (typeof instruction === "function") {
        instruction = [, instruction];
      }
      const [filter2 = nonNullish, valueFn = pass, sourceKey = targetKey] = instruction;
      if (typeof filter2 === "function" && filter2(source[sourceKey]) || typeof filter2 !== "function" && !!filter2) {
        target[targetKey] = valueFn(source[sourceKey]);
      }
      return;
    }
    let [filter, value] = instructions[targetKey];
    if (typeof value === "function") {
      let _value;
      const defaultFilterPassed = filter === undefined && (_value = value()) != null;
      const customFilterPassed = typeof filter === "function" && !!filter(undefined) || typeof filter !== "function" && !!filter;
      if (defaultFilterPassed) {
        target[targetKey] = _value;
      } else if (customFilterPassed) {
        target[targetKey] = value();
      }
    } else {
      const defaultFilterPassed = filter === undefined && value != null;
      const customFilterPassed = typeof filter === "function" && !!filter(value) || typeof filter !== "function" && !!filter;
      if (defaultFilterPassed || customFilterPassed) {
        target[targetKey] = value;
      }
    }
  };
  var nonNullish = (_) => _ != null;
  var pass = (_) => _;
  var serializeFloat = (value) => {
    if (value !== value) {
      return "NaN";
    }
    switch (value) {
      case Infinity:
        return "Infinity";
      case -Infinity:
        return "-Infinity";
      default:
        return value;
    }
  };
  var serializeDateTime = (date) => date.toISOString().replace(".000Z", "Z");
  var _json = (obj) => {
    if (obj == null) {
      return {};
    }
    if (Array.isArray(obj)) {
      return obj.filter((_) => _ != null).map(_json);
    }
    if (typeof obj === "object") {
      const target = {};
      for (const key of Object.keys(obj)) {
        if (obj[key] == null) {
          continue;
        }
        target[key] = _json(obj[key]);
      }
      return target;
    }
    return obj;
  };
  Object.defineProperty(exports, "collectBody", {
    enumerable: true,
    get: function() {
      return protocols.collectBody;
    }
  });
  Object.defineProperty(exports, "extendedEncodeURIComponent", {
    enumerable: true,
    get: function() {
      return protocols.extendedEncodeURIComponent;
    }
  });
  Object.defineProperty(exports, "resolvedPath", {
    enumerable: true,
    get: function() {
      return protocols.resolvedPath;
    }
  });
  exports.Client = Client;
  exports.Command = Command;
  exports.NoOpLogger = NoOpLogger;
  exports.SENSITIVE_STRING = SENSITIVE_STRING;
  exports.ServiceException = ServiceException;
  exports._json = _json;
  exports.convertMap = convertMap;
  exports.createAggregatedClient = createAggregatedClient;
  exports.decorateServiceException = decorateServiceException;
  exports.emitWarningIfUnsupportedVersion = emitWarningIfUnsupportedVersion;
  exports.getArrayIfSingleItem = getArrayIfSingleItem;
  exports.getDefaultClientConfiguration = getDefaultClientConfiguration;
  exports.getDefaultExtensionConfiguration = getDefaultExtensionConfiguration;
  exports.getValueFromTextNode = getValueFromTextNode;
  exports.isSerializableHeaderValue = isSerializableHeaderValue;
  exports.loadConfigsForDefaultMode = loadConfigsForDefaultMode;
  exports.map = map;
  exports.resolveDefaultRuntimeConfig = resolveDefaultRuntimeConfig;
  exports.serializeDateTime = serializeDateTime;
  exports.serializeFloat = serializeFloat;
  exports.take = take;
  exports.throwDefaultError = throwDefaultError;
  exports.withBaseException = withBaseException;
  Object.keys(serde).forEach(function(k) {
    if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports, k))
      Object.defineProperty(exports, k, {
        enumerable: true,
        get: function() {
          return serde[k];
        }
      });
  });
});

// ../node_modules/.bun/fast-xml-parser@5.3.6/node_modules/fast-xml-parser/lib/fxp.cjs
var require_fxp = __commonJS((exports, module) => {
  (() => {
    var t = { d: (e2, n2) => {
      for (var i2 in n2)
        t.o(n2, i2) && !t.o(e2, i2) && Object.defineProperty(e2, i2, { enumerable: true, get: n2[i2] });
    }, o: (t2, e2) => Object.prototype.hasOwnProperty.call(t2, e2), r: (t2) => {
      typeof Symbol != "undefined" && Symbol.toStringTag && Object.defineProperty(t2, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(t2, "__esModule", { value: true });
    } }, e = {};
    t.r(e), t.d(e, { XMLBuilder: () => dt, XMLParser: () => it, XMLValidator: () => gt });
    const n = ":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD", i = new RegExp("^[" + n + "][" + n + "\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040]*$");
    function s(t2, e2) {
      const n2 = [];
      let i2 = e2.exec(t2);
      for (;i2; ) {
        const s2 = [];
        s2.startIndex = e2.lastIndex - i2[0].length;
        const r2 = i2.length;
        for (let t3 = 0;t3 < r2; t3++)
          s2.push(i2[t3]);
        n2.push(s2), i2 = e2.exec(t2);
      }
      return n2;
    }
    const r = function(t2) {
      return !(i.exec(t2) == null);
    }, o = { allowBooleanAttributes: false, unpairedTags: [] };
    function a(t2, e2) {
      e2 = Object.assign({}, o, e2);
      const n2 = [];
      let i2 = false, s2 = false;
      t2[0] === "\uFEFF" && (t2 = t2.substr(1));
      for (let o2 = 0;o2 < t2.length; o2++)
        if (t2[o2] === "<" && t2[o2 + 1] === "?") {
          if (o2 += 2, o2 = u(t2, o2), o2.err)
            return o2;
        } else {
          if (t2[o2] !== "<") {
            if (l(t2[o2]))
              continue;
            return m("InvalidChar", "char '" + t2[o2] + "' is not expected.", b(t2, o2));
          }
          {
            let a2 = o2;
            if (o2++, t2[o2] === "!") {
              o2 = h(t2, o2);
              continue;
            }
            {
              let d2 = false;
              t2[o2] === "/" && (d2 = true, o2++);
              let p2 = "";
              for (;o2 < t2.length && t2[o2] !== ">" && t2[o2] !== " " && t2[o2] !== "\t" && t2[o2] !== `
` && t2[o2] !== "\r"; o2++)
                p2 += t2[o2];
              if (p2 = p2.trim(), p2[p2.length - 1] === "/" && (p2 = p2.substring(0, p2.length - 1), o2--), !r(p2)) {
                let e3;
                return e3 = p2.trim().length === 0 ? "Invalid space after '<'." : "Tag '" + p2 + "' is an invalid name.", m("InvalidTag", e3, b(t2, o2));
              }
              const c2 = f(t2, o2);
              if (c2 === false)
                return m("InvalidAttr", "Attributes for '" + p2 + "' have open quote.", b(t2, o2));
              let E2 = c2.value;
              if (o2 = c2.index, E2[E2.length - 1] === "/") {
                const n3 = o2 - E2.length;
                E2 = E2.substring(0, E2.length - 1);
                const s3 = g(E2, e2);
                if (s3 !== true)
                  return m(s3.err.code, s3.err.msg, b(t2, n3 + s3.err.line));
                i2 = true;
              } else if (d2) {
                if (!c2.tagClosed)
                  return m("InvalidTag", "Closing tag '" + p2 + "' doesn't have proper closing.", b(t2, o2));
                if (E2.trim().length > 0)
                  return m("InvalidTag", "Closing tag '" + p2 + "' can't have attributes or invalid starting.", b(t2, a2));
                if (n2.length === 0)
                  return m("InvalidTag", "Closing tag '" + p2 + "' has not been opened.", b(t2, a2));
                {
                  const e3 = n2.pop();
                  if (p2 !== e3.tagName) {
                    let n3 = b(t2, e3.tagStartPos);
                    return m("InvalidTag", "Expected closing tag '" + e3.tagName + "' (opened in line " + n3.line + ", col " + n3.col + ") instead of closing tag '" + p2 + "'.", b(t2, a2));
                  }
                  n2.length == 0 && (s2 = true);
                }
              } else {
                const r2 = g(E2, e2);
                if (r2 !== true)
                  return m(r2.err.code, r2.err.msg, b(t2, o2 - E2.length + r2.err.line));
                if (s2 === true)
                  return m("InvalidXml", "Multiple possible root nodes found.", b(t2, o2));
                e2.unpairedTags.indexOf(p2) !== -1 || n2.push({ tagName: p2, tagStartPos: a2 }), i2 = true;
              }
              for (o2++;o2 < t2.length; o2++)
                if (t2[o2] === "<") {
                  if (t2[o2 + 1] === "!") {
                    o2++, o2 = h(t2, o2);
                    continue;
                  }
                  if (t2[o2 + 1] !== "?")
                    break;
                  if (o2 = u(t2, ++o2), o2.err)
                    return o2;
                } else if (t2[o2] === "&") {
                  const e3 = x(t2, o2);
                  if (e3 == -1)
                    return m("InvalidChar", "char '&' is not expected.", b(t2, o2));
                  o2 = e3;
                } else if (s2 === true && !l(t2[o2]))
                  return m("InvalidXml", "Extra text at the end", b(t2, o2));
              t2[o2] === "<" && o2--;
            }
          }
        }
      return i2 ? n2.length == 1 ? m("InvalidTag", "Unclosed tag '" + n2[0].tagName + "'.", b(t2, n2[0].tagStartPos)) : !(n2.length > 0) || m("InvalidXml", "Invalid '" + JSON.stringify(n2.map((t3) => t3.tagName), null, 4).replace(/\r?\n/g, "") + "' found.", { line: 1, col: 1 }) : m("InvalidXml", "Start tag expected.", 1);
    }
    function l(t2) {
      return t2 === " " || t2 === "\t" || t2 === `
` || t2 === "\r";
    }
    function u(t2, e2) {
      const n2 = e2;
      for (;e2 < t2.length; e2++)
        if (t2[e2] != "?" && t2[e2] != " ")
          ;
        else {
          const i2 = t2.substr(n2, e2 - n2);
          if (e2 > 5 && i2 === "xml")
            return m("InvalidXml", "XML declaration allowed only at the start of the document.", b(t2, e2));
          if (t2[e2] == "?" && t2[e2 + 1] == ">") {
            e2++;
            break;
          }
        }
      return e2;
    }
    function h(t2, e2) {
      if (t2.length > e2 + 5 && t2[e2 + 1] === "-" && t2[e2 + 2] === "-") {
        for (e2 += 3;e2 < t2.length; e2++)
          if (t2[e2] === "-" && t2[e2 + 1] === "-" && t2[e2 + 2] === ">") {
            e2 += 2;
            break;
          }
      } else if (t2.length > e2 + 8 && t2[e2 + 1] === "D" && t2[e2 + 2] === "O" && t2[e2 + 3] === "C" && t2[e2 + 4] === "T" && t2[e2 + 5] === "Y" && t2[e2 + 6] === "P" && t2[e2 + 7] === "E") {
        let n2 = 1;
        for (e2 += 8;e2 < t2.length; e2++)
          if (t2[e2] === "<")
            n2++;
          else if (t2[e2] === ">" && (n2--, n2 === 0))
            break;
      } else if (t2.length > e2 + 9 && t2[e2 + 1] === "[" && t2[e2 + 2] === "C" && t2[e2 + 3] === "D" && t2[e2 + 4] === "A" && t2[e2 + 5] === "T" && t2[e2 + 6] === "A" && t2[e2 + 7] === "[") {
        for (e2 += 8;e2 < t2.length; e2++)
          if (t2[e2] === "]" && t2[e2 + 1] === "]" && t2[e2 + 2] === ">") {
            e2 += 2;
            break;
          }
      }
      return e2;
    }
    const d = '"', p = "'";
    function f(t2, e2) {
      let n2 = "", i2 = "", s2 = false;
      for (;e2 < t2.length; e2++) {
        if (t2[e2] === d || t2[e2] === p)
          i2 === "" ? i2 = t2[e2] : i2 !== t2[e2] || (i2 = "");
        else if (t2[e2] === ">" && i2 === "") {
          s2 = true;
          break;
        }
        n2 += t2[e2];
      }
      return i2 === "" && { value: n2, index: e2, tagClosed: s2 };
    }
    const c = new RegExp(`(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['"])(([\\s\\S])*?)\\5)?`, "g");
    function g(t2, e2) {
      const n2 = s(t2, c), i2 = {};
      for (let t3 = 0;t3 < n2.length; t3++) {
        if (n2[t3][1].length === 0)
          return m("InvalidAttr", "Attribute '" + n2[t3][2] + "' has no space in starting.", N(n2[t3]));
        if (n2[t3][3] !== undefined && n2[t3][4] === undefined)
          return m("InvalidAttr", "Attribute '" + n2[t3][2] + "' is without value.", N(n2[t3]));
        if (n2[t3][3] === undefined && !e2.allowBooleanAttributes)
          return m("InvalidAttr", "boolean attribute '" + n2[t3][2] + "' is not allowed.", N(n2[t3]));
        const s2 = n2[t3][2];
        if (!E(s2))
          return m("InvalidAttr", "Attribute '" + s2 + "' is an invalid name.", N(n2[t3]));
        if (i2.hasOwnProperty(s2))
          return m("InvalidAttr", "Attribute '" + s2 + "' is repeated.", N(n2[t3]));
        i2[s2] = 1;
      }
      return true;
    }
    function x(t2, e2) {
      if (t2[++e2] === ";")
        return -1;
      if (t2[e2] === "#")
        return function(t3, e3) {
          let n3 = /\d/;
          for (t3[e3] === "x" && (e3++, n3 = /[\da-fA-F]/);e3 < t3.length; e3++) {
            if (t3[e3] === ";")
              return e3;
            if (!t3[e3].match(n3))
              break;
          }
          return -1;
        }(t2, ++e2);
      let n2 = 0;
      for (;e2 < t2.length; e2++, n2++)
        if (!(t2[e2].match(/\w/) && n2 < 20)) {
          if (t2[e2] === ";")
            break;
          return -1;
        }
      return e2;
    }
    function m(t2, e2, n2) {
      return { err: { code: t2, msg: e2, line: n2.line || n2, col: n2.col } };
    }
    function E(t2) {
      return r(t2);
    }
    function b(t2, e2) {
      const n2 = t2.substring(0, e2).split(/\r?\n/);
      return { line: n2.length, col: n2[n2.length - 1].length + 1 };
    }
    function N(t2) {
      return t2.startIndex + t2[1].length;
    }
    const y = { preserveOrder: false, attributeNamePrefix: "@_", attributesGroupName: false, textNodeName: "#text", ignoreAttributes: true, removeNSPrefix: false, allowBooleanAttributes: false, parseTagValue: true, parseAttributeValue: false, trimValues: true, cdataPropName: false, numberParseOptions: { hex: true, leadingZeros: true, eNotation: true }, tagValueProcessor: function(t2, e2) {
      return e2;
    }, attributeValueProcessor: function(t2, e2) {
      return e2;
    }, stopNodes: [], alwaysCreateTextNode: false, isArray: () => false, commentPropName: false, unpairedTags: [], processEntities: true, htmlEntities: false, ignoreDeclaration: false, ignorePiTags: false, transformTagName: false, transformAttributeName: false, updateTag: function(t2, e2, n2) {
      return t2;
    }, captureMetaData: false };
    function T(t2) {
      return typeof t2 == "boolean" ? { enabled: t2, maxEntitySize: 1e4, maxExpansionDepth: 10, maxTotalExpansions: 1000, maxExpandedLength: 1e5, allowedTags: null, tagFilter: null } : typeof t2 == "object" && t2 !== null ? { enabled: t2.enabled !== false, maxEntitySize: t2.maxEntitySize ?? 1e4, maxExpansionDepth: t2.maxExpansionDepth ?? 10, maxTotalExpansions: t2.maxTotalExpansions ?? 1000, maxExpandedLength: t2.maxExpandedLength ?? 1e5, allowedTags: t2.allowedTags ?? null, tagFilter: t2.tagFilter ?? null } : T(true);
    }
    const w = function(t2) {
      const e2 = Object.assign({}, y, t2);
      return e2.processEntities = T(e2.processEntities), e2;
    };
    let v;
    v = typeof Symbol != "function" ? "@@xmlMetadata" : Symbol("XML Node Metadata");

    class I {
      constructor(t2) {
        this.tagname = t2, this.child = [], this[":@"] = {};
      }
      add(t2, e2) {
        t2 === "__proto__" && (t2 = "#__proto__"), this.child.push({ [t2]: e2 });
      }
      addChild(t2, e2) {
        t2.tagname === "__proto__" && (t2.tagname = "#__proto__"), t2[":@"] && Object.keys(t2[":@"]).length > 0 ? this.child.push({ [t2.tagname]: t2.child, ":@": t2[":@"] }) : this.child.push({ [t2.tagname]: t2.child }), e2 !== undefined && (this.child[this.child.length - 1][v] = { startIndex: e2 });
      }
      static getMetaDataSymbol() {
        return v;
      }
    }

    class O {
      constructor(t2) {
        this.suppressValidationErr = !t2, this.options = t2;
      }
      readDocType(t2, e2) {
        const n2 = {};
        if (t2[e2 + 3] !== "O" || t2[e2 + 4] !== "C" || t2[e2 + 5] !== "T" || t2[e2 + 6] !== "Y" || t2[e2 + 7] !== "P" || t2[e2 + 8] !== "E")
          throw new Error("Invalid Tag instead of DOCTYPE");
        {
          e2 += 9;
          let i2 = 1, s2 = false, r2 = false, o2 = "";
          for (;e2 < t2.length; e2++)
            if (t2[e2] !== "<" || r2)
              if (t2[e2] === ">") {
                if (r2 ? t2[e2 - 1] === "-" && t2[e2 - 2] === "-" && (r2 = false, i2--) : i2--, i2 === 0)
                  break;
              } else
                t2[e2] === "[" ? s2 = true : o2 += t2[e2];
            else {
              if (s2 && A(t2, "!ENTITY", e2)) {
                let i3, s3;
                if (e2 += 7, [i3, s3, e2] = this.readEntityExp(t2, e2 + 1, this.suppressValidationErr), s3.indexOf("&") === -1) {
                  const t3 = i3.replace(/[.\-+*:]/g, "\\.");
                  n2[i3] = { regx: RegExp(`&${t3};`, "g"), val: s3 };
                }
              } else if (s2 && A(t2, "!ELEMENT", e2)) {
                e2 += 8;
                const { index: n3 } = this.readElementExp(t2, e2 + 1);
                e2 = n3;
              } else if (s2 && A(t2, "!ATTLIST", e2))
                e2 += 8;
              else if (s2 && A(t2, "!NOTATION", e2)) {
                e2 += 9;
                const { index: n3 } = this.readNotationExp(t2, e2 + 1, this.suppressValidationErr);
                e2 = n3;
              } else {
                if (!A(t2, "!--", e2))
                  throw new Error("Invalid DOCTYPE");
                r2 = true;
              }
              i2++, o2 = "";
            }
          if (i2 !== 0)
            throw new Error("Unclosed DOCTYPE");
        }
        return { entities: n2, i: e2 };
      }
      readEntityExp(t2, e2) {
        e2 = P(t2, e2);
        let n2 = "";
        for (;e2 < t2.length && !/\s/.test(t2[e2]) && t2[e2] !== '"' && t2[e2] !== "'"; )
          n2 += t2[e2], e2++;
        if (S(n2), e2 = P(t2, e2), !this.suppressValidationErr) {
          if (t2.substring(e2, e2 + 6).toUpperCase() === "SYSTEM")
            throw new Error("External entities are not supported");
          if (t2[e2] === "%")
            throw new Error("Parameter entities are not supported");
        }
        let i2 = "";
        if ([e2, i2] = this.readIdentifierVal(t2, e2, "entity"), this.options.enabled !== false && this.options.maxEntitySize && i2.length > this.options.maxEntitySize)
          throw new Error(`Entity "${n2}" size (${i2.length}) exceeds maximum allowed size (${this.options.maxEntitySize})`);
        return [n2, i2, --e2];
      }
      readNotationExp(t2, e2) {
        e2 = P(t2, e2);
        let n2 = "";
        for (;e2 < t2.length && !/\s/.test(t2[e2]); )
          n2 += t2[e2], e2++;
        !this.suppressValidationErr && S(n2), e2 = P(t2, e2);
        const i2 = t2.substring(e2, e2 + 6).toUpperCase();
        if (!this.suppressValidationErr && i2 !== "SYSTEM" && i2 !== "PUBLIC")
          throw new Error(`Expected SYSTEM or PUBLIC, found "${i2}"`);
        e2 += i2.length, e2 = P(t2, e2);
        let s2 = null, r2 = null;
        if (i2 === "PUBLIC")
          [e2, s2] = this.readIdentifierVal(t2, e2, "publicIdentifier"), t2[e2 = P(t2, e2)] !== '"' && t2[e2] !== "'" || ([e2, r2] = this.readIdentifierVal(t2, e2, "systemIdentifier"));
        else if (i2 === "SYSTEM" && ([e2, r2] = this.readIdentifierVal(t2, e2, "systemIdentifier"), !this.suppressValidationErr && !r2))
          throw new Error("Missing mandatory system identifier for SYSTEM notation");
        return { notationName: n2, publicIdentifier: s2, systemIdentifier: r2, index: --e2 };
      }
      readIdentifierVal(t2, e2, n2) {
        let i2 = "";
        const s2 = t2[e2];
        if (s2 !== '"' && s2 !== "'")
          throw new Error(`Expected quoted string, found "${s2}"`);
        for (e2++;e2 < t2.length && t2[e2] !== s2; )
          i2 += t2[e2], e2++;
        if (t2[e2] !== s2)
          throw new Error(`Unterminated ${n2} value`);
        return [++e2, i2];
      }
      readElementExp(t2, e2) {
        e2 = P(t2, e2);
        let n2 = "";
        for (;e2 < t2.length && !/\s/.test(t2[e2]); )
          n2 += t2[e2], e2++;
        if (!this.suppressValidationErr && !r(n2))
          throw new Error(`Invalid element name: "${n2}"`);
        let i2 = "";
        if (t2[e2 = P(t2, e2)] === "E" && A(t2, "MPTY", e2))
          e2 += 4;
        else if (t2[e2] === "A" && A(t2, "NY", e2))
          e2 += 2;
        else if (t2[e2] === "(") {
          for (e2++;e2 < t2.length && t2[e2] !== ")"; )
            i2 += t2[e2], e2++;
          if (t2[e2] !== ")")
            throw new Error("Unterminated content model");
        } else if (!this.suppressValidationErr)
          throw new Error(`Invalid Element Expression, found "${t2[e2]}"`);
        return { elementName: n2, contentModel: i2.trim(), index: e2 };
      }
      readAttlistExp(t2, e2) {
        e2 = P(t2, e2);
        let n2 = "";
        for (;e2 < t2.length && !/\s/.test(t2[e2]); )
          n2 += t2[e2], e2++;
        S(n2), e2 = P(t2, e2);
        let i2 = "";
        for (;e2 < t2.length && !/\s/.test(t2[e2]); )
          i2 += t2[e2], e2++;
        if (!S(i2))
          throw new Error(`Invalid attribute name: "${i2}"`);
        e2 = P(t2, e2);
        let s2 = "";
        if (t2.substring(e2, e2 + 8).toUpperCase() === "NOTATION") {
          if (s2 = "NOTATION", t2[e2 = P(t2, e2 += 8)] !== "(")
            throw new Error(`Expected '(', found "${t2[e2]}"`);
          e2++;
          let n3 = [];
          for (;e2 < t2.length && t2[e2] !== ")"; ) {
            let i3 = "";
            for (;e2 < t2.length && t2[e2] !== "|" && t2[e2] !== ")"; )
              i3 += t2[e2], e2++;
            if (i3 = i3.trim(), !S(i3))
              throw new Error(`Invalid notation name: "${i3}"`);
            n3.push(i3), t2[e2] === "|" && (e2++, e2 = P(t2, e2));
          }
          if (t2[e2] !== ")")
            throw new Error("Unterminated list of notations");
          e2++, s2 += " (" + n3.join("|") + ")";
        } else {
          for (;e2 < t2.length && !/\s/.test(t2[e2]); )
            s2 += t2[e2], e2++;
          const n3 = ["CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS"];
          if (!this.suppressValidationErr && !n3.includes(s2.toUpperCase()))
            throw new Error(`Invalid attribute type: "${s2}"`);
        }
        e2 = P(t2, e2);
        let r2 = "";
        return t2.substring(e2, e2 + 8).toUpperCase() === "#REQUIRED" ? (r2 = "#REQUIRED", e2 += 8) : t2.substring(e2, e2 + 7).toUpperCase() === "#IMPLIED" ? (r2 = "#IMPLIED", e2 += 7) : [e2, r2] = this.readIdentifierVal(t2, e2, "ATTLIST"), { elementName: n2, attributeName: i2, attributeType: s2, defaultValue: r2, index: e2 };
      }
    }
    const P = (t2, e2) => {
      for (;e2 < t2.length && /\s/.test(t2[e2]); )
        e2++;
      return e2;
    };
    function A(t2, e2, n2) {
      for (let i2 = 0;i2 < e2.length; i2++)
        if (e2[i2] !== t2[n2 + i2 + 1])
          return false;
      return true;
    }
    function S(t2) {
      if (r(t2))
        return t2;
      throw new Error(`Invalid entity name ${t2}`);
    }
    const C = /^[-+]?0x[a-fA-F0-9]+$/, $ = /^([\-\+])?(0*)([0-9]*(\.[0-9]*)?)$/, V = { hex: true, leadingZeros: true, decimalPoint: ".", eNotation: true };
    const D = /^([-+])?(0*)(\d*(\.\d*)?[eE][-\+]?\d+)$/;
    function L(t2) {
      return typeof t2 == "function" ? t2 : Array.isArray(t2) ? (e2) => {
        for (const n2 of t2) {
          if (typeof n2 == "string" && e2 === n2)
            return true;
          if (n2 instanceof RegExp && n2.test(e2))
            return true;
        }
      } : () => false;
    }

    class F {
      constructor(t2) {
        if (this.options = t2, this.currentNode = null, this.tagsNodeStack = [], this.docTypeEntities = {}, this.lastEntities = { apos: { regex: /&(apos|#39|#x27);/g, val: "'" }, gt: { regex: /&(gt|#62|#x3E);/g, val: ">" }, lt: { regex: /&(lt|#60|#x3C);/g, val: "<" }, quot: { regex: /&(quot|#34|#x22);/g, val: '"' } }, this.ampEntity = { regex: /&(amp|#38|#x26);/g, val: "&" }, this.htmlEntities = { space: { regex: /&(nbsp|#160);/g, val: " " }, cent: { regex: /&(cent|#162);/g, val: "\xA2" }, pound: { regex: /&(pound|#163);/g, val: "\xA3" }, yen: { regex: /&(yen|#165);/g, val: "\xA5" }, euro: { regex: /&(euro|#8364);/g, val: "\u20AC" }, copyright: { regex: /&(copy|#169);/g, val: "\xA9" }, reg: { regex: /&(reg|#174);/g, val: "\xAE" }, inr: { regex: /&(inr|#8377);/g, val: "\u20B9" }, num_dec: { regex: /&#([0-9]{1,7});/g, val: (t3, e2) => K(e2, 10, "&#") }, num_hex: { regex: /&#x([0-9a-fA-F]{1,6});/g, val: (t3, e2) => K(e2, 16, "&#x") } }, this.addExternalEntities = j, this.parseXml = B, this.parseTextData = M, this.resolveNameSpace = _, this.buildAttributesMap = U, this.isItStopNode = X, this.replaceEntitiesValue = Y, this.readStopNodeData = q, this.saveTextToParentTag = G, this.addChild = R, this.ignoreAttributesFn = L(this.options.ignoreAttributes), this.entityExpansionCount = 0, this.currentExpandedLength = 0, this.options.stopNodes && this.options.stopNodes.length > 0) {
          this.stopNodesExact = new Set, this.stopNodesWildcard = new Set;
          for (let t3 = 0;t3 < this.options.stopNodes.length; t3++) {
            const e2 = this.options.stopNodes[t3];
            typeof e2 == "string" && (e2.startsWith("*.") ? this.stopNodesWildcard.add(e2.substring(2)) : this.stopNodesExact.add(e2));
          }
        }
      }
    }
    function j(t2) {
      const e2 = Object.keys(t2);
      for (let n2 = 0;n2 < e2.length; n2++) {
        const i2 = e2[n2], s2 = i2.replace(/[.\-+*:]/g, "\\.");
        this.lastEntities[i2] = { regex: new RegExp("&" + s2 + ";", "g"), val: t2[i2] };
      }
    }
    function M(t2, e2, n2, i2, s2, r2, o2) {
      if (t2 !== undefined && (this.options.trimValues && !i2 && (t2 = t2.trim()), t2.length > 0)) {
        o2 || (t2 = this.replaceEntitiesValue(t2, e2, n2));
        const i3 = this.options.tagValueProcessor(e2, t2, n2, s2, r2);
        return i3 == null ? t2 : typeof i3 != typeof t2 || i3 !== t2 ? i3 : this.options.trimValues || t2.trim() === t2 ? Z(t2, this.options.parseTagValue, this.options.numberParseOptions) : t2;
      }
    }
    function _(t2) {
      if (this.options.removeNSPrefix) {
        const e2 = t2.split(":"), n2 = t2.charAt(0) === "/" ? "/" : "";
        if (e2[0] === "xmlns")
          return "";
        e2.length === 2 && (t2 = n2 + e2[1]);
      }
      return t2;
    }
    const k = new RegExp(`([^\\s=]+)\\s*(=\\s*(['"])([\\s\\S]*?)\\3)?`, "gm");
    function U(t2, e2, n2) {
      if (this.options.ignoreAttributes !== true && typeof t2 == "string") {
        const i2 = s(t2, k), r2 = i2.length, o2 = {};
        for (let t3 = 0;t3 < r2; t3++) {
          const s2 = this.resolveNameSpace(i2[t3][1]);
          if (this.ignoreAttributesFn(s2, e2))
            continue;
          let r3 = i2[t3][4], a2 = this.options.attributeNamePrefix + s2;
          if (s2.length)
            if (this.options.transformAttributeName && (a2 = this.options.transformAttributeName(a2)), a2 === "__proto__" && (a2 = "#__proto__"), r3 !== undefined) {
              this.options.trimValues && (r3 = r3.trim()), r3 = this.replaceEntitiesValue(r3, n2, e2);
              const t4 = this.options.attributeValueProcessor(s2, r3, e2);
              o2[a2] = t4 == null ? r3 : typeof t4 != typeof r3 || t4 !== r3 ? t4 : Z(r3, this.options.parseAttributeValue, this.options.numberParseOptions);
            } else
              this.options.allowBooleanAttributes && (o2[a2] = true);
        }
        if (!Object.keys(o2).length)
          return;
        if (this.options.attributesGroupName) {
          const t3 = {};
          return t3[this.options.attributesGroupName] = o2, t3;
        }
        return o2;
      }
    }
    const B = function(t2) {
      t2 = t2.replace(/\r\n?/g, `
`);
      const e2 = new I("!xml");
      let n2 = e2, i2 = "", s2 = "";
      this.entityExpansionCount = 0, this.currentExpandedLength = 0;
      const r2 = new O(this.options.processEntities);
      for (let o2 = 0;o2 < t2.length; o2++)
        if (t2[o2] === "<")
          if (t2[o2 + 1] === "/") {
            const e3 = z(t2, ">", o2, "Closing Tag is not closed.");
            let r3 = t2.substring(o2 + 2, e3).trim();
            if (this.options.removeNSPrefix) {
              const t3 = r3.indexOf(":");
              t3 !== -1 && (r3 = r3.substr(t3 + 1));
            }
            this.options.transformTagName && (r3 = this.options.transformTagName(r3)), n2 && (i2 = this.saveTextToParentTag(i2, n2, s2));
            const a2 = s2.substring(s2.lastIndexOf(".") + 1);
            if (r3 && this.options.unpairedTags.indexOf(r3) !== -1)
              throw new Error(`Unpaired tag can not be used as closing tag: </${r3}>`);
            let l2 = 0;
            a2 && this.options.unpairedTags.indexOf(a2) !== -1 ? (l2 = s2.lastIndexOf(".", s2.lastIndexOf(".") - 1), this.tagsNodeStack.pop()) : l2 = s2.lastIndexOf("."), s2 = s2.substring(0, l2), n2 = this.tagsNodeStack.pop(), i2 = "", o2 = e3;
          } else if (t2[o2 + 1] === "?") {
            let e3 = W(t2, o2, false, "?>");
            if (!e3)
              throw new Error("Pi Tag is not closed.");
            if (i2 = this.saveTextToParentTag(i2, n2, s2), this.options.ignoreDeclaration && e3.tagName === "?xml" || this.options.ignorePiTags)
              ;
            else {
              const t3 = new I(e3.tagName);
              t3.add(this.options.textNodeName, ""), e3.tagName !== e3.tagExp && e3.attrExpPresent && (t3[":@"] = this.buildAttributesMap(e3.tagExp, s2, e3.tagName)), this.addChild(n2, t3, s2, o2);
            }
            o2 = e3.closeIndex + 1;
          } else if (t2.substr(o2 + 1, 3) === "!--") {
            const e3 = z(t2, "-->", o2 + 4, "Comment is not closed.");
            if (this.options.commentPropName) {
              const r3 = t2.substring(o2 + 4, e3 - 2);
              i2 = this.saveTextToParentTag(i2, n2, s2), n2.add(this.options.commentPropName, [{ [this.options.textNodeName]: r3 }]);
            }
            o2 = e3;
          } else if (t2.substr(o2 + 1, 2) === "!D") {
            const e3 = r2.readDocType(t2, o2);
            this.docTypeEntities = e3.entities, o2 = e3.i;
          } else if (t2.substr(o2 + 1, 2) === "![") {
            const e3 = z(t2, "]]>", o2, "CDATA is not closed.") - 2, r3 = t2.substring(o2 + 9, e3);
            i2 = this.saveTextToParentTag(i2, n2, s2);
            let a2 = this.parseTextData(r3, n2.tagname, s2, true, false, true, true);
            a2 == null && (a2 = ""), this.options.cdataPropName ? n2.add(this.options.cdataPropName, [{ [this.options.textNodeName]: r3 }]) : n2.add(this.options.textNodeName, a2), o2 = e3 + 2;
          } else {
            let r3 = W(t2, o2, this.options.removeNSPrefix), a2 = r3.tagName;
            const l2 = r3.rawTagName;
            let { tagExp: u2, attrExpPresent: h2, closeIndex: d2 } = r3;
            if (this.options.transformTagName) {
              const t3 = this.options.transformTagName(a2);
              u2 === a2 && (u2 = t3), a2 = t3;
            }
            n2 && i2 && n2.tagname !== "!xml" && (i2 = this.saveTextToParentTag(i2, n2, s2, false));
            const p2 = n2;
            p2 && this.options.unpairedTags.indexOf(p2.tagname) !== -1 && (n2 = this.tagsNodeStack.pop(), s2 = s2.substring(0, s2.lastIndexOf("."))), a2 !== e2.tagname && (s2 += s2 ? "." + a2 : a2);
            const f2 = o2;
            if (this.isItStopNode(this.stopNodesExact, this.stopNodesWildcard, s2, a2)) {
              let e3 = "";
              if (u2.length > 0 && u2.lastIndexOf("/") === u2.length - 1)
                a2[a2.length - 1] === "/" ? (a2 = a2.substr(0, a2.length - 1), s2 = s2.substr(0, s2.length - 1), u2 = a2) : u2 = u2.substr(0, u2.length - 1), o2 = r3.closeIndex;
              else if (this.options.unpairedTags.indexOf(a2) !== -1)
                o2 = r3.closeIndex;
              else {
                const n3 = this.readStopNodeData(t2, l2, d2 + 1);
                if (!n3)
                  throw new Error(`Unexpected end of ${l2}`);
                o2 = n3.i, e3 = n3.tagContent;
              }
              const i3 = new I(a2);
              a2 !== u2 && h2 && (i3[":@"] = this.buildAttributesMap(u2, s2, a2)), e3 && (e3 = this.parseTextData(e3, a2, s2, true, h2, true, true)), s2 = s2.substr(0, s2.lastIndexOf(".")), i3.add(this.options.textNodeName, e3), this.addChild(n2, i3, s2, f2);
            } else {
              if (u2.length > 0 && u2.lastIndexOf("/") === u2.length - 1) {
                if (a2[a2.length - 1] === "/" ? (a2 = a2.substr(0, a2.length - 1), s2 = s2.substr(0, s2.length - 1), u2 = a2) : u2 = u2.substr(0, u2.length - 1), this.options.transformTagName) {
                  const t4 = this.options.transformTagName(a2);
                  u2 === a2 && (u2 = t4), a2 = t4;
                }
                const t3 = new I(a2);
                a2 !== u2 && h2 && (t3[":@"] = this.buildAttributesMap(u2, s2, a2)), this.addChild(n2, t3, s2, f2), s2 = s2.substr(0, s2.lastIndexOf("."));
              } else {
                const t3 = new I(a2);
                this.tagsNodeStack.push(n2), a2 !== u2 && h2 && (t3[":@"] = this.buildAttributesMap(u2, s2, a2)), this.addChild(n2, t3, s2, f2), n2 = t3;
              }
              i2 = "", o2 = d2;
            }
          }
        else
          i2 += t2[o2];
      return e2.child;
    };
    function R(t2, e2, n2, i2) {
      this.options.captureMetaData || (i2 = undefined);
      const s2 = this.options.updateTag(e2.tagname, n2, e2[":@"]);
      s2 === false || (typeof s2 == "string" ? (e2.tagname = s2, t2.addChild(e2, i2)) : t2.addChild(e2, i2));
    }
    const Y = function(t2, e2, n2) {
      if (t2.indexOf("&") === -1)
        return t2;
      const i2 = this.options.processEntities;
      if (!i2.enabled)
        return t2;
      if (i2.allowedTags && !i2.allowedTags.includes(e2))
        return t2;
      if (i2.tagFilter && !i2.tagFilter(e2, n2))
        return t2;
      for (let e3 in this.docTypeEntities) {
        const n3 = this.docTypeEntities[e3], s2 = t2.match(n3.regx);
        if (s2) {
          if (this.entityExpansionCount += s2.length, i2.maxTotalExpansions && this.entityExpansionCount > i2.maxTotalExpansions)
            throw new Error(`Entity expansion limit exceeded: ${this.entityExpansionCount} > ${i2.maxTotalExpansions}`);
          const e4 = t2.length;
          if (t2 = t2.replace(n3.regx, n3.val), i2.maxExpandedLength && (this.currentExpandedLength += t2.length - e4, this.currentExpandedLength > i2.maxExpandedLength))
            throw new Error(`Total expanded content size exceeded: ${this.currentExpandedLength} > ${i2.maxExpandedLength}`);
        }
      }
      if (t2.indexOf("&") === -1)
        return t2;
      for (let e3 in this.lastEntities) {
        const n3 = this.lastEntities[e3];
        t2 = t2.replace(n3.regex, n3.val);
      }
      if (t2.indexOf("&") === -1)
        return t2;
      if (this.options.htmlEntities)
        for (let e3 in this.htmlEntities) {
          const n3 = this.htmlEntities[e3];
          t2 = t2.replace(n3.regex, n3.val);
        }
      return t2.replace(this.ampEntity.regex, this.ampEntity.val);
    };
    function G(t2, e2, n2, i2) {
      return t2 && (i2 === undefined && (i2 = e2.child.length === 0), (t2 = this.parseTextData(t2, e2.tagname, n2, false, !!e2[":@"] && Object.keys(e2[":@"]).length !== 0, i2)) !== undefined && t2 !== "" && e2.add(this.options.textNodeName, t2), t2 = ""), t2;
    }
    function X(t2, e2, n2, i2) {
      return !(!e2 || !e2.has(i2)) || !(!t2 || !t2.has(n2));
    }
    function z(t2, e2, n2, i2) {
      const s2 = t2.indexOf(e2, n2);
      if (s2 === -1)
        throw new Error(i2);
      return s2 + e2.length - 1;
    }
    function W(t2, e2, n2, i2 = ">") {
      const s2 = function(t3, e3, n3 = ">") {
        let i3, s3 = "";
        for (let r3 = e3;r3 < t3.length; r3++) {
          let e4 = t3[r3];
          if (i3)
            e4 === i3 && (i3 = "");
          else if (e4 === '"' || e4 === "'")
            i3 = e4;
          else if (e4 === n3[0]) {
            if (!n3[1])
              return { data: s3, index: r3 };
            if (t3[r3 + 1] === n3[1])
              return { data: s3, index: r3 };
          } else
            e4 === "\t" && (e4 = " ");
          s3 += e4;
        }
      }(t2, e2 + 1, i2);
      if (!s2)
        return;
      let r2 = s2.data;
      const o2 = s2.index, a2 = r2.search(/\s/);
      let l2 = r2, u2 = true;
      a2 !== -1 && (l2 = r2.substring(0, a2), r2 = r2.substring(a2 + 1).trimStart());
      const h2 = l2;
      if (n2) {
        const t3 = l2.indexOf(":");
        t3 !== -1 && (l2 = l2.substr(t3 + 1), u2 = l2 !== s2.data.substr(t3 + 1));
      }
      return { tagName: l2, tagExp: r2, closeIndex: o2, attrExpPresent: u2, rawTagName: h2 };
    }
    function q(t2, e2, n2) {
      const i2 = n2;
      let s2 = 1;
      for (;n2 < t2.length; n2++)
        if (t2[n2] === "<")
          if (t2[n2 + 1] === "/") {
            const r2 = z(t2, ">", n2, `${e2} is not closed`);
            if (t2.substring(n2 + 2, r2).trim() === e2 && (s2--, s2 === 0))
              return { tagContent: t2.substring(i2, n2), i: r2 };
            n2 = r2;
          } else if (t2[n2 + 1] === "?")
            n2 = z(t2, "?>", n2 + 1, "StopNode is not closed.");
          else if (t2.substr(n2 + 1, 3) === "!--")
            n2 = z(t2, "-->", n2 + 3, "StopNode is not closed.");
          else if (t2.substr(n2 + 1, 2) === "![")
            n2 = z(t2, "]]>", n2, "StopNode is not closed.") - 2;
          else {
            const i3 = W(t2, n2, ">");
            i3 && ((i3 && i3.tagName) === e2 && i3.tagExp[i3.tagExp.length - 1] !== "/" && s2++, n2 = i3.closeIndex);
          }
    }
    function Z(t2, e2, n2) {
      if (e2 && typeof t2 == "string") {
        const e3 = t2.trim();
        return e3 === "true" || e3 !== "false" && function(t3, e4 = {}) {
          if (e4 = Object.assign({}, V, e4), !t3 || typeof t3 != "string")
            return t3;
          let n3 = t3.trim();
          if (e4.skipLike !== undefined && e4.skipLike.test(n3))
            return t3;
          if (t3 === "0")
            return 0;
          if (e4.hex && C.test(n3))
            return function(t4) {
              if (parseInt)
                return parseInt(t4, 16);
              if (Number.parseInt)
                return Number.parseInt(t4, 16);
              if (window && window.parseInt)
                return window.parseInt(t4, 16);
              throw new Error("parseInt, Number.parseInt, window.parseInt are not supported");
            }(n3);
          if (n3.search(/.+[eE].+/) !== -1)
            return function(t4, e5, n4) {
              if (!n4.eNotation)
                return t4;
              const i3 = e5.match(D);
              if (i3) {
                let s2 = i3[1] || "";
                const r2 = i3[3].indexOf("e") === -1 ? "E" : "e", o2 = i3[2], a2 = s2 ? t4[o2.length + 1] === r2 : t4[o2.length] === r2;
                return o2.length > 1 && a2 ? t4 : o2.length !== 1 || !i3[3].startsWith(`.${r2}`) && i3[3][0] !== r2 ? n4.leadingZeros && !a2 ? (e5 = (i3[1] || "") + i3[3], Number(e5)) : t4 : Number(e5);
              }
              return t4;
            }(t3, n3, e4);
          {
            const s2 = $.exec(n3);
            if (s2) {
              const r2 = s2[1] || "", o2 = s2[2];
              let a2 = (i2 = s2[3]) && i2.indexOf(".") !== -1 ? ((i2 = i2.replace(/0+$/, "")) === "." ? i2 = "0" : i2[0] === "." ? i2 = "0" + i2 : i2[i2.length - 1] === "." && (i2 = i2.substring(0, i2.length - 1)), i2) : i2;
              const l2 = r2 ? t3[o2.length + 1] === "." : t3[o2.length] === ".";
              if (!e4.leadingZeros && (o2.length > 1 || o2.length === 1 && !l2))
                return t3;
              {
                const i3 = Number(n3), s3 = String(i3);
                if (i3 === 0 || i3 === -0)
                  return i3;
                if (s3.search(/[eE]/) !== -1)
                  return e4.eNotation ? i3 : t3;
                if (n3.indexOf(".") !== -1)
                  return s3 === "0" || s3 === a2 || s3 === `${r2}${a2}` ? i3 : t3;
                let l3 = o2 ? a2 : n3;
                return o2 ? l3 === s3 || r2 + l3 === s3 ? i3 : t3 : l3 === s3 || l3 === r2 + s3 ? i3 : t3;
              }
            }
            return t3;
          }
          var i2;
        }(t2, n2);
      }
      return t2 !== undefined ? t2 : "";
    }
    function K(t2, e2, n2) {
      const i2 = Number.parseInt(t2, e2);
      return i2 >= 0 && i2 <= 1114111 ? String.fromCodePoint(i2) : n2 + t2 + ";";
    }
    const Q = I.getMetaDataSymbol();
    function J(t2, e2) {
      return H(t2, e2);
    }
    function H(t2, e2, n2) {
      let i2;
      const s2 = {};
      for (let r2 = 0;r2 < t2.length; r2++) {
        const o2 = t2[r2], a2 = tt(o2);
        let l2 = "";
        if (l2 = n2 === undefined ? a2 : n2 + "." + a2, a2 === e2.textNodeName)
          i2 === undefined ? i2 = o2[a2] : i2 += "" + o2[a2];
        else {
          if (a2 === undefined)
            continue;
          if (o2[a2]) {
            let t3 = H(o2[a2], e2, l2);
            const n3 = nt(t3, e2);
            o2[Q] !== undefined && (t3[Q] = o2[Q]), o2[":@"] ? et(t3, o2[":@"], l2, e2) : Object.keys(t3).length !== 1 || t3[e2.textNodeName] === undefined || e2.alwaysCreateTextNode ? Object.keys(t3).length === 0 && (e2.alwaysCreateTextNode ? t3[e2.textNodeName] = "" : t3 = "") : t3 = t3[e2.textNodeName], s2[a2] !== undefined && s2.hasOwnProperty(a2) ? (Array.isArray(s2[a2]) || (s2[a2] = [s2[a2]]), s2[a2].push(t3)) : e2.isArray(a2, l2, n3) ? s2[a2] = [t3] : s2[a2] = t3;
          }
        }
      }
      return typeof i2 == "string" ? i2.length > 0 && (s2[e2.textNodeName] = i2) : i2 !== undefined && (s2[e2.textNodeName] = i2), s2;
    }
    function tt(t2) {
      const e2 = Object.keys(t2);
      for (let t3 = 0;t3 < e2.length; t3++) {
        const n2 = e2[t3];
        if (n2 !== ":@")
          return n2;
      }
    }
    function et(t2, e2, n2, i2) {
      if (e2) {
        const s2 = Object.keys(e2), r2 = s2.length;
        for (let o2 = 0;o2 < r2; o2++) {
          const r3 = s2[o2];
          i2.isArray(r3, n2 + "." + r3, true, true) ? t2[r3] = [e2[r3]] : t2[r3] = e2[r3];
        }
      }
    }
    function nt(t2, e2) {
      const { textNodeName: n2 } = e2, i2 = Object.keys(t2).length;
      return i2 === 0 || !(i2 !== 1 || !t2[n2] && typeof t2[n2] != "boolean" && t2[n2] !== 0);
    }

    class it {
      constructor(t2) {
        this.externalEntities = {}, this.options = w(t2);
      }
      parse(t2, e2) {
        if (typeof t2 != "string" && t2.toString)
          t2 = t2.toString();
        else if (typeof t2 != "string")
          throw new Error("XML data is accepted in String or Bytes[] form.");
        if (e2) {
          e2 === true && (e2 = {});
          const n3 = a(t2, e2);
          if (n3 !== true)
            throw Error(`${n3.err.msg}:${n3.err.line}:${n3.err.col}`);
        }
        const n2 = new F(this.options);
        n2.addExternalEntities(this.externalEntities);
        const i2 = n2.parseXml(t2);
        return this.options.preserveOrder || i2 === undefined ? i2 : J(i2, this.options);
      }
      addEntity(t2, e2) {
        if (e2.indexOf("&") !== -1)
          throw new Error("Entity value can't have '&'");
        if (t2.indexOf("&") !== -1 || t2.indexOf(";") !== -1)
          throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'");
        if (e2 === "&")
          throw new Error("An entity with value '&' is not permitted");
        this.externalEntities[t2] = e2;
      }
      static getMetaDataSymbol() {
        return I.getMetaDataSymbol();
      }
    }
    function st(t2, e2) {
      let n2 = "";
      return e2.format && e2.indentBy.length > 0 && (n2 = `
`), rt(t2, e2, "", n2);
    }
    function rt(t2, e2, n2, i2) {
      let s2 = "", r2 = false;
      for (let o2 = 0;o2 < t2.length; o2++) {
        const a2 = t2[o2], l2 = ot(a2);
        if (l2 === undefined)
          continue;
        let u2 = "";
        if (u2 = n2.length === 0 ? l2 : `${n2}.${l2}`, l2 === e2.textNodeName) {
          let t3 = a2[l2];
          lt(u2, e2) || (t3 = e2.tagValueProcessor(l2, t3), t3 = ut(t3, e2)), r2 && (s2 += i2), s2 += t3, r2 = false;
          continue;
        }
        if (l2 === e2.cdataPropName) {
          r2 && (s2 += i2), s2 += `<![CDATA[${a2[l2][0][e2.textNodeName]}]]>`, r2 = false;
          continue;
        }
        if (l2 === e2.commentPropName) {
          s2 += i2 + `<!--${a2[l2][0][e2.textNodeName]}-->`, r2 = true;
          continue;
        }
        if (l2[0] === "?") {
          const t3 = at(a2[":@"], e2), n3 = l2 === "?xml" ? "" : i2;
          let o3 = a2[l2][0][e2.textNodeName];
          o3 = o3.length !== 0 ? " " + o3 : "", s2 += n3 + `<${l2}${o3}${t3}?>`, r2 = true;
          continue;
        }
        let h2 = i2;
        h2 !== "" && (h2 += e2.indentBy);
        const d2 = i2 + `<${l2}${at(a2[":@"], e2)}`, p2 = rt(a2[l2], e2, u2, h2);
        e2.unpairedTags.indexOf(l2) !== -1 ? e2.suppressUnpairedNode ? s2 += d2 + ">" : s2 += d2 + "/>" : p2 && p2.length !== 0 || !e2.suppressEmptyNode ? p2 && p2.endsWith(">") ? s2 += d2 + `>${p2}${i2}</${l2}>` : (s2 += d2 + ">", p2 && i2 !== "" && (p2.includes("/>") || p2.includes("</")) ? s2 += i2 + e2.indentBy + p2 + i2 : s2 += p2, s2 += `</${l2}>`) : s2 += d2 + "/>", r2 = true;
      }
      return s2;
    }
    function ot(t2) {
      const e2 = Object.keys(t2);
      for (let n2 = 0;n2 < e2.length; n2++) {
        const i2 = e2[n2];
        if (t2.hasOwnProperty(i2) && i2 !== ":@")
          return i2;
      }
    }
    function at(t2, e2) {
      let n2 = "";
      if (t2 && !e2.ignoreAttributes)
        for (let i2 in t2) {
          if (!t2.hasOwnProperty(i2))
            continue;
          let s2 = e2.attributeValueProcessor(i2, t2[i2]);
          s2 = ut(s2, e2), s2 === true && e2.suppressBooleanAttributes ? n2 += ` ${i2.substr(e2.attributeNamePrefix.length)}` : n2 += ` ${i2.substr(e2.attributeNamePrefix.length)}="${s2}"`;
        }
      return n2;
    }
    function lt(t2, e2) {
      let n2 = (t2 = t2.substr(0, t2.length - e2.textNodeName.length - 1)).substr(t2.lastIndexOf(".") + 1);
      for (let i2 in e2.stopNodes)
        if (e2.stopNodes[i2] === t2 || e2.stopNodes[i2] === "*." + n2)
          return true;
      return false;
    }
    function ut(t2, e2) {
      if (t2 && t2.length > 0 && e2.processEntities)
        for (let n2 = 0;n2 < e2.entities.length; n2++) {
          const i2 = e2.entities[n2];
          t2 = t2.replace(i2.regex, i2.val);
        }
      return t2;
    }
    const ht = { attributeNamePrefix: "@_", attributesGroupName: false, textNodeName: "#text", ignoreAttributes: true, cdataPropName: false, format: false, indentBy: "  ", suppressEmptyNode: false, suppressUnpairedNode: true, suppressBooleanAttributes: true, tagValueProcessor: function(t2, e2) {
      return e2;
    }, attributeValueProcessor: function(t2, e2) {
      return e2;
    }, preserveOrder: false, commentPropName: false, unpairedTags: [], entities: [{ regex: new RegExp("&", "g"), val: "&amp;" }, { regex: new RegExp(">", "g"), val: "&gt;" }, { regex: new RegExp("<", "g"), val: "&lt;" }, { regex: new RegExp("'", "g"), val: "&apos;" }, { regex: new RegExp('"', "g"), val: "&quot;" }], processEntities: true, stopNodes: [], oneListGroup: false };
    function dt(t2) {
      this.options = Object.assign({}, ht, t2), this.options.ignoreAttributes === true || this.options.attributesGroupName ? this.isAttribute = function() {
        return false;
      } : (this.ignoreAttributesFn = L(this.options.ignoreAttributes), this.attrPrefixLen = this.options.attributeNamePrefix.length, this.isAttribute = ct), this.processTextOrObjNode = pt, this.options.format ? (this.indentate = ft, this.tagEndChar = `>
`, this.newLine = `
`) : (this.indentate = function() {
        return "";
      }, this.tagEndChar = ">", this.newLine = "");
    }
    function pt(t2, e2, n2, i2) {
      const s2 = this.j2x(t2, n2 + 1, i2.concat(e2));
      return t2[this.options.textNodeName] !== undefined && Object.keys(t2).length === 1 ? this.buildTextValNode(t2[this.options.textNodeName], e2, s2.attrStr, n2) : this.buildObjectNode(s2.val, e2, s2.attrStr, n2);
    }
    function ft(t2) {
      return this.options.indentBy.repeat(t2);
    }
    function ct(t2) {
      return !(!t2.startsWith(this.options.attributeNamePrefix) || t2 === this.options.textNodeName) && t2.substr(this.attrPrefixLen);
    }
    dt.prototype.build = function(t2) {
      return this.options.preserveOrder ? st(t2, this.options) : (Array.isArray(t2) && this.options.arrayNodeName && this.options.arrayNodeName.length > 1 && (t2 = { [this.options.arrayNodeName]: t2 }), this.j2x(t2, 0, []).val);
    }, dt.prototype.j2x = function(t2, e2, n2) {
      let i2 = "", s2 = "";
      const r2 = n2.join(".");
      for (let o2 in t2)
        if (Object.prototype.hasOwnProperty.call(t2, o2))
          if (t2[o2] === undefined)
            this.isAttribute(o2) && (s2 += "");
          else if (t2[o2] === null)
            this.isAttribute(o2) || o2 === this.options.cdataPropName ? s2 += "" : o2[0] === "?" ? s2 += this.indentate(e2) + "<" + o2 + "?" + this.tagEndChar : s2 += this.indentate(e2) + "<" + o2 + "/" + this.tagEndChar;
          else if (t2[o2] instanceof Date)
            s2 += this.buildTextValNode(t2[o2], o2, "", e2);
          else if (typeof t2[o2] != "object") {
            const n3 = this.isAttribute(o2);
            if (n3 && !this.ignoreAttributesFn(n3, r2))
              i2 += this.buildAttrPairStr(n3, "" + t2[o2]);
            else if (!n3)
              if (o2 === this.options.textNodeName) {
                let e3 = this.options.tagValueProcessor(o2, "" + t2[o2]);
                s2 += this.replaceEntitiesValue(e3);
              } else
                s2 += this.buildTextValNode(t2[o2], o2, "", e2);
          } else if (Array.isArray(t2[o2])) {
            const i3 = t2[o2].length;
            let r3 = "", a2 = "";
            for (let l2 = 0;l2 < i3; l2++) {
              const i4 = t2[o2][l2];
              if (i4 === undefined)
                ;
              else if (i4 === null)
                o2[0] === "?" ? s2 += this.indentate(e2) + "<" + o2 + "?" + this.tagEndChar : s2 += this.indentate(e2) + "<" + o2 + "/" + this.tagEndChar;
              else if (typeof i4 == "object")
                if (this.options.oneListGroup) {
                  const t3 = this.j2x(i4, e2 + 1, n2.concat(o2));
                  r3 += t3.val, this.options.attributesGroupName && i4.hasOwnProperty(this.options.attributesGroupName) && (a2 += t3.attrStr);
                } else
                  r3 += this.processTextOrObjNode(i4, o2, e2, n2);
              else if (this.options.oneListGroup) {
                let t3 = this.options.tagValueProcessor(o2, i4);
                t3 = this.replaceEntitiesValue(t3), r3 += t3;
              } else
                r3 += this.buildTextValNode(i4, o2, "", e2);
            }
            this.options.oneListGroup && (r3 = this.buildObjectNode(r3, o2, a2, e2)), s2 += r3;
          } else if (this.options.attributesGroupName && o2 === this.options.attributesGroupName) {
            const e3 = Object.keys(t2[o2]), n3 = e3.length;
            for (let s3 = 0;s3 < n3; s3++)
              i2 += this.buildAttrPairStr(e3[s3], "" + t2[o2][e3[s3]]);
          } else
            s2 += this.processTextOrObjNode(t2[o2], o2, e2, n2);
      return { attrStr: i2, val: s2 };
    }, dt.prototype.buildAttrPairStr = function(t2, e2) {
      return e2 = this.options.attributeValueProcessor(t2, "" + e2), e2 = this.replaceEntitiesValue(e2), this.options.suppressBooleanAttributes && e2 === "true" ? " " + t2 : " " + t2 + '="' + e2 + '"';
    }, dt.prototype.buildObjectNode = function(t2, e2, n2, i2) {
      if (t2 === "")
        return e2[0] === "?" ? this.indentate(i2) + "<" + e2 + n2 + "?" + this.tagEndChar : this.indentate(i2) + "<" + e2 + n2 + this.closeTag(e2) + this.tagEndChar;
      {
        let s2 = "</" + e2 + this.tagEndChar, r2 = "";
        return e2[0] === "?" && (r2 = "?", s2 = ""), !n2 && n2 !== "" || t2.indexOf("<") !== -1 ? this.options.commentPropName !== false && e2 === this.options.commentPropName && r2.length === 0 ? this.indentate(i2) + `<!--${t2}-->` + this.newLine : this.indentate(i2) + "<" + e2 + n2 + r2 + this.tagEndChar + t2 + this.indentate(i2) + s2 : this.indentate(i2) + "<" + e2 + n2 + r2 + ">" + t2 + s2;
      }
    }, dt.prototype.closeTag = function(t2) {
      let e2 = "";
      return this.options.unpairedTags.indexOf(t2) !== -1 ? this.options.suppressUnpairedNode || (e2 = "/") : e2 = this.options.suppressEmptyNode ? "/" : `></${t2}`, e2;
    }, dt.prototype.buildTextValNode = function(t2, e2, n2, i2) {
      if (this.options.cdataPropName !== false && e2 === this.options.cdataPropName)
        return this.indentate(i2) + `<![CDATA[${t2}]]>` + this.newLine;
      if (this.options.commentPropName !== false && e2 === this.options.commentPropName)
        return this.indentate(i2) + `<!--${t2}-->` + this.newLine;
      if (e2[0] === "?")
        return this.indentate(i2) + "<" + e2 + n2 + "?" + this.tagEndChar;
      {
        let s2 = this.options.tagValueProcessor(e2, t2);
        return s2 = this.replaceEntitiesValue(s2), s2 === "" ? this.indentate(i2) + "<" + e2 + n2 + this.closeTag(e2) + this.tagEndChar : this.indentate(i2) + "<" + e2 + n2 + ">" + s2 + "</" + e2 + this.tagEndChar;
      }
    }, dt.prototype.replaceEntitiesValue = function(t2) {
      if (t2 && t2.length > 0 && this.options.processEntities)
        for (let e2 = 0;e2 < this.options.entities.length; e2++) {
          const n2 = this.options.entities[e2];
          t2 = t2.replace(n2.regex, n2.val);
        }
      return t2;
    };
    const gt = { validate: a };
    module.exports = e;
  })();
});

// ../node_modules/.bun/@aws-sdk+xml-builder@3.972.5/node_modules/@aws-sdk/xml-builder/dist-cjs/xml-parser.js
var require_xml_parser = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.parseXML = parseXML;
  var fast_xml_parser_1 = require_fxp();
  var parser = new fast_xml_parser_1.XMLParser({
    attributeNamePrefix: "",
    htmlEntities: true,
    ignoreAttributes: false,
    ignoreDeclaration: true,
    parseTagValue: false,
    trimValues: false,
    tagValueProcessor: (_, val) => val.trim() === "" && val.includes(`
`) ? "" : undefined
  });
  parser.addEntity("#xD", "\r");
  parser.addEntity("#10", `
`);
  function parseXML(xmlString) {
    return parser.parse(xmlString, true);
  }
});

// ../node_modules/.bun/@aws-sdk+xml-builder@3.972.5/node_modules/@aws-sdk/xml-builder/dist-cjs/index.js
var require_dist_cjs29 = __commonJS((exports) => {
  var xmlParser = require_xml_parser();
  function escapeAttribute(value) {
    return value.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
  }
  function escapeElement(value) {
    return value.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&apos;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/\r/g, "&#x0D;").replace(/\n/g, "&#x0A;").replace(/\u0085/g, "&#x85;").replace(/\u2028/, "&#x2028;");
  }

  class XmlText {
    value;
    constructor(value) {
      this.value = value;
    }
    toString() {
      return escapeElement("" + this.value);
    }
  }

  class XmlNode {
    name;
    children;
    attributes = {};
    static of(name, childText, withName) {
      const node = new XmlNode(name);
      if (childText !== undefined) {
        node.addChildNode(new XmlText(childText));
      }
      if (withName !== undefined) {
        node.withName(withName);
      }
      return node;
    }
    constructor(name, children = []) {
      this.name = name;
      this.children = children;
    }
    withName(name) {
      this.name = name;
      return this;
    }
    addAttribute(name, value) {
      this.attributes[name] = value;
      return this;
    }
    addChildNode(child) {
      this.children.push(child);
      return this;
    }
    removeAttribute(name) {
      delete this.attributes[name];
      return this;
    }
    n(name) {
      this.name = name;
      return this;
    }
    c(child) {
      this.children.push(child);
      return this;
    }
    a(name, value) {
      if (value != null) {
        this.attributes[name] = value;
      }
      return this;
    }
    cc(input, field, withName = field) {
      if (input[field] != null) {
        const node = XmlNode.of(field, input[field]).withName(withName);
        this.c(node);
      }
    }
    l(input, listName, memberName, valueProvider) {
      if (input[listName] != null) {
        const nodes = valueProvider();
        nodes.map((node) => {
          node.withName(memberName);
          this.c(node);
        });
      }
    }
    lc(input, listName, memberName, valueProvider) {
      if (input[listName] != null) {
        const nodes = valueProvider();
        const containerNode = new XmlNode(memberName);
        nodes.map((node) => {
          containerNode.c(node);
        });
        this.c(containerNode);
      }
    }
    toString() {
      const hasChildren = Boolean(this.children.length);
      let xmlText = `<${this.name}`;
      const attributes = this.attributes;
      for (const attributeName of Object.keys(attributes)) {
        const attribute = attributes[attributeName];
        if (attribute != null) {
          xmlText += ` ${attributeName}="${escapeAttribute("" + attribute)}"`;
        }
      }
      return xmlText += !hasChildren ? "/>" : `>${this.children.map((c) => c.toString()).join("")}</${this.name}>`;
    }
  }
  Object.defineProperty(exports, "parseXML", {
    enumerable: true,
    get: function() {
      return xmlParser.parseXML;
    }
  });
  exports.XmlNode = XmlNode;
  exports.XmlText = XmlText;
});

// ../node_modules/.bun/@aws-sdk+core@3.973.11/node_modules/@aws-sdk/core/dist-cjs/index.js
var require_dist_cjs30 = __commonJS((exports) => {
  var protocolHttp = require_dist_cjs2();
  var core = require_dist_cjs19();
  var propertyProvider = require_dist_cjs24();
  var client = require_client();
  var signatureV4 = require_dist_cjs25();
  var cbor = require_cbor();
  var schema = require_schema();
  var smithyClient = require_dist_cjs28();
  var protocols = require_protocols();
  var serde = require_serde();
  var utilBase64 = require_dist_cjs11();
  var utilUtf8 = require_dist_cjs10();
  var xmlBuilder = require_dist_cjs29();
  var state = {
    warningEmitted: false
  };
  var emitWarningIfUnsupportedVersion = (version) => {
    if (version && !state.warningEmitted && parseInt(version.substring(1, version.indexOf("."))) < 20) {
      state.warningEmitted = true;
      process.emitWarning(`NodeDeprecationWarning: The AWS SDK for JavaScript (v3) will
no longer support Node.js ${version} in January 2026.

To continue receiving updates to AWS services, bug fixes, and security
updates please upgrade to a supported Node.js LTS version.

More information can be found at: https://a.co/c895JFp`);
    }
  };
  function setCredentialFeature(credentials, feature, value) {
    if (!credentials.$source) {
      credentials.$source = {};
    }
    credentials.$source[feature] = value;
    return credentials;
  }
  function setFeature(context, feature, value) {
    if (!context.__aws_sdk_context) {
      context.__aws_sdk_context = {
        features: {}
      };
    } else if (!context.__aws_sdk_context.features) {
      context.__aws_sdk_context.features = {};
    }
    context.__aws_sdk_context.features[feature] = value;
  }
  function setTokenFeature(token, feature, value) {
    if (!token.$source) {
      token.$source = {};
    }
    token.$source[feature] = value;
    return token;
  }
  var getDateHeader = (response) => protocolHttp.HttpResponse.isInstance(response) ? response.headers?.date ?? response.headers?.Date : undefined;
  var getSkewCorrectedDate = (systemClockOffset) => new Date(Date.now() + systemClockOffset);
  var isClockSkewed = (clockTime, systemClockOffset) => Math.abs(getSkewCorrectedDate(systemClockOffset).getTime() - clockTime) >= 300000;
  var getUpdatedSystemClockOffset = (clockTime, currentSystemClockOffset) => {
    const clockTimeInMs = Date.parse(clockTime);
    if (isClockSkewed(clockTimeInMs, currentSystemClockOffset)) {
      return clockTimeInMs - Date.now();
    }
    return currentSystemClockOffset;
  };
  var throwSigningPropertyError = (name, property) => {
    if (!property) {
      throw new Error(`Property \`${name}\` is not resolved for AWS SDK SigV4Auth`);
    }
    return property;
  };
  var validateSigningProperties = async (signingProperties) => {
    const context = throwSigningPropertyError("context", signingProperties.context);
    const config = throwSigningPropertyError("config", signingProperties.config);
    const authScheme = context.endpointV2?.properties?.authSchemes?.[0];
    const signerFunction = throwSigningPropertyError("signer", config.signer);
    const signer = await signerFunction(authScheme);
    const signingRegion = signingProperties?.signingRegion;
    const signingRegionSet = signingProperties?.signingRegionSet;
    const signingName = signingProperties?.signingName;
    return {
      config,
      signer,
      signingRegion,
      signingRegionSet,
      signingName
    };
  };

  class AwsSdkSigV4Signer {
    async sign(httpRequest, identity, signingProperties) {
      if (!protocolHttp.HttpRequest.isInstance(httpRequest)) {
        throw new Error("The request is not an instance of `HttpRequest` and cannot be signed");
      }
      const validatedProps = await validateSigningProperties(signingProperties);
      const { config, signer } = validatedProps;
      let { signingRegion, signingName } = validatedProps;
      const handlerExecutionContext = signingProperties.context;
      if (handlerExecutionContext?.authSchemes?.length ?? 0 > 1) {
        const [first, second] = handlerExecutionContext.authSchemes;
        if (first?.name === "sigv4a" && second?.name === "sigv4") {
          signingRegion = second?.signingRegion ?? signingRegion;
          signingName = second?.signingName ?? signingName;
        }
      }
      const signedRequest = await signer.sign(httpRequest, {
        signingDate: getSkewCorrectedDate(config.systemClockOffset),
        signingRegion,
        signingService: signingName
      });
      return signedRequest;
    }
    errorHandler(signingProperties) {
      return (error3) => {
        const serverTime = error3.ServerTime ?? getDateHeader(error3.$response);
        if (serverTime) {
          const config = throwSigningPropertyError("config", signingProperties.config);
          const initialSystemClockOffset = config.systemClockOffset;
          config.systemClockOffset = getUpdatedSystemClockOffset(serverTime, config.systemClockOffset);
          const clockSkewCorrected = config.systemClockOffset !== initialSystemClockOffset;
          if (clockSkewCorrected && error3.$metadata) {
            error3.$metadata.clockSkewCorrected = true;
          }
        }
        throw error3;
      };
    }
    successHandler(httpResponse, signingProperties) {
      const dateHeader = getDateHeader(httpResponse);
      if (dateHeader) {
        const config = throwSigningPropertyError("config", signingProperties.config);
        config.systemClockOffset = getUpdatedSystemClockOffset(dateHeader, config.systemClockOffset);
      }
    }
  }
  var AWSSDKSigV4Signer = AwsSdkSigV4Signer;

  class AwsSdkSigV4ASigner extends AwsSdkSigV4Signer {
    async sign(httpRequest, identity, signingProperties) {
      if (!protocolHttp.HttpRequest.isInstance(httpRequest)) {
        throw new Error("The request is not an instance of `HttpRequest` and cannot be signed");
      }
      const { config, signer, signingRegion, signingRegionSet, signingName } = await validateSigningProperties(signingProperties);
      const configResolvedSigningRegionSet = await config.sigv4aSigningRegionSet?.();
      const multiRegionOverride = (configResolvedSigningRegionSet ?? signingRegionSet ?? [signingRegion]).join(",");
      const signedRequest = await signer.sign(httpRequest, {
        signingDate: getSkewCorrectedDate(config.systemClockOffset),
        signingRegion: multiRegionOverride,
        signingService: signingName
      });
      return signedRequest;
    }
  }
  var getArrayForCommaSeparatedString = (str2) => typeof str2 === "string" && str2.length > 0 ? str2.split(",").map((item) => item.trim()) : [];
  var getBearerTokenEnvKey = (signingName) => `AWS_BEARER_TOKEN_${signingName.replace(/[\s-]/g, "_").toUpperCase()}`;
  var NODE_AUTH_SCHEME_PREFERENCE_ENV_KEY = "AWS_AUTH_SCHEME_PREFERENCE";
  var NODE_AUTH_SCHEME_PREFERENCE_CONFIG_KEY = "auth_scheme_preference";
  var NODE_AUTH_SCHEME_PREFERENCE_OPTIONS = {
    environmentVariableSelector: (env2, options) => {
      if (options?.signingName) {
        const bearerTokenKey = getBearerTokenEnvKey(options.signingName);
        if (bearerTokenKey in env2)
          return ["httpBearerAuth"];
      }
      if (!(NODE_AUTH_SCHEME_PREFERENCE_ENV_KEY in env2))
        return;
      return getArrayForCommaSeparatedString(env2[NODE_AUTH_SCHEME_PREFERENCE_ENV_KEY]);
    },
    configFileSelector: (profile) => {
      if (!(NODE_AUTH_SCHEME_PREFERENCE_CONFIG_KEY in profile))
        return;
      return getArrayForCommaSeparatedString(profile[NODE_AUTH_SCHEME_PREFERENCE_CONFIG_KEY]);
    },
    default: []
  };
  var resolveAwsSdkSigV4AConfig = (config) => {
    config.sigv4aSigningRegionSet = core.normalizeProvider(config.sigv4aSigningRegionSet);
    return config;
  };
  var NODE_SIGV4A_CONFIG_OPTIONS = {
    environmentVariableSelector(env2) {
      if (env2.AWS_SIGV4A_SIGNING_REGION_SET) {
        return env2.AWS_SIGV4A_SIGNING_REGION_SET.split(",").map((_) => _.trim());
      }
      throw new propertyProvider.ProviderError("AWS_SIGV4A_SIGNING_REGION_SET not set in env.", {
        tryNextLink: true
      });
    },
    configFileSelector(profile) {
      if (profile.sigv4a_signing_region_set) {
        return (profile.sigv4a_signing_region_set ?? "").split(",").map((_) => _.trim());
      }
      throw new propertyProvider.ProviderError("sigv4a_signing_region_set not set in profile.", {
        tryNextLink: true
      });
    },
    default: undefined
  };
  var resolveAwsSdkSigV4Config = (config) => {
    let inputCredentials = config.credentials;
    let isUserSupplied = !!config.credentials;
    let resolvedCredentials = undefined;
    Object.defineProperty(config, "credentials", {
      set(credentials) {
        if (credentials && credentials !== inputCredentials && credentials !== resolvedCredentials) {
          isUserSupplied = true;
        }
        inputCredentials = credentials;
        const memoizedProvider = normalizeCredentialProvider(config, {
          credentials: inputCredentials,
          credentialDefaultProvider: config.credentialDefaultProvider
        });
        const boundProvider = bindCallerConfig(config, memoizedProvider);
        if (isUserSupplied && !boundProvider.attributed) {
          const isCredentialObject = typeof inputCredentials === "object" && inputCredentials !== null;
          resolvedCredentials = async (options) => {
            const creds = await boundProvider(options);
            const attributedCreds = creds;
            if (isCredentialObject && (!attributedCreds.$source || Object.keys(attributedCreds.$source).length === 0)) {
              return client.setCredentialFeature(attributedCreds, "CREDENTIALS_CODE", "e");
            }
            return attributedCreds;
          };
          resolvedCredentials.memoized = boundProvider.memoized;
          resolvedCredentials.configBound = boundProvider.configBound;
          resolvedCredentials.attributed = true;
        } else {
          resolvedCredentials = boundProvider;
        }
      },
      get() {
        return resolvedCredentials;
      },
      enumerable: true,
      configurable: true
    });
    config.credentials = inputCredentials;
    const { signingEscapePath = true, systemClockOffset = config.systemClockOffset || 0, sha256 } = config;
    let signer;
    if (config.signer) {
      signer = core.normalizeProvider(config.signer);
    } else if (config.regionInfoProvider) {
      signer = () => core.normalizeProvider(config.region)().then(async (region) => [
        await config.regionInfoProvider(region, {
          useFipsEndpoint: await config.useFipsEndpoint(),
          useDualstackEndpoint: await config.useDualstackEndpoint()
        }) || {},
        region
      ]).then(([regionInfo, region]) => {
        const { signingRegion, signingService } = regionInfo;
        config.signingRegion = config.signingRegion || signingRegion || region;
        config.signingName = config.signingName || signingService || config.serviceId;
        const params = {
          ...config,
          credentials: config.credentials,
          region: config.signingRegion,
          service: config.signingName,
          sha256,
          uriEscapePath: signingEscapePath
        };
        const SignerCtor = config.signerConstructor || signatureV4.SignatureV4;
        return new SignerCtor(params);
      });
    } else {
      signer = async (authScheme) => {
        authScheme = Object.assign({}, {
          name: "sigv4",
          signingName: config.signingName || config.defaultSigningName,
          signingRegion: await core.normalizeProvider(config.region)(),
          properties: {}
        }, authScheme);
        const signingRegion = authScheme.signingRegion;
        const signingService = authScheme.signingName;
        config.signingRegion = config.signingRegion || signingRegion;
        config.signingName = config.signingName || signingService || config.serviceId;
        const params = {
          ...config,
          credentials: config.credentials,
          region: config.signingRegion,
          service: config.signingName,
          sha256,
          uriEscapePath: signingEscapePath
        };
        const SignerCtor = config.signerConstructor || signatureV4.SignatureV4;
        return new SignerCtor(params);
      };
    }
    const resolvedConfig = Object.assign(config, {
      systemClockOffset,
      signingEscapePath,
      signer
    });
    return resolvedConfig;
  };
  var resolveAWSSDKSigV4Config = resolveAwsSdkSigV4Config;
  function normalizeCredentialProvider(config, { credentials, credentialDefaultProvider }) {
    let credentialsProvider;
    if (credentials) {
      if (!credentials?.memoized) {
        credentialsProvider = core.memoizeIdentityProvider(credentials, core.isIdentityExpired, core.doesIdentityRequireRefresh);
      } else {
        credentialsProvider = credentials;
      }
    } else {
      if (credentialDefaultProvider) {
        credentialsProvider = core.normalizeProvider(credentialDefaultProvider(Object.assign({}, config, {
          parentClientConfig: config
        })));
      } else {
        credentialsProvider = async () => {
          throw new Error("@aws-sdk/core::resolveAwsSdkSigV4Config - `credentials` not provided and no credentialDefaultProvider was configured.");
        };
      }
    }
    credentialsProvider.memoized = true;
    return credentialsProvider;
  }
  function bindCallerConfig(config, credentialsProvider) {
    if (credentialsProvider.configBound) {
      return credentialsProvider;
    }
    const fn = async (options) => credentialsProvider({ ...options, callerClientConfig: config });
    fn.memoized = credentialsProvider.memoized;
    fn.configBound = true;
    return fn;
  }

  class ProtocolLib {
    queryCompat;
    constructor(queryCompat = false) {
      this.queryCompat = queryCompat;
    }
    resolveRestContentType(defaultContentType, inputSchema) {
      const members = inputSchema.getMemberSchemas();
      const httpPayloadMember = Object.values(members).find((m) => {
        return !!m.getMergedTraits().httpPayload;
      });
      if (httpPayloadMember) {
        const mediaType = httpPayloadMember.getMergedTraits().mediaType;
        if (mediaType) {
          return mediaType;
        } else if (httpPayloadMember.isStringSchema()) {
          return "text/plain";
        } else if (httpPayloadMember.isBlobSchema()) {
          return "application/octet-stream";
        } else {
          return defaultContentType;
        }
      } else if (!inputSchema.isUnitSchema()) {
        const hasBody = Object.values(members).find((m) => {
          const { httpQuery, httpQueryParams, httpHeader, httpLabel, httpPrefixHeaders } = m.getMergedTraits();
          const noPrefixHeaders = httpPrefixHeaders === undefined;
          return !httpQuery && !httpQueryParams && !httpHeader && !httpLabel && noPrefixHeaders;
        });
        if (hasBody) {
          return defaultContentType;
        }
      }
    }
    async getErrorSchemaOrThrowBaseException(errorIdentifier, defaultNamespace, response, dataObject, metadata, getErrorSchema) {
      let namespace = defaultNamespace;
      let errorName = errorIdentifier;
      if (errorIdentifier.includes("#")) {
        [namespace, errorName] = errorIdentifier.split("#");
      }
      const errorMetadata = {
        $metadata: metadata,
        $fault: response.statusCode < 500 ? "client" : "server"
      };
      const registry = schema.TypeRegistry.for(namespace);
      try {
        const errorSchema = getErrorSchema?.(registry, errorName) ?? registry.getSchema(errorIdentifier);
        return { errorSchema, errorMetadata };
      } catch (e) {
        dataObject.message = dataObject.message ?? dataObject.Message ?? "UnknownError";
        const synthetic = schema.TypeRegistry.for("smithy.ts.sdk.synthetic." + namespace);
        const baseExceptionSchema = synthetic.getBaseException();
        if (baseExceptionSchema) {
          const ErrorCtor = synthetic.getErrorCtor(baseExceptionSchema) ?? Error;
          throw this.decorateServiceException(Object.assign(new ErrorCtor({ name: errorName }), errorMetadata), dataObject);
        }
        throw this.decorateServiceException(Object.assign(new Error(errorName), errorMetadata), dataObject);
      }
    }
    decorateServiceException(exception, additions = {}) {
      if (this.queryCompat) {
        const msg = exception.Message ?? additions.Message;
        const error3 = smithyClient.decorateServiceException(exception, additions);
        if (msg) {
          error3.message = msg;
        }
        error3.Error = {
          ...error3.Error,
          Type: error3.Error.Type,
          Code: error3.Error.Code,
          Message: error3.Error.message ?? error3.Error.Message ?? msg
        };
        const reqId = error3.$metadata.requestId;
        if (reqId) {
          error3.RequestId = reqId;
        }
        return error3;
      }
      return smithyClient.decorateServiceException(exception, additions);
    }
    setQueryCompatError(output, response) {
      const queryErrorHeader = response.headers?.["x-amzn-query-error"];
      if (output !== undefined && queryErrorHeader != null) {
        const [Code, Type3] = queryErrorHeader.split(";");
        const entries = Object.entries(output);
        const Error2 = {
          Code,
          Type: Type3
        };
        Object.assign(output, Error2);
        for (const [k, v] of entries) {
          Error2[k === "message" ? "Message" : k] = v;
        }
        delete Error2.__type;
        output.Error = Error2;
      }
    }
    queryCompatOutput(queryCompatErrorData, errorData) {
      if (queryCompatErrorData.Error) {
        errorData.Error = queryCompatErrorData.Error;
      }
      if (queryCompatErrorData.Type) {
        errorData.Type = queryCompatErrorData.Type;
      }
      if (queryCompatErrorData.Code) {
        errorData.Code = queryCompatErrorData.Code;
      }
    }
    findQueryCompatibleError(registry, errorName) {
      try {
        return registry.getSchema(errorName);
      } catch (e) {
        return registry.find((schema$1) => schema.NormalizedSchema.of(schema$1).getMergedTraits().awsQueryError?.[0] === errorName);
      }
    }
  }

  class AwsSmithyRpcV2CborProtocol extends cbor.SmithyRpcV2CborProtocol {
    awsQueryCompatible;
    mixin;
    constructor({ defaultNamespace, awsQueryCompatible }) {
      super({ defaultNamespace });
      this.awsQueryCompatible = !!awsQueryCompatible;
      this.mixin = new ProtocolLib(this.awsQueryCompatible);
    }
    async serializeRequest(operationSchema, input, context) {
      const request = await super.serializeRequest(operationSchema, input, context);
      if (this.awsQueryCompatible) {
        request.headers["x-amzn-query-mode"] = "true";
      }
      return request;
    }
    async handleError(operationSchema, context, response, dataObject, metadata) {
      if (this.awsQueryCompatible) {
        this.mixin.setQueryCompatError(dataObject, response);
      }
      const errorName = (() => {
        const compatHeader = response.headers["x-amzn-query-error"];
        if (compatHeader && this.awsQueryCompatible) {
          return compatHeader.split(";")[0];
        }
        return cbor.loadSmithyRpcV2CborErrorCode(response, dataObject) ?? "Unknown";
      })();
      const { errorSchema, errorMetadata } = await this.mixin.getErrorSchemaOrThrowBaseException(errorName, this.options.defaultNamespace, response, dataObject, metadata, this.awsQueryCompatible ? this.mixin.findQueryCompatibleError : undefined);
      const ns = schema.NormalizedSchema.of(errorSchema);
      const message = dataObject.message ?? dataObject.Message ?? "Unknown";
      const ErrorCtor = schema.TypeRegistry.for(errorSchema[1]).getErrorCtor(errorSchema) ?? Error;
      const exception = new ErrorCtor(message);
      const output = {};
      for (const [name, member] of ns.structIterator()) {
        if (dataObject[name] != null) {
          output[name] = this.deserializer.readValue(member, dataObject[name]);
        }
      }
      if (this.awsQueryCompatible) {
        this.mixin.queryCompatOutput(dataObject, output);
      }
      throw this.mixin.decorateServiceException(Object.assign(exception, errorMetadata, {
        $fault: ns.getMergedTraits().error,
        message
      }, output), dataObject);
    }
  }
  var _toStr = (val) => {
    if (val == null) {
      return val;
    }
    if (typeof val === "number" || typeof val === "bigint") {
      const warning = new Error(`Received number ${val} where a string was expected.`);
      warning.name = "Warning";
      console.warn(warning);
      return String(val);
    }
    if (typeof val === "boolean") {
      const warning = new Error(`Received boolean ${val} where a string was expected.`);
      warning.name = "Warning";
      console.warn(warning);
      return String(val);
    }
    return val;
  };
  var _toBool = (val) => {
    if (val == null) {
      return val;
    }
    if (typeof val === "string") {
      const lowercase = val.toLowerCase();
      if (val !== "" && lowercase !== "false" && lowercase !== "true") {
        const warning = new Error(`Received string "${val}" where a boolean was expected.`);
        warning.name = "Warning";
        console.warn(warning);
      }
      return val !== "" && lowercase !== "false";
    }
    return val;
  };
  var _toNum = (val) => {
    if (val == null) {
      return val;
    }
    if (typeof val === "string") {
      const num = Number(val);
      if (num.toString() !== val) {
        const warning = new Error(`Received string "${val}" where a number was expected.`);
        warning.name = "Warning";
        console.warn(warning);
        return val;
      }
      return num;
    }
    return val;
  };

  class SerdeContextConfig {
    serdeContext;
    setSerdeContext(serdeContext) {
      this.serdeContext = serdeContext;
    }
  }

  class UnionSerde {
    from;
    to;
    keys;
    constructor(from, to) {
      this.from = from;
      this.to = to;
      this.keys = new Set(Object.keys(this.from).filter((k) => k !== "__type"));
    }
    mark(key) {
      this.keys.delete(key);
    }
    hasUnknown() {
      return this.keys.size === 1 && Object.keys(this.to).length === 0;
    }
    writeUnknown() {
      if (this.hasUnknown()) {
        const k = this.keys.values().next().value;
        const v = this.from[k];
        this.to.$unknown = [k, v];
      }
    }
  }
  function jsonReviver(key, value, context) {
    if (context?.source) {
      const numericString = context.source;
      if (typeof value === "number") {
        if (value > Number.MAX_SAFE_INTEGER || value < Number.MIN_SAFE_INTEGER || numericString !== String(value)) {
          const isFractional = numericString.includes(".");
          if (isFractional) {
            return new serde.NumericValue(numericString, "bigDecimal");
          } else {
            return BigInt(numericString);
          }
        }
      }
    }
    return value;
  }
  var collectBodyString = (streamBody, context) => smithyClient.collectBody(streamBody, context).then((body) => (context?.utf8Encoder ?? utilUtf8.toUtf8)(body));
  var parseJsonBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
      try {
        return JSON.parse(encoded);
      } catch (e) {
        if (e?.name === "SyntaxError") {
          Object.defineProperty(e, "$responseBodyText", {
            value: encoded
          });
        }
        throw e;
      }
    }
    return {};
  });
  var parseJsonErrorBody = async (errorBody, context) => {
    const value = await parseJsonBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
  };
  var loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
      let cleanValue = rawValue;
      if (typeof cleanValue === "number") {
        cleanValue = cleanValue.toString();
      }
      if (cleanValue.indexOf(",") >= 0) {
        cleanValue = cleanValue.split(",")[0];
      }
      if (cleanValue.indexOf(":") >= 0) {
        cleanValue = cleanValue.split(":")[0];
      }
      if (cleanValue.indexOf("#") >= 0) {
        cleanValue = cleanValue.split("#")[1];
      }
      return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
      return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data && typeof data === "object") {
      const codeKey = findKey(data, "code");
      if (codeKey && data[codeKey] !== undefined) {
        return sanitizeErrorCode(data[codeKey]);
      }
      if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
      }
    }
  };

  class JsonShapeDeserializer extends SerdeContextConfig {
    settings;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    async read(schema2, data) {
      return this._read(schema2, typeof data === "string" ? JSON.parse(data, jsonReviver) : await parseJsonBody(data, this.serdeContext));
    }
    readObject(schema2, data) {
      return this._read(schema2, data);
    }
    _read(schema$1, value) {
      const isObject = value !== null && typeof value === "object";
      const ns = schema.NormalizedSchema.of(schema$1);
      if (isObject) {
        if (ns.isStructSchema()) {
          const record = value;
          const union = ns.isUnionSchema();
          const out = {};
          let nameMap = undefined;
          const { jsonName } = this.settings;
          if (jsonName) {
            nameMap = {};
          }
          let unionSerde;
          if (union) {
            unionSerde = new UnionSerde(record, out);
          }
          for (const [memberName, memberSchema] of ns.structIterator()) {
            let fromKey = memberName;
            if (jsonName) {
              fromKey = memberSchema.getMergedTraits().jsonName ?? fromKey;
              nameMap[fromKey] = memberName;
            }
            if (union) {
              unionSerde.mark(fromKey);
            }
            if (record[fromKey] != null) {
              out[memberName] = this._read(memberSchema, record[fromKey]);
            }
          }
          if (union) {
            unionSerde.writeUnknown();
          } else if (typeof record.__type === "string") {
            for (const [k, v] of Object.entries(record)) {
              const t = jsonName ? nameMap[k] ?? k : k;
              if (!(t in out)) {
                out[t] = v;
              }
            }
          }
          return out;
        }
        if (Array.isArray(value) && ns.isListSchema()) {
          const listMember = ns.getValueSchema();
          const out = [];
          const sparse = !!ns.getMergedTraits().sparse;
          for (const item of value) {
            if (sparse || item != null) {
              out.push(this._read(listMember, item));
            }
          }
          return out;
        }
        if (ns.isMapSchema()) {
          const mapMember = ns.getValueSchema();
          const out = {};
          const sparse = !!ns.getMergedTraits().sparse;
          for (const [_k, _v] of Object.entries(value)) {
            if (sparse || _v != null) {
              out[_k] = this._read(mapMember, _v);
            }
          }
          return out;
        }
      }
      if (ns.isBlobSchema() && typeof value === "string") {
        return utilBase64.fromBase64(value);
      }
      const mediaType = ns.getMergedTraits().mediaType;
      if (ns.isStringSchema() && typeof value === "string" && mediaType) {
        const isJson = mediaType === "application/json" || mediaType.endsWith("+json");
        if (isJson) {
          return serde.LazyJsonString.from(value);
        }
        return value;
      }
      if (ns.isTimestampSchema() && value != null) {
        const format = protocols.determineTimestampFormat(ns, this.settings);
        switch (format) {
          case 5:
            return serde.parseRfc3339DateTimeWithOffset(value);
          case 6:
            return serde.parseRfc7231DateTime(value);
          case 7:
            return serde.parseEpochTimestamp(value);
          default:
            console.warn("Missing timestamp format, parsing value with Date constructor:", value);
            return new Date(value);
        }
      }
      if (ns.isBigIntegerSchema() && (typeof value === "number" || typeof value === "string")) {
        return BigInt(value);
      }
      if (ns.isBigDecimalSchema() && value != null) {
        if (value instanceof serde.NumericValue) {
          return value;
        }
        const untyped = value;
        if (untyped.type === "bigDecimal" && "string" in untyped) {
          return new serde.NumericValue(untyped.string, untyped.type);
        }
        return new serde.NumericValue(String(value), "bigDecimal");
      }
      if (ns.isNumericSchema() && typeof value === "string") {
        switch (value) {
          case "Infinity":
            return Infinity;
          case "-Infinity":
            return -Infinity;
          case "NaN":
            return NaN;
        }
        return value;
      }
      if (ns.isDocumentSchema()) {
        if (isObject) {
          const out = Array.isArray(value) ? [] : {};
          for (const [k, v] of Object.entries(value)) {
            if (v instanceof serde.NumericValue) {
              out[k] = v;
            } else {
              out[k] = this._read(ns, v);
            }
          }
          return out;
        } else {
          return structuredClone(value);
        }
      }
      return value;
    }
  }
  var NUMERIC_CONTROL_CHAR = String.fromCharCode(925);

  class JsonReplacer {
    values = new Map;
    counter = 0;
    stage = 0;
    createReplacer() {
      if (this.stage === 1) {
        throw new Error("@aws-sdk/core/protocols - JsonReplacer already created.");
      }
      if (this.stage === 2) {
        throw new Error("@aws-sdk/core/protocols - JsonReplacer exhausted.");
      }
      this.stage = 1;
      return (key, value) => {
        if (value instanceof serde.NumericValue) {
          const v = `${NUMERIC_CONTROL_CHAR + "nv" + this.counter++}_` + value.string;
          this.values.set(`"${v}"`, value.string);
          return v;
        }
        if (typeof value === "bigint") {
          const s = value.toString();
          const v = `${NUMERIC_CONTROL_CHAR + "b" + this.counter++}_` + s;
          this.values.set(`"${v}"`, s);
          return v;
        }
        return value;
      };
    }
    replaceInJson(json) {
      if (this.stage === 0) {
        throw new Error("@aws-sdk/core/protocols - JsonReplacer not created yet.");
      }
      if (this.stage === 2) {
        throw new Error("@aws-sdk/core/protocols - JsonReplacer exhausted.");
      }
      this.stage = 2;
      if (this.counter === 0) {
        return json;
      }
      for (const [key, value] of this.values) {
        json = json.replace(key, value);
      }
      return json;
    }
  }

  class JsonShapeSerializer extends SerdeContextConfig {
    settings;
    buffer;
    useReplacer = false;
    rootSchema;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    write(schema$1, value) {
      this.rootSchema = schema.NormalizedSchema.of(schema$1);
      this.buffer = this._write(this.rootSchema, value);
    }
    writeDiscriminatedDocument(schema$1, value) {
      this.write(schema$1, value);
      if (typeof this.buffer === "object") {
        this.buffer.__type = schema.NormalizedSchema.of(schema$1).getName(true);
      }
    }
    flush() {
      const { rootSchema, useReplacer } = this;
      this.rootSchema = undefined;
      this.useReplacer = false;
      if (rootSchema?.isStructSchema() || rootSchema?.isDocumentSchema()) {
        if (!useReplacer) {
          return JSON.stringify(this.buffer);
        }
        const replacer = new JsonReplacer;
        return replacer.replaceInJson(JSON.stringify(this.buffer, replacer.createReplacer(), 0));
      }
      return this.buffer;
    }
    _write(schema$1, value, container) {
      const isObject = value !== null && typeof value === "object";
      const ns = schema.NormalizedSchema.of(schema$1);
      if (isObject) {
        if (ns.isStructSchema()) {
          const record = value;
          const out = {};
          const { jsonName } = this.settings;
          let nameMap = undefined;
          if (jsonName) {
            nameMap = {};
          }
          for (const [memberName, memberSchema] of ns.structIterator()) {
            const serializableValue = this._write(memberSchema, record[memberName], ns);
            if (serializableValue !== undefined) {
              let targetKey = memberName;
              if (jsonName) {
                targetKey = memberSchema.getMergedTraits().jsonName ?? memberName;
                nameMap[memberName] = targetKey;
              }
              out[targetKey] = serializableValue;
            }
          }
          if (ns.isUnionSchema() && Object.keys(out).length === 0) {
            const { $unknown } = record;
            if (Array.isArray($unknown)) {
              const [k, v] = $unknown;
              out[k] = this._write(15, v);
            }
          } else if (typeof record.__type === "string") {
            for (const [k, v] of Object.entries(record)) {
              const targetKey = jsonName ? nameMap[k] ?? k : k;
              if (!(targetKey in out)) {
                out[targetKey] = this._write(15, v);
              }
            }
          }
          return out;
        }
        if (Array.isArray(value) && ns.isListSchema()) {
          const listMember = ns.getValueSchema();
          const out = [];
          const sparse = !!ns.getMergedTraits().sparse;
          for (const item of value) {
            if (sparse || item != null) {
              out.push(this._write(listMember, item));
            }
          }
          return out;
        }
        if (ns.isMapSchema()) {
          const mapMember = ns.getValueSchema();
          const out = {};
          const sparse = !!ns.getMergedTraits().sparse;
          for (const [_k, _v] of Object.entries(value)) {
            if (sparse || _v != null) {
              out[_k] = this._write(mapMember, _v);
            }
          }
          return out;
        }
        if (value instanceof Uint8Array && (ns.isBlobSchema() || ns.isDocumentSchema())) {
          if (ns === this.rootSchema) {
            return value;
          }
          return (this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(value);
        }
        if (value instanceof Date && (ns.isTimestampSchema() || ns.isDocumentSchema())) {
          const format = protocols.determineTimestampFormat(ns, this.settings);
          switch (format) {
            case 5:
              return value.toISOString().replace(".000Z", "Z");
            case 6:
              return serde.dateToUtcString(value);
            case 7:
              return value.getTime() / 1000;
            default:
              console.warn("Missing timestamp format, using epoch seconds", value);
              return value.getTime() / 1000;
          }
        }
        if (value instanceof serde.NumericValue) {
          this.useReplacer = true;
        }
      }
      if (value === null && container?.isStructSchema()) {
        return;
      }
      if (ns.isStringSchema()) {
        if (typeof value === "undefined" && ns.isIdempotencyToken()) {
          return serde.generateIdempotencyToken();
        }
        const mediaType = ns.getMergedTraits().mediaType;
        if (value != null && mediaType) {
          const isJson = mediaType === "application/json" || mediaType.endsWith("+json");
          if (isJson) {
            return serde.LazyJsonString.from(value);
          }
        }
        return value;
      }
      if (typeof value === "number" && ns.isNumericSchema()) {
        if (Math.abs(value) === Infinity || isNaN(value)) {
          return String(value);
        }
        return value;
      }
      if (typeof value === "string" && ns.isBlobSchema()) {
        if (ns === this.rootSchema) {
          return value;
        }
        return (this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(value);
      }
      if (typeof value === "bigint") {
        this.useReplacer = true;
      }
      if (ns.isDocumentSchema()) {
        if (isObject) {
          const out = Array.isArray(value) ? [] : {};
          for (const [k, v] of Object.entries(value)) {
            if (v instanceof serde.NumericValue) {
              this.useReplacer = true;
              out[k] = v;
            } else {
              out[k] = this._write(ns, v);
            }
          }
          return out;
        } else {
          return structuredClone(value);
        }
      }
      return value;
    }
  }

  class JsonCodec extends SerdeContextConfig {
    settings;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    createSerializer() {
      const serializer = new JsonShapeSerializer(this.settings);
      serializer.setSerdeContext(this.serdeContext);
      return serializer;
    }
    createDeserializer() {
      const deserializer = new JsonShapeDeserializer(this.settings);
      deserializer.setSerdeContext(this.serdeContext);
      return deserializer;
    }
  }

  class AwsJsonRpcProtocol extends protocols.RpcProtocol {
    serializer;
    deserializer;
    serviceTarget;
    codec;
    mixin;
    awsQueryCompatible;
    constructor({ defaultNamespace, serviceTarget, awsQueryCompatible, jsonCodec }) {
      super({
        defaultNamespace
      });
      this.serviceTarget = serviceTarget;
      this.codec = jsonCodec ?? new JsonCodec({
        timestampFormat: {
          useTrait: true,
          default: 7
        },
        jsonName: false
      });
      this.serializer = this.codec.createSerializer();
      this.deserializer = this.codec.createDeserializer();
      this.awsQueryCompatible = !!awsQueryCompatible;
      this.mixin = new ProtocolLib(this.awsQueryCompatible);
    }
    async serializeRequest(operationSchema, input, context) {
      const request = await super.serializeRequest(operationSchema, input, context);
      if (!request.path.endsWith("/")) {
        request.path += "/";
      }
      Object.assign(request.headers, {
        "content-type": `application/x-amz-json-${this.getJsonRpcVersion()}`,
        "x-amz-target": `${this.serviceTarget}.${operationSchema.name}`
      });
      if (this.awsQueryCompatible) {
        request.headers["x-amzn-query-mode"] = "true";
      }
      if (schema.deref(operationSchema.input) === "unit" || !request.body) {
        request.body = "{}";
      }
      return request;
    }
    getPayloadCodec() {
      return this.codec;
    }
    async handleError(operationSchema, context, response, dataObject, metadata) {
      if (this.awsQueryCompatible) {
        this.mixin.setQueryCompatError(dataObject, response);
      }
      const errorIdentifier = loadRestJsonErrorCode(response, dataObject) ?? "Unknown";
      const { errorSchema, errorMetadata } = await this.mixin.getErrorSchemaOrThrowBaseException(errorIdentifier, this.options.defaultNamespace, response, dataObject, metadata, this.awsQueryCompatible ? this.mixin.findQueryCompatibleError : undefined);
      const ns = schema.NormalizedSchema.of(errorSchema);
      const message = dataObject.message ?? dataObject.Message ?? "Unknown";
      const ErrorCtor = schema.TypeRegistry.for(errorSchema[1]).getErrorCtor(errorSchema) ?? Error;
      const exception = new ErrorCtor(message);
      const output = {};
      for (const [name, member] of ns.structIterator()) {
        if (dataObject[name] != null) {
          output[name] = this.codec.createDeserializer().readObject(member, dataObject[name]);
        }
      }
      if (this.awsQueryCompatible) {
        this.mixin.queryCompatOutput(dataObject, output);
      }
      throw this.mixin.decorateServiceException(Object.assign(exception, errorMetadata, {
        $fault: ns.getMergedTraits().error,
        message
      }, output), dataObject);
    }
  }

  class AwsJson1_0Protocol extends AwsJsonRpcProtocol {
    constructor({ defaultNamespace, serviceTarget, awsQueryCompatible, jsonCodec }) {
      super({
        defaultNamespace,
        serviceTarget,
        awsQueryCompatible,
        jsonCodec
      });
    }
    getShapeId() {
      return "aws.protocols#awsJson1_0";
    }
    getJsonRpcVersion() {
      return "1.0";
    }
    getDefaultContentType() {
      return "application/x-amz-json-1.0";
    }
  }

  class AwsJson1_1Protocol extends AwsJsonRpcProtocol {
    constructor({ defaultNamespace, serviceTarget, awsQueryCompatible, jsonCodec }) {
      super({
        defaultNamespace,
        serviceTarget,
        awsQueryCompatible,
        jsonCodec
      });
    }
    getShapeId() {
      return "aws.protocols#awsJson1_1";
    }
    getJsonRpcVersion() {
      return "1.1";
    }
    getDefaultContentType() {
      return "application/x-amz-json-1.1";
    }
  }

  class AwsRestJsonProtocol extends protocols.HttpBindingProtocol {
    serializer;
    deserializer;
    codec;
    mixin = new ProtocolLib;
    constructor({ defaultNamespace }) {
      super({
        defaultNamespace
      });
      const settings = {
        timestampFormat: {
          useTrait: true,
          default: 7
        },
        httpBindings: true,
        jsonName: true
      };
      this.codec = new JsonCodec(settings);
      this.serializer = new protocols.HttpInterceptingShapeSerializer(this.codec.createSerializer(), settings);
      this.deserializer = new protocols.HttpInterceptingShapeDeserializer(this.codec.createDeserializer(), settings);
    }
    getShapeId() {
      return "aws.protocols#restJson1";
    }
    getPayloadCodec() {
      return this.codec;
    }
    setSerdeContext(serdeContext) {
      this.codec.setSerdeContext(serdeContext);
      super.setSerdeContext(serdeContext);
    }
    async serializeRequest(operationSchema, input, context) {
      const request = await super.serializeRequest(operationSchema, input, context);
      const inputSchema = schema.NormalizedSchema.of(operationSchema.input);
      if (!request.headers["content-type"]) {
        const contentType = this.mixin.resolveRestContentType(this.getDefaultContentType(), inputSchema);
        if (contentType) {
          request.headers["content-type"] = contentType;
        }
      }
      if (request.body == null && request.headers["content-type"] === this.getDefaultContentType()) {
        request.body = "{}";
      }
      return request;
    }
    async deserializeResponse(operationSchema, context, response) {
      const output = await super.deserializeResponse(operationSchema, context, response);
      const outputSchema = schema.NormalizedSchema.of(operationSchema.output);
      for (const [name, member] of outputSchema.structIterator()) {
        if (member.getMemberTraits().httpPayload && !(name in output)) {
          output[name] = null;
        }
      }
      return output;
    }
    async handleError(operationSchema, context, response, dataObject, metadata) {
      const errorIdentifier = loadRestJsonErrorCode(response, dataObject) ?? "Unknown";
      const { errorSchema, errorMetadata } = await this.mixin.getErrorSchemaOrThrowBaseException(errorIdentifier, this.options.defaultNamespace, response, dataObject, metadata);
      const ns = schema.NormalizedSchema.of(errorSchema);
      const message = dataObject.message ?? dataObject.Message ?? "Unknown";
      const ErrorCtor = schema.TypeRegistry.for(errorSchema[1]).getErrorCtor(errorSchema) ?? Error;
      const exception = new ErrorCtor(message);
      await this.deserializeHttpMessage(errorSchema, context, response, dataObject);
      const output = {};
      for (const [name, member] of ns.structIterator()) {
        const target = member.getMergedTraits().jsonName ?? name;
        output[name] = this.codec.createDeserializer().readObject(member, dataObject[target]);
      }
      throw this.mixin.decorateServiceException(Object.assign(exception, errorMetadata, {
        $fault: ns.getMergedTraits().error,
        message
      }, output), dataObject);
    }
    getDefaultContentType() {
      return "application/json";
    }
  }
  var awsExpectUnion = (value) => {
    if (value == null) {
      return;
    }
    if (typeof value === "object" && "__type" in value) {
      delete value.__type;
    }
    return smithyClient.expectUnion(value);
  };

  class XmlShapeDeserializer extends SerdeContextConfig {
    settings;
    stringDeserializer;
    constructor(settings) {
      super();
      this.settings = settings;
      this.stringDeserializer = new protocols.FromStringShapeDeserializer(settings);
    }
    setSerdeContext(serdeContext) {
      this.serdeContext = serdeContext;
      this.stringDeserializer.setSerdeContext(serdeContext);
    }
    read(schema$1, bytes, key) {
      const ns = schema.NormalizedSchema.of(schema$1);
      const memberSchemas = ns.getMemberSchemas();
      const isEventPayload = ns.isStructSchema() && ns.isMemberSchema() && !!Object.values(memberSchemas).find((memberNs) => {
        return !!memberNs.getMemberTraits().eventPayload;
      });
      if (isEventPayload) {
        const output = {};
        const memberName = Object.keys(memberSchemas)[0];
        const eventMemberSchema = memberSchemas[memberName];
        if (eventMemberSchema.isBlobSchema()) {
          output[memberName] = bytes;
        } else {
          output[memberName] = this.read(memberSchemas[memberName], bytes);
        }
        return output;
      }
      const xmlString = (this.serdeContext?.utf8Encoder ?? utilUtf8.toUtf8)(bytes);
      const parsedObject = this.parseXml(xmlString);
      return this.readSchema(schema$1, key ? parsedObject[key] : parsedObject);
    }
    readSchema(_schema, value) {
      const ns = schema.NormalizedSchema.of(_schema);
      if (ns.isUnitSchema()) {
        return;
      }
      const traits = ns.getMergedTraits();
      if (ns.isListSchema() && !Array.isArray(value)) {
        return this.readSchema(ns, [value]);
      }
      if (value == null) {
        return value;
      }
      if (typeof value === "object") {
        const sparse = !!traits.sparse;
        const flat = !!traits.xmlFlattened;
        if (ns.isListSchema()) {
          const listValue = ns.getValueSchema();
          const buffer2 = [];
          const sourceKey = listValue.getMergedTraits().xmlName ?? "member";
          const source = flat ? value : (value[0] ?? value)[sourceKey];
          const sourceArray = Array.isArray(source) ? source : [source];
          for (const v of sourceArray) {
            if (v != null || sparse) {
              buffer2.push(this.readSchema(listValue, v));
            }
          }
          return buffer2;
        }
        const buffer = {};
        if (ns.isMapSchema()) {
          const keyNs = ns.getKeySchema();
          const memberNs = ns.getValueSchema();
          let entries;
          if (flat) {
            entries = Array.isArray(value) ? value : [value];
          } else {
            entries = Array.isArray(value.entry) ? value.entry : [value.entry];
          }
          const keyProperty = keyNs.getMergedTraits().xmlName ?? "key";
          const valueProperty = memberNs.getMergedTraits().xmlName ?? "value";
          for (const entry of entries) {
            const key = entry[keyProperty];
            const value2 = entry[valueProperty];
            if (value2 != null || sparse) {
              buffer[key] = this.readSchema(memberNs, value2);
            }
          }
          return buffer;
        }
        if (ns.isStructSchema()) {
          const union = ns.isUnionSchema();
          let unionSerde;
          if (union) {
            unionSerde = new UnionSerde(value, buffer);
          }
          for (const [memberName, memberSchema] of ns.structIterator()) {
            const memberTraits = memberSchema.getMergedTraits();
            const xmlObjectKey = !memberTraits.httpPayload ? memberSchema.getMemberTraits().xmlName ?? memberName : memberTraits.xmlName ?? memberSchema.getName();
            if (union) {
              unionSerde.mark(xmlObjectKey);
            }
            if (value[xmlObjectKey] != null) {
              buffer[memberName] = this.readSchema(memberSchema, value[xmlObjectKey]);
            }
          }
          if (union) {
            unionSerde.writeUnknown();
          }
          return buffer;
        }
        if (ns.isDocumentSchema()) {
          return value;
        }
        throw new Error(`@aws-sdk/core/protocols - xml deserializer unhandled schema type for ${ns.getName(true)}`);
      }
      if (ns.isListSchema()) {
        return [];
      }
      if (ns.isMapSchema() || ns.isStructSchema()) {
        return {};
      }
      return this.stringDeserializer.read(ns, value);
    }
    parseXml(xml) {
      if (xml.length) {
        let parsedObj;
        try {
          parsedObj = xmlBuilder.parseXML(xml);
        } catch (e) {
          if (e && typeof e === "object") {
            Object.defineProperty(e, "$responseBodyText", {
              value: xml
            });
          }
          throw e;
        }
        const textNodeName = "#text";
        const key = Object.keys(parsedObj)[0];
        const parsedObjToReturn = parsedObj[key];
        if (parsedObjToReturn[textNodeName]) {
          parsedObjToReturn[key] = parsedObjToReturn[textNodeName];
          delete parsedObjToReturn[textNodeName];
        }
        return smithyClient.getValueFromTextNode(parsedObjToReturn);
      }
      return {};
    }
  }

  class QueryShapeSerializer extends SerdeContextConfig {
    settings;
    buffer;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    write(schema$1, value, prefix = "") {
      if (this.buffer === undefined) {
        this.buffer = "";
      }
      const ns = schema.NormalizedSchema.of(schema$1);
      if (prefix && !prefix.endsWith(".")) {
        prefix += ".";
      }
      if (ns.isBlobSchema()) {
        if (typeof value === "string" || value instanceof Uint8Array) {
          this.writeKey(prefix);
          this.writeValue((this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(value));
        }
      } else if (ns.isBooleanSchema() || ns.isNumericSchema() || ns.isStringSchema()) {
        if (value != null) {
          this.writeKey(prefix);
          this.writeValue(String(value));
        } else if (ns.isIdempotencyToken()) {
          this.writeKey(prefix);
          this.writeValue(serde.generateIdempotencyToken());
        }
      } else if (ns.isBigIntegerSchema()) {
        if (value != null) {
          this.writeKey(prefix);
          this.writeValue(String(value));
        }
      } else if (ns.isBigDecimalSchema()) {
        if (value != null) {
          this.writeKey(prefix);
          this.writeValue(value instanceof serde.NumericValue ? value.string : String(value));
        }
      } else if (ns.isTimestampSchema()) {
        if (value instanceof Date) {
          this.writeKey(prefix);
          const format = protocols.determineTimestampFormat(ns, this.settings);
          switch (format) {
            case 5:
              this.writeValue(value.toISOString().replace(".000Z", "Z"));
              break;
            case 6:
              this.writeValue(smithyClient.dateToUtcString(value));
              break;
            case 7:
              this.writeValue(String(value.getTime() / 1000));
              break;
          }
        }
      } else if (ns.isDocumentSchema()) {
        if (Array.isArray(value)) {
          this.write(64 | 15, value, prefix);
        } else if (value instanceof Date) {
          this.write(4, value, prefix);
        } else if (value instanceof Uint8Array) {
          this.write(21, value, prefix);
        } else if (value && typeof value === "object") {
          this.write(128 | 15, value, prefix);
        } else {
          this.writeKey(prefix);
          this.writeValue(String(value));
        }
      } else if (ns.isListSchema()) {
        if (Array.isArray(value)) {
          if (value.length === 0) {
            if (this.settings.serializeEmptyLists) {
              this.writeKey(prefix);
              this.writeValue("");
            }
          } else {
            const member = ns.getValueSchema();
            const flat = this.settings.flattenLists || ns.getMergedTraits().xmlFlattened;
            let i = 1;
            for (const item of value) {
              if (item == null) {
                continue;
              }
              const traits = member.getMergedTraits();
              const suffix2 = this.getKey("member", traits.xmlName, traits.ec2QueryName);
              const key = flat ? `${prefix}${i}` : `${prefix}${suffix2}.${i}`;
              this.write(member, item, key);
              ++i;
            }
          }
        }
      } else if (ns.isMapSchema()) {
        if (value && typeof value === "object") {
          const keySchema = ns.getKeySchema();
          const memberSchema = ns.getValueSchema();
          const flat = ns.getMergedTraits().xmlFlattened;
          let i = 1;
          for (const [k, v] of Object.entries(value)) {
            if (v == null) {
              continue;
            }
            const keyTraits = keySchema.getMergedTraits();
            const keySuffix = this.getKey("key", keyTraits.xmlName, keyTraits.ec2QueryName);
            const key = flat ? `${prefix}${i}.${keySuffix}` : `${prefix}entry.${i}.${keySuffix}`;
            const valTraits = memberSchema.getMergedTraits();
            const valueSuffix = this.getKey("value", valTraits.xmlName, valTraits.ec2QueryName);
            const valueKey = flat ? `${prefix}${i}.${valueSuffix}` : `${prefix}entry.${i}.${valueSuffix}`;
            this.write(keySchema, k, key);
            this.write(memberSchema, v, valueKey);
            ++i;
          }
        }
      } else if (ns.isStructSchema()) {
        if (value && typeof value === "object") {
          let didWriteMember = false;
          for (const [memberName, member] of ns.structIterator()) {
            if (value[memberName] == null && !member.isIdempotencyToken()) {
              continue;
            }
            const traits = member.getMergedTraits();
            const suffix2 = this.getKey(memberName, traits.xmlName, traits.ec2QueryName, "struct");
            const key = `${prefix}${suffix2}`;
            this.write(member, value[memberName], key);
            didWriteMember = true;
          }
          if (!didWriteMember && ns.isUnionSchema()) {
            const { $unknown } = value;
            if (Array.isArray($unknown)) {
              const [k, v] = $unknown;
              const key = `${prefix}${k}`;
              this.write(15, v, key);
            }
          }
        }
      } else if (ns.isUnitSchema())
        ;
      else {
        throw new Error(`@aws-sdk/core/protocols - QuerySerializer unrecognized schema type ${ns.getName(true)}`);
      }
    }
    flush() {
      if (this.buffer === undefined) {
        throw new Error("@aws-sdk/core/protocols - QuerySerializer cannot flush with nothing written to buffer.");
      }
      const str2 = this.buffer;
      delete this.buffer;
      return str2;
    }
    getKey(memberName, xmlName, ec2QueryName, keySource) {
      const { ec2, capitalizeKeys } = this.settings;
      if (ec2 && ec2QueryName) {
        return ec2QueryName;
      }
      const key = xmlName ?? memberName;
      if (capitalizeKeys && keySource === "struct") {
        return key[0].toUpperCase() + key.slice(1);
      }
      return key;
    }
    writeKey(key) {
      if (key.endsWith(".")) {
        key = key.slice(0, key.length - 1);
      }
      this.buffer += `&${protocols.extendedEncodeURIComponent(key)}=`;
    }
    writeValue(value) {
      this.buffer += protocols.extendedEncodeURIComponent(value);
    }
  }

  class AwsQueryProtocol extends protocols.RpcProtocol {
    options;
    serializer;
    deserializer;
    mixin = new ProtocolLib;
    constructor(options) {
      super({
        defaultNamespace: options.defaultNamespace
      });
      this.options = options;
      const settings = {
        timestampFormat: {
          useTrait: true,
          default: 5
        },
        httpBindings: false,
        xmlNamespace: options.xmlNamespace,
        serviceNamespace: options.defaultNamespace,
        serializeEmptyLists: true
      };
      this.serializer = new QueryShapeSerializer(settings);
      this.deserializer = new XmlShapeDeserializer(settings);
    }
    getShapeId() {
      return "aws.protocols#awsQuery";
    }
    setSerdeContext(serdeContext) {
      this.serializer.setSerdeContext(serdeContext);
      this.deserializer.setSerdeContext(serdeContext);
    }
    getPayloadCodec() {
      throw new Error("AWSQuery protocol has no payload codec.");
    }
    async serializeRequest(operationSchema, input, context) {
      const request = await super.serializeRequest(operationSchema, input, context);
      if (!request.path.endsWith("/")) {
        request.path += "/";
      }
      Object.assign(request.headers, {
        "content-type": `application/x-www-form-urlencoded`
      });
      if (schema.deref(operationSchema.input) === "unit" || !request.body) {
        request.body = "";
      }
      const action = operationSchema.name.split("#")[1] ?? operationSchema.name;
      request.body = `Action=${action}&Version=${this.options.version}` + request.body;
      if (request.body.endsWith("&")) {
        request.body = request.body.slice(-1);
      }
      return request;
    }
    async deserializeResponse(operationSchema, context, response) {
      const deserializer = this.deserializer;
      const ns = schema.NormalizedSchema.of(operationSchema.output);
      const dataObject = {};
      if (response.statusCode >= 300) {
        const bytes2 = await protocols.collectBody(response.body, context);
        if (bytes2.byteLength > 0) {
          Object.assign(dataObject, await deserializer.read(15, bytes2));
        }
        await this.handleError(operationSchema, context, response, dataObject, this.deserializeMetadata(response));
      }
      for (const header in response.headers) {
        const value = response.headers[header];
        delete response.headers[header];
        response.headers[header.toLowerCase()] = value;
      }
      const shortName = operationSchema.name.split("#")[1] ?? operationSchema.name;
      const awsQueryResultKey = ns.isStructSchema() && this.useNestedResult() ? shortName + "Result" : undefined;
      const bytes = await protocols.collectBody(response.body, context);
      if (bytes.byteLength > 0) {
        Object.assign(dataObject, await deserializer.read(ns, bytes, awsQueryResultKey));
      }
      const output = {
        $metadata: this.deserializeMetadata(response),
        ...dataObject
      };
      return output;
    }
    useNestedResult() {
      return true;
    }
    async handleError(operationSchema, context, response, dataObject, metadata) {
      const errorIdentifier = this.loadQueryErrorCode(response, dataObject) ?? "Unknown";
      const errorData = this.loadQueryError(dataObject);
      const message = this.loadQueryErrorMessage(dataObject);
      errorData.message = message;
      errorData.Error = {
        Type: errorData.Type,
        Code: errorData.Code,
        Message: message
      };
      const { errorSchema, errorMetadata } = await this.mixin.getErrorSchemaOrThrowBaseException(errorIdentifier, this.options.defaultNamespace, response, errorData, metadata, this.mixin.findQueryCompatibleError);
      const ns = schema.NormalizedSchema.of(errorSchema);
      const ErrorCtor = schema.TypeRegistry.for(errorSchema[1]).getErrorCtor(errorSchema) ?? Error;
      const exception = new ErrorCtor(message);
      const output = {
        Type: errorData.Error.Type,
        Code: errorData.Error.Code,
        Error: errorData.Error
      };
      for (const [name, member] of ns.structIterator()) {
        const target = member.getMergedTraits().xmlName ?? name;
        const value = errorData[target] ?? dataObject[target];
        output[name] = this.deserializer.readSchema(member, value);
      }
      throw this.mixin.decorateServiceException(Object.assign(exception, errorMetadata, {
        $fault: ns.getMergedTraits().error,
        message
      }, output), dataObject);
    }
    loadQueryErrorCode(output, data) {
      const code = (data.Errors?.[0]?.Error ?? data.Errors?.Error ?? data.Error)?.Code;
      if (code !== undefined) {
        return code;
      }
      if (output.statusCode == 404) {
        return "NotFound";
      }
    }
    loadQueryError(data) {
      return data.Errors?.[0]?.Error ?? data.Errors?.Error ?? data.Error;
    }
    loadQueryErrorMessage(data) {
      const errorData = this.loadQueryError(data);
      return errorData?.message ?? errorData?.Message ?? data.message ?? data.Message ?? "Unknown";
    }
    getDefaultContentType() {
      return "application/x-www-form-urlencoded";
    }
  }

  class AwsEc2QueryProtocol extends AwsQueryProtocol {
    options;
    constructor(options) {
      super(options);
      this.options = options;
      const ec2Settings = {
        capitalizeKeys: true,
        flattenLists: true,
        serializeEmptyLists: false,
        ec2: true
      };
      Object.assign(this.serializer.settings, ec2Settings);
    }
    useNestedResult() {
      return false;
    }
  }
  var parseXmlBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
      let parsedObj;
      try {
        parsedObj = xmlBuilder.parseXML(encoded);
      } catch (e) {
        if (e && typeof e === "object") {
          Object.defineProperty(e, "$responseBodyText", {
            value: encoded
          });
        }
        throw e;
      }
      const textNodeName = "#text";
      const key = Object.keys(parsedObj)[0];
      const parsedObjToReturn = parsedObj[key];
      if (parsedObjToReturn[textNodeName]) {
        parsedObjToReturn[key] = parsedObjToReturn[textNodeName];
        delete parsedObjToReturn[textNodeName];
      }
      return smithyClient.getValueFromTextNode(parsedObjToReturn);
    }
    return {};
  });
  var parseXmlErrorBody = async (errorBody, context) => {
    const value = await parseXmlBody(errorBody, context);
    if (value.Error) {
      value.Error.message = value.Error.message ?? value.Error.Message;
    }
    return value;
  };
  var loadRestXmlErrorCode = (output, data) => {
    if (data?.Error?.Code !== undefined) {
      return data.Error.Code;
    }
    if (data?.Code !== undefined) {
      return data.Code;
    }
    if (output.statusCode == 404) {
      return "NotFound";
    }
  };

  class XmlShapeSerializer extends SerdeContextConfig {
    settings;
    stringBuffer;
    byteBuffer;
    buffer;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    write(schema$1, value) {
      const ns = schema.NormalizedSchema.of(schema$1);
      if (ns.isStringSchema() && typeof value === "string") {
        this.stringBuffer = value;
      } else if (ns.isBlobSchema()) {
        this.byteBuffer = "byteLength" in value ? value : (this.serdeContext?.base64Decoder ?? utilBase64.fromBase64)(value);
      } else {
        this.buffer = this.writeStruct(ns, value, undefined);
        const traits = ns.getMergedTraits();
        if (traits.httpPayload && !traits.xmlName) {
          this.buffer.withName(ns.getName());
        }
      }
    }
    flush() {
      if (this.byteBuffer !== undefined) {
        const bytes = this.byteBuffer;
        delete this.byteBuffer;
        return bytes;
      }
      if (this.stringBuffer !== undefined) {
        const str2 = this.stringBuffer;
        delete this.stringBuffer;
        return str2;
      }
      const buffer = this.buffer;
      if (this.settings.xmlNamespace) {
        if (!buffer?.attributes?.["xmlns"]) {
          buffer.addAttribute("xmlns", this.settings.xmlNamespace);
        }
      }
      delete this.buffer;
      return buffer.toString();
    }
    writeStruct(ns, value, parentXmlns) {
      const traits = ns.getMergedTraits();
      const name = ns.isMemberSchema() && !traits.httpPayload ? ns.getMemberTraits().xmlName ?? ns.getMemberName() : traits.xmlName ?? ns.getName();
      if (!name || !ns.isStructSchema()) {
        throw new Error(`@aws-sdk/core/protocols - xml serializer, cannot write struct with empty name or non-struct, schema=${ns.getName(true)}.`);
      }
      const structXmlNode = xmlBuilder.XmlNode.of(name);
      const [xmlnsAttr, xmlns] = this.getXmlnsAttribute(ns, parentXmlns);
      for (const [memberName, memberSchema] of ns.structIterator()) {
        const val = value[memberName];
        if (val != null || memberSchema.isIdempotencyToken()) {
          if (memberSchema.getMergedTraits().xmlAttribute) {
            structXmlNode.addAttribute(memberSchema.getMergedTraits().xmlName ?? memberName, this.writeSimple(memberSchema, val));
            continue;
          }
          if (memberSchema.isListSchema()) {
            this.writeList(memberSchema, val, structXmlNode, xmlns);
          } else if (memberSchema.isMapSchema()) {
            this.writeMap(memberSchema, val, structXmlNode, xmlns);
          } else if (memberSchema.isStructSchema()) {
            structXmlNode.addChildNode(this.writeStruct(memberSchema, val, xmlns));
          } else {
            const memberNode = xmlBuilder.XmlNode.of(memberSchema.getMergedTraits().xmlName ?? memberSchema.getMemberName());
            this.writeSimpleInto(memberSchema, val, memberNode, xmlns);
            structXmlNode.addChildNode(memberNode);
          }
        }
      }
      const { $unknown } = value;
      if ($unknown && ns.isUnionSchema() && Array.isArray($unknown) && Object.keys(value).length === 1) {
        const [k, v] = $unknown;
        const node = xmlBuilder.XmlNode.of(k);
        if (typeof v !== "string") {
          if (value instanceof xmlBuilder.XmlNode || value instanceof xmlBuilder.XmlText) {
            structXmlNode.addChildNode(value);
          } else {
            throw new Error(`@aws-sdk - $unknown union member in XML requires ` + `value of type string, @aws-sdk/xml-builder::XmlNode or XmlText.`);
          }
        }
        this.writeSimpleInto(0, v, node, xmlns);
        structXmlNode.addChildNode(node);
      }
      if (xmlns) {
        structXmlNode.addAttribute(xmlnsAttr, xmlns);
      }
      return structXmlNode;
    }
    writeList(listMember, array, container, parentXmlns) {
      if (!listMember.isMemberSchema()) {
        throw new Error(`@aws-sdk/core/protocols - xml serializer, cannot write non-member list: ${listMember.getName(true)}`);
      }
      const listTraits = listMember.getMergedTraits();
      const listValueSchema = listMember.getValueSchema();
      const listValueTraits = listValueSchema.getMergedTraits();
      const sparse = !!listValueTraits.sparse;
      const flat = !!listTraits.xmlFlattened;
      const [xmlnsAttr, xmlns] = this.getXmlnsAttribute(listMember, parentXmlns);
      const writeItem = (container2, value) => {
        if (listValueSchema.isListSchema()) {
          this.writeList(listValueSchema, Array.isArray(value) ? value : [value], container2, xmlns);
        } else if (listValueSchema.isMapSchema()) {
          this.writeMap(listValueSchema, value, container2, xmlns);
        } else if (listValueSchema.isStructSchema()) {
          const struct = this.writeStruct(listValueSchema, value, xmlns);
          container2.addChildNode(struct.withName(flat ? listTraits.xmlName ?? listMember.getMemberName() : listValueTraits.xmlName ?? "member"));
        } else {
          const listItemNode = xmlBuilder.XmlNode.of(flat ? listTraits.xmlName ?? listMember.getMemberName() : listValueTraits.xmlName ?? "member");
          this.writeSimpleInto(listValueSchema, value, listItemNode, xmlns);
          container2.addChildNode(listItemNode);
        }
      };
      if (flat) {
        for (const value of array) {
          if (sparse || value != null) {
            writeItem(container, value);
          }
        }
      } else {
        const listNode = xmlBuilder.XmlNode.of(listTraits.xmlName ?? listMember.getMemberName());
        if (xmlns) {
          listNode.addAttribute(xmlnsAttr, xmlns);
        }
        for (const value of array) {
          if (sparse || value != null) {
            writeItem(listNode, value);
          }
        }
        container.addChildNode(listNode);
      }
    }
    writeMap(mapMember, map, container, parentXmlns, containerIsMap = false) {
      if (!mapMember.isMemberSchema()) {
        throw new Error(`@aws-sdk/core/protocols - xml serializer, cannot write non-member map: ${mapMember.getName(true)}`);
      }
      const mapTraits = mapMember.getMergedTraits();
      const mapKeySchema = mapMember.getKeySchema();
      const mapKeyTraits = mapKeySchema.getMergedTraits();
      const keyTag = mapKeyTraits.xmlName ?? "key";
      const mapValueSchema = mapMember.getValueSchema();
      const mapValueTraits = mapValueSchema.getMergedTraits();
      const valueTag = mapValueTraits.xmlName ?? "value";
      const sparse = !!mapValueTraits.sparse;
      const flat = !!mapTraits.xmlFlattened;
      const [xmlnsAttr, xmlns] = this.getXmlnsAttribute(mapMember, parentXmlns);
      const addKeyValue = (entry, key, val) => {
        const keyNode = xmlBuilder.XmlNode.of(keyTag, key);
        const [keyXmlnsAttr, keyXmlns] = this.getXmlnsAttribute(mapKeySchema, xmlns);
        if (keyXmlns) {
          keyNode.addAttribute(keyXmlnsAttr, keyXmlns);
        }
        entry.addChildNode(keyNode);
        let valueNode = xmlBuilder.XmlNode.of(valueTag);
        if (mapValueSchema.isListSchema()) {
          this.writeList(mapValueSchema, val, valueNode, xmlns);
        } else if (mapValueSchema.isMapSchema()) {
          this.writeMap(mapValueSchema, val, valueNode, xmlns, true);
        } else if (mapValueSchema.isStructSchema()) {
          valueNode = this.writeStruct(mapValueSchema, val, xmlns);
        } else {
          this.writeSimpleInto(mapValueSchema, val, valueNode, xmlns);
        }
        entry.addChildNode(valueNode);
      };
      if (flat) {
        for (const [key, val] of Object.entries(map)) {
          if (sparse || val != null) {
            const entry = xmlBuilder.XmlNode.of(mapTraits.xmlName ?? mapMember.getMemberName());
            addKeyValue(entry, key, val);
            container.addChildNode(entry);
          }
        }
      } else {
        let mapNode;
        if (!containerIsMap) {
          mapNode = xmlBuilder.XmlNode.of(mapTraits.xmlName ?? mapMember.getMemberName());
          if (xmlns) {
            mapNode.addAttribute(xmlnsAttr, xmlns);
          }
          container.addChildNode(mapNode);
        }
        for (const [key, val] of Object.entries(map)) {
          if (sparse || val != null) {
            const entry = xmlBuilder.XmlNode.of("entry");
            addKeyValue(entry, key, val);
            (containerIsMap ? container : mapNode).addChildNode(entry);
          }
        }
      }
    }
    writeSimple(_schema, value) {
      if (value === null) {
        throw new Error("@aws-sdk/core/protocols - (XML serializer) cannot write null value.");
      }
      const ns = schema.NormalizedSchema.of(_schema);
      let nodeContents = null;
      if (value && typeof value === "object") {
        if (ns.isBlobSchema()) {
          nodeContents = (this.serdeContext?.base64Encoder ?? utilBase64.toBase64)(value);
        } else if (ns.isTimestampSchema() && value instanceof Date) {
          const format = protocols.determineTimestampFormat(ns, this.settings);
          switch (format) {
            case 5:
              nodeContents = value.toISOString().replace(".000Z", "Z");
              break;
            case 6:
              nodeContents = smithyClient.dateToUtcString(value);
              break;
            case 7:
              nodeContents = String(value.getTime() / 1000);
              break;
            default:
              console.warn("Missing timestamp format, using http date", value);
              nodeContents = smithyClient.dateToUtcString(value);
              break;
          }
        } else if (ns.isBigDecimalSchema() && value) {
          if (value instanceof serde.NumericValue) {
            return value.string;
          }
          return String(value);
        } else if (ns.isMapSchema() || ns.isListSchema()) {
          throw new Error("@aws-sdk/core/protocols - xml serializer, cannot call _write() on List/Map schema, call writeList or writeMap() instead.");
        } else {
          throw new Error(`@aws-sdk/core/protocols - xml serializer, unhandled schema type for object value and schema: ${ns.getName(true)}`);
        }
      }
      if (ns.isBooleanSchema() || ns.isNumericSchema() || ns.isBigIntegerSchema() || ns.isBigDecimalSchema()) {
        nodeContents = String(value);
      }
      if (ns.isStringSchema()) {
        if (value === undefined && ns.isIdempotencyToken()) {
          nodeContents = serde.generateIdempotencyToken();
        } else {
          nodeContents = String(value);
        }
      }
      if (nodeContents === null) {
        throw new Error(`Unhandled schema-value pair ${ns.getName(true)}=${value}`);
      }
      return nodeContents;
    }
    writeSimpleInto(_schema, value, into, parentXmlns) {
      const nodeContents = this.writeSimple(_schema, value);
      const ns = schema.NormalizedSchema.of(_schema);
      const content = new xmlBuilder.XmlText(nodeContents);
      const [xmlnsAttr, xmlns] = this.getXmlnsAttribute(ns, parentXmlns);
      if (xmlns) {
        into.addAttribute(xmlnsAttr, xmlns);
      }
      into.addChildNode(content);
    }
    getXmlnsAttribute(ns, parentXmlns) {
      const traits = ns.getMergedTraits();
      const [prefix, xmlns] = traits.xmlNamespace ?? [];
      if (xmlns && xmlns !== parentXmlns) {
        return [prefix ? `xmlns:${prefix}` : "xmlns", xmlns];
      }
      return [undefined, undefined];
    }
  }

  class XmlCodec extends SerdeContextConfig {
    settings;
    constructor(settings) {
      super();
      this.settings = settings;
    }
    createSerializer() {
      const serializer = new XmlShapeSerializer(this.settings);
      serializer.setSerdeContext(this.serdeContext);
      return serializer;
    }
    createDeserializer() {
      const deserializer = new XmlShapeDeserializer(this.settings);
      deserializer.setSerdeContext(this.serdeContext);
      return deserializer;
    }
  }

  class AwsRestXmlProtocol extends protocols.HttpBindingProtocol {
    codec;
    serializer;
    deserializer;
    mixin = new ProtocolLib;
    constructor(options) {
      super(options);
      const settings = 